# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RegistryEnterpriseNamespaceArgs', 'RegistryEnterpriseNamespace']

@pulumi.input_type
class RegistryEnterpriseNamespaceArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 auto_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RegistryEnterpriseNamespace resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Container Registry Enterprise Edition instance.
        :param pulumi.Input[_builtins.bool] auto_create: Specifies whether to automatically create an image repository in the namespace. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] default_visibility: The default type of the repository that is automatically created. Valid values:
               - `PUBLIC`: A public repository.
               - `PRIVATE`: A private repository.
        :param pulumi.Input[_builtins.str] name: The name of the Container Registry Enterprise Edition Name. It must be `2` to `120` characters in length, and can contain lowercase letters, digits, underscores (_), hyphens (-), and periods (.). It cannot start or end with a delimiter.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if auto_create is not None:
            pulumi.set(__self__, "auto_create", auto_create)
        if default_visibility is not None:
            pulumi.set(__self__, "default_visibility", default_visibility)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="autoCreate")
    def auto_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to automatically create an image repository in the namespace. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_create")

    @auto_create.setter
    def auto_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_create", value)

    @_builtins.property
    @pulumi.getter(name="defaultVisibility")
    def default_visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default type of the repository that is automatically created. Valid values:
        - `PUBLIC`: A public repository.
        - `PRIVATE`: A private repository.
        """
        return pulumi.get(self, "default_visibility")

    @default_visibility.setter
    def default_visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_visibility", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Container Registry Enterprise Edition Name. It must be `2` to `120` characters in length, and can contain lowercase letters, digits, underscores (_), hyphens (-), and periods (.). It cannot start or end with a delimiter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RegistryEnterpriseNamespaceState:
    def __init__(__self__, *,
                 auto_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegistryEnterpriseNamespace resources.
        :param pulumi.Input[_builtins.bool] auto_create: Specifies whether to automatically create an image repository in the namespace. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] default_visibility: The default type of the repository that is automatically created. Valid values:
               - `PUBLIC`: A public repository.
               - `PRIVATE`: A private repository.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Container Registry Enterprise Edition instance.
        :param pulumi.Input[_builtins.str] name: The name of the Container Registry Enterprise Edition Name. It must be `2` to `120` characters in length, and can contain lowercase letters, digits, underscores (_), hyphens (-), and periods (.). It cannot start or end with a delimiter.
        """
        if auto_create is not None:
            pulumi.set(__self__, "auto_create", auto_create)
        if default_visibility is not None:
            pulumi.set(__self__, "default_visibility", default_visibility)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="autoCreate")
    def auto_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to automatically create an image repository in the namespace. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_create")

    @auto_create.setter
    def auto_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_create", value)

    @_builtins.property
    @pulumi.getter(name="defaultVisibility")
    def default_visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default type of the repository that is automatically created. Valid values:
        - `PUBLIC`: A public repository.
        - `PRIVATE`: A private repository.
        """
        return pulumi.get(self, "default_visibility")

    @default_visibility.setter
    def default_visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_visibility", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Container Registry Enterprise Edition Name. It must be `2` to `120` characters in length, and can contain lowercase letters, digits, underscores (_), hyphens (-), and periods (.). It cannot start or end with a delimiter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("alicloud:cs/registryEnterpriseNamespace:RegistryEnterpriseNamespace")
class RegistryEnterpriseNamespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Container Registry Enterprise Edition Namespace resource.

        For information about Container Registry Enterprise Edition Namespace and how to use it, see [What is Namespace](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createnamespace)

        > **NOTE:** Available since v1.86.0.

        > **NOTE:** You need to set your registry password in Container Registry Enterprise Edition console before use this resource.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_registry_enterprise_instance = alicloud.cr.RegistryEnterpriseInstance("default",
            payment_type="Subscription",
            period=1,
            renew_period=0,
            renewal_status="ManualRenewal",
            instance_type="Advanced",
            instance_name=f"{name}-{default['result']}")
        default_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("default",
            instance_id=default_registry_enterprise_instance.id,
            name=f"{name}-{default['result']}",
            auto_create=False,
            default_visibility="PUBLIC")
        ```

        ## Import

        Container Registry Enterprise Edition Namespace can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cs/registryEnterpriseNamespace:RegistryEnterpriseNamespace example <instance_id>:<name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_create: Specifies whether to automatically create an image repository in the namespace. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] default_visibility: The default type of the repository that is automatically created. Valid values:
               - `PUBLIC`: A public repository.
               - `PRIVATE`: A private repository.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Container Registry Enterprise Edition instance.
        :param pulumi.Input[_builtins.str] name: The name of the Container Registry Enterprise Edition Name. It must be `2` to `120` characters in length, and can contain lowercase letters, digits, underscores (_), hyphens (-), and periods (.). It cannot start or end with a delimiter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegistryEnterpriseNamespaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Container Registry Enterprise Edition Namespace resource.

        For information about Container Registry Enterprise Edition Namespace and how to use it, see [What is Namespace](https://www.alibabacloud.com/help/en/acr/developer-reference/api-cr-2018-12-01-createnamespace)

        > **NOTE:** Available since v1.86.0.

        > **NOTE:** You need to set your registry password in Container Registry Enterprise Edition console before use this resource.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_registry_enterprise_instance = alicloud.cr.RegistryEnterpriseInstance("default",
            payment_type="Subscription",
            period=1,
            renew_period=0,
            renewal_status="ManualRenewal",
            instance_type="Advanced",
            instance_name=f"{name}-{default['result']}")
        default_registry_enterprise_namespace = alicloud.cs.RegistryEnterpriseNamespace("default",
            instance_id=default_registry_enterprise_instance.id,
            name=f"{name}-{default['result']}",
            auto_create=False,
            default_visibility="PUBLIC")
        ```

        ## Import

        Container Registry Enterprise Edition Namespace can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cs/registryEnterpriseNamespace:RegistryEnterpriseNamespace example <instance_id>:<name>
        ```

        :param str resource_name: The name of the resource.
        :param RegistryEnterpriseNamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistryEnterpriseNamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistryEnterpriseNamespaceArgs.__new__(RegistryEnterpriseNamespaceArgs)

            __props__.__dict__["auto_create"] = auto_create
            __props__.__dict__["default_visibility"] = default_visibility
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
        super(RegistryEnterpriseNamespace, __self__).__init__(
            'alicloud:cs/registryEnterpriseNamespace:RegistryEnterpriseNamespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_create: Optional[pulumi.Input[_builtins.bool]] = None,
            default_visibility: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'RegistryEnterpriseNamespace':
        """
        Get an existing RegistryEnterpriseNamespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_create: Specifies whether to automatically create an image repository in the namespace. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] default_visibility: The default type of the repository that is automatically created. Valid values:
               - `PUBLIC`: A public repository.
               - `PRIVATE`: A private repository.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the Container Registry Enterprise Edition instance.
        :param pulumi.Input[_builtins.str] name: The name of the Container Registry Enterprise Edition Name. It must be `2` to `120` characters in length, and can contain lowercase letters, digits, underscores (_), hyphens (-), and periods (.). It cannot start or end with a delimiter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistryEnterpriseNamespaceState.__new__(_RegistryEnterpriseNamespaceState)

        __props__.__dict__["auto_create"] = auto_create
        __props__.__dict__["default_visibility"] = default_visibility
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        return RegistryEnterpriseNamespace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoCreate")
    def auto_create(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to automatically create an image repository in the namespace. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_create")

    @_builtins.property
    @pulumi.getter(name="defaultVisibility")
    def default_visibility(self) -> pulumi.Output[_builtins.str]:
        """
        The default type of the repository that is automatically created. Valid values:
        - `PUBLIC`: A public repository.
        - `PRIVATE`: A private repository.
        """
        return pulumi.get(self, "default_visibility")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Container Registry Enterprise Edition instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Container Registry Enterprise Edition Name. It must be `2` to `120` characters in length, and can contain lowercase letters, digits, underscores (_), hyphens (-), and periods (.). It cannot start or end with a delimiter.
        """
        return pulumi.get(self, "name")

