# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainConfigArgs', 'DomainConfig']

@pulumi.input_type
class DomainConfigArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[_builtins.str],
                 function_args: pulumi.Input[Sequence[pulumi.Input['DomainConfigFunctionArgArgs']]],
                 function_name: pulumi.Input[_builtins.str],
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DomainConfig resource.
        :param pulumi.Input[_builtins.str] domain_name: Name of the accelerated domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
        :param pulumi.Input[Sequence[pulumi.Input['DomainConfigFunctionArgArgs']]] function_args: The args of the domain config. See `function_args` below.
        :param pulumi.Input[_builtins.str] function_name: The name of the domain config.
        :param pulumi.Input[_builtins.str] parent_id: By configuring the function condition (rule engine) in the domain name configuration function parameters, Rule conditions can be created (Rule conditions can match and filter user requests by identifying various parameters carried in user requests). After each rule condition is created, a corresponding ConfigId will be generated, and the ConfigId can be referenced by other functions as a ParentId parameter, in this way, the rule conditions can be combined with the functional configuration to form a more flexible configuration.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "function_args", function_args)
        pulumi.set(__self__, "function_name", function_name)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the accelerated domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="functionArgs")
    def function_args(self) -> pulumi.Input[Sequence[pulumi.Input['DomainConfigFunctionArgArgs']]]:
        """
        The args of the domain config. See `function_args` below.
        """
        return pulumi.get(self, "function_args")

    @function_args.setter
    def function_args(self, value: pulumi.Input[Sequence[pulumi.Input['DomainConfigFunctionArgArgs']]]):
        pulumi.set(self, "function_args", value)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the domain config.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        By configuring the function condition (rule engine) in the domain name configuration function parameters, Rule conditions can be created (Rule conditions can match and filter user requests by identifying various parameters carried in user requests). After each rule condition is created, a corresponding ConfigId will be generated, and the ConfigId can be referenced by other functions as a ParentId parameter, in this way, the rule conditions can be combined with the functional configuration to form a more flexible configuration.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_id", value)


@pulumi.input_type
class _DomainConfigState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 function_args: Optional[pulumi.Input[Sequence[pulumi.Input['DomainConfigFunctionArgArgs']]]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DomainConfig resources.
        :param pulumi.Input[_builtins.str] config_id: The ID of the configuration.
        :param pulumi.Input[_builtins.str] domain_name: Name of the accelerated domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
        :param pulumi.Input[Sequence[pulumi.Input['DomainConfigFunctionArgArgs']]] function_args: The args of the domain config. See `function_args` below.
        :param pulumi.Input[_builtins.str] function_name: The name of the domain config.
        :param pulumi.Input[_builtins.str] parent_id: By configuring the function condition (rule engine) in the domain name configuration function parameters, Rule conditions can be created (Rule conditions can match and filter user requests by identifying various parameters carried in user requests). After each rule condition is created, a corresponding ConfigId will be generated, and the ConfigId can be referenced by other functions as a ParentId parameter, in this way, the rule conditions can be combined with the functional configuration to form a more flexible configuration.
        :param pulumi.Input[_builtins.str] status: The status of the Config.
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if function_args is not None:
            pulumi.set(__self__, "function_args", function_args)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the configuration.
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the accelerated domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="functionArgs")
    def function_args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainConfigFunctionArgArgs']]]]:
        """
        The args of the domain config. See `function_args` below.
        """
        return pulumi.get(self, "function_args")

    @function_args.setter
    def function_args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainConfigFunctionArgArgs']]]]):
        pulumi.set(self, "function_args", value)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the domain config.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        By configuring the function condition (rule engine) in the domain name configuration function parameters, Rule conditions can be created (Rule conditions can match and filter user requests by identifying various parameters carried in user requests). After each rule condition is created, a corresponding ConfigId will be generated, and the ConfigId can be referenced by other functions as a ParentId parameter, in this way, the rule conditions can be combined with the functional configuration to form a more flexible configuration.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Config.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:dcdn/domainConfig:DomainConfig")
class DomainConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 function_args: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainConfigFunctionArgArgs', 'DomainConfigFunctionArgArgsDict']]]]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a DCDN Accelerated Domain resource.

        For information about domain config and how to use it, see [Batch set config](https://www.alibabacloud.com/help/en/doc-detail/130632.htm).

        > **NOTE:** Available since v1.131.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        domain_name = config.get("domainName")
        if domain_name is None:
            domain_name = "alibaba-example.com"
        example = alicloud.dcdn.Domain("example",
            domain_name=domain_name,
            scope="overseas",
            status="online",
            sources=[{
                "content": "1.1.1.1",
                "type": "ipaddr",
                "priority": "20",
                "port": 80,
                "weight": "10",
            }])
        ip_allow_list_set = alicloud.dcdn.DomainConfig("ip_allow_list_set",
            domain_name=example.domain_name,
            function_name="ip_allow_list_set",
            function_args=[{
                "arg_name": "ip_list",
                "arg_value": "192.168.0.1",
            }])
        referer_white_list_set = alicloud.dcdn.DomainConfig("referer_white_list_set",
            domain_name=example.domain_name,
            function_name="referer_white_list_set",
            function_args=[{
                "arg_name": "refer_domain_allow_list",
                "arg_value": "110.110.110.110",
            }])
        filetype_based_ttl_set = alicloud.dcdn.DomainConfig("filetype_based_ttl_set",
            domain_name=example.domain_name,
            function_name="filetype_based_ttl_set",
            function_args=[
                {
                    "arg_name": "ttl",
                    "arg_value": "300",
                },
                {
                    "arg_name": "file_type",
                    "arg_value": "jpg",
                },
                {
                    "arg_name": "weight",
                    "arg_value": "1",
                },
            ])
        ```

        ## Import

        DCDN domain config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dcdn/domainConfig:DomainConfig example <domain_name>:<function_name>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_name: Name of the accelerated domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainConfigFunctionArgArgs', 'DomainConfigFunctionArgArgsDict']]]] function_args: The args of the domain config. See `function_args` below.
        :param pulumi.Input[_builtins.str] function_name: The name of the domain config.
        :param pulumi.Input[_builtins.str] parent_id: By configuring the function condition (rule engine) in the domain name configuration function parameters, Rule conditions can be created (Rule conditions can match and filter user requests by identifying various parameters carried in user requests). After each rule condition is created, a corresponding ConfigId will be generated, and the ConfigId can be referenced by other functions as a ParentId parameter, in this way, the rule conditions can be combined with the functional configuration to form a more flexible configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DCDN Accelerated Domain resource.

        For information about domain config and how to use it, see [Batch set config](https://www.alibabacloud.com/help/en/doc-detail/130632.htm).

        > **NOTE:** Available since v1.131.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        domain_name = config.get("domainName")
        if domain_name is None:
            domain_name = "alibaba-example.com"
        example = alicloud.dcdn.Domain("example",
            domain_name=domain_name,
            scope="overseas",
            status="online",
            sources=[{
                "content": "1.1.1.1",
                "type": "ipaddr",
                "priority": "20",
                "port": 80,
                "weight": "10",
            }])
        ip_allow_list_set = alicloud.dcdn.DomainConfig("ip_allow_list_set",
            domain_name=example.domain_name,
            function_name="ip_allow_list_set",
            function_args=[{
                "arg_name": "ip_list",
                "arg_value": "192.168.0.1",
            }])
        referer_white_list_set = alicloud.dcdn.DomainConfig("referer_white_list_set",
            domain_name=example.domain_name,
            function_name="referer_white_list_set",
            function_args=[{
                "arg_name": "refer_domain_allow_list",
                "arg_value": "110.110.110.110",
            }])
        filetype_based_ttl_set = alicloud.dcdn.DomainConfig("filetype_based_ttl_set",
            domain_name=example.domain_name,
            function_name="filetype_based_ttl_set",
            function_args=[
                {
                    "arg_name": "ttl",
                    "arg_value": "300",
                },
                {
                    "arg_name": "file_type",
                    "arg_value": "jpg",
                },
                {
                    "arg_name": "weight",
                    "arg_value": "1",
                },
            ])
        ```

        ## Import

        DCDN domain config can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dcdn/domainConfig:DomainConfig example <domain_name>:<function_name>:<config_id>
        ```

        :param str resource_name: The name of the resource.
        :param DomainConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 function_args: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainConfigFunctionArgArgs', 'DomainConfigFunctionArgArgsDict']]]]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainConfigArgs.__new__(DomainConfigArgs)

            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            if function_args is None and not opts.urn:
                raise TypeError("Missing required property 'function_args'")
            __props__.__dict__["function_args"] = function_args
            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            __props__.__dict__["parent_id"] = parent_id
            __props__.__dict__["config_id"] = None
            __props__.__dict__["status"] = None
        super(DomainConfig, __self__).__init__(
            'alicloud:dcdn/domainConfig:DomainConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            function_args: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainConfigFunctionArgArgs', 'DomainConfigFunctionArgArgsDict']]]]] = None,
            function_name: Optional[pulumi.Input[_builtins.str]] = None,
            parent_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'DomainConfig':
        """
        Get an existing DomainConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] config_id: The ID of the configuration.
        :param pulumi.Input[_builtins.str] domain_name: Name of the accelerated domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainConfigFunctionArgArgs', 'DomainConfigFunctionArgArgsDict']]]] function_args: The args of the domain config. See `function_args` below.
        :param pulumi.Input[_builtins.str] function_name: The name of the domain config.
        :param pulumi.Input[_builtins.str] parent_id: By configuring the function condition (rule engine) in the domain name configuration function parameters, Rule conditions can be created (Rule conditions can match and filter user requests by identifying various parameters carried in user requests). After each rule condition is created, a corresponding ConfigId will be generated, and the ConfigId can be referenced by other functions as a ParentId parameter, in this way, the rule conditions can be combined with the functional configuration to form a more flexible configuration.
        :param pulumi.Input[_builtins.str] status: The status of the Config.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainConfigState.__new__(_DomainConfigState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["function_args"] = function_args
        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["status"] = status
        return DomainConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the configuration.
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the accelerated domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="functionArgs")
    def function_args(self) -> pulumi.Output[Sequence['outputs.DomainConfigFunctionArg']]:
        """
        The args of the domain config. See `function_args` below.
        """
        return pulumi.get(self, "function_args")

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the domain config.
        """
        return pulumi.get(self, "function_name")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[_builtins.str]:
        """
        By configuring the function condition (rule engine) in the domain name configuration function parameters, Rule conditions can be created (Rule conditions can match and filter user requests by identifying various parameters carried in user requests). After each rule condition is created, a corresponding ConfigId will be generated, and the ConfigId can be referenced by other functions as a ParentId parameter, in this way, the rule conditions can be combined with the functional configuration to form a more flexible configuration.
        """
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Config.
        """
        return pulumi.get(self, "status")

