# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDdosBgpInstancesResult',
    'AwaitableGetDdosBgpInstancesResult',
    'get_ddos_bgp_instances',
    'get_ddos_bgp_instances_output',
]

@pulumi.output_type
class GetDdosBgpInstancesResult:
    """
    A collection of values returned by getDdosBgpInstances.
    """
    def __init__(__self__, id=None, ids=None, instances=None, name_regex=None, names=None, output_file=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of instance IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetDdosBgpInstancesInstanceResult']:
        """
        A list of apis. Each element contains the following attributes:
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of instance names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetDdosBgpInstancesResult(GetDdosBgpInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDdosBgpInstancesResult(
            id=self.id,
            ids=self.ids,
            instances=self.instances,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file)


def get_ddos_bgp_instances(ids: Optional[Sequence[_builtins.str]] = None,
                           name_regex: Optional[_builtins.str] = None,
                           output_file: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDdosBgpInstancesResult:
    """
    This data source provides a list of Anti-DDoS Advanced instances in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available in v1.183.0+ .

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "tf-example"
    instance_ddos_bgp_instance = alicloud.ddos.DdosBgpInstance("instance",
        name=name,
        base_bandwidth=20,
        bandwidth=-1,
        ip_count=100,
        ip_type="IPv4",
        normal_bandwidth=100,
        type="Enterprise")
    instance = alicloud.ddos.get_ddos_bgp_instances(name_regex="ddosbgp")
    pulumi.export("instance", [__item.id for __item in [instance]])
    ```


    :param Sequence[_builtins.str] ids: A list of instance IDs.
    :param _builtins.str name_regex: A regex string to filter results by the instance name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ddos/getDdosBgpInstances:getDdosBgpInstances', __args__, opts=opts, typ=GetDdosBgpInstancesResult).value

    return AwaitableGetDdosBgpInstancesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instances=pulumi.get(__ret__, 'instances'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_ddos_bgp_instances_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                  name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDdosBgpInstancesResult]:
    """
    This data source provides a list of Anti-DDoS Advanced instances in an Alibaba Cloud account according to the specified filters.

    > **NOTE:** Available in v1.183.0+ .

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "tf-example"
    instance_ddos_bgp_instance = alicloud.ddos.DdosBgpInstance("instance",
        name=name,
        base_bandwidth=20,
        bandwidth=-1,
        ip_count=100,
        ip_type="IPv4",
        normal_bandwidth=100,
        type="Enterprise")
    instance = alicloud.ddos.get_ddos_bgp_instances(name_regex="ddosbgp")
    pulumi.export("instance", [__item.id for __item in [instance]])
    ```


    :param Sequence[_builtins.str] ids: A list of instance IDs.
    :param _builtins.str name_regex: A regex string to filter results by the instance name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ddos/getDdosBgpInstances:getDdosBgpInstances', __args__, opts=opts, typ=GetDdosBgpInstancesResult)
    return __ret__.apply(lambda __response__: GetDdosBgpInstancesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        instances=pulumi.get(__response__, 'instances'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file')))
