# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MigrationJobArgs', 'MigrationJob']

@pulumi.input_type
class MigrationJobArgs:
    def __init__(__self__, *,
                 data_initialization: pulumi.Input[_builtins.bool],
                 data_synchronization: pulumi.Input[_builtins.bool],
                 db_list: pulumi.Input[_builtins.str],
                 destination_endpoint_engine_name: pulumi.Input[_builtins.str],
                 destination_endpoint_instance_type: pulumi.Input[_builtins.str],
                 dts_instance_id: pulumi.Input[_builtins.str],
                 source_endpoint_engine_name: pulumi.Input[_builtins.str],
                 source_endpoint_instance_type: pulumi.Input[_builtins.str],
                 structure_initialization: pulumi.Input[_builtins.bool],
                 checkpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_port: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dts_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_port: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_role: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MigrationJob resource.
        :param pulumi.Input[_builtins.bool] data_initialization: Whether to execute DTS supports schema migration.
        :param pulumi.Input[_builtins.bool] data_synchronization: Whether to perform incremental data migration.
        :param pulumi.Input[_builtins.str] db_list: Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, migration or subscription objects](https://help.aliyun.com/document_detail/209545.html).
        :param pulumi.Input[_builtins.str] destination_endpoint_engine_name: The type of destination database. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
        :param pulumi.Input[_builtins.str] destination_endpoint_instance_type: The type of destination instance. Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param pulumi.Input[_builtins.str] dts_instance_id: The Migration instance ID. The ID of `dts.MigrationInstance`.
        :param pulumi.Input[_builtins.str] source_endpoint_engine_name: The type of source database. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_type: The type of source instance. Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param pulumi.Input[_builtins.bool] structure_initialization: Whether to perform a database table structure to migrate.
        :param pulumi.Input[_builtins.str] checkpoint: Start time in Unix timestamp format.
        :param pulumi.Input[_builtins.str] destination_endpoint_database_name: The name of migrate the database.
        :param pulumi.Input[_builtins.str] destination_endpoint_instance_id: The ID of destination instance.
        :param pulumi.Input[_builtins.str] destination_endpoint_ip: The ip of source endpoint.
        :param pulumi.Input[_builtins.str] destination_endpoint_oracle_sid: The SID of Oracle database.
        :param pulumi.Input[_builtins.str] destination_endpoint_password: The password of database account.
        :param pulumi.Input[_builtins.str] destination_endpoint_port: The port of source endpoint.
        :param pulumi.Input[_builtins.str] destination_endpoint_region: The region of destination instance.
        :param pulumi.Input[_builtins.str] destination_endpoint_user_name: The username of database account.
        :param pulumi.Input[_builtins.str] dts_job_name: The name of migration job.
        :param pulumi.Input[_builtins.str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
        :param pulumi.Input[_builtins.str] source_endpoint_database_name: The name of migrate the database.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_id: The ID of source instance.
        :param pulumi.Input[_builtins.str] source_endpoint_ip: The ip of source endpoint.
        :param pulumi.Input[_builtins.str] source_endpoint_oracle_sid: The SID of Oracle database.
        :param pulumi.Input[_builtins.str] source_endpoint_owner_id: The Alibaba Cloud account ID to which the source instance belongs.
        :param pulumi.Input[_builtins.str] source_endpoint_password: The password of database account.
        :param pulumi.Input[_builtins.str] source_endpoint_port: The port of source endpoint.
        :param pulumi.Input[_builtins.str] source_endpoint_region: The region of source instance.
        :param pulumi.Input[_builtins.str] source_endpoint_role: The name of the role configured for the cloud account to which the source instance belongs.
        :param pulumi.Input[_builtins.str] source_endpoint_user_name: The username of database account.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Migrating`, `Suspending`. You can suspend the task by specifying `Suspending` and start the task by specifying `Migrating`.
        """
        pulumi.set(__self__, "data_initialization", data_initialization)
        pulumi.set(__self__, "data_synchronization", data_synchronization)
        pulumi.set(__self__, "db_list", db_list)
        pulumi.set(__self__, "destination_endpoint_engine_name", destination_endpoint_engine_name)
        pulumi.set(__self__, "destination_endpoint_instance_type", destination_endpoint_instance_type)
        pulumi.set(__self__, "dts_instance_id", dts_instance_id)
        pulumi.set(__self__, "source_endpoint_engine_name", source_endpoint_engine_name)
        pulumi.set(__self__, "source_endpoint_instance_type", source_endpoint_instance_type)
        pulumi.set(__self__, "structure_initialization", structure_initialization)
        if checkpoint is not None:
            pulumi.set(__self__, "checkpoint", checkpoint)
        if destination_endpoint_database_name is not None:
            pulumi.set(__self__, "destination_endpoint_database_name", destination_endpoint_database_name)
        if destination_endpoint_instance_id is not None:
            pulumi.set(__self__, "destination_endpoint_instance_id", destination_endpoint_instance_id)
        if destination_endpoint_ip is not None:
            pulumi.set(__self__, "destination_endpoint_ip", destination_endpoint_ip)
        if destination_endpoint_oracle_sid is not None:
            pulumi.set(__self__, "destination_endpoint_oracle_sid", destination_endpoint_oracle_sid)
        if destination_endpoint_password is not None:
            pulumi.set(__self__, "destination_endpoint_password", destination_endpoint_password)
        if destination_endpoint_port is not None:
            pulumi.set(__self__, "destination_endpoint_port", destination_endpoint_port)
        if destination_endpoint_region is not None:
            pulumi.set(__self__, "destination_endpoint_region", destination_endpoint_region)
        if destination_endpoint_user_name is not None:
            pulumi.set(__self__, "destination_endpoint_user_name", destination_endpoint_user_name)
        if dts_job_name is not None:
            pulumi.set(__self__, "dts_job_name", dts_job_name)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if source_endpoint_database_name is not None:
            pulumi.set(__self__, "source_endpoint_database_name", source_endpoint_database_name)
        if source_endpoint_instance_id is not None:
            pulumi.set(__self__, "source_endpoint_instance_id", source_endpoint_instance_id)
        if source_endpoint_ip is not None:
            pulumi.set(__self__, "source_endpoint_ip", source_endpoint_ip)
        if source_endpoint_oracle_sid is not None:
            pulumi.set(__self__, "source_endpoint_oracle_sid", source_endpoint_oracle_sid)
        if source_endpoint_owner_id is not None:
            pulumi.set(__self__, "source_endpoint_owner_id", source_endpoint_owner_id)
        if source_endpoint_password is not None:
            pulumi.set(__self__, "source_endpoint_password", source_endpoint_password)
        if source_endpoint_port is not None:
            pulumi.set(__self__, "source_endpoint_port", source_endpoint_port)
        if source_endpoint_region is not None:
            pulumi.set(__self__, "source_endpoint_region", source_endpoint_region)
        if source_endpoint_role is not None:
            pulumi.set(__self__, "source_endpoint_role", source_endpoint_role)
        if source_endpoint_user_name is not None:
            pulumi.set(__self__, "source_endpoint_user_name", source_endpoint_user_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="dataInitialization")
    def data_initialization(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to execute DTS supports schema migration.
        """
        return pulumi.get(self, "data_initialization")

    @data_initialization.setter
    def data_initialization(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "data_initialization", value)

    @_builtins.property
    @pulumi.getter(name="dataSynchronization")
    def data_synchronization(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to perform incremental data migration.
        """
        return pulumi.get(self, "data_synchronization")

    @data_synchronization.setter
    def data_synchronization(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "data_synchronization", value)

    @_builtins.property
    @pulumi.getter(name="dbList")
    def db_list(self) -> pulumi.Input[_builtins.str]:
        """
        Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, migration or subscription objects](https://help.aliyun.com/document_detail/209545.html).
        """
        return pulumi.get(self, "db_list")

    @db_list.setter
    def db_list(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_list", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> pulumi.Input[_builtins.str]:
        """
        The type of destination database. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @destination_endpoint_engine_name.setter
    def destination_endpoint_engine_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_endpoint_engine_name", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointInstanceType")
    def destination_endpoint_instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of destination instance. Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        """
        return pulumi.get(self, "destination_endpoint_instance_type")

    @destination_endpoint_instance_type.setter
    def destination_endpoint_instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_endpoint_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Migration instance ID. The ID of `dts.MigrationInstance`.
        """
        return pulumi.get(self, "dts_instance_id")

    @dts_instance_id.setter
    def dts_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dts_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> pulumi.Input[_builtins.str]:
        """
        The type of source database. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @source_endpoint_engine_name.setter
    def source_endpoint_engine_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_endpoint_engine_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceType")
    def source_endpoint_instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of source instance. Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        """
        return pulumi.get(self, "source_endpoint_instance_type")

    @source_endpoint_instance_type.setter
    def source_endpoint_instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_endpoint_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="structureInitialization")
    def structure_initialization(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to perform a database table structure to migrate.
        """
        return pulumi.get(self, "structure_initialization")

    @structure_initialization.setter
    def structure_initialization(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "structure_initialization", value)

    @_builtins.property
    @pulumi.getter
    def checkpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Start time in Unix timestamp format.
        """
        return pulumi.get(self, "checkpoint")

    @checkpoint.setter
    def checkpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checkpoint", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointDatabaseName")
    def destination_endpoint_database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of migrate the database.
        """
        return pulumi.get(self, "destination_endpoint_database_name")

    @destination_endpoint_database_name.setter
    def destination_endpoint_database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_database_name", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointInstanceId")
    def destination_endpoint_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of destination instance.
        """
        return pulumi.get(self, "destination_endpoint_instance_id")

    @destination_endpoint_instance_id.setter
    def destination_endpoint_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointIp")
    def destination_endpoint_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ip of source endpoint.
        """
        return pulumi.get(self, "destination_endpoint_ip")

    @destination_endpoint_ip.setter
    def destination_endpoint_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_ip", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointOracleSid")
    def destination_endpoint_oracle_sid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SID of Oracle database.
        """
        return pulumi.get(self, "destination_endpoint_oracle_sid")

    @destination_endpoint_oracle_sid.setter
    def destination_endpoint_oracle_sid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_oracle_sid", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointPassword")
    def destination_endpoint_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of database account.
        """
        return pulumi.get(self, "destination_endpoint_password")

    @destination_endpoint_password.setter
    def destination_endpoint_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_password", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointPort")
    def destination_endpoint_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port of source endpoint.
        """
        return pulumi.get(self, "destination_endpoint_port")

    @destination_endpoint_port.setter
    def destination_endpoint_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_port", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointRegion")
    def destination_endpoint_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of destination instance.
        """
        return pulumi.get(self, "destination_endpoint_region")

    @destination_endpoint_region.setter
    def destination_endpoint_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_region", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointUserName")
    def destination_endpoint_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of database account.
        """
        return pulumi.get(self, "destination_endpoint_user_name")

    @destination_endpoint_user_name.setter
    def destination_endpoint_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_user_name", value)

    @_builtins.property
    @pulumi.getter(name="dtsJobName")
    def dts_job_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of migration job.
        """
        return pulumi.get(self, "dts_job_name")

    @dts_job_name.setter
    def dts_job_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dts_job_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_class", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointDatabaseName")
    def source_endpoint_database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of migrate the database.
        """
        return pulumi.get(self, "source_endpoint_database_name")

    @source_endpoint_database_name.setter
    def source_endpoint_database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_database_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceId")
    def source_endpoint_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of source instance.
        """
        return pulumi.get(self, "source_endpoint_instance_id")

    @source_endpoint_instance_id.setter
    def source_endpoint_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointIp")
    def source_endpoint_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ip of source endpoint.
        """
        return pulumi.get(self, "source_endpoint_ip")

    @source_endpoint_ip.setter
    def source_endpoint_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_ip", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointOracleSid")
    def source_endpoint_oracle_sid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SID of Oracle database.
        """
        return pulumi.get(self, "source_endpoint_oracle_sid")

    @source_endpoint_oracle_sid.setter
    def source_endpoint_oracle_sid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_oracle_sid", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointOwnerId")
    def source_endpoint_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Alibaba Cloud account ID to which the source instance belongs.
        """
        return pulumi.get(self, "source_endpoint_owner_id")

    @source_endpoint_owner_id.setter
    def source_endpoint_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPassword")
    def source_endpoint_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of database account.
        """
        return pulumi.get(self, "source_endpoint_password")

    @source_endpoint_password.setter
    def source_endpoint_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_password", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPort")
    def source_endpoint_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port of source endpoint.
        """
        return pulumi.get(self, "source_endpoint_port")

    @source_endpoint_port.setter
    def source_endpoint_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_port", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of source instance.
        """
        return pulumi.get(self, "source_endpoint_region")

    @source_endpoint_region.setter
    def source_endpoint_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_region", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointRole")
    def source_endpoint_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the role configured for the cloud account to which the source instance belongs.
        """
        return pulumi.get(self, "source_endpoint_role")

    @source_endpoint_role.setter
    def source_endpoint_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_role", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointUserName")
    def source_endpoint_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of database account.
        """
        return pulumi.get(self, "source_endpoint_user_name")

    @source_endpoint_user_name.setter
    def source_endpoint_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_user_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `Migrating`, `Suspending`. You can suspend the task by specifying `Suspending` and start the task by specifying `Migrating`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _MigrationJobState:
    def __init__(__self__, *,
                 checkpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 data_initialization: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_synchronization: Optional[pulumi.Input[_builtins.bool]] = None,
                 db_list: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_port: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dts_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dts_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_port: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_role: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 structure_initialization: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering MigrationJob resources.
        :param pulumi.Input[_builtins.str] checkpoint: Start time in Unix timestamp format.
        :param pulumi.Input[_builtins.bool] data_initialization: Whether to execute DTS supports schema migration.
        :param pulumi.Input[_builtins.bool] data_synchronization: Whether to perform incremental data migration.
        :param pulumi.Input[_builtins.str] db_list: Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, migration or subscription objects](https://help.aliyun.com/document_detail/209545.html).
        :param pulumi.Input[_builtins.str] destination_endpoint_database_name: The name of migrate the database.
        :param pulumi.Input[_builtins.str] destination_endpoint_engine_name: The type of destination database. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
        :param pulumi.Input[_builtins.str] destination_endpoint_instance_id: The ID of destination instance.
        :param pulumi.Input[_builtins.str] destination_endpoint_instance_type: The type of destination instance. Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param pulumi.Input[_builtins.str] destination_endpoint_ip: The ip of source endpoint.
        :param pulumi.Input[_builtins.str] destination_endpoint_oracle_sid: The SID of Oracle database.
        :param pulumi.Input[_builtins.str] destination_endpoint_password: The password of database account.
        :param pulumi.Input[_builtins.str] destination_endpoint_port: The port of source endpoint.
        :param pulumi.Input[_builtins.str] destination_endpoint_region: The region of destination instance.
        :param pulumi.Input[_builtins.str] destination_endpoint_user_name: The username of database account.
        :param pulumi.Input[_builtins.str] dts_instance_id: The Migration instance ID. The ID of `dts.MigrationInstance`.
        :param pulumi.Input[_builtins.str] dts_job_name: The name of migration job.
        :param pulumi.Input[_builtins.str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
        :param pulumi.Input[_builtins.str] source_endpoint_database_name: The name of migrate the database.
        :param pulumi.Input[_builtins.str] source_endpoint_engine_name: The type of source database. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_id: The ID of source instance.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_type: The type of source instance. Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param pulumi.Input[_builtins.str] source_endpoint_ip: The ip of source endpoint.
        :param pulumi.Input[_builtins.str] source_endpoint_oracle_sid: The SID of Oracle database.
        :param pulumi.Input[_builtins.str] source_endpoint_owner_id: The Alibaba Cloud account ID to which the source instance belongs.
        :param pulumi.Input[_builtins.str] source_endpoint_password: The password of database account.
        :param pulumi.Input[_builtins.str] source_endpoint_port: The port of source endpoint.
        :param pulumi.Input[_builtins.str] source_endpoint_region: The region of source instance.
        :param pulumi.Input[_builtins.str] source_endpoint_role: The name of the role configured for the cloud account to which the source instance belongs.
        :param pulumi.Input[_builtins.str] source_endpoint_user_name: The username of database account.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Migrating`, `Suspending`. You can suspend the task by specifying `Suspending` and start the task by specifying `Migrating`.
        :param pulumi.Input[_builtins.bool] structure_initialization: Whether to perform a database table structure to migrate.
        """
        if checkpoint is not None:
            pulumi.set(__self__, "checkpoint", checkpoint)
        if data_initialization is not None:
            pulumi.set(__self__, "data_initialization", data_initialization)
        if data_synchronization is not None:
            pulumi.set(__self__, "data_synchronization", data_synchronization)
        if db_list is not None:
            pulumi.set(__self__, "db_list", db_list)
        if destination_endpoint_database_name is not None:
            pulumi.set(__self__, "destination_endpoint_database_name", destination_endpoint_database_name)
        if destination_endpoint_engine_name is not None:
            pulumi.set(__self__, "destination_endpoint_engine_name", destination_endpoint_engine_name)
        if destination_endpoint_instance_id is not None:
            pulumi.set(__self__, "destination_endpoint_instance_id", destination_endpoint_instance_id)
        if destination_endpoint_instance_type is not None:
            pulumi.set(__self__, "destination_endpoint_instance_type", destination_endpoint_instance_type)
        if destination_endpoint_ip is not None:
            pulumi.set(__self__, "destination_endpoint_ip", destination_endpoint_ip)
        if destination_endpoint_oracle_sid is not None:
            pulumi.set(__self__, "destination_endpoint_oracle_sid", destination_endpoint_oracle_sid)
        if destination_endpoint_password is not None:
            pulumi.set(__self__, "destination_endpoint_password", destination_endpoint_password)
        if destination_endpoint_port is not None:
            pulumi.set(__self__, "destination_endpoint_port", destination_endpoint_port)
        if destination_endpoint_region is not None:
            pulumi.set(__self__, "destination_endpoint_region", destination_endpoint_region)
        if destination_endpoint_user_name is not None:
            pulumi.set(__self__, "destination_endpoint_user_name", destination_endpoint_user_name)
        if dts_instance_id is not None:
            pulumi.set(__self__, "dts_instance_id", dts_instance_id)
        if dts_job_name is not None:
            pulumi.set(__self__, "dts_job_name", dts_job_name)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if source_endpoint_database_name is not None:
            pulumi.set(__self__, "source_endpoint_database_name", source_endpoint_database_name)
        if source_endpoint_engine_name is not None:
            pulumi.set(__self__, "source_endpoint_engine_name", source_endpoint_engine_name)
        if source_endpoint_instance_id is not None:
            pulumi.set(__self__, "source_endpoint_instance_id", source_endpoint_instance_id)
        if source_endpoint_instance_type is not None:
            pulumi.set(__self__, "source_endpoint_instance_type", source_endpoint_instance_type)
        if source_endpoint_ip is not None:
            pulumi.set(__self__, "source_endpoint_ip", source_endpoint_ip)
        if source_endpoint_oracle_sid is not None:
            pulumi.set(__self__, "source_endpoint_oracle_sid", source_endpoint_oracle_sid)
        if source_endpoint_owner_id is not None:
            pulumi.set(__self__, "source_endpoint_owner_id", source_endpoint_owner_id)
        if source_endpoint_password is not None:
            pulumi.set(__self__, "source_endpoint_password", source_endpoint_password)
        if source_endpoint_port is not None:
            pulumi.set(__self__, "source_endpoint_port", source_endpoint_port)
        if source_endpoint_region is not None:
            pulumi.set(__self__, "source_endpoint_region", source_endpoint_region)
        if source_endpoint_role is not None:
            pulumi.set(__self__, "source_endpoint_role", source_endpoint_role)
        if source_endpoint_user_name is not None:
            pulumi.set(__self__, "source_endpoint_user_name", source_endpoint_user_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if structure_initialization is not None:
            pulumi.set(__self__, "structure_initialization", structure_initialization)

    @_builtins.property
    @pulumi.getter
    def checkpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Start time in Unix timestamp format.
        """
        return pulumi.get(self, "checkpoint")

    @checkpoint.setter
    def checkpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checkpoint", value)

    @_builtins.property
    @pulumi.getter(name="dataInitialization")
    def data_initialization(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to execute DTS supports schema migration.
        """
        return pulumi.get(self, "data_initialization")

    @data_initialization.setter
    def data_initialization(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_initialization", value)

    @_builtins.property
    @pulumi.getter(name="dataSynchronization")
    def data_synchronization(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to perform incremental data migration.
        """
        return pulumi.get(self, "data_synchronization")

    @data_synchronization.setter
    def data_synchronization(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_synchronization", value)

    @_builtins.property
    @pulumi.getter(name="dbList")
    def db_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, migration or subscription objects](https://help.aliyun.com/document_detail/209545.html).
        """
        return pulumi.get(self, "db_list")

    @db_list.setter
    def db_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_list", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointDatabaseName")
    def destination_endpoint_database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of migrate the database.
        """
        return pulumi.get(self, "destination_endpoint_database_name")

    @destination_endpoint_database_name.setter
    def destination_endpoint_database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_database_name", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of destination database. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @destination_endpoint_engine_name.setter
    def destination_endpoint_engine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_engine_name", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointInstanceId")
    def destination_endpoint_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of destination instance.
        """
        return pulumi.get(self, "destination_endpoint_instance_id")

    @destination_endpoint_instance_id.setter
    def destination_endpoint_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointInstanceType")
    def destination_endpoint_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of destination instance. Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        """
        return pulumi.get(self, "destination_endpoint_instance_type")

    @destination_endpoint_instance_type.setter
    def destination_endpoint_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointIp")
    def destination_endpoint_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ip of source endpoint.
        """
        return pulumi.get(self, "destination_endpoint_ip")

    @destination_endpoint_ip.setter
    def destination_endpoint_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_ip", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointOracleSid")
    def destination_endpoint_oracle_sid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SID of Oracle database.
        """
        return pulumi.get(self, "destination_endpoint_oracle_sid")

    @destination_endpoint_oracle_sid.setter
    def destination_endpoint_oracle_sid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_oracle_sid", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointPassword")
    def destination_endpoint_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of database account.
        """
        return pulumi.get(self, "destination_endpoint_password")

    @destination_endpoint_password.setter
    def destination_endpoint_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_password", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointPort")
    def destination_endpoint_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port of source endpoint.
        """
        return pulumi.get(self, "destination_endpoint_port")

    @destination_endpoint_port.setter
    def destination_endpoint_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_port", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointRegion")
    def destination_endpoint_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of destination instance.
        """
        return pulumi.get(self, "destination_endpoint_region")

    @destination_endpoint_region.setter
    def destination_endpoint_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_region", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointUserName")
    def destination_endpoint_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of database account.
        """
        return pulumi.get(self, "destination_endpoint_user_name")

    @destination_endpoint_user_name.setter
    def destination_endpoint_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_user_name", value)

    @_builtins.property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Migration instance ID. The ID of `dts.MigrationInstance`.
        """
        return pulumi.get(self, "dts_instance_id")

    @dts_instance_id.setter
    def dts_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dts_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="dtsJobName")
    def dts_job_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of migration job.
        """
        return pulumi.get(self, "dts_job_name")

    @dts_job_name.setter
    def dts_job_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dts_job_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_class", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointDatabaseName")
    def source_endpoint_database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of migrate the database.
        """
        return pulumi.get(self, "source_endpoint_database_name")

    @source_endpoint_database_name.setter
    def source_endpoint_database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_database_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of source database. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @source_endpoint_engine_name.setter
    def source_endpoint_engine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_engine_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceId")
    def source_endpoint_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of source instance.
        """
        return pulumi.get(self, "source_endpoint_instance_id")

    @source_endpoint_instance_id.setter
    def source_endpoint_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceType")
    def source_endpoint_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of source instance. Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        """
        return pulumi.get(self, "source_endpoint_instance_type")

    @source_endpoint_instance_type.setter
    def source_endpoint_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointIp")
    def source_endpoint_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ip of source endpoint.
        """
        return pulumi.get(self, "source_endpoint_ip")

    @source_endpoint_ip.setter
    def source_endpoint_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_ip", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointOracleSid")
    def source_endpoint_oracle_sid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SID of Oracle database.
        """
        return pulumi.get(self, "source_endpoint_oracle_sid")

    @source_endpoint_oracle_sid.setter
    def source_endpoint_oracle_sid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_oracle_sid", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointOwnerId")
    def source_endpoint_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Alibaba Cloud account ID to which the source instance belongs.
        """
        return pulumi.get(self, "source_endpoint_owner_id")

    @source_endpoint_owner_id.setter
    def source_endpoint_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPassword")
    def source_endpoint_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of database account.
        """
        return pulumi.get(self, "source_endpoint_password")

    @source_endpoint_password.setter
    def source_endpoint_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_password", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPort")
    def source_endpoint_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port of source endpoint.
        """
        return pulumi.get(self, "source_endpoint_port")

    @source_endpoint_port.setter
    def source_endpoint_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_port", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of source instance.
        """
        return pulumi.get(self, "source_endpoint_region")

    @source_endpoint_region.setter
    def source_endpoint_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_region", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointRole")
    def source_endpoint_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the role configured for the cloud account to which the source instance belongs.
        """
        return pulumi.get(self, "source_endpoint_role")

    @source_endpoint_role.setter
    def source_endpoint_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_role", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointUserName")
    def source_endpoint_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of database account.
        """
        return pulumi.get(self, "source_endpoint_user_name")

    @source_endpoint_user_name.setter
    def source_endpoint_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_user_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `Migrating`, `Suspending`. You can suspend the task by specifying `Suspending` and start the task by specifying `Migrating`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="structureInitialization")
    def structure_initialization(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to perform a database table structure to migrate.
        """
        return pulumi.get(self, "structure_initialization")

    @structure_initialization.setter
    def structure_initialization(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "structure_initialization", value)


@pulumi.type_token("alicloud:dts/migrationJob:MigrationJob")
class MigrationJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checkpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 data_initialization: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_synchronization: Optional[pulumi.Input[_builtins.bool]] = None,
                 db_list: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_port: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dts_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dts_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_port: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_role: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 structure_initialization: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a DTS Migration Job resource.

        For information about DTS Migration Job and how to use it, see [What is Migration Job](https://www.alibabacloud.com/help/en/doc-detail/208399.html).

        > **NOTE:** Available since v1.157.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.get_regions(current=True)
        example_get_zones = alicloud.rds.get_zones(engine="MySQL",
            engine_version="8.0",
            instance_charge_type="PostPaid",
            category="Basic",
            db_instance_storage_type="cloud_essd")
        example_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=example_get_zones.zones[0].id,
            engine="MySQL",
            engine_version="8.0",
            instance_charge_type="PostPaid",
            category="Basic",
            db_instance_storage_type="cloud_essd")
        example_network = alicloud.vpc.Network("example",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        example_switch = alicloud.vpc.Switch("example",
            vpc_id=example_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=example_get_zones.zones[0].id,
            vswitch_name=name)
        example_security_group = alicloud.ecs.SecurityGroup("example",
            name=name,
            vpc_id=example_network.id)
        example_instance = []
        for range in [{"value": i} for i in range(0, 2)]:
            example_instance.append(alicloud.rds.Instance(f"example-{range['value']}",
                engine="MySQL",
                engine_version="8.0",
                instance_type=example_get_instance_classes.instance_classes[0].instance_class,
                instance_storage=example_get_instance_classes.instance_classes[0].storage_range.min,
                instance_charge_type="Postpaid",
                instance_name=std.format(input=f"{name}_%d",
                    args=[range["value"] + 1]).result,
                vswitch_id=example_switch.id,
                monitoring_period=60,
                db_instance_storage_type="cloud_essd",
                security_group_ids=[example_security_group.id]))
        example_rds_account = []
        for range in [{"value": i} for i in range(0, 2)]:
            example_rds_account.append(alicloud.rds.RdsAccount(f"example-{range['value']}",
                db_instance_id=example_instance[range["value"]].id,
                account_name=std.format(input="example_name_%d",
                    args=[range["value"] + 1]).result,
                account_password=std.format(input="example_password_%d",
                    args=[range["value"] + 1]).result))
        example_database = []
        for range in [{"value": i} for i in range(0, 2)]:
            example_database.append(alicloud.rds.Database(f"example-{range['value']}",
                instance_id=example_instance[range["value"]].id,
                name=std.format(input=f"{name}_%d",
                    args=[range["value"] + 1]).result))
        example_account_privilege = []
        for range in [{"value": i} for i in range(0, 2)]:
            example_account_privilege.append(alicloud.rds.AccountPrivilege(f"example-{range['value']}",
                instance_id=example_instance[range["value"]].id,
                account_name=example_rds_account[range["value"]].name,
                privilege="ReadWrite",
                db_names=[example_database[range["value"]].name]))
        example_migration_instance = alicloud.dts.MigrationInstance("example",
            payment_type="PayAsYouGo",
            source_endpoint_engine_name="MySQL",
            source_endpoint_region=example.regions[0].id,
            destination_endpoint_engine_name="MySQL",
            destination_endpoint_region=example.regions[0].id,
            instance_class="small",
            sync_architecture="oneway")
        example_migration_job = alicloud.dts.MigrationJob("example",
            dts_instance_id=example_migration_instance.id,
            dts_job_name=name,
            source_endpoint_instance_type="RDS",
            source_endpoint_instance_id=example_account_privilege[0].instance_id,
            source_endpoint_engine_name="MySQL",
            source_endpoint_region=example.regions[0].id,
            source_endpoint_user_name=example_rds_account[0].account_name,
            source_endpoint_password=example_rds_account[0].account_password,
            destination_endpoint_instance_type="RDS",
            destination_endpoint_instance_id=example_account_privilege[1].instance_id,
            destination_endpoint_engine_name="MySQL",
            destination_endpoint_region=example.regions[0].id,
            destination_endpoint_user_name=example_rds_account[1].account_name,
            destination_endpoint_password=example_rds_account[1].account_password,
            db_list=pulumi.Output.json_dumps(pulumi.Output.all(
                exampleDatabaseName=example_database[0].name,
                exampleDatabaseName1=example_database[1].name
        ).apply(lambda resolved_outputs: {
                resolved_outputs['exampleDatabaseName']: {
                    "name": resolved_outputs['exampleDatabaseName1'],
                    "all": True,
                },
            })
        ),
            structure_initialization=True,
            data_initialization=True,
            data_synchronization=True)
        ```

        ## Notice

        1. The expiration time cannot be changed after the work of the annual and monthly subscription suspended;
        2. After the pay-as-you-go type job suspended, your job configuration fee will still be charged;
        3. If the task suspended for more than 6 hours, the task will not start successfully.
        4. Suspending the task will only stop writing to the target library, but will still continue to obtain the incremental log of the source, so that the task can be quickly resumed after the suspension is canceled. Therefore, some resources of the source library, such as bandwidth resources, will continue to be occupied during the period.
        5. Charges will continue during the task suspension period. If you need to stop charging, please release the instance
        6. When a DTS instance suspended for more than 7 days, the instance cannot be resumed, and the status will change from suspended to failed.

        ## Import

        DTS Migration Job can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dts/migrationJob:MigrationJob example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] checkpoint: Start time in Unix timestamp format.
        :param pulumi.Input[_builtins.bool] data_initialization: Whether to execute DTS supports schema migration.
        :param pulumi.Input[_builtins.bool] data_synchronization: Whether to perform incremental data migration.
        :param pulumi.Input[_builtins.str] db_list: Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, migration or subscription objects](https://help.aliyun.com/document_detail/209545.html).
        :param pulumi.Input[_builtins.str] destination_endpoint_database_name: The name of migrate the database.
        :param pulumi.Input[_builtins.str] destination_endpoint_engine_name: The type of destination database. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
        :param pulumi.Input[_builtins.str] destination_endpoint_instance_id: The ID of destination instance.
        :param pulumi.Input[_builtins.str] destination_endpoint_instance_type: The type of destination instance. Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param pulumi.Input[_builtins.str] destination_endpoint_ip: The ip of source endpoint.
        :param pulumi.Input[_builtins.str] destination_endpoint_oracle_sid: The SID of Oracle database.
        :param pulumi.Input[_builtins.str] destination_endpoint_password: The password of database account.
        :param pulumi.Input[_builtins.str] destination_endpoint_port: The port of source endpoint.
        :param pulumi.Input[_builtins.str] destination_endpoint_region: The region of destination instance.
        :param pulumi.Input[_builtins.str] destination_endpoint_user_name: The username of database account.
        :param pulumi.Input[_builtins.str] dts_instance_id: The Migration instance ID. The ID of `dts.MigrationInstance`.
        :param pulumi.Input[_builtins.str] dts_job_name: The name of migration job.
        :param pulumi.Input[_builtins.str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
        :param pulumi.Input[_builtins.str] source_endpoint_database_name: The name of migrate the database.
        :param pulumi.Input[_builtins.str] source_endpoint_engine_name: The type of source database. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_id: The ID of source instance.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_type: The type of source instance. Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param pulumi.Input[_builtins.str] source_endpoint_ip: The ip of source endpoint.
        :param pulumi.Input[_builtins.str] source_endpoint_oracle_sid: The SID of Oracle database.
        :param pulumi.Input[_builtins.str] source_endpoint_owner_id: The Alibaba Cloud account ID to which the source instance belongs.
        :param pulumi.Input[_builtins.str] source_endpoint_password: The password of database account.
        :param pulumi.Input[_builtins.str] source_endpoint_port: The port of source endpoint.
        :param pulumi.Input[_builtins.str] source_endpoint_region: The region of source instance.
        :param pulumi.Input[_builtins.str] source_endpoint_role: The name of the role configured for the cloud account to which the source instance belongs.
        :param pulumi.Input[_builtins.str] source_endpoint_user_name: The username of database account.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Migrating`, `Suspending`. You can suspend the task by specifying `Suspending` and start the task by specifying `Migrating`.
        :param pulumi.Input[_builtins.bool] structure_initialization: Whether to perform a database table structure to migrate.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MigrationJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DTS Migration Job resource.

        For information about DTS Migration Job and how to use it, see [What is Migration Job](https://www.alibabacloud.com/help/en/doc-detail/208399.html).

        > **NOTE:** Available since v1.157.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.get_regions(current=True)
        example_get_zones = alicloud.rds.get_zones(engine="MySQL",
            engine_version="8.0",
            instance_charge_type="PostPaid",
            category="Basic",
            db_instance_storage_type="cloud_essd")
        example_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=example_get_zones.zones[0].id,
            engine="MySQL",
            engine_version="8.0",
            instance_charge_type="PostPaid",
            category="Basic",
            db_instance_storage_type="cloud_essd")
        example_network = alicloud.vpc.Network("example",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        example_switch = alicloud.vpc.Switch("example",
            vpc_id=example_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=example_get_zones.zones[0].id,
            vswitch_name=name)
        example_security_group = alicloud.ecs.SecurityGroup("example",
            name=name,
            vpc_id=example_network.id)
        example_instance = []
        for range in [{"value": i} for i in range(0, 2)]:
            example_instance.append(alicloud.rds.Instance(f"example-{range['value']}",
                engine="MySQL",
                engine_version="8.0",
                instance_type=example_get_instance_classes.instance_classes[0].instance_class,
                instance_storage=example_get_instance_classes.instance_classes[0].storage_range.min,
                instance_charge_type="Postpaid",
                instance_name=std.format(input=f"{name}_%d",
                    args=[range["value"] + 1]).result,
                vswitch_id=example_switch.id,
                monitoring_period=60,
                db_instance_storage_type="cloud_essd",
                security_group_ids=[example_security_group.id]))
        example_rds_account = []
        for range in [{"value": i} for i in range(0, 2)]:
            example_rds_account.append(alicloud.rds.RdsAccount(f"example-{range['value']}",
                db_instance_id=example_instance[range["value"]].id,
                account_name=std.format(input="example_name_%d",
                    args=[range["value"] + 1]).result,
                account_password=std.format(input="example_password_%d",
                    args=[range["value"] + 1]).result))
        example_database = []
        for range in [{"value": i} for i in range(0, 2)]:
            example_database.append(alicloud.rds.Database(f"example-{range['value']}",
                instance_id=example_instance[range["value"]].id,
                name=std.format(input=f"{name}_%d",
                    args=[range["value"] + 1]).result))
        example_account_privilege = []
        for range in [{"value": i} for i in range(0, 2)]:
            example_account_privilege.append(alicloud.rds.AccountPrivilege(f"example-{range['value']}",
                instance_id=example_instance[range["value"]].id,
                account_name=example_rds_account[range["value"]].name,
                privilege="ReadWrite",
                db_names=[example_database[range["value"]].name]))
        example_migration_instance = alicloud.dts.MigrationInstance("example",
            payment_type="PayAsYouGo",
            source_endpoint_engine_name="MySQL",
            source_endpoint_region=example.regions[0].id,
            destination_endpoint_engine_name="MySQL",
            destination_endpoint_region=example.regions[0].id,
            instance_class="small",
            sync_architecture="oneway")
        example_migration_job = alicloud.dts.MigrationJob("example",
            dts_instance_id=example_migration_instance.id,
            dts_job_name=name,
            source_endpoint_instance_type="RDS",
            source_endpoint_instance_id=example_account_privilege[0].instance_id,
            source_endpoint_engine_name="MySQL",
            source_endpoint_region=example.regions[0].id,
            source_endpoint_user_name=example_rds_account[0].account_name,
            source_endpoint_password=example_rds_account[0].account_password,
            destination_endpoint_instance_type="RDS",
            destination_endpoint_instance_id=example_account_privilege[1].instance_id,
            destination_endpoint_engine_name="MySQL",
            destination_endpoint_region=example.regions[0].id,
            destination_endpoint_user_name=example_rds_account[1].account_name,
            destination_endpoint_password=example_rds_account[1].account_password,
            db_list=pulumi.Output.json_dumps(pulumi.Output.all(
                exampleDatabaseName=example_database[0].name,
                exampleDatabaseName1=example_database[1].name
        ).apply(lambda resolved_outputs: {
                resolved_outputs['exampleDatabaseName']: {
                    "name": resolved_outputs['exampleDatabaseName1'],
                    "all": True,
                },
            })
        ),
            structure_initialization=True,
            data_initialization=True,
            data_synchronization=True)
        ```

        ## Notice

        1. The expiration time cannot be changed after the work of the annual and monthly subscription suspended;
        2. After the pay-as-you-go type job suspended, your job configuration fee will still be charged;
        3. If the task suspended for more than 6 hours, the task will not start successfully.
        4. Suspending the task will only stop writing to the target library, but will still continue to obtain the incremental log of the source, so that the task can be quickly resumed after the suspension is canceled. Therefore, some resources of the source library, such as bandwidth resources, will continue to be occupied during the period.
        5. Charges will continue during the task suspension period. If you need to stop charging, please release the instance
        6. When a DTS instance suspended for more than 7 days, the instance cannot be resumed, and the status will change from suspended to failed.

        ## Import

        DTS Migration Job can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dts/migrationJob:MigrationJob example <id>
        ```

        :param str resource_name: The name of the resource.
        :param MigrationJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MigrationJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checkpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 data_initialization: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_synchronization: Optional[pulumi.Input[_builtins.bool]] = None,
                 db_list: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_port: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dts_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dts_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_port: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_role: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 structure_initialization: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MigrationJobArgs.__new__(MigrationJobArgs)

            __props__.__dict__["checkpoint"] = checkpoint
            if data_initialization is None and not opts.urn:
                raise TypeError("Missing required property 'data_initialization'")
            __props__.__dict__["data_initialization"] = data_initialization
            if data_synchronization is None and not opts.urn:
                raise TypeError("Missing required property 'data_synchronization'")
            __props__.__dict__["data_synchronization"] = data_synchronization
            if db_list is None and not opts.urn:
                raise TypeError("Missing required property 'db_list'")
            __props__.__dict__["db_list"] = db_list
            __props__.__dict__["destination_endpoint_database_name"] = destination_endpoint_database_name
            if destination_endpoint_engine_name is None and not opts.urn:
                raise TypeError("Missing required property 'destination_endpoint_engine_name'")
            __props__.__dict__["destination_endpoint_engine_name"] = destination_endpoint_engine_name
            __props__.__dict__["destination_endpoint_instance_id"] = destination_endpoint_instance_id
            if destination_endpoint_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'destination_endpoint_instance_type'")
            __props__.__dict__["destination_endpoint_instance_type"] = destination_endpoint_instance_type
            __props__.__dict__["destination_endpoint_ip"] = destination_endpoint_ip
            __props__.__dict__["destination_endpoint_oracle_sid"] = destination_endpoint_oracle_sid
            __props__.__dict__["destination_endpoint_password"] = destination_endpoint_password
            __props__.__dict__["destination_endpoint_port"] = destination_endpoint_port
            __props__.__dict__["destination_endpoint_region"] = destination_endpoint_region
            __props__.__dict__["destination_endpoint_user_name"] = destination_endpoint_user_name
            if dts_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'dts_instance_id'")
            __props__.__dict__["dts_instance_id"] = dts_instance_id
            __props__.__dict__["dts_job_name"] = dts_job_name
            __props__.__dict__["instance_class"] = instance_class
            __props__.__dict__["source_endpoint_database_name"] = source_endpoint_database_name
            if source_endpoint_engine_name is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint_engine_name'")
            __props__.__dict__["source_endpoint_engine_name"] = source_endpoint_engine_name
            __props__.__dict__["source_endpoint_instance_id"] = source_endpoint_instance_id
            if source_endpoint_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint_instance_type'")
            __props__.__dict__["source_endpoint_instance_type"] = source_endpoint_instance_type
            __props__.__dict__["source_endpoint_ip"] = source_endpoint_ip
            __props__.__dict__["source_endpoint_oracle_sid"] = source_endpoint_oracle_sid
            __props__.__dict__["source_endpoint_owner_id"] = source_endpoint_owner_id
            __props__.__dict__["source_endpoint_password"] = source_endpoint_password
            __props__.__dict__["source_endpoint_port"] = source_endpoint_port
            __props__.__dict__["source_endpoint_region"] = source_endpoint_region
            __props__.__dict__["source_endpoint_role"] = source_endpoint_role
            __props__.__dict__["source_endpoint_user_name"] = source_endpoint_user_name
            __props__.__dict__["status"] = status
            if structure_initialization is None and not opts.urn:
                raise TypeError("Missing required property 'structure_initialization'")
            __props__.__dict__["structure_initialization"] = structure_initialization
        super(MigrationJob, __self__).__init__(
            'alicloud:dts/migrationJob:MigrationJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            checkpoint: Optional[pulumi.Input[_builtins.str]] = None,
            data_initialization: Optional[pulumi.Input[_builtins.bool]] = None,
            data_synchronization: Optional[pulumi.Input[_builtins.bool]] = None,
            db_list: Optional[pulumi.Input[_builtins.str]] = None,
            destination_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
            destination_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
            destination_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            destination_endpoint_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            destination_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
            destination_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
            destination_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
            destination_endpoint_port: Optional[pulumi.Input[_builtins.str]] = None,
            destination_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
            destination_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
            dts_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            dts_job_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_class: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_port: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_role: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            structure_initialization: Optional[pulumi.Input[_builtins.bool]] = None) -> 'MigrationJob':
        """
        Get an existing MigrationJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] checkpoint: Start time in Unix timestamp format.
        :param pulumi.Input[_builtins.bool] data_initialization: Whether to execute DTS supports schema migration.
        :param pulumi.Input[_builtins.bool] data_synchronization: Whether to perform incremental data migration.
        :param pulumi.Input[_builtins.str] db_list: Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, migration or subscription objects](https://help.aliyun.com/document_detail/209545.html).
        :param pulumi.Input[_builtins.str] destination_endpoint_database_name: The name of migrate the database.
        :param pulumi.Input[_builtins.str] destination_endpoint_engine_name: The type of destination database. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
        :param pulumi.Input[_builtins.str] destination_endpoint_instance_id: The ID of destination instance.
        :param pulumi.Input[_builtins.str] destination_endpoint_instance_type: The type of destination instance. Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param pulumi.Input[_builtins.str] destination_endpoint_ip: The ip of source endpoint.
        :param pulumi.Input[_builtins.str] destination_endpoint_oracle_sid: The SID of Oracle database.
        :param pulumi.Input[_builtins.str] destination_endpoint_password: The password of database account.
        :param pulumi.Input[_builtins.str] destination_endpoint_port: The port of source endpoint.
        :param pulumi.Input[_builtins.str] destination_endpoint_region: The region of destination instance.
        :param pulumi.Input[_builtins.str] destination_endpoint_user_name: The username of database account.
        :param pulumi.Input[_builtins.str] dts_instance_id: The Migration instance ID. The ID of `dts.MigrationInstance`.
        :param pulumi.Input[_builtins.str] dts_job_name: The name of migration job.
        :param pulumi.Input[_builtins.str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
        :param pulumi.Input[_builtins.str] source_endpoint_database_name: The name of migrate the database.
        :param pulumi.Input[_builtins.str] source_endpoint_engine_name: The type of source database. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_id: The ID of source instance.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_type: The type of source instance. Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        :param pulumi.Input[_builtins.str] source_endpoint_ip: The ip of source endpoint.
        :param pulumi.Input[_builtins.str] source_endpoint_oracle_sid: The SID of Oracle database.
        :param pulumi.Input[_builtins.str] source_endpoint_owner_id: The Alibaba Cloud account ID to which the source instance belongs.
        :param pulumi.Input[_builtins.str] source_endpoint_password: The password of database account.
        :param pulumi.Input[_builtins.str] source_endpoint_port: The port of source endpoint.
        :param pulumi.Input[_builtins.str] source_endpoint_region: The region of source instance.
        :param pulumi.Input[_builtins.str] source_endpoint_role: The name of the role configured for the cloud account to which the source instance belongs.
        :param pulumi.Input[_builtins.str] source_endpoint_user_name: The username of database account.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `Migrating`, `Suspending`. You can suspend the task by specifying `Suspending` and start the task by specifying `Migrating`.
        :param pulumi.Input[_builtins.bool] structure_initialization: Whether to perform a database table structure to migrate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MigrationJobState.__new__(_MigrationJobState)

        __props__.__dict__["checkpoint"] = checkpoint
        __props__.__dict__["data_initialization"] = data_initialization
        __props__.__dict__["data_synchronization"] = data_synchronization
        __props__.__dict__["db_list"] = db_list
        __props__.__dict__["destination_endpoint_database_name"] = destination_endpoint_database_name
        __props__.__dict__["destination_endpoint_engine_name"] = destination_endpoint_engine_name
        __props__.__dict__["destination_endpoint_instance_id"] = destination_endpoint_instance_id
        __props__.__dict__["destination_endpoint_instance_type"] = destination_endpoint_instance_type
        __props__.__dict__["destination_endpoint_ip"] = destination_endpoint_ip
        __props__.__dict__["destination_endpoint_oracle_sid"] = destination_endpoint_oracle_sid
        __props__.__dict__["destination_endpoint_password"] = destination_endpoint_password
        __props__.__dict__["destination_endpoint_port"] = destination_endpoint_port
        __props__.__dict__["destination_endpoint_region"] = destination_endpoint_region
        __props__.__dict__["destination_endpoint_user_name"] = destination_endpoint_user_name
        __props__.__dict__["dts_instance_id"] = dts_instance_id
        __props__.__dict__["dts_job_name"] = dts_job_name
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["source_endpoint_database_name"] = source_endpoint_database_name
        __props__.__dict__["source_endpoint_engine_name"] = source_endpoint_engine_name
        __props__.__dict__["source_endpoint_instance_id"] = source_endpoint_instance_id
        __props__.__dict__["source_endpoint_instance_type"] = source_endpoint_instance_type
        __props__.__dict__["source_endpoint_ip"] = source_endpoint_ip
        __props__.__dict__["source_endpoint_oracle_sid"] = source_endpoint_oracle_sid
        __props__.__dict__["source_endpoint_owner_id"] = source_endpoint_owner_id
        __props__.__dict__["source_endpoint_password"] = source_endpoint_password
        __props__.__dict__["source_endpoint_port"] = source_endpoint_port
        __props__.__dict__["source_endpoint_region"] = source_endpoint_region
        __props__.__dict__["source_endpoint_role"] = source_endpoint_role
        __props__.__dict__["source_endpoint_user_name"] = source_endpoint_user_name
        __props__.__dict__["status"] = status
        __props__.__dict__["structure_initialization"] = structure_initialization
        return MigrationJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def checkpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Start time in Unix timestamp format.
        """
        return pulumi.get(self, "checkpoint")

    @_builtins.property
    @pulumi.getter(name="dataInitialization")
    def data_initialization(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to execute DTS supports schema migration.
        """
        return pulumi.get(self, "data_initialization")

    @_builtins.property
    @pulumi.getter(name="dataSynchronization")
    def data_synchronization(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to perform incremental data migration.
        """
        return pulumi.get(self, "data_synchronization")

    @_builtins.property
    @pulumi.getter(name="dbList")
    def db_list(self) -> pulumi.Output[_builtins.str]:
        """
        Migration object, in the format of JSON strings. For detailed definition instructions, please refer to [the description of migration, migration or subscription objects](https://help.aliyun.com/document_detail/209545.html).
        """
        return pulumi.get(self, "db_list")

    @_builtins.property
    @pulumi.getter(name="destinationEndpointDatabaseName")
    def destination_endpoint_database_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of migrate the database.
        """
        return pulumi.get(self, "destination_endpoint_database_name")

    @_builtins.property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> pulumi.Output[_builtins.str]:
        """
        The type of destination database. Valid values: `ADS`, `ADB30`, `AS400`, `DATAHUB`, `DB2`, `GREENPLUM`, `KAFKA`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `PostgreSQL`.
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @_builtins.property
    @pulumi.getter(name="destinationEndpointInstanceId")
    def destination_endpoint_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of destination instance.
        """
        return pulumi.get(self, "destination_endpoint_instance_id")

    @_builtins.property
    @pulumi.getter(name="destinationEndpointInstanceType")
    def destination_endpoint_instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of destination instance. Valid values: `ADS`, `CEN`, `DATAHUB`, `DG`, `ECS`, `EXPRESS`, `GREENPLUM`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        """
        return pulumi.get(self, "destination_endpoint_instance_type")

    @_builtins.property
    @pulumi.getter(name="destinationEndpointIp")
    def destination_endpoint_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ip of source endpoint.
        """
        return pulumi.get(self, "destination_endpoint_ip")

    @_builtins.property
    @pulumi.getter(name="destinationEndpointOracleSid")
    def destination_endpoint_oracle_sid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The SID of Oracle database.
        """
        return pulumi.get(self, "destination_endpoint_oracle_sid")

    @_builtins.property
    @pulumi.getter(name="destinationEndpointPassword")
    def destination_endpoint_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of database account.
        """
        return pulumi.get(self, "destination_endpoint_password")

    @_builtins.property
    @pulumi.getter(name="destinationEndpointPort")
    def destination_endpoint_port(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The port of source endpoint.
        """
        return pulumi.get(self, "destination_endpoint_port")

    @_builtins.property
    @pulumi.getter(name="destinationEndpointRegion")
    def destination_endpoint_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region of destination instance.
        """
        return pulumi.get(self, "destination_endpoint_region")

    @_builtins.property
    @pulumi.getter(name="destinationEndpointUserName")
    def destination_endpoint_user_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The username of database account.
        """
        return pulumi.get(self, "destination_endpoint_user_name")

    @_builtins.property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Migration instance ID. The ID of `dts.MigrationInstance`.
        """
        return pulumi.get(self, "dts_instance_id")

    @_builtins.property
    @pulumi.getter(name="dtsJobName")
    def dts_job_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of migration job.
        """
        return pulumi.get(self, "dts_job_name")

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[_builtins.str]:
        """
        The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
        """
        return pulumi.get(self, "instance_class")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointDatabaseName")
    def source_endpoint_database_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of migrate the database.
        """
        return pulumi.get(self, "source_endpoint_database_name")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> pulumi.Output[_builtins.str]:
        """
        The type of source database. Valid values: `AS400`, `DB2`, `DMSPOLARDB`, `HBASE`, `MONGODB`, `MSSQL`, `MySQL`, `ORACLE`, `PolarDB`, `POLARDBX20`, `POLARDB_O`, `POSTGRESQL`, `TERADATA`.
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceId")
    def source_endpoint_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of source instance.
        """
        return pulumi.get(self, "source_endpoint_instance_id")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceType")
    def source_endpoint_instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of source instance. Valid values: `CEN`, `DG`, `DISTRIBUTED_DMSLOGICDB`, `ECS`, `EXPRESS`, `MONGODB`, `OTHER`, `PolarDB`, `POLARDBX20`, `RDS`.
        """
        return pulumi.get(self, "source_endpoint_instance_type")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointIp")
    def source_endpoint_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ip of source endpoint.
        """
        return pulumi.get(self, "source_endpoint_ip")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointOracleSid")
    def source_endpoint_oracle_sid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The SID of Oracle database.
        """
        return pulumi.get(self, "source_endpoint_oracle_sid")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointOwnerId")
    def source_endpoint_owner_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Alibaba Cloud account ID to which the source instance belongs.
        """
        return pulumi.get(self, "source_endpoint_owner_id")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPassword")
    def source_endpoint_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of database account.
        """
        return pulumi.get(self, "source_endpoint_password")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPort")
    def source_endpoint_port(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The port of source endpoint.
        """
        return pulumi.get(self, "source_endpoint_port")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region of source instance.
        """
        return pulumi.get(self, "source_endpoint_region")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointRole")
    def source_endpoint_role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the role configured for the cloud account to which the source instance belongs.
        """
        return pulumi.get(self, "source_endpoint_role")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointUserName")
    def source_endpoint_user_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The username of database account.
        """
        return pulumi.get(self, "source_endpoint_user_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource. Valid values: `Migrating`, `Suspending`. You can suspend the task by specifying `Suspending` and start the task by specifying `Migrating`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="structureInitialization")
    def structure_initialization(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to perform a database table structure to migrate.
        """
        return pulumi.get(self, "structure_initialization")

