# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SubscriptionJobArgs', 'SubscriptionJob']

@pulumi.input_type
class SubscriptionJobArgs:
    def __init__(__self__, *,
                 payment_type: pulumi.Input[_builtins.str],
                 source_endpoint_engine_name: pulumi.Input[_builtins.str],
                 source_endpoint_instance_type: pulumi.Input[_builtins.str],
                 source_endpoint_region: pulumi.Input[_builtins.str],
                 checkpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_unit: Optional[pulumi.Input[_builtins.int]] = None,
                 database_count: Optional[pulumi.Input[_builtins.int]] = None,
                 db_list: Optional[pulumi.Input[_builtins.str]] = None,
                 delay_notice: Optional[pulumi.Input[_builtins.bool]] = None,
                 delay_phone: Optional[pulumi.Input[_builtins.str]] = None,
                 delay_rule_time: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_region: Optional[pulumi.Input[_builtins.str]] = None,
                 dts_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dts_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 error_notice: Optional[pulumi.Input[_builtins.bool]] = None,
                 error_phone: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 reserve: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_port: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_role: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_data_type_ddl: Optional[pulumi.Input[_builtins.bool]] = None,
                 subscription_data_type_dml: Optional[pulumi.Input[_builtins.bool]] = None,
                 subscription_instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_instance_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_instance_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 synchronization_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SubscriptionJob resource.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] source_endpoint_engine_name: The source database type value is MySQL or Oracle. Valid values: `MySQL`, `Oracle`.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_type: The type of source instance. Valid values: `RDS`, `PolarDB`, `DRDS`, `LocalInstance`, `ECS`, `Express`, `CEN`, `dg`.
        :param pulumi.Input[_builtins.str] source_endpoint_region: The region of source database.
        :param pulumi.Input[_builtins.str] checkpoint: Subscription start time in Unix timestamp format.
        :param pulumi.Input[_builtins.int] compute_unit: [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        :param pulumi.Input[_builtins.int] database_count: The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        :param pulumi.Input[_builtins.str] db_list: Subscription object, in the format of JSON strings. For detailed definitions, please refer to the description of migration, synchronization or subscription objects [document](https://help.aliyun.com/document_detail/209545.html).
        :param pulumi.Input[_builtins.bool] delay_notice: This parameter decides whether to monitor the delay status. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] delay_phone: The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        :param pulumi.Input[_builtins.str] delay_rule_time: When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
        :param pulumi.Input[_builtins.str] destination_endpoint_engine_name: The destination endpoint engine name. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`.
        :param pulumi.Input[_builtins.str] destination_region: The destination region. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        :param pulumi.Input[_builtins.str] dts_instance_id: The ID of subscription instance.
        :param pulumi.Input[_builtins.str] dts_job_name: The name of subscription task.
        :param pulumi.Input[_builtins.bool] error_notice: This parameter decides whether to monitor abnormal status. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] error_phone: The mobile phone number of the contact for abnormal alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        :param pulumi.Input[_builtins.str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
        :param pulumi.Input[_builtins.int] payment_duration: The duration of prepaid instance purchase. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        :param pulumi.Input[_builtins.str] payment_duration_unit: The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        :param pulumi.Input[_builtins.str] reserve: DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter description of the [Reserve parameter](https://help.aliyun.com/document_detail/176470.html).
        :param pulumi.Input[_builtins.str] source_endpoint_database_name: To subscribe to the name of the database.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_id: The ID of source instance. Only when the type of source database instance was RDS MySQL, PolarDB-X 1.0, PolarDB MySQL, this parameter can be available and must be set.
        :param pulumi.Input[_builtins.str] source_endpoint_ip: The IP of source endpoint.
        :param pulumi.Input[_builtins.str] source_endpoint_oracle_sid: The SID of Oracle Database. When the source database is self-built Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        :param pulumi.Input[_builtins.str] source_endpoint_owner_id: The Alibaba Cloud account ID to which the source instance belongs. This parameter is only available when configuring data subscriptions across Alibaba Cloud accounts and must be passed in.
        :param pulumi.Input[_builtins.str] source_endpoint_password: The password of source database instance account.
        :param pulumi.Input[_builtins.str] source_endpoint_port: The port of source database.
        :param pulumi.Input[_builtins.str] source_endpoint_role: Both the authorization roles. When the source instance and configure subscriptions task of the Alibaba Cloud account is not the same as the need to pass the parameter, to specify the source of the authorization roles, to allow configuration subscription task of the Alibaba Cloud account to access the source of the source instance information.
        :param pulumi.Input[_builtins.str] source_endpoint_user_name: The username of source database instance account.
        :param pulumi.Input[_builtins.str] status: The status of the task. Valid values: `Normal`, `Abnormal`. When a task created, it is in this state of `NotStarted`. You can specify this state to `Normal` to start the job, and specify this state of `Abnormal` to stop the job. **Note: We treat the state `Starting` as the state of `Normal`, and consider the two states to be consistent on the user side.**
        :param pulumi.Input[_builtins.bool] subscription_data_type_ddl: Whether to subscribe the DDL type of data. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] subscription_data_type_dml: Whether to subscribe the DML type of data. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] subscription_instance_network_type: Subscription task type of network value: classic: classic Network. Virtual Private Cloud (vpc): a vpc. Valid values: `classic`, `vpc`.
        :param pulumi.Input[_builtins.str] subscription_instance_vpc_id: The ID of subscription vpc instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
        :param pulumi.Input[_builtins.str] subscription_instance_vswitch_id: The ID of subscription VSwitch instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
        :param pulumi.Input[_builtins.str] sync_architecture: The sync architecture. Valid values: `bidirectional`, `oneway`.
        :param pulumi.Input[_builtins.str] synchronization_direction: The synchronization direction. Valid values: `Forward`, `Reverse`. When the topology type of the data synchronization instance is bidirectional, it can be passed in to reverse to start the reverse synchronization link.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "source_endpoint_engine_name", source_endpoint_engine_name)
        pulumi.set(__self__, "source_endpoint_instance_type", source_endpoint_instance_type)
        pulumi.set(__self__, "source_endpoint_region", source_endpoint_region)
        if checkpoint is not None:
            pulumi.set(__self__, "checkpoint", checkpoint)
        if compute_unit is not None:
            pulumi.set(__self__, "compute_unit", compute_unit)
        if database_count is not None:
            pulumi.set(__self__, "database_count", database_count)
        if db_list is not None:
            pulumi.set(__self__, "db_list", db_list)
        if delay_notice is not None:
            pulumi.set(__self__, "delay_notice", delay_notice)
        if delay_phone is not None:
            pulumi.set(__self__, "delay_phone", delay_phone)
        if delay_rule_time is not None:
            pulumi.set(__self__, "delay_rule_time", delay_rule_time)
        if destination_endpoint_engine_name is not None:
            pulumi.set(__self__, "destination_endpoint_engine_name", destination_endpoint_engine_name)
        if destination_region is not None:
            pulumi.set(__self__, "destination_region", destination_region)
        if dts_instance_id is not None:
            pulumi.set(__self__, "dts_instance_id", dts_instance_id)
        if dts_job_name is not None:
            pulumi.set(__self__, "dts_job_name", dts_job_name)
        if error_notice is not None:
            pulumi.set(__self__, "error_notice", error_notice)
        if error_phone is not None:
            pulumi.set(__self__, "error_phone", error_phone)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if payment_duration is not None:
            pulumi.set(__self__, "payment_duration", payment_duration)
        if payment_duration_unit is not None:
            pulumi.set(__self__, "payment_duration_unit", payment_duration_unit)
        if reserve is not None:
            pulumi.set(__self__, "reserve", reserve)
        if source_endpoint_database_name is not None:
            pulumi.set(__self__, "source_endpoint_database_name", source_endpoint_database_name)
        if source_endpoint_instance_id is not None:
            pulumi.set(__self__, "source_endpoint_instance_id", source_endpoint_instance_id)
        if source_endpoint_ip is not None:
            pulumi.set(__self__, "source_endpoint_ip", source_endpoint_ip)
        if source_endpoint_oracle_sid is not None:
            pulumi.set(__self__, "source_endpoint_oracle_sid", source_endpoint_oracle_sid)
        if source_endpoint_owner_id is not None:
            pulumi.set(__self__, "source_endpoint_owner_id", source_endpoint_owner_id)
        if source_endpoint_password is not None:
            pulumi.set(__self__, "source_endpoint_password", source_endpoint_password)
        if source_endpoint_port is not None:
            pulumi.set(__self__, "source_endpoint_port", source_endpoint_port)
        if source_endpoint_role is not None:
            pulumi.set(__self__, "source_endpoint_role", source_endpoint_role)
        if source_endpoint_user_name is not None:
            pulumi.set(__self__, "source_endpoint_user_name", source_endpoint_user_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subscription_data_type_ddl is not None:
            pulumi.set(__self__, "subscription_data_type_ddl", subscription_data_type_ddl)
        if subscription_data_type_dml is not None:
            pulumi.set(__self__, "subscription_data_type_dml", subscription_data_type_dml)
        if subscription_instance_network_type is not None:
            pulumi.set(__self__, "subscription_instance_network_type", subscription_instance_network_type)
        if subscription_instance_vpc_id is not None:
            pulumi.set(__self__, "subscription_instance_vpc_id", subscription_instance_vpc_id)
        if subscription_instance_vswitch_id is not None:
            pulumi.set(__self__, "subscription_instance_vswitch_id", subscription_instance_vswitch_id)
        if sync_architecture is not None:
            pulumi.set(__self__, "sync_architecture", sync_architecture)
        if synchronization_direction is not None:
            pulumi.set(__self__, "synchronization_direction", synchronization_direction)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> pulumi.Input[_builtins.str]:
        """
        The source database type value is MySQL or Oracle. Valid values: `MySQL`, `Oracle`.
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @source_endpoint_engine_name.setter
    def source_endpoint_engine_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_endpoint_engine_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceType")
    def source_endpoint_instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of source instance. Valid values: `RDS`, `PolarDB`, `DRDS`, `LocalInstance`, `ECS`, `Express`, `CEN`, `dg`.
        """
        return pulumi.get(self, "source_endpoint_instance_type")

    @source_endpoint_instance_type.setter
    def source_endpoint_instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_endpoint_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> pulumi.Input[_builtins.str]:
        """
        The region of source database.
        """
        return pulumi.get(self, "source_endpoint_region")

    @source_endpoint_region.setter
    def source_endpoint_region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_endpoint_region", value)

    @_builtins.property
    @pulumi.getter
    def checkpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subscription start time in Unix timestamp format.
        """
        return pulumi.get(self, "checkpoint")

    @checkpoint.setter
    def checkpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checkpoint", value)

    @_builtins.property
    @pulumi.getter(name="computeUnit")
    def compute_unit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        """
        return pulumi.get(self, "compute_unit")

    @compute_unit.setter
    def compute_unit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "compute_unit", value)

    @_builtins.property
    @pulumi.getter(name="databaseCount")
    def database_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        """
        return pulumi.get(self, "database_count")

    @database_count.setter
    def database_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "database_count", value)

    @_builtins.property
    @pulumi.getter(name="dbList")
    def db_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subscription object, in the format of JSON strings. For detailed definitions, please refer to the description of migration, synchronization or subscription objects [document](https://help.aliyun.com/document_detail/209545.html).
        """
        return pulumi.get(self, "db_list")

    @db_list.setter
    def db_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_list", value)

    @_builtins.property
    @pulumi.getter(name="delayNotice")
    def delay_notice(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This parameter decides whether to monitor the delay status. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "delay_notice")

    @delay_notice.setter
    def delay_notice(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delay_notice", value)

    @_builtins.property
    @pulumi.getter(name="delayPhone")
    def delay_phone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        """
        return pulumi.get(self, "delay_phone")

    @delay_phone.setter
    def delay_phone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delay_phone", value)

    @_builtins.property
    @pulumi.getter(name="delayRuleTime")
    def delay_rule_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
        """
        return pulumi.get(self, "delay_rule_time")

    @delay_rule_time.setter
    def delay_rule_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delay_rule_time", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination endpoint engine name. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`.
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @destination_endpoint_engine_name.setter
    def destination_endpoint_engine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_engine_name", value)

    @_builtins.property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination region. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        """
        return pulumi.get(self, "destination_region")

    @destination_region.setter
    def destination_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_region", value)

    @_builtins.property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of subscription instance.
        """
        return pulumi.get(self, "dts_instance_id")

    @dts_instance_id.setter
    def dts_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dts_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="dtsJobName")
    def dts_job_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of subscription task.
        """
        return pulumi.get(self, "dts_job_name")

    @dts_job_name.setter
    def dts_job_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dts_job_name", value)

    @_builtins.property
    @pulumi.getter(name="errorNotice")
    def error_notice(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This parameter decides whether to monitor abnormal status. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "error_notice")

    @error_notice.setter
    def error_notice(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "error_notice", value)

    @_builtins.property
    @pulumi.getter(name="errorPhone")
    def error_phone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mobile phone number of the contact for abnormal alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        """
        return pulumi.get(self, "error_phone")

    @error_phone.setter
    def error_phone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_phone", value)

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_class", value)

    @_builtins.property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration of prepaid instance purchase. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        """
        return pulumi.get(self, "payment_duration")

    @payment_duration.setter
    def payment_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "payment_duration", value)

    @_builtins.property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        """
        return pulumi.get(self, "payment_duration_unit")

    @payment_duration_unit.setter
    def payment_duration_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_duration_unit", value)

    @_builtins.property
    @pulumi.getter
    def reserve(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter description of the [Reserve parameter](https://help.aliyun.com/document_detail/176470.html).
        """
        return pulumi.get(self, "reserve")

    @reserve.setter
    def reserve(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserve", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointDatabaseName")
    def source_endpoint_database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To subscribe to the name of the database.
        """
        return pulumi.get(self, "source_endpoint_database_name")

    @source_endpoint_database_name.setter
    def source_endpoint_database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_database_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceId")
    def source_endpoint_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of source instance. Only when the type of source database instance was RDS MySQL, PolarDB-X 1.0, PolarDB MySQL, this parameter can be available and must be set.
        """
        return pulumi.get(self, "source_endpoint_instance_id")

    @source_endpoint_instance_id.setter
    def source_endpoint_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointIp")
    def source_endpoint_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP of source endpoint.
        """
        return pulumi.get(self, "source_endpoint_ip")

    @source_endpoint_ip.setter
    def source_endpoint_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_ip", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointOracleSid")
    def source_endpoint_oracle_sid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SID of Oracle Database. When the source database is self-built Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_oracle_sid")

    @source_endpoint_oracle_sid.setter
    def source_endpoint_oracle_sid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_oracle_sid", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointOwnerId")
    def source_endpoint_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Alibaba Cloud account ID to which the source instance belongs. This parameter is only available when configuring data subscriptions across Alibaba Cloud accounts and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_owner_id")

    @source_endpoint_owner_id.setter
    def source_endpoint_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPassword")
    def source_endpoint_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of source database instance account.
        """
        return pulumi.get(self, "source_endpoint_password")

    @source_endpoint_password.setter
    def source_endpoint_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_password", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPort")
    def source_endpoint_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port of source database.
        """
        return pulumi.get(self, "source_endpoint_port")

    @source_endpoint_port.setter
    def source_endpoint_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_port", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointRole")
    def source_endpoint_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Both the authorization roles. When the source instance and configure subscriptions task of the Alibaba Cloud account is not the same as the need to pass the parameter, to specify the source of the authorization roles, to allow configuration subscription task of the Alibaba Cloud account to access the source of the source instance information.
        """
        return pulumi.get(self, "source_endpoint_role")

    @source_endpoint_role.setter
    def source_endpoint_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_role", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointUserName")
    def source_endpoint_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of source database instance account.
        """
        return pulumi.get(self, "source_endpoint_user_name")

    @source_endpoint_user_name.setter
    def source_endpoint_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_user_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the task. Valid values: `Normal`, `Abnormal`. When a task created, it is in this state of `NotStarted`. You can specify this state to `Normal` to start the job, and specify this state of `Abnormal` to stop the job. **Note: We treat the state `Starting` as the state of `Normal`, and consider the two states to be consistent on the user side.**
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionDataTypeDdl")
    def subscription_data_type_ddl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to subscribe the DDL type of data. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "subscription_data_type_ddl")

    @subscription_data_type_ddl.setter
    def subscription_data_type_ddl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "subscription_data_type_ddl", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionDataTypeDml")
    def subscription_data_type_dml(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to subscribe the DML type of data. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "subscription_data_type_dml")

    @subscription_data_type_dml.setter
    def subscription_data_type_dml(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "subscription_data_type_dml", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionInstanceNetworkType")
    def subscription_instance_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subscription task type of network value: classic: classic Network. Virtual Private Cloud (vpc): a vpc. Valid values: `classic`, `vpc`.
        """
        return pulumi.get(self, "subscription_instance_network_type")

    @subscription_instance_network_type.setter
    def subscription_instance_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_instance_network_type", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionInstanceVpcId")
    def subscription_instance_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of subscription vpc instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "subscription_instance_vpc_id")

    @subscription_instance_vpc_id.setter
    def subscription_instance_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_instance_vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionInstanceVswitchId")
    def subscription_instance_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of subscription VSwitch instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "subscription_instance_vswitch_id")

    @subscription_instance_vswitch_id.setter
    def subscription_instance_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_instance_vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="syncArchitecture")
    def sync_architecture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sync architecture. Valid values: `bidirectional`, `oneway`.
        """
        return pulumi.get(self, "sync_architecture")

    @sync_architecture.setter
    def sync_architecture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_architecture", value)

    @_builtins.property
    @pulumi.getter(name="synchronizationDirection")
    def synchronization_direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The synchronization direction. Valid values: `Forward`, `Reverse`. When the topology type of the data synchronization instance is bidirectional, it can be passed in to reverse to start the reverse synchronization link.
        """
        return pulumi.get(self, "synchronization_direction")

    @synchronization_direction.setter
    def synchronization_direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "synchronization_direction", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SubscriptionJobState:
    def __init__(__self__, *,
                 checkpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_unit: Optional[pulumi.Input[_builtins.int]] = None,
                 database_count: Optional[pulumi.Input[_builtins.int]] = None,
                 db_list: Optional[pulumi.Input[_builtins.str]] = None,
                 delay_notice: Optional[pulumi.Input[_builtins.bool]] = None,
                 delay_phone: Optional[pulumi.Input[_builtins.str]] = None,
                 delay_rule_time: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_region: Optional[pulumi.Input[_builtins.str]] = None,
                 dts_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dts_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 error_notice: Optional[pulumi.Input[_builtins.bool]] = None,
                 error_phone: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 reserve: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_port: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_role: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_data_type_ddl: Optional[pulumi.Input[_builtins.bool]] = None,
                 subscription_data_type_dml: Optional[pulumi.Input[_builtins.bool]] = None,
                 subscription_instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_instance_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_instance_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 synchronization_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SubscriptionJob resources.
        :param pulumi.Input[_builtins.str] checkpoint: Subscription start time in Unix timestamp format.
        :param pulumi.Input[_builtins.int] compute_unit: [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        :param pulumi.Input[_builtins.int] database_count: The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        :param pulumi.Input[_builtins.str] db_list: Subscription object, in the format of JSON strings. For detailed definitions, please refer to the description of migration, synchronization or subscription objects [document](https://help.aliyun.com/document_detail/209545.html).
        :param pulumi.Input[_builtins.bool] delay_notice: This parameter decides whether to monitor the delay status. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] delay_phone: The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        :param pulumi.Input[_builtins.str] delay_rule_time: When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
        :param pulumi.Input[_builtins.str] destination_endpoint_engine_name: The destination endpoint engine name. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`.
        :param pulumi.Input[_builtins.str] destination_region: The destination region. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        :param pulumi.Input[_builtins.str] dts_instance_id: The ID of subscription instance.
        :param pulumi.Input[_builtins.str] dts_job_name: The name of subscription task.
        :param pulumi.Input[_builtins.bool] error_notice: This parameter decides whether to monitor abnormal status. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] error_phone: The mobile phone number of the contact for abnormal alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        :param pulumi.Input[_builtins.str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
        :param pulumi.Input[_builtins.int] payment_duration: The duration of prepaid instance purchase. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        :param pulumi.Input[_builtins.str] payment_duration_unit: The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] reserve: DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter description of the [Reserve parameter](https://help.aliyun.com/document_detail/176470.html).
        :param pulumi.Input[_builtins.str] source_endpoint_database_name: To subscribe to the name of the database.
        :param pulumi.Input[_builtins.str] source_endpoint_engine_name: The source database type value is MySQL or Oracle. Valid values: `MySQL`, `Oracle`.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_id: The ID of source instance. Only when the type of source database instance was RDS MySQL, PolarDB-X 1.0, PolarDB MySQL, this parameter can be available and must be set.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_type: The type of source instance. Valid values: `RDS`, `PolarDB`, `DRDS`, `LocalInstance`, `ECS`, `Express`, `CEN`, `dg`.
        :param pulumi.Input[_builtins.str] source_endpoint_ip: The IP of source endpoint.
        :param pulumi.Input[_builtins.str] source_endpoint_oracle_sid: The SID of Oracle Database. When the source database is self-built Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        :param pulumi.Input[_builtins.str] source_endpoint_owner_id: The Alibaba Cloud account ID to which the source instance belongs. This parameter is only available when configuring data subscriptions across Alibaba Cloud accounts and must be passed in.
        :param pulumi.Input[_builtins.str] source_endpoint_password: The password of source database instance account.
        :param pulumi.Input[_builtins.str] source_endpoint_port: The port of source database.
        :param pulumi.Input[_builtins.str] source_endpoint_region: The region of source database.
        :param pulumi.Input[_builtins.str] source_endpoint_role: Both the authorization roles. When the source instance and configure subscriptions task of the Alibaba Cloud account is not the same as the need to pass the parameter, to specify the source of the authorization roles, to allow configuration subscription task of the Alibaba Cloud account to access the source of the source instance information.
        :param pulumi.Input[_builtins.str] source_endpoint_user_name: The username of source database instance account.
        :param pulumi.Input[_builtins.str] status: The status of the task. Valid values: `Normal`, `Abnormal`. When a task created, it is in this state of `NotStarted`. You can specify this state to `Normal` to start the job, and specify this state of `Abnormal` to stop the job. **Note: We treat the state `Starting` as the state of `Normal`, and consider the two states to be consistent on the user side.**
        :param pulumi.Input[_builtins.bool] subscription_data_type_ddl: Whether to subscribe the DDL type of data. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] subscription_data_type_dml: Whether to subscribe the DML type of data. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] subscription_instance_network_type: Subscription task type of network value: classic: classic Network. Virtual Private Cloud (vpc): a vpc. Valid values: `classic`, `vpc`.
        :param pulumi.Input[_builtins.str] subscription_instance_vpc_id: The ID of subscription vpc instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
        :param pulumi.Input[_builtins.str] subscription_instance_vswitch_id: The ID of subscription VSwitch instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
        :param pulumi.Input[_builtins.str] sync_architecture: The sync architecture. Valid values: `bidirectional`, `oneway`.
        :param pulumi.Input[_builtins.str] synchronization_direction: The synchronization direction. Valid values: `Forward`, `Reverse`. When the topology type of the data synchronization instance is bidirectional, it can be passed in to reverse to start the reverse synchronization link.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if checkpoint is not None:
            pulumi.set(__self__, "checkpoint", checkpoint)
        if compute_unit is not None:
            pulumi.set(__self__, "compute_unit", compute_unit)
        if database_count is not None:
            pulumi.set(__self__, "database_count", database_count)
        if db_list is not None:
            pulumi.set(__self__, "db_list", db_list)
        if delay_notice is not None:
            pulumi.set(__self__, "delay_notice", delay_notice)
        if delay_phone is not None:
            pulumi.set(__self__, "delay_phone", delay_phone)
        if delay_rule_time is not None:
            pulumi.set(__self__, "delay_rule_time", delay_rule_time)
        if destination_endpoint_engine_name is not None:
            pulumi.set(__self__, "destination_endpoint_engine_name", destination_endpoint_engine_name)
        if destination_region is not None:
            pulumi.set(__self__, "destination_region", destination_region)
        if dts_instance_id is not None:
            pulumi.set(__self__, "dts_instance_id", dts_instance_id)
        if dts_job_name is not None:
            pulumi.set(__self__, "dts_job_name", dts_job_name)
        if error_notice is not None:
            pulumi.set(__self__, "error_notice", error_notice)
        if error_phone is not None:
            pulumi.set(__self__, "error_phone", error_phone)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if payment_duration is not None:
            pulumi.set(__self__, "payment_duration", payment_duration)
        if payment_duration_unit is not None:
            pulumi.set(__self__, "payment_duration_unit", payment_duration_unit)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if reserve is not None:
            pulumi.set(__self__, "reserve", reserve)
        if source_endpoint_database_name is not None:
            pulumi.set(__self__, "source_endpoint_database_name", source_endpoint_database_name)
        if source_endpoint_engine_name is not None:
            pulumi.set(__self__, "source_endpoint_engine_name", source_endpoint_engine_name)
        if source_endpoint_instance_id is not None:
            pulumi.set(__self__, "source_endpoint_instance_id", source_endpoint_instance_id)
        if source_endpoint_instance_type is not None:
            pulumi.set(__self__, "source_endpoint_instance_type", source_endpoint_instance_type)
        if source_endpoint_ip is not None:
            pulumi.set(__self__, "source_endpoint_ip", source_endpoint_ip)
        if source_endpoint_oracle_sid is not None:
            pulumi.set(__self__, "source_endpoint_oracle_sid", source_endpoint_oracle_sid)
        if source_endpoint_owner_id is not None:
            pulumi.set(__self__, "source_endpoint_owner_id", source_endpoint_owner_id)
        if source_endpoint_password is not None:
            pulumi.set(__self__, "source_endpoint_password", source_endpoint_password)
        if source_endpoint_port is not None:
            pulumi.set(__self__, "source_endpoint_port", source_endpoint_port)
        if source_endpoint_region is not None:
            pulumi.set(__self__, "source_endpoint_region", source_endpoint_region)
        if source_endpoint_role is not None:
            pulumi.set(__self__, "source_endpoint_role", source_endpoint_role)
        if source_endpoint_user_name is not None:
            pulumi.set(__self__, "source_endpoint_user_name", source_endpoint_user_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subscription_data_type_ddl is not None:
            pulumi.set(__self__, "subscription_data_type_ddl", subscription_data_type_ddl)
        if subscription_data_type_dml is not None:
            pulumi.set(__self__, "subscription_data_type_dml", subscription_data_type_dml)
        if subscription_instance_network_type is not None:
            pulumi.set(__self__, "subscription_instance_network_type", subscription_instance_network_type)
        if subscription_instance_vpc_id is not None:
            pulumi.set(__self__, "subscription_instance_vpc_id", subscription_instance_vpc_id)
        if subscription_instance_vswitch_id is not None:
            pulumi.set(__self__, "subscription_instance_vswitch_id", subscription_instance_vswitch_id)
        if sync_architecture is not None:
            pulumi.set(__self__, "sync_architecture", sync_architecture)
        if synchronization_direction is not None:
            pulumi.set(__self__, "synchronization_direction", synchronization_direction)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def checkpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subscription start time in Unix timestamp format.
        """
        return pulumi.get(self, "checkpoint")

    @checkpoint.setter
    def checkpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checkpoint", value)

    @_builtins.property
    @pulumi.getter(name="computeUnit")
    def compute_unit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        """
        return pulumi.get(self, "compute_unit")

    @compute_unit.setter
    def compute_unit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "compute_unit", value)

    @_builtins.property
    @pulumi.getter(name="databaseCount")
    def database_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        """
        return pulumi.get(self, "database_count")

    @database_count.setter
    def database_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "database_count", value)

    @_builtins.property
    @pulumi.getter(name="dbList")
    def db_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subscription object, in the format of JSON strings. For detailed definitions, please refer to the description of migration, synchronization or subscription objects [document](https://help.aliyun.com/document_detail/209545.html).
        """
        return pulumi.get(self, "db_list")

    @db_list.setter
    def db_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_list", value)

    @_builtins.property
    @pulumi.getter(name="delayNotice")
    def delay_notice(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This parameter decides whether to monitor the delay status. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "delay_notice")

    @delay_notice.setter
    def delay_notice(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delay_notice", value)

    @_builtins.property
    @pulumi.getter(name="delayPhone")
    def delay_phone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        """
        return pulumi.get(self, "delay_phone")

    @delay_phone.setter
    def delay_phone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delay_phone", value)

    @_builtins.property
    @pulumi.getter(name="delayRuleTime")
    def delay_rule_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
        """
        return pulumi.get(self, "delay_rule_time")

    @delay_rule_time.setter
    def delay_rule_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delay_rule_time", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination endpoint engine name. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`.
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @destination_endpoint_engine_name.setter
    def destination_endpoint_engine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_engine_name", value)

    @_builtins.property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination region. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        """
        return pulumi.get(self, "destination_region")

    @destination_region.setter
    def destination_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_region", value)

    @_builtins.property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of subscription instance.
        """
        return pulumi.get(self, "dts_instance_id")

    @dts_instance_id.setter
    def dts_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dts_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="dtsJobName")
    def dts_job_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of subscription task.
        """
        return pulumi.get(self, "dts_job_name")

    @dts_job_name.setter
    def dts_job_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dts_job_name", value)

    @_builtins.property
    @pulumi.getter(name="errorNotice")
    def error_notice(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This parameter decides whether to monitor abnormal status. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "error_notice")

    @error_notice.setter
    def error_notice(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "error_notice", value)

    @_builtins.property
    @pulumi.getter(name="errorPhone")
    def error_phone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mobile phone number of the contact for abnormal alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        """
        return pulumi.get(self, "error_phone")

    @error_phone.setter
    def error_phone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_phone", value)

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_class", value)

    @_builtins.property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration of prepaid instance purchase. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        """
        return pulumi.get(self, "payment_duration")

    @payment_duration.setter
    def payment_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "payment_duration", value)

    @_builtins.property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        """
        return pulumi.get(self, "payment_duration_unit")

    @payment_duration_unit.setter
    def payment_duration_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_duration_unit", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def reserve(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter description of the [Reserve parameter](https://help.aliyun.com/document_detail/176470.html).
        """
        return pulumi.get(self, "reserve")

    @reserve.setter
    def reserve(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserve", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointDatabaseName")
    def source_endpoint_database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To subscribe to the name of the database.
        """
        return pulumi.get(self, "source_endpoint_database_name")

    @source_endpoint_database_name.setter
    def source_endpoint_database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_database_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source database type value is MySQL or Oracle. Valid values: `MySQL`, `Oracle`.
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @source_endpoint_engine_name.setter
    def source_endpoint_engine_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_engine_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceId")
    def source_endpoint_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of source instance. Only when the type of source database instance was RDS MySQL, PolarDB-X 1.0, PolarDB MySQL, this parameter can be available and must be set.
        """
        return pulumi.get(self, "source_endpoint_instance_id")

    @source_endpoint_instance_id.setter
    def source_endpoint_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceType")
    def source_endpoint_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of source instance. Valid values: `RDS`, `PolarDB`, `DRDS`, `LocalInstance`, `ECS`, `Express`, `CEN`, `dg`.
        """
        return pulumi.get(self, "source_endpoint_instance_type")

    @source_endpoint_instance_type.setter
    def source_endpoint_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointIp")
    def source_endpoint_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP of source endpoint.
        """
        return pulumi.get(self, "source_endpoint_ip")

    @source_endpoint_ip.setter
    def source_endpoint_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_ip", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointOracleSid")
    def source_endpoint_oracle_sid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SID of Oracle Database. When the source database is self-built Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_oracle_sid")

    @source_endpoint_oracle_sid.setter
    def source_endpoint_oracle_sid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_oracle_sid", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointOwnerId")
    def source_endpoint_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Alibaba Cloud account ID to which the source instance belongs. This parameter is only available when configuring data subscriptions across Alibaba Cloud accounts and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_owner_id")

    @source_endpoint_owner_id.setter
    def source_endpoint_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_owner_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPassword")
    def source_endpoint_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of source database instance account.
        """
        return pulumi.get(self, "source_endpoint_password")

    @source_endpoint_password.setter
    def source_endpoint_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_password", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPort")
    def source_endpoint_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port of source database.
        """
        return pulumi.get(self, "source_endpoint_port")

    @source_endpoint_port.setter
    def source_endpoint_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_port", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of source database.
        """
        return pulumi.get(self, "source_endpoint_region")

    @source_endpoint_region.setter
    def source_endpoint_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_region", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointRole")
    def source_endpoint_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Both the authorization roles. When the source instance and configure subscriptions task of the Alibaba Cloud account is not the same as the need to pass the parameter, to specify the source of the authorization roles, to allow configuration subscription task of the Alibaba Cloud account to access the source of the source instance information.
        """
        return pulumi.get(self, "source_endpoint_role")

    @source_endpoint_role.setter
    def source_endpoint_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_role", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointUserName")
    def source_endpoint_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of source database instance account.
        """
        return pulumi.get(self, "source_endpoint_user_name")

    @source_endpoint_user_name.setter
    def source_endpoint_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_user_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the task. Valid values: `Normal`, `Abnormal`. When a task created, it is in this state of `NotStarted`. You can specify this state to `Normal` to start the job, and specify this state of `Abnormal` to stop the job. **Note: We treat the state `Starting` as the state of `Normal`, and consider the two states to be consistent on the user side.**
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionDataTypeDdl")
    def subscription_data_type_ddl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to subscribe the DDL type of data. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "subscription_data_type_ddl")

    @subscription_data_type_ddl.setter
    def subscription_data_type_ddl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "subscription_data_type_ddl", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionDataTypeDml")
    def subscription_data_type_dml(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to subscribe the DML type of data. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "subscription_data_type_dml")

    @subscription_data_type_dml.setter
    def subscription_data_type_dml(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "subscription_data_type_dml", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionInstanceNetworkType")
    def subscription_instance_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subscription task type of network value: classic: classic Network. Virtual Private Cloud (vpc): a vpc. Valid values: `classic`, `vpc`.
        """
        return pulumi.get(self, "subscription_instance_network_type")

    @subscription_instance_network_type.setter
    def subscription_instance_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_instance_network_type", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionInstanceVpcId")
    def subscription_instance_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of subscription vpc instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "subscription_instance_vpc_id")

    @subscription_instance_vpc_id.setter
    def subscription_instance_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_instance_vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionInstanceVswitchId")
    def subscription_instance_vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of subscription VSwitch instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "subscription_instance_vswitch_id")

    @subscription_instance_vswitch_id.setter
    def subscription_instance_vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_instance_vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="syncArchitecture")
    def sync_architecture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sync architecture. Valid values: `bidirectional`, `oneway`.
        """
        return pulumi.get(self, "sync_architecture")

    @sync_architecture.setter
    def sync_architecture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_architecture", value)

    @_builtins.property
    @pulumi.getter(name="synchronizationDirection")
    def synchronization_direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The synchronization direction. Valid values: `Forward`, `Reverse`. When the topology type of the data synchronization instance is bidirectional, it can be passed in to reverse to start the reverse synchronization link.
        """
        return pulumi.get(self, "synchronization_direction")

    @synchronization_direction.setter
    def synchronization_direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "synchronization_direction", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:dts/subscriptionJob:SubscriptionJob")
class SubscriptionJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checkpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_unit: Optional[pulumi.Input[_builtins.int]] = None,
                 database_count: Optional[pulumi.Input[_builtins.int]] = None,
                 db_list: Optional[pulumi.Input[_builtins.str]] = None,
                 delay_notice: Optional[pulumi.Input[_builtins.bool]] = None,
                 delay_phone: Optional[pulumi.Input[_builtins.str]] = None,
                 delay_rule_time: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_region: Optional[pulumi.Input[_builtins.str]] = None,
                 dts_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dts_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 error_notice: Optional[pulumi.Input[_builtins.bool]] = None,
                 error_phone: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 reserve: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_port: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_role: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_data_type_ddl: Optional[pulumi.Input[_builtins.bool]] = None,
                 subscription_data_type_dml: Optional[pulumi.Input[_builtins.bool]] = None,
                 subscription_instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_instance_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_instance_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 synchronization_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a DTS Subscription Job resource.

        For information about DTS Subscription Job and how to use it, see [What is Subscription Job](https://www.alibabacloud.com/help/en/data-transmission-service/latest/configuresubscription).

        > **NOTE:** Available since v1.138.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.get_regions(current=True)
        example_get_zones = alicloud.rds.get_zones(engine="MySQL",
            engine_version="8.0",
            instance_charge_type="PostPaid",
            category="Basic",
            db_instance_storage_type="cloud_essd")
        example_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=example_get_zones.zones[0].id,
            engine="MySQL",
            engine_version="8.0",
            instance_charge_type="PostPaid",
            category="Basic",
            db_instance_storage_type="cloud_essd")
        example_network = alicloud.vpc.Network("example",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        example_switch = alicloud.vpc.Switch("example",
            vpc_id=example_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=example_get_zones.zones[0].id,
            vswitch_name=name)
        example_security_group = alicloud.ecs.SecurityGroup("example",
            name=name,
            vpc_id=example_network.id)
        example_instance = alicloud.rds.Instance("example",
            engine="MySQL",
            engine_version="8.0",
            instance_type=example_get_instance_classes.instance_classes[0].instance_class,
            instance_storage=example_get_instance_classes.instance_classes[0].storage_range.min,
            instance_charge_type="Postpaid",
            instance_name=name,
            vswitch_id=example_switch.id,
            monitoring_period=60,
            db_instance_storage_type="cloud_essd",
            security_group_ids=[example_security_group.id])
        example_rds_account = alicloud.rds.RdsAccount("example",
            db_instance_id=example_instance.id,
            account_name="test_mysql",
            account_password="N1cetest")
        example_database = alicloud.rds.Database("example",
            instance_id=example_instance.id,
            name=name)
        example_account_privilege = alicloud.rds.AccountPrivilege("example",
            instance_id=example_instance.id,
            account_name=example_rds_account.account_name,
            privilege="ReadWrite",
            db_names=[example_database.name])
        example_subscription_job = alicloud.dts.SubscriptionJob("example",
            dts_job_name=name,
            payment_type="PayAsYouGo",
            source_endpoint_engine_name="MySQL",
            source_endpoint_region=example.regions[0].id,
            source_endpoint_instance_type="RDS",
            source_endpoint_instance_id=example_instance.id,
            source_endpoint_database_name=example_database.name,
            source_endpoint_user_name=example_rds_account.account_name,
            source_endpoint_password=example_rds_account.account_password,
            db_list=pulumi.Output.json_dumps(pulumi.Output.all(
                exampleDatabaseName=example_database.name,
                exampleDatabaseName1=example_database.name
        ).apply(lambda resolved_outputs: {
                resolved_outputs['exampleDatabaseName']: {
                    "name": resolved_outputs['exampleDatabaseName1'],
                    "all": True,
                },
            })
        ),
            subscription_instance_network_type="vpc",
            subscription_instance_vpc_id=example_network.id,
            subscription_instance_vswitch_id=example_switch.id,
            status="Normal")
        ```

        ## Import

        DTS Subscription Job can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dts/subscriptionJob:SubscriptionJob example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] checkpoint: Subscription start time in Unix timestamp format.
        :param pulumi.Input[_builtins.int] compute_unit: [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        :param pulumi.Input[_builtins.int] database_count: The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        :param pulumi.Input[_builtins.str] db_list: Subscription object, in the format of JSON strings. For detailed definitions, please refer to the description of migration, synchronization or subscription objects [document](https://help.aliyun.com/document_detail/209545.html).
        :param pulumi.Input[_builtins.bool] delay_notice: This parameter decides whether to monitor the delay status. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] delay_phone: The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        :param pulumi.Input[_builtins.str] delay_rule_time: When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
        :param pulumi.Input[_builtins.str] destination_endpoint_engine_name: The destination endpoint engine name. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`.
        :param pulumi.Input[_builtins.str] destination_region: The destination region. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        :param pulumi.Input[_builtins.str] dts_instance_id: The ID of subscription instance.
        :param pulumi.Input[_builtins.str] dts_job_name: The name of subscription task.
        :param pulumi.Input[_builtins.bool] error_notice: This parameter decides whether to monitor abnormal status. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] error_phone: The mobile phone number of the contact for abnormal alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        :param pulumi.Input[_builtins.str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
        :param pulumi.Input[_builtins.int] payment_duration: The duration of prepaid instance purchase. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        :param pulumi.Input[_builtins.str] payment_duration_unit: The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] reserve: DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter description of the [Reserve parameter](https://help.aliyun.com/document_detail/176470.html).
        :param pulumi.Input[_builtins.str] source_endpoint_database_name: To subscribe to the name of the database.
        :param pulumi.Input[_builtins.str] source_endpoint_engine_name: The source database type value is MySQL or Oracle. Valid values: `MySQL`, `Oracle`.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_id: The ID of source instance. Only when the type of source database instance was RDS MySQL, PolarDB-X 1.0, PolarDB MySQL, this parameter can be available and must be set.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_type: The type of source instance. Valid values: `RDS`, `PolarDB`, `DRDS`, `LocalInstance`, `ECS`, `Express`, `CEN`, `dg`.
        :param pulumi.Input[_builtins.str] source_endpoint_ip: The IP of source endpoint.
        :param pulumi.Input[_builtins.str] source_endpoint_oracle_sid: The SID of Oracle Database. When the source database is self-built Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        :param pulumi.Input[_builtins.str] source_endpoint_owner_id: The Alibaba Cloud account ID to which the source instance belongs. This parameter is only available when configuring data subscriptions across Alibaba Cloud accounts and must be passed in.
        :param pulumi.Input[_builtins.str] source_endpoint_password: The password of source database instance account.
        :param pulumi.Input[_builtins.str] source_endpoint_port: The port of source database.
        :param pulumi.Input[_builtins.str] source_endpoint_region: The region of source database.
        :param pulumi.Input[_builtins.str] source_endpoint_role: Both the authorization roles. When the source instance and configure subscriptions task of the Alibaba Cloud account is not the same as the need to pass the parameter, to specify the source of the authorization roles, to allow configuration subscription task of the Alibaba Cloud account to access the source of the source instance information.
        :param pulumi.Input[_builtins.str] source_endpoint_user_name: The username of source database instance account.
        :param pulumi.Input[_builtins.str] status: The status of the task. Valid values: `Normal`, `Abnormal`. When a task created, it is in this state of `NotStarted`. You can specify this state to `Normal` to start the job, and specify this state of `Abnormal` to stop the job. **Note: We treat the state `Starting` as the state of `Normal`, and consider the two states to be consistent on the user side.**
        :param pulumi.Input[_builtins.bool] subscription_data_type_ddl: Whether to subscribe the DDL type of data. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] subscription_data_type_dml: Whether to subscribe the DML type of data. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] subscription_instance_network_type: Subscription task type of network value: classic: classic Network. Virtual Private Cloud (vpc): a vpc. Valid values: `classic`, `vpc`.
        :param pulumi.Input[_builtins.str] subscription_instance_vpc_id: The ID of subscription vpc instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
        :param pulumi.Input[_builtins.str] subscription_instance_vswitch_id: The ID of subscription VSwitch instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
        :param pulumi.Input[_builtins.str] sync_architecture: The sync architecture. Valid values: `bidirectional`, `oneway`.
        :param pulumi.Input[_builtins.str] synchronization_direction: The synchronization direction. Valid values: `Forward`, `Reverse`. When the topology type of the data synchronization instance is bidirectional, it can be passed in to reverse to start the reverse synchronization link.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubscriptionJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DTS Subscription Job resource.

        For information about DTS Subscription Job and how to use it, see [What is Subscription Job](https://www.alibabacloud.com/help/en/data-transmission-service/latest/configuresubscription).

        > **NOTE:** Available since v1.138.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.get_regions(current=True)
        example_get_zones = alicloud.rds.get_zones(engine="MySQL",
            engine_version="8.0",
            instance_charge_type="PostPaid",
            category="Basic",
            db_instance_storage_type="cloud_essd")
        example_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=example_get_zones.zones[0].id,
            engine="MySQL",
            engine_version="8.0",
            instance_charge_type="PostPaid",
            category="Basic",
            db_instance_storage_type="cloud_essd")
        example_network = alicloud.vpc.Network("example",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        example_switch = alicloud.vpc.Switch("example",
            vpc_id=example_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=example_get_zones.zones[0].id,
            vswitch_name=name)
        example_security_group = alicloud.ecs.SecurityGroup("example",
            name=name,
            vpc_id=example_network.id)
        example_instance = alicloud.rds.Instance("example",
            engine="MySQL",
            engine_version="8.0",
            instance_type=example_get_instance_classes.instance_classes[0].instance_class,
            instance_storage=example_get_instance_classes.instance_classes[0].storage_range.min,
            instance_charge_type="Postpaid",
            instance_name=name,
            vswitch_id=example_switch.id,
            monitoring_period=60,
            db_instance_storage_type="cloud_essd",
            security_group_ids=[example_security_group.id])
        example_rds_account = alicloud.rds.RdsAccount("example",
            db_instance_id=example_instance.id,
            account_name="test_mysql",
            account_password="N1cetest")
        example_database = alicloud.rds.Database("example",
            instance_id=example_instance.id,
            name=name)
        example_account_privilege = alicloud.rds.AccountPrivilege("example",
            instance_id=example_instance.id,
            account_name=example_rds_account.account_name,
            privilege="ReadWrite",
            db_names=[example_database.name])
        example_subscription_job = alicloud.dts.SubscriptionJob("example",
            dts_job_name=name,
            payment_type="PayAsYouGo",
            source_endpoint_engine_name="MySQL",
            source_endpoint_region=example.regions[0].id,
            source_endpoint_instance_type="RDS",
            source_endpoint_instance_id=example_instance.id,
            source_endpoint_database_name=example_database.name,
            source_endpoint_user_name=example_rds_account.account_name,
            source_endpoint_password=example_rds_account.account_password,
            db_list=pulumi.Output.json_dumps(pulumi.Output.all(
                exampleDatabaseName=example_database.name,
                exampleDatabaseName1=example_database.name
        ).apply(lambda resolved_outputs: {
                resolved_outputs['exampleDatabaseName']: {
                    "name": resolved_outputs['exampleDatabaseName1'],
                    "all": True,
                },
            })
        ),
            subscription_instance_network_type="vpc",
            subscription_instance_vpc_id=example_network.id,
            subscription_instance_vswitch_id=example_switch.id,
            status="Normal")
        ```

        ## Import

        DTS Subscription Job can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dts/subscriptionJob:SubscriptionJob example <id>
        ```

        :param str resource_name: The name of the resource.
        :param SubscriptionJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriptionJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checkpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_unit: Optional[pulumi.Input[_builtins.int]] = None,
                 database_count: Optional[pulumi.Input[_builtins.int]] = None,
                 db_list: Optional[pulumi.Input[_builtins.str]] = None,
                 delay_notice: Optional[pulumi.Input[_builtins.bool]] = None,
                 delay_phone: Optional[pulumi.Input[_builtins.str]] = None,
                 delay_rule_time: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_region: Optional[pulumi.Input[_builtins.str]] = None,
                 dts_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dts_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 error_notice: Optional[pulumi.Input[_builtins.bool]] = None,
                 error_phone: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 reserve: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_port: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_role: Optional[pulumi.Input[_builtins.str]] = None,
                 source_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_data_type_ddl: Optional[pulumi.Input[_builtins.bool]] = None,
                 subscription_data_type_dml: Optional[pulumi.Input[_builtins.bool]] = None,
                 subscription_instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_instance_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_instance_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 synchronization_direction: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriptionJobArgs.__new__(SubscriptionJobArgs)

            __props__.__dict__["checkpoint"] = checkpoint
            __props__.__dict__["compute_unit"] = compute_unit
            __props__.__dict__["database_count"] = database_count
            __props__.__dict__["db_list"] = db_list
            __props__.__dict__["delay_notice"] = delay_notice
            __props__.__dict__["delay_phone"] = delay_phone
            __props__.__dict__["delay_rule_time"] = delay_rule_time
            __props__.__dict__["destination_endpoint_engine_name"] = destination_endpoint_engine_name
            __props__.__dict__["destination_region"] = destination_region
            __props__.__dict__["dts_instance_id"] = dts_instance_id
            __props__.__dict__["dts_job_name"] = dts_job_name
            __props__.__dict__["error_notice"] = error_notice
            __props__.__dict__["error_phone"] = error_phone
            __props__.__dict__["instance_class"] = instance_class
            __props__.__dict__["payment_duration"] = payment_duration
            __props__.__dict__["payment_duration_unit"] = payment_duration_unit
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["reserve"] = reserve
            __props__.__dict__["source_endpoint_database_name"] = source_endpoint_database_name
            if source_endpoint_engine_name is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint_engine_name'")
            __props__.__dict__["source_endpoint_engine_name"] = source_endpoint_engine_name
            __props__.__dict__["source_endpoint_instance_id"] = source_endpoint_instance_id
            if source_endpoint_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint_instance_type'")
            __props__.__dict__["source_endpoint_instance_type"] = source_endpoint_instance_type
            __props__.__dict__["source_endpoint_ip"] = source_endpoint_ip
            __props__.__dict__["source_endpoint_oracle_sid"] = source_endpoint_oracle_sid
            __props__.__dict__["source_endpoint_owner_id"] = source_endpoint_owner_id
            __props__.__dict__["source_endpoint_password"] = source_endpoint_password
            __props__.__dict__["source_endpoint_port"] = source_endpoint_port
            if source_endpoint_region is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint_region'")
            __props__.__dict__["source_endpoint_region"] = source_endpoint_region
            __props__.__dict__["source_endpoint_role"] = source_endpoint_role
            __props__.__dict__["source_endpoint_user_name"] = source_endpoint_user_name
            __props__.__dict__["status"] = status
            __props__.__dict__["subscription_data_type_ddl"] = subscription_data_type_ddl
            __props__.__dict__["subscription_data_type_dml"] = subscription_data_type_dml
            __props__.__dict__["subscription_instance_network_type"] = subscription_instance_network_type
            __props__.__dict__["subscription_instance_vpc_id"] = subscription_instance_vpc_id
            __props__.__dict__["subscription_instance_vswitch_id"] = subscription_instance_vswitch_id
            __props__.__dict__["sync_architecture"] = sync_architecture
            __props__.__dict__["synchronization_direction"] = synchronization_direction
            __props__.__dict__["tags"] = tags
        super(SubscriptionJob, __self__).__init__(
            'alicloud:dts/subscriptionJob:SubscriptionJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            checkpoint: Optional[pulumi.Input[_builtins.str]] = None,
            compute_unit: Optional[pulumi.Input[_builtins.int]] = None,
            database_count: Optional[pulumi.Input[_builtins.int]] = None,
            db_list: Optional[pulumi.Input[_builtins.str]] = None,
            delay_notice: Optional[pulumi.Input[_builtins.bool]] = None,
            delay_phone: Optional[pulumi.Input[_builtins.str]] = None,
            delay_rule_time: Optional[pulumi.Input[_builtins.str]] = None,
            destination_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
            destination_region: Optional[pulumi.Input[_builtins.str]] = None,
            dts_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            dts_job_name: Optional[pulumi.Input[_builtins.str]] = None,
            error_notice: Optional[pulumi.Input[_builtins.bool]] = None,
            error_phone: Optional[pulumi.Input[_builtins.str]] = None,
            instance_class: Optional[pulumi.Input[_builtins.str]] = None,
            payment_duration: Optional[pulumi.Input[_builtins.int]] = None,
            payment_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            reserve: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_database_name: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_engine_name: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_ip: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_oracle_sid: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_password: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_port: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_region: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_role: Optional[pulumi.Input[_builtins.str]] = None,
            source_endpoint_user_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_data_type_ddl: Optional[pulumi.Input[_builtins.bool]] = None,
            subscription_data_type_dml: Optional[pulumi.Input[_builtins.bool]] = None,
            subscription_instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_instance_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_instance_vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            sync_architecture: Optional[pulumi.Input[_builtins.str]] = None,
            synchronization_direction: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'SubscriptionJob':
        """
        Get an existing SubscriptionJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] checkpoint: Subscription start time in Unix timestamp format.
        :param pulumi.Input[_builtins.int] compute_unit: [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        :param pulumi.Input[_builtins.int] database_count: The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        :param pulumi.Input[_builtins.str] db_list: Subscription object, in the format of JSON strings. For detailed definitions, please refer to the description of migration, synchronization or subscription objects [document](https://help.aliyun.com/document_detail/209545.html).
        :param pulumi.Input[_builtins.bool] delay_notice: This parameter decides whether to monitor the delay status. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] delay_phone: The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        :param pulumi.Input[_builtins.str] delay_rule_time: When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
        :param pulumi.Input[_builtins.str] destination_endpoint_engine_name: The destination endpoint engine name. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`.
        :param pulumi.Input[_builtins.str] destination_region: The destination region. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        :param pulumi.Input[_builtins.str] dts_instance_id: The ID of subscription instance.
        :param pulumi.Input[_builtins.str] dts_job_name: The name of subscription task.
        :param pulumi.Input[_builtins.bool] error_notice: This parameter decides whether to monitor abnormal status. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] error_phone: The mobile phone number of the contact for abnormal alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        :param pulumi.Input[_builtins.str] instance_class: The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
        :param pulumi.Input[_builtins.int] payment_duration: The duration of prepaid instance purchase. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        :param pulumi.Input[_builtins.str] payment_duration_unit: The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] reserve: DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter description of the [Reserve parameter](https://help.aliyun.com/document_detail/176470.html).
        :param pulumi.Input[_builtins.str] source_endpoint_database_name: To subscribe to the name of the database.
        :param pulumi.Input[_builtins.str] source_endpoint_engine_name: The source database type value is MySQL or Oracle. Valid values: `MySQL`, `Oracle`.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_id: The ID of source instance. Only when the type of source database instance was RDS MySQL, PolarDB-X 1.0, PolarDB MySQL, this parameter can be available and must be set.
        :param pulumi.Input[_builtins.str] source_endpoint_instance_type: The type of source instance. Valid values: `RDS`, `PolarDB`, `DRDS`, `LocalInstance`, `ECS`, `Express`, `CEN`, `dg`.
        :param pulumi.Input[_builtins.str] source_endpoint_ip: The IP of source endpoint.
        :param pulumi.Input[_builtins.str] source_endpoint_oracle_sid: The SID of Oracle Database. When the source database is self-built Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        :param pulumi.Input[_builtins.str] source_endpoint_owner_id: The Alibaba Cloud account ID to which the source instance belongs. This parameter is only available when configuring data subscriptions across Alibaba Cloud accounts and must be passed in.
        :param pulumi.Input[_builtins.str] source_endpoint_password: The password of source database instance account.
        :param pulumi.Input[_builtins.str] source_endpoint_port: The port of source database.
        :param pulumi.Input[_builtins.str] source_endpoint_region: The region of source database.
        :param pulumi.Input[_builtins.str] source_endpoint_role: Both the authorization roles. When the source instance and configure subscriptions task of the Alibaba Cloud account is not the same as the need to pass the parameter, to specify the source of the authorization roles, to allow configuration subscription task of the Alibaba Cloud account to access the source of the source instance information.
        :param pulumi.Input[_builtins.str] source_endpoint_user_name: The username of source database instance account.
        :param pulumi.Input[_builtins.str] status: The status of the task. Valid values: `Normal`, `Abnormal`. When a task created, it is in this state of `NotStarted`. You can specify this state to `Normal` to start the job, and specify this state of `Abnormal` to stop the job. **Note: We treat the state `Starting` as the state of `Normal`, and consider the two states to be consistent on the user side.**
        :param pulumi.Input[_builtins.bool] subscription_data_type_ddl: Whether to subscribe the DDL type of data. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.bool] subscription_data_type_dml: Whether to subscribe the DML type of data. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] subscription_instance_network_type: Subscription task type of network value: classic: classic Network. Virtual Private Cloud (vpc): a vpc. Valid values: `classic`, `vpc`.
        :param pulumi.Input[_builtins.str] subscription_instance_vpc_id: The ID of subscription vpc instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
        :param pulumi.Input[_builtins.str] subscription_instance_vswitch_id: The ID of subscription VSwitch instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
        :param pulumi.Input[_builtins.str] sync_architecture: The sync architecture. Valid values: `bidirectional`, `oneway`.
        :param pulumi.Input[_builtins.str] synchronization_direction: The synchronization direction. Valid values: `Forward`, `Reverse`. When the topology type of the data synchronization instance is bidirectional, it can be passed in to reverse to start the reverse synchronization link.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubscriptionJobState.__new__(_SubscriptionJobState)

        __props__.__dict__["checkpoint"] = checkpoint
        __props__.__dict__["compute_unit"] = compute_unit
        __props__.__dict__["database_count"] = database_count
        __props__.__dict__["db_list"] = db_list
        __props__.__dict__["delay_notice"] = delay_notice
        __props__.__dict__["delay_phone"] = delay_phone
        __props__.__dict__["delay_rule_time"] = delay_rule_time
        __props__.__dict__["destination_endpoint_engine_name"] = destination_endpoint_engine_name
        __props__.__dict__["destination_region"] = destination_region
        __props__.__dict__["dts_instance_id"] = dts_instance_id
        __props__.__dict__["dts_job_name"] = dts_job_name
        __props__.__dict__["error_notice"] = error_notice
        __props__.__dict__["error_phone"] = error_phone
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["payment_duration"] = payment_duration
        __props__.__dict__["payment_duration_unit"] = payment_duration_unit
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["reserve"] = reserve
        __props__.__dict__["source_endpoint_database_name"] = source_endpoint_database_name
        __props__.__dict__["source_endpoint_engine_name"] = source_endpoint_engine_name
        __props__.__dict__["source_endpoint_instance_id"] = source_endpoint_instance_id
        __props__.__dict__["source_endpoint_instance_type"] = source_endpoint_instance_type
        __props__.__dict__["source_endpoint_ip"] = source_endpoint_ip
        __props__.__dict__["source_endpoint_oracle_sid"] = source_endpoint_oracle_sid
        __props__.__dict__["source_endpoint_owner_id"] = source_endpoint_owner_id
        __props__.__dict__["source_endpoint_password"] = source_endpoint_password
        __props__.__dict__["source_endpoint_port"] = source_endpoint_port
        __props__.__dict__["source_endpoint_region"] = source_endpoint_region
        __props__.__dict__["source_endpoint_role"] = source_endpoint_role
        __props__.__dict__["source_endpoint_user_name"] = source_endpoint_user_name
        __props__.__dict__["status"] = status
        __props__.__dict__["subscription_data_type_ddl"] = subscription_data_type_ddl
        __props__.__dict__["subscription_data_type_dml"] = subscription_data_type_dml
        __props__.__dict__["subscription_instance_network_type"] = subscription_instance_network_type
        __props__.__dict__["subscription_instance_vpc_id"] = subscription_instance_vpc_id
        __props__.__dict__["subscription_instance_vswitch_id"] = subscription_instance_vswitch_id
        __props__.__dict__["sync_architecture"] = sync_architecture
        __props__.__dict__["synchronization_direction"] = synchronization_direction
        __props__.__dict__["tags"] = tags
        return SubscriptionJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def checkpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Subscription start time in Unix timestamp format.
        """
        return pulumi.get(self, "checkpoint")

    @_builtins.property
    @pulumi.getter(name="computeUnit")
    def compute_unit(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        [ETL specifications](https://help.aliyun.com/document_detail/212324.html). The unit is the computing unit ComputeUnit (CU), 1CU=1vCPU+4 GB memory. The value range is an integer greater than or equal to 2.
        """
        return pulumi.get(self, "compute_unit")

    @_builtins.property
    @pulumi.getter(name="databaseCount")
    def database_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of private customized RDS instances under PolarDB-X. The default value is 1. This parameter needs to be passed only when `source_endpoint_engine_name` equals `drds`.
        """
        return pulumi.get(self, "database_count")

    @_builtins.property
    @pulumi.getter(name="dbList")
    def db_list(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Subscription object, in the format of JSON strings. For detailed definitions, please refer to the description of migration, synchronization or subscription objects [document](https://help.aliyun.com/document_detail/209545.html).
        """
        return pulumi.get(self, "db_list")

    @_builtins.property
    @pulumi.getter(name="delayNotice")
    def delay_notice(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This parameter decides whether to monitor the delay status. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "delay_notice")

    @_builtins.property
    @pulumi.getter(name="delayPhone")
    def delay_phone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The mobile phone number of the contact who delayed the alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        """
        return pulumi.get(self, "delay_phone")

    @_builtins.property
    @pulumi.getter(name="delayRuleTime")
    def delay_rule_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When `delay_notice` is set to `true`, this parameter must be passed in. The threshold for triggering the delay alarm. The unit is second and needs to be an integer. The threshold can be set according to business needs. It is recommended to set it above 10 seconds to avoid delay fluctuations caused by network and database load.
        """
        return pulumi.get(self, "delay_rule_time")

    @_builtins.property
    @pulumi.getter(name="destinationEndpointEngineName")
    def destination_endpoint_engine_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The destination endpoint engine name. Valid values: `ADS`, `DB2`, `DRDS`, `DataHub`, `Greenplum`, `MSSQL`, `MySQL`, `PolarDB`, `PostgreSQL`, `Redis`, `Tablestore`, `as400`, `clickhouse`, `kafka`, `mongodb`, `odps`, `oracle`, `polardb_o`, `polardb_pg`, `tidb`.
        """
        return pulumi.get(self, "destination_endpoint_engine_name")

    @_builtins.property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The destination region. List of [supported regions](https://help.aliyun.com/document_detail/141033.html).
        """
        return pulumi.get(self, "destination_region")

    @_builtins.property
    @pulumi.getter(name="dtsInstanceId")
    def dts_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of subscription instance.
        """
        return pulumi.get(self, "dts_instance_id")

    @_builtins.property
    @pulumi.getter(name="dtsJobName")
    def dts_job_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of subscription task.
        """
        return pulumi.get(self, "dts_job_name")

    @_builtins.property
    @pulumi.getter(name="errorNotice")
    def error_notice(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This parameter decides whether to monitor abnormal status. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "error_notice")

    @_builtins.property
    @pulumi.getter(name="errorPhone")
    def error_phone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The mobile phone number of the contact for abnormal alarm. Multiple mobile phone numbers separated by English commas `,`. This parameter currently only supports China stations, and only supports mainland mobile phone numbers, and up to 10 mobile phone numbers can be passed in.
        """
        return pulumi.get(self, "error_phone")

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance class. Valid values: `large`, `medium`, `micro`, `small`, `xlarge`, `xxlarge`.
        """
        return pulumi.get(self, "instance_class")

    @_builtins.property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The duration of prepaid instance purchase. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        """
        return pulumi.get(self, "payment_duration")

    @_builtins.property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The payment duration unit. Valid values: `Month`, `Year`. When `payment_type` is `Subscription`, this parameter is valid and must be passed in.
        """
        return pulumi.get(self, "payment_duration_unit")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the resource. Valid values: `Subscription`, `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def reserve(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        DTS reserves parameters, the format is a JSON string, you can pass in this parameter to complete the source and target database information (such as the data storage format of the target Kafka database, the instance ID of the cloud enterprise network CEN). For more information, please refer to the parameter description of the [Reserve parameter](https://help.aliyun.com/document_detail/176470.html).
        """
        return pulumi.get(self, "reserve")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointDatabaseName")
    def source_endpoint_database_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        To subscribe to the name of the database.
        """
        return pulumi.get(self, "source_endpoint_database_name")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointEngineName")
    def source_endpoint_engine_name(self) -> pulumi.Output[_builtins.str]:
        """
        The source database type value is MySQL or Oracle. Valid values: `MySQL`, `Oracle`.
        """
        return pulumi.get(self, "source_endpoint_engine_name")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceId")
    def source_endpoint_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of source instance. Only when the type of source database instance was RDS MySQL, PolarDB-X 1.0, PolarDB MySQL, this parameter can be available and must be set.
        """
        return pulumi.get(self, "source_endpoint_instance_id")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointInstanceType")
    def source_endpoint_instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of source instance. Valid values: `RDS`, `PolarDB`, `DRDS`, `LocalInstance`, `ECS`, `Express`, `CEN`, `dg`.
        """
        return pulumi.get(self, "source_endpoint_instance_type")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointIp")
    def source_endpoint_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IP of source endpoint.
        """
        return pulumi.get(self, "source_endpoint_ip")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointOracleSid")
    def source_endpoint_oracle_sid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The SID of Oracle Database. When the source database is self-built Oracle and the Oracle database is a non-RAC instance, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_oracle_sid")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointOwnerId")
    def source_endpoint_owner_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Alibaba Cloud account ID to which the source instance belongs. This parameter is only available when configuring data subscriptions across Alibaba Cloud accounts and must be passed in.
        """
        return pulumi.get(self, "source_endpoint_owner_id")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPassword")
    def source_endpoint_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of source database instance account.
        """
        return pulumi.get(self, "source_endpoint_password")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointPort")
    def source_endpoint_port(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The port of source database.
        """
        return pulumi.get(self, "source_endpoint_port")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointRegion")
    def source_endpoint_region(self) -> pulumi.Output[_builtins.str]:
        """
        The region of source database.
        """
        return pulumi.get(self, "source_endpoint_region")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointRole")
    def source_endpoint_role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Both the authorization roles. When the source instance and configure subscriptions task of the Alibaba Cloud account is not the same as the need to pass the parameter, to specify the source of the authorization roles, to allow configuration subscription task of the Alibaba Cloud account to access the source of the source instance information.
        """
        return pulumi.get(self, "source_endpoint_role")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointUserName")
    def source_endpoint_user_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The username of source database instance account.
        """
        return pulumi.get(self, "source_endpoint_user_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the task. Valid values: `Normal`, `Abnormal`. When a task created, it is in this state of `NotStarted`. You can specify this state to `Normal` to start the job, and specify this state of `Abnormal` to stop the job. **Note: We treat the state `Starting` as the state of `Normal`, and consider the two states to be consistent on the user side.**
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subscriptionDataTypeDdl")
    def subscription_data_type_ddl(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to subscribe the DDL type of data. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "subscription_data_type_ddl")

    @_builtins.property
    @pulumi.getter(name="subscriptionDataTypeDml")
    def subscription_data_type_dml(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to subscribe the DML type of data. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "subscription_data_type_dml")

    @_builtins.property
    @pulumi.getter(name="subscriptionInstanceNetworkType")
    def subscription_instance_network_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Subscription task type of network value: classic: classic Network. Virtual Private Cloud (vpc): a vpc. Valid values: `classic`, `vpc`.
        """
        return pulumi.get(self, "subscription_instance_network_type")

    @_builtins.property
    @pulumi.getter(name="subscriptionInstanceVpcId")
    def subscription_instance_vpc_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of subscription vpc instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "subscription_instance_vpc_id")

    @_builtins.property
    @pulumi.getter(name="subscriptionInstanceVswitchId")
    def subscription_instance_vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of subscription VSwitch instance. When the value of `subscription_instance_network_type` is vpc, this parameter is available and must be passed in.
        """
        return pulumi.get(self, "subscription_instance_vswitch_id")

    @_builtins.property
    @pulumi.getter(name="syncArchitecture")
    def sync_architecture(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The sync architecture. Valid values: `bidirectional`, `oneway`.
        """
        return pulumi.get(self, "sync_architecture")

    @_builtins.property
    @pulumi.getter(name="synchronizationDirection")
    def synchronization_direction(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The synchronization direction. Valid values: `Forward`, `Reverse`. When the topology type of the data synchronization instance is bidirectional, it can be passed in to reverse to start the reverse synchronization link.
        """
        return pulumi.get(self, "synchronization_direction")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

