# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DiskReplicaPairArgs', 'DiskReplicaPair']

@pulumi.input_type
class DiskReplicaPairArgs:
    def __init__(__self__, *,
                 destination_disk_id: pulumi.Input[_builtins.str],
                 destination_region_id: pulumi.Input[_builtins.str],
                 destination_zone_id: pulumi.Input[_builtins.str],
                 disk_id: pulumi.Input[_builtins.str],
                 source_zone_id: pulumi.Input[_builtins.str],
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_replica_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 one_shot: Optional[pulumi.Input[_builtins.bool]] = None,
                 pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse_replicate: Optional[pulumi.Input[_builtins.bool]] = None,
                 rpo: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DiskReplicaPair resource.
        :param pulumi.Input[_builtins.str] destination_disk_id: The ID of the standby disk.
        :param pulumi.Input[_builtins.str] destination_region_id: The ID of the region to which the disaster recovery site belongs.
        :param pulumi.Input[_builtins.str] destination_zone_id: The ID of the zone to which the disaster recovery site belongs.
        :param pulumi.Input[_builtins.str] disk_id: The ID of the primary disk.
        :param pulumi.Input[_builtins.str] source_zone_id: The ID of the zone to which the production site belongs.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:
               - 10240 Kbps: equal to 10 Mbps.
               - 20480 Kbps: equal to 20 Mbps.
               - 51200 Kbps: equal to 50 Mbps.
               - 102400 Kbps: equal to 100 Mbps.
               
               Default value: 10240.
               This parameter cannot be specified when the ChargeType value is PayAsYouGo The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
        :param pulumi.Input[_builtins.str] description: The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
        :param pulumi.Input[_builtins.str] disk_replica_pair_name: The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
        :param pulumi.Input[_builtins.bool] one_shot: Whether to synchronize immediately. Value range:
               - true: Start data synchronization immediately.
               - false: Data Synchronization starts after the RPO time period.
               
               Default value: false.
        :param pulumi.Input[_builtins.str] pair_name: . Field 'pair_name' has been deprecated from provider version 1.245.0. New field 'disk_replica_pair_name' instead.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.int] period: The purchase duration of the asynchronous replication relationship. This parameter is required when 'ChargeType = PrePay. The duration unit is specified by'periodunit', and the value range is:
               - When 'PeriodUnit = Week', the value range of this parameter is 1, 2, 3, and 4.
               - When 'PeriodUnit = Month', the value range of this parameter is 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 48, 60.
        :param pulumi.Input[_builtins.str] period_unit: The unit of the purchase time of the asynchronous replication relationship. Value range:
               - Week: Week.
               - Month: Month.
               
               Default value: Month.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.bool] reverse_replicate: Specifies whether to enable the reverse replication sub-feature. Valid values: true and false. Default value: true.
        :param pulumi.Input[_builtins.int] rpo: The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        pulumi.set(__self__, "destination_disk_id", destination_disk_id)
        pulumi.set(__self__, "destination_region_id", destination_region_id)
        pulumi.set(__self__, "destination_zone_id", destination_zone_id)
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "source_zone_id", source_zone_id)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_replica_pair_name is not None:
            pulumi.set(__self__, "disk_replica_pair_name", disk_replica_pair_name)
        if one_shot is not None:
            pulumi.set(__self__, "one_shot", one_shot)
        if pair_name is not None:
            warnings.warn("""Field 'pair_name' has been deprecated since provider version 1.245.0. New field 'disk_replica_pair_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""pair_name is deprecated: Field 'pair_name' has been deprecated since provider version 1.245.0. New field 'disk_replica_pair_name' instead.""")
        if pair_name is not None:
            pulumi.set(__self__, "pair_name", pair_name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if reverse_replicate is not None:
            pulumi.set(__self__, "reverse_replicate", reverse_replicate)
        if rpo is not None:
            pulumi.set(__self__, "rpo", rpo)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="destinationDiskId")
    def destination_disk_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the standby disk.
        """
        return pulumi.get(self, "destination_disk_id")

    @destination_disk_id.setter
    def destination_disk_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_disk_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the region to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_region_id")

    @destination_region_id.setter
    def destination_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_region_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationZoneId")
    def destination_zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the zone to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_zone_id")

    @destination_zone_id.setter
    def destination_zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the primary disk.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "disk_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceZoneId")
    def source_zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the zone to which the production site belongs.
        """
        return pulumi.get(self, "source_zone_id")

    @source_zone_id.setter
    def source_zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_zone_id", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:
        - 10240 Kbps: equal to 10 Mbps.
        - 20480 Kbps: equal to 20 Mbps.
        - 51200 Kbps: equal to 50 Mbps.
        - 102400 Kbps: equal to 100 Mbps.

        Default value: 10240.
        This parameter cannot be specified when the ChargeType value is PayAsYouGo The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskReplicaPairName")
    def disk_replica_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
        """
        return pulumi.get(self, "disk_replica_pair_name")

    @disk_replica_pair_name.setter
    def disk_replica_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_replica_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="oneShot")
    def one_shot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to synchronize immediately. Value range:
        - true: Start data synchronization immediately.
        - false: Data Synchronization starts after the RPO time period.

        Default value: false.
        """
        return pulumi.get(self, "one_shot")

    @one_shot.setter
    def one_shot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "one_shot", value)

    @_builtins.property
    @pulumi.getter(name="pairName")
    @_utilities.deprecated("""Field 'pair_name' has been deprecated since provider version 1.245.0. New field 'disk_replica_pair_name' instead.""")
    def pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'pair_name' has been deprecated from provider version 1.245.0. New field 'disk_replica_pair_name' instead.
        """
        return pulumi.get(self, "pair_name")

    @pair_name.setter
    def pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pair_name", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The purchase duration of the asynchronous replication relationship. This parameter is required when 'ChargeType = PrePay. The duration unit is specified by'periodunit', and the value range is:
        - When 'PeriodUnit = Week', the value range of this parameter is 1, 2, 3, and 4.
        - When 'PeriodUnit = Month', the value range of this parameter is 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 48, 60.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of the purchase time of the asynchronous replication relationship. Value range:
        - Week: Week.
        - Month: Month.

        Default value: Month.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="reverseReplicate")
    def reverse_replicate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the reverse replication sub-feature. Valid values: true and false. Default value: true.
        """
        return pulumi.get(self, "reverse_replicate")

    @reverse_replicate.setter
    def reverse_replicate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reverse_replicate", value)

    @_builtins.property
    @pulumi.getter
    def rpo(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        """
        return pulumi.get(self, "rpo")

    @rpo.setter
    def rpo(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rpo", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DiskReplicaPairState:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_replica_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 one_shot: Optional[pulumi.Input[_builtins.bool]] = None,
                 pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse_replicate: Optional[pulumi.Input[_builtins.bool]] = None,
                 rpo: Optional[pulumi.Input[_builtins.int]] = None,
                 source_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DiskReplicaPair resources.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:
               - 10240 Kbps: equal to 10 Mbps.
               - 20480 Kbps: equal to 20 Mbps.
               - 51200 Kbps: equal to 50 Mbps.
               - 102400 Kbps: equal to 100 Mbps.
               
               Default value: 10240.
               This parameter cannot be specified when the ChargeType value is PayAsYouGo The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
        :param pulumi.Input[_builtins.int] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] description: The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
        :param pulumi.Input[_builtins.str] destination_disk_id: The ID of the standby disk.
        :param pulumi.Input[_builtins.str] destination_region_id: The ID of the region to which the disaster recovery site belongs.
        :param pulumi.Input[_builtins.str] destination_zone_id: The ID of the zone to which the disaster recovery site belongs.
        :param pulumi.Input[_builtins.str] disk_id: The ID of the primary disk.
        :param pulumi.Input[_builtins.str] disk_replica_pair_name: The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
        :param pulumi.Input[_builtins.bool] one_shot: Whether to synchronize immediately. Value range:
               - true: Start data synchronization immediately.
               - false: Data Synchronization starts after the RPO time period.
               
               Default value: false.
        :param pulumi.Input[_builtins.str] pair_name: . Field 'pair_name' has been deprecated from provider version 1.245.0. New field 'disk_replica_pair_name' instead.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.int] period: The purchase duration of the asynchronous replication relationship. This parameter is required when 'ChargeType = PrePay. The duration unit is specified by'periodunit', and the value range is:
               - When 'PeriodUnit = Week', the value range of this parameter is 1, 2, 3, and 4.
               - When 'PeriodUnit = Month', the value range of this parameter is 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 48, 60.
        :param pulumi.Input[_builtins.str] period_unit: The unit of the purchase time of the asynchronous replication relationship. Value range:
               - Week: Week.
               - Month: Month.
               
               Default value: Month.
        :param pulumi.Input[_builtins.str] region_id: The region ID  of the resource
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.bool] reverse_replicate: Specifies whether to enable the reverse replication sub-feature. Valid values: true and false. Default value: true.
        :param pulumi.Input[_builtins.int] rpo: The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        :param pulumi.Input[_builtins.str] source_zone_id: The ID of the zone to which the production site belongs.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_disk_id is not None:
            pulumi.set(__self__, "destination_disk_id", destination_disk_id)
        if destination_region_id is not None:
            pulumi.set(__self__, "destination_region_id", destination_region_id)
        if destination_zone_id is not None:
            pulumi.set(__self__, "destination_zone_id", destination_zone_id)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if disk_replica_pair_name is not None:
            pulumi.set(__self__, "disk_replica_pair_name", disk_replica_pair_name)
        if one_shot is not None:
            pulumi.set(__self__, "one_shot", one_shot)
        if pair_name is not None:
            warnings.warn("""Field 'pair_name' has been deprecated since provider version 1.245.0. New field 'disk_replica_pair_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""pair_name is deprecated: Field 'pair_name' has been deprecated since provider version 1.245.0. New field 'disk_replica_pair_name' instead.""")
        if pair_name is not None:
            pulumi.set(__self__, "pair_name", pair_name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if reverse_replicate is not None:
            pulumi.set(__self__, "reverse_replicate", reverse_replicate)
        if rpo is not None:
            pulumi.set(__self__, "rpo", rpo)
        if source_zone_id is not None:
            pulumi.set(__self__, "source_zone_id", source_zone_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:
        - 10240 Kbps: equal to 10 Mbps.
        - 20480 Kbps: equal to 20 Mbps.
        - 51200 Kbps: equal to 50 Mbps.
        - 102400 Kbps: equal to 100 Mbps.

        Default value: 10240.
        This parameter cannot be specified when the ChargeType value is PayAsYouGo The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationDiskId")
    def destination_disk_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the standby disk.
        """
        return pulumi.get(self, "destination_disk_id")

    @destination_disk_id.setter
    def destination_disk_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_disk_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_region_id")

    @destination_region_id.setter
    def destination_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_region_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationZoneId")
    def destination_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the zone to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_zone_id")

    @destination_zone_id.setter
    def destination_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the primary disk.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_id", value)

    @_builtins.property
    @pulumi.getter(name="diskReplicaPairName")
    def disk_replica_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
        """
        return pulumi.get(self, "disk_replica_pair_name")

    @disk_replica_pair_name.setter
    def disk_replica_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_replica_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="oneShot")
    def one_shot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to synchronize immediately. Value range:
        - true: Start data synchronization immediately.
        - false: Data Synchronization starts after the RPO time period.

        Default value: false.
        """
        return pulumi.get(self, "one_shot")

    @one_shot.setter
    def one_shot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "one_shot", value)

    @_builtins.property
    @pulumi.getter(name="pairName")
    @_utilities.deprecated("""Field 'pair_name' has been deprecated since provider version 1.245.0. New field 'disk_replica_pair_name' instead.""")
    def pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'pair_name' has been deprecated from provider version 1.245.0. New field 'disk_replica_pair_name' instead.
        """
        return pulumi.get(self, "pair_name")

    @pair_name.setter
    def pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pair_name", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The purchase duration of the asynchronous replication relationship. This parameter is required when 'ChargeType = PrePay. The duration unit is specified by'periodunit', and the value range is:
        - When 'PeriodUnit = Week', the value range of this parameter is 1, 2, 3, and 4.
        - When 'PeriodUnit = Month', the value range of this parameter is 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 48, 60.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of the purchase time of the asynchronous replication relationship. Value range:
        - Week: Week.
        - Month: Month.

        Default value: Month.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID  of the resource
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="reverseReplicate")
    def reverse_replicate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the reverse replication sub-feature. Valid values: true and false. Default value: true.
        """
        return pulumi.get(self, "reverse_replicate")

    @reverse_replicate.setter
    def reverse_replicate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reverse_replicate", value)

    @_builtins.property
    @pulumi.getter
    def rpo(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        """
        return pulumi.get(self, "rpo")

    @rpo.setter
    def rpo(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rpo", value)

    @_builtins.property
    @pulumi.getter(name="sourceZoneId")
    def source_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the zone to which the production site belongs.
        """
        return pulumi.get(self, "source_zone_id")

    @source_zone_id.setter
    def source_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_zone_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:ebs/diskReplicaPair:DiskReplicaPair")
class DiskReplicaPair(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_replica_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 one_shot: Optional[pulumi.Input[_builtins.bool]] = None,
                 pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse_replicate: Optional[pulumi.Input[_builtins.bool]] = None,
                 rpo: Optional[pulumi.Input[_builtins.int]] = None,
                 source_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Elastic Block Storage(EBS) Disk Replica Pair resource.

        For information about Elastic Block Storage(EBS) Disk Replica Pair and how to use it, see [What is Disk Replica Pair](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-ebs-2021-07-30-creatediskreplicapair).

        > **NOTE:** Available since v1.196.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_regions(current=True)
        default_get_regions = alicloud.ebs.get_regions(region_id=default.regions[0].id)
        default_ecs_disk = alicloud.ecs.EcsDisk("default",
            zone_id=default_get_regions.regions[0].zones[0].zone_id,
            category="cloud_essd",
            delete_auto_snapshot=True,
            delete_with_instance=True,
            description=name,
            disk_name=name,
            enable_auto_snapshot=True,
            encrypted=True,
            size=500,
            tags={
                "Created": "TF",
                "For": "example",
                "controlledBy": "ear",
            })
        destination = alicloud.ecs.EcsDisk("destination",
            zone_id=default_get_regions.regions[0].zones[1].zone_id,
            category="cloud_essd",
            delete_auto_snapshot=True,
            delete_with_instance=True,
            description=std.format(input="%s-destination",
                args=[name]).result,
            disk_name=name,
            enable_auto_snapshot=True,
            encrypted=True,
            size=500,
            tags={
                "Created": "TF",
                "For": "example",
                "controlledBy": "ear",
            })
        default_disk_replica_pair = alicloud.ebs.DiskReplicaPair("default",
            destination_disk_id=destination.id,
            destination_region_id=default.regions[0].id,
            payment_type="POSTPAY",
            destination_zone_id=destination.zone_id,
            source_zone_id=default_ecs_disk.zone_id,
            disk_id=default_ecs_disk.id,
            description=name)
        ```

        ## Import

        Elastic Block Storage(EBS) Disk Replica Pair can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ebs/diskReplicaPair:DiskReplicaPair example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:
               - 10240 Kbps: equal to 10 Mbps.
               - 20480 Kbps: equal to 20 Mbps.
               - 51200 Kbps: equal to 50 Mbps.
               - 102400 Kbps: equal to 100 Mbps.
               
               Default value: 10240.
               This parameter cannot be specified when the ChargeType value is PayAsYouGo The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
        :param pulumi.Input[_builtins.str] description: The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
        :param pulumi.Input[_builtins.str] destination_disk_id: The ID of the standby disk.
        :param pulumi.Input[_builtins.str] destination_region_id: The ID of the region to which the disaster recovery site belongs.
        :param pulumi.Input[_builtins.str] destination_zone_id: The ID of the zone to which the disaster recovery site belongs.
        :param pulumi.Input[_builtins.str] disk_id: The ID of the primary disk.
        :param pulumi.Input[_builtins.str] disk_replica_pair_name: The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
        :param pulumi.Input[_builtins.bool] one_shot: Whether to synchronize immediately. Value range:
               - true: Start data synchronization immediately.
               - false: Data Synchronization starts after the RPO time period.
               
               Default value: false.
        :param pulumi.Input[_builtins.str] pair_name: . Field 'pair_name' has been deprecated from provider version 1.245.0. New field 'disk_replica_pair_name' instead.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.int] period: The purchase duration of the asynchronous replication relationship. This parameter is required when 'ChargeType = PrePay. The duration unit is specified by'periodunit', and the value range is:
               - When 'PeriodUnit = Week', the value range of this parameter is 1, 2, 3, and 4.
               - When 'PeriodUnit = Month', the value range of this parameter is 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 48, 60.
        :param pulumi.Input[_builtins.str] period_unit: The unit of the purchase time of the asynchronous replication relationship. Value range:
               - Week: Week.
               - Month: Month.
               
               Default value: Month.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.bool] reverse_replicate: Specifies whether to enable the reverse replication sub-feature. Valid values: true and false. Default value: true.
        :param pulumi.Input[_builtins.int] rpo: The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        :param pulumi.Input[_builtins.str] source_zone_id: The ID of the zone to which the production site belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DiskReplicaPairArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Elastic Block Storage(EBS) Disk Replica Pair resource.

        For information about Elastic Block Storage(EBS) Disk Replica Pair and how to use it, see [What is Disk Replica Pair](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-ebs-2021-07-30-creatediskreplicapair).

        > **NOTE:** Available since v1.196.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_regions(current=True)
        default_get_regions = alicloud.ebs.get_regions(region_id=default.regions[0].id)
        default_ecs_disk = alicloud.ecs.EcsDisk("default",
            zone_id=default_get_regions.regions[0].zones[0].zone_id,
            category="cloud_essd",
            delete_auto_snapshot=True,
            delete_with_instance=True,
            description=name,
            disk_name=name,
            enable_auto_snapshot=True,
            encrypted=True,
            size=500,
            tags={
                "Created": "TF",
                "For": "example",
                "controlledBy": "ear",
            })
        destination = alicloud.ecs.EcsDisk("destination",
            zone_id=default_get_regions.regions[0].zones[1].zone_id,
            category="cloud_essd",
            delete_auto_snapshot=True,
            delete_with_instance=True,
            description=std.format(input="%s-destination",
                args=[name]).result,
            disk_name=name,
            enable_auto_snapshot=True,
            encrypted=True,
            size=500,
            tags={
                "Created": "TF",
                "For": "example",
                "controlledBy": "ear",
            })
        default_disk_replica_pair = alicloud.ebs.DiskReplicaPair("default",
            destination_disk_id=destination.id,
            destination_region_id=default.regions[0].id,
            payment_type="POSTPAY",
            destination_zone_id=destination.zone_id,
            source_zone_id=default_ecs_disk.zone_id,
            disk_id=default_ecs_disk.id,
            description=name)
        ```

        ## Import

        Elastic Block Storage(EBS) Disk Replica Pair can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ebs/diskReplicaPair:DiskReplicaPair example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DiskReplicaPairArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiskReplicaPairArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_replica_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 one_shot: Optional[pulumi.Input[_builtins.bool]] = None,
                 pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse_replicate: Optional[pulumi.Input[_builtins.bool]] = None,
                 rpo: Optional[pulumi.Input[_builtins.int]] = None,
                 source_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiskReplicaPairArgs.__new__(DiskReplicaPairArgs)

            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["description"] = description
            if destination_disk_id is None and not opts.urn:
                raise TypeError("Missing required property 'destination_disk_id'")
            __props__.__dict__["destination_disk_id"] = destination_disk_id
            if destination_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'destination_region_id'")
            __props__.__dict__["destination_region_id"] = destination_region_id
            if destination_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'destination_zone_id'")
            __props__.__dict__["destination_zone_id"] = destination_zone_id
            if disk_id is None and not opts.urn:
                raise TypeError("Missing required property 'disk_id'")
            __props__.__dict__["disk_id"] = disk_id
            __props__.__dict__["disk_replica_pair_name"] = disk_replica_pair_name
            __props__.__dict__["one_shot"] = one_shot
            __props__.__dict__["pair_name"] = pair_name
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["reverse_replicate"] = reverse_replicate
            __props__.__dict__["rpo"] = rpo
            if source_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_zone_id'")
            __props__.__dict__["source_zone_id"] = source_zone_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(DiskReplicaPair, __self__).__init__(
            'alicloud:ebs/diskReplicaPair:DiskReplicaPair',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
            destination_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            destination_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            disk_id: Optional[pulumi.Input[_builtins.str]] = None,
            disk_replica_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
            one_shot: Optional[pulumi.Input[_builtins.bool]] = None,
            pair_name: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            reverse_replicate: Optional[pulumi.Input[_builtins.bool]] = None,
            rpo: Optional[pulumi.Input[_builtins.int]] = None,
            source_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'DiskReplicaPair':
        """
        Get an existing DiskReplicaPair resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:
               - 10240 Kbps: equal to 10 Mbps.
               - 20480 Kbps: equal to 20 Mbps.
               - 51200 Kbps: equal to 50 Mbps.
               - 102400 Kbps: equal to 100 Mbps.
               
               Default value: 10240.
               This parameter cannot be specified when the ChargeType value is PayAsYouGo The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
        :param pulumi.Input[_builtins.int] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] description: The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
        :param pulumi.Input[_builtins.str] destination_disk_id: The ID of the standby disk.
        :param pulumi.Input[_builtins.str] destination_region_id: The ID of the region to which the disaster recovery site belongs.
        :param pulumi.Input[_builtins.str] destination_zone_id: The ID of the zone to which the disaster recovery site belongs.
        :param pulumi.Input[_builtins.str] disk_id: The ID of the primary disk.
        :param pulumi.Input[_builtins.str] disk_replica_pair_name: The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
        :param pulumi.Input[_builtins.bool] one_shot: Whether to synchronize immediately. Value range:
               - true: Start data synchronization immediately.
               - false: Data Synchronization starts after the RPO time period.
               
               Default value: false.
        :param pulumi.Input[_builtins.str] pair_name: . Field 'pair_name' has been deprecated from provider version 1.245.0. New field 'disk_replica_pair_name' instead.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource
        :param pulumi.Input[_builtins.int] period: The purchase duration of the asynchronous replication relationship. This parameter is required when 'ChargeType = PrePay. The duration unit is specified by'periodunit', and the value range is:
               - When 'PeriodUnit = Week', the value range of this parameter is 1, 2, 3, and 4.
               - When 'PeriodUnit = Month', the value range of this parameter is 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 48, 60.
        :param pulumi.Input[_builtins.str] period_unit: The unit of the purchase time of the asynchronous replication relationship. Value range:
               - Week: Week.
               - Month: Month.
               
               Default value: Month.
        :param pulumi.Input[_builtins.str] region_id: The region ID  of the resource
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.bool] reverse_replicate: Specifies whether to enable the reverse replication sub-feature. Valid values: true and false. Default value: true.
        :param pulumi.Input[_builtins.int] rpo: The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        :param pulumi.Input[_builtins.str] source_zone_id: The ID of the zone to which the production site belongs.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiskReplicaPairState.__new__(_DiskReplicaPairState)

        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_disk_id"] = destination_disk_id
        __props__.__dict__["destination_region_id"] = destination_region_id
        __props__.__dict__["destination_zone_id"] = destination_zone_id
        __props__.__dict__["disk_id"] = disk_id
        __props__.__dict__["disk_replica_pair_name"] = disk_replica_pair_name
        __props__.__dict__["one_shot"] = one_shot
        __props__.__dict__["pair_name"] = pair_name
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["reverse_replicate"] = reverse_replicate
        __props__.__dict__["rpo"] = rpo
        __props__.__dict__["source_zone_id"] = source_zone_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return DiskReplicaPair(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The bandwidth for asynchronous data replication between cloud disks. The unit is Kbps. Value range:
        - 10240 Kbps: equal to 10 Mbps.
        - 20480 Kbps: equal to 20 Mbps.
        - 51200 Kbps: equal to 50 Mbps.
        - 102400 Kbps: equal to 100 Mbps.

        Default value: 10240.
        This parameter cannot be specified when the ChargeType value is PayAsYouGo The system value is 0, which indicates that the disk is dynamically allocated according to data write changes during asynchronous replication.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the asynchronous replication relationship. 2 to 256 English or Chinese characters in length and cannot start with' http:// 'or' https.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationDiskId")
    def destination_disk_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the standby disk.
        """
        return pulumi.get(self, "destination_disk_id")

    @_builtins.property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_region_id")

    @_builtins.property
    @pulumi.getter(name="destinationZoneId")
    def destination_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the zone to which the disaster recovery site belongs.
        """
        return pulumi.get(self, "destination_zone_id")

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the primary disk.
        """
        return pulumi.get(self, "disk_id")

    @_builtins.property
    @pulumi.getter(name="diskReplicaPairName")
    def disk_replica_pair_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the asynchronous replication relationship. The length must be 2 to 128 characters in length and must start with a letter or Chinese name. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-).
        """
        return pulumi.get(self, "disk_replica_pair_name")

    @_builtins.property
    @pulumi.getter(name="oneShot")
    def one_shot(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to synchronize immediately. Value range:
        - true: Start data synchronization immediately.
        - false: Data Synchronization starts after the RPO time period.

        Default value: false.
        """
        return pulumi.get(self, "one_shot")

    @_builtins.property
    @pulumi.getter(name="pairName")
    @_utilities.deprecated("""Field 'pair_name' has been deprecated since provider version 1.245.0. New field 'disk_replica_pair_name' instead.""")
    def pair_name(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'pair_name' has been deprecated from provider version 1.245.0. New field 'disk_replica_pair_name' instead.
        """
        return pulumi.get(self, "pair_name")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the resource
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The purchase duration of the asynchronous replication relationship. This parameter is required when 'ChargeType = PrePay. The duration unit is specified by'periodunit', and the value range is:
        - When 'PeriodUnit = Week', the value range of this parameter is 1, 2, 3, and 4.
        - When 'PeriodUnit = Month', the value range of this parameter is 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 48, 60.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unit of the purchase time of the asynchronous replication relationship. Value range:
        - Week: Week.
        - Month: Month.

        Default value: Month.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID  of the resource
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="reverseReplicate")
    def reverse_replicate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the reverse replication sub-feature. Valid values: true and false. Default value: true.
        """
        return pulumi.get(self, "reverse_replicate")

    @_builtins.property
    @pulumi.getter
    def rpo(self) -> pulumi.Output[_builtins.int]:
        """
        The RPO value set by the consistency group in seconds. Currently only 900 seconds are supported.
        """
        return pulumi.get(self, "rpo")

    @_builtins.property
    @pulumi.getter(name="sourceZoneId")
    def source_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the zone to which the production site belongs.
        """
        return pulumi.get(self, "source_zone_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "tags")

