# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ImageArgs', 'Image']

@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_auto_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detection_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['ImageDiskDeviceMappingArgs']]]] = None,
                 features: Optional[pulumi.Input['ImageFeaturesArgs']] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_family: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_version: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Image resource.
        :param pulumi.Input[_builtins.str] architecture: The system architecture of the system disk. If you specify a data disk snapshot to create the system disk of the custom image, you must use Architecture to specify the system architecture of the system disk. Valid values: `i386`, `x86\\_64`, `arm64`. Default value: `x86\\_64`.
        :param pulumi.Input[_builtins.str] boot_mode: The new boot mode of the image. Valid values:
               
               *   BIOS: Basic Input/Output System (BIOS)
               
               *   UEFI: Unified Extensible Firmware Interface (UEFI)
               
               *   UEFI-Preferred: BIOS and UEFI
               
               > **NOTE:**   Before you change the boot mode, we recommend that you obtain the boot modes supported by the image. If you specify an unsupported boot mode for the image, ECS instances that use the image cannot start as expected. If you do not know which boot modes are supported by the image, we recommend that you use the image check feature to perform a check. For information about the image check feature, see [Overview](https://www.alibabacloud.com/help/en/doc-detail/439819.html).
               
               > **NOTE:**   For information about the UEFI-Preferred boot mode, see [Best practices for ECS instance boot modes](https://www.alibabacloud.com/help/en/doc-detail/2244655.html).
        :param pulumi.Input[_builtins.bool] delete_auto_snapshot: Not the public attribute and it used to automatically delete dependence snapshots while deleting the image.
        :param pulumi.Input[_builtins.str] description: The new description of the custom image. The description must be 2 to 256 characters in length It cannot start with `http://` or `https://`. This parameter is empty by default, which specifies that the original description is retained.
        :param pulumi.Input[_builtins.str] detection_strategy: The mode in which to check the custom image. If you do not specify this parameter, the image is not checked. Only the standard check mode is supported.
               
               > **NOTE:**   This parameter is supported for most Linux and Windows operating system versions. For information about image check items and operating system limits for image check, see [Overview of image check](https://www.alibabacloud.com/help/en/doc-detail/439819.html) and [Operating system limits for image check](https://www.alibabacloud.com/help/en/doc-detail/475800.html).
        :param pulumi.Input[Sequence[pulumi.Input['ImageDiskDeviceMappingArgs']]] disk_device_mappings: Snapshot information for the image See `disk_device_mapping` below.
        :param pulumi.Input['ImageFeaturesArgs'] features: Features See `features` below.
        :param pulumi.Input[_builtins.bool] force: Whether to perform forced deletion. Value range:
               - true: forcibly deletes the custom image, ignoring whether the current image is used by other instances.
               - false: The custom image is deleted normally. Before deleting the custom image, check whether the current image is used by other instances.
               
               Default value: false
        :param pulumi.Input[_builtins.str] image_family: The name of the image family. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\\_), and hyphens (-). By default, this parameter is empty.
        :param pulumi.Input[_builtins.str] image_name: The name of the custom image. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\\_), and hyphens (-). By default, this parameter is empty. In this case, the original name is retained.
        :param pulumi.Input[_builtins.str] image_version: The image version.
               
               > **NOTE:**  If you specify an instance by configuring `InstanceId`, and the instance uses an Alibaba Cloud Marketplace image or a custom image that is created from an Alibaba Cloud Marketplace image, you must leave this parameter empty or set this parameter to the value of ImageVersion of the instance.
        :param pulumi.Input[_builtins.str] instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] license_type: The type of the license that is used to activate the operating system after the image is imported. Set the value to BYOL. BYOL: The license that comes with the source operating system is used. When you use the BYOL license, make sure that your license key is supported by Alibaba Cloud.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.227.0. New field 'image_name' instead.
        :param pulumi.Input[_builtins.str] platform: The operating system distribution for the system disk in the custom image. If you specify a data disk snapshot to create the system disk of the custom image, use Platform to specify the operating system distribution for the system disk. Valid values: `Aliyun`, `Anolis`, `CentOS`, `Ubuntu`, `CoreOS`, `SUSE`, `Debian`, `OpenSUSE`, `FreeBSD`, `RedHat`, `Kylin`, `UOS`, `Fedora`, `Fedora CoreOS`, `CentOS Stream`, `AlmaLinux`, `Rocky Linux`, `Gentoo`, `Customized Linux`, `Others Linux`, `Windows Server 2022`, `Windows Server 2019`, `Windows Server 2016`, `Windows Server 2012`, `Windows Server 2008`, `Windows Server 2003`. Default value: `Others Linux`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which to assign the custom image. If you do not specify this parameter, the image is assigned to the default resource group.
               
               > **NOTE:**   If you call the CreateImage operation as a Resource Access Management (RAM) user who does not have the permissions to manage the default resource group and do not specify `ResourceGroupId`, the `Forbbiden: User not authorized to operate on the specified resource` error message is returned. You must specify the ID of a resource group that the RAM user has the permissions to manage or grant the RAM user the permissions to manage the default resource group before you call the CreateImage operation again.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the snapshot that you want to use to create the custom image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if boot_mode is not None:
            pulumi.set(__self__, "boot_mode", boot_mode)
        if delete_auto_snapshot is not None:
            pulumi.set(__self__, "delete_auto_snapshot", delete_auto_snapshot)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detection_strategy is not None:
            pulumi.set(__self__, "detection_strategy", detection_strategy)
        if disk_device_mappings is not None:
            pulumi.set(__self__, "disk_device_mappings", disk_device_mappings)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if image_family is not None:
            pulumi.set(__self__, "image_family", image_family)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.227.0. New field 'image_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.227.0. New field 'image_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The system architecture of the system disk. If you specify a data disk snapshot to create the system disk of the custom image, you must use Architecture to specify the system architecture of the system disk. Valid values: `i386`, `x86\\_64`, `arm64`. Default value: `x86\\_64`.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "architecture", value)

    @_builtins.property
    @pulumi.getter(name="bootMode")
    def boot_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new boot mode of the image. Valid values:

        *   BIOS: Basic Input/Output System (BIOS)

        *   UEFI: Unified Extensible Firmware Interface (UEFI)

        *   UEFI-Preferred: BIOS and UEFI

        > **NOTE:**   Before you change the boot mode, we recommend that you obtain the boot modes supported by the image. If you specify an unsupported boot mode for the image, ECS instances that use the image cannot start as expected. If you do not know which boot modes are supported by the image, we recommend that you use the image check feature to perform a check. For information about the image check feature, see [Overview](https://www.alibabacloud.com/help/en/doc-detail/439819.html).

        > **NOTE:**   For information about the UEFI-Preferred boot mode, see [Best practices for ECS instance boot modes](https://www.alibabacloud.com/help/en/doc-detail/2244655.html).
        """
        return pulumi.get(self, "boot_mode")

    @boot_mode.setter
    def boot_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "boot_mode", value)

    @_builtins.property
    @pulumi.getter(name="deleteAutoSnapshot")
    def delete_auto_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Not the public attribute and it used to automatically delete dependence snapshots while deleting the image.
        """
        return pulumi.get(self, "delete_auto_snapshot")

    @delete_auto_snapshot.setter
    def delete_auto_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_auto_snapshot", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new description of the custom image. The description must be 2 to 256 characters in length It cannot start with `http://` or `https://`. This parameter is empty by default, which specifies that the original description is retained.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="detectionStrategy")
    def detection_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode in which to check the custom image. If you do not specify this parameter, the image is not checked. Only the standard check mode is supported.

        > **NOTE:**   This parameter is supported for most Linux and Windows operating system versions. For information about image check items and operating system limits for image check, see [Overview of image check](https://www.alibabacloud.com/help/en/doc-detail/439819.html) and [Operating system limits for image check](https://www.alibabacloud.com/help/en/doc-detail/475800.html).
        """
        return pulumi.get(self, "detection_strategy")

    @detection_strategy.setter
    def detection_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detection_strategy", value)

    @_builtins.property
    @pulumi.getter(name="diskDeviceMappings")
    def disk_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageDiskDeviceMappingArgs']]]]:
        """
        Snapshot information for the image See `disk_device_mapping` below.
        """
        return pulumi.get(self, "disk_device_mappings")

    @disk_device_mappings.setter
    def disk_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageDiskDeviceMappingArgs']]]]):
        pulumi.set(self, "disk_device_mappings", value)

    @_builtins.property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input['ImageFeaturesArgs']]:
        """
        Features See `features` below.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input['ImageFeaturesArgs']]):
        pulumi.set(self, "features", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to perform forced deletion. Value range:
        - true: forcibly deletes the custom image, ignoring whether the current image is used by other instances.
        - false: The custom image is deleted normally. Before deleting the custom image, check whether the current image is used by other instances.

        Default value: false
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="imageFamily")
    def image_family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image family. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\\_), and hyphens (-). By default, this parameter is empty.
        """
        return pulumi.get(self, "image_family")

    @image_family.setter
    def image_family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_family", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the custom image. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\\_), and hyphens (-). By default, this parameter is empty. In this case, the original name is retained.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The image version.

        > **NOTE:**  If you specify an instance by configuring `InstanceId`, and the instance uses an Alibaba Cloud Marketplace image or a custom image that is created from an Alibaba Cloud Marketplace image, you must leave this parameter empty or set this parameter to the value of ImageVersion of the instance.
        """
        return pulumi.get(self, "image_version")

    @image_version.setter
    def image_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_version", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the license that is used to activate the operating system after the image is imported. Set the value to BYOL. BYOL: The license that comes with the source operating system is used. When you use the BYOL license, make sure that your license key is supported by Alibaba Cloud.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.227.0. New field 'image_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.227.0. New field 'image_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating system distribution for the system disk in the custom image. If you specify a data disk snapshot to create the system disk of the custom image, use Platform to specify the operating system distribution for the system disk. Valid values: `Aliyun`, `Anolis`, `CentOS`, `Ubuntu`, `CoreOS`, `SUSE`, `Debian`, `OpenSUSE`, `FreeBSD`, `RedHat`, `Kylin`, `UOS`, `Fedora`, `Fedora CoreOS`, `CentOS Stream`, `AlmaLinux`, `Rocky Linux`, `Gentoo`, `Customized Linux`, `Others Linux`, `Windows Server 2022`, `Windows Server 2019`, `Windows Server 2016`, `Windows Server 2012`, `Windows Server 2008`, `Windows Server 2003`. Default value: `Others Linux`.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which to assign the custom image. If you do not specify this parameter, the image is assigned to the default resource group.

        > **NOTE:**   If you call the CreateImage operation as a Resource Access Management (RAM) user who does not have the permissions to manage the default resource group and do not specify `ResourceGroupId`, the `Forbbiden: User not authorized to operate on the specified resource` error message is returned. You must specify the ID of a resource group that the RAM user has the permissions to manage or grant the RAM user the permissions to manage the default resource group before you call the CreateImage operation again.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the snapshot that you want to use to create the custom image.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ImageState:
    def __init__(__self__, *,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_auto_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detection_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['ImageDiskDeviceMappingArgs']]]] = None,
                 features: Optional[pulumi.Input['ImageFeaturesArgs']] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_family: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_version: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Image resources.
        :param pulumi.Input[_builtins.str] architecture: The system architecture of the system disk. If you specify a data disk snapshot to create the system disk of the custom image, you must use Architecture to specify the system architecture of the system disk. Valid values: `i386`, `x86\\_64`, `arm64`. Default value: `x86\\_64`.
        :param pulumi.Input[_builtins.str] boot_mode: The new boot mode of the image. Valid values:
               
               *   BIOS: Basic Input/Output System (BIOS)
               
               *   UEFI: Unified Extensible Firmware Interface (UEFI)
               
               *   UEFI-Preferred: BIOS and UEFI
               
               > **NOTE:**   Before you change the boot mode, we recommend that you obtain the boot modes supported by the image. If you specify an unsupported boot mode for the image, ECS instances that use the image cannot start as expected. If you do not know which boot modes are supported by the image, we recommend that you use the image check feature to perform a check. For information about the image check feature, see [Overview](https://www.alibabacloud.com/help/en/doc-detail/439819.html).
               
               > **NOTE:**   For information about the UEFI-Preferred boot mode, see [Best practices for ECS instance boot modes](https://www.alibabacloud.com/help/en/doc-detail/2244655.html).
        :param pulumi.Input[_builtins.str] create_time: The create time
        :param pulumi.Input[_builtins.bool] delete_auto_snapshot: Not the public attribute and it used to automatically delete dependence snapshots while deleting the image.
        :param pulumi.Input[_builtins.str] description: The new description of the custom image. The description must be 2 to 256 characters in length It cannot start with `http://` or `https://`. This parameter is empty by default, which specifies that the original description is retained.
        :param pulumi.Input[_builtins.str] detection_strategy: The mode in which to check the custom image. If you do not specify this parameter, the image is not checked. Only the standard check mode is supported.
               
               > **NOTE:**   This parameter is supported for most Linux and Windows operating system versions. For information about image check items and operating system limits for image check, see [Overview of image check](https://www.alibabacloud.com/help/en/doc-detail/439819.html) and [Operating system limits for image check](https://www.alibabacloud.com/help/en/doc-detail/475800.html).
        :param pulumi.Input[Sequence[pulumi.Input['ImageDiskDeviceMappingArgs']]] disk_device_mappings: Snapshot information for the image See `disk_device_mapping` below.
        :param pulumi.Input['ImageFeaturesArgs'] features: Features See `features` below.
        :param pulumi.Input[_builtins.bool] force: Whether to perform forced deletion. Value range:
               - true: forcibly deletes the custom image, ignoring whether the current image is used by other instances.
               - false: The custom image is deleted normally. Before deleting the custom image, check whether the current image is used by other instances.
               
               Default value: false
        :param pulumi.Input[_builtins.str] image_family: The name of the image family. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\\_), and hyphens (-). By default, this parameter is empty.
        :param pulumi.Input[_builtins.str] image_name: The name of the custom image. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\\_), and hyphens (-). By default, this parameter is empty. In this case, the original name is retained.
        :param pulumi.Input[_builtins.str] image_version: The image version.
               
               > **NOTE:**  If you specify an instance by configuring `InstanceId`, and the instance uses an Alibaba Cloud Marketplace image or a custom image that is created from an Alibaba Cloud Marketplace image, you must leave this parameter empty or set this parameter to the value of ImageVersion of the instance.
        :param pulumi.Input[_builtins.str] instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] license_type: The type of the license that is used to activate the operating system after the image is imported. Set the value to BYOL. BYOL: The license that comes with the source operating system is used. When you use the BYOL license, make sure that your license key is supported by Alibaba Cloud.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.227.0. New field 'image_name' instead.
        :param pulumi.Input[_builtins.str] platform: The operating system distribution for the system disk in the custom image. If you specify a data disk snapshot to create the system disk of the custom image, use Platform to specify the operating system distribution for the system disk. Valid values: `Aliyun`, `Anolis`, `CentOS`, `Ubuntu`, `CoreOS`, `SUSE`, `Debian`, `OpenSUSE`, `FreeBSD`, `RedHat`, `Kylin`, `UOS`, `Fedora`, `Fedora CoreOS`, `CentOS Stream`, `AlmaLinux`, `Rocky Linux`, `Gentoo`, `Customized Linux`, `Others Linux`, `Windows Server 2022`, `Windows Server 2019`, `Windows Server 2016`, `Windows Server 2012`, `Windows Server 2008`, `Windows Server 2003`. Default value: `Others Linux`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which to assign the custom image. If you do not specify this parameter, the image is assigned to the default resource group.
               
               > **NOTE:**   If you call the CreateImage operation as a Resource Access Management (RAM) user who does not have the permissions to manage the default resource group and do not specify `ResourceGroupId`, the `Forbbiden: User not authorized to operate on the specified resource` error message is returned. You must specify the ID of a resource group that the RAM user has the permissions to manage or grant the RAM user the permissions to manage the default resource group before you call the CreateImage operation again.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the snapshot that you want to use to create the custom image.
        :param pulumi.Input[_builtins.str] status: The status of the image. By default, if you do not specify this parameter, only images in the Available state are returned.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if boot_mode is not None:
            pulumi.set(__self__, "boot_mode", boot_mode)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_auto_snapshot is not None:
            pulumi.set(__self__, "delete_auto_snapshot", delete_auto_snapshot)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detection_strategy is not None:
            pulumi.set(__self__, "detection_strategy", detection_strategy)
        if disk_device_mappings is not None:
            pulumi.set(__self__, "disk_device_mappings", disk_device_mappings)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if image_family is not None:
            pulumi.set(__self__, "image_family", image_family)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.227.0. New field 'image_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.227.0. New field 'image_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The system architecture of the system disk. If you specify a data disk snapshot to create the system disk of the custom image, you must use Architecture to specify the system architecture of the system disk. Valid values: `i386`, `x86\\_64`, `arm64`. Default value: `x86\\_64`.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "architecture", value)

    @_builtins.property
    @pulumi.getter(name="bootMode")
    def boot_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new boot mode of the image. Valid values:

        *   BIOS: Basic Input/Output System (BIOS)

        *   UEFI: Unified Extensible Firmware Interface (UEFI)

        *   UEFI-Preferred: BIOS and UEFI

        > **NOTE:**   Before you change the boot mode, we recommend that you obtain the boot modes supported by the image. If you specify an unsupported boot mode for the image, ECS instances that use the image cannot start as expected. If you do not know which boot modes are supported by the image, we recommend that you use the image check feature to perform a check. For information about the image check feature, see [Overview](https://www.alibabacloud.com/help/en/doc-detail/439819.html).

        > **NOTE:**   For information about the UEFI-Preferred boot mode, see [Best practices for ECS instance boot modes](https://www.alibabacloud.com/help/en/doc-detail/2244655.html).
        """
        return pulumi.get(self, "boot_mode")

    @boot_mode.setter
    def boot_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "boot_mode", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The create time
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deleteAutoSnapshot")
    def delete_auto_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Not the public attribute and it used to automatically delete dependence snapshots while deleting the image.
        """
        return pulumi.get(self, "delete_auto_snapshot")

    @delete_auto_snapshot.setter
    def delete_auto_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_auto_snapshot", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The new description of the custom image. The description must be 2 to 256 characters in length It cannot start with `http://` or `https://`. This parameter is empty by default, which specifies that the original description is retained.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="detectionStrategy")
    def detection_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode in which to check the custom image. If you do not specify this parameter, the image is not checked. Only the standard check mode is supported.

        > **NOTE:**   This parameter is supported for most Linux and Windows operating system versions. For information about image check items and operating system limits for image check, see [Overview of image check](https://www.alibabacloud.com/help/en/doc-detail/439819.html) and [Operating system limits for image check](https://www.alibabacloud.com/help/en/doc-detail/475800.html).
        """
        return pulumi.get(self, "detection_strategy")

    @detection_strategy.setter
    def detection_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detection_strategy", value)

    @_builtins.property
    @pulumi.getter(name="diskDeviceMappings")
    def disk_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageDiskDeviceMappingArgs']]]]:
        """
        Snapshot information for the image See `disk_device_mapping` below.
        """
        return pulumi.get(self, "disk_device_mappings")

    @disk_device_mappings.setter
    def disk_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageDiskDeviceMappingArgs']]]]):
        pulumi.set(self, "disk_device_mappings", value)

    @_builtins.property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input['ImageFeaturesArgs']]:
        """
        Features See `features` below.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input['ImageFeaturesArgs']]):
        pulumi.set(self, "features", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to perform forced deletion. Value range:
        - true: forcibly deletes the custom image, ignoring whether the current image is used by other instances.
        - false: The custom image is deleted normally. Before deleting the custom image, check whether the current image is used by other instances.

        Default value: false
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="imageFamily")
    def image_family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image family. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\\_), and hyphens (-). By default, this parameter is empty.
        """
        return pulumi.get(self, "image_family")

    @image_family.setter
    def image_family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_family", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the custom image. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\\_), and hyphens (-). By default, this parameter is empty. In this case, the original name is retained.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The image version.

        > **NOTE:**  If you specify an instance by configuring `InstanceId`, and the instance uses an Alibaba Cloud Marketplace image or a custom image that is created from an Alibaba Cloud Marketplace image, you must leave this parameter empty or set this parameter to the value of ImageVersion of the instance.
        """
        return pulumi.get(self, "image_version")

    @image_version.setter
    def image_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_version", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the license that is used to activate the operating system after the image is imported. Set the value to BYOL. BYOL: The license that comes with the source operating system is used. When you use the BYOL license, make sure that your license key is supported by Alibaba Cloud.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.227.0. New field 'image_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.227.0. New field 'image_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating system distribution for the system disk in the custom image. If you specify a data disk snapshot to create the system disk of the custom image, use Platform to specify the operating system distribution for the system disk. Valid values: `Aliyun`, `Anolis`, `CentOS`, `Ubuntu`, `CoreOS`, `SUSE`, `Debian`, `OpenSUSE`, `FreeBSD`, `RedHat`, `Kylin`, `UOS`, `Fedora`, `Fedora CoreOS`, `CentOS Stream`, `AlmaLinux`, `Rocky Linux`, `Gentoo`, `Customized Linux`, `Others Linux`, `Windows Server 2022`, `Windows Server 2019`, `Windows Server 2016`, `Windows Server 2012`, `Windows Server 2008`, `Windows Server 2003`. Default value: `Others Linux`.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which to assign the custom image. If you do not specify this parameter, the image is assigned to the default resource group.

        > **NOTE:**   If you call the CreateImage operation as a Resource Access Management (RAM) user who does not have the permissions to manage the default resource group and do not specify `ResourceGroupId`, the `Forbbiden: User not authorized to operate on the specified resource` error message is returned. You must specify the ID of a resource group that the RAM user has the permissions to manage or grant the RAM user the permissions to manage the default resource group before you call the CreateImage operation again.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the snapshot that you want to use to create the custom image.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the image. By default, if you do not specify this parameter, only images in the Available state are returned.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:ecs/image:Image")
class Image(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_auto_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detection_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageDiskDeviceMappingArgs', 'ImageDiskDeviceMappingArgsDict']]]]] = None,
                 features: Optional[pulumi.Input[Union['ImageFeaturesArgs', 'ImageFeaturesArgsDict']]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_family: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_version: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a ECS Image resource.

        > **NOTE:**  If you want to create a template from an ECS instance, you can specify the instance ID (InstanceId) to create a custom image. You must make sure that the status of the specified instance is Running or Stopped. After a successful invocation, each disk of the specified instance has a new snapshot created.

        > **NOTE:**  If you want to create a custom image based on the system disk of your ECS instance, you can specify one of the system disk snapshots (SnapshotId) to create a custom image. However, the specified snapshot cannot be created on or before July 15, 2013.

        > **NOTE:**  If you want to combine snapshots of multiple disks into an image template, you can specify DiskDeviceMapping to create a custom image.

        For information about ECS Image and how to use it, see [What is Image](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-ecs-2014-05-26-createimage).

        > **NOTE:** Available since v1.64.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = alicloud.get_zones(available_resource_creation="Instance")
        default_get_instance_types = alicloud.ecs.get_instance_types(instance_type_family="ecs.sn1ne")
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            owners="system")
        default_network = alicloud.vpc.Network("default",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name="terraform-example",
            cidr_block="172.17.3.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name="terraform-example",
            vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("default",
            availability_zone=default.zones[0].id,
            instance_name="terraform-example",
            security_groups=[default_security_group.id],
            vswitch_id=default_switch.id,
            instance_type=default_get_instance_types.ids[0],
            image_id=default_get_images.ids[0],
            internet_max_bandwidth_out=10)
        default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_image = alicloud.ecs.Image("default",
            instance_id=default_instance.id,
            image_name=f"terraform-example-{default_integer['result']}",
            description="terraform-example",
            architecture="x86_64",
            resource_group_id=default_get_resource_groups.ids[0],
            tags={
                "FinanceDept": "FinanceDeptJoshua",
            })
        ```

        ## Import

        ECS Image can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/image:Image example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] architecture: The system architecture of the system disk. If you specify a data disk snapshot to create the system disk of the custom image, you must use Architecture to specify the system architecture of the system disk. Valid values: `i386`, `x86\\_64`, `arm64`. Default value: `x86\\_64`.
        :param pulumi.Input[_builtins.str] boot_mode: The new boot mode of the image. Valid values:
               
               *   BIOS: Basic Input/Output System (BIOS)
               
               *   UEFI: Unified Extensible Firmware Interface (UEFI)
               
               *   UEFI-Preferred: BIOS and UEFI
               
               > **NOTE:**   Before you change the boot mode, we recommend that you obtain the boot modes supported by the image. If you specify an unsupported boot mode for the image, ECS instances that use the image cannot start as expected. If you do not know which boot modes are supported by the image, we recommend that you use the image check feature to perform a check. For information about the image check feature, see [Overview](https://www.alibabacloud.com/help/en/doc-detail/439819.html).
               
               > **NOTE:**   For information about the UEFI-Preferred boot mode, see [Best practices for ECS instance boot modes](https://www.alibabacloud.com/help/en/doc-detail/2244655.html).
        :param pulumi.Input[_builtins.bool] delete_auto_snapshot: Not the public attribute and it used to automatically delete dependence snapshots while deleting the image.
        :param pulumi.Input[_builtins.str] description: The new description of the custom image. The description must be 2 to 256 characters in length It cannot start with `http://` or `https://`. This parameter is empty by default, which specifies that the original description is retained.
        :param pulumi.Input[_builtins.str] detection_strategy: The mode in which to check the custom image. If you do not specify this parameter, the image is not checked. Only the standard check mode is supported.
               
               > **NOTE:**   This parameter is supported for most Linux and Windows operating system versions. For information about image check items and operating system limits for image check, see [Overview of image check](https://www.alibabacloud.com/help/en/doc-detail/439819.html) and [Operating system limits for image check](https://www.alibabacloud.com/help/en/doc-detail/475800.html).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageDiskDeviceMappingArgs', 'ImageDiskDeviceMappingArgsDict']]]] disk_device_mappings: Snapshot information for the image See `disk_device_mapping` below.
        :param pulumi.Input[Union['ImageFeaturesArgs', 'ImageFeaturesArgsDict']] features: Features See `features` below.
        :param pulumi.Input[_builtins.bool] force: Whether to perform forced deletion. Value range:
               - true: forcibly deletes the custom image, ignoring whether the current image is used by other instances.
               - false: The custom image is deleted normally. Before deleting the custom image, check whether the current image is used by other instances.
               
               Default value: false
        :param pulumi.Input[_builtins.str] image_family: The name of the image family. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\\_), and hyphens (-). By default, this parameter is empty.
        :param pulumi.Input[_builtins.str] image_name: The name of the custom image. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\\_), and hyphens (-). By default, this parameter is empty. In this case, the original name is retained.
        :param pulumi.Input[_builtins.str] image_version: The image version.
               
               > **NOTE:**  If you specify an instance by configuring `InstanceId`, and the instance uses an Alibaba Cloud Marketplace image or a custom image that is created from an Alibaba Cloud Marketplace image, you must leave this parameter empty or set this parameter to the value of ImageVersion of the instance.
        :param pulumi.Input[_builtins.str] instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] license_type: The type of the license that is used to activate the operating system after the image is imported. Set the value to BYOL. BYOL: The license that comes with the source operating system is used. When you use the BYOL license, make sure that your license key is supported by Alibaba Cloud.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.227.0. New field 'image_name' instead.
        :param pulumi.Input[_builtins.str] platform: The operating system distribution for the system disk in the custom image. If you specify a data disk snapshot to create the system disk of the custom image, use Platform to specify the operating system distribution for the system disk. Valid values: `Aliyun`, `Anolis`, `CentOS`, `Ubuntu`, `CoreOS`, `SUSE`, `Debian`, `OpenSUSE`, `FreeBSD`, `RedHat`, `Kylin`, `UOS`, `Fedora`, `Fedora CoreOS`, `CentOS Stream`, `AlmaLinux`, `Rocky Linux`, `Gentoo`, `Customized Linux`, `Others Linux`, `Windows Server 2022`, `Windows Server 2019`, `Windows Server 2016`, `Windows Server 2012`, `Windows Server 2008`, `Windows Server 2003`. Default value: `Others Linux`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which to assign the custom image. If you do not specify this parameter, the image is assigned to the default resource group.
               
               > **NOTE:**   If you call the CreateImage operation as a Resource Access Management (RAM) user who does not have the permissions to manage the default resource group and do not specify `ResourceGroupId`, the `Forbbiden: User not authorized to operate on the specified resource` error message is returned. You must specify the ID of a resource group that the RAM user has the permissions to manage or grant the RAM user the permissions to manage the default resource group before you call the CreateImage operation again.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the snapshot that you want to use to create the custom image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ImageArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECS Image resource.

        > **NOTE:**  If you want to create a template from an ECS instance, you can specify the instance ID (InstanceId) to create a custom image. You must make sure that the status of the specified instance is Running or Stopped. After a successful invocation, each disk of the specified instance has a new snapshot created.

        > **NOTE:**  If you want to create a custom image based on the system disk of your ECS instance, you can specify one of the system disk snapshots (SnapshotId) to create a custom image. However, the specified snapshot cannot be created on or before July 15, 2013.

        > **NOTE:**  If you want to combine snapshots of multiple disks into an image template, you can specify DiskDeviceMapping to create a custom image.

        For information about ECS Image and how to use it, see [What is Image](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-ecs-2014-05-26-createimage).

        > **NOTE:** Available since v1.64.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = alicloud.get_zones(available_resource_creation="Instance")
        default_get_instance_types = alicloud.ecs.get_instance_types(instance_type_family="ecs.sn1ne")
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            owners="system")
        default_network = alicloud.vpc.Network("default",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name="terraform-example",
            cidr_block="172.17.3.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name="terraform-example",
            vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("default",
            availability_zone=default.zones[0].id,
            instance_name="terraform-example",
            security_groups=[default_security_group.id],
            vswitch_id=default_switch.id,
            instance_type=default_get_instance_types.ids[0],
            image_id=default_get_images.ids[0],
            internet_max_bandwidth_out=10)
        default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_image = alicloud.ecs.Image("default",
            instance_id=default_instance.id,
            image_name=f"terraform-example-{default_integer['result']}",
            description="terraform-example",
            architecture="x86_64",
            resource_group_id=default_get_resource_groups.ids[0],
            tags={
                "FinanceDept": "FinanceDeptJoshua",
            })
        ```

        ## Import

        ECS Image can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/image:Image example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_auto_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detection_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageDiskDeviceMappingArgs', 'ImageDiskDeviceMappingArgsDict']]]]] = None,
                 features: Optional[pulumi.Input[Union['ImageFeaturesArgs', 'ImageFeaturesArgsDict']]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_family: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_version: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageArgs.__new__(ImageArgs)

            __props__.__dict__["architecture"] = architecture
            __props__.__dict__["boot_mode"] = boot_mode
            __props__.__dict__["delete_auto_snapshot"] = delete_auto_snapshot
            __props__.__dict__["description"] = description
            __props__.__dict__["detection_strategy"] = detection_strategy
            __props__.__dict__["disk_device_mappings"] = disk_device_mappings
            __props__.__dict__["features"] = features
            __props__.__dict__["force"] = force
            __props__.__dict__["image_family"] = image_family
            __props__.__dict__["image_name"] = image_name
            __props__.__dict__["image_version"] = image_version
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["name"] = name
            __props__.__dict__["platform"] = platform
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Image, __self__).__init__(
            'alicloud:ecs/image:Image',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            architecture: Optional[pulumi.Input[_builtins.str]] = None,
            boot_mode: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            delete_auto_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            detection_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            disk_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageDiskDeviceMappingArgs', 'ImageDiskDeviceMappingArgsDict']]]]] = None,
            features: Optional[pulumi.Input[Union['ImageFeaturesArgs', 'ImageFeaturesArgsDict']]] = None,
            force: Optional[pulumi.Input[_builtins.bool]] = None,
            image_family: Optional[pulumi.Input[_builtins.str]] = None,
            image_name: Optional[pulumi.Input[_builtins.str]] = None,
            image_version: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            license_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            platform: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Image':
        """
        Get an existing Image resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] architecture: The system architecture of the system disk. If you specify a data disk snapshot to create the system disk of the custom image, you must use Architecture to specify the system architecture of the system disk. Valid values: `i386`, `x86\\_64`, `arm64`. Default value: `x86\\_64`.
        :param pulumi.Input[_builtins.str] boot_mode: The new boot mode of the image. Valid values:
               
               *   BIOS: Basic Input/Output System (BIOS)
               
               *   UEFI: Unified Extensible Firmware Interface (UEFI)
               
               *   UEFI-Preferred: BIOS and UEFI
               
               > **NOTE:**   Before you change the boot mode, we recommend that you obtain the boot modes supported by the image. If you specify an unsupported boot mode for the image, ECS instances that use the image cannot start as expected. If you do not know which boot modes are supported by the image, we recommend that you use the image check feature to perform a check. For information about the image check feature, see [Overview](https://www.alibabacloud.com/help/en/doc-detail/439819.html).
               
               > **NOTE:**   For information about the UEFI-Preferred boot mode, see [Best practices for ECS instance boot modes](https://www.alibabacloud.com/help/en/doc-detail/2244655.html).
        :param pulumi.Input[_builtins.str] create_time: The create time
        :param pulumi.Input[_builtins.bool] delete_auto_snapshot: Not the public attribute and it used to automatically delete dependence snapshots while deleting the image.
        :param pulumi.Input[_builtins.str] description: The new description of the custom image. The description must be 2 to 256 characters in length It cannot start with `http://` or `https://`. This parameter is empty by default, which specifies that the original description is retained.
        :param pulumi.Input[_builtins.str] detection_strategy: The mode in which to check the custom image. If you do not specify this parameter, the image is not checked. Only the standard check mode is supported.
               
               > **NOTE:**   This parameter is supported for most Linux and Windows operating system versions. For information about image check items and operating system limits for image check, see [Overview of image check](https://www.alibabacloud.com/help/en/doc-detail/439819.html) and [Operating system limits for image check](https://www.alibabacloud.com/help/en/doc-detail/475800.html).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageDiskDeviceMappingArgs', 'ImageDiskDeviceMappingArgsDict']]]] disk_device_mappings: Snapshot information for the image See `disk_device_mapping` below.
        :param pulumi.Input[Union['ImageFeaturesArgs', 'ImageFeaturesArgsDict']] features: Features See `features` below.
        :param pulumi.Input[_builtins.bool] force: Whether to perform forced deletion. Value range:
               - true: forcibly deletes the custom image, ignoring whether the current image is used by other instances.
               - false: The custom image is deleted normally. Before deleting the custom image, check whether the current image is used by other instances.
               
               Default value: false
        :param pulumi.Input[_builtins.str] image_family: The name of the image family. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\\_), and hyphens (-). By default, this parameter is empty.
        :param pulumi.Input[_builtins.str] image_name: The name of the custom image. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\\_), and hyphens (-). By default, this parameter is empty. In this case, the original name is retained.
        :param pulumi.Input[_builtins.str] image_version: The image version.
               
               > **NOTE:**  If you specify an instance by configuring `InstanceId`, and the instance uses an Alibaba Cloud Marketplace image or a custom image that is created from an Alibaba Cloud Marketplace image, you must leave this parameter empty or set this parameter to the value of ImageVersion of the instance.
        :param pulumi.Input[_builtins.str] instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] license_type: The type of the license that is used to activate the operating system after the image is imported. Set the value to BYOL. BYOL: The license that comes with the source operating system is used. When you use the BYOL license, make sure that your license key is supported by Alibaba Cloud.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.227.0. New field 'image_name' instead.
        :param pulumi.Input[_builtins.str] platform: The operating system distribution for the system disk in the custom image. If you specify a data disk snapshot to create the system disk of the custom image, use Platform to specify the operating system distribution for the system disk. Valid values: `Aliyun`, `Anolis`, `CentOS`, `Ubuntu`, `CoreOS`, `SUSE`, `Debian`, `OpenSUSE`, `FreeBSD`, `RedHat`, `Kylin`, `UOS`, `Fedora`, `Fedora CoreOS`, `CentOS Stream`, `AlmaLinux`, `Rocky Linux`, `Gentoo`, `Customized Linux`, `Others Linux`, `Windows Server 2022`, `Windows Server 2019`, `Windows Server 2016`, `Windows Server 2012`, `Windows Server 2008`, `Windows Server 2003`. Default value: `Others Linux`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which to assign the custom image. If you do not specify this parameter, the image is assigned to the default resource group.
               
               > **NOTE:**   If you call the CreateImage operation as a Resource Access Management (RAM) user who does not have the permissions to manage the default resource group and do not specify `ResourceGroupId`, the `Forbbiden: User not authorized to operate on the specified resource` error message is returned. You must specify the ID of a resource group that the RAM user has the permissions to manage or grant the RAM user the permissions to manage the default resource group before you call the CreateImage operation again.
        :param pulumi.Input[_builtins.str] snapshot_id: The ID of the snapshot that you want to use to create the custom image.
        :param pulumi.Input[_builtins.str] status: The status of the image. By default, if you do not specify this parameter, only images in the Available state are returned.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageState.__new__(_ImageState)

        __props__.__dict__["architecture"] = architecture
        __props__.__dict__["boot_mode"] = boot_mode
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_auto_snapshot"] = delete_auto_snapshot
        __props__.__dict__["description"] = description
        __props__.__dict__["detection_strategy"] = detection_strategy
        __props__.__dict__["disk_device_mappings"] = disk_device_mappings
        __props__.__dict__["features"] = features
        __props__.__dict__["force"] = force
        __props__.__dict__["image_family"] = image_family
        __props__.__dict__["image_name"] = image_name
        __props__.__dict__["image_version"] = image_version
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["name"] = name
        __props__.__dict__["platform"] = platform
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Image(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The system architecture of the system disk. If you specify a data disk snapshot to create the system disk of the custom image, you must use Architecture to specify the system architecture of the system disk. Valid values: `i386`, `x86\\_64`, `arm64`. Default value: `x86\\_64`.
        """
        return pulumi.get(self, "architecture")

    @_builtins.property
    @pulumi.getter(name="bootMode")
    def boot_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The new boot mode of the image. Valid values:

        *   BIOS: Basic Input/Output System (BIOS)

        *   UEFI: Unified Extensible Firmware Interface (UEFI)

        *   UEFI-Preferred: BIOS and UEFI

        > **NOTE:**   Before you change the boot mode, we recommend that you obtain the boot modes supported by the image. If you specify an unsupported boot mode for the image, ECS instances that use the image cannot start as expected. If you do not know which boot modes are supported by the image, we recommend that you use the image check feature to perform a check. For information about the image check feature, see [Overview](https://www.alibabacloud.com/help/en/doc-detail/439819.html).

        > **NOTE:**   For information about the UEFI-Preferred boot mode, see [Best practices for ECS instance boot modes](https://www.alibabacloud.com/help/en/doc-detail/2244655.html).
        """
        return pulumi.get(self, "boot_mode")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The create time
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deleteAutoSnapshot")
    def delete_auto_snapshot(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Not the public attribute and it used to automatically delete dependence snapshots while deleting the image.
        """
        return pulumi.get(self, "delete_auto_snapshot")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The new description of the custom image. The description must be 2 to 256 characters in length It cannot start with `http://` or `https://`. This parameter is empty by default, which specifies that the original description is retained.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="detectionStrategy")
    def detection_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The mode in which to check the custom image. If you do not specify this parameter, the image is not checked. Only the standard check mode is supported.

        > **NOTE:**   This parameter is supported for most Linux and Windows operating system versions. For information about image check items and operating system limits for image check, see [Overview of image check](https://www.alibabacloud.com/help/en/doc-detail/439819.html) and [Operating system limits for image check](https://www.alibabacloud.com/help/en/doc-detail/475800.html).
        """
        return pulumi.get(self, "detection_strategy")

    @_builtins.property
    @pulumi.getter(name="diskDeviceMappings")
    def disk_device_mappings(self) -> pulumi.Output[Sequence['outputs.ImageDiskDeviceMapping']]:
        """
        Snapshot information for the image See `disk_device_mapping` below.
        """
        return pulumi.get(self, "disk_device_mappings")

    @_builtins.property
    @pulumi.getter
    def features(self) -> pulumi.Output['outputs.ImageFeatures']:
        """
        Features See `features` below.
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to perform forced deletion. Value range:
        - true: forcibly deletes the custom image, ignoring whether the current image is used by other instances.
        - false: The custom image is deleted normally. Before deleting the custom image, check whether the current image is used by other instances.

        Default value: false
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter(name="imageFamily")
    def image_family(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the image family. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\\_), and hyphens (-). By default, this parameter is empty.
        """
        return pulumi.get(self, "image_family")

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the custom image. The name must be 2 to 128 characters in length. It must start with a letter and cannot start with acs: or aliyun. It cannot contain http:// or https://. It can contain letters, digits, periods (.), colons (:), underscores (\\_), and hyphens (-). By default, this parameter is empty. In this case, the original name is retained.
        """
        return pulumi.get(self, "image_name")

    @_builtins.property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The image version.

        > **NOTE:**  If you specify an instance by configuring `InstanceId`, and the instance uses an Alibaba Cloud Marketplace image or a custom image that is created from an Alibaba Cloud Marketplace image, you must leave this parameter empty or set this parameter to the value of ImageVersion of the instance.
        """
        return pulumi.get(self, "image_version")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the license that is used to activate the operating system after the image is imported. Set the value to BYOL. BYOL: The license that comes with the source operating system is used. When you use the BYOL license, make sure that your license key is supported by Alibaba Cloud.
        """
        return pulumi.get(self, "license_type")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.227.0. New field 'image_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'name' has been deprecated from provider version 1.227.0. New field 'image_name' instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> pulumi.Output[_builtins.str]:
        """
        The operating system distribution for the system disk in the custom image. If you specify a data disk snapshot to create the system disk of the custom image, use Platform to specify the operating system distribution for the system disk. Valid values: `Aliyun`, `Anolis`, `CentOS`, `Ubuntu`, `CoreOS`, `SUSE`, `Debian`, `OpenSUSE`, `FreeBSD`, `RedHat`, `Kylin`, `UOS`, `Fedora`, `Fedora CoreOS`, `CentOS Stream`, `AlmaLinux`, `Rocky Linux`, `Gentoo`, `Customized Linux`, `Others Linux`, `Windows Server 2022`, `Windows Server 2019`, `Windows Server 2016`, `Windows Server 2012`, `Windows Server 2008`, `Windows Server 2003`. Default value: `Others Linux`.
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group to which to assign the custom image. If you do not specify this parameter, the image is assigned to the default resource group.

        > **NOTE:**   If you call the CreateImage operation as a Resource Access Management (RAM) user who does not have the permissions to manage the default resource group and do not specify `ResourceGroupId`, the `Forbbiden: User not authorized to operate on the specified resource` error message is returned. You must specify the ID of a resource group that the RAM user has the permissions to manage or grant the RAM user the permissions to manage the default resource group before you call the CreateImage operation again.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the snapshot that you want to use to create the custom image.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the image. By default, if you do not specify this parameter, only images in the Available state are returned.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "tags")

