# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'K8sSlbAttachmentSlbConfigArgs',
    'K8sSlbAttachmentSlbConfigArgsDict',
    'K8sSlbAttachmentSlbConfigPortMappingArgs',
    'K8sSlbAttachmentSlbConfigPortMappingArgsDict',
    'K8sSlbAttachmentSlbConfigPortMappingServicePortArgs',
    'K8sSlbAttachmentSlbConfigPortMappingServicePortArgsDict',
]

MYPY = False

if not MYPY:
    class K8sSlbAttachmentSlbConfigArgsDict(TypedDict):
        port_mappings: pulumi.Input[Sequence[pulumi.Input['K8sSlbAttachmentSlbConfigPortMappingArgsDict']]]
        """
        The port configuration for SLB instance, which is supported for multiple configurations. See `port_mappings` below.
        """
        scheduler: pulumi.Input[_builtins.str]
        """
        The scheduler policy of SLB configuration, values can be 'rr'(round-robin) or 'wrr'(weighted round-robin).
        """
        type: pulumi.Input[_builtins.str]
        """
        The type of SLB instance, values can be 'internet' or 'intranet'.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of this SLB configuration, empty for auto-generated by EDAS server.
        """
        slb_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of your SLB instance, if value is empty which means EDAS will purchase an SLB instance with 'specification' field.
        """
        specification: NotRequired[pulumi.Input[_builtins.str]]
        """
        The instance specification of SLB, values can be found [here](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createloadbalancer-2#t4182.html), empty for 'slb.s1.small'.
        """
elif False:
    K8sSlbAttachmentSlbConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class K8sSlbAttachmentSlbConfigArgs:
    def __init__(__self__, *,
                 port_mappings: pulumi.Input[Sequence[pulumi.Input['K8sSlbAttachmentSlbConfigPortMappingArgs']]],
                 scheduler: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 slb_id: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['K8sSlbAttachmentSlbConfigPortMappingArgs']]] port_mappings: The port configuration for SLB instance, which is supported for multiple configurations. See `port_mappings` below.
        :param pulumi.Input[_builtins.str] scheduler: The scheduler policy of SLB configuration, values can be 'rr'(round-robin) or 'wrr'(weighted round-robin).
        :param pulumi.Input[_builtins.str] type: The type of SLB instance, values can be 'internet' or 'intranet'.
        :param pulumi.Input[_builtins.str] name: The name of this SLB configuration, empty for auto-generated by EDAS server.
        :param pulumi.Input[_builtins.str] slb_id: The ID of your SLB instance, if value is empty which means EDAS will purchase an SLB instance with 'specification' field.
        :param pulumi.Input[_builtins.str] specification: The instance specification of SLB, values can be found [here](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createloadbalancer-2#t4182.html), empty for 'slb.s1.small'.
        """
        pulumi.set(__self__, "port_mappings", port_mappings)
        pulumi.set(__self__, "scheduler", scheduler)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if slb_id is not None:
            pulumi.set(__self__, "slb_id", slb_id)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)

    @_builtins.property
    @pulumi.getter(name="portMappings")
    def port_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['K8sSlbAttachmentSlbConfigPortMappingArgs']]]:
        """
        The port configuration for SLB instance, which is supported for multiple configurations. See `port_mappings` below.
        """
        return pulumi.get(self, "port_mappings")

    @port_mappings.setter
    def port_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['K8sSlbAttachmentSlbConfigPortMappingArgs']]]):
        pulumi.set(self, "port_mappings", value)

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> pulumi.Input[_builtins.str]:
        """
        The scheduler policy of SLB configuration, values can be 'rr'(round-robin) or 'wrr'(weighted round-robin).
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scheduler", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of SLB instance, values can be 'internet' or 'intranet'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of this SLB configuration, empty for auto-generated by EDAS server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="slbId")
    def slb_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of your SLB instance, if value is empty which means EDAS will purchase an SLB instance with 'specification' field.
        """
        return pulumi.get(self, "slb_id")

    @slb_id.setter
    def slb_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slb_id", value)

    @_builtins.property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance specification of SLB, values can be found [here](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createloadbalancer-2#t4182.html), empty for 'slb.s1.small'.
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "specification", value)


if not MYPY:
    class K8sSlbAttachmentSlbConfigPortMappingArgsDict(TypedDict):
        loadbalancer_protocol: pulumi.Input[_builtins.str]
        """
        The protocol of SLB instance configuration, values can be 'TCP', 'HTTP' or 'HTTPS'.
        """
        service_port: pulumi.Input['K8sSlbAttachmentSlbConfigPortMappingServicePortArgsDict']
        """
        The backend k8s service configuration for SLB instance, which is supported for multiple configurations. See `service_port` below.
        """
        cert_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of your tls certification, this is used for 'HTTPS' protocol only.
        """
elif False:
    K8sSlbAttachmentSlbConfigPortMappingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class K8sSlbAttachmentSlbConfigPortMappingArgs:
    def __init__(__self__, *,
                 loadbalancer_protocol: pulumi.Input[_builtins.str],
                 service_port: pulumi.Input['K8sSlbAttachmentSlbConfigPortMappingServicePortArgs'],
                 cert_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] loadbalancer_protocol: The protocol of SLB instance configuration, values can be 'TCP', 'HTTP' or 'HTTPS'.
        :param pulumi.Input['K8sSlbAttachmentSlbConfigPortMappingServicePortArgs'] service_port: The backend k8s service configuration for SLB instance, which is supported for multiple configurations. See `service_port` below.
        :param pulumi.Input[_builtins.str] cert_id: The ID of your tls certification, this is used for 'HTTPS' protocol only.
        """
        pulumi.set(__self__, "loadbalancer_protocol", loadbalancer_protocol)
        pulumi.set(__self__, "service_port", service_port)
        if cert_id is not None:
            pulumi.set(__self__, "cert_id", cert_id)

    @_builtins.property
    @pulumi.getter(name="loadbalancerProtocol")
    def loadbalancer_protocol(self) -> pulumi.Input[_builtins.str]:
        """
        The protocol of SLB instance configuration, values can be 'TCP', 'HTTP' or 'HTTPS'.
        """
        return pulumi.get(self, "loadbalancer_protocol")

    @loadbalancer_protocol.setter
    def loadbalancer_protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "loadbalancer_protocol", value)

    @_builtins.property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> pulumi.Input['K8sSlbAttachmentSlbConfigPortMappingServicePortArgs']:
        """
        The backend k8s service configuration for SLB instance, which is supported for multiple configurations. See `service_port` below.
        """
        return pulumi.get(self, "service_port")

    @service_port.setter
    def service_port(self, value: pulumi.Input['K8sSlbAttachmentSlbConfigPortMappingServicePortArgs']):
        pulumi.set(self, "service_port", value)

    @_builtins.property
    @pulumi.getter(name="certId")
    def cert_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of your tls certification, this is used for 'HTTPS' protocol only.
        """
        return pulumi.get(self, "cert_id")

    @cert_id.setter
    def cert_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_id", value)


if not MYPY:
    class K8sSlbAttachmentSlbConfigPortMappingServicePortArgsDict(TypedDict):
        port: pulumi.Input[_builtins.int]
        """
        The port of k8s service, values should be within range [1, 65535].
        """
        protocol: pulumi.Input[_builtins.str]
        """
        The protocol of k8s service, values can be 'TCP' or 'UDP'.
        """
        target_port: pulumi.Input[_builtins.int]
        """
        The port of k8s pod, values should be within range [1, 65535].
        """
elif False:
    K8sSlbAttachmentSlbConfigPortMappingServicePortArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class K8sSlbAttachmentSlbConfigPortMappingServicePortArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[_builtins.int],
                 protocol: pulumi.Input[_builtins.str],
                 target_port: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.int] port: The port of k8s service, values should be within range [1, 65535].
        :param pulumi.Input[_builtins.str] protocol: The protocol of k8s service, values can be 'TCP' or 'UDP'.
        :param pulumi.Input[_builtins.int] target_port: The port of k8s pod, values should be within range [1, 65535].
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "target_port", target_port)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        The port of k8s service, values should be within range [1, 65535].
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        The protocol of k8s service, values can be 'TCP' or 'UDP'.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> pulumi.Input[_builtins.int]:
        """
        The port of k8s pod, values should be within range [1, 65535].
        """
        return pulumi.get(self, "target_port")

    @target_port.setter
    def target_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "target_port", value)


