# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'K8sSlbAttachmentSlbConfig',
    'K8sSlbAttachmentSlbConfigPortMapping',
    'K8sSlbAttachmentSlbConfigPortMappingServicePort',
    'GetApplicationsApplicationResult',
    'GetClustersClusterResult',
    'GetDeployGroupsGroupResult',
    'GetNamespacesNamespaceResult',
]

@pulumi.output_type
class K8sSlbAttachmentSlbConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portMappings":
            suggest = "port_mappings"
        elif key == "slbId":
            suggest = "slb_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in K8sSlbAttachmentSlbConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        K8sSlbAttachmentSlbConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        K8sSlbAttachmentSlbConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port_mappings: Sequence['outputs.K8sSlbAttachmentSlbConfigPortMapping'],
                 scheduler: _builtins.str,
                 type: _builtins.str,
                 name: Optional[_builtins.str] = None,
                 slb_id: Optional[_builtins.str] = None,
                 specification: Optional[_builtins.str] = None):
        """
        :param Sequence['K8sSlbAttachmentSlbConfigPortMappingArgs'] port_mappings: The port configuration for SLB instance, which is supported for multiple configurations. See `port_mappings` below.
        :param _builtins.str scheduler: The scheduler policy of SLB configuration, values can be 'rr'(round-robin) or 'wrr'(weighted round-robin).
        :param _builtins.str type: The type of SLB instance, values can be 'internet' or 'intranet'.
        :param _builtins.str name: The name of this SLB configuration, empty for auto-generated by EDAS server.
        :param _builtins.str slb_id: The ID of your SLB instance, if value is empty which means EDAS will purchase an SLB instance with 'specification' field.
        :param _builtins.str specification: The instance specification of SLB, values can be found [here](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createloadbalancer-2#t4182.html), empty for 'slb.s1.small'.
        """
        pulumi.set(__self__, "port_mappings", port_mappings)
        pulumi.set(__self__, "scheduler", scheduler)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if slb_id is not None:
            pulumi.set(__self__, "slb_id", slb_id)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)

    @_builtins.property
    @pulumi.getter(name="portMappings")
    def port_mappings(self) -> Sequence['outputs.K8sSlbAttachmentSlbConfigPortMapping']:
        """
        The port configuration for SLB instance, which is supported for multiple configurations. See `port_mappings` below.
        """
        return pulumi.get(self, "port_mappings")

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> _builtins.str:
        """
        The scheduler policy of SLB configuration, values can be 'rr'(round-robin) or 'wrr'(weighted round-robin).
        """
        return pulumi.get(self, "scheduler")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of SLB instance, values can be 'internet' or 'intranet'.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of this SLB configuration, empty for auto-generated by EDAS server.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="slbId")
    def slb_id(self) -> Optional[_builtins.str]:
        """
        The ID of your SLB instance, if value is empty which means EDAS will purchase an SLB instance with 'specification' field.
        """
        return pulumi.get(self, "slb_id")

    @_builtins.property
    @pulumi.getter
    def specification(self) -> Optional[_builtins.str]:
        """
        The instance specification of SLB, values can be found [here](https://www.alibabacloud.com/help/en/server-load-balancer/latest/createloadbalancer-2#t4182.html), empty for 'slb.s1.small'.
        """
        return pulumi.get(self, "specification")


@pulumi.output_type
class K8sSlbAttachmentSlbConfigPortMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadbalancerProtocol":
            suggest = "loadbalancer_protocol"
        elif key == "servicePort":
            suggest = "service_port"
        elif key == "certId":
            suggest = "cert_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in K8sSlbAttachmentSlbConfigPortMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        K8sSlbAttachmentSlbConfigPortMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        K8sSlbAttachmentSlbConfigPortMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 loadbalancer_protocol: _builtins.str,
                 service_port: 'outputs.K8sSlbAttachmentSlbConfigPortMappingServicePort',
                 cert_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str loadbalancer_protocol: The protocol of SLB instance configuration, values can be 'TCP', 'HTTP' or 'HTTPS'.
        :param 'K8sSlbAttachmentSlbConfigPortMappingServicePortArgs' service_port: The backend k8s service configuration for SLB instance, which is supported for multiple configurations. See `service_port` below.
        :param _builtins.str cert_id: The ID of your tls certification, this is used for 'HTTPS' protocol only.
        """
        pulumi.set(__self__, "loadbalancer_protocol", loadbalancer_protocol)
        pulumi.set(__self__, "service_port", service_port)
        if cert_id is not None:
            pulumi.set(__self__, "cert_id", cert_id)

    @_builtins.property
    @pulumi.getter(name="loadbalancerProtocol")
    def loadbalancer_protocol(self) -> _builtins.str:
        """
        The protocol of SLB instance configuration, values can be 'TCP', 'HTTP' or 'HTTPS'.
        """
        return pulumi.get(self, "loadbalancer_protocol")

    @_builtins.property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> 'outputs.K8sSlbAttachmentSlbConfigPortMappingServicePort':
        """
        The backend k8s service configuration for SLB instance, which is supported for multiple configurations. See `service_port` below.
        """
        return pulumi.get(self, "service_port")

    @_builtins.property
    @pulumi.getter(name="certId")
    def cert_id(self) -> Optional[_builtins.str]:
        """
        The ID of your tls certification, this is used for 'HTTPS' protocol only.
        """
        return pulumi.get(self, "cert_id")


@pulumi.output_type
class K8sSlbAttachmentSlbConfigPortMappingServicePort(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetPort":
            suggest = "target_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in K8sSlbAttachmentSlbConfigPortMappingServicePort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        K8sSlbAttachmentSlbConfigPortMappingServicePort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        K8sSlbAttachmentSlbConfigPortMappingServicePort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 protocol: _builtins.str,
                 target_port: _builtins.int):
        """
        :param _builtins.int port: The port of k8s service, values should be within range [1, 65535].
        :param _builtins.str protocol: The protocol of k8s service, values can be 'TCP' or 'UDP'.
        :param _builtins.int target_port: The port of k8s pod, values should be within range [1, 65535].
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "target_port", target_port)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port of k8s service, values should be within range [1, 65535].
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol of k8s service, values can be 'TCP' or 'UDP'.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> _builtins.int:
        """
        The port of k8s pod, values should be within range [1, 65535].
        """
        return pulumi.get(self, "target_port")


@pulumi.output_type
class GetApplicationsApplicationResult(dict):
    def __init__(__self__, *,
                 app_id: _builtins.str,
                 app_name: _builtins.str,
                 application_type: _builtins.str,
                 build_package_id: _builtins.int,
                 cluster_id: _builtins.str,
                 cluster_type: _builtins.int,
                 region_id: _builtins.str):
        """
        :param _builtins.str app_id: The ID of the application that you want to deploy.
        :param _builtins.str app_name: The name of your EDAS application. Only letters '-' '_' and numbers are allowed. The length cannot exceed 36 characters.
        :param _builtins.str application_type: The type of the package for the deployment of the application that you want to create. The valid values are: WAR and JAR. We strongly recommend you to set this parameter when creating the application.
        :param _builtins.int build_package_id: The package ID of Enterprise Distributed Application Service (EDAS) Container.
        :param _builtins.str cluster_id: The ID of the cluster that you want to create the application.
        :param _builtins.int cluster_type: The type of the cluster that you want to create. Valid values: 1: Swarm cluster. 2: ECS cluster. 3: Kubernetes cluster.
        :param _builtins.str region_id: The ID of the namespace the application belongs to.
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "app_name", app_name)
        pulumi.set(__self__, "application_type", application_type)
        pulumi.set(__self__, "build_package_id", build_package_id)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "region_id", region_id)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> _builtins.str:
        """
        The ID of the application that you want to deploy.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> _builtins.str:
        """
        The name of your EDAS application. Only letters '-' '_' and numbers are allowed. The length cannot exceed 36 characters.
        """
        return pulumi.get(self, "app_name")

    @_builtins.property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> _builtins.str:
        """
        The type of the package for the deployment of the application that you want to create. The valid values are: WAR and JAR. We strongly recommend you to set this parameter when creating the application.
        """
        return pulumi.get(self, "application_type")

    @_builtins.property
    @pulumi.getter(name="buildPackageId")
    def build_package_id(self) -> _builtins.int:
        """
        The package ID of Enterprise Distributed Application Service (EDAS) Container.
        """
        return pulumi.get(self, "build_package_id")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the cluster that you want to create the application.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> _builtins.int:
        """
        The type of the cluster that you want to create. Valid values: 1: Swarm cluster. 2: ECS cluster. 3: Kubernetes cluster.
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The ID of the namespace the application belongs to.
        """
        return pulumi.get(self, "region_id")


@pulumi.output_type
class GetClustersClusterResult(dict):
    def __init__(__self__, *,
                 cluster_id: _builtins.str,
                 cluster_name: _builtins.str,
                 cluster_type: _builtins.int,
                 cpu: _builtins.int,
                 cpu_used: _builtins.int,
                 create_time: _builtins.int,
                 mem: _builtins.int,
                 mem_used: _builtins.int,
                 network_mode: _builtins.int,
                 node_num: _builtins.int,
                 region_id: _builtins.str,
                 update_time: _builtins.int,
                 vpc_id: _builtins.str):
        """
        :param _builtins.str cluster_id: The ID of the cluster that you want to create the application.
        :param _builtins.str cluster_name: The name of the cluster.
        :param _builtins.int cluster_type: The type of the cluster, Valid values: 1: Swarm cluster. 2: ECS cluster. 3: Kubernetes cluster.
        :param _builtins.int cpu: The total number of CPUs in the cluster.
        :param _builtins.int cpu_used: The number of used CPUs in the cluster.
        :param _builtins.int create_time: Cluster's creation time.
        :param _builtins.int mem: The total amount of memory in the cluser. Unit: MB.
        :param _builtins.int mem_used: The amount of used memory in the cluser. Unit: MB.
        :param _builtins.int network_mode: The network type of the cluster. Valid values: 1: classic network. 2: VPC.
        :param _builtins.int node_num: The number of the Elastic Compute Service (ECS) instances that are deployed to the cluster.
        :param _builtins.str region_id: The ID of the namespace the application belongs to.
        :param _builtins.int update_time: The time when the cluster was last updated.
        :param _builtins.str vpc_id: The ID of the Virtual Private Cloud (VPC) for the cluster.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "cpu_used", cpu_used)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "mem", mem)
        pulumi.set(__self__, "mem_used", mem_used)
        pulumi.set(__self__, "network_mode", network_mode)
        pulumi.set(__self__, "node_num", node_num)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the cluster that you want to create the application.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> _builtins.int:
        """
        The type of the cluster, Valid values: 1: Swarm cluster. 2: ECS cluster. 3: Kubernetes cluster.
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.int:
        """
        The total number of CPUs in the cluster.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="cpuUsed")
    def cpu_used(self) -> _builtins.int:
        """
        The number of used CPUs in the cluster.
        """
        return pulumi.get(self, "cpu_used")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.int:
        """
        Cluster's creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def mem(self) -> _builtins.int:
        """
        The total amount of memory in the cluser. Unit: MB.
        """
        return pulumi.get(self, "mem")

    @_builtins.property
    @pulumi.getter(name="memUsed")
    def mem_used(self) -> _builtins.int:
        """
        The amount of used memory in the cluser. Unit: MB.
        """
        return pulumi.get(self, "mem_used")

    @_builtins.property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> _builtins.int:
        """
        The network type of the cluster. Valid values: 1: classic network. 2: VPC.
        """
        return pulumi.get(self, "network_mode")

    @_builtins.property
    @pulumi.getter(name="nodeNum")
    def node_num(self) -> _builtins.int:
        """
        The number of the Elastic Compute Service (ECS) instances that are deployed to the cluster.
        """
        return pulumi.get(self, "node_num")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The ID of the namespace the application belongs to.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.int:
        """
        The time when the cluster was last updated.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the Virtual Private Cloud (VPC) for the cluster.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetDeployGroupsGroupResult(dict):
    def __init__(__self__, *,
                 app_id: _builtins.str,
                 app_version_id: _builtins.str,
                 cluster_id: _builtins.str,
                 create_time: _builtins.int,
                 group_id: _builtins.str,
                 group_name: _builtins.str,
                 group_type: _builtins.int,
                 package_version_id: _builtins.str,
                 update_time: _builtins.int):
        """
        :param _builtins.str app_id: ID of the EDAS application.
        :param _builtins.str app_version_id: The version of the deployment package for the application.
        :param _builtins.str cluster_id: The ID of the cluster that you want to create the application.
        :param _builtins.int create_time: The time when the instance group was created.
        :param _builtins.str group_id: The ID of the instance group.
        :param _builtins.str group_name: The name of the instance group. The length cannot exceed 64 characters.
        :param _builtins.int group_type: The type of the instance group. Valid values: 0: Default group. 1: Phased release is disabled for traffic management. 2: Phased release is enabled for traffic management.
        :param _builtins.str package_version_id: The version of the deployment package for the instance group that was created.
        :param _builtins.int update_time: The time when the instance group was updated.
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "app_version_id", app_version_id)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "group_type", group_type)
        pulumi.set(__self__, "package_version_id", package_version_id)
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> _builtins.str:
        """
        ID of the EDAS application.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="appVersionId")
    def app_version_id(self) -> _builtins.str:
        """
        The version of the deployment package for the application.
        """
        return pulumi.get(self, "app_version_id")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the cluster that you want to create the application.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.int:
        """
        The time when the instance group was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.str:
        """
        The ID of the instance group.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> _builtins.str:
        """
        The name of the instance group. The length cannot exceed 64 characters.
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> _builtins.int:
        """
        The type of the instance group. Valid values: 0: Default group. 1: Phased release is disabled for traffic management. 2: Phased release is enabled for traffic management.
        """
        return pulumi.get(self, "group_type")

    @_builtins.property
    @pulumi.getter(name="packageVersionId")
    def package_version_id(self) -> _builtins.str:
        """
        The version of the deployment package for the instance group that was created.
        """
        return pulumi.get(self, "package_version_id")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.int:
        """
        The time when the instance group was updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetNamespacesNamespaceResult(dict):
    def __init__(__self__, *,
                 belong_region: _builtins.str,
                 debug_enable: _builtins.bool,
                 description: _builtins.str,
                 id: _builtins.str,
                 namespace_id: _builtins.str,
                 namespace_logical_id: _builtins.str,
                 namespace_name: _builtins.str,
                 user_id: _builtins.str):
        """
        :param _builtins.str belong_region: The ID of the physical region to which the namespace belongs.
        :param _builtins.bool debug_enable: Indicates whether remote debugging is allowed in this region.
        :param _builtins.str description: The description of the namespace.
        :param _builtins.str id: The ID of the resource.
        :param _builtins.str namespace_id: The unique ID of the namespace generated by Enterprise Distributed Application Service (EDAS).
        :param _builtins.str namespace_logical_id: The ID of the namespace. **Note:** The ID cannot be changed after the namespace is created. The ID is in the format of `Physical region ID:Logical region identifier`.
        :param _builtins.str namespace_name: The name of the namespace.
        :param _builtins.str user_id: The ID of the Alibaba Cloud account to which the namespace belongs.
        """
        pulumi.set(__self__, "belong_region", belong_region)
        pulumi.set(__self__, "debug_enable", debug_enable)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "namespace_id", namespace_id)
        pulumi.set(__self__, "namespace_logical_id", namespace_logical_id)
        pulumi.set(__self__, "namespace_name", namespace_name)
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="belongRegion")
    def belong_region(self) -> _builtins.str:
        """
        The ID of the physical region to which the namespace belongs.
        """
        return pulumi.get(self, "belong_region")

    @_builtins.property
    @pulumi.getter(name="debugEnable")
    def debug_enable(self) -> _builtins.bool:
        """
        Indicates whether remote debugging is allowed in this region.
        """
        return pulumi.get(self, "debug_enable")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the namespace.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> _builtins.str:
        """
        The unique ID of the namespace generated by Enterprise Distributed Application Service (EDAS).
        """
        return pulumi.get(self, "namespace_id")

    @_builtins.property
    @pulumi.getter(name="namespaceLogicalId")
    def namespace_logical_id(self) -> _builtins.str:
        """
        The ID of the namespace. **Note:** The ID cannot be changed after the namespace is created. The ID is in the format of `Physical region ID:Logical region identifier`.
        """
        return pulumi.get(self, "namespace_logical_id")

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> _builtins.str:
        """
        The name of the namespace.
        """
        return pulumi.get(self, "namespace_name")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        """
        The ID of the Alibaba Cloud account to which the namespace belongs.
        """
        return pulumi.get(self, "user_id")


