# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NasFileSystemArgs', 'NasFileSystem']

@pulumi.input_type
class NasFileSystemArgs:
    def __init__(__self__, *,
                 office_site_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_target_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 nas_file_system_name: Optional[pulumi.Input[_builtins.str]] = None,
                 reset: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a NasFileSystem resource.
        :param pulumi.Input[_builtins.str] office_site_id: The ID of office site.
        :param pulumi.Input[_builtins.str] description: The description of nas file system.
        :param pulumi.Input[_builtins.str] file_system_id: The filesystem id of nas file system.
        :param pulumi.Input[_builtins.str] mount_target_domain: The domain of mount target.
        :param pulumi.Input[_builtins.str] nas_file_system_name: The name of nas file system.
        :param pulumi.Input[_builtins.bool] reset: The mount point is in an inactive state, reset the mount point of the NAS file system. Default to `false`.
        """
        pulumi.set(__self__, "office_site_id", office_site_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if mount_target_domain is not None:
            pulumi.set(__self__, "mount_target_domain", mount_target_domain)
        if nas_file_system_name is not None:
            pulumi.set(__self__, "nas_file_system_name", nas_file_system_name)
        if reset is not None:
            pulumi.set(__self__, "reset", reset)

    @_builtins.property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of office site.
        """
        return pulumi.get(self, "office_site_id")

    @office_site_id.setter
    def office_site_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "office_site_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of nas file system.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The filesystem id of nas file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="mountTargetDomain")
    def mount_target_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain of mount target.
        """
        return pulumi.get(self, "mount_target_domain")

    @mount_target_domain.setter
    def mount_target_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount_target_domain", value)

    @_builtins.property
    @pulumi.getter(name="nasFileSystemName")
    def nas_file_system_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of nas file system.
        """
        return pulumi.get(self, "nas_file_system_name")

    @nas_file_system_name.setter
    def nas_file_system_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nas_file_system_name", value)

    @_builtins.property
    @pulumi.getter
    def reset(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The mount point is in an inactive state, reset the mount point of the NAS file system. Default to `false`.
        """
        return pulumi.get(self, "reset")

    @reset.setter
    def reset(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reset", value)


@pulumi.input_type
class _NasFileSystemState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_target_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 nas_file_system_name: Optional[pulumi.Input[_builtins.str]] = None,
                 office_site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reset: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NasFileSystem resources.
        :param pulumi.Input[_builtins.str] description: The description of nas file system.
        :param pulumi.Input[_builtins.str] file_system_id: The filesystem id of nas file system.
        :param pulumi.Input[_builtins.str] mount_target_domain: The domain of mount target.
        :param pulumi.Input[_builtins.str] nas_file_system_name: The name of nas file system.
        :param pulumi.Input[_builtins.str] office_site_id: The ID of office site.
        :param pulumi.Input[_builtins.bool] reset: The mount point is in an inactive state, reset the mount point of the NAS file system. Default to `false`.
        :param pulumi.Input[_builtins.str] status: The status of nas file system. Valid values: `Pending`, `Running`, `Stopped`,`Deleting`, `Deleted`, `Invalid`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if mount_target_domain is not None:
            pulumi.set(__self__, "mount_target_domain", mount_target_domain)
        if nas_file_system_name is not None:
            pulumi.set(__self__, "nas_file_system_name", nas_file_system_name)
        if office_site_id is not None:
            pulumi.set(__self__, "office_site_id", office_site_id)
        if reset is not None:
            pulumi.set(__self__, "reset", reset)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of nas file system.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The filesystem id of nas file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="mountTargetDomain")
    def mount_target_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain of mount target.
        """
        return pulumi.get(self, "mount_target_domain")

    @mount_target_domain.setter
    def mount_target_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mount_target_domain", value)

    @_builtins.property
    @pulumi.getter(name="nasFileSystemName")
    def nas_file_system_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of nas file system.
        """
        return pulumi.get(self, "nas_file_system_name")

    @nas_file_system_name.setter
    def nas_file_system_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nas_file_system_name", value)

    @_builtins.property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of office site.
        """
        return pulumi.get(self, "office_site_id")

    @office_site_id.setter
    def office_site_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "office_site_id", value)

    @_builtins.property
    @pulumi.getter
    def reset(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The mount point is in an inactive state, reset the mount point of the NAS file system. Default to `false`.
        """
        return pulumi.get(self, "reset")

    @reset.setter
    def reset(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reset", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of nas file system. Valid values: `Pending`, `Running`, `Stopped`,`Deleting`, `Deleted`, `Invalid`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:eds/nasFileSystem:NasFileSystem")
class NasFileSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_target_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 nas_file_system_name: Optional[pulumi.Input[_builtins.str]] = None,
                 office_site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reset: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a ECD Nas File System resource.

        For information about ECD Nas File System and how to use it, see [What is Nas File System](https://www.alibabacloud.com/help/en/elastic-desktop-service/latest/api-reference-for-easy-use-1).

        > **NOTE:** Available since v1.141.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_simple_office_site = alicloud.eds.SimpleOfficeSite("default",
            cidr_block="172.16.0.0/12",
            enable_admin_access=False,
            desktop_access_type="Internet",
            office_site_name=f"{name}-{default['result']}")
        example = alicloud.eds.NasFileSystem("example",
            nas_file_system_name=name,
            office_site_id=default_simple_office_site.id,
            description=name)
        ```

        ## Import

        ECD Nas File System can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eds/nasFileSystem:NasFileSystem example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of nas file system.
        :param pulumi.Input[_builtins.str] file_system_id: The filesystem id of nas file system.
        :param pulumi.Input[_builtins.str] mount_target_domain: The domain of mount target.
        :param pulumi.Input[_builtins.str] nas_file_system_name: The name of nas file system.
        :param pulumi.Input[_builtins.str] office_site_id: The ID of office site.
        :param pulumi.Input[_builtins.bool] reset: The mount point is in an inactive state, reset the mount point of the NAS file system. Default to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NasFileSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECD Nas File System resource.

        For information about ECD Nas File System and how to use it, see [What is Nas File System](https://www.alibabacloud.com/help/en/elastic-desktop-service/latest/api-reference-for-easy-use-1).

        > **NOTE:** Available since v1.141.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_simple_office_site = alicloud.eds.SimpleOfficeSite("default",
            cidr_block="172.16.0.0/12",
            enable_admin_access=False,
            desktop_access_type="Internet",
            office_site_name=f"{name}-{default['result']}")
        example = alicloud.eds.NasFileSystem("example",
            nas_file_system_name=name,
            office_site_id=default_simple_office_site.id,
            description=name)
        ```

        ## Import

        ECD Nas File System can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eds/nasFileSystem:NasFileSystem example <id>
        ```

        :param str resource_name: The name of the resource.
        :param NasFileSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NasFileSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_target_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 nas_file_system_name: Optional[pulumi.Input[_builtins.str]] = None,
                 office_site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reset: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NasFileSystemArgs.__new__(NasFileSystemArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["file_system_id"] = file_system_id
            __props__.__dict__["mount_target_domain"] = mount_target_domain
            __props__.__dict__["nas_file_system_name"] = nas_file_system_name
            if office_site_id is None and not opts.urn:
                raise TypeError("Missing required property 'office_site_id'")
            __props__.__dict__["office_site_id"] = office_site_id
            __props__.__dict__["reset"] = reset
            __props__.__dict__["status"] = None
        super(NasFileSystem, __self__).__init__(
            'alicloud:eds/nasFileSystem:NasFileSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            mount_target_domain: Optional[pulumi.Input[_builtins.str]] = None,
            nas_file_system_name: Optional[pulumi.Input[_builtins.str]] = None,
            office_site_id: Optional[pulumi.Input[_builtins.str]] = None,
            reset: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'NasFileSystem':
        """
        Get an existing NasFileSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of nas file system.
        :param pulumi.Input[_builtins.str] file_system_id: The filesystem id of nas file system.
        :param pulumi.Input[_builtins.str] mount_target_domain: The domain of mount target.
        :param pulumi.Input[_builtins.str] nas_file_system_name: The name of nas file system.
        :param pulumi.Input[_builtins.str] office_site_id: The ID of office site.
        :param pulumi.Input[_builtins.bool] reset: The mount point is in an inactive state, reset the mount point of the NAS file system. Default to `false`.
        :param pulumi.Input[_builtins.str] status: The status of nas file system. Valid values: `Pending`, `Running`, `Stopped`,`Deleting`, `Deleted`, `Invalid`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NasFileSystemState.__new__(_NasFileSystemState)

        __props__.__dict__["description"] = description
        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["mount_target_domain"] = mount_target_domain
        __props__.__dict__["nas_file_system_name"] = nas_file_system_name
        __props__.__dict__["office_site_id"] = office_site_id
        __props__.__dict__["reset"] = reset
        __props__.__dict__["status"] = status
        return NasFileSystem(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of nas file system.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        The filesystem id of nas file system.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter(name="mountTargetDomain")
    def mount_target_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The domain of mount target.
        """
        return pulumi.get(self, "mount_target_domain")

    @_builtins.property
    @pulumi.getter(name="nasFileSystemName")
    def nas_file_system_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of nas file system.
        """
        return pulumi.get(self, "nas_file_system_name")

    @_builtins.property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of office site.
        """
        return pulumi.get(self, "office_site_id")

    @_builtins.property
    @pulumi.getter
    def reset(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The mount point is in an inactive state, reset the mount point of the NAS file system. Default to `false`.
        """
        return pulumi.get(self, "reset")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of nas file system. Valid values: `Pending`, `Running`, `Stopped`,`Deleting`, `Deleted`, `Invalid`.
        """
        return pulumi.get(self, "status")

