# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterComponent',
    'ClusterComponentComponentConfig',
    'ClusterNetworks',
    'ClusterNetworksIpAllocationPolicy',
    'ClusterNetworksIpAllocationPolicyBondPolicy',
    'ClusterNetworksIpAllocationPolicyBondPolicyBond',
    'ClusterNetworksIpAllocationPolicyMachineTypePolicy',
    'ClusterNetworksIpAllocationPolicyMachineTypePolicyBond',
    'ClusterNetworksIpAllocationPolicyNodePolicy',
    'ClusterNetworksIpAllocationPolicyNodePolicyBond',
    'ClusterNetworksNewVpdInfo',
    'ClusterNetworksNewVpdInfoVpdSubnet',
    'ClusterNetworksVpdInfo',
    'ClusterNodeGroup',
    'ClusterNodeGroupNode',
    'ExperimentPlanTemplateTemplatePipeline',
    'ExperimentPlanTemplateTemplatePipelineEnvParams',
    'NodeGroupAttachmentDataDisk',
    'NodeGroupIpAllocationPolicy',
    'NodeGroupIpAllocationPolicyBondPolicy',
    'NodeGroupIpAllocationPolicyBondPolicyBond',
    'NodeGroupIpAllocationPolicyMachineTypePolicy',
    'NodeGroupIpAllocationPolicyMachineTypePolicyBond',
    'NodeGroupIpAllocationPolicyNodePolicy',
    'NodeGroupIpAllocationPolicyNodePolicyBond',
    'NodeGroupNode',
    'ResourceMachineTypes',
    'ResourceUserAccessParam',
    'GetSubnetsSubnetResult',
    'GetVpdsVpdResult',
]

@pulumi.output_type
class ClusterComponent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentConfig":
            suggest = "component_config"
        elif key == "componentType":
            suggest = "component_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterComponent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterComponent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterComponent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_config: Optional['outputs.ClusterComponentComponentConfig'] = None,
                 component_type: Optional[_builtins.str] = None):
        """
        :param 'ClusterComponentComponentConfigArgs' component_config: Component Configuration See `component_config` below.
        :param _builtins.str component_type: Component Type
        """
        if component_config is not None:
            pulumi.set(__self__, "component_config", component_config)
        if component_type is not None:
            pulumi.set(__self__, "component_type", component_type)

    @_builtins.property
    @pulumi.getter(name="componentConfig")
    def component_config(self) -> Optional['outputs.ClusterComponentComponentConfig']:
        """
        Component Configuration See `component_config` below.
        """
        return pulumi.get(self, "component_config")

    @_builtins.property
    @pulumi.getter(name="componentType")
    def component_type(self) -> Optional[_builtins.str]:
        """
        Component Type
        """
        return pulumi.get(self, "component_type")


@pulumi.output_type
class ClusterComponentComponentConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicArgs":
            suggest = "basic_args"
        elif key == "nodeUnits":
            suggest = "node_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterComponentComponentConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterComponentComponentConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterComponentComponentConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_args: Optional[_builtins.str] = None,
                 node_units: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str basic_args: Component Basic Parameters
        :param Sequence[_builtins.str] node_units: Node pool configuration, and is used to establish the corresponding relationship between node groups and node pools. When
               ComponentType = "ACKEdge" is required. Other values are empty.
        """
        if basic_args is not None:
            pulumi.set(__self__, "basic_args", basic_args)
        if node_units is not None:
            pulumi.set(__self__, "node_units", node_units)

    @_builtins.property
    @pulumi.getter(name="basicArgs")
    def basic_args(self) -> Optional[_builtins.str]:
        """
        Component Basic Parameters
        """
        return pulumi.get(self, "basic_args")

    @_builtins.property
    @pulumi.getter(name="nodeUnits")
    def node_units(self) -> Optional[Sequence[_builtins.str]]:
        """
        Node pool configuration, and is used to establish the corresponding relationship between node groups and node pools. When
        ComponentType = "ACKEdge" is required. Other values are empty.
        """
        return pulumi.get(self, "node_units")


@pulumi.output_type
class ClusterNetworks(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAllocationPolicies":
            suggest = "ip_allocation_policies"
        elif key == "newVpdInfo":
            suggest = "new_vpd_info"
        elif key == "securityGroupId":
            suggest = "security_group_id"
        elif key == "tailIpVersion":
            suggest = "tail_ip_version"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "vpdInfo":
            suggest = "vpd_info"
        elif key == "vswitchId":
            suggest = "vswitch_id"
        elif key == "vswitchZoneId":
            suggest = "vswitch_zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetworks. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetworks.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetworks.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_allocation_policies: Optional[Sequence['outputs.ClusterNetworksIpAllocationPolicy']] = None,
                 new_vpd_info: Optional['outputs.ClusterNetworksNewVpdInfo'] = None,
                 security_group_id: Optional[_builtins.str] = None,
                 tail_ip_version: Optional[_builtins.str] = None,
                 vpc_id: Optional[_builtins.str] = None,
                 vpd_info: Optional['outputs.ClusterNetworksVpdInfo'] = None,
                 vswitch_id: Optional[_builtins.str] = None,
                 vswitch_zone_id: Optional[_builtins.str] = None):
        """
        :param Sequence['ClusterNetworksIpAllocationPolicyArgs'] ip_allocation_policies: IP allocation policy See `ip_allocation_policy` below.
        :param 'ClusterNetworksNewVpdInfoArgs' new_vpd_info: Vpd configuration information See `new_vpd_info` below.
        :param _builtins.str security_group_id: Security group ID
        :param _builtins.str tail_ip_version: IP version
        :param _builtins.str vpc_id: VPC ID
        :param 'ClusterNetworksVpdInfoArgs' vpd_info: Multiplexing VPD information See `vpd_info` below.
        :param _builtins.str vswitch_id: Switch ID
        :param _builtins.str vswitch_zone_id: Switch ZoneID
        """
        if ip_allocation_policies is not None:
            pulumi.set(__self__, "ip_allocation_policies", ip_allocation_policies)
        if new_vpd_info is not None:
            pulumi.set(__self__, "new_vpd_info", new_vpd_info)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if tail_ip_version is not None:
            pulumi.set(__self__, "tail_ip_version", tail_ip_version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpd_info is not None:
            pulumi.set(__self__, "vpd_info", vpd_info)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if vswitch_zone_id is not None:
            pulumi.set(__self__, "vswitch_zone_id", vswitch_zone_id)

    @_builtins.property
    @pulumi.getter(name="ipAllocationPolicies")
    def ip_allocation_policies(self) -> Optional[Sequence['outputs.ClusterNetworksIpAllocationPolicy']]:
        """
        IP allocation policy See `ip_allocation_policy` below.
        """
        return pulumi.get(self, "ip_allocation_policies")

    @_builtins.property
    @pulumi.getter(name="newVpdInfo")
    def new_vpd_info(self) -> Optional['outputs.ClusterNetworksNewVpdInfo']:
        """
        Vpd configuration information See `new_vpd_info` below.
        """
        return pulumi.get(self, "new_vpd_info")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[_builtins.str]:
        """
        Security group ID
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="tailIpVersion")
    def tail_ip_version(self) -> Optional[_builtins.str]:
        """
        IP version
        """
        return pulumi.get(self, "tail_ip_version")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        VPC ID
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpdInfo")
    def vpd_info(self) -> Optional['outputs.ClusterNetworksVpdInfo']:
        """
        Multiplexing VPD information See `vpd_info` below.
        """
        return pulumi.get(self, "vpd_info")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[_builtins.str]:
        """
        Switch ID
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="vswitchZoneId")
    def vswitch_zone_id(self) -> Optional[_builtins.str]:
        """
        Switch ZoneID
        """
        return pulumi.get(self, "vswitch_zone_id")


@pulumi.output_type
class ClusterNetworksIpAllocationPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bondPolicy":
            suggest = "bond_policy"
        elif key == "machineTypePolicies":
            suggest = "machine_type_policies"
        elif key == "nodePolicies":
            suggest = "node_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetworksIpAllocationPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetworksIpAllocationPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetworksIpAllocationPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bond_policy: Optional['outputs.ClusterNetworksIpAllocationPolicyBondPolicy'] = None,
                 machine_type_policies: Optional[Sequence['outputs.ClusterNetworksIpAllocationPolicyMachineTypePolicy']] = None,
                 node_policies: Optional[Sequence['outputs.ClusterNetworksIpAllocationPolicyNodePolicy']] = None):
        """
        :param 'ClusterNetworksIpAllocationPolicyBondPolicyArgs' bond_policy: Bond policy See `bond_policy` below.
        :param Sequence['ClusterNetworksIpAllocationPolicyMachineTypePolicyArgs'] machine_type_policies: Model Assignment Policy See `machine_type_policy` below.
        :param Sequence['ClusterNetworksIpAllocationPolicyNodePolicyArgs'] node_policies: Node allocation policy See `node_policy` below.
        """
        if bond_policy is not None:
            pulumi.set(__self__, "bond_policy", bond_policy)
        if machine_type_policies is not None:
            pulumi.set(__self__, "machine_type_policies", machine_type_policies)
        if node_policies is not None:
            pulumi.set(__self__, "node_policies", node_policies)

    @_builtins.property
    @pulumi.getter(name="bondPolicy")
    def bond_policy(self) -> Optional['outputs.ClusterNetworksIpAllocationPolicyBondPolicy']:
        """
        Bond policy See `bond_policy` below.
        """
        return pulumi.get(self, "bond_policy")

    @_builtins.property
    @pulumi.getter(name="machineTypePolicies")
    def machine_type_policies(self) -> Optional[Sequence['outputs.ClusterNetworksIpAllocationPolicyMachineTypePolicy']]:
        """
        Model Assignment Policy See `machine_type_policy` below.
        """
        return pulumi.get(self, "machine_type_policies")

    @_builtins.property
    @pulumi.getter(name="nodePolicies")
    def node_policies(self) -> Optional[Sequence['outputs.ClusterNetworksIpAllocationPolicyNodePolicy']]:
        """
        Node allocation policy See `node_policy` below.
        """
        return pulumi.get(self, "node_policies")


@pulumi.output_type
class ClusterNetworksIpAllocationPolicyBondPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bondDefaultSubnet":
            suggest = "bond_default_subnet"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetworksIpAllocationPolicyBondPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetworksIpAllocationPolicyBondPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetworksIpAllocationPolicyBondPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bond_default_subnet: Optional[_builtins.str] = None,
                 bonds: Optional[Sequence['outputs.ClusterNetworksIpAllocationPolicyBondPolicyBond']] = None):
        """
        :param _builtins.str bond_default_subnet: Default bond cluster subnet
        :param Sequence['ClusterNetworksIpAllocationPolicyBondPolicyBondArgs'] bonds: Bond information See `bonds` below.
        """
        if bond_default_subnet is not None:
            pulumi.set(__self__, "bond_default_subnet", bond_default_subnet)
        if bonds is not None:
            pulumi.set(__self__, "bonds", bonds)

    @_builtins.property
    @pulumi.getter(name="bondDefaultSubnet")
    def bond_default_subnet(self) -> Optional[_builtins.str]:
        """
        Default bond cluster subnet
        """
        return pulumi.get(self, "bond_default_subnet")

    @_builtins.property
    @pulumi.getter
    def bonds(self) -> Optional[Sequence['outputs.ClusterNetworksIpAllocationPolicyBondPolicyBond']]:
        """
        Bond information See `bonds` below.
        """
        return pulumi.get(self, "bonds")


@pulumi.output_type
class ClusterNetworksIpAllocationPolicyBondPolicyBond(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 subnet: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The bond name
        :param _builtins.str subnet: IP source cluster subnet
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The bond name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[_builtins.str]:
        """
        IP source cluster subnet
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class ClusterNetworksIpAllocationPolicyMachineTypePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineType":
            suggest = "machine_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetworksIpAllocationPolicyMachineTypePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetworksIpAllocationPolicyMachineTypePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetworksIpAllocationPolicyMachineTypePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bonds: Optional[Sequence['outputs.ClusterNetworksIpAllocationPolicyMachineTypePolicyBond']] = None,
                 machine_type: Optional[_builtins.str] = None):
        """
        :param Sequence['ClusterNetworksIpAllocationPolicyMachineTypePolicyBondArgs'] bonds: Bond information See `bonds` below.
        """
        if bonds is not None:
            pulumi.set(__self__, "bonds", bonds)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)

    @_builtins.property
    @pulumi.getter
    def bonds(self) -> Optional[Sequence['outputs.ClusterNetworksIpAllocationPolicyMachineTypePolicyBond']]:
        """
        Bond information See `bonds` below.
        """
        return pulumi.get(self, "bonds")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "machine_type")


@pulumi.output_type
class ClusterNetworksIpAllocationPolicyMachineTypePolicyBond(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 subnet: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The bond name
        :param _builtins.str subnet: IP source cluster subnet
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The bond name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[_builtins.str]:
        """
        IP source cluster subnet
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class ClusterNetworksIpAllocationPolicyNodePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeId":
            suggest = "node_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetworksIpAllocationPolicyNodePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetworksIpAllocationPolicyNodePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetworksIpAllocationPolicyNodePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bonds: Optional[Sequence['outputs.ClusterNetworksIpAllocationPolicyNodePolicyBond']] = None,
                 node_id: Optional[_builtins.str] = None):
        """
        :param Sequence['ClusterNetworksIpAllocationPolicyNodePolicyBondArgs'] bonds: Bond information See `bonds` below.
        """
        if bonds is not None:
            pulumi.set(__self__, "bonds", bonds)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)

    @_builtins.property
    @pulumi.getter
    def bonds(self) -> Optional[Sequence['outputs.ClusterNetworksIpAllocationPolicyNodePolicyBond']]:
        """
        Bond information See `bonds` below.
        """
        return pulumi.get(self, "bonds")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "node_id")


@pulumi.output_type
class ClusterNetworksIpAllocationPolicyNodePolicyBond(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 subnet: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The bond name
        :param _builtins.str subnet: IP source cluster subnet
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The bond name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[_builtins.str]:
        """
        IP source cluster subnet
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class ClusterNetworksNewVpdInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cenId":
            suggest = "cen_id"
        elif key == "cloudLinkCidr":
            suggest = "cloud_link_cidr"
        elif key == "cloudLinkId":
            suggest = "cloud_link_id"
        elif key == "monitorVpcId":
            suggest = "monitor_vpc_id"
        elif key == "monitorVswitchId":
            suggest = "monitor_vswitch_id"
        elif key == "vpdCidr":
            suggest = "vpd_cidr"
        elif key == "vpdSubnets":
            suggest = "vpd_subnets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetworksNewVpdInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetworksNewVpdInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetworksNewVpdInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cen_id: Optional[_builtins.str] = None,
                 cloud_link_cidr: Optional[_builtins.str] = None,
                 cloud_link_id: Optional[_builtins.str] = None,
                 monitor_vpc_id: Optional[_builtins.str] = None,
                 monitor_vswitch_id: Optional[_builtins.str] = None,
                 vpd_cidr: Optional[_builtins.str] = None,
                 vpd_subnets: Optional[Sequence['outputs.ClusterNetworksNewVpdInfoVpdSubnet']] = None):
        """
        :param _builtins.str cen_id: Cloud Enterprise Network ID
        :param _builtins.str cloud_link_cidr: Cloud chain cidr
        :param _builtins.str cloud_link_id: Cloud chain ID
        :param _builtins.str monitor_vpc_id: Proprietary Network
        :param _builtins.str monitor_vswitch_id: Proprietary network switch
        :param _builtins.str vpd_cidr: Cluster network segment
        :param Sequence['ClusterNetworksNewVpdInfoVpdSubnetArgs'] vpd_subnets: List of cluster subnet ID
        """
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if cloud_link_cidr is not None:
            pulumi.set(__self__, "cloud_link_cidr", cloud_link_cidr)
        if cloud_link_id is not None:
            pulumi.set(__self__, "cloud_link_id", cloud_link_id)
        if monitor_vpc_id is not None:
            pulumi.set(__self__, "monitor_vpc_id", monitor_vpc_id)
        if monitor_vswitch_id is not None:
            pulumi.set(__self__, "monitor_vswitch_id", monitor_vswitch_id)
        if vpd_cidr is not None:
            pulumi.set(__self__, "vpd_cidr", vpd_cidr)
        if vpd_subnets is not None:
            pulumi.set(__self__, "vpd_subnets", vpd_subnets)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[_builtins.str]:
        """
        Cloud Enterprise Network ID
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="cloudLinkCidr")
    def cloud_link_cidr(self) -> Optional[_builtins.str]:
        """
        Cloud chain cidr
        """
        return pulumi.get(self, "cloud_link_cidr")

    @_builtins.property
    @pulumi.getter(name="cloudLinkId")
    def cloud_link_id(self) -> Optional[_builtins.str]:
        """
        Cloud chain ID
        """
        return pulumi.get(self, "cloud_link_id")

    @_builtins.property
    @pulumi.getter(name="monitorVpcId")
    def monitor_vpc_id(self) -> Optional[_builtins.str]:
        """
        Proprietary Network
        """
        return pulumi.get(self, "monitor_vpc_id")

    @_builtins.property
    @pulumi.getter(name="monitorVswitchId")
    def monitor_vswitch_id(self) -> Optional[_builtins.str]:
        """
        Proprietary network switch
        """
        return pulumi.get(self, "monitor_vswitch_id")

    @_builtins.property
    @pulumi.getter(name="vpdCidr")
    def vpd_cidr(self) -> Optional[_builtins.str]:
        """
        Cluster network segment
        """
        return pulumi.get(self, "vpd_cidr")

    @_builtins.property
    @pulumi.getter(name="vpdSubnets")
    def vpd_subnets(self) -> Optional[Sequence['outputs.ClusterNetworksNewVpdInfoVpdSubnet']]:
        """
        List of cluster subnet ID
        """
        return pulumi.get(self, "vpd_subnets")


@pulumi.output_type
class ClusterNetworksNewVpdInfoVpdSubnet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetCidr":
            suggest = "subnet_cidr"
        elif key == "subnetType":
            suggest = "subnet_type"
        elif key == "zoneId":
            suggest = "zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetworksNewVpdInfoVpdSubnet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetworksNewVpdInfoVpdSubnet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetworksNewVpdInfoVpdSubnet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_cidr: Optional[_builtins.str] = None,
                 subnet_type: Optional[_builtins.str] = None,
                 zone_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str subnet_cidr: Subnet cidr
        :param _builtins.str subnet_type: Subnet Type
        """
        if subnet_cidr is not None:
            pulumi.set(__self__, "subnet_cidr", subnet_cidr)
        if subnet_type is not None:
            pulumi.set(__self__, "subnet_type", subnet_type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="subnetCidr")
    def subnet_cidr(self) -> Optional[_builtins.str]:
        """
        Subnet cidr
        """
        return pulumi.get(self, "subnet_cidr")

    @_builtins.property
    @pulumi.getter(name="subnetType")
    def subnet_type(self) -> Optional[_builtins.str]:
        """
        Subnet Type
        """
        return pulumi.get(self, "subnet_type")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class ClusterNetworksVpdInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpdId":
            suggest = "vpd_id"
        elif key == "vpdSubnets":
            suggest = "vpd_subnets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetworksVpdInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetworksVpdInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetworksVpdInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpd_id: Optional[_builtins.str] = None,
                 vpd_subnets: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str vpd_id: VPC ID
        :param Sequence[_builtins.str] vpd_subnets: List of cluster subnet ID
        """
        if vpd_id is not None:
            pulumi.set(__self__, "vpd_id", vpd_id)
        if vpd_subnets is not None:
            pulumi.set(__self__, "vpd_subnets", vpd_subnets)

    @_builtins.property
    @pulumi.getter(name="vpdId")
    def vpd_id(self) -> Optional[_builtins.str]:
        """
        VPC ID
        """
        return pulumi.get(self, "vpd_id")

    @_builtins.property
    @pulumi.getter(name="vpdSubnets")
    def vpd_subnets(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of cluster subnet ID
        """
        return pulumi.get(self, "vpd_subnets")


@pulumi.output_type
class ClusterNodeGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageId":
            suggest = "image_id"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "nodeGroupDescription":
            suggest = "node_group_description"
        elif key == "nodeGroupName":
            suggest = "node_group_name"
        elif key == "userData":
            suggest = "user_data"
        elif key == "zoneId":
            suggest = "zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_id: Optional[_builtins.str] = None,
                 machine_type: Optional[_builtins.str] = None,
                 node_group_description: Optional[_builtins.str] = None,
                 node_group_name: Optional[_builtins.str] = None,
                 nodes: Optional[Sequence['outputs.ClusterNodeGroupNode']] = None,
                 user_data: Optional[_builtins.str] = None,
                 zone_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str image_id: System Image ID
        :param _builtins.str machine_type: Model
        :param _builtins.str node_group_description: Node Group Description
        :param _builtins.str node_group_name: Node Group Name
        :param Sequence['ClusterNodeGroupNodeArgs'] nodes: Node List See `nodes` below.
        :param _builtins.str user_data: Instance custom data. It needs to be encoded in Base64 mode, and the original data is at most 16KB.
        :param _builtins.str zone_id: Zone ID
        """
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if node_group_description is not None:
            pulumi.set(__self__, "node_group_description", node_group_description)
        if node_group_name is not None:
            pulumi.set(__self__, "node_group_name", node_group_name)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[_builtins.str]:
        """
        System Image ID
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        Model
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="nodeGroupDescription")
    def node_group_description(self) -> Optional[_builtins.str]:
        """
        Node Group Description
        """
        return pulumi.get(self, "node_group_description")

    @_builtins.property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> Optional[_builtins.str]:
        """
        Node Group Name
        """
        return pulumi.get(self, "node_group_name")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[Sequence['outputs.ClusterNodeGroupNode']]:
        """
        Node List See `nodes` below.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[_builtins.str]:
        """
        Instance custom data. It needs to be encoded in Base64 mode, and the original data is at most 16KB.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        Zone ID
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class ClusterNodeGroupNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loginPassword":
            suggest = "login_password"
        elif key == "nodeId":
            suggest = "node_id"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "vswitchId":
            suggest = "vswitch_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: Optional[_builtins.str] = None,
                 login_password: Optional[_builtins.str] = None,
                 node_id: Optional[_builtins.str] = None,
                 vpc_id: Optional[_builtins.str] = None,
                 vswitch_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str hostname: Host name
        :param _builtins.str login_password: Login Password
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if login_password is not None:
            pulumi.set(__self__, "login_password", login_password)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Host name
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="loginPassword")
    def login_password(self) -> Optional[_builtins.str]:
        """
        Login Password
        """
        return pulumi.get(self, "login_password")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class ExperimentPlanTemplateTemplatePipeline(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "envParams":
            suggest = "env_params"
        elif key == "pipelineOrder":
            suggest = "pipeline_order"
        elif key == "workloadId":
            suggest = "workload_id"
        elif key == "workloadName":
            suggest = "workload_name"
        elif key == "settingParams":
            suggest = "setting_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExperimentPlanTemplateTemplatePipeline. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExperimentPlanTemplateTemplatePipeline.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExperimentPlanTemplateTemplatePipeline.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 env_params: 'outputs.ExperimentPlanTemplateTemplatePipelineEnvParams',
                 pipeline_order: _builtins.int,
                 scene: _builtins.str,
                 workload_id: _builtins.int,
                 workload_name: _builtins.str,
                 setting_params: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param 'ExperimentPlanTemplateTemplatePipelineEnvParamsArgs' env_params: Contains a series of parameters related to the environment. See `env_params` below.
        :param _builtins.int pipeline_order: Indicates the sequence number of the pipeline node.
        :param _builtins.str scene: The use of the template scenario. It can have the following optional parameters:
               - baseline: benchmark evaluation
        :param _builtins.int workload_id: Used to uniquely identify a specific payload.
        :param _builtins.str workload_name: The name used to represent a specific payload.
        :param Mapping[str, _builtins.str] setting_params: Represents additional parameters for the run.
        """
        pulumi.set(__self__, "env_params", env_params)
        pulumi.set(__self__, "pipeline_order", pipeline_order)
        pulumi.set(__self__, "scene", scene)
        pulumi.set(__self__, "workload_id", workload_id)
        pulumi.set(__self__, "workload_name", workload_name)
        if setting_params is not None:
            pulumi.set(__self__, "setting_params", setting_params)

    @_builtins.property
    @pulumi.getter(name="envParams")
    def env_params(self) -> 'outputs.ExperimentPlanTemplateTemplatePipelineEnvParams':
        """
        Contains a series of parameters related to the environment. See `env_params` below.
        """
        return pulumi.get(self, "env_params")

    @_builtins.property
    @pulumi.getter(name="pipelineOrder")
    def pipeline_order(self) -> _builtins.int:
        """
        Indicates the sequence number of the pipeline node.
        """
        return pulumi.get(self, "pipeline_order")

    @_builtins.property
    @pulumi.getter
    def scene(self) -> _builtins.str:
        """
        The use of the template scenario. It can have the following optional parameters:
        - baseline: benchmark evaluation
        """
        return pulumi.get(self, "scene")

    @_builtins.property
    @pulumi.getter(name="workloadId")
    def workload_id(self) -> _builtins.int:
        """
        Used to uniquely identify a specific payload.
        """
        return pulumi.get(self, "workload_id")

    @_builtins.property
    @pulumi.getter(name="workloadName")
    def workload_name(self) -> _builtins.str:
        """
        The name used to represent a specific payload.
        """
        return pulumi.get(self, "workload_name")

    @_builtins.property
    @pulumi.getter(name="settingParams")
    def setting_params(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Represents additional parameters for the run.
        """
        return pulumi.get(self, "setting_params")


@pulumi.output_type
class ExperimentPlanTemplateTemplatePipelineEnvParams(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuPerWorker":
            suggest = "cpu_per_worker"
        elif key == "gpuPerWorker":
            suggest = "gpu_per_worker"
        elif key == "memoryPerWorker":
            suggest = "memory_per_worker"
        elif key == "shareMemory":
            suggest = "share_memory"
        elif key == "workerNum":
            suggest = "worker_num"
        elif key == "cudaVersion":
            suggest = "cuda_version"
        elif key == "gpuDriverVersion":
            suggest = "gpu_driver_version"
        elif key == "ncclVersion":
            suggest = "nccl_version"
        elif key == "pyTorchVersion":
            suggest = "py_torch_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExperimentPlanTemplateTemplatePipelineEnvParams. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExperimentPlanTemplateTemplatePipelineEnvParams.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExperimentPlanTemplateTemplatePipelineEnvParams.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_per_worker: _builtins.int,
                 gpu_per_worker: _builtins.int,
                 memory_per_worker: _builtins.int,
                 share_memory: _builtins.int,
                 worker_num: _builtins.int,
                 cuda_version: Optional[_builtins.str] = None,
                 gpu_driver_version: Optional[_builtins.str] = None,
                 nccl_version: Optional[_builtins.str] = None,
                 py_torch_version: Optional[_builtins.str] = None):
        """
        :param _builtins.int cpu_per_worker: Number of central processing units (CPUs) allocated. This parameter affects the processing power of the computation, especially in tasks that require a large amount of parallel processing.
        :param _builtins.int gpu_per_worker: Number of graphics processing units (GPUs). GPUs are a key component in deep learning and large-scale data processing, so this parameter is very important for tasks that require graphics-accelerated computing.
        :param _builtins.int memory_per_worker: The amount of memory available. Memory size has an important impact on the performance and stability of the program, especially when dealing with large data sets or high-dimensional data.
        :param _builtins.int share_memory: Shared memory GB allocation
        :param _builtins.int worker_num: The total number of nodes. This parameter directly affects the parallelism and computing speed of the task, and a higher number of working nodes usually accelerates the completion of the task.
        :param _builtins.str cuda_version: The version of CUDA(Compute Unified Device Architecture) used. CUDA is a parallel computing platform and programming model provided by NVIDIA. A specific version may affect the available GPU functions and performance optimization.
        :param _builtins.str gpu_driver_version: The version of the GPU driver used. Driver version may affect GPU performance and compatibility, so it is important to ensure that the correct version is used
        :param _builtins.str nccl_version: The NVIDIA Collective Communications Library(NCCL) version used. NCCL is a library for multi-GPU and multi-node communication. This parameter is particularly important for optimizing data transmission in distributed computing.
        :param _builtins.str py_torch_version: The version of the PyTorch framework used. PyTorch is a widely used deep learning library, and differences between versions may affect the performance and functional support of model training and inference.
        """
        pulumi.set(__self__, "cpu_per_worker", cpu_per_worker)
        pulumi.set(__self__, "gpu_per_worker", gpu_per_worker)
        pulumi.set(__self__, "memory_per_worker", memory_per_worker)
        pulumi.set(__self__, "share_memory", share_memory)
        pulumi.set(__self__, "worker_num", worker_num)
        if cuda_version is not None:
            pulumi.set(__self__, "cuda_version", cuda_version)
        if gpu_driver_version is not None:
            pulumi.set(__self__, "gpu_driver_version", gpu_driver_version)
        if nccl_version is not None:
            pulumi.set(__self__, "nccl_version", nccl_version)
        if py_torch_version is not None:
            pulumi.set(__self__, "py_torch_version", py_torch_version)

    @_builtins.property
    @pulumi.getter(name="cpuPerWorker")
    def cpu_per_worker(self) -> _builtins.int:
        """
        Number of central processing units (CPUs) allocated. This parameter affects the processing power of the computation, especially in tasks that require a large amount of parallel processing.
        """
        return pulumi.get(self, "cpu_per_worker")

    @_builtins.property
    @pulumi.getter(name="gpuPerWorker")
    def gpu_per_worker(self) -> _builtins.int:
        """
        Number of graphics processing units (GPUs). GPUs are a key component in deep learning and large-scale data processing, so this parameter is very important for tasks that require graphics-accelerated computing.
        """
        return pulumi.get(self, "gpu_per_worker")

    @_builtins.property
    @pulumi.getter(name="memoryPerWorker")
    def memory_per_worker(self) -> _builtins.int:
        """
        The amount of memory available. Memory size has an important impact on the performance and stability of the program, especially when dealing with large data sets or high-dimensional data.
        """
        return pulumi.get(self, "memory_per_worker")

    @_builtins.property
    @pulumi.getter(name="shareMemory")
    def share_memory(self) -> _builtins.int:
        """
        Shared memory GB allocation
        """
        return pulumi.get(self, "share_memory")

    @_builtins.property
    @pulumi.getter(name="workerNum")
    def worker_num(self) -> _builtins.int:
        """
        The total number of nodes. This parameter directly affects the parallelism and computing speed of the task, and a higher number of working nodes usually accelerates the completion of the task.
        """
        return pulumi.get(self, "worker_num")

    @_builtins.property
    @pulumi.getter(name="cudaVersion")
    def cuda_version(self) -> Optional[_builtins.str]:
        """
        The version of CUDA(Compute Unified Device Architecture) used. CUDA is a parallel computing platform and programming model provided by NVIDIA. A specific version may affect the available GPU functions and performance optimization.
        """
        return pulumi.get(self, "cuda_version")

    @_builtins.property
    @pulumi.getter(name="gpuDriverVersion")
    def gpu_driver_version(self) -> Optional[_builtins.str]:
        """
        The version of the GPU driver used. Driver version may affect GPU performance and compatibility, so it is important to ensure that the correct version is used
        """
        return pulumi.get(self, "gpu_driver_version")

    @_builtins.property
    @pulumi.getter(name="ncclVersion")
    def nccl_version(self) -> Optional[_builtins.str]:
        """
        The NVIDIA Collective Communications Library(NCCL) version used. NCCL is a library for multi-GPU and multi-node communication. This parameter is particularly important for optimizing data transmission in distributed computing.
        """
        return pulumi.get(self, "nccl_version")

    @_builtins.property
    @pulumi.getter(name="pyTorchVersion")
    def py_torch_version(self) -> Optional[_builtins.str]:
        """
        The version of the PyTorch framework used. PyTorch is a widely used deep learning library, and differences between versions may affect the performance and functional support of model training and inference.
        """
        return pulumi.get(self, "py_torch_version")


@pulumi.output_type
class NodeGroupAttachmentDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteWithNode":
            suggest = "delete_with_node"
        elif key == "performanceLevel":
            suggest = "performance_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeGroupAttachmentDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeGroupAttachmentDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeGroupAttachmentDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: Optional[_builtins.str] = None,
                 delete_with_node: Optional[_builtins.bool] = None,
                 performance_level: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None):
        """
        :param _builtins.str category: Type
        :param _builtins.bool delete_with_node: Indicate whether the data disk is released with the node. true indicates that the data disk will be released together when the node unsubscribes.
        :param _builtins.str performance_level: Performance level
        :param _builtins.int size: Data disk size
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if delete_with_node is not None:
            pulumi.set(__self__, "delete_with_node", delete_with_node)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[_builtins.str]:
        """
        Type
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="deleteWithNode")
    def delete_with_node(self) -> Optional[_builtins.bool]:
        """
        Indicate whether the data disk is released with the node. true indicates that the data disk will be released together when the node unsubscribes.
        """
        return pulumi.get(self, "delete_with_node")

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[_builtins.str]:
        """
        Performance level
        """
        return pulumi.get(self, "performance_level")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        Data disk size
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class NodeGroupIpAllocationPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bondPolicy":
            suggest = "bond_policy"
        elif key == "machineTypePolicies":
            suggest = "machine_type_policies"
        elif key == "nodePolicies":
            suggest = "node_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeGroupIpAllocationPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeGroupIpAllocationPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeGroupIpAllocationPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bond_policy: Optional['outputs.NodeGroupIpAllocationPolicyBondPolicy'] = None,
                 machine_type_policies: Optional[Sequence['outputs.NodeGroupIpAllocationPolicyMachineTypePolicy']] = None,
                 node_policies: Optional[Sequence['outputs.NodeGroupIpAllocationPolicyNodePolicy']] = None):
        """
        :param 'NodeGroupIpAllocationPolicyBondPolicyArgs' bond_policy: Specify the cluster subnet ID based on the bond name See `bond_policy` below.
        :param Sequence['NodeGroupIpAllocationPolicyMachineTypePolicyArgs'] machine_type_policies: Model Assignment Policy See `machine_type_policy` below.
        :param Sequence['NodeGroupIpAllocationPolicyNodePolicyArgs'] node_policies: Node allocation policy See `node_policy` below.
        """
        if bond_policy is not None:
            pulumi.set(__self__, "bond_policy", bond_policy)
        if machine_type_policies is not None:
            pulumi.set(__self__, "machine_type_policies", machine_type_policies)
        if node_policies is not None:
            pulumi.set(__self__, "node_policies", node_policies)

    @_builtins.property
    @pulumi.getter(name="bondPolicy")
    def bond_policy(self) -> Optional['outputs.NodeGroupIpAllocationPolicyBondPolicy']:
        """
        Specify the cluster subnet ID based on the bond name See `bond_policy` below.
        """
        return pulumi.get(self, "bond_policy")

    @_builtins.property
    @pulumi.getter(name="machineTypePolicies")
    def machine_type_policies(self) -> Optional[Sequence['outputs.NodeGroupIpAllocationPolicyMachineTypePolicy']]:
        """
        Model Assignment Policy See `machine_type_policy` below.
        """
        return pulumi.get(self, "machine_type_policies")

    @_builtins.property
    @pulumi.getter(name="nodePolicies")
    def node_policies(self) -> Optional[Sequence['outputs.NodeGroupIpAllocationPolicyNodePolicy']]:
        """
        Node allocation policy See `node_policy` below.
        """
        return pulumi.get(self, "node_policies")


@pulumi.output_type
class NodeGroupIpAllocationPolicyBondPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bondDefaultSubnet":
            suggest = "bond_default_subnet"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeGroupIpAllocationPolicyBondPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeGroupIpAllocationPolicyBondPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeGroupIpAllocationPolicyBondPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bond_default_subnet: Optional[_builtins.str] = None,
                 bonds: Optional[Sequence['outputs.NodeGroupIpAllocationPolicyBondPolicyBond']] = None):
        """
        :param _builtins.str bond_default_subnet: Default bond cluster subnet
        :param Sequence['NodeGroupIpAllocationPolicyBondPolicyBondArgs'] bonds: Bond information See `bonds` below.
        """
        if bond_default_subnet is not None:
            pulumi.set(__self__, "bond_default_subnet", bond_default_subnet)
        if bonds is not None:
            pulumi.set(__self__, "bonds", bonds)

    @_builtins.property
    @pulumi.getter(name="bondDefaultSubnet")
    def bond_default_subnet(self) -> Optional[_builtins.str]:
        """
        Default bond cluster subnet
        """
        return pulumi.get(self, "bond_default_subnet")

    @_builtins.property
    @pulumi.getter
    def bonds(self) -> Optional[Sequence['outputs.NodeGroupIpAllocationPolicyBondPolicyBond']]:
        """
        Bond information See `bonds` below.
        """
        return pulumi.get(self, "bonds")


@pulumi.output_type
class NodeGroupIpAllocationPolicyBondPolicyBond(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 subnet: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The bond name
        :param _builtins.str subnet: IP source cluster subnet
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The bond name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[_builtins.str]:
        """
        IP source cluster subnet
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class NodeGroupIpAllocationPolicyMachineTypePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineType":
            suggest = "machine_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeGroupIpAllocationPolicyMachineTypePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeGroupIpAllocationPolicyMachineTypePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeGroupIpAllocationPolicyMachineTypePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bonds: Optional[Sequence['outputs.NodeGroupIpAllocationPolicyMachineTypePolicyBond']] = None,
                 machine_type: Optional[_builtins.str] = None):
        """
        :param Sequence['NodeGroupIpAllocationPolicyMachineTypePolicyBondArgs'] bonds: Bond information See `bonds` below.
        :param _builtins.str machine_type: Machine type
        """
        if bonds is not None:
            pulumi.set(__self__, "bonds", bonds)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)

    @_builtins.property
    @pulumi.getter
    def bonds(self) -> Optional[Sequence['outputs.NodeGroupIpAllocationPolicyMachineTypePolicyBond']]:
        """
        Bond information See `bonds` below.
        """
        return pulumi.get(self, "bonds")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        Machine type
        """
        return pulumi.get(self, "machine_type")


@pulumi.output_type
class NodeGroupIpAllocationPolicyMachineTypePolicyBond(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 subnet: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The bond name
        :param _builtins.str subnet: IP source cluster subnet
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The bond name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[_builtins.str]:
        """
        IP source cluster subnet
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class NodeGroupIpAllocationPolicyNodePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeId":
            suggest = "node_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeGroupIpAllocationPolicyNodePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeGroupIpAllocationPolicyNodePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeGroupIpAllocationPolicyNodePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bonds: Optional[Sequence['outputs.NodeGroupIpAllocationPolicyNodePolicyBond']] = None,
                 node_id: Optional[_builtins.str] = None):
        """
        :param Sequence['NodeGroupIpAllocationPolicyNodePolicyBondArgs'] bonds: Bond information See `bonds` below.
        """
        if bonds is not None:
            pulumi.set(__self__, "bonds", bonds)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)

    @_builtins.property
    @pulumi.getter
    def bonds(self) -> Optional[Sequence['outputs.NodeGroupIpAllocationPolicyNodePolicyBond']]:
        """
        Bond information See `bonds` below.
        """
        return pulumi.get(self, "bonds")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "node_id")


@pulumi.output_type
class NodeGroupIpAllocationPolicyNodePolicyBond(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 subnet: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The bond name
        :param _builtins.str subnet: IP source cluster subnet
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The bond name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[_builtins.str]:
        """
        IP source cluster subnet
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class NodeGroupNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loginPassword":
            suggest = "login_password"
        elif key == "nodeId":
            suggest = "node_id"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "vswitchId":
            suggest = "vswitch_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeGroupNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeGroupNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeGroupNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: Optional[_builtins.str] = None,
                 login_password: Optional[_builtins.str] = None,
                 node_id: Optional[_builtins.str] = None,
                 vpc_id: Optional[_builtins.str] = None,
                 vswitch_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str hostname: Host name
        :param _builtins.str login_password: Login Password
        :param _builtins.str node_id: Node ID
        :param _builtins.str vpc_id: VPC ID
        :param _builtins.str vswitch_id: Switch ID
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if login_password is not None:
            pulumi.set(__self__, "login_password", login_password)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Host name
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="loginPassword")
    def login_password(self) -> Optional[_builtins.str]:
        """
        Login Password
        """
        return pulumi.get(self, "login_password")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[_builtins.str]:
        """
        Node ID
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        VPC ID
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[_builtins.str]:
        """
        Switch ID
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class ResourceMachineTypes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuInfo":
            suggest = "cpu_info"
        elif key == "gpuInfo":
            suggest = "gpu_info"
        elif key == "bondNum":
            suggest = "bond_num"
        elif key == "diskInfo":
            suggest = "disk_info"
        elif key == "memoryInfo":
            suggest = "memory_info"
        elif key == "networkInfo":
            suggest = "network_info"
        elif key == "networkMode":
            suggest = "network_mode"
        elif key == "nodeCount":
            suggest = "node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceMachineTypes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceMachineTypes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceMachineTypes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_info: _builtins.str,
                 gpu_info: _builtins.str,
                 bond_num: Optional[_builtins.int] = None,
                 disk_info: Optional[_builtins.str] = None,
                 memory_info: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 network_info: Optional[_builtins.str] = None,
                 network_mode: Optional[_builtins.str] = None,
                 node_count: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str cpu_info: Provides CPU details, including the number of cores, number of threads, clock frequency, and architecture type. This information helps to evaluate the processing power and identify whether it can meet the performance requirements of a particular application.
        :param _builtins.str gpu_info: Provides detailed information about the GPU, including the number, model, memory size, and computing capability. This information is particularly important for tasks such as deep learning, scientific computing, and graph processing, helping users understand the graph processing capabilities of nodes.
        :param _builtins.int bond_num: This property specifies the number of network bindings, which relates to the number of physical or virtual network cards connected to the network through the network interface card (NIC). Multiple network bindings can increase bandwidth and redundancy and improve network reliability.
        :param _builtins.str disk_info: Displays information about the storage device, including the disk type (such as SSD or HDD), capacity, and I/O performance. Storage performance is critical in data-intensive applications such as big data processing and databases.
        :param _builtins.str memory_info: This property provides memory details, including total memory, available memory, and usage. This helps users understand the memory processing capabilities of compute nodes, especially when running heavy-duty applications.
        :param _builtins.str name: Specification Name.
        :param _builtins.str network_info: Contains detailed information about the network interface, such as network bandwidth, latency, protocol types supported by the network, IP addresses, and network topology. Optimizing network information is essential to ensure efficient data transmission and low latency.
        :param _builtins.str network_mode: Specifies the network mode, such as bridge mode, NAT mode, or direct connection mode. Different network modes affect the network configuration and data transmission performance of nodes, and affect the network access methods of computing instances.
        :param _builtins.int node_count: Specifies the total number of compute nodes. This property is particularly important in distributed computing and cluster environments, because the number of nodes often directly affects the computing power and the ability to parallel processing.
        :param _builtins.str type: Usually refers to a specific resource type (such as virtual machine, physical server, container, etc.), which is used to distinguish different computing units or resource categories.
        """
        pulumi.set(__self__, "cpu_info", cpu_info)
        pulumi.set(__self__, "gpu_info", gpu_info)
        if bond_num is not None:
            pulumi.set(__self__, "bond_num", bond_num)
        if disk_info is not None:
            pulumi.set(__self__, "disk_info", disk_info)
        if memory_info is not None:
            pulumi.set(__self__, "memory_info", memory_info)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_info is not None:
            pulumi.set(__self__, "network_info", network_info)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="cpuInfo")
    def cpu_info(self) -> _builtins.str:
        """
        Provides CPU details, including the number of cores, number of threads, clock frequency, and architecture type. This information helps to evaluate the processing power and identify whether it can meet the performance requirements of a particular application.
        """
        return pulumi.get(self, "cpu_info")

    @_builtins.property
    @pulumi.getter(name="gpuInfo")
    def gpu_info(self) -> _builtins.str:
        """
        Provides detailed information about the GPU, including the number, model, memory size, and computing capability. This information is particularly important for tasks such as deep learning, scientific computing, and graph processing, helping users understand the graph processing capabilities of nodes.
        """
        return pulumi.get(self, "gpu_info")

    @_builtins.property
    @pulumi.getter(name="bondNum")
    def bond_num(self) -> Optional[_builtins.int]:
        """
        This property specifies the number of network bindings, which relates to the number of physical or virtual network cards connected to the network through the network interface card (NIC). Multiple network bindings can increase bandwidth and redundancy and improve network reliability.
        """
        return pulumi.get(self, "bond_num")

    @_builtins.property
    @pulumi.getter(name="diskInfo")
    def disk_info(self) -> Optional[_builtins.str]:
        """
        Displays information about the storage device, including the disk type (such as SSD or HDD), capacity, and I/O performance. Storage performance is critical in data-intensive applications such as big data processing and databases.
        """
        return pulumi.get(self, "disk_info")

    @_builtins.property
    @pulumi.getter(name="memoryInfo")
    def memory_info(self) -> Optional[_builtins.str]:
        """
        This property provides memory details, including total memory, available memory, and usage. This helps users understand the memory processing capabilities of compute nodes, especially when running heavy-duty applications.
        """
        return pulumi.get(self, "memory_info")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Specification Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkInfo")
    def network_info(self) -> Optional[_builtins.str]:
        """
        Contains detailed information about the network interface, such as network bandwidth, latency, protocol types supported by the network, IP addresses, and network topology. Optimizing network information is essential to ensure efficient data transmission and low latency.
        """
        return pulumi.get(self, "network_info")

    @_builtins.property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[_builtins.str]:
        """
        Specifies the network mode, such as bridge mode, NAT mode, or direct connection mode. Different network modes affect the network configuration and data transmission performance of nodes, and affect the network access methods of computing instances.
        """
        return pulumi.get(self, "network_mode")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[_builtins.int]:
        """
        Specifies the total number of compute nodes. This property is particularly important in distributed computing and cluster environments, because the number of nodes often directly affects the computing power and the ability to parallel processing.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Usually refers to a specific resource type (such as virtual machine, physical server, container, etc.), which is used to distinguish different computing units or resource categories.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ResourceUserAccessParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessId":
            suggest = "access_id"
        elif key == "accessKey":
            suggest = "access_key"
        elif key == "workspaceId":
            suggest = "workspace_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceUserAccessParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceUserAccessParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceUserAccessParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_id: _builtins.str,
                 access_key: _builtins.str,
                 endpoint: _builtins.str,
                 workspace_id: _builtins.str):
        """
        :param _builtins.str access_id: Access keys are important credentials for authentication.
        :param _builtins.str access_key: A Secret Key is a Secret credential paired with an access Key to verify a user's identity and protect the security of an interface.
        :param _builtins.str endpoint: An Endpoint is a network address for accessing a service or API, usually a URL to a specific service instance.
        :param _builtins.str workspace_id: A Workspace generally refers to a separate space created by a user on a particular computing environment or platform.
        """
        pulumi.set(__self__, "access_id", access_id)
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="accessId")
    def access_id(self) -> _builtins.str:
        """
        Access keys are important credentials for authentication.
        """
        return pulumi.get(self, "access_id")

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> _builtins.str:
        """
        A Secret Key is a Secret credential paired with an access Key to verify a user's identity and protect the security of an interface.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        An Endpoint is a network address for accessing a service or API, usually a URL to a specific service instance.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> _builtins.str:
        """
        A Workspace generally refers to a separate space created by a user on a particular computing environment or platform.
        """
        return pulumi.get(self, "workspace_id")


@pulumi.output_type
class GetSubnetsSubnetResult(dict):
    def __init__(__self__, *,
                 cidr: _builtins.str,
                 create_time: _builtins.str,
                 gmt_modified: _builtins.str,
                 id: _builtins.str,
                 message: _builtins.str,
                 resource_group_id: _builtins.str,
                 status: _builtins.str,
                 subnet_id: _builtins.str,
                 subnet_name: _builtins.str,
                 type: _builtins.str,
                 vpd_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str cidr: Network segment
        :param _builtins.str create_time: The creation time of the resource
        :param _builtins.str gmt_modified: Modification time
        :param _builtins.str id: The ID of the resource.
        :param _builtins.str message: Error message
        :param _builtins.str resource_group_id: Resource Group ID.
        :param _builtins.str status: The status of the resource.
        :param _builtins.str subnet_id: Primary key ID.
        :param _builtins.str subnet_name: The Subnet name.
        :param _builtins.str type: Eflo subnet usage type, optional value: 
               - General type is not filled in
               - OOB:OOB type
               - LB: LB type
        :param _builtins.str vpd_id: The Eflo VPD ID.
        :param _builtins.str zone_id: The zone ID of the resource.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "gmt_modified", gmt_modified)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "subnet_name", subnet_name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vpd_id", vpd_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        """
        Network segment
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="gmtModified")
    def gmt_modified(self) -> _builtins.str:
        """
        Modification time
        """
        return pulumi.get(self, "gmt_modified")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        Error message
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        Resource Group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        Primary key ID.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> _builtins.str:
        """
        The Subnet name.
        """
        return pulumi.get(self, "subnet_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Eflo subnet usage type, optional value: 
        - General type is not filled in
        - OOB:OOB type
        - LB: LB type
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vpdId")
    def vpd_id(self) -> _builtins.str:
        """
        The Eflo VPD ID.
        """
        return pulumi.get(self, "vpd_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID of the resource.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetVpdsVpdResult(dict):
    def __init__(__self__, *,
                 cidr: _builtins.str,
                 create_time: _builtins.str,
                 gmt_modified: _builtins.str,
                 id: _builtins.str,
                 resource_group_id: _builtins.str,
                 status: _builtins.str,
                 vpd_id: _builtins.str,
                 vpd_name: _builtins.str):
        """
        :param _builtins.str cidr: CIDR network segment
        :param _builtins.str create_time: The creation time of the resource
        :param _builtins.str gmt_modified: Modification time
        :param _builtins.str id: The id of the vpd.
        :param _builtins.str resource_group_id: The Resource group id
        :param _builtins.str status: The Vpd status. Valid values: `Available`, `Not Available`, `Executing`, `Deleting`,
        :param _builtins.str vpd_id: The id of the vpd.
        :param _builtins.str vpd_name: The Name of the VPD.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "gmt_modified", gmt_modified)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpd_id", vpd_id)
        pulumi.set(__self__, "vpd_name", vpd_name)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        """
        CIDR network segment
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="gmtModified")
    def gmt_modified(self) -> _builtins.str:
        """
        Modification time
        """
        return pulumi.get(self, "gmt_modified")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the vpd.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The Resource group id
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The Vpd status. Valid values: `Available`, `Not Available`, `Executing`, `Deleting`,
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpdId")
    def vpd_id(self) -> _builtins.str:
        """
        The id of the vpd.
        """
        return pulumi.get(self, "vpd_id")

    @_builtins.property
    @pulumi.getter(name="vpdName")
    def vpd_name(self) -> _builtins.str:
        """
        The Name of the VPD.
        """
        return pulumi.get(self, "vpd_name")


