# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterAdditionalVolume',
    'ClusterAdditionalVolumeRole',
    'ClusterApplication',
    'ClusterPostInstallScript',
    'GetClustersClusterResult',
    'GetClustersClusterApplicationResult',
    'GetClustersClusterPostInstallScriptResult',
    'GetJobTemplatesTemplateResult',
]

@pulumi.output_type
class ClusterAdditionalVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobQueue":
            suggest = "job_queue"
        elif key == "localDirectory":
            suggest = "local_directory"
        elif key == "remoteDirectory":
            suggest = "remote_directory"
        elif key == "volumeId":
            suggest = "volume_id"
        elif key == "volumeMountOption":
            suggest = "volume_mount_option"
        elif key == "volumeMountpoint":
            suggest = "volume_mountpoint"
        elif key == "volumeProtocol":
            suggest = "volume_protocol"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAdditionalVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAdditionalVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAdditionalVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_queue: Optional[_builtins.str] = None,
                 local_directory: Optional[_builtins.str] = None,
                 location: Optional[_builtins.str] = None,
                 remote_directory: Optional[_builtins.str] = None,
                 roles: Optional[Sequence['outputs.ClusterAdditionalVolumeRole']] = None,
                 volume_id: Optional[_builtins.str] = None,
                 volume_mount_option: Optional[_builtins.str] = None,
                 volume_mountpoint: Optional[_builtins.str] = None,
                 volume_protocol: Optional[_builtins.str] = None,
                 volume_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str job_queue: The queue of the nodes to which the additional file system is attached.
        :param _builtins.str local_directory: The local directory on which the additional file system is mounted.
        :param _builtins.str location: The type of the cluster. Valid value: `PublicCloud`.
        :param _builtins.str remote_directory: The remote directory to which the additional file system is mounted.
        :param Sequence['ClusterAdditionalVolumeRoleArgs'] roles: The roles. See `roles` below.
        :param _builtins.str volume_id: The ID of the additional file system.
        :param _builtins.str volume_mount_option: The mount options of the file system.
        :param _builtins.str volume_mountpoint: The mount target of the additional file system.
        :param _builtins.str volume_protocol: The type of the protocol that is used by the additional file system. Valid values: `NFS`, `SMB`. Default value: `NFS`
        :param _builtins.str volume_type: The type of the additional shared storage. Only NAS file systems are supported.
        """
        if job_queue is not None:
            pulumi.set(__self__, "job_queue", job_queue)
        if local_directory is not None:
            pulumi.set(__self__, "local_directory", local_directory)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if remote_directory is not None:
            pulumi.set(__self__, "remote_directory", remote_directory)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if volume_mount_option is not None:
            pulumi.set(__self__, "volume_mount_option", volume_mount_option)
        if volume_mountpoint is not None:
            pulumi.set(__self__, "volume_mountpoint", volume_mountpoint)
        if volume_protocol is not None:
            pulumi.set(__self__, "volume_protocol", volume_protocol)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter(name="jobQueue")
    def job_queue(self) -> Optional[_builtins.str]:
        """
        The queue of the nodes to which the additional file system is attached.
        """
        return pulumi.get(self, "job_queue")

    @_builtins.property
    @pulumi.getter(name="localDirectory")
    def local_directory(self) -> Optional[_builtins.str]:
        """
        The local directory on which the additional file system is mounted.
        """
        return pulumi.get(self, "local_directory")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        """
        The type of the cluster. Valid value: `PublicCloud`.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="remoteDirectory")
    def remote_directory(self) -> Optional[_builtins.str]:
        """
        The remote directory to which the additional file system is mounted.
        """
        return pulumi.get(self, "remote_directory")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[Sequence['outputs.ClusterAdditionalVolumeRole']]:
        """
        The roles. See `roles` below.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[_builtins.str]:
        """
        The ID of the additional file system.
        """
        return pulumi.get(self, "volume_id")

    @_builtins.property
    @pulumi.getter(name="volumeMountOption")
    def volume_mount_option(self) -> Optional[_builtins.str]:
        """
        The mount options of the file system.
        """
        return pulumi.get(self, "volume_mount_option")

    @_builtins.property
    @pulumi.getter(name="volumeMountpoint")
    def volume_mountpoint(self) -> Optional[_builtins.str]:
        """
        The mount target of the additional file system.
        """
        return pulumi.get(self, "volume_mountpoint")

    @_builtins.property
    @pulumi.getter(name="volumeProtocol")
    def volume_protocol(self) -> Optional[_builtins.str]:
        """
        The type of the protocol that is used by the additional file system. Valid values: `NFS`, `SMB`. Default value: `NFS`
        """
        return pulumi.get(self, "volume_protocol")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[_builtins.str]:
        """
        The type of the additional shared storage. Only NAS file systems are supported.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class ClusterAdditionalVolumeRole(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The type of the nodes to which the additional file system is attached.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The type of the nodes to which the additional file system is attached.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ClusterApplication(dict):
    def __init__(__self__, *,
                 tag: Optional[_builtins.str] = None):
        """
        :param _builtins.str tag: The tag of the software.
        """
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        The tag of the software.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class ClusterPostInstallScript(dict):
    def __init__(__self__, *,
                 args: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.str args: The parameter that is used to run the script after the cluster is created.
        :param _builtins.str url: The URL that is used to download the script after the cluster is created.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[_builtins.str]:
        """
        The parameter that is used to run the script after the cluster is created.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        The URL that is used to download the script after the cluster is created.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetClustersClusterResult(dict):
    def __init__(__self__, *,
                 account_type: _builtins.str,
                 applications: Sequence['outputs.GetClustersClusterApplicationResult'],
                 client_version: _builtins.str,
                 cluster_id: _builtins.str,
                 cluster_name: _builtins.str,
                 compute_count: _builtins.int,
                 compute_instance_type: _builtins.str,
                 create_time: _builtins.str,
                 deploy_mode: _builtins.str,
                 description: _builtins.str,
                 ha_enable: _builtins.bool,
                 id: _builtins.str,
                 image_id: _builtins.str,
                 image_owner_alias: _builtins.str,
                 login_count: _builtins.int,
                 login_instance_type: _builtins.str,
                 manager_count: _builtins.int,
                 manager_instance_type: _builtins.str,
                 os_tag: _builtins.str,
                 post_install_scripts: Sequence['outputs.GetClustersClusterPostInstallScriptResult'],
                 remote_directory: _builtins.str,
                 scc_cluster_id: _builtins.str,
                 scheduler_type: _builtins.str,
                 security_group_id: _builtins.str,
                 status: _builtins.str,
                 volume_id: _builtins.str,
                 volume_mountpoint: _builtins.str,
                 volume_protocol: _builtins.str,
                 volume_type: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str account_type: The server type of the account.
        :param Sequence['GetClustersClusterApplicationArgs'] applications: A list of clustered applications.
        :param _builtins.str client_version: The version number of the client used by the cluster.
        :param _builtins.str cluster_id: The id of E-HPC Cluster.
        :param _builtins.str cluster_name: The name of E-HPC cluster.
        :param _builtins.int compute_count: The number of compute nodes in the cluster.
        :param _builtins.str compute_instance_type: Cluster compute node specifications.
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.str deploy_mode: Cluster deployment mode. Possible values:
               - Standard: separate deployment of account nodes, scheduling nodes, login nodes, and compute nodes.
               - Advanced:HA mode deployment.
               - Simple: the account node and the scheduling node are deployed on one node, and the login node and the compute node are deployed separately.
               - Tiny: account nodes, scheduling nodes, and login nodes are deployed on one node, and compute nodes are deployed separately.
               - OneBox: account node, scheduling node, login node and compute node are deployed on one node.
        :param _builtins.str description: The description of E-HPC cluster.
        :param _builtins.bool ha_enable: Whether to turn on high availability. > If high availability is enabled, each control role in the cluster will use two primary and secondary instances.
        :param _builtins.str id: The ID of the Cluster.
        :param _builtins.str image_id: The ID of the Image.
        :param _builtins.str image_owner_alias: The type of the image.
        :param _builtins.int login_count: The number of cluster login nodes. Only configuration 1 is supported.
        :param _builtins.str login_instance_type: Cluster login node specifications.
        :param _builtins.int manager_count: The number of control nodes.
        :param _builtins.str manager_instance_type: The instance type of manager nodes.
        :param _builtins.str os_tag: The image tag of the operating system.
        :param Sequence['GetClustersClusterPostInstallScriptArgs'] post_install_scripts: List of post-installation scripts.
        :param _builtins.str remote_directory: Mount the remote directory of the shared storage.
        :param _builtins.str scc_cluster_id: The SccCluster ID used by the cluster. If the cluster is not an SCC model, it is empty.
        :param _builtins.str scheduler_type: Dispatch server type.
        :param _builtins.str security_group_id: The ID of the security group.
        :param _builtins.str status: The status of the resource. Valid values:
        :param _builtins.str volume_id: The ID of the NAS instance. Currently, you cannot automatically create an Alibaba Cloud NAS instance.
        :param _builtins.str volume_mountpoint: The mount target of the file system. Mount targets cannot be automatically created for NAS file systems.
        :param _builtins.str volume_protocol: The type of the protocol that is used by the file system.
        :param _builtins.str volume_type: The type of the network shared storage. Valid value: NAS.
        :param _builtins.str vpc_id: The ID of the VPC network.
        :param _builtins.str vswitch_id: The vswitch id.
        :param _builtins.str zone_id: The available zone ID.
        """
        pulumi.set(__self__, "account_type", account_type)
        pulumi.set(__self__, "applications", applications)
        pulumi.set(__self__, "client_version", client_version)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "compute_count", compute_count)
        pulumi.set(__self__, "compute_instance_type", compute_instance_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "deploy_mode", deploy_mode)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ha_enable", ha_enable)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "image_owner_alias", image_owner_alias)
        pulumi.set(__self__, "login_count", login_count)
        pulumi.set(__self__, "login_instance_type", login_instance_type)
        pulumi.set(__self__, "manager_count", manager_count)
        pulumi.set(__self__, "manager_instance_type", manager_instance_type)
        pulumi.set(__self__, "os_tag", os_tag)
        pulumi.set(__self__, "post_install_scripts", post_install_scripts)
        pulumi.set(__self__, "remote_directory", remote_directory)
        pulumi.set(__self__, "scc_cluster_id", scc_cluster_id)
        pulumi.set(__self__, "scheduler_type", scheduler_type)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "volume_id", volume_id)
        pulumi.set(__self__, "volume_mountpoint", volume_mountpoint)
        pulumi.set(__self__, "volume_protocol", volume_protocol)
        pulumi.set(__self__, "volume_type", volume_type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> _builtins.str:
        """
        The server type of the account.
        """
        return pulumi.get(self, "account_type")

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Sequence['outputs.GetClustersClusterApplicationResult']:
        """
        A list of clustered applications.
        """
        return pulumi.get(self, "applications")

    @_builtins.property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> _builtins.str:
        """
        The version number of the client used by the cluster.
        """
        return pulumi.get(self, "client_version")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The id of E-HPC Cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        """
        The name of E-HPC cluster.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> _builtins.int:
        """
        The number of compute nodes in the cluster.
        """
        return pulumi.get(self, "compute_count")

    @_builtins.property
    @pulumi.getter(name="computeInstanceType")
    def compute_instance_type(self) -> _builtins.str:
        """
        Cluster compute node specifications.
        """
        return pulumi.get(self, "compute_instance_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deployMode")
    def deploy_mode(self) -> _builtins.str:
        """
        Cluster deployment mode. Possible values:
        - Standard: separate deployment of account nodes, scheduling nodes, login nodes, and compute nodes.
        - Advanced:HA mode deployment.
        - Simple: the account node and the scheduling node are deployed on one node, and the login node and the compute node are deployed separately.
        - Tiny: account nodes, scheduling nodes, and login nodes are deployed on one node, and compute nodes are deployed separately.
        - OneBox: account node, scheduling node, login node and compute node are deployed on one node.
        """
        return pulumi.get(self, "deploy_mode")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of E-HPC cluster.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="haEnable")
    def ha_enable(self) -> _builtins.bool:
        """
        Whether to turn on high availability. > If high availability is enabled, each control role in the cluster will use two primary and secondary instances.
        """
        return pulumi.get(self, "ha_enable")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Cluster.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        The ID of the Image.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> _builtins.str:
        """
        The type of the image.
        """
        return pulumi.get(self, "image_owner_alias")

    @_builtins.property
    @pulumi.getter(name="loginCount")
    def login_count(self) -> _builtins.int:
        """
        The number of cluster login nodes. Only configuration 1 is supported.
        """
        return pulumi.get(self, "login_count")

    @_builtins.property
    @pulumi.getter(name="loginInstanceType")
    def login_instance_type(self) -> _builtins.str:
        """
        Cluster login node specifications.
        """
        return pulumi.get(self, "login_instance_type")

    @_builtins.property
    @pulumi.getter(name="managerCount")
    def manager_count(self) -> _builtins.int:
        """
        The number of control nodes.
        """
        return pulumi.get(self, "manager_count")

    @_builtins.property
    @pulumi.getter(name="managerInstanceType")
    def manager_instance_type(self) -> _builtins.str:
        """
        The instance type of manager nodes.
        """
        return pulumi.get(self, "manager_instance_type")

    @_builtins.property
    @pulumi.getter(name="osTag")
    def os_tag(self) -> _builtins.str:
        """
        The image tag of the operating system.
        """
        return pulumi.get(self, "os_tag")

    @_builtins.property
    @pulumi.getter(name="postInstallScripts")
    def post_install_scripts(self) -> Sequence['outputs.GetClustersClusterPostInstallScriptResult']:
        """
        List of post-installation scripts.
        """
        return pulumi.get(self, "post_install_scripts")

    @_builtins.property
    @pulumi.getter(name="remoteDirectory")
    def remote_directory(self) -> _builtins.str:
        """
        Mount the remote directory of the shared storage.
        """
        return pulumi.get(self, "remote_directory")

    @_builtins.property
    @pulumi.getter(name="sccClusterId")
    def scc_cluster_id(self) -> _builtins.str:
        """
        The SccCluster ID used by the cluster. If the cluster is not an SCC model, it is empty.
        """
        return pulumi.get(self, "scc_cluster_id")

    @_builtins.property
    @pulumi.getter(name="schedulerType")
    def scheduler_type(self) -> _builtins.str:
        """
        Dispatch server type.
        """
        return pulumi.get(self, "scheduler_type")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource. Valid values:
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> _builtins.str:
        """
        The ID of the NAS instance. Currently, you cannot automatically create an Alibaba Cloud NAS instance.
        """
        return pulumi.get(self, "volume_id")

    @_builtins.property
    @pulumi.getter(name="volumeMountpoint")
    def volume_mountpoint(self) -> _builtins.str:
        """
        The mount target of the file system. Mount targets cannot be automatically created for NAS file systems.
        """
        return pulumi.get(self, "volume_mountpoint")

    @_builtins.property
    @pulumi.getter(name="volumeProtocol")
    def volume_protocol(self) -> _builtins.str:
        """
        The type of the protocol that is used by the file system.
        """
        return pulumi.get(self, "volume_protocol")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> _builtins.str:
        """
        The type of the network shared storage. Valid value: NAS.
        """
        return pulumi.get(self, "volume_type")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC network.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The available zone ID.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetClustersClusterApplicationResult(dict):
    def __init__(__self__, *,
                 tag: _builtins.str):
        """
        :param _builtins.str tag: Application Tags.
        """
        pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        Application Tags.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class GetClustersClusterPostInstallScriptResult(dict):
    def __init__(__self__, *,
                 args: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str args: The parameters of the script.
        :param _builtins.str url: The download path of the script.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def args(self) -> _builtins.str:
        """
        The parameters of the script.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The download path of the script.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetJobTemplatesTemplateResult(dict):
    def __init__(__self__, *,
                 array_request: _builtins.str,
                 clock_time: _builtins.str,
                 command_line: _builtins.str,
                 gpu: _builtins.int,
                 id: _builtins.str,
                 job_template_id: _builtins.str,
                 job_template_name: _builtins.str,
                 mem: _builtins.str,
                 node: _builtins.int,
                 package_path: _builtins.str,
                 priority: _builtins.int,
                 queue: _builtins.str,
                 re_runable: _builtins.bool,
                 runas_user: _builtins.str,
                 stderr_redirect_path: _builtins.str,
                 stdout_redirect_path: _builtins.str,
                 task: _builtins.int,
                 thread: _builtins.int,
                 variables: _builtins.str):
        """
        :param _builtins.str array_request: Queue Jobs, Is of the Form: 1-10:2.
        :param _builtins.str clock_time: Job Maximum Run Time.
        :param _builtins.str command_line: Job Commands.
        :param _builtins.int gpu: A Single Compute Node Using the GPU Number.Possible Values: 1~20000.
        :param _builtins.str id: The ID of the Job Template.
        :param _builtins.str job_template_id: The first ID of the resource.
        :param _builtins.str job_template_name: A Job Template Name.
        :param _builtins.str mem: A Single Compute Node Maximum Memory.
        :param _builtins.int node: Submit a Task Is Required for Computing the Number of Data Nodes to Be. Possible Values: 1~5000 .
        :param _builtins.str package_path: Job Commands the Directory.
        :param _builtins.int priority: The Job Priority.Possible Values: 0~9.
        :param _builtins.str queue: The Job Queue.
        :param _builtins.bool re_runable: If the Job Is Support for the Re-Run.
        :param _builtins.str runas_user: The name of the user who performed the job.
        :param _builtins.str stderr_redirect_path: Error Output Path.
        :param _builtins.str stdout_redirect_path: Standard Output Path and.
        :param _builtins.int task: A Single Compute Node Required Number of Tasks. Possible Values: 1~20000 .
        :param _builtins.int thread: A Single Task and the Number of Required Threads.Possible Values: 1~20000.
        :param _builtins.str variables: The Job of the Environment Variable.
        """
        pulumi.set(__self__, "array_request", array_request)
        pulumi.set(__self__, "clock_time", clock_time)
        pulumi.set(__self__, "command_line", command_line)
        pulumi.set(__self__, "gpu", gpu)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "job_template_id", job_template_id)
        pulumi.set(__self__, "job_template_name", job_template_name)
        pulumi.set(__self__, "mem", mem)
        pulumi.set(__self__, "node", node)
        pulumi.set(__self__, "package_path", package_path)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "queue", queue)
        pulumi.set(__self__, "re_runable", re_runable)
        pulumi.set(__self__, "runas_user", runas_user)
        pulumi.set(__self__, "stderr_redirect_path", stderr_redirect_path)
        pulumi.set(__self__, "stdout_redirect_path", stdout_redirect_path)
        pulumi.set(__self__, "task", task)
        pulumi.set(__self__, "thread", thread)
        pulumi.set(__self__, "variables", variables)

    @_builtins.property
    @pulumi.getter(name="arrayRequest")
    def array_request(self) -> _builtins.str:
        """
        Queue Jobs, Is of the Form: 1-10:2.
        """
        return pulumi.get(self, "array_request")

    @_builtins.property
    @pulumi.getter(name="clockTime")
    def clock_time(self) -> _builtins.str:
        """
        Job Maximum Run Time.
        """
        return pulumi.get(self, "clock_time")

    @_builtins.property
    @pulumi.getter(name="commandLine")
    def command_line(self) -> _builtins.str:
        """
        Job Commands.
        """
        return pulumi.get(self, "command_line")

    @_builtins.property
    @pulumi.getter
    def gpu(self) -> _builtins.int:
        """
        A Single Compute Node Using the GPU Number.Possible Values: 1~20000.
        """
        return pulumi.get(self, "gpu")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Job Template.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="jobTemplateId")
    def job_template_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "job_template_id")

    @_builtins.property
    @pulumi.getter(name="jobTemplateName")
    def job_template_name(self) -> _builtins.str:
        """
        A Job Template Name.
        """
        return pulumi.get(self, "job_template_name")

    @_builtins.property
    @pulumi.getter
    def mem(self) -> _builtins.str:
        """
        A Single Compute Node Maximum Memory.
        """
        return pulumi.get(self, "mem")

    @_builtins.property
    @pulumi.getter
    def node(self) -> _builtins.int:
        """
        Submit a Task Is Required for Computing the Number of Data Nodes to Be. Possible Values: 1~5000 .
        """
        return pulumi.get(self, "node")

    @_builtins.property
    @pulumi.getter(name="packagePath")
    def package_path(self) -> _builtins.str:
        """
        Job Commands the Directory.
        """
        return pulumi.get(self, "package_path")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The Job Priority.Possible Values: 0~9.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def queue(self) -> _builtins.str:
        """
        The Job Queue.
        """
        return pulumi.get(self, "queue")

    @_builtins.property
    @pulumi.getter(name="reRunable")
    def re_runable(self) -> _builtins.bool:
        """
        If the Job Is Support for the Re-Run.
        """
        return pulumi.get(self, "re_runable")

    @_builtins.property
    @pulumi.getter(name="runasUser")
    def runas_user(self) -> _builtins.str:
        """
        The name of the user who performed the job.
        """
        return pulumi.get(self, "runas_user")

    @_builtins.property
    @pulumi.getter(name="stderrRedirectPath")
    def stderr_redirect_path(self) -> _builtins.str:
        """
        Error Output Path.
        """
        return pulumi.get(self, "stderr_redirect_path")

    @_builtins.property
    @pulumi.getter(name="stdoutRedirectPath")
    def stdout_redirect_path(self) -> _builtins.str:
        """
        Standard Output Path and.
        """
        return pulumi.get(self, "stdout_redirect_path")

    @_builtins.property
    @pulumi.getter
    def task(self) -> _builtins.int:
        """
        A Single Compute Node Required Number of Tasks. Possible Values: 1~20000 .
        """
        return pulumi.get(self, "task")

    @_builtins.property
    @pulumi.getter
    def thread(self) -> _builtins.int:
        """
        A Single Task and the Number of Required Threads.Possible Values: 1~20000.
        """
        return pulumi.get(self, "thread")

    @_builtins.property
    @pulumi.getter
    def variables(self) -> _builtins.str:
        """
        The Job of the Environment Variable.
        """
        return pulumi.get(self, "variables")


