# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 applications: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 cluster_name: pulumi.Input[_builtins.str],
                 cluster_type: pulumi.Input[_builtins.str],
                 node_attributes: pulumi.Input[Sequence[pulumi.Input['ClusterNodeAttributeArgs']]],
                 node_groups: pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]],
                 release_version: pulumi.Input[_builtins.str],
                 application_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationConfigArgs']]]] = None,
                 bootstrap_scripts: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapScriptArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 deploy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 log_collect_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_config: Optional[pulumi.Input['ClusterSubscriptionConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
        :param pulumi.Input[_builtins.str] cluster_name: The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        :param pulumi.Input[_builtins.str] cluster_type: EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeAttributeArgs']]] node_attributes: The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]] node_groups: Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below. **NOTE:** Since version 1.227.0, the type of `node_groups` changed from Set to List.
        :param pulumi.Input[_builtins.str] release_version: EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterApplicationConfigArgs']]] application_configs: The application configurations of EMR cluster. See `application_configs` below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapScriptArgs']]] bootstrap_scripts: The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster, if priority is not specified, the scripts will execute in the declared order. See `bootstrap_scripts` below.
        :param pulumi.Input[_builtins.bool] deletion_protection: The deletion protection of EMR cluster.
        :param pulumi.Input[_builtins.str] deploy_mode: The deploy mode of EMR cluster. Supported value: NORMAL or HA.
        :param pulumi.Input[_builtins.str] log_collect_strategy: The log collect strategy of EMR cluster.
        :param pulumi.Input[_builtins.str] payment_type: Payment Type for this cluster. Supported value: PayAsYouGo or Subscription. **NOTE:** From version 1.227.0, `payment_type` can be modified.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the emr-cluster belongs.
        :param pulumi.Input[_builtins.str] security_mode: The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
        :param pulumi.Input['ClusterSubscriptionConfigArgs'] subscription_config: The detail configuration of subscription payment type. See `subscription_config` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "applications", applications)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "node_attributes", node_attributes)
        pulumi.set(__self__, "node_groups", node_groups)
        pulumi.set(__self__, "release_version", release_version)
        if application_configs is not None:
            pulumi.set(__self__, "application_configs", application_configs)
        if bootstrap_scripts is not None:
            pulumi.set(__self__, "bootstrap_scripts", bootstrap_scripts)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if deploy_mode is not None:
            pulumi.set(__self__, "deploy_mode", deploy_mode)
        if log_collect_strategy is not None:
            pulumi.set(__self__, "log_collect_strategy", log_collect_strategy)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_mode is not None:
            pulumi.set(__self__, "security_mode", security_mode)
        if subscription_config is not None:
            pulumi.set(__self__, "subscription_config", subscription_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Input[_builtins.str]:
        """
        EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="nodeAttributes")
    def node_attributes(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterNodeAttributeArgs']]]:
        """
        The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
        """
        return pulumi.get(self, "node_attributes")

    @node_attributes.setter
    def node_attributes(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterNodeAttributeArgs']]]):
        pulumi.set(self, "node_attributes", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroups")
    def node_groups(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]]:
        """
        Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below. **NOTE:** Since version 1.227.0, the type of `node_groups` changed from Set to List.
        """
        return pulumi.get(self, "node_groups")

    @node_groups.setter
    def node_groups(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]]):
        pulumi.set(self, "node_groups", value)

    @_builtins.property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> pulumi.Input[_builtins.str]:
        """
        EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
        """
        return pulumi.get(self, "release_version")

    @release_version.setter
    def release_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "release_version", value)

    @_builtins.property
    @pulumi.getter(name="applicationConfigs")
    def application_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationConfigArgs']]]]:
        """
        The application configurations of EMR cluster. See `application_configs` below.
        """
        return pulumi.get(self, "application_configs")

    @application_configs.setter
    def application_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationConfigArgs']]]]):
        pulumi.set(self, "application_configs", value)

    @_builtins.property
    @pulumi.getter(name="bootstrapScripts")
    def bootstrap_scripts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapScriptArgs']]]]:
        """
        The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster, if priority is not specified, the scripts will execute in the declared order. See `bootstrap_scripts` below.
        """
        return pulumi.get(self, "bootstrap_scripts")

    @bootstrap_scripts.setter
    def bootstrap_scripts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapScriptArgs']]]]):
        pulumi.set(self, "bootstrap_scripts", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The deletion protection of EMR cluster.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="deployMode")
    def deploy_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The deploy mode of EMR cluster. Supported value: NORMAL or HA.
        """
        return pulumi.get(self, "deploy_mode")

    @deploy_mode.setter
    def deploy_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deploy_mode", value)

    @_builtins.property
    @pulumi.getter(name="logCollectStrategy")
    def log_collect_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The log collect strategy of EMR cluster.
        """
        return pulumi.get(self, "log_collect_strategy")

    @log_collect_strategy.setter
    def log_collect_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_collect_strategy", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Payment Type for this cluster. Supported value: PayAsYouGo or Subscription. **NOTE:** From version 1.227.0, `payment_type` can be modified.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of resource group which the emr-cluster belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
        """
        return pulumi.get(self, "security_mode")

    @security_mode.setter
    def security_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_mode", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionConfig")
    def subscription_config(self) -> Optional[pulumi.Input['ClusterSubscriptionConfigArgs']]:
        """
        The detail configuration of subscription payment type. See `subscription_config` below.
        """
        return pulumi.get(self, "subscription_config")

    @subscription_config.setter
    def subscription_config(self, value: Optional[pulumi.Input['ClusterSubscriptionConfigArgs']]):
        pulumi.set(self, "subscription_config", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 application_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationConfigArgs']]]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bootstrap_scripts: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapScriptArgs']]]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 deploy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 log_collect_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 node_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeAttributeArgs']]]] = None,
                 node_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 release_version: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_config: Optional[pulumi.Input['ClusterSubscriptionConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterApplicationConfigArgs']]] application_configs: The application configurations of EMR cluster. See `application_configs` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapScriptArgs']]] bootstrap_scripts: The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster, if priority is not specified, the scripts will execute in the declared order. See `bootstrap_scripts` below.
        :param pulumi.Input[_builtins.str] cluster_name: The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        :param pulumi.Input[_builtins.str] cluster_type: EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
        :param pulumi.Input[_builtins.bool] deletion_protection: The deletion protection of EMR cluster.
        :param pulumi.Input[_builtins.str] deploy_mode: The deploy mode of EMR cluster. Supported value: NORMAL or HA.
        :param pulumi.Input[_builtins.str] log_collect_strategy: The log collect strategy of EMR cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeAttributeArgs']]] node_attributes: The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]] node_groups: Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below. **NOTE:** Since version 1.227.0, the type of `node_groups` changed from Set to List.
        :param pulumi.Input[_builtins.str] payment_type: Payment Type for this cluster. Supported value: PayAsYouGo or Subscription. **NOTE:** From version 1.227.0, `payment_type` can be modified.
        :param pulumi.Input[_builtins.str] release_version: EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the emr-cluster belongs.
        :param pulumi.Input[_builtins.str] security_mode: The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
        :param pulumi.Input['ClusterSubscriptionConfigArgs'] subscription_config: The detail configuration of subscription payment type. See `subscription_config` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if application_configs is not None:
            pulumi.set(__self__, "application_configs", application_configs)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if bootstrap_scripts is not None:
            pulumi.set(__self__, "bootstrap_scripts", bootstrap_scripts)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if deploy_mode is not None:
            pulumi.set(__self__, "deploy_mode", deploy_mode)
        if log_collect_strategy is not None:
            pulumi.set(__self__, "log_collect_strategy", log_collect_strategy)
        if node_attributes is not None:
            pulumi.set(__self__, "node_attributes", node_attributes)
        if node_groups is not None:
            pulumi.set(__self__, "node_groups", node_groups)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if release_version is not None:
            pulumi.set(__self__, "release_version", release_version)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_mode is not None:
            pulumi.set(__self__, "security_mode", security_mode)
        if subscription_config is not None:
            pulumi.set(__self__, "subscription_config", subscription_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="applicationConfigs")
    def application_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationConfigArgs']]]]:
        """
        The application configurations of EMR cluster. See `application_configs` below.
        """
        return pulumi.get(self, "application_configs")

    @application_configs.setter
    def application_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationConfigArgs']]]]):
        pulumi.set(self, "application_configs", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter(name="bootstrapScripts")
    def bootstrap_scripts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapScriptArgs']]]]:
        """
        The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster, if priority is not specified, the scripts will execute in the declared order. See `bootstrap_scripts` below.
        """
        return pulumi.get(self, "bootstrap_scripts")

    @bootstrap_scripts.setter
    def bootstrap_scripts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapScriptArgs']]]]):
        pulumi.set(self, "bootstrap_scripts", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The deletion protection of EMR cluster.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="deployMode")
    def deploy_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The deploy mode of EMR cluster. Supported value: NORMAL or HA.
        """
        return pulumi.get(self, "deploy_mode")

    @deploy_mode.setter
    def deploy_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deploy_mode", value)

    @_builtins.property
    @pulumi.getter(name="logCollectStrategy")
    def log_collect_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The log collect strategy of EMR cluster.
        """
        return pulumi.get(self, "log_collect_strategy")

    @log_collect_strategy.setter
    def log_collect_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_collect_strategy", value)

    @_builtins.property
    @pulumi.getter(name="nodeAttributes")
    def node_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeAttributeArgs']]]]:
        """
        The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
        """
        return pulumi.get(self, "node_attributes")

    @node_attributes.setter
    def node_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeAttributeArgs']]]]):
        pulumi.set(self, "node_attributes", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroups")
    def node_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]]]:
        """
        Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below. **NOTE:** Since version 1.227.0, the type of `node_groups` changed from Set to List.
        """
        return pulumi.get(self, "node_groups")

    @node_groups.setter
    def node_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]]]):
        pulumi.set(self, "node_groups", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Payment Type for this cluster. Supported value: PayAsYouGo or Subscription. **NOTE:** From version 1.227.0, `payment_type` can be modified.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
        """
        return pulumi.get(self, "release_version")

    @release_version.setter
    def release_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_version", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of resource group which the emr-cluster belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
        """
        return pulumi.get(self, "security_mode")

    @security_mode.setter
    def security_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_mode", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionConfig")
    def subscription_config(self) -> Optional[pulumi.Input['ClusterSubscriptionConfigArgs']]:
        """
        The detail configuration of subscription payment type. See `subscription_config` below.
        """
        return pulumi.get(self, "subscription_config")

    @subscription_config.setter
    def subscription_config(self, value: Optional[pulumi.Input['ClusterSubscriptionConfigArgs']]):
        pulumi.set(self, "subscription_config", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:emrv2/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterApplicationConfigArgs', 'ClusterApplicationConfigArgsDict']]]]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bootstrap_scripts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterBootstrapScriptArgs', 'ClusterBootstrapScriptArgsDict']]]]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 deploy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 log_collect_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 node_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeAttributeArgs', 'ClusterNodeAttributeArgsDict']]]]] = None,
                 node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeGroupArgs', 'ClusterNodeGroupArgsDict']]]]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 release_version: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_config: Optional[pulumi.Input[Union['ClusterSubscriptionConfigArgs', 'ClusterSubscriptionConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a EMR cluster resource. This resource is based on EMR's new version OpenAPI.

        For information about EMR New and how to use it, see [Add a domain](https://www.alibabacloud.com/help/doc-detail/28068.htm).

        > **NOTE:** Available since v1.199.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_get_keys = alicloud.kms.get_keys(status="Enabled")
        default_get_zones = alicloud.get_zones(available_instance_type="ecs.g7.xlarge")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/12")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/21",
            zone_id=default_get_zones.zones[0].id,
            vswitch_name=name)
        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default_ecs_key_pair = alicloud.ecs.EcsKeyPair("default", key_pair_name=f"{name}-{default_integer['result']}")
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_role = alicloud.ram.Role("default",
            name=name,
            document=\"\"\"    {
                \\"Statement\\": [
                {
                    \\"Action\\": \\"sts:AssumeRole\\",
                    \\"Effect\\": \\"Allow\\",
                    \\"Principal\\": {
                    \\"Service\\": [
                        \\"emr.aliyuncs.com\\",
                        \\"ecs.aliyuncs.com\\"
                    ]
                    }
                }
                ],
                \\"Version\\": \\"1\\"
            }
        \"\"\",
            description="this is a role example.",
            force=True)
        default_cluster = alicloud.emrv2.Cluster("default",
            node_groups=[
                {
                    "vswitch_ids": [default_switch.id],
                    "instance_types": ["ecs.g7.xlarge"],
                    "node_count": 1,
                    "spot_instance_remedy": False,
                    "data_disks": [{
                        "count": 3,
                        "category": "cloud_essd",
                        "size": 80,
                        "performance_level": "PL0",
                    }],
                    "node_group_name": "emr-master",
                    "payment_type": "PayAsYouGo",
                    "with_public_ip": False,
                    "graceful_shutdown": False,
                    "system_disk": {
                        "category": "cloud_essd",
                        "size": 80,
                        "performance_level": "PL0",
                        "count": 1,
                    },
                    "node_group_type": "MASTER",
                },
                {
                    "spot_instance_remedy": False,
                    "node_group_type": "CORE",
                    "vswitch_ids": [default_switch.id],
                    "node_count": 2,
                    "graceful_shutdown": False,
                    "system_disk": {
                        "performance_level": "PL0",
                        "count": 1,
                        "category": "cloud_essd",
                        "size": 80,
                    },
                    "data_disks": [{
                        "count": 3,
                        "performance_level": "PL0",
                        "category": "cloud_essd",
                        "size": 80,
                    }],
                    "node_group_name": "emr-core",
                    "payment_type": "PayAsYouGo",
                    "instance_types": ["ecs.g7.xlarge"],
                    "with_public_ip": False,
                },
            ],
            deploy_mode="NORMAL",
            tags={
                "Created": "TF",
                "For": "example",
            },
            release_version="EMR-5.10.0",
            applications=[
                "HADOOP-COMMON",
                "HDFS",
                "YARN",
            ],
            node_attributes=[{
                "zone_id": default_get_zones.zones[0].id,
                "key_pair_name": default_ecs_key_pair.id,
                "data_disk_encrypted": True,
                "data_disk_kms_key_id": default_get_keys.ids[0],
                "vpc_id": default_network.id,
                "ram_role": default_role.name,
                "security_group_id": default_security_group.id,
            }],
            resource_group_id=default.ids[0],
            cluster_name=name,
            payment_type="PayAsYouGo",
            cluster_type="DATAFLOW")
        ```

        ## Import

        Aliclioud E-MapReduce cluster can be imported using the id e.g.

        ```sh
        $ pulumi import alicloud:emrv2/cluster:Cluster default <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterApplicationConfigArgs', 'ClusterApplicationConfigArgsDict']]]] application_configs: The application configurations of EMR cluster. See `application_configs` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterBootstrapScriptArgs', 'ClusterBootstrapScriptArgsDict']]]] bootstrap_scripts: The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster, if priority is not specified, the scripts will execute in the declared order. See `bootstrap_scripts` below.
        :param pulumi.Input[_builtins.str] cluster_name: The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        :param pulumi.Input[_builtins.str] cluster_type: EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
        :param pulumi.Input[_builtins.bool] deletion_protection: The deletion protection of EMR cluster.
        :param pulumi.Input[_builtins.str] deploy_mode: The deploy mode of EMR cluster. Supported value: NORMAL or HA.
        :param pulumi.Input[_builtins.str] log_collect_strategy: The log collect strategy of EMR cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeAttributeArgs', 'ClusterNodeAttributeArgsDict']]]] node_attributes: The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeGroupArgs', 'ClusterNodeGroupArgsDict']]]] node_groups: Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below. **NOTE:** Since version 1.227.0, the type of `node_groups` changed from Set to List.
        :param pulumi.Input[_builtins.str] payment_type: Payment Type for this cluster. Supported value: PayAsYouGo or Subscription. **NOTE:** From version 1.227.0, `payment_type` can be modified.
        :param pulumi.Input[_builtins.str] release_version: EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the emr-cluster belongs.
        :param pulumi.Input[_builtins.str] security_mode: The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
        :param pulumi.Input[Union['ClusterSubscriptionConfigArgs', 'ClusterSubscriptionConfigArgsDict']] subscription_config: The detail configuration of subscription payment type. See `subscription_config` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a EMR cluster resource. This resource is based on EMR's new version OpenAPI.

        For information about EMR New and how to use it, see [Add a domain](https://www.alibabacloud.com/help/doc-detail/28068.htm).

        > **NOTE:** Available since v1.199.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_get_keys = alicloud.kms.get_keys(status="Enabled")
        default_get_zones = alicloud.get_zones(available_instance_type="ecs.g7.xlarge")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/12")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/21",
            zone_id=default_get_zones.zones[0].id,
            vswitch_name=name)
        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default_ecs_key_pair = alicloud.ecs.EcsKeyPair("default", key_pair_name=f"{name}-{default_integer['result']}")
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=name,
            vpc_id=default_network.id)
        default_role = alicloud.ram.Role("default",
            name=name,
            document=\"\"\"    {
                \\"Statement\\": [
                {
                    \\"Action\\": \\"sts:AssumeRole\\",
                    \\"Effect\\": \\"Allow\\",
                    \\"Principal\\": {
                    \\"Service\\": [
                        \\"emr.aliyuncs.com\\",
                        \\"ecs.aliyuncs.com\\"
                    ]
                    }
                }
                ],
                \\"Version\\": \\"1\\"
            }
        \"\"\",
            description="this is a role example.",
            force=True)
        default_cluster = alicloud.emrv2.Cluster("default",
            node_groups=[
                {
                    "vswitch_ids": [default_switch.id],
                    "instance_types": ["ecs.g7.xlarge"],
                    "node_count": 1,
                    "spot_instance_remedy": False,
                    "data_disks": [{
                        "count": 3,
                        "category": "cloud_essd",
                        "size": 80,
                        "performance_level": "PL0",
                    }],
                    "node_group_name": "emr-master",
                    "payment_type": "PayAsYouGo",
                    "with_public_ip": False,
                    "graceful_shutdown": False,
                    "system_disk": {
                        "category": "cloud_essd",
                        "size": 80,
                        "performance_level": "PL0",
                        "count": 1,
                    },
                    "node_group_type": "MASTER",
                },
                {
                    "spot_instance_remedy": False,
                    "node_group_type": "CORE",
                    "vswitch_ids": [default_switch.id],
                    "node_count": 2,
                    "graceful_shutdown": False,
                    "system_disk": {
                        "performance_level": "PL0",
                        "count": 1,
                        "category": "cloud_essd",
                        "size": 80,
                    },
                    "data_disks": [{
                        "count": 3,
                        "performance_level": "PL0",
                        "category": "cloud_essd",
                        "size": 80,
                    }],
                    "node_group_name": "emr-core",
                    "payment_type": "PayAsYouGo",
                    "instance_types": ["ecs.g7.xlarge"],
                    "with_public_ip": False,
                },
            ],
            deploy_mode="NORMAL",
            tags={
                "Created": "TF",
                "For": "example",
            },
            release_version="EMR-5.10.0",
            applications=[
                "HADOOP-COMMON",
                "HDFS",
                "YARN",
            ],
            node_attributes=[{
                "zone_id": default_get_zones.zones[0].id,
                "key_pair_name": default_ecs_key_pair.id,
                "data_disk_encrypted": True,
                "data_disk_kms_key_id": default_get_keys.ids[0],
                "vpc_id": default_network.id,
                "ram_role": default_role.name,
                "security_group_id": default_security_group.id,
            }],
            resource_group_id=default.ids[0],
            cluster_name=name,
            payment_type="PayAsYouGo",
            cluster_type="DATAFLOW")
        ```

        ## Import

        Aliclioud E-MapReduce cluster can be imported using the id e.g.

        ```sh
        $ pulumi import alicloud:emrv2/cluster:Cluster default <id>
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterApplicationConfigArgs', 'ClusterApplicationConfigArgsDict']]]]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bootstrap_scripts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterBootstrapScriptArgs', 'ClusterBootstrapScriptArgsDict']]]]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 deploy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 log_collect_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 node_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeAttributeArgs', 'ClusterNodeAttributeArgsDict']]]]] = None,
                 node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeGroupArgs', 'ClusterNodeGroupArgsDict']]]]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 release_version: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_config: Optional[pulumi.Input[Union['ClusterSubscriptionConfigArgs', 'ClusterSubscriptionConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["application_configs"] = application_configs
            if applications is None and not opts.urn:
                raise TypeError("Missing required property 'applications'")
            __props__.__dict__["applications"] = applications
            __props__.__dict__["bootstrap_scripts"] = bootstrap_scripts
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            if cluster_type is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_type'")
            __props__.__dict__["cluster_type"] = cluster_type
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["deploy_mode"] = deploy_mode
            __props__.__dict__["log_collect_strategy"] = log_collect_strategy
            if node_attributes is None and not opts.urn:
                raise TypeError("Missing required property 'node_attributes'")
            __props__.__dict__["node_attributes"] = node_attributes
            if node_groups is None and not opts.urn:
                raise TypeError("Missing required property 'node_groups'")
            __props__.__dict__["node_groups"] = node_groups
            __props__.__dict__["payment_type"] = payment_type
            if release_version is None and not opts.urn:
                raise TypeError("Missing required property 'release_version'")
            __props__.__dict__["release_version"] = release_version
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_mode"] = security_mode
            __props__.__dict__["subscription_config"] = subscription_config
            __props__.__dict__["tags"] = tags
        super(Cluster, __self__).__init__(
            'alicloud:emrv2/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterApplicationConfigArgs', 'ClusterApplicationConfigArgsDict']]]]] = None,
            applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bootstrap_scripts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterBootstrapScriptArgs', 'ClusterBootstrapScriptArgsDict']]]]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            deploy_mode: Optional[pulumi.Input[_builtins.str]] = None,
            log_collect_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            node_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeAttributeArgs', 'ClusterNodeAttributeArgsDict']]]]] = None,
            node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeGroupArgs', 'ClusterNodeGroupArgsDict']]]]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            release_version: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_mode: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_config: Optional[pulumi.Input[Union['ClusterSubscriptionConfigArgs', 'ClusterSubscriptionConfigArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterApplicationConfigArgs', 'ClusterApplicationConfigArgsDict']]]] application_configs: The application configurations of EMR cluster. See `application_configs` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterBootstrapScriptArgs', 'ClusterBootstrapScriptArgsDict']]]] bootstrap_scripts: The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster, if priority is not specified, the scripts will execute in the declared order. See `bootstrap_scripts` below.
        :param pulumi.Input[_builtins.str] cluster_name: The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        :param pulumi.Input[_builtins.str] cluster_type: EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
        :param pulumi.Input[_builtins.bool] deletion_protection: The deletion protection of EMR cluster.
        :param pulumi.Input[_builtins.str] deploy_mode: The deploy mode of EMR cluster. Supported value: NORMAL or HA.
        :param pulumi.Input[_builtins.str] log_collect_strategy: The log collect strategy of EMR cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeAttributeArgs', 'ClusterNodeAttributeArgsDict']]]] node_attributes: The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeGroupArgs', 'ClusterNodeGroupArgsDict']]]] node_groups: Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below. **NOTE:** Since version 1.227.0, the type of `node_groups` changed from Set to List.
        :param pulumi.Input[_builtins.str] payment_type: Payment Type for this cluster. Supported value: PayAsYouGo or Subscription. **NOTE:** From version 1.227.0, `payment_type` can be modified.
        :param pulumi.Input[_builtins.str] release_version: EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the emr-cluster belongs.
        :param pulumi.Input[_builtins.str] security_mode: The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
        :param pulumi.Input[Union['ClusterSubscriptionConfigArgs', 'ClusterSubscriptionConfigArgsDict']] subscription_config: The detail configuration of subscription payment type. See `subscription_config` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["application_configs"] = application_configs
        __props__.__dict__["applications"] = applications
        __props__.__dict__["bootstrap_scripts"] = bootstrap_scripts
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["cluster_type"] = cluster_type
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["deploy_mode"] = deploy_mode
        __props__.__dict__["log_collect_strategy"] = log_collect_strategy
        __props__.__dict__["node_attributes"] = node_attributes
        __props__.__dict__["node_groups"] = node_groups
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["release_version"] = release_version
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_mode"] = security_mode
        __props__.__dict__["subscription_config"] = subscription_config
        __props__.__dict__["tags"] = tags
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationConfigs")
    def application_configs(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterApplicationConfig']]]:
        """
        The application configurations of EMR cluster. See `application_configs` below.
        """
        return pulumi.get(self, "application_configs")

    @_builtins.property
    @pulumi.getter
    def applications(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
        """
        return pulumi.get(self, "applications")

    @_builtins.property
    @pulumi.getter(name="bootstrapScripts")
    def bootstrap_scripts(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterBootstrapScript']]]:
        """
        The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster, if priority is not specified, the scripts will execute in the declared order. See `bootstrap_scripts` below.
        """
        return pulumi.get(self, "bootstrap_scripts")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Output[_builtins.str]:
        """
        EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The deletion protection of EMR cluster.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="deployMode")
    def deploy_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The deploy mode of EMR cluster. Supported value: NORMAL or HA.
        """
        return pulumi.get(self, "deploy_mode")

    @_builtins.property
    @pulumi.getter(name="logCollectStrategy")
    def log_collect_strategy(self) -> pulumi.Output[_builtins.str]:
        """
        The log collect strategy of EMR cluster.
        """
        return pulumi.get(self, "log_collect_strategy")

    @_builtins.property
    @pulumi.getter(name="nodeAttributes")
    def node_attributes(self) -> pulumi.Output[Sequence['outputs.ClusterNodeAttribute']]:
        """
        The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
        """
        return pulumi.get(self, "node_attributes")

    @_builtins.property
    @pulumi.getter(name="nodeGroups")
    def node_groups(self) -> pulumi.Output[Sequence['outputs.ClusterNodeGroup']]:
        """
        Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below. **NOTE:** Since version 1.227.0, the type of `node_groups` changed from Set to List.
        """
        return pulumi.get(self, "node_groups")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        Payment Type for this cluster. Supported value: PayAsYouGo or Subscription. **NOTE:** From version 1.227.0, `payment_type` can be modified.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> pulumi.Output[_builtins.str]:
        """
        EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
        """
        return pulumi.get(self, "release_version")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Id of resource group which the emr-cluster belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
        """
        return pulumi.get(self, "security_mode")

    @_builtins.property
    @pulumi.getter(name="subscriptionConfig")
    def subscription_config(self) -> pulumi.Output[Optional['outputs.ClusterSubscriptionConfig']]:
        """
        The detail configuration of subscription payment type. See `subscription_config` below.
        """
        return pulumi.get(self, "subscription_config")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

