# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'InstanceDataDiskArgs',
    'InstanceDataDiskArgsDict',
    'InstanceSystemDiskArgs',
    'InstanceSystemDiskArgsDict',
    'LoadBalancerBackendServerArgs',
    'LoadBalancerBackendServerArgsDict',
]

MYPY = False

if not MYPY:
    class InstanceDataDiskArgsDict(TypedDict):
        category: NotRequired[pulumi.Input[_builtins.str]]
        """
        Data disk type. Optional values:
        - cloud_efficiency: Ultra cloud disk
        - cloud_ssd: Full Flash cloud disk
        - local_hdd: local hdd disk
        - local_ssd: local disk ssd.
        """
        disk_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Cloud Disk ID.
        """
        encrypt_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the KMS key used by the cloud disk.
        """
        encrypted: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to encrypt the cloud disk. Value range:  true: Yes  false (default): No.
        """
        size: NotRequired[pulumi.Input[_builtins.int]]
        """
        Data disk size, unit: GB.
        """
elif False:
    InstanceDataDiskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceDataDiskArgs:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] category: Data disk type. Optional values:
               - cloud_efficiency: Ultra cloud disk
               - cloud_ssd: Full Flash cloud disk
               - local_hdd: local hdd disk
               - local_ssd: local disk ssd.
        :param pulumi.Input[_builtins.str] disk_id: Cloud Disk ID.
        :param pulumi.Input[_builtins.str] encrypt_key_id: The ID of the KMS key used by the cloud disk.
        :param pulumi.Input[_builtins.bool] encrypted: Whether to encrypt the cloud disk. Value range:  true: Yes  false (default): No.
        :param pulumi.Input[_builtins.int] size: Data disk size, unit: GB.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if encrypt_key_id is not None:
            pulumi.set(__self__, "encrypt_key_id", encrypt_key_id)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data disk type. Optional values:
        - cloud_efficiency: Ultra cloud disk
        - cloud_ssd: Full Flash cloud disk
        - local_hdd: local hdd disk
        - local_ssd: local disk ssd.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud Disk ID.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_id", value)

    @_builtins.property
    @pulumi.getter(name="encryptKeyId")
    def encrypt_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS key used by the cloud disk.
        """
        return pulumi.get(self, "encrypt_key_id")

    @encrypt_key_id.setter
    def encrypt_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypt_key_id", value)

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to encrypt the cloud disk. Value range:  true: Yes  false (default): No.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Data disk size, unit: GB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)


if not MYPY:
    class InstanceSystemDiskArgsDict(TypedDict):
        category: NotRequired[pulumi.Input[_builtins.str]]
        """
        System disk type. Value
        - cloud_efficiency: Ultra cloud disk
        - cloud_ssd: Full Flash cloud disk
        - local_hdd: local hdd disk
        - local_ssd: local disk ssd.
        """
        size: NotRequired[pulumi.Input[_builtins.int]]
        """
        System disk size, unit: GB.
        """
elif False:
    InstanceSystemDiskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceSystemDiskArgs:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] category: System disk type. Value
               - cloud_efficiency: Ultra cloud disk
               - cloud_ssd: Full Flash cloud disk
               - local_hdd: local hdd disk
               - local_ssd: local disk ssd.
        :param pulumi.Input[_builtins.int] size: System disk size, unit: GB.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        System disk type. Value
        - cloud_efficiency: Ultra cloud disk
        - cloud_ssd: Full Flash cloud disk
        - local_hdd: local hdd disk
        - local_ssd: local disk ssd.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        System disk size, unit: GB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)


if not MYPY:
    class LoadBalancerBackendServerArgsDict(TypedDict):
        server_id: pulumi.Input[_builtins.str]
        """
        Backend server instance ID  Example value: i-5vb5h5njxiuhn48a * * * *.
        """
        ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        IP address of the backend server  Example value: 192.168.0.5.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        Port used by the backend server.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Backend server type  Example value: ens.
        """
        weight: NotRequired[pulumi.Input[_builtins.int]]
        """
        Weight of the backend server  Example value: 100.
        """
elif False:
    LoadBalancerBackendServerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerBackendServerArgs:
    def __init__(__self__, *,
                 server_id: pulumi.Input[_builtins.str],
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] server_id: Backend server instance ID  Example value: i-5vb5h5njxiuhn48a * * * *.
        :param pulumi.Input[_builtins.str] ip: IP address of the backend server  Example value: 192.168.0.5.
        :param pulumi.Input[_builtins.int] port: Port used by the backend server.
        :param pulumi.Input[_builtins.str] type: Backend server type  Example value: ens.
        :param pulumi.Input[_builtins.int] weight: Weight of the backend server  Example value: 100.
        """
        pulumi.set(__self__, "server_id", server_id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Input[_builtins.str]:
        """
        Backend server instance ID  Example value: i-5vb5h5njxiuhn48a * * * *.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address of the backend server  Example value: 192.168.0.5.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port used by the backend server.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backend server type  Example value: ens.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Weight of the backend server  Example value: 100.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weight", value)


