# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ClientCaCertificateArgs', 'ClientCaCertificate']

@pulumi.input_type
class ClientCaCertificateArgs:
    def __init__(__self__, *,
                 certificate: pulumi.Input[_builtins.str],
                 site_id: pulumi.Input[_builtins.int],
                 client_ca_cert_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ClientCaCertificate resource.
        :param pulumi.Input[_builtins.str] certificate: Certificate content.
        :param pulumi.Input[_builtins.int] site_id: Site Id
        :param pulumi.Input[_builtins.str] client_ca_cert_name: The certificate name.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "site_id", site_id)
        if client_ca_cert_name is not None:
            pulumi.set(__self__, "client_ca_cert_name", client_ca_cert_name)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Input[_builtins.str]:
        """
        Certificate content.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="clientCaCertName")
    def client_ca_cert_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate name.
        """
        return pulumi.get(self, "client_ca_cert_name")

    @client_ca_cert_name.setter
    def client_ca_cert_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_ca_cert_name", value)


@pulumi.input_type
class _ClientCaCertificateState:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_cert_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClientCaCertificate resources.
        :param pulumi.Input[_builtins.str] certificate: Certificate content.
        :param pulumi.Input[_builtins.str] client_ca_cert_id: ClientCaCertificate Id
        :param pulumi.Input[_builtins.str] client_ca_cert_name: The certificate name.
        :param pulumi.Input[_builtins.str] create_time: Creation time.
        :param pulumi.Input[_builtins.int] site_id: Site Id
        :param pulumi.Input[_builtins.str] status: Certificate status.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if client_ca_cert_id is not None:
            pulumi.set(__self__, "client_ca_cert_id", client_ca_cert_id)
        if client_ca_cert_name is not None:
            pulumi.set(__self__, "client_ca_cert_name", client_ca_cert_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate content.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="clientCaCertId")
    def client_ca_cert_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ClientCaCertificate Id
        """
        return pulumi.get(self, "client_ca_cert_id")

    @client_ca_cert_id.setter
    def client_ca_cert_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_ca_cert_id", value)

    @_builtins.property
    @pulumi.getter(name="clientCaCertName")
    def client_ca_cert_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate name.
        """
        return pulumi.get(self, "client_ca_cert_name")

    @client_ca_cert_name.setter
    def client_ca_cert_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_ca_cert_name", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:esa/clientCaCertificate:ClientCaCertificate")
class ClientCaCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a ESA Client Ca Certificate resource.

        For information about ESA Client Ca Certificate and how to use it, see [What is Client Ca Certificate](https://next.api.alibabacloud.com/document/ESA/2024-09-10/UploadClientCaCertificate).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan",
            site_name="gositecdn.cn")
        default_client_ca_certificate = alicloud.esa.ClientCaCertificate("default",
            certificate=\"\"\"-----BEGIN CERTIFICATE-----
        ****-----END CERTIFICATE-----\"\"\",
            client_ca_cert_name="example",
            site_id=default.sites[0].id)
        ```

        ## Import

        ESA Client Ca Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/clientCaCertificate:ClientCaCertificate example <site_id>:<client_ca_cert_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate: Certificate content.
        :param pulumi.Input[_builtins.str] client_ca_cert_name: The certificate name.
        :param pulumi.Input[_builtins.int] site_id: Site Id
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClientCaCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Client Ca Certificate resource.

        For information about ESA Client Ca Certificate and how to use it, see [What is Client Ca Certificate](https://next.api.alibabacloud.com/document/ESA/2024-09-10/UploadClientCaCertificate).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan",
            site_name="gositecdn.cn")
        default_client_ca_certificate = alicloud.esa.ClientCaCertificate("default",
            certificate=\"\"\"-----BEGIN CERTIFICATE-----
        ****-----END CERTIFICATE-----\"\"\",
            client_ca_cert_name="example",
            site_id=default.sites[0].id)
        ```

        ## Import

        ESA Client Ca Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/clientCaCertificate:ClientCaCertificate example <site_id>:<client_ca_cert_id>
        ```

        :param str resource_name: The name of the resource.
        :param ClientCaCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClientCaCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClientCaCertificateArgs.__new__(ClientCaCertificateArgs)

            if certificate is None and not opts.urn:
                raise TypeError("Missing required property 'certificate'")
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["client_ca_cert_name"] = client_ca_cert_name
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["client_ca_cert_id"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(ClientCaCertificate, __self__).__init__(
            'alicloud:esa/clientCaCertificate:ClientCaCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            client_ca_cert_id: Optional[pulumi.Input[_builtins.str]] = None,
            client_ca_cert_name: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'ClientCaCertificate':
        """
        Get an existing ClientCaCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate: Certificate content.
        :param pulumi.Input[_builtins.str] client_ca_cert_id: ClientCaCertificate Id
        :param pulumi.Input[_builtins.str] client_ca_cert_name: The certificate name.
        :param pulumi.Input[_builtins.str] create_time: Creation time.
        :param pulumi.Input[_builtins.int] site_id: Site Id
        :param pulumi.Input[_builtins.str] status: Certificate status.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClientCaCertificateState.__new__(_ClientCaCertificateState)

        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["client_ca_cert_id"] = client_ca_cert_id
        __props__.__dict__["client_ca_cert_name"] = client_ca_cert_name
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["status"] = status
        return ClientCaCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[_builtins.str]:
        """
        Certificate content.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="clientCaCertId")
    def client_ca_cert_id(self) -> pulumi.Output[_builtins.str]:
        """
        ClientCaCertificate Id
        """
        return pulumi.get(self, "client_ca_cert_id")

    @_builtins.property
    @pulumi.getter(name="clientCaCertName")
    def client_ca_cert_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The certificate name.
        """
        return pulumi.get(self, "client_ca_cert_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Certificate status.
        """
        return pulumi.get(self, "status")

