# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ClientCertificateArgs', 'ClientCertificate']

@pulumi.input_type
class ClientCertificateArgs:
    def __init__(__self__, *,
                 site_id: pulumi.Input[_builtins.int],
                 validity_days: pulumi.Input[_builtins.str],
                 csr: Optional[pulumi.Input[_builtins.str]] = None,
                 pkey_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ClientCertificate resource.
        :param pulumi.Input[_builtins.int] site_id: Site Id
        :param pulumi.Input[_builtins.str] validity_days: Certificate validity period.
        :param pulumi.Input[_builtins.str] csr: Certificate signing request content.
        :param pulumi.Input[_builtins.str] pkey_type: The private key algorithm type.
        :param pulumi.Input[_builtins.str] status: The certificate status. Valid values: `revoked`, `active`.
        """
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "validity_days", validity_days)
        if csr is not None:
            pulumi.set(__self__, "csr", csr)
        if pkey_type is not None:
            pulumi.set(__self__, "pkey_type", pkey_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="validityDays")
    def validity_days(self) -> pulumi.Input[_builtins.str]:
        """
        Certificate validity period.
        """
        return pulumi.get(self, "validity_days")

    @validity_days.setter
    def validity_days(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "validity_days", value)

    @_builtins.property
    @pulumi.getter
    def csr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate signing request content.
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "csr", value)

    @_builtins.property
    @pulumi.getter(name="pkeyType")
    def pkey_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key algorithm type.
        """
        return pulumi.get(self, "pkey_type")

    @pkey_type.setter
    def pkey_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pkey_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate status. Valid values: `revoked`, `active`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _ClientCertificateState:
    def __init__(__self__, *,
                 client_cert_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 csr: Optional[pulumi.Input[_builtins.str]] = None,
                 pkey_type: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 validity_days: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClientCertificate resources.
        :param pulumi.Input[_builtins.str] client_cert_id: ClientCertificate Id
        :param pulumi.Input[_builtins.str] create_time: The time when the certificate was created.
        :param pulumi.Input[_builtins.str] csr: Certificate signing request content.
        :param pulumi.Input[_builtins.str] pkey_type: The private key algorithm type.
        :param pulumi.Input[_builtins.int] site_id: Site Id
        :param pulumi.Input[_builtins.str] status: The certificate status. Valid values: `revoked`, `active`.
        :param pulumi.Input[_builtins.str] validity_days: Certificate validity period.
        """
        if client_cert_id is not None:
            pulumi.set(__self__, "client_cert_id", client_cert_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if csr is not None:
            pulumi.set(__self__, "csr", csr)
        if pkey_type is not None:
            pulumi.set(__self__, "pkey_type", pkey_type)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if validity_days is not None:
            pulumi.set(__self__, "validity_days", validity_days)

    @_builtins.property
    @pulumi.getter(name="clientCertId")
    def client_cert_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ClientCertificate Id
        """
        return pulumi.get(self, "client_cert_id")

    @client_cert_id.setter
    def client_cert_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the certificate was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def csr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate signing request content.
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "csr", value)

    @_builtins.property
    @pulumi.getter(name="pkeyType")
    def pkey_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key algorithm type.
        """
        return pulumi.get(self, "pkey_type")

    @pkey_type.setter
    def pkey_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pkey_type", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate status. Valid values: `revoked`, `active`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="validityDays")
    def validity_days(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate validity period.
        """
        return pulumi.get(self, "validity_days")

    @validity_days.setter
    def validity_days(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validity_days", value)


@pulumi.type_token("alicloud:esa/clientCertificate:ClientCertificate")
class ClientCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 csr: Optional[pulumi.Input[_builtins.str]] = None,
                 pkey_type: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 validity_days: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Client Certificate resource.

        For information about ESA Client Certificate and how to use it, see [What is Client Certificate](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateClientCertificate).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan",
            site_name="gositecdn.cn")
        default_client_certificate = alicloud.esa.ClientCertificate("default",
            site_id=default.sites[0].id,
            pkey_type="RSA",
            validity_days="365")
        ```

        ## Import

        ESA Client Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/clientCertificate:ClientCertificate example <site_id>:<client_cert_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] csr: Certificate signing request content.
        :param pulumi.Input[_builtins.str] pkey_type: The private key algorithm type.
        :param pulumi.Input[_builtins.int] site_id: Site Id
        :param pulumi.Input[_builtins.str] status: The certificate status. Valid values: `revoked`, `active`.
        :param pulumi.Input[_builtins.str] validity_days: Certificate validity period.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClientCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Client Certificate resource.

        For information about ESA Client Certificate and how to use it, see [What is Client Certificate](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateClientCertificate).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan",
            site_name="gositecdn.cn")
        default_client_certificate = alicloud.esa.ClientCertificate("default",
            site_id=default.sites[0].id,
            pkey_type="RSA",
            validity_days="365")
        ```

        ## Import

        ESA Client Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/clientCertificate:ClientCertificate example <site_id>:<client_cert_id>
        ```

        :param str resource_name: The name of the resource.
        :param ClientCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClientCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 csr: Optional[pulumi.Input[_builtins.str]] = None,
                 pkey_type: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 validity_days: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClientCertificateArgs.__new__(ClientCertificateArgs)

            __props__.__dict__["csr"] = csr
            __props__.__dict__["pkey_type"] = pkey_type
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["status"] = status
            if validity_days is None and not opts.urn:
                raise TypeError("Missing required property 'validity_days'")
            __props__.__dict__["validity_days"] = validity_days
            __props__.__dict__["client_cert_id"] = None
            __props__.__dict__["create_time"] = None
        super(ClientCertificate, __self__).__init__(
            'alicloud:esa/clientCertificate:ClientCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_cert_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            csr: Optional[pulumi.Input[_builtins.str]] = None,
            pkey_type: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            validity_days: Optional[pulumi.Input[_builtins.str]] = None) -> 'ClientCertificate':
        """
        Get an existing ClientCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] client_cert_id: ClientCertificate Id
        :param pulumi.Input[_builtins.str] create_time: The time when the certificate was created.
        :param pulumi.Input[_builtins.str] csr: Certificate signing request content.
        :param pulumi.Input[_builtins.str] pkey_type: The private key algorithm type.
        :param pulumi.Input[_builtins.int] site_id: Site Id
        :param pulumi.Input[_builtins.str] status: The certificate status. Valid values: `revoked`, `active`.
        :param pulumi.Input[_builtins.str] validity_days: Certificate validity period.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClientCertificateState.__new__(_ClientCertificateState)

        __props__.__dict__["client_cert_id"] = client_cert_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["csr"] = csr
        __props__.__dict__["pkey_type"] = pkey_type
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["status"] = status
        __props__.__dict__["validity_days"] = validity_days
        return ClientCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clientCertId")
    def client_cert_id(self) -> pulumi.Output[_builtins.str]:
        """
        ClientCertificate Id
        """
        return pulumi.get(self, "client_cert_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the certificate was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def csr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Certificate signing request content.
        """
        return pulumi.get(self, "csr")

    @_builtins.property
    @pulumi.getter(name="pkeyType")
    def pkey_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The private key algorithm type.
        """
        return pulumi.get(self, "pkey_type")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate status. Valid values: `revoked`, `active`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="validityDays")
    def validity_days(self) -> pulumi.Output[_builtins.str]:
        """
        Certificate validity period.
        """
        return pulumi.get(self, "validity_days")

