# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OriginProtectionArgs', 'OriginProtection']

@pulumi.input_type
class OriginProtectionArgs:
    def __init__(__self__, *,
                 site_id: pulumi.Input[_builtins.int],
                 origin_converge: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OriginProtection resource.
        :param pulumi.Input[_builtins.int] site_id: Site Id
        :param pulumi.Input[_builtins.str] origin_converge: The IP convergence status.
               
               - on
               - off
        """
        pulumi.set(__self__, "site_id", site_id)
        if origin_converge is not None:
            pulumi.set(__self__, "origin_converge", origin_converge)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="originConverge")
    def origin_converge(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP convergence status.

        - on
        - off
        """
        return pulumi.get(self, "origin_converge")

    @origin_converge.setter
    def origin_converge(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_converge", value)


@pulumi.input_type
class _OriginProtectionState:
    def __init__(__self__, *,
                 origin_converge: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering OriginProtection resources.
        :param pulumi.Input[_builtins.str] origin_converge: The IP convergence status.
               
               - on
               - off
        :param pulumi.Input[_builtins.int] site_id: Site Id
        """
        if origin_converge is not None:
            pulumi.set(__self__, "origin_converge", origin_converge)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)

    @_builtins.property
    @pulumi.getter(name="originConverge")
    def origin_converge(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP convergence status.

        - on
        - off
        """
        return pulumi.get(self, "origin_converge")

    @origin_converge.setter
    def origin_converge(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_converge", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)


@pulumi.type_token("alicloud:esa/originProtection:OriginProtection")
class OriginProtection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 origin_converge: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a ESA Origin Protection resource.

        For information about ESA Origin Protection and how to use it, see [What is Origin Protection](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateOriginProtection).

        > **NOTE:** Available since v1.256.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name="chenxin0116.site",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_origin_protection = alicloud.esa.OriginProtection("default",
            origin_converge="on",
            site_id=default_site.id)
        ```

        ## Import

        ESA Origin Protection can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/originProtection:OriginProtection example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] origin_converge: The IP convergence status.
               
               - on
               - off
        :param pulumi.Input[_builtins.int] site_id: Site Id
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OriginProtectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Origin Protection resource.

        For information about ESA Origin Protection and how to use it, see [What is Origin Protection](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateOriginProtection).

        > **NOTE:** Available since v1.256.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name="chenxin0116.site",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_origin_protection = alicloud.esa.OriginProtection("default",
            origin_converge="on",
            site_id=default_site.id)
        ```

        ## Import

        ESA Origin Protection can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/originProtection:OriginProtection example <id>
        ```

        :param str resource_name: The name of the resource.
        :param OriginProtectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OriginProtectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 origin_converge: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OriginProtectionArgs.__new__(OriginProtectionArgs)

            __props__.__dict__["origin_converge"] = origin_converge
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
        super(OriginProtection, __self__).__init__(
            'alicloud:esa/originProtection:OriginProtection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            origin_converge: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'OriginProtection':
        """
        Get an existing OriginProtection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] origin_converge: The IP convergence status.
               
               - on
               - off
        :param pulumi.Input[_builtins.int] site_id: Site Id
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OriginProtectionState.__new__(_OriginProtectionState)

        __props__.__dict__["origin_converge"] = origin_converge
        __props__.__dict__["site_id"] = site_id
        return OriginProtection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="originConverge")
    def origin_converge(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IP convergence status.

        - on
        - off
        """
        return pulumi.get(self, "origin_converge")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

