# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ScheduledPreloadJobArgs', 'ScheduledPreloadJob']

@pulumi.input_type
class ScheduledPreloadJobArgs:
    def __init__(__self__, *,
                 insert_way: pulumi.Input[_builtins.str],
                 scheduled_preload_job_name: pulumi.Input[_builtins.str],
                 site_id: pulumi.Input[_builtins.int],
                 oss_url: Optional[pulumi.Input[_builtins.str]] = None,
                 url_list: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ScheduledPreloadJob resource.
        :param pulumi.Input[_builtins.str] insert_way: The method to submit the URLs to be prefetched.
        :param pulumi.Input[_builtins.str] scheduled_preload_job_name: The task name.
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.str] oss_url: Preheat OSS files regularly and fill in the OSS file address. Note: The OSS file contains the URL that you need to warm up.
        :param pulumi.Input[_builtins.str] url_list: A list of URLs to be preheated, which is used when uploading a preheated file in the text box mode.
        """
        pulumi.set(__self__, "insert_way", insert_way)
        pulumi.set(__self__, "scheduled_preload_job_name", scheduled_preload_job_name)
        pulumi.set(__self__, "site_id", site_id)
        if oss_url is not None:
            pulumi.set(__self__, "oss_url", oss_url)
        if url_list is not None:
            pulumi.set(__self__, "url_list", url_list)

    @_builtins.property
    @pulumi.getter(name="insertWay")
    def insert_way(self) -> pulumi.Input[_builtins.str]:
        """
        The method to submit the URLs to be prefetched.
        """
        return pulumi.get(self, "insert_way")

    @insert_way.setter
    def insert_way(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "insert_way", value)

    @_builtins.property
    @pulumi.getter(name="scheduledPreloadJobName")
    def scheduled_preload_job_name(self) -> pulumi.Input[_builtins.str]:
        """
        The task name.
        """
        return pulumi.get(self, "scheduled_preload_job_name")

    @scheduled_preload_job_name.setter
    def scheduled_preload_job_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scheduled_preload_job_name", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="ossUrl")
    def oss_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Preheat OSS files regularly and fill in the OSS file address. Note: The OSS file contains the URL that you need to warm up.
        """
        return pulumi.get(self, "oss_url")

    @oss_url.setter
    def oss_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_url", value)

    @_builtins.property
    @pulumi.getter(name="urlList")
    def url_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A list of URLs to be preheated, which is used when uploading a preheated file in the text box mode.
        """
        return pulumi.get(self, "url_list")

    @url_list.setter
    def url_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url_list", value)


@pulumi.input_type
class _ScheduledPreloadJobState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 insert_way: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_url: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_preload_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_preload_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 url_list: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ScheduledPreloadJob resources.
        :param pulumi.Input[_builtins.str] create_time: The time when the task was created.
        :param pulumi.Input[_builtins.str] insert_way: The method to submit the URLs to be prefetched.
        :param pulumi.Input[_builtins.str] oss_url: Preheat OSS files regularly and fill in the OSS file address. Note: The OSS file contains the URL that you need to warm up.
        :param pulumi.Input[_builtins.str] scheduled_preload_job_id: The ID of the prefetch task.
        :param pulumi.Input[_builtins.str] scheduled_preload_job_name: The task name.
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.str] url_list: A list of URLs to be preheated, which is used when uploading a preheated file in the text box mode.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if insert_way is not None:
            pulumi.set(__self__, "insert_way", insert_way)
        if oss_url is not None:
            pulumi.set(__self__, "oss_url", oss_url)
        if scheduled_preload_job_id is not None:
            pulumi.set(__self__, "scheduled_preload_job_id", scheduled_preload_job_id)
        if scheduled_preload_job_name is not None:
            pulumi.set(__self__, "scheduled_preload_job_name", scheduled_preload_job_name)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if url_list is not None:
            pulumi.set(__self__, "url_list", url_list)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the task was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="insertWay")
    def insert_way(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method to submit the URLs to be prefetched.
        """
        return pulumi.get(self, "insert_way")

    @insert_way.setter
    def insert_way(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "insert_way", value)

    @_builtins.property
    @pulumi.getter(name="ossUrl")
    def oss_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Preheat OSS files regularly and fill in the OSS file address. Note: The OSS file contains the URL that you need to warm up.
        """
        return pulumi.get(self, "oss_url")

    @oss_url.setter
    def oss_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_url", value)

    @_builtins.property
    @pulumi.getter(name="scheduledPreloadJobId")
    def scheduled_preload_job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the prefetch task.
        """
        return pulumi.get(self, "scheduled_preload_job_id")

    @scheduled_preload_job_id.setter
    def scheduled_preload_job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_preload_job_id", value)

    @_builtins.property
    @pulumi.getter(name="scheduledPreloadJobName")
    def scheduled_preload_job_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The task name.
        """
        return pulumi.get(self, "scheduled_preload_job_name")

    @scheduled_preload_job_name.setter
    def scheduled_preload_job_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_preload_job_name", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="urlList")
    def url_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A list of URLs to be preheated, which is used when uploading a preheated file in the text box mode.
        """
        return pulumi.get(self, "url_list")

    @url_list.setter
    def url_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url_list", value)


@pulumi.type_token("alicloud:esa/scheduledPreloadJob:ScheduledPreloadJob")
class ScheduledPreloadJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 insert_way: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_url: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_preload_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 url_list: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Scheduled Preload Job resource.

        For information about ESA Scheduled Preload Job and how to use it, see [What is Scheduled Preload Job](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateScheduledPreloadJob).

        > **NOTE:** Available since v1.248.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name="terraform.cn",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_scheduled_preload_job = alicloud.esa.ScheduledPreloadJob("default",
            insert_way="textBox",
            site_id=default_site.id,
            scheduled_preload_job_name="example_scheduledpreloadexecution_job",
            url_list="http://example.gositecdn.cn/example/example.txt")
        ```

        ## Import

        ESA Scheduled Preload Job can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/scheduledPreloadJob:ScheduledPreloadJob example <site_id>:<scheduled_preload_job_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] insert_way: The method to submit the URLs to be prefetched.
        :param pulumi.Input[_builtins.str] oss_url: Preheat OSS files regularly and fill in the OSS file address. Note: The OSS file contains the URL that you need to warm up.
        :param pulumi.Input[_builtins.str] scheduled_preload_job_name: The task name.
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.str] url_list: A list of URLs to be preheated, which is used when uploading a preheated file in the text box mode.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduledPreloadJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Scheduled Preload Job resource.

        For information about ESA Scheduled Preload Job and how to use it, see [What is Scheduled Preload Job](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateScheduledPreloadJob).

        > **NOTE:** Available since v1.248.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name="terraform.cn",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_scheduled_preload_job = alicloud.esa.ScheduledPreloadJob("default",
            insert_way="textBox",
            site_id=default_site.id,
            scheduled_preload_job_name="example_scheduledpreloadexecution_job",
            url_list="http://example.gositecdn.cn/example/example.txt")
        ```

        ## Import

        ESA Scheduled Preload Job can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/scheduledPreloadJob:ScheduledPreloadJob example <site_id>:<scheduled_preload_job_id>
        ```

        :param str resource_name: The name of the resource.
        :param ScheduledPreloadJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduledPreloadJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 insert_way: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_url: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_preload_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 url_list: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduledPreloadJobArgs.__new__(ScheduledPreloadJobArgs)

            if insert_way is None and not opts.urn:
                raise TypeError("Missing required property 'insert_way'")
            __props__.__dict__["insert_way"] = insert_way
            __props__.__dict__["oss_url"] = oss_url
            if scheduled_preload_job_name is None and not opts.urn:
                raise TypeError("Missing required property 'scheduled_preload_job_name'")
            __props__.__dict__["scheduled_preload_job_name"] = scheduled_preload_job_name
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["url_list"] = url_list
            __props__.__dict__["create_time"] = None
            __props__.__dict__["scheduled_preload_job_id"] = None
        super(ScheduledPreloadJob, __self__).__init__(
            'alicloud:esa/scheduledPreloadJob:ScheduledPreloadJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            insert_way: Optional[pulumi.Input[_builtins.str]] = None,
            oss_url: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_preload_job_id: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_preload_job_name: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            url_list: Optional[pulumi.Input[_builtins.str]] = None) -> 'ScheduledPreloadJob':
        """
        Get an existing ScheduledPreloadJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The time when the task was created.
        :param pulumi.Input[_builtins.str] insert_way: The method to submit the URLs to be prefetched.
        :param pulumi.Input[_builtins.str] oss_url: Preheat OSS files regularly and fill in the OSS file address. Note: The OSS file contains the URL that you need to warm up.
        :param pulumi.Input[_builtins.str] scheduled_preload_job_id: The ID of the prefetch task.
        :param pulumi.Input[_builtins.str] scheduled_preload_job_name: The task name.
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.str] url_list: A list of URLs to be preheated, which is used when uploading a preheated file in the text box mode.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScheduledPreloadJobState.__new__(_ScheduledPreloadJobState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["insert_way"] = insert_way
        __props__.__dict__["oss_url"] = oss_url
        __props__.__dict__["scheduled_preload_job_id"] = scheduled_preload_job_id
        __props__.__dict__["scheduled_preload_job_name"] = scheduled_preload_job_name
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["url_list"] = url_list
        return ScheduledPreloadJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the task was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="insertWay")
    def insert_way(self) -> pulumi.Output[_builtins.str]:
        """
        The method to submit the URLs to be prefetched.
        """
        return pulumi.get(self, "insert_way")

    @_builtins.property
    @pulumi.getter(name="ossUrl")
    def oss_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Preheat OSS files regularly and fill in the OSS file address. Note: The OSS file contains the URL that you need to warm up.
        """
        return pulumi.get(self, "oss_url")

    @_builtins.property
    @pulumi.getter(name="scheduledPreloadJobId")
    def scheduled_preload_job_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the prefetch task.
        """
        return pulumi.get(self, "scheduled_preload_job_id")

    @_builtins.property
    @pulumi.getter(name="scheduledPreloadJobName")
    def scheduled_preload_job_name(self) -> pulumi.Output[_builtins.str]:
        """
        The task name.
        """
        return pulumi.get(self, "scheduled_preload_job_name")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The site ID.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="urlList")
    def url_list(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A list of URLs to be preheated, which is used when uploading a preheated file in the text box mode.
        """
        return pulumi.get(self, "url_list")

