# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WaitingRoomRuleArgs', 'WaitingRoomRule']

@pulumi.input_type
class WaitingRoomRuleArgs:
    def __init__(__self__, *,
                 rule: pulumi.Input[_builtins.str],
                 rule_name: pulumi.Input[_builtins.str],
                 site_id: pulumi.Input[_builtins.int],
                 status: pulumi.Input[_builtins.str],
                 waiting_room_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a WaitingRoomRule resource.
        :param pulumi.Input[_builtins.str] rule: The content of the rule, the implemented policy or conditional expression.
        :param pulumi.Input[_builtins.str] rule_name: Rule name, optional, used to query by waiting room bypass rule name.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.str] status: Rule enabled status, supporting:
               -'on': means enabled.
               -'off': means disabled.
        :param pulumi.Input[_builtins.str] waiting_room_id: Waiting room ID, used to identify a specific waiting room. It can be obtained by calling the [listwaitingroom](https://help.aliyun.com/document_detail/2850279.html) interface.
        """
        pulumi.set(__self__, "rule", rule)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "waiting_room_id", waiting_room_id)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> pulumi.Input[_builtins.str]:
        """
        The content of the rule, the implemented policy or conditional expression.
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[_builtins.str]:
        """
        Rule name, optional, used to query by waiting room bypass rule name.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The site ID, which can be obtained by calling the ListSites API.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Input[_builtins.str]:
        """
        Rule enabled status, supporting:
        -'on': means enabled.
        -'off': means disabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="waitingRoomId")
    def waiting_room_id(self) -> pulumi.Input[_builtins.str]:
        """
        Waiting room ID, used to identify a specific waiting room. It can be obtained by calling the [listwaitingroom](https://help.aliyun.com/document_detail/2850279.html) interface.
        """
        return pulumi.get(self, "waiting_room_id")

    @waiting_room_id.setter
    def waiting_room_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "waiting_room_id", value)


@pulumi.input_type
class _WaitingRoomRuleState:
    def __init__(__self__, *,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 waiting_room_id: Optional[pulumi.Input[_builtins.str]] = None,
                 waiting_room_rule_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering WaitingRoomRule resources.
        :param pulumi.Input[_builtins.str] rule: The content of the rule, the implemented policy or conditional expression.
        :param pulumi.Input[_builtins.str] rule_name: Rule name, optional, used to query by waiting room bypass rule name.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.str] status: Rule enabled status, supporting:
               -'on': means enabled.
               -'off': means disabled.
        :param pulumi.Input[_builtins.str] waiting_room_id: Waiting room ID, used to identify a specific waiting room. It can be obtained by calling the [listwaitingroom](https://help.aliyun.com/document_detail/2850279.html) interface.
        :param pulumi.Input[_builtins.int] waiting_room_rule_id: The rule ID, which can be used to query a specific rule.
        """
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if waiting_room_id is not None:
            pulumi.set(__self__, "waiting_room_id", waiting_room_id)
        if waiting_room_rule_id is not None:
            pulumi.set(__self__, "waiting_room_rule_id", waiting_room_rule_id)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the rule, the implemented policy or conditional expression.
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule name, optional, used to query by waiting room bypass rule name.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The site ID, which can be obtained by calling the ListSites API.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule enabled status, supporting:
        -'on': means enabled.
        -'off': means disabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="waitingRoomId")
    def waiting_room_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Waiting room ID, used to identify a specific waiting room. It can be obtained by calling the [listwaitingroom](https://help.aliyun.com/document_detail/2850279.html) interface.
        """
        return pulumi.get(self, "waiting_room_id")

    @waiting_room_id.setter
    def waiting_room_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "waiting_room_id", value)

    @_builtins.property
    @pulumi.getter(name="waitingRoomRuleId")
    def waiting_room_rule_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The rule ID, which can be used to query a specific rule.
        """
        return pulumi.get(self, "waiting_room_rule_id")

    @waiting_room_rule_id.setter
    def waiting_room_rule_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "waiting_room_rule_id", value)


@pulumi.type_token("alicloud:esa/waitingRoomRule:WaitingRoomRule")
class WaitingRoomRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 waiting_room_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Waiting Room Rule resource.

        For information about ESA Waiting Room Rule and how to use it, see [What is Waiting Room Rule](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateWaitingRoomRule).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name="terraform.site",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_waiting_room = alicloud.esa.WaitingRoom("default",
            status="off",
            site_id=default_site.id,
            json_response_enable="off",
            description="example",
            waiting_room_type="default",
            disable_session_renewal_enable="off",
            cookie_name="__aliwaitingroom_example",
            waiting_room_name="waitingroom_example",
            queue_all_enable="off",
            queuing_status_code="200",
            custom_page_html="",
            new_users_per_minute="200",
            session_duration="5",
            language="zhcn",
            total_active_users="300",
            queuing_method="fifo",
            host_name_and_paths=[{
                "domain": "sub_domain.com",
                "path": "/example",
                "subdomain": "example_sub_domain.com.",
            }])
        default_waiting_room_rule = alicloud.esa.WaitingRoomRule("default",
            rule="(http.host eq \\"video.example.com\\")",
            waiting_room_id=default_waiting_room.waiting_room_id,
            rule_name="WaitingRoomRule_example1",
            status="off",
            site_id=default_site.id)
        ```

        ## Import

        ESA Waiting Room Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/waitingRoomRule:WaitingRoomRule example <site_id>:<waiting_room_id>:<waiting_room_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] rule: The content of the rule, the implemented policy or conditional expression.
        :param pulumi.Input[_builtins.str] rule_name: Rule name, optional, used to query by waiting room bypass rule name.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.str] status: Rule enabled status, supporting:
               -'on': means enabled.
               -'off': means disabled.
        :param pulumi.Input[_builtins.str] waiting_room_id: Waiting room ID, used to identify a specific waiting room. It can be obtained by calling the [listwaitingroom](https://help.aliyun.com/document_detail/2850279.html) interface.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WaitingRoomRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Waiting Room Rule resource.

        For information about ESA Waiting Room Rule and how to use it, see [What is Waiting Room Rule](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateWaitingRoomRule).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_site = alicloud.esa.Site("default",
            site_name="terraform.site",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_waiting_room = alicloud.esa.WaitingRoom("default",
            status="off",
            site_id=default_site.id,
            json_response_enable="off",
            description="example",
            waiting_room_type="default",
            disable_session_renewal_enable="off",
            cookie_name="__aliwaitingroom_example",
            waiting_room_name="waitingroom_example",
            queue_all_enable="off",
            queuing_status_code="200",
            custom_page_html="",
            new_users_per_minute="200",
            session_duration="5",
            language="zhcn",
            total_active_users="300",
            queuing_method="fifo",
            host_name_and_paths=[{
                "domain": "sub_domain.com",
                "path": "/example",
                "subdomain": "example_sub_domain.com.",
            }])
        default_waiting_room_rule = alicloud.esa.WaitingRoomRule("default",
            rule="(http.host eq \\"video.example.com\\")",
            waiting_room_id=default_waiting_room.waiting_room_id,
            rule_name="WaitingRoomRule_example1",
            status="off",
            site_id=default_site.id)
        ```

        ## Import

        ESA Waiting Room Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/waitingRoomRule:WaitingRoomRule example <site_id>:<waiting_room_id>:<waiting_room_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param WaitingRoomRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WaitingRoomRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 waiting_room_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WaitingRoomRuleArgs.__new__(WaitingRoomRuleArgs)

            if rule is None and not opts.urn:
                raise TypeError("Missing required property 'rule'")
            __props__.__dict__["rule"] = rule
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            if waiting_room_id is None and not opts.urn:
                raise TypeError("Missing required property 'waiting_room_id'")
            __props__.__dict__["waiting_room_id"] = waiting_room_id
            __props__.__dict__["waiting_room_rule_id"] = None
        super(WaitingRoomRule, __self__).__init__(
            'alicloud:esa/waitingRoomRule:WaitingRoomRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            rule: Optional[pulumi.Input[_builtins.str]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            waiting_room_id: Optional[pulumi.Input[_builtins.str]] = None,
            waiting_room_rule_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'WaitingRoomRule':
        """
        Get an existing WaitingRoomRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] rule: The content of the rule, the implemented policy or conditional expression.
        :param pulumi.Input[_builtins.str] rule_name: Rule name, optional, used to query by waiting room bypass rule name.
        :param pulumi.Input[_builtins.int] site_id: The site ID, which can be obtained by calling the ListSites API.
        :param pulumi.Input[_builtins.str] status: Rule enabled status, supporting:
               -'on': means enabled.
               -'off': means disabled.
        :param pulumi.Input[_builtins.str] waiting_room_id: Waiting room ID, used to identify a specific waiting room. It can be obtained by calling the [listwaitingroom](https://help.aliyun.com/document_detail/2850279.html) interface.
        :param pulumi.Input[_builtins.int] waiting_room_rule_id: The rule ID, which can be used to query a specific rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WaitingRoomRuleState.__new__(_WaitingRoomRuleState)

        __props__.__dict__["rule"] = rule
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["status"] = status
        __props__.__dict__["waiting_room_id"] = waiting_room_id
        __props__.__dict__["waiting_room_rule_id"] = waiting_room_rule_id
        return WaitingRoomRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> pulumi.Output[_builtins.str]:
        """
        The content of the rule, the implemented policy or conditional expression.
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[_builtins.str]:
        """
        Rule name, optional, used to query by waiting room bypass rule name.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The site ID, which can be obtained by calling the ListSites API.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Rule enabled status, supporting:
        -'on': means enabled.
        -'off': means disabled.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="waitingRoomId")
    def waiting_room_id(self) -> pulumi.Output[_builtins.str]:
        """
        Waiting room ID, used to identify a specific waiting room. It can be obtained by calling the [listwaitingroom](https://help.aliyun.com/document_detail/2850279.html) interface.
        """
        return pulumi.get(self, "waiting_room_id")

    @_builtins.property
    @pulumi.getter(name="waitingRoomRuleId")
    def waiting_room_rule_id(self) -> pulumi.Output[_builtins.int]:
        """
        The rule ID, which can be used to query a specific rule.
        """
        return pulumi.get(self, "waiting_room_rule_id")

