# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAlarmsResult',
    'AwaitableGetAlarmsResult',
    'get_alarms',
    'get_alarms_output',
]

@pulumi.output_type
class GetAlarmsResult:
    """
    A collection of values returned by getAlarms.
    """
    def __init__(__self__, alarms=None, id=None, ids=None, metric_type=None, name_regex=None, names=None, output_file=None, scaling_group_id=None):
        if alarms and not isinstance(alarms, list):
            raise TypeError("Expected argument 'alarms' to be a list")
        pulumi.set(__self__, "alarms", alarms)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if metric_type and not isinstance(metric_type, str):
            raise TypeError("Expected argument 'metric_type' to be a str")
        pulumi.set(__self__, "metric_type", metric_type)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if scaling_group_id and not isinstance(scaling_group_id, str):
            raise TypeError("Expected argument 'scaling_group_id' to be a str")
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)

    @_builtins.property
    @pulumi.getter
    def alarms(self) -> Sequence['outputs.GetAlarmsAlarmResult']:
        """
        A list of alarms. Each element contains the following attributes:
        """
        return pulumi.get(self, "alarms")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of alarm ids.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional[_builtins.str]:
        """
        The type for the alarm's associated metric.
        """
        return pulumi.get(self, "metric_type")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of alarm names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[_builtins.str]:
        """
        The scaling group associated with this alarm.
        """
        return pulumi.get(self, "scaling_group_id")


class AwaitableGetAlarmsResult(GetAlarmsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlarmsResult(
            alarms=self.alarms,
            id=self.id,
            ids=self.ids,
            metric_type=self.metric_type,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            scaling_group_id=self.scaling_group_id)


def get_alarms(ids: Optional[Sequence[_builtins.str]] = None,
               metric_type: Optional[_builtins.str] = None,
               name_regex: Optional[_builtins.str] = None,
               output_file: Optional[_builtins.str] = None,
               scaling_group_id: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlarmsResult:
    """
    This data source provides available alarm resources.

    > **NOTE** Available in 1.72.0+


    :param Sequence[_builtins.str] ids: A list of alarm IDs.
    :param _builtins.str metric_type: The type for the alarm's associated metric. Supported value: system, custom. "system" means the metric data is collected by Aliyun Cloud Monitor Service(CMS), "custom" means the metric data is upload to CMS by users. Defaults to system.
    :param _builtins.str name_regex: A regex string to filter resulting alarms by name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str scaling_group_id: Scaling group id the alarms belong to.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['metricType'] = metric_type
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['scalingGroupId'] = scaling_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ess/getAlarms:getAlarms', __args__, opts=opts, typ=GetAlarmsResult).value

    return AwaitableGetAlarmsResult(
        alarms=pulumi.get(__ret__, 'alarms'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        metric_type=pulumi.get(__ret__, 'metric_type'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        scaling_group_id=pulumi.get(__ret__, 'scaling_group_id'))
def get_alarms_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      metric_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      scaling_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlarmsResult]:
    """
    This data source provides available alarm resources.

    > **NOTE** Available in 1.72.0+


    :param Sequence[_builtins.str] ids: A list of alarm IDs.
    :param _builtins.str metric_type: The type for the alarm's associated metric. Supported value: system, custom. "system" means the metric data is collected by Aliyun Cloud Monitor Service(CMS), "custom" means the metric data is upload to CMS by users. Defaults to system.
    :param _builtins.str name_regex: A regex string to filter resulting alarms by name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str scaling_group_id: Scaling group id the alarms belong to.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['metricType'] = metric_type
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['scalingGroupId'] = scaling_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ess/getAlarms:getAlarms', __args__, opts=opts, typ=GetAlarmsResult)
    return __ret__.apply(lambda __response__: GetAlarmsResult(
        alarms=pulumi.get(__response__, 'alarms'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        metric_type=pulumi.get(__response__, 'metric_type'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        scaling_group_id=pulumi.get(__response__, 'scaling_group_id')))
