# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetScalingGroupsResult',
    'AwaitableGetScalingGroupsResult',
    'get_scaling_groups',
    'get_scaling_groups_output',
]

@pulumi.output_type
class GetScalingGroupsResult:
    """
    A collection of values returned by getScalingGroups.
    """
    def __init__(__self__, groups=None, id=None, ids=None, name_regex=None, names=None, output_file=None):
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetScalingGroupsGroupResult']:
        """
        A list of scaling groups. Each element contains the following attributes:
        """
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of scaling group ids.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of scaling group names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetScalingGroupsResult(GetScalingGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScalingGroupsResult(
            groups=self.groups,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file)


def get_scaling_groups(ids: Optional[Sequence[_builtins.str]] = None,
                       name_regex: Optional[_builtins.str] = None,
                       output_file: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScalingGroupsResult:
    """
    This data source provides available scaling group resources.

    > **NOTE:** Available since v1.39.0

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default_integer = random.index.Integer("default",
        min=10000,
        max=99999)
    my_name = f"{name}-{default_integer['result']}"
    default = alicloud.get_zones(available_disk_category="cloud_efficiency",
        available_resource_creation="VSwitch")
    default_network = alicloud.vpc.Network("default",
        vpc_name=my_name,
        cidr_block="172.16.0.0/16")
    default_switch = alicloud.vpc.Switch("default",
        vpc_id=default_network.id,
        cidr_block="172.16.0.0/24",
        zone_id=default.zones[0].id,
        vswitch_name=my_name)
    default_scaling_group = alicloud.ess.ScalingGroup("default",
        min_size=1,
        max_size=1,
        scaling_group_name=my_name,
        removal_policies=[
            "OldestInstance",
            "NewestInstance",
        ],
        vswitch_ids=[default_switch.id])
    scalinggroups_ds = alicloud.ess.get_scaling_groups_output(ids=[default_scaling_group.id],
        name_regex=my_name)
    pulumi.export("firstScalingGroup", scalinggroups_ds.groups[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of scaling group IDs.
    :param _builtins.str name_regex: A regex string to filter resulting scaling groups by name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ess/getScalingGroups:getScalingGroups', __args__, opts=opts, typ=GetScalingGroupsResult).value

    return AwaitableGetScalingGroupsResult(
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_scaling_groups_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                              name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScalingGroupsResult]:
    """
    This data source provides available scaling group resources.

    > **NOTE:** Available since v1.39.0

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default_integer = random.index.Integer("default",
        min=10000,
        max=99999)
    my_name = f"{name}-{default_integer['result']}"
    default = alicloud.get_zones(available_disk_category="cloud_efficiency",
        available_resource_creation="VSwitch")
    default_network = alicloud.vpc.Network("default",
        vpc_name=my_name,
        cidr_block="172.16.0.0/16")
    default_switch = alicloud.vpc.Switch("default",
        vpc_id=default_network.id,
        cidr_block="172.16.0.0/24",
        zone_id=default.zones[0].id,
        vswitch_name=my_name)
    default_scaling_group = alicloud.ess.ScalingGroup("default",
        min_size=1,
        max_size=1,
        scaling_group_name=my_name,
        removal_policies=[
            "OldestInstance",
            "NewestInstance",
        ],
        vswitch_ids=[default_switch.id])
    scalinggroups_ds = alicloud.ess.get_scaling_groups_output(ids=[default_scaling_group.id],
        name_regex=my_name)
    pulumi.export("firstScalingGroup", scalinggroups_ds.groups[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of scaling group IDs.
    :param _builtins.str name_regex: A regex string to filter resulting scaling groups by name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ess/getScalingGroups:getScalingGroups', __args__, opts=opts, typ=GetScalingGroupsResult)
    return __ret__.apply(lambda __response__: GetScalingGroupsResult(
        groups=pulumi.get(__response__, 'groups'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file')))
