# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LifecycleHookArgs', 'LifecycleHook']

@pulumi.input_type
class LifecycleHookArgs:
    def __init__(__self__, *,
                 lifecycle_transition: pulumi.Input[_builtins.str],
                 scaling_group_id: pulumi.Input[_builtins.str],
                 default_result: Optional[pulumi.Input[_builtins.str]] = None,
                 heartbeat_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_metadata: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LifecycleHook resource.
        :param pulumi.Input[_builtins.str] lifecycle_transition: Type of Scaling activity attached to lifecycle hook. Supported value: SCALE_OUT, SCALE_IN.
        :param pulumi.Input[_builtins.str] scaling_group_id: The ID of the Auto Scaling group to which you want to assign the lifecycle hook.
        :param pulumi.Input[_builtins.str] default_result: Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses. Applicable value: CONTINUE, ABANDON, ROLLBACK, default value: CONTINUE.
        :param pulumi.Input[_builtins.int] heartbeat_timeout: Defines the amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action defined in the default_result parameter. Default value: 600.
        :param pulumi.Input[_builtins.str] name: The name of the lifecycle hook, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is lifecycle hook id.
        :param pulumi.Input[_builtins.str] notification_arn: The Arn of notification target.
        :param pulumi.Input[_builtins.str] notification_metadata: Additional information that you want to include when Auto Scaling sends a message to the notification target.
        """
        pulumi.set(__self__, "lifecycle_transition", lifecycle_transition)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if default_result is not None:
            pulumi.set(__self__, "default_result", default_result)
        if heartbeat_timeout is not None:
            pulumi.set(__self__, "heartbeat_timeout", heartbeat_timeout)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_arn is not None:
            pulumi.set(__self__, "notification_arn", notification_arn)
        if notification_metadata is not None:
            pulumi.set(__self__, "notification_metadata", notification_metadata)

    @_builtins.property
    @pulumi.getter(name="lifecycleTransition")
    def lifecycle_transition(self) -> pulumi.Input[_builtins.str]:
        """
        Type of Scaling activity attached to lifecycle hook. Supported value: SCALE_OUT, SCALE_IN.
        """
        return pulumi.get(self, "lifecycle_transition")

    @lifecycle_transition.setter
    def lifecycle_transition(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "lifecycle_transition", value)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Auto Scaling group to which you want to assign the lifecycle hook.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scaling_group_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultResult")
    def default_result(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses. Applicable value: CONTINUE, ABANDON, ROLLBACK, default value: CONTINUE.
        """
        return pulumi.get(self, "default_result")

    @default_result.setter
    def default_result(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_result", value)

    @_builtins.property
    @pulumi.getter(name="heartbeatTimeout")
    def heartbeat_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Defines the amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action defined in the default_result parameter. Default value: 600.
        """
        return pulumi.get(self, "heartbeat_timeout")

    @heartbeat_timeout.setter
    def heartbeat_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "heartbeat_timeout", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the lifecycle hook, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is lifecycle hook id.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationArn")
    def notification_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Arn of notification target.
        """
        return pulumi.get(self, "notification_arn")

    @notification_arn.setter
    def notification_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_arn", value)

    @_builtins.property
    @pulumi.getter(name="notificationMetadata")
    def notification_metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information that you want to include when Auto Scaling sends a message to the notification target.
        """
        return pulumi.get(self, "notification_metadata")

    @notification_metadata.setter
    def notification_metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_metadata", value)


@pulumi.input_type
class _LifecycleHookState:
    def __init__(__self__, *,
                 default_result: Optional[pulumi.Input[_builtins.str]] = None,
                 heartbeat_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 lifecycle_transition: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LifecycleHook resources.
        :param pulumi.Input[_builtins.str] default_result: Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses. Applicable value: CONTINUE, ABANDON, ROLLBACK, default value: CONTINUE.
        :param pulumi.Input[_builtins.int] heartbeat_timeout: Defines the amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action defined in the default_result parameter. Default value: 600.
        :param pulumi.Input[_builtins.str] lifecycle_transition: Type of Scaling activity attached to lifecycle hook. Supported value: SCALE_OUT, SCALE_IN.
        :param pulumi.Input[_builtins.str] name: The name of the lifecycle hook, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is lifecycle hook id.
        :param pulumi.Input[_builtins.str] notification_arn: The Arn of notification target.
        :param pulumi.Input[_builtins.str] notification_metadata: Additional information that you want to include when Auto Scaling sends a message to the notification target.
        :param pulumi.Input[_builtins.str] scaling_group_id: The ID of the Auto Scaling group to which you want to assign the lifecycle hook.
        """
        if default_result is not None:
            pulumi.set(__self__, "default_result", default_result)
        if heartbeat_timeout is not None:
            pulumi.set(__self__, "heartbeat_timeout", heartbeat_timeout)
        if lifecycle_transition is not None:
            pulumi.set(__self__, "lifecycle_transition", lifecycle_transition)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_arn is not None:
            pulumi.set(__self__, "notification_arn", notification_arn)
        if notification_metadata is not None:
            pulumi.set(__self__, "notification_metadata", notification_metadata)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)

    @_builtins.property
    @pulumi.getter(name="defaultResult")
    def default_result(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses. Applicable value: CONTINUE, ABANDON, ROLLBACK, default value: CONTINUE.
        """
        return pulumi.get(self, "default_result")

    @default_result.setter
    def default_result(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_result", value)

    @_builtins.property
    @pulumi.getter(name="heartbeatTimeout")
    def heartbeat_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Defines the amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action defined in the default_result parameter. Default value: 600.
        """
        return pulumi.get(self, "heartbeat_timeout")

    @heartbeat_timeout.setter
    def heartbeat_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "heartbeat_timeout", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleTransition")
    def lifecycle_transition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of Scaling activity attached to lifecycle hook. Supported value: SCALE_OUT, SCALE_IN.
        """
        return pulumi.get(self, "lifecycle_transition")

    @lifecycle_transition.setter
    def lifecycle_transition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_transition", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the lifecycle hook, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is lifecycle hook id.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationArn")
    def notification_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Arn of notification target.
        """
        return pulumi.get(self, "notification_arn")

    @notification_arn.setter
    def notification_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_arn", value)

    @_builtins.property
    @pulumi.getter(name="notificationMetadata")
    def notification_metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information that you want to include when Auto Scaling sends a message to the notification target.
        """
        return pulumi.get(self, "notification_metadata")

    @notification_metadata.setter
    def notification_metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_metadata", value)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Auto Scaling group to which you want to assign the lifecycle hook.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_group_id", value)


@pulumi.type_token("alicloud:ess/lifecycleHook:LifecycleHook")
class LifecycleHook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_result: Optional[pulumi.Input[_builtins.str]] = None,
                 heartbeat_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 lifecycle_transition: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESS lifecycle hook resource. More about Ess lifecycle hook, see [LifecycleHook](https://www.alibabacloud.com/help/doc-detail/73839.htm).

        > **NOTE:** Available since v1.13.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        my_name = f"{name}-{default_integer['result']}"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name=my_name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=my_name)
        default2 = alicloud.vpc.Switch("default2",
            vpc_id=default_network.id,
            cidr_block="172.16.1.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=f"{name}-bar")
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=my_name,
            vpc_id=default_network.id)
        default_scaling_group = alicloud.ess.ScalingGroup("default",
            min_size=1,
            max_size=1,
            scaling_group_name=my_name,
            default_cooldown=200,
            removal_policies=[
                "OldestInstance",
                "NewestInstance",
            ],
            vswitch_ids=[
                default_switch.id,
                default2.id,
            ])
        default_lifecycle_hook = alicloud.ess.LifecycleHook("default",
            scaling_group_id=default_scaling_group.id,
            name=my_name,
            lifecycle_transition="SCALE_OUT",
            heartbeat_timeout=400,
            notification_metadata="example")
        ```

        ## Module Support

        You can use to the existing autoscaling module
        to create a lifecycle hook, scaling group and configuration one-click.

        ## Import

        Ess lifecycle hook can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ess/lifecycleHook:LifecycleHook example ash-l12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_result: Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses. Applicable value: CONTINUE, ABANDON, ROLLBACK, default value: CONTINUE.
        :param pulumi.Input[_builtins.int] heartbeat_timeout: Defines the amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action defined in the default_result parameter. Default value: 600.
        :param pulumi.Input[_builtins.str] lifecycle_transition: Type of Scaling activity attached to lifecycle hook. Supported value: SCALE_OUT, SCALE_IN.
        :param pulumi.Input[_builtins.str] name: The name of the lifecycle hook, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is lifecycle hook id.
        :param pulumi.Input[_builtins.str] notification_arn: The Arn of notification target.
        :param pulumi.Input[_builtins.str] notification_metadata: Additional information that you want to include when Auto Scaling sends a message to the notification target.
        :param pulumi.Input[_builtins.str] scaling_group_id: The ID of the Auto Scaling group to which you want to assign the lifecycle hook.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LifecycleHookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESS lifecycle hook resource. More about Ess lifecycle hook, see [LifecycleHook](https://www.alibabacloud.com/help/doc-detail/73839.htm).

        > **NOTE:** Available since v1.13.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        my_name = f"{name}-{default_integer['result']}"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name=my_name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=my_name)
        default2 = alicloud.vpc.Switch("default2",
            vpc_id=default_network.id,
            cidr_block="172.16.1.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=f"{name}-bar")
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=my_name,
            vpc_id=default_network.id)
        default_scaling_group = alicloud.ess.ScalingGroup("default",
            min_size=1,
            max_size=1,
            scaling_group_name=my_name,
            default_cooldown=200,
            removal_policies=[
                "OldestInstance",
                "NewestInstance",
            ],
            vswitch_ids=[
                default_switch.id,
                default2.id,
            ])
        default_lifecycle_hook = alicloud.ess.LifecycleHook("default",
            scaling_group_id=default_scaling_group.id,
            name=my_name,
            lifecycle_transition="SCALE_OUT",
            heartbeat_timeout=400,
            notification_metadata="example")
        ```

        ## Module Support

        You can use to the existing autoscaling module
        to create a lifecycle hook, scaling group and configuration one-click.

        ## Import

        Ess lifecycle hook can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ess/lifecycleHook:LifecycleHook example ash-l12345
        ```

        :param str resource_name: The name of the resource.
        :param LifecycleHookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LifecycleHookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_result: Optional[pulumi.Input[_builtins.str]] = None,
                 heartbeat_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 lifecycle_transition: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LifecycleHookArgs.__new__(LifecycleHookArgs)

            __props__.__dict__["default_result"] = default_result
            __props__.__dict__["heartbeat_timeout"] = heartbeat_timeout
            if lifecycle_transition is None and not opts.urn:
                raise TypeError("Missing required property 'lifecycle_transition'")
            __props__.__dict__["lifecycle_transition"] = lifecycle_transition
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_arn"] = notification_arn
            __props__.__dict__["notification_metadata"] = notification_metadata
            if scaling_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_id'")
            __props__.__dict__["scaling_group_id"] = scaling_group_id
        super(LifecycleHook, __self__).__init__(
            'alicloud:ess/lifecycleHook:LifecycleHook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_result: Optional[pulumi.Input[_builtins.str]] = None,
            heartbeat_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            lifecycle_transition: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notification_arn: Optional[pulumi.Input[_builtins.str]] = None,
            notification_metadata: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LifecycleHook':
        """
        Get an existing LifecycleHook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_result: Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses. Applicable value: CONTINUE, ABANDON, ROLLBACK, default value: CONTINUE.
        :param pulumi.Input[_builtins.int] heartbeat_timeout: Defines the amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action defined in the default_result parameter. Default value: 600.
        :param pulumi.Input[_builtins.str] lifecycle_transition: Type of Scaling activity attached to lifecycle hook. Supported value: SCALE_OUT, SCALE_IN.
        :param pulumi.Input[_builtins.str] name: The name of the lifecycle hook, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is lifecycle hook id.
        :param pulumi.Input[_builtins.str] notification_arn: The Arn of notification target.
        :param pulumi.Input[_builtins.str] notification_metadata: Additional information that you want to include when Auto Scaling sends a message to the notification target.
        :param pulumi.Input[_builtins.str] scaling_group_id: The ID of the Auto Scaling group to which you want to assign the lifecycle hook.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LifecycleHookState.__new__(_LifecycleHookState)

        __props__.__dict__["default_result"] = default_result
        __props__.__dict__["heartbeat_timeout"] = heartbeat_timeout
        __props__.__dict__["lifecycle_transition"] = lifecycle_transition
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_arn"] = notification_arn
        __props__.__dict__["notification_metadata"] = notification_metadata
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        return LifecycleHook(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultResult")
    def default_result(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses. Applicable value: CONTINUE, ABANDON, ROLLBACK, default value: CONTINUE.
        """
        return pulumi.get(self, "default_result")

    @_builtins.property
    @pulumi.getter(name="heartbeatTimeout")
    def heartbeat_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Defines the amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action defined in the default_result parameter. Default value: 600.
        """
        return pulumi.get(self, "heartbeat_timeout")

    @_builtins.property
    @pulumi.getter(name="lifecycleTransition")
    def lifecycle_transition(self) -> pulumi.Output[_builtins.str]:
        """
        Type of Scaling activity attached to lifecycle hook. Supported value: SCALE_OUT, SCALE_IN.
        """
        return pulumi.get(self, "lifecycle_transition")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the lifecycle hook, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is lifecycle hook id.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationArn")
    def notification_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Arn of notification target.
        """
        return pulumi.get(self, "notification_arn")

    @_builtins.property
    @pulumi.getter(name="notificationMetadata")
    def notification_metadata(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information that you want to include when Auto Scaling sends a message to the notification target.
        """
        return pulumi.get(self, "notification_metadata")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Auto Scaling group to which you want to assign the lifecycle hook.
        """
        return pulumi.get(self, "scaling_group_id")

