# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EcFailoverTestJobArgs', 'EcFailoverTestJob']

@pulumi.input_type
class EcFailoverTestJobArgs:
    def __init__(__self__, *,
                 job_duration: pulumi.Input[_builtins.int],
                 job_type: pulumi.Input[_builtins.str],
                 resource_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 resource_type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ec_failover_test_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EcFailoverTestJob resource.
        :param pulumi.Input[_builtins.int] job_duration: Job duration.
        :param pulumi.Input[_builtins.str] job_type: Job type.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_ids: Resource id list.
        :param pulumi.Input[_builtins.str] resource_type: Resource type.
        :param pulumi.Input[_builtins.str] description: Job description.
        :param pulumi.Input[_builtins.str] ec_failover_test_job_name: Job name.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        """
        pulumi.set(__self__, "job_duration", job_duration)
        pulumi.set(__self__, "job_type", job_type)
        pulumi.set(__self__, "resource_ids", resource_ids)
        pulumi.set(__self__, "resource_type", resource_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ec_failover_test_job_name is not None:
            pulumi.set(__self__, "ec_failover_test_job_name", ec_failover_test_job_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="jobDuration")
    def job_duration(self) -> pulumi.Input[_builtins.int]:
        """
        Job duration.
        """
        return pulumi.get(self, "job_duration")

    @job_duration.setter
    def job_duration(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "job_duration", value)

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Input[_builtins.str]:
        """
        Job type.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "job_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceIds")
    def resource_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Resource id list.
        """
        return pulumi.get(self, "resource_ids")

    @resource_ids.setter
    def resource_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "resource_ids", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[_builtins.str]:
        """
        Resource type.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ecFailoverTestJobName")
    def ec_failover_test_job_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job name.
        """
        return pulumi.get(self, "ec_failover_test_job_name")

    @ec_failover_test_job_name.setter
    def ec_failover_test_job_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ec_failover_test_job_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _EcFailoverTestJobState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ec_failover_test_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EcFailoverTestJob resources.
        :param pulumi.Input[_builtins.str] description: Job description.
        :param pulumi.Input[_builtins.str] ec_failover_test_job_name: Job name.
        :param pulumi.Input[_builtins.int] job_duration: Job duration.
        :param pulumi.Input[_builtins.str] job_type: Job type.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_ids: Resource id list.
        :param pulumi.Input[_builtins.str] resource_type: Resource type.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ec_failover_test_job_name is not None:
            pulumi.set(__self__, "ec_failover_test_job_name", ec_failover_test_job_name)
        if job_duration is not None:
            pulumi.set(__self__, "job_duration", job_duration)
        if job_type is not None:
            pulumi.set(__self__, "job_type", job_type)
        if resource_ids is not None:
            pulumi.set(__self__, "resource_ids", resource_ids)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ecFailoverTestJobName")
    def ec_failover_test_job_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job name.
        """
        return pulumi.get(self, "ec_failover_test_job_name")

    @ec_failover_test_job_name.setter
    def ec_failover_test_job_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ec_failover_test_job_name", value)

    @_builtins.property
    @pulumi.getter(name="jobDuration")
    def job_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Job duration.
        """
        return pulumi.get(self, "job_duration")

    @job_duration.setter
    def job_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "job_duration", value)

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job type.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceIds")
    def resource_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Resource id list.
        """
        return pulumi.get(self, "resource_ids")

    @resource_ids.setter
    def resource_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_ids", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource type.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:expressconnect/ecFailoverTestJob:EcFailoverTestJob")
class EcFailoverTestJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ec_failover_test_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Express Connect Ec Failover Test Job resource. Express Connect Failover Test Job.

        For information about Express Connect Ec Failover Test Job and how to use it, see [What is Ec Failover Test Job](https://www.alibabacloud.com/help/zh/express-connect/developer-reference/api-vpc-2016-04-28-createfailovertestjob-efficiency-channels).

        > **NOTE:** Available since v1.215.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.expressconnect.get_physical_connections(name_regex="preserved-NODELETING")
        default_ec_failover_test_job = alicloud.expressconnect.EcFailoverTestJob("default",
            description=name,
            job_type="StartNow",
            resource_ids=[
                default.ids[0],
                default.ids[1],
            ],
            job_duration=1,
            resource_type="PHYSICALCONNECTION",
            ec_failover_test_job_name=name)
        ```

        ## Import

        Express Connect Ec Failover Test Job can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/ecFailoverTestJob:EcFailoverTestJob example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Job description.
        :param pulumi.Input[_builtins.str] ec_failover_test_job_name: Job name.
        :param pulumi.Input[_builtins.int] job_duration: Job duration.
        :param pulumi.Input[_builtins.str] job_type: Job type.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_ids: Resource id list.
        :param pulumi.Input[_builtins.str] resource_type: Resource type.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EcFailoverTestJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Express Connect Ec Failover Test Job resource. Express Connect Failover Test Job.

        For information about Express Connect Ec Failover Test Job and how to use it, see [What is Ec Failover Test Job](https://www.alibabacloud.com/help/zh/express-connect/developer-reference/api-vpc-2016-04-28-createfailovertestjob-efficiency-channels).

        > **NOTE:** Available since v1.215.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.expressconnect.get_physical_connections(name_regex="preserved-NODELETING")
        default_ec_failover_test_job = alicloud.expressconnect.EcFailoverTestJob("default",
            description=name,
            job_type="StartNow",
            resource_ids=[
                default.ids[0],
                default.ids[1],
            ],
            job_duration=1,
            resource_type="PHYSICALCONNECTION",
            ec_failover_test_job_name=name)
        ```

        ## Import

        Express Connect Ec Failover Test Job can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/ecFailoverTestJob:EcFailoverTestJob example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EcFailoverTestJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EcFailoverTestJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ec_failover_test_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 job_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EcFailoverTestJobArgs.__new__(EcFailoverTestJobArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["ec_failover_test_job_name"] = ec_failover_test_job_name
            if job_duration is None and not opts.urn:
                raise TypeError("Missing required property 'job_duration'")
            __props__.__dict__["job_duration"] = job_duration
            if job_type is None and not opts.urn:
                raise TypeError("Missing required property 'job_type'")
            __props__.__dict__["job_type"] = job_type
            if resource_ids is None and not opts.urn:
                raise TypeError("Missing required property 'resource_ids'")
            __props__.__dict__["resource_ids"] = resource_ids
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["status"] = status
        super(EcFailoverTestJob, __self__).__init__(
            'alicloud:expressconnect/ecFailoverTestJob:EcFailoverTestJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ec_failover_test_job_name: Optional[pulumi.Input[_builtins.str]] = None,
            job_duration: Optional[pulumi.Input[_builtins.int]] = None,
            job_type: Optional[pulumi.Input[_builtins.str]] = None,
            resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'EcFailoverTestJob':
        """
        Get an existing EcFailoverTestJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Job description.
        :param pulumi.Input[_builtins.str] ec_failover_test_job_name: Job name.
        :param pulumi.Input[_builtins.int] job_duration: Job duration.
        :param pulumi.Input[_builtins.str] job_type: Job type.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_ids: Resource id list.
        :param pulumi.Input[_builtins.str] resource_type: Resource type.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EcFailoverTestJobState.__new__(_EcFailoverTestJobState)

        __props__.__dict__["description"] = description
        __props__.__dict__["ec_failover_test_job_name"] = ec_failover_test_job_name
        __props__.__dict__["job_duration"] = job_duration
        __props__.__dict__["job_type"] = job_type
        __props__.__dict__["resource_ids"] = resource_ids
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["status"] = status
        return EcFailoverTestJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Job description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ecFailoverTestJobName")
    def ec_failover_test_job_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Job name.
        """
        return pulumi.get(self, "ec_failover_test_job_name")

    @_builtins.property
    @pulumi.getter(name="jobDuration")
    def job_duration(self) -> pulumi.Output[_builtins.int]:
        """
        Job duration.
        """
        return pulumi.get(self, "job_duration")

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Output[_builtins.str]:
        """
        Job type.
        """
        return pulumi.get(self, "job_type")

    @_builtins.property
    @pulumi.getter(name="resourceIds")
    def resource_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Resource id list.
        """
        return pulumi.get(self, "resource_ids")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        Resource type.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

