# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetV3TriggersResult',
    'AwaitableGetV3TriggersResult',
    'get_v3_triggers',
    'get_v3_triggers_output',
]

@pulumi.output_type
class GetV3TriggersResult:
    """
    A collection of values returned by getV3Triggers.
    """
    def __init__(__self__, function_name=None, id=None, ids=None, name_regex=None, names=None, output_file=None, triggers=None):
        if function_name and not isinstance(function_name, str):
            raise TypeError("Expected argument 'function_name' to be a str")
        pulumi.set(__self__, "function_name", function_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if triggers and not isinstance(triggers, list):
            raise TypeError("Expected argument 'triggers' to be a list")
        pulumi.set(__self__, "triggers", triggers)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> _builtins.str:
        return pulumi.get(self, "function_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Trigger IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of name of Triggers.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> Sequence['outputs.GetV3TriggersTriggerResult']:
        """
        A list of Trigger Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "triggers")


class AwaitableGetV3TriggersResult(GetV3TriggersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetV3TriggersResult(
            function_name=self.function_name,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            triggers=self.triggers)


def get_v3_triggers(function_name: Optional[_builtins.str] = None,
                    ids: Optional[Sequence[_builtins.str]] = None,
                    name_regex: Optional[_builtins.str] = None,
                    output_file: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetV3TriggersResult:
    """
    This data source provides Fcv3 Trigger available to the user.[What is Trigger](https://next.api.alibabacloud.com/document/FC/2023-03-30/CreateTrigger)

    > **NOTE:** Available since v1.250.0.

    ## Example Usage

    ```python
    import pulumi
    import json
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-exampleTriggerResourceAPI"
    function_name = config.get("functionName")
    if function_name is None:
        function_name = "terraform-exampleTriggerResourceAPI"
    trigger_name = config.get("triggerName")
    if trigger_name is None:
        trigger_name = "exampleTrigger_HTTP"
    function = alicloud.fc.V3Function("function",
        memory_size=512,
        cpu=0.5,
        handler="index.Handler",
        code={
            "zip_file": "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
        },
        function_name=name,
        runtime="python3.9",
        disk_size=512,
        log_config={
            "log_begin_rule": "None",
        })
    default_v3_trigger = alicloud.fc.V3Trigger("default",
        function_name=function.function_name,
        trigger_type="http",
        trigger_name="tf-exampleacceu-central-1fcv3trigger28547",
        description="create",
        qualifier="LATEST",
        trigger_config=json.dumps({
            "authType": "anonymous",
            "methods": [
                "GET",
                "POST",
            ],
        }))
    default = alicloud.fc.get_v3_triggers_output(ids=[default_v3_trigger.id],
        name_regex=default_v3_trigger.trigger_name,
        function_name=function_name)
    pulumi.export("alicloudFcv3TriggerExampleId", default.triggers[0].id)
    ```


    :param _builtins.str function_name: Function Name
    :param Sequence[_builtins.str] ids: A list of Trigger IDs. The value is formulated as `<function_name>:<trigger_name>`.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['functionName'] = function_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:fc/getV3Triggers:getV3Triggers', __args__, opts=opts, typ=GetV3TriggersResult).value

    return AwaitableGetV3TriggersResult(
        function_name=pulumi.get(__ret__, 'function_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        triggers=pulumi.get(__ret__, 'triggers'))
def get_v3_triggers_output(function_name: Optional[pulumi.Input[_builtins.str]] = None,
                           ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                           name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetV3TriggersResult]:
    """
    This data source provides Fcv3 Trigger available to the user.[What is Trigger](https://next.api.alibabacloud.com/document/FC/2023-03-30/CreateTrigger)

    > **NOTE:** Available since v1.250.0.

    ## Example Usage

    ```python
    import pulumi
    import json
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-exampleTriggerResourceAPI"
    function_name = config.get("functionName")
    if function_name is None:
        function_name = "terraform-exampleTriggerResourceAPI"
    trigger_name = config.get("triggerName")
    if trigger_name is None:
        trigger_name = "exampleTrigger_HTTP"
    function = alicloud.fc.V3Function("function",
        memory_size=512,
        cpu=0.5,
        handler="index.Handler",
        code={
            "zip_file": "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
        },
        function_name=name,
        runtime="python3.9",
        disk_size=512,
        log_config={
            "log_begin_rule": "None",
        })
    default_v3_trigger = alicloud.fc.V3Trigger("default",
        function_name=function.function_name,
        trigger_type="http",
        trigger_name="tf-exampleacceu-central-1fcv3trigger28547",
        description="create",
        qualifier="LATEST",
        trigger_config=json.dumps({
            "authType": "anonymous",
            "methods": [
                "GET",
                "POST",
            ],
        }))
    default = alicloud.fc.get_v3_triggers_output(ids=[default_v3_trigger.id],
        name_regex=default_v3_trigger.trigger_name,
        function_name=function_name)
    pulumi.export("alicloudFcv3TriggerExampleId", default.triggers[0].id)
    ```


    :param _builtins.str function_name: Function Name
    :param Sequence[_builtins.str] ids: A list of Trigger IDs. The value is formulated as `<function_name>:<trigger_name>`.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['functionName'] = function_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:fc/getV3Triggers:getV3Triggers', __args__, opts=opts, typ=GetV3TriggersResult)
    return __ret__.apply(lambda __response__: GetV3TriggersResult(
        function_name=pulumi.get(__response__, 'function_name'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        triggers=pulumi.get(__response__, 'triggers')))
