# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TriggerArgs', 'Trigger']

@pulumi.input_type
class TriggerArgs:
    def __init__(__self__, *,
                 function: pulumi.Input[_builtins.str],
                 service: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 config_mns: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 source_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Trigger resource.
        :param pulumi.Input[_builtins.str] function: The Function Compute function name.
        :param pulumi.Input[_builtins.str] service: The Function Compute service name.
        :param pulumi.Input[_builtins.str] type: The Type of the trigger. Valid values: ["oss", "log", "timer", "http", "mns_topic", "cdn_events", "eventbridge"].
               
               > **NOTE:** Config does not support modification when type is mns_topic.
               > **NOTE:** type = cdn_events, available in 1.47.0+.
               > **NOTE:** type = eventbridge, available in 1.173.0+.
        :param pulumi.Input[_builtins.str] config: The config of Function Compute trigger.It is valid when `type` is not "mns_topic".See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
        :param pulumi.Input[_builtins.str] config_mns: The config of Function Compute trigger when the type is "mns_topic".It is conflict with `config`.
        :param pulumi.Input[_builtins.str] name: The Function Compute trigger name. It is the only in one service and is conflict with "name_prefix".
        :param pulumi.Input[_builtins.str] name_prefix: Setting a prefix to get a only trigger name. It is conflict with "name".
        :param pulumi.Input[_builtins.str] role: RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        :param pulumi.Input[_builtins.str] source_arn: Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        """
        pulumi.set(__self__, "function", function)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "type", type)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if config_mns is not None:
            pulumi.set(__self__, "config_mns", config_mns)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)

    @_builtins.property
    @pulumi.getter
    def function(self) -> pulumi.Input[_builtins.str]:
        """
        The Function Compute function name.
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Input[_builtins.str]:
        """
        The Function Compute service name.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The Type of the trigger. Valid values: ["oss", "log", "timer", "http", "mns_topic", "cdn_events", "eventbridge"].

        > **NOTE:** Config does not support modification when type is mns_topic.
        > **NOTE:** type = cdn_events, available in 1.47.0+.
        > **NOTE:** type = eventbridge, available in 1.173.0+.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The config of Function Compute trigger.It is valid when `type` is not "mns_topic".See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="configMns")
    def config_mns(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The config of Function Compute trigger when the type is "mns_topic".It is conflict with `config`.
        """
        return pulumi.get(self, "config_mns")

    @config_mns.setter
    def config_mns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_mns", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Function Compute trigger name. It is the only in one service and is conflict with "name_prefix".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Setting a prefix to get a only trigger name. It is conflict with "name".
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_arn", value)


@pulumi.input_type
class _TriggerState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 config_mns: Optional[pulumi.Input[_builtins.str]] = None,
                 function: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 source_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Trigger resources.
        :param pulumi.Input[_builtins.str] config: The config of Function Compute trigger.It is valid when `type` is not "mns_topic".See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
        :param pulumi.Input[_builtins.str] config_mns: The config of Function Compute trigger when the type is "mns_topic".It is conflict with `config`.
        :param pulumi.Input[_builtins.str] function: The Function Compute function name.
        :param pulumi.Input[_builtins.str] last_modified: The date this resource was last modified.
        :param pulumi.Input[_builtins.str] name: The Function Compute trigger name. It is the only in one service and is conflict with "name_prefix".
        :param pulumi.Input[_builtins.str] name_prefix: Setting a prefix to get a only trigger name. It is conflict with "name".
        :param pulumi.Input[_builtins.str] role: RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        :param pulumi.Input[_builtins.str] service: The Function Compute service name.
        :param pulumi.Input[_builtins.str] source_arn: Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        :param pulumi.Input[_builtins.str] trigger_id: The Function Compute trigger ID.
        :param pulumi.Input[_builtins.str] type: The Type of the trigger. Valid values: ["oss", "log", "timer", "http", "mns_topic", "cdn_events", "eventbridge"].
               
               > **NOTE:** Config does not support modification when type is mns_topic.
               > **NOTE:** type = cdn_events, available in 1.47.0+.
               > **NOTE:** type = eventbridge, available in 1.173.0+.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if config_mns is not None:
            pulumi.set(__self__, "config_mns", config_mns)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)
        if trigger_id is not None:
            pulumi.set(__self__, "trigger_id", trigger_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The config of Function Compute trigger.It is valid when `type` is not "mns_topic".See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="configMns")
    def config_mns(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The config of Function Compute trigger when the type is "mns_topic".It is conflict with `config`.
        """
        return pulumi.get(self, "config_mns")

    @config_mns.setter
    def config_mns(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_mns", value)

    @_builtins.property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Function Compute function name.
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function", value)

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date this resource was last modified.
        """
        return pulumi.get(self, "last_modified")

    @last_modified.setter
    def last_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Function Compute trigger name. It is the only in one service and is conflict with "name_prefix".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Setting a prefix to get a only trigger name. It is conflict with "name".
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Function Compute service name.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_arn", value)

    @_builtins.property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Function Compute trigger ID.
        """
        return pulumi.get(self, "trigger_id")

    @trigger_id.setter
    def trigger_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trigger_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Type of the trigger. Valid values: ["oss", "log", "timer", "http", "mns_topic", "cdn_events", "eventbridge"].

        > **NOTE:** Config does not support modification when type is mns_topic.
        > **NOTE:** type = cdn_events, available in 1.47.0+.
        > **NOTE:** type = eventbridge, available in 1.173.0+.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("alicloud:fc/trigger:Trigger")
class Trigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 config_mns: Optional[pulumi.Input[_builtins.str]] = None,
                 function: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 source_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an Alicloud Function Compute Trigger resource. Based on trigger, execute your code in response to events in Alibaba Cloud.
         For information about Service and how to use it, see [What is Function Compute](https://www.alibabacloud.com/help/en/fc/developer-reference/api-fc-open-2021-04-06-createtrigger).

        > **NOTE:** The resource requires a provider field 'account_id'. See account_id.

        > **NOTE:** Available since v1.93.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = alicloud.get_account()
        default_get_regions = alicloud.get_regions(current=True)
        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default_project = alicloud.log.Project("default", project_name=f"example-value-{default_integer['result']}")
        default_store = alicloud.log.Store("default",
            project_name=default_project.project_name,
            logstore_name="example-value")
        source_store = alicloud.log.Store("source_store",
            project_name=default_project.project_name,
            logstore_name="example-source-store")
        default_role = alicloud.ram.Role("default",
            name=f"fcservicerole-{default_integer['result']}",
            document=\"\"\"  {
              \\"Statement\\": [
                {
                  \\"Action\\": \\"sts:AssumeRole\\",
                  \\"Effect\\": \\"Allow\\",
                  \\"Principal\\": {
                    \\"Service\\": [
                      \\"fc.aliyuncs.com\\"
                    ]
                  }
                }
              ],
              \\"Version\\": \\"1\\"
          }
        \"\"\",
            description="this is a example",
            force=True)
        default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("default",
            role_name=default_role.name,
            policy_name="AliyunLogFullAccess",
            policy_type="System")
        default_service = alicloud.fc.Service("default",
            name=f"example-value-{default_integer['result']}",
            description="example-value",
            role=default_role.arn,
            log_config={
                "project": default_project.project_name,
                "logstore": default_store.logstore_name,
                "enable_instance_metrics": True,
                "enable_request_metrics": True,
            })
        default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default_integer['result']}")
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("default",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        default_function = alicloud.fc.Function("default",
            service=default_service.name,
            name="terraform-example",
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler")
        default_trigger = alicloud.fc.Trigger("default",
            service=default_service.name,
            function=default_function.name,
            name="terraform-example",
            role=default_role.arn,
            source_arn=default_project.project_name.apply(lambda project_name: f"acs:log:{default_get_regions.regions[0].id}:{default.id}:project/{project_name}"),
            type="log",
            config=pulumi.Output.all(
                sourceStoreLogstore_name=source_store.logstore_name,
                project_name=default_project.project_name,
                defaultStoreLogstore_name=default_store.logstore_name
        ).apply(lambda resolved_outputs: f\"\"\"    {{
                \\"sourceConfig\\": {{
                    \\"logstore\\": \\"{resolved_outputs['sourceStoreLogstore_name']}\\",
                    \\"startTime\\": null
                }},
                \\"jobConfig\\": {{
                    \\"maxRetryTime\\": 3,
                    \\"triggerInterval\\": 60
                }},
                \\"functionParameter\\": {{
                    \\"a\\": \\"b\\",
                    \\"c\\": \\"d\\"
                }},
                \\"logConfig\\": {{
                     \\"project\\": \\"{resolved_outputs['project_name']}\\",
                    \\"logstore\\": \\"{resolved_outputs['defaultStoreLogstore_name']}\\"
                }},
                \\"enable\\": true
            }}
          
        \"\"\")
        )
        ```

        MNS topic trigger:

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = alicloud.get_account()
        default_get_regions = alicloud.get_regions(current=True)
        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default_topic = alicloud.mns.Topic("default", name=f"example-value-{default_integer['result']}")
        default_role = alicloud.ram.Role("default",
            name=f"fcservicerole-{default_integer['result']}",
            document=\"\"\"  {
              \\"Statement\\": [
                {
                  \\"Action\\": \\"sts:AssumeRole\\",
                  \\"Effect\\": \\"Allow\\",
                  \\"Principal\\": {
                    \\"Service\\": [
                      \\"mns.aliyuncs.com\\"
                    ]
                  }
                }
              ],
              \\"Version\\": \\"1\\"
          }
        \"\"\",
            description="this is a example",
            force=True)
        default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("default",
            role_name=default_role.name,
            policy_name="AliyunMNSNotificationRolePolicy",
            policy_type="System")
        default_service = alicloud.fc.Service("default",
            name=f"example-value-{default_integer['result']}",
            description="example-value",
            internet_access=False)
        default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default_integer['result']}")
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("default",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        default_function = alicloud.fc.Function("default",
            service=default_service.name,
            name=f"terraform-example-{default_integer['result']}",
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler")
        default_trigger = alicloud.fc.Trigger("default",
            service=default_service.name,
            function=default_function.name,
            name="terraform-example",
            role=default_role.arn,
            source_arn=default_topic.name.apply(lambda name: f"acs:mns:{default_get_regions.regions[0].id}:{default.id}:/topics/{name}"),
            type="mns_topic",
            config_mns=\"\"\"  {
            \\"filterTag\\":\\"exampleTag\\",
            \\"notifyContentFormat\\":\\"STREAM\\",
            \\"notifyStrategy\\":\\"BACKOFF_RETRY\\"
          }
        \"\"\")
        ```

        CDN events trigger:

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = alicloud.get_account()
        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default_domain_new = alicloud.cdn.DomainNew("default",
            domain_name=f"example{default_integer['result']}.tf.com",
            cdn_type="web",
            scope="overseas",
            sources=[{
                "content": "1.1.1.1",
                "type": "ipaddr",
                "priority": 20,
                "port": 80,
                "weight": 10,
            }])
        default_service = alicloud.fc.Service("default",
            name=f"example-value-{default_integer['result']}",
            description="example-value",
            internet_access=False)
        default_role = alicloud.ram.Role("default",
            name=f"fcservicerole-{default_integer['result']}",
            document=\"\"\"    {
              \\"Statement\\": [
                {
                  \\"Action\\": \\"sts:AssumeRole\\",
                  \\"Effect\\": \\"Allow\\",
                  \\"Principal\\": {
                    \\"Service\\": [
                      \\"cdn.aliyuncs.com\\"
                    ]
                  }
                }
              ],
              \\"Version\\": \\"1\\"
          }
        \"\"\",
            description="this is a example",
            force=True)
        default_policy = alicloud.ram.Policy("default",
            policy_name=f"fcservicepolicy-{default_integer['result']}",
            policy_document=pulumi.Output.all(
                defaultServiceName=default_service.name,
                defaultServiceName1=default_service.name
        ).apply(lambda resolved_outputs: f\"\"\"    {{
                \\"Version\\": \\"1\\",
                \\"Statement\\": [
                {{
                    \\"Action\\": [
                    \\"fc:InvokeFunction\\"
                    ],
                \\"Resource\\": [
                    \\"acs:fc:*:*:services/{resolved_outputs['defaultServiceName']}/functions/*\\",
                    \\"acs:fc:*:*:services/{resolved_outputs['defaultServiceName1']}.*/functions/*\\"
                ],
                \\"Effect\\": \\"Allow\\"
                }}
                ]
            }}
        \"\"\")
        ,
            description="this is a example",
            force=True)
        default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("default",
            role_name=default_role.name,
            policy_name=default_policy.policy_name,
            policy_type="Custom")
        default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default_integer['result']}")
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("default",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        default_function = alicloud.fc.Function("default",
            service=default_service.name,
            name=f"terraform-example-{default_integer['result']}",
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler")
        default_trigger = alicloud.fc.Trigger("default",
            service=default_service.name,
            function=default_function.name,
            name="terraform-example",
            role=default_role.arn,
            source_arn=f"acs:cdn:*:{default.id}",
            type="cdn_events",
            config=default_domain_new.domain_name.apply(lambda domain_name: f\"\"\"      {{\\"eventName\\":\\"LogFileCreated\\",
             \\"eventVersion\\":\\"1.0.0\\",
             \\"notes\\":\\"cdn events trigger\\",
             \\"filter\\":{{
                \\"domain\\": [\\"{domain_name}\\"]
                }}
            }}
        \"\"\"))
        ```

        EventBridge trigger:

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = alicloud.get_account()
        default_get_regions = alicloud.get_regions(current=True)
        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        service_linked_role = alicloud.eventbridge.ServiceLinkedRole("service_linked_role", product_name="AliyunServiceRoleForEventBridgeSendToFC")
        default_service = alicloud.fc.Service("default",
            name=f"example-value-{default_integer['result']}",
            description="example-value",
            internet_access=False)
        default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default_integer['result']}")
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("default",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        default_function = alicloud.fc.Function("default",
            service=default_service.name,
            name="terraform-example",
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler")
        oss_trigger = alicloud.fc.Trigger("oss_trigger",
            service=default_service.name,
            function=default_function.name,
            name="terraform-example-oss",
            type="eventbridge",
            config=json.dumps({
                "triggerEnable": False,
                "asyncInvocationType": False,
                "eventSourceConfig": {
                    "eventSourceType": "Default",
                },
                "eventRuleFilterPattern": "{\\"source\\":[\\"acs.oss\\"],\\"type\\":[\\"oss:BucketCreated:PutBucket\\"]}",
                "eventSinkConfig": {
                    "deliveryOption": {
                        "mode": "event-driven",
                        "eventSchema": "CloudEvents",
                    },
                },
                "runOptions": {
                    "retryStrategy": {
                        "PushRetryStrategy": "BACKOFF_RETRY",
                    },
                    "errorsTolerance": "ALL",
                    "mode": "event-driven",
                },
            }))
        mns_trigger = alicloud.fc.Trigger("mns_trigger",
            service=default_service.name,
            function=default_function.name,
            name="terraform-example-mns",
            type="eventbridge",
            config=json.dumps({
                "triggerEnable": False,
                "asyncInvocationType": False,
                "eventSourceConfig": {
                    "eventSourceType": "MNS",
                    "eventSourceParameters": {
                        "sourceMNSParameters": {
                            "RegionId": default_get_regions.regions[0].id,
                            "QueueName": "mns-queue",
                            "IsBase64Decode": True,
                        },
                    },
                },
                "eventRuleFilterPattern": "{}",
                "eventSinkConfig": {
                    "deliveryOption": {
                        "mode": "event-driven",
                        "eventSchema": "CloudEvents",
                    },
                },
                "runOptions": {
                    "retryStrategy": {
                        "PushRetryStrategy": "BACKOFF_RETRY",
                    },
                    "errorsTolerance": "ALL",
                    "mode": "event-driven",
                },
            }))
        default_instance = alicloud.rocketmq.Instance("default",
            instance_name=f"terraform-example-{default_integer['result']}",
            remark="terraform-example")
        default_group = alicloud.rocketmq.Group("default",
            group_name="GID-example",
            instance_id=default_instance.id,
            remark="terraform-example")
        default_topic = alicloud.rocketmq.Topic("default",
            topic_name="mytopic",
            instance_id=default_instance.id,
            message_type=0,
            remark="terraform-example")
        rocketmq_trigger = alicloud.fc.Trigger("rocketmq_trigger",
            service=default_service.name,
            function=default_function.name,
            name="terraform-example-rocketmq",
            type="eventbridge",
            config=pulumi.Output.json_dumps({
                "triggerEnable": False,
                "asyncInvocationType": False,
                "eventRuleFilterPattern": "{}",
                "eventSinkConfig": {
                    "deliveryOption": {
                        "mode": "event-driven",
                        "eventSchema": "CloudEvents",
                    },
                },
                "eventSourceConfig": {
                    "eventSourceType": "RocketMQ",
                    "eventSourceParameters": {
                        "sourceRocketMQParameters": {
                            "RegionId": default_get_regions.regions[0].id,
                            "InstanceId": default_instance.id,
                            "GroupID": default_group.group_name,
                            "Topic": default_topic.topic_name,
                            "Timestamp": 1686296162,
                            "Tag": "example-tag",
                            "Offset": "CONSUME_FROM_LAST_OFFSET",
                        },
                    },
                },
                "runOptions": {
                    "retryStrategy": {
                        "PushRetryStrategy": "BACKOFF_RETRY",
                    },
                    "errorsTolerance": "ALL",
                    "mode": "event-driven",
                },
            }))
        default_instance2 = alicloud.amqp.Instance("default",
            instance_name=f"terraform-example-{default_integer['result']}",
            instance_type="professional",
            max_tps="1000",
            queue_capacity="50",
            support_eip=True,
            max_eip_tps="128",
            payment_type="Subscription",
            period=1)
        default_virtual_host = alicloud.amqp.VirtualHost("default",
            instance_id=default_instance2.id,
            virtual_host_name="example-VirtualHost")
        default_queue = alicloud.amqp.Queue("default",
            instance_id=default_virtual_host.instance_id,
            queue_name="example-queue",
            virtual_host_name=default_virtual_host.virtual_host_name)
        rabbitmq_trigger = alicloud.fc.Trigger("rabbitmq_trigger",
            service=default_service.name,
            function=default_function.name,
            name="terraform-example-rabbitmq",
            type="eventbridge",
            config=pulumi.Output.json_dumps({
                "triggerEnable": False,
                "asyncInvocationType": False,
                "eventRuleFilterPattern": "{}",
                "eventSourceConfig": {
                    "eventSourceType": "RabbitMQ",
                    "eventSourceParameters": {
                        "sourceRabbitMQParameters": {
                            "RegionId": default_get_regions.regions[0].id,
                            "InstanceId": default_instance2.id,
                            "VirtualHostName": default_virtual_host.virtual_host_name,
                            "QueueName": default_queue.queue_name,
                        },
                    },
                },
                "eventSinkConfig": {
                    "deliveryOption": {
                        "mode": "event-driven",
                        "eventSchema": "CloudEvents",
                    },
                },
                "runOptions": {
                    "retryStrategy": {
                        "PushRetryStrategy": "BACKOFF_RETRY",
                    },
                    "errorsTolerance": "ALL",
                    "mode": "event-driven",
                },
            }))
        ```

        ## Module Support

        You can use to the existing fc module
        to create several triggers quickly.

        ## Import

        Function Compute trigger can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fc/trigger:Trigger foo my-fc-service:hello-world:hello-trigger
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] config: The config of Function Compute trigger.It is valid when `type` is not "mns_topic".See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
        :param pulumi.Input[_builtins.str] config_mns: The config of Function Compute trigger when the type is "mns_topic".It is conflict with `config`.
        :param pulumi.Input[_builtins.str] function: The Function Compute function name.
        :param pulumi.Input[_builtins.str] name: The Function Compute trigger name. It is the only in one service and is conflict with "name_prefix".
        :param pulumi.Input[_builtins.str] name_prefix: Setting a prefix to get a only trigger name. It is conflict with "name".
        :param pulumi.Input[_builtins.str] role: RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        :param pulumi.Input[_builtins.str] service: The Function Compute service name.
        :param pulumi.Input[_builtins.str] source_arn: Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        :param pulumi.Input[_builtins.str] type: The Type of the trigger. Valid values: ["oss", "log", "timer", "http", "mns_topic", "cdn_events", "eventbridge"].
               
               > **NOTE:** Config does not support modification when type is mns_topic.
               > **NOTE:** type = cdn_events, available in 1.47.0+.
               > **NOTE:** type = eventbridge, available in 1.173.0+.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TriggerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Alicloud Function Compute Trigger resource. Based on trigger, execute your code in response to events in Alibaba Cloud.
         For information about Service and how to use it, see [What is Function Compute](https://www.alibabacloud.com/help/en/fc/developer-reference/api-fc-open-2021-04-06-createtrigger).

        > **NOTE:** The resource requires a provider field 'account_id'. See account_id.

        > **NOTE:** Available since v1.93.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = alicloud.get_account()
        default_get_regions = alicloud.get_regions(current=True)
        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default_project = alicloud.log.Project("default", project_name=f"example-value-{default_integer['result']}")
        default_store = alicloud.log.Store("default",
            project_name=default_project.project_name,
            logstore_name="example-value")
        source_store = alicloud.log.Store("source_store",
            project_name=default_project.project_name,
            logstore_name="example-source-store")
        default_role = alicloud.ram.Role("default",
            name=f"fcservicerole-{default_integer['result']}",
            document=\"\"\"  {
              \\"Statement\\": [
                {
                  \\"Action\\": \\"sts:AssumeRole\\",
                  \\"Effect\\": \\"Allow\\",
                  \\"Principal\\": {
                    \\"Service\\": [
                      \\"fc.aliyuncs.com\\"
                    ]
                  }
                }
              ],
              \\"Version\\": \\"1\\"
          }
        \"\"\",
            description="this is a example",
            force=True)
        default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("default",
            role_name=default_role.name,
            policy_name="AliyunLogFullAccess",
            policy_type="System")
        default_service = alicloud.fc.Service("default",
            name=f"example-value-{default_integer['result']}",
            description="example-value",
            role=default_role.arn,
            log_config={
                "project": default_project.project_name,
                "logstore": default_store.logstore_name,
                "enable_instance_metrics": True,
                "enable_request_metrics": True,
            })
        default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default_integer['result']}")
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("default",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        default_function = alicloud.fc.Function("default",
            service=default_service.name,
            name="terraform-example",
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler")
        default_trigger = alicloud.fc.Trigger("default",
            service=default_service.name,
            function=default_function.name,
            name="terraform-example",
            role=default_role.arn,
            source_arn=default_project.project_name.apply(lambda project_name: f"acs:log:{default_get_regions.regions[0].id}:{default.id}:project/{project_name}"),
            type="log",
            config=pulumi.Output.all(
                sourceStoreLogstore_name=source_store.logstore_name,
                project_name=default_project.project_name,
                defaultStoreLogstore_name=default_store.logstore_name
        ).apply(lambda resolved_outputs: f\"\"\"    {{
                \\"sourceConfig\\": {{
                    \\"logstore\\": \\"{resolved_outputs['sourceStoreLogstore_name']}\\",
                    \\"startTime\\": null
                }},
                \\"jobConfig\\": {{
                    \\"maxRetryTime\\": 3,
                    \\"triggerInterval\\": 60
                }},
                \\"functionParameter\\": {{
                    \\"a\\": \\"b\\",
                    \\"c\\": \\"d\\"
                }},
                \\"logConfig\\": {{
                     \\"project\\": \\"{resolved_outputs['project_name']}\\",
                    \\"logstore\\": \\"{resolved_outputs['defaultStoreLogstore_name']}\\"
                }},
                \\"enable\\": true
            }}
          
        \"\"\")
        )
        ```

        MNS topic trigger:

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = alicloud.get_account()
        default_get_regions = alicloud.get_regions(current=True)
        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default_topic = alicloud.mns.Topic("default", name=f"example-value-{default_integer['result']}")
        default_role = alicloud.ram.Role("default",
            name=f"fcservicerole-{default_integer['result']}",
            document=\"\"\"  {
              \\"Statement\\": [
                {
                  \\"Action\\": \\"sts:AssumeRole\\",
                  \\"Effect\\": \\"Allow\\",
                  \\"Principal\\": {
                    \\"Service\\": [
                      \\"mns.aliyuncs.com\\"
                    ]
                  }
                }
              ],
              \\"Version\\": \\"1\\"
          }
        \"\"\",
            description="this is a example",
            force=True)
        default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("default",
            role_name=default_role.name,
            policy_name="AliyunMNSNotificationRolePolicy",
            policy_type="System")
        default_service = alicloud.fc.Service("default",
            name=f"example-value-{default_integer['result']}",
            description="example-value",
            internet_access=False)
        default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default_integer['result']}")
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("default",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        default_function = alicloud.fc.Function("default",
            service=default_service.name,
            name=f"terraform-example-{default_integer['result']}",
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler")
        default_trigger = alicloud.fc.Trigger("default",
            service=default_service.name,
            function=default_function.name,
            name="terraform-example",
            role=default_role.arn,
            source_arn=default_topic.name.apply(lambda name: f"acs:mns:{default_get_regions.regions[0].id}:{default.id}:/topics/{name}"),
            type="mns_topic",
            config_mns=\"\"\"  {
            \\"filterTag\\":\\"exampleTag\\",
            \\"notifyContentFormat\\":\\"STREAM\\",
            \\"notifyStrategy\\":\\"BACKOFF_RETRY\\"
          }
        \"\"\")
        ```

        CDN events trigger:

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = alicloud.get_account()
        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default_domain_new = alicloud.cdn.DomainNew("default",
            domain_name=f"example{default_integer['result']}.tf.com",
            cdn_type="web",
            scope="overseas",
            sources=[{
                "content": "1.1.1.1",
                "type": "ipaddr",
                "priority": 20,
                "port": 80,
                "weight": 10,
            }])
        default_service = alicloud.fc.Service("default",
            name=f"example-value-{default_integer['result']}",
            description="example-value",
            internet_access=False)
        default_role = alicloud.ram.Role("default",
            name=f"fcservicerole-{default_integer['result']}",
            document=\"\"\"    {
              \\"Statement\\": [
                {
                  \\"Action\\": \\"sts:AssumeRole\\",
                  \\"Effect\\": \\"Allow\\",
                  \\"Principal\\": {
                    \\"Service\\": [
                      \\"cdn.aliyuncs.com\\"
                    ]
                  }
                }
              ],
              \\"Version\\": \\"1\\"
          }
        \"\"\",
            description="this is a example",
            force=True)
        default_policy = alicloud.ram.Policy("default",
            policy_name=f"fcservicepolicy-{default_integer['result']}",
            policy_document=pulumi.Output.all(
                defaultServiceName=default_service.name,
                defaultServiceName1=default_service.name
        ).apply(lambda resolved_outputs: f\"\"\"    {{
                \\"Version\\": \\"1\\",
                \\"Statement\\": [
                {{
                    \\"Action\\": [
                    \\"fc:InvokeFunction\\"
                    ],
                \\"Resource\\": [
                    \\"acs:fc:*:*:services/{resolved_outputs['defaultServiceName']}/functions/*\\",
                    \\"acs:fc:*:*:services/{resolved_outputs['defaultServiceName1']}.*/functions/*\\"
                ],
                \\"Effect\\": \\"Allow\\"
                }}
                ]
            }}
        \"\"\")
        ,
            description="this is a example",
            force=True)
        default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("default",
            role_name=default_role.name,
            policy_name=default_policy.policy_name,
            policy_type="Custom")
        default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default_integer['result']}")
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("default",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        default_function = alicloud.fc.Function("default",
            service=default_service.name,
            name=f"terraform-example-{default_integer['result']}",
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler")
        default_trigger = alicloud.fc.Trigger("default",
            service=default_service.name,
            function=default_function.name,
            name="terraform-example",
            role=default_role.arn,
            source_arn=f"acs:cdn:*:{default.id}",
            type="cdn_events",
            config=default_domain_new.domain_name.apply(lambda domain_name: f\"\"\"      {{\\"eventName\\":\\"LogFileCreated\\",
             \\"eventVersion\\":\\"1.0.0\\",
             \\"notes\\":\\"cdn events trigger\\",
             \\"filter\\":{{
                \\"domain\\": [\\"{domain_name}\\"]
                }}
            }}
        \"\"\"))
        ```

        EventBridge trigger:

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = alicloud.get_account()
        default_get_regions = alicloud.get_regions(current=True)
        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        service_linked_role = alicloud.eventbridge.ServiceLinkedRole("service_linked_role", product_name="AliyunServiceRoleForEventBridgeSendToFC")
        default_service = alicloud.fc.Service("default",
            name=f"example-value-{default_integer['result']}",
            description="example-value",
            internet_access=False)
        default_bucket = alicloud.oss.Bucket("default", bucket=f"terraform-example-{default_integer['result']}")
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("default",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        default_function = alicloud.fc.Function("default",
            service=default_service.name,
            name="terraform-example",
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler")
        oss_trigger = alicloud.fc.Trigger("oss_trigger",
            service=default_service.name,
            function=default_function.name,
            name="terraform-example-oss",
            type="eventbridge",
            config=json.dumps({
                "triggerEnable": False,
                "asyncInvocationType": False,
                "eventSourceConfig": {
                    "eventSourceType": "Default",
                },
                "eventRuleFilterPattern": "{\\"source\\":[\\"acs.oss\\"],\\"type\\":[\\"oss:BucketCreated:PutBucket\\"]}",
                "eventSinkConfig": {
                    "deliveryOption": {
                        "mode": "event-driven",
                        "eventSchema": "CloudEvents",
                    },
                },
                "runOptions": {
                    "retryStrategy": {
                        "PushRetryStrategy": "BACKOFF_RETRY",
                    },
                    "errorsTolerance": "ALL",
                    "mode": "event-driven",
                },
            }))
        mns_trigger = alicloud.fc.Trigger("mns_trigger",
            service=default_service.name,
            function=default_function.name,
            name="terraform-example-mns",
            type="eventbridge",
            config=json.dumps({
                "triggerEnable": False,
                "asyncInvocationType": False,
                "eventSourceConfig": {
                    "eventSourceType": "MNS",
                    "eventSourceParameters": {
                        "sourceMNSParameters": {
                            "RegionId": default_get_regions.regions[0].id,
                            "QueueName": "mns-queue",
                            "IsBase64Decode": True,
                        },
                    },
                },
                "eventRuleFilterPattern": "{}",
                "eventSinkConfig": {
                    "deliveryOption": {
                        "mode": "event-driven",
                        "eventSchema": "CloudEvents",
                    },
                },
                "runOptions": {
                    "retryStrategy": {
                        "PushRetryStrategy": "BACKOFF_RETRY",
                    },
                    "errorsTolerance": "ALL",
                    "mode": "event-driven",
                },
            }))
        default_instance = alicloud.rocketmq.Instance("default",
            instance_name=f"terraform-example-{default_integer['result']}",
            remark="terraform-example")
        default_group = alicloud.rocketmq.Group("default",
            group_name="GID-example",
            instance_id=default_instance.id,
            remark="terraform-example")
        default_topic = alicloud.rocketmq.Topic("default",
            topic_name="mytopic",
            instance_id=default_instance.id,
            message_type=0,
            remark="terraform-example")
        rocketmq_trigger = alicloud.fc.Trigger("rocketmq_trigger",
            service=default_service.name,
            function=default_function.name,
            name="terraform-example-rocketmq",
            type="eventbridge",
            config=pulumi.Output.json_dumps({
                "triggerEnable": False,
                "asyncInvocationType": False,
                "eventRuleFilterPattern": "{}",
                "eventSinkConfig": {
                    "deliveryOption": {
                        "mode": "event-driven",
                        "eventSchema": "CloudEvents",
                    },
                },
                "eventSourceConfig": {
                    "eventSourceType": "RocketMQ",
                    "eventSourceParameters": {
                        "sourceRocketMQParameters": {
                            "RegionId": default_get_regions.regions[0].id,
                            "InstanceId": default_instance.id,
                            "GroupID": default_group.group_name,
                            "Topic": default_topic.topic_name,
                            "Timestamp": 1686296162,
                            "Tag": "example-tag",
                            "Offset": "CONSUME_FROM_LAST_OFFSET",
                        },
                    },
                },
                "runOptions": {
                    "retryStrategy": {
                        "PushRetryStrategy": "BACKOFF_RETRY",
                    },
                    "errorsTolerance": "ALL",
                    "mode": "event-driven",
                },
            }))
        default_instance2 = alicloud.amqp.Instance("default",
            instance_name=f"terraform-example-{default_integer['result']}",
            instance_type="professional",
            max_tps="1000",
            queue_capacity="50",
            support_eip=True,
            max_eip_tps="128",
            payment_type="Subscription",
            period=1)
        default_virtual_host = alicloud.amqp.VirtualHost("default",
            instance_id=default_instance2.id,
            virtual_host_name="example-VirtualHost")
        default_queue = alicloud.amqp.Queue("default",
            instance_id=default_virtual_host.instance_id,
            queue_name="example-queue",
            virtual_host_name=default_virtual_host.virtual_host_name)
        rabbitmq_trigger = alicloud.fc.Trigger("rabbitmq_trigger",
            service=default_service.name,
            function=default_function.name,
            name="terraform-example-rabbitmq",
            type="eventbridge",
            config=pulumi.Output.json_dumps({
                "triggerEnable": False,
                "asyncInvocationType": False,
                "eventRuleFilterPattern": "{}",
                "eventSourceConfig": {
                    "eventSourceType": "RabbitMQ",
                    "eventSourceParameters": {
                        "sourceRabbitMQParameters": {
                            "RegionId": default_get_regions.regions[0].id,
                            "InstanceId": default_instance2.id,
                            "VirtualHostName": default_virtual_host.virtual_host_name,
                            "QueueName": default_queue.queue_name,
                        },
                    },
                },
                "eventSinkConfig": {
                    "deliveryOption": {
                        "mode": "event-driven",
                        "eventSchema": "CloudEvents",
                    },
                },
                "runOptions": {
                    "retryStrategy": {
                        "PushRetryStrategy": "BACKOFF_RETRY",
                    },
                    "errorsTolerance": "ALL",
                    "mode": "event-driven",
                },
            }))
        ```

        ## Module Support

        You can use to the existing fc module
        to create several triggers quickly.

        ## Import

        Function Compute trigger can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fc/trigger:Trigger foo my-fc-service:hello-world:hello-trigger
        ```

        :param str resource_name: The name of the resource.
        :param TriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[_builtins.str]] = None,
                 config_mns: Optional[pulumi.Input[_builtins.str]] = None,
                 function: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 source_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TriggerArgs.__new__(TriggerArgs)

            __props__.__dict__["config"] = config
            __props__.__dict__["config_mns"] = config_mns
            if function is None and not opts.urn:
                raise TypeError("Missing required property 'function'")
            __props__.__dict__["function"] = function
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["role"] = role
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            __props__.__dict__["source_arn"] = source_arn
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["last_modified"] = None
            __props__.__dict__["trigger_id"] = None
        super(Trigger, __self__).__init__(
            'alicloud:fc/trigger:Trigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[_builtins.str]] = None,
            config_mns: Optional[pulumi.Input[_builtins.str]] = None,
            function: Optional[pulumi.Input[_builtins.str]] = None,
            last_modified: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            service: Optional[pulumi.Input[_builtins.str]] = None,
            source_arn: Optional[pulumi.Input[_builtins.str]] = None,
            trigger_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Trigger':
        """
        Get an existing Trigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] config: The config of Function Compute trigger.It is valid when `type` is not "mns_topic".See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
        :param pulumi.Input[_builtins.str] config_mns: The config of Function Compute trigger when the type is "mns_topic".It is conflict with `config`.
        :param pulumi.Input[_builtins.str] function: The Function Compute function name.
        :param pulumi.Input[_builtins.str] last_modified: The date this resource was last modified.
        :param pulumi.Input[_builtins.str] name: The Function Compute trigger name. It is the only in one service and is conflict with "name_prefix".
        :param pulumi.Input[_builtins.str] name_prefix: Setting a prefix to get a only trigger name. It is conflict with "name".
        :param pulumi.Input[_builtins.str] role: RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        :param pulumi.Input[_builtins.str] service: The Function Compute service name.
        :param pulumi.Input[_builtins.str] source_arn: Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        :param pulumi.Input[_builtins.str] trigger_id: The Function Compute trigger ID.
        :param pulumi.Input[_builtins.str] type: The Type of the trigger. Valid values: ["oss", "log", "timer", "http", "mns_topic", "cdn_events", "eventbridge"].
               
               > **NOTE:** Config does not support modification when type is mns_topic.
               > **NOTE:** type = cdn_events, available in 1.47.0+.
               > **NOTE:** type = eventbridge, available in 1.173.0+.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TriggerState.__new__(_TriggerState)

        __props__.__dict__["config"] = config
        __props__.__dict__["config_mns"] = config_mns
        __props__.__dict__["function"] = function
        __props__.__dict__["last_modified"] = last_modified
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["role"] = role
        __props__.__dict__["service"] = service
        __props__.__dict__["source_arn"] = source_arn
        __props__.__dict__["trigger_id"] = trigger_id
        __props__.__dict__["type"] = type
        return Trigger(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The config of Function Compute trigger.It is valid when `type` is not "mns_topic".See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="configMns")
    def config_mns(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The config of Function Compute trigger when the type is "mns_topic".It is conflict with `config`.
        """
        return pulumi.get(self, "config_mns")

    @_builtins.property
    @pulumi.getter
    def function(self) -> pulumi.Output[_builtins.str]:
        """
        The Function Compute function name.
        """
        return pulumi.get(self, "function")

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[_builtins.str]:
        """
        The date this resource was last modified.
        """
        return pulumi.get(self, "last_modified")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The Function Compute trigger name. It is the only in one service and is conflict with "name_prefix".
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Setting a prefix to get a only trigger name. It is conflict with "name".
        """
        return pulumi.get(self, "name_prefix")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Output[_builtins.str]:
        """
        The Function Compute service name.
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        """
        return pulumi.get(self, "source_arn")

    @_builtins.property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Function Compute trigger ID.
        """
        return pulumi.get(self, "trigger_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The Type of the trigger. Valid values: ["oss", "log", "timer", "http", "mns_topic", "cdn_events", "eventbridge"].

        > **NOTE:** Config does not support modification when type is mns_topic.
        > **NOTE:** type = cdn_events, available in 1.47.0+.
        > **NOTE:** type = eventbridge, available in 1.173.0+.
        """
        return pulumi.get(self, "type")

