# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAclsResult',
    'AwaitableGetAclsResult',
    'get_acls',
    'get_acls_output',
]

@pulumi.output_type
class GetAclsResult:
    """
    A collection of values returned by getAcls.
    """
    def __init__(__self__, acl_name=None, acls=None, enable_details=None, id=None, ids=None, name_regex=None, names=None, output_file=None, status=None):
        if acl_name and not isinstance(acl_name, str):
            raise TypeError("Expected argument 'acl_name' to be a str")
        pulumi.set(__self__, "acl_name", acl_name)
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        pulumi.set(__self__, "acls", acls)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="aclName")
    def acl_name(self) -> Optional[_builtins.str]:
        """
        The name of the acl.
        """
        return pulumi.get(self, "acl_name")

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Sequence['outputs.GetAclsAclResult']:
        """
        A list of Ga Acls. Each element contains the following attributes:
        """
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Acl names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


class AwaitableGetAclsResult(GetAclsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAclsResult(
            acl_name=self.acl_name,
            acls=self.acls,
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            status=self.status)


def get_acls(acl_name: Optional[_builtins.str] = None,
             enable_details: Optional[_builtins.bool] = None,
             ids: Optional[Sequence[_builtins.str]] = None,
             name_regex: Optional[_builtins.str] = None,
             output_file: Optional[_builtins.str] = None,
             status: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAclsResult:
    """
    This data source provides the Ga Acls of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.150.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.ga.get_acls()
    pulumi.export("gaAclId1", ids.acls[0].id)
    name_regex = alicloud.ga.get_acls(name_regex="^my-Acl")
    pulumi.export("gaAclId2", name_regex.acls[0].id)
    ```


    :param _builtins.str acl_name: The name of the acl.
    :param _builtins.bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[_builtins.str] ids: A list of Acl IDs.
    :param _builtins.str name_regex: A regex string to filter results by Acl name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the resource. Valid values: `active`, `configuring`, `deleting`, `init`.
    """
    __args__ = dict()
    __args__['aclName'] = acl_name
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ga/getAcls:getAcls', __args__, opts=opts, typ=GetAclsResult).value

    return AwaitableGetAclsResult(
        acl_name=pulumi.get(__ret__, 'acl_name'),
        acls=pulumi.get(__ret__, 'acls'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'))
def get_acls_output(acl_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                    ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                    name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAclsResult]:
    """
    This data source provides the Ga Acls of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.150.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.ga.get_acls()
    pulumi.export("gaAclId1", ids.acls[0].id)
    name_regex = alicloud.ga.get_acls(name_regex="^my-Acl")
    pulumi.export("gaAclId2", name_regex.acls[0].id)
    ```


    :param _builtins.str acl_name: The name of the acl.
    :param _builtins.bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[_builtins.str] ids: A list of Acl IDs.
    :param _builtins.str name_regex: A regex string to filter results by Acl name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the resource. Valid values: `active`, `configuring`, `deleting`, `init`.
    """
    __args__ = dict()
    __args__['aclName'] = acl_name
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ga/getAcls:getAcls', __args__, opts=opts, typ=GetAclsResult)
    return __ret__.apply(lambda __response__: GetAclsResult(
        acl_name=pulumi.get(__response__, 'acl_name'),
        acls=pulumi.get(__response__, 'acls'),
        enable_details=pulumi.get(__response__, 'enable_details'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        status=pulumi.get(__response__, 'status')))
