# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetListenersResult',
    'AwaitableGetListenersResult',
    'get_listeners',
    'get_listeners_output',
]

@pulumi.output_type
class GetListenersResult:
    """
    A collection of values returned by getListeners.
    """
    def __init__(__self__, accelerator_id=None, id=None, ids=None, listeners=None, name_regex=None, names=None, output_file=None, status=None):
        if accelerator_id and not isinstance(accelerator_id, str):
            raise TypeError("Expected argument 'accelerator_id' to be a str")
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if listeners and not isinstance(listeners, list):
            raise TypeError("Expected argument 'listeners' to be a list")
        pulumi.set(__self__, "listeners", listeners)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> _builtins.str:
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> Sequence['outputs.GetListenersListenerResult']:
        """
        A list of Ga Listeners. Each element contains the following attributes:
        """
        return pulumi.get(self, "listeners")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Listener names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the listener.
        """
        return pulumi.get(self, "status")


class AwaitableGetListenersResult(GetListenersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListenersResult(
            accelerator_id=self.accelerator_id,
            id=self.id,
            ids=self.ids,
            listeners=self.listeners,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            status=self.status)


def get_listeners(accelerator_id: Optional[_builtins.str] = None,
                  ids: Optional[Sequence[_builtins.str]] = None,
                  name_regex: Optional[_builtins.str] = None,
                  output_file: Optional[_builtins.str] = None,
                  status: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListenersResult:
    """
    This data source provides the Global Accelerator (GA) Listeners of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.111.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.ga.get_listeners(accelerator_id="example_value",
        ids=["example_value"],
        name_regex="the_resource_name")
    pulumi.export("firstGaListenerId", example.listeners[0].id)
    ```


    :param _builtins.str accelerator_id: The accelerator id.
    :param Sequence[_builtins.str] ids: A list of Listener IDs.
    :param _builtins.str name_regex: A regex string to filter results by Listener name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the listener. Valid values: `active`, `configuring`, `creating`.
    """
    __args__ = dict()
    __args__['acceleratorId'] = accelerator_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ga/getListeners:getListeners', __args__, opts=opts, typ=GetListenersResult).value

    return AwaitableGetListenersResult(
        accelerator_id=pulumi.get(__ret__, 'accelerator_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        listeners=pulumi.get(__ret__, 'listeners'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'))
def get_listeners_output(accelerator_id: Optional[pulumi.Input[_builtins.str]] = None,
                         ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                         name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetListenersResult]:
    """
    This data source provides the Global Accelerator (GA) Listeners of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.111.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.ga.get_listeners(accelerator_id="example_value",
        ids=["example_value"],
        name_regex="the_resource_name")
    pulumi.export("firstGaListenerId", example.listeners[0].id)
    ```


    :param _builtins.str accelerator_id: The accelerator id.
    :param Sequence[_builtins.str] ids: A list of Listener IDs.
    :param _builtins.str name_regex: A regex string to filter results by Listener name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the listener. Valid values: `active`, `configuring`, `creating`.
    """
    __args__ = dict()
    __args__['acceleratorId'] = accelerator_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ga/getListeners:getListeners', __args__, opts=opts, typ=GetListenersResult)
    return __ret__.apply(lambda __response__: GetListenersResult(
        accelerator_id=pulumi.get(__response__, 'accelerator_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        listeners=pulumi.get(__response__, 'listeners'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        status=pulumi.get(__response__, 'status')))
