# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DbInstanceArgs', 'DbInstance']

@pulumi.input_type
class DbInstanceArgs:
    def __init__(__self__, *,
                 db_instance_category: pulumi.Input[_builtins.str],
                 db_instance_network_type: pulumi.Input[_builtins.str],
                 db_instance_storage_type: pulumi.Input[_builtins.str],
                 db_node_class: pulumi.Input[_builtins.str],
                 db_node_storage: pulumi.Input[_builtins.int],
                 db_version: pulumi.Input[_builtins.str],
                 payment_type: pulumi.Input[_builtins.str],
                 db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_arrays: Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceDbInstanceIpArrayArgs']]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DbInstance resource.
        :param pulumi.Input[_builtins.str] db_instance_category: The category of the db instance. Valid values: `HA`, `SINGLE`(Available in 1.173.0+).
        :param pulumi.Input[_builtins.str] db_instance_network_type: The network type of the db instance. Valid values: `vpc`.
        :param pulumi.Input[_builtins.str] db_instance_storage_type: Disk storage type. Valid values: `cloud_essd`, `cloud_ssd`. Modification is not supported.
        :param pulumi.Input[_builtins.str] db_node_class: The class of the db node. Valid values: `gdb.r.xlarge`, `gdb.r.2xlarge`, `gdb.r.4xlarge`, `gdb.r.8xlarge`, `gdb.r.16xlarge`, `gdb.r.xlarge_basic`, `gdb.r.2xlarge_basic`, `gdb.r.4xlarge_basic`, `gdb.r.8xlarge_basic`, `gdb.r.16xlarge_basic`.
        :param pulumi.Input[_builtins.int] db_node_storage: Instance storage space, which is measured in GB.
        :param pulumi.Input[_builtins.str] db_version: Kernel Version. Valid values: `1.0` or `1.0-OpenCypher`. `1.0`: represented as gremlin, `1.0-OpenCypher`: said opencypher.
        :param pulumi.Input[_builtins.str] payment_type: The paymen type of the resource. Valid values: `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] db_instance_description: According to the practical example or notes.
        :param pulumi.Input[Sequence[pulumi.Input['DbInstanceDbInstanceIpArrayArgs']]] db_instance_ip_arrays: IP ADDRESS whitelist for the instance group list. See `db_instance_ip_array` below.
        :param pulumi.Input[_builtins.str] vpc_id: ID of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of attaching vswitch to instance.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the resource.
        """
        pulumi.set(__self__, "db_instance_category", db_instance_category)
        pulumi.set(__self__, "db_instance_network_type", db_instance_network_type)
        pulumi.set(__self__, "db_instance_storage_type", db_instance_storage_type)
        pulumi.set(__self__, "db_node_class", db_node_class)
        pulumi.set(__self__, "db_node_storage", db_node_storage)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "payment_type", payment_type)
        if db_instance_description is not None:
            pulumi.set(__self__, "db_instance_description", db_instance_description)
        if db_instance_ip_arrays is not None:
            pulumi.set(__self__, "db_instance_ip_arrays", db_instance_ip_arrays)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="dbInstanceCategory")
    def db_instance_category(self) -> pulumi.Input[_builtins.str]:
        """
        The category of the db instance. Valid values: `HA`, `SINGLE`(Available in 1.173.0+).
        """
        return pulumi.get(self, "db_instance_category")

    @db_instance_category.setter
    def db_instance_category(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_category", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceNetworkType")
    def db_instance_network_type(self) -> pulumi.Input[_builtins.str]:
        """
        The network type of the db instance. Valid values: `vpc`.
        """
        return pulumi.get(self, "db_instance_network_type")

    @db_instance_network_type.setter
    def db_instance_network_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_network_type", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> pulumi.Input[_builtins.str]:
        """
        Disk storage type. Valid values: `cloud_essd`, `cloud_ssd`. Modification is not supported.
        """
        return pulumi.get(self, "db_instance_storage_type")

    @db_instance_storage_type.setter
    def db_instance_storage_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_storage_type", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeClass")
    def db_node_class(self) -> pulumi.Input[_builtins.str]:
        """
        The class of the db node. Valid values: `gdb.r.xlarge`, `gdb.r.2xlarge`, `gdb.r.4xlarge`, `gdb.r.8xlarge`, `gdb.r.16xlarge`, `gdb.r.xlarge_basic`, `gdb.r.2xlarge_basic`, `gdb.r.4xlarge_basic`, `gdb.r.8xlarge_basic`, `gdb.r.16xlarge_basic`.
        """
        return pulumi.get(self, "db_node_class")

    @db_node_class.setter
    def db_node_class(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_node_class", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeStorage")
    def db_node_storage(self) -> pulumi.Input[_builtins.int]:
        """
        Instance storage space, which is measured in GB.
        """
        return pulumi.get(self, "db_node_storage")

    @db_node_storage.setter
    def db_node_storage(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "db_node_storage", value)

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Input[_builtins.str]:
        """
        Kernel Version. Valid values: `1.0` or `1.0-OpenCypher`. `1.0`: represented as gremlin, `1.0-OpenCypher`: said opencypher.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_version", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The paymen type of the resource. Valid values: `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        According to the practical example or notes.
        """
        return pulumi.get(self, "db_instance_description")

    @db_instance_description.setter
    def db_instance_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_description", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceIpArrays")
    def db_instance_ip_arrays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceDbInstanceIpArrayArgs']]]]:
        """
        IP ADDRESS whitelist for the instance group list. See `db_instance_ip_array` below.
        """
        return pulumi.get(self, "db_instance_ip_arrays")

    @db_instance_ip_arrays.setter
    def db_instance_ip_arrays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceDbInstanceIpArrayArgs']]]]):
        pulumi.set(self, "db_instance_ip_arrays", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of attaching vswitch to instance.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID of the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _DbInstanceState:
    def __init__(__self__, *,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_category: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_arrays: Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceDbInstanceIpArrayArgs']]]] = None,
                 db_instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_node_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_node_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DbInstance resources.
        :param pulumi.Input[_builtins.str] connection_string: (Available in 1.196.0+)  The connection string of the instance.
        :param pulumi.Input[_builtins.str] db_instance_category: The category of the db instance. Valid values: `HA`, `SINGLE`(Available in 1.173.0+).
        :param pulumi.Input[_builtins.str] db_instance_description: According to the practical example or notes.
        :param pulumi.Input[Sequence[pulumi.Input['DbInstanceDbInstanceIpArrayArgs']]] db_instance_ip_arrays: IP ADDRESS whitelist for the instance group list. See `db_instance_ip_array` below.
        :param pulumi.Input[_builtins.str] db_instance_network_type: The network type of the db instance. Valid values: `vpc`.
        :param pulumi.Input[_builtins.str] db_instance_storage_type: Disk storage type. Valid values: `cloud_essd`, `cloud_ssd`. Modification is not supported.
        :param pulumi.Input[_builtins.str] db_node_class: The class of the db node. Valid values: `gdb.r.xlarge`, `gdb.r.2xlarge`, `gdb.r.4xlarge`, `gdb.r.8xlarge`, `gdb.r.16xlarge`, `gdb.r.xlarge_basic`, `gdb.r.2xlarge_basic`, `gdb.r.4xlarge_basic`, `gdb.r.8xlarge_basic`, `gdb.r.16xlarge_basic`.
        :param pulumi.Input[_builtins.int] db_node_storage: Instance storage space, which is measured in GB.
        :param pulumi.Input[_builtins.str] db_version: Kernel Version. Valid values: `1.0` or `1.0-OpenCypher`. `1.0`: represented as gremlin, `1.0-OpenCypher`: said opencypher.
        :param pulumi.Input[_builtins.str] payment_type: The paymen type of the resource. Valid values: `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] port: (Available in 1.196.0+) The connection port of the instance.
        :param pulumi.Input[_builtins.str] status: Instance status. Value range: `Creating`, `Running`, `Deleting`, `Rebooting`, `DBInstanceClassChanging`, `NetAddressCreating` and `NetAddressDeleting`.
        :param pulumi.Input[_builtins.str] vpc_id: ID of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of attaching vswitch to instance.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the resource.
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if db_instance_category is not None:
            pulumi.set(__self__, "db_instance_category", db_instance_category)
        if db_instance_description is not None:
            pulumi.set(__self__, "db_instance_description", db_instance_description)
        if db_instance_ip_arrays is not None:
            pulumi.set(__self__, "db_instance_ip_arrays", db_instance_ip_arrays)
        if db_instance_network_type is not None:
            pulumi.set(__self__, "db_instance_network_type", db_instance_network_type)
        if db_instance_storage_type is not None:
            pulumi.set(__self__, "db_instance_storage_type", db_instance_storage_type)
        if db_node_class is not None:
            pulumi.set(__self__, "db_node_class", db_node_class)
        if db_node_storage is not None:
            pulumi.set(__self__, "db_node_storage", db_node_storage)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available in 1.196.0+)  The connection string of the instance.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceCategory")
    def db_instance_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category of the db instance. Valid values: `HA`, `SINGLE`(Available in 1.173.0+).
        """
        return pulumi.get(self, "db_instance_category")

    @db_instance_category.setter
    def db_instance_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_category", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        According to the practical example or notes.
        """
        return pulumi.get(self, "db_instance_description")

    @db_instance_description.setter
    def db_instance_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_description", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceIpArrays")
    def db_instance_ip_arrays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceDbInstanceIpArrayArgs']]]]:
        """
        IP ADDRESS whitelist for the instance group list. See `db_instance_ip_array` below.
        """
        return pulumi.get(self, "db_instance_ip_arrays")

    @db_instance_ip_arrays.setter
    def db_instance_ip_arrays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceDbInstanceIpArrayArgs']]]]):
        pulumi.set(self, "db_instance_ip_arrays", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceNetworkType")
    def db_instance_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the db instance. Valid values: `vpc`.
        """
        return pulumi.get(self, "db_instance_network_type")

    @db_instance_network_type.setter
    def db_instance_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_network_type", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Disk storage type. Valid values: `cloud_essd`, `cloud_ssd`. Modification is not supported.
        """
        return pulumi.get(self, "db_instance_storage_type")

    @db_instance_storage_type.setter
    def db_instance_storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_storage_type", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeClass")
    def db_node_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The class of the db node. Valid values: `gdb.r.xlarge`, `gdb.r.2xlarge`, `gdb.r.4xlarge`, `gdb.r.8xlarge`, `gdb.r.16xlarge`, `gdb.r.xlarge_basic`, `gdb.r.2xlarge_basic`, `gdb.r.4xlarge_basic`, `gdb.r.8xlarge_basic`, `gdb.r.16xlarge_basic`.
        """
        return pulumi.get(self, "db_node_class")

    @db_node_class.setter
    def db_node_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_node_class", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeStorage")
    def db_node_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance storage space, which is measured in GB.
        """
        return pulumi.get(self, "db_node_storage")

    @db_node_storage.setter
    def db_node_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "db_node_storage", value)

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Kernel Version. Valid values: `1.0` or `1.0-OpenCypher`. `1.0`: represented as gremlin, `1.0-OpenCypher`: said opencypher.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_version", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The paymen type of the resource. Valid values: `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available in 1.196.0+) The connection port of the instance.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance status. Value range: `Creating`, `Running`, `Deleting`, `Rebooting`, `DBInstanceClassChanging`, `NetAddressCreating` and `NetAddressDeleting`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of attaching vswitch to instance.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID of the resource.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:graphdatabase/dbInstance:DbInstance")
class DbInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_instance_category: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_arrays: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceDbInstanceIpArrayArgs', 'DbInstanceDbInstanceIpArrayArgsDict']]]]] = None,
                 db_instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_node_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_node_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Graph Database Db Instance resource.

        For information about Graph Database Db Instance and how to use it, see [What is Db Instance](https://www.alibabacloud.com/help/en/graph-compute/latest/placeholder).

        > **NOTE:** Available since v1.136.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example = alicloud.graphdatabase.DbInstance("example",
            db_node_class="gdb.r.2xlarge",
            db_instance_network_type="vpc",
            db_version="1.0",
            db_instance_category="HA",
            db_instance_storage_type="cloud_ssd",
            db_node_storage=50,
            payment_type="PayAsYouGo",
            db_instance_description=name)
        ```

        ## Import

        Graph Database Db Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:graphdatabase/dbInstance:DbInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] db_instance_category: The category of the db instance. Valid values: `HA`, `SINGLE`(Available in 1.173.0+).
        :param pulumi.Input[_builtins.str] db_instance_description: According to the practical example or notes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceDbInstanceIpArrayArgs', 'DbInstanceDbInstanceIpArrayArgsDict']]]] db_instance_ip_arrays: IP ADDRESS whitelist for the instance group list. See `db_instance_ip_array` below.
        :param pulumi.Input[_builtins.str] db_instance_network_type: The network type of the db instance. Valid values: `vpc`.
        :param pulumi.Input[_builtins.str] db_instance_storage_type: Disk storage type. Valid values: `cloud_essd`, `cloud_ssd`. Modification is not supported.
        :param pulumi.Input[_builtins.str] db_node_class: The class of the db node. Valid values: `gdb.r.xlarge`, `gdb.r.2xlarge`, `gdb.r.4xlarge`, `gdb.r.8xlarge`, `gdb.r.16xlarge`, `gdb.r.xlarge_basic`, `gdb.r.2xlarge_basic`, `gdb.r.4xlarge_basic`, `gdb.r.8xlarge_basic`, `gdb.r.16xlarge_basic`.
        :param pulumi.Input[_builtins.int] db_node_storage: Instance storage space, which is measured in GB.
        :param pulumi.Input[_builtins.str] db_version: Kernel Version. Valid values: `1.0` or `1.0-OpenCypher`. `1.0`: represented as gremlin, `1.0-OpenCypher`: said opencypher.
        :param pulumi.Input[_builtins.str] payment_type: The paymen type of the resource. Valid values: `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] vpc_id: ID of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of attaching vswitch to instance.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Graph Database Db Instance resource.

        For information about Graph Database Db Instance and how to use it, see [What is Db Instance](https://www.alibabacloud.com/help/en/graph-compute/latest/placeholder).

        > **NOTE:** Available since v1.136.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example = alicloud.graphdatabase.DbInstance("example",
            db_node_class="gdb.r.2xlarge",
            db_instance_network_type="vpc",
            db_version="1.0",
            db_instance_category="HA",
            db_instance_storage_type="cloud_ssd",
            db_node_storage=50,
            payment_type="PayAsYouGo",
            db_instance_description=name)
        ```

        ## Import

        Graph Database Db Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:graphdatabase/dbInstance:DbInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DbInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_instance_category: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_arrays: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceDbInstanceIpArrayArgs', 'DbInstanceDbInstanceIpArrayArgsDict']]]]] = None,
                 db_instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_node_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_node_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbInstanceArgs.__new__(DbInstanceArgs)

            if db_instance_category is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_category'")
            __props__.__dict__["db_instance_category"] = db_instance_category
            __props__.__dict__["db_instance_description"] = db_instance_description
            __props__.__dict__["db_instance_ip_arrays"] = db_instance_ip_arrays
            if db_instance_network_type is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_network_type'")
            __props__.__dict__["db_instance_network_type"] = db_instance_network_type
            if db_instance_storage_type is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_storage_type'")
            __props__.__dict__["db_instance_storage_type"] = db_instance_storage_type
            if db_node_class is None and not opts.urn:
                raise TypeError("Missing required property 'db_node_class'")
            __props__.__dict__["db_node_class"] = db_node_class
            if db_node_storage is None and not opts.urn:
                raise TypeError("Missing required property 'db_node_storage'")
            __props__.__dict__["db_node_storage"] = db_node_storage
            if db_version is None and not opts.urn:
                raise TypeError("Missing required property 'db_version'")
            __props__.__dict__["db_version"] = db_version
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["status"] = None
        super(DbInstance, __self__).__init__(
            'alicloud:graphdatabase/dbInstance:DbInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_category: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_ip_arrays: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceDbInstanceIpArrayArgs', 'DbInstanceDbInstanceIpArrayArgsDict']]]]] = None,
            db_instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_node_class: Optional[pulumi.Input[_builtins.str]] = None,
            db_node_storage: Optional[pulumi.Input[_builtins.int]] = None,
            db_version: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DbInstance':
        """
        Get an existing DbInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_string: (Available in 1.196.0+)  The connection string of the instance.
        :param pulumi.Input[_builtins.str] db_instance_category: The category of the db instance. Valid values: `HA`, `SINGLE`(Available in 1.173.0+).
        :param pulumi.Input[_builtins.str] db_instance_description: According to the practical example or notes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceDbInstanceIpArrayArgs', 'DbInstanceDbInstanceIpArrayArgsDict']]]] db_instance_ip_arrays: IP ADDRESS whitelist for the instance group list. See `db_instance_ip_array` below.
        :param pulumi.Input[_builtins.str] db_instance_network_type: The network type of the db instance. Valid values: `vpc`.
        :param pulumi.Input[_builtins.str] db_instance_storage_type: Disk storage type. Valid values: `cloud_essd`, `cloud_ssd`. Modification is not supported.
        :param pulumi.Input[_builtins.str] db_node_class: The class of the db node. Valid values: `gdb.r.xlarge`, `gdb.r.2xlarge`, `gdb.r.4xlarge`, `gdb.r.8xlarge`, `gdb.r.16xlarge`, `gdb.r.xlarge_basic`, `gdb.r.2xlarge_basic`, `gdb.r.4xlarge_basic`, `gdb.r.8xlarge_basic`, `gdb.r.16xlarge_basic`.
        :param pulumi.Input[_builtins.int] db_node_storage: Instance storage space, which is measured in GB.
        :param pulumi.Input[_builtins.str] db_version: Kernel Version. Valid values: `1.0` or `1.0-OpenCypher`. `1.0`: represented as gremlin, `1.0-OpenCypher`: said opencypher.
        :param pulumi.Input[_builtins.str] payment_type: The paymen type of the resource. Valid values: `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] port: (Available in 1.196.0+) The connection port of the instance.
        :param pulumi.Input[_builtins.str] status: Instance status. Value range: `Creating`, `Running`, `Deleting`, `Rebooting`, `DBInstanceClassChanging`, `NetAddressCreating` and `NetAddressDeleting`.
        :param pulumi.Input[_builtins.str] vpc_id: ID of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of attaching vswitch to instance.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbInstanceState.__new__(_DbInstanceState)

        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["db_instance_category"] = db_instance_category
        __props__.__dict__["db_instance_description"] = db_instance_description
        __props__.__dict__["db_instance_ip_arrays"] = db_instance_ip_arrays
        __props__.__dict__["db_instance_network_type"] = db_instance_network_type
        __props__.__dict__["db_instance_storage_type"] = db_instance_storage_type
        __props__.__dict__["db_node_class"] = db_node_class
        __props__.__dict__["db_node_storage"] = db_node_storage
        __props__.__dict__["db_version"] = db_version
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["port"] = port
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return DbInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        (Available in 1.196.0+)  The connection string of the instance.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="dbInstanceCategory")
    def db_instance_category(self) -> pulumi.Output[_builtins.str]:
        """
        The category of the db instance. Valid values: `HA`, `SINGLE`(Available in 1.173.0+).
        """
        return pulumi.get(self, "db_instance_category")

    @_builtins.property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        According to the practical example or notes.
        """
        return pulumi.get(self, "db_instance_description")

    @_builtins.property
    @pulumi.getter(name="dbInstanceIpArrays")
    def db_instance_ip_arrays(self) -> pulumi.Output[Sequence['outputs.DbInstanceDbInstanceIpArray']]:
        """
        IP ADDRESS whitelist for the instance group list. See `db_instance_ip_array` below.
        """
        return pulumi.get(self, "db_instance_ip_arrays")

    @_builtins.property
    @pulumi.getter(name="dbInstanceNetworkType")
    def db_instance_network_type(self) -> pulumi.Output[_builtins.str]:
        """
        The network type of the db instance. Valid values: `vpc`.
        """
        return pulumi.get(self, "db_instance_network_type")

    @_builtins.property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> pulumi.Output[_builtins.str]:
        """
        Disk storage type. Valid values: `cloud_essd`, `cloud_ssd`. Modification is not supported.
        """
        return pulumi.get(self, "db_instance_storage_type")

    @_builtins.property
    @pulumi.getter(name="dbNodeClass")
    def db_node_class(self) -> pulumi.Output[_builtins.str]:
        """
        The class of the db node. Valid values: `gdb.r.xlarge`, `gdb.r.2xlarge`, `gdb.r.4xlarge`, `gdb.r.8xlarge`, `gdb.r.16xlarge`, `gdb.r.xlarge_basic`, `gdb.r.2xlarge_basic`, `gdb.r.4xlarge_basic`, `gdb.r.8xlarge_basic`, `gdb.r.16xlarge_basic`.
        """
        return pulumi.get(self, "db_node_class")

    @_builtins.property
    @pulumi.getter(name="dbNodeStorage")
    def db_node_storage(self) -> pulumi.Output[_builtins.int]:
        """
        Instance storage space, which is measured in GB.
        """
        return pulumi.get(self, "db_node_storage")

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Output[_builtins.str]:
        """
        Kernel Version. Valid values: `1.0` or `1.0-OpenCypher`. `1.0`: represented as gremlin, `1.0-OpenCypher`: said opencypher.
        """
        return pulumi.get(self, "db_version")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The paymen type of the resource. Valid values: `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.str]:
        """
        (Available in 1.196.0+) The connection port of the instance.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Instance status. Value range: `Creating`, `Running`, `Deleting`, `Rebooting`, `DBInstanceClassChanging`, `NetAddressCreating` and `NetAddressDeleting`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of attaching vswitch to instance.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The zone ID of the resource.
        """
        return pulumi.get(self, "zone_id")

