# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'OtsBackupPlanOtsDetail',
    'OtsBackupPlanRule',
    'PolicyBindingAdvancedOptions',
    'PolicyBindingAdvancedOptionsUdmDetail',
    'PolicyRule',
    'PolicyRuleRetentionRule',
    'RestoreJobOtsDetail',
    'ServerBackupPlanDetail',
    'GetBackupJobsFilterResult',
    'GetBackupJobsJobResult',
    'GetBackupJobsJobOtsDetailResult',
    'GetEcsBackupClientsClientResult',
    'GetEcsBackupPlansPlanResult',
    'GetHanaBackupClientsHanaBackupClientResult',
    'GetHanaBackupPlansPlanResult',
    'GetHanaInstancesInstanceResult',
    'GetNasBackupPlansPlanResult',
    'GetOssBackupPlansPlanResult',
    'GetOtsBackupPlansPlanResult',
    'GetOtsBackupPlansPlanOtsDetailResult',
    'GetOtsSnapshotsSnapshotResult',
    'GetReplicationVaultRegionsRegionResult',
    'GetRestoreJobsJobResult',
    'GetServerBackupPlansFilterResult',
    'GetServerBackupPlansPlanResult',
    'GetServerBackupPlansPlanDetailResult',
    'GetSnapshotsSnapshotResult',
    'GetUdmSnapshotsSnapshotResult',
    'GetVaultsVaultResult',
]

@pulumi.output_type
class OtsBackupPlanOtsDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableNames":
            suggest = "table_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OtsBackupPlanOtsDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OtsBackupPlanOtsDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OtsBackupPlanOtsDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_names: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] table_names: The names of the destination tables in the Tablestore instance. **Note:** Required while source_type equals `OTS_TABLE`.
        """
        if table_names is not None:
            pulumi.set(__self__, "table_names", table_names)

    @_builtins.property
    @pulumi.getter(name="tableNames")
    def table_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        The names of the destination tables in the Tablestore instance. **Note:** Required while source_type equals `OTS_TABLE`.
        """
        return pulumi.get(self, "table_names")


@pulumi.output_type
class OtsBackupPlanRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupType":
            suggest = "backup_type"
        elif key == "ruleName":
            suggest = "rule_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OtsBackupPlanRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OtsBackupPlanRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OtsBackupPlanRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_type: Optional[_builtins.str] = None,
                 disabled: Optional[_builtins.bool] = None,
                 retention: Optional[_builtins.str] = None,
                 rule_name: Optional[_builtins.str] = None,
                 schedule: Optional[_builtins.str] = None):
        """
        :param _builtins.str backup_type: Backup type. Valid values: `COMPLETE`.
        :param _builtins.bool disabled: Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
        :param _builtins.str retention: Backup retention days, the minimum is 1.
        :param _builtins.str rule_name: The name of the backup rule.**Note:** Required while source_type equals `OTS_TABLE`. `rule_name` should be unique for the specific user.
        :param _builtins.str schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
               - `startTime` Backup start time, UNIX time seconds.
        """
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[_builtins.str]:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[_builtins.bool]:
        """
        Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> Optional[_builtins.str]:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[_builtins.str]:
        """
        The name of the backup rule.**Note:** Required while source_type equals `OTS_TABLE`. `rule_name` should be unique for the specific user.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[_builtins.str]:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        - `startTime` Backup start time, UNIX time seconds.
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class PolicyBindingAdvancedOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "udmDetail":
            suggest = "udm_detail"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyBindingAdvancedOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyBindingAdvancedOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyBindingAdvancedOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 udm_detail: Optional['outputs.PolicyBindingAdvancedOptionsUdmDetail'] = None):
        """
        :param 'PolicyBindingAdvancedOptionsUdmDetailArgs' udm_detail: ECS Backup Advanced options. See `udm_detail` below.
        """
        if udm_detail is not None:
            pulumi.set(__self__, "udm_detail", udm_detail)

    @_builtins.property
    @pulumi.getter(name="udmDetail")
    def udm_detail(self) -> Optional['outputs.PolicyBindingAdvancedOptionsUdmDetail']:
        """
        ECS Backup Advanced options. See `udm_detail` below.
        """
        return pulumi.get(self, "udm_detail")


@pulumi.output_type
class PolicyBindingAdvancedOptionsUdmDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationKmsKeyId":
            suggest = "destination_kms_key_id"
        elif key == "diskIdLists":
            suggest = "disk_id_lists"
        elif key == "excludeDiskIdLists":
            suggest = "exclude_disk_id_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyBindingAdvancedOptionsUdmDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyBindingAdvancedOptionsUdmDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyBindingAdvancedOptionsUdmDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_kms_key_id: Optional[_builtins.str] = None,
                 disk_id_lists: Optional[Sequence[_builtins.str]] = None,
                 exclude_disk_id_lists: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str destination_kms_key_id: Custom KMS key ID of encrypted copy.
        :param Sequence[_builtins.str] disk_id_lists: The list of backup disks. If it is empty, all disks are backed up.
        :param Sequence[_builtins.str] exclude_disk_id_lists: List of cloud disk IDs that are not backed up.
        """
        if destination_kms_key_id is not None:
            pulumi.set(__self__, "destination_kms_key_id", destination_kms_key_id)
        if disk_id_lists is not None:
            pulumi.set(__self__, "disk_id_lists", disk_id_lists)
        if exclude_disk_id_lists is not None:
            pulumi.set(__self__, "exclude_disk_id_lists", exclude_disk_id_lists)

    @_builtins.property
    @pulumi.getter(name="destinationKmsKeyId")
    def destination_kms_key_id(self) -> Optional[_builtins.str]:
        """
        Custom KMS key ID of encrypted copy.
        """
        return pulumi.get(self, "destination_kms_key_id")

    @_builtins.property
    @pulumi.getter(name="diskIdLists")
    def disk_id_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of backup disks. If it is empty, all disks are backed up.
        """
        return pulumi.get(self, "disk_id_lists")

    @_builtins.property
    @pulumi.getter(name="excludeDiskIdLists")
    def exclude_disk_id_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of cloud disk IDs that are not backed up.
        """
        return pulumi.get(self, "exclude_disk_id_lists")


@pulumi.output_type
class PolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleType":
            suggest = "rule_type"
        elif key == "archiveDays":
            suggest = "archive_days"
        elif key == "backupType":
            suggest = "backup_type"
        elif key == "keepLatestSnapshots":
            suggest = "keep_latest_snapshots"
        elif key == "replicationRegionId":
            suggest = "replication_region_id"
        elif key == "retentionRules":
            suggest = "retention_rules"
        elif key == "ruleId":
            suggest = "rule_id"
        elif key == "vaultId":
            suggest = "vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_type: _builtins.str,
                 archive_days: Optional[_builtins.int] = None,
                 backup_type: Optional[_builtins.str] = None,
                 keep_latest_snapshots: Optional[_builtins.int] = None,
                 replication_region_id: Optional[_builtins.str] = None,
                 retention: Optional[_builtins.int] = None,
                 retention_rules: Optional[Sequence['outputs.PolicyRuleRetentionRule']] = None,
                 rule_id: Optional[_builtins.str] = None,
                 schedule: Optional[_builtins.str] = None,
                 vault_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str rule_type: Rule Type.
        :param _builtins.int archive_days: This parameter is required only when the value of `RuleType` is **TRANSITION. The minimum value is 30, and the Retention-ArchiveDays needs to be greater than or equal to 60.
        :param _builtins.str backup_type: This parameter is required only when the `RuleType` value is **BACKUP. Backup Type.
        :param _builtins.int keep_latest_snapshots: This parameter is required only when `RuleType` is set to `BACKUP`.
        :param _builtins.str replication_region_id: Only when the `RuleType` value is.
        :param _builtins.int retention: Retention time, in days.
        :param Sequence['PolicyRuleRetentionRuleArgs'] retention_rules: This parameter is required only when the value of `RuleType` is `TRANSITION`. See `retention_rules` below.
        :param _builtins.str rule_id: Rule ID.
        :param _builtins.str schedule: This parameter is required only if you set the `RuleType` parameter to `BACKUP`. This parameter specifies the backup schedule settings. Format: `I|{startTime}|{interval}`. The system runs the first backup job at a point in time that is specified in the {startTime} parameter and the subsequent backup jobs at an interval that is specified in the {interval} parameter. The system does not run a backup job before the specified point in time. Each backup job, except the first one, starts only after the previous backup job is complete. For example, `I|1631685600|P1D` specifies that the system runs the first backup job at 14:00:00 on September 15, 2021 and the subsequent backup jobs once a day.  *   startTime: the time at which the system starts to run a backup job. The time must follow the UNIX time format. Unit: seconds. *   interval: the interval at which the system runs a backup job. The interval must follow the ISO 8601 standard. For example, PT1H specifies an interval of one hour. P1D specifies an interval of one day.
        :param _builtins.str vault_id: Vault ID.
        """
        pulumi.set(__self__, "rule_type", rule_type)
        if archive_days is not None:
            pulumi.set(__self__, "archive_days", archive_days)
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if keep_latest_snapshots is not None:
            pulumi.set(__self__, "keep_latest_snapshots", keep_latest_snapshots)
        if replication_region_id is not None:
            pulumi.set(__self__, "replication_region_id", replication_region_id)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if retention_rules is not None:
            pulumi.set(__self__, "retention_rules", retention_rules)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> _builtins.str:
        """
        Rule Type.
        """
        return pulumi.get(self, "rule_type")

    @_builtins.property
    @pulumi.getter(name="archiveDays")
    def archive_days(self) -> Optional[_builtins.int]:
        """
        This parameter is required only when the value of `RuleType` is **TRANSITION. The minimum value is 30, and the Retention-ArchiveDays needs to be greater than or equal to 60.
        """
        return pulumi.get(self, "archive_days")

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[_builtins.str]:
        """
        This parameter is required only when the `RuleType` value is **BACKUP. Backup Type.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="keepLatestSnapshots")
    def keep_latest_snapshots(self) -> Optional[_builtins.int]:
        """
        This parameter is required only when `RuleType` is set to `BACKUP`.
        """
        return pulumi.get(self, "keep_latest_snapshots")

    @_builtins.property
    @pulumi.getter(name="replicationRegionId")
    def replication_region_id(self) -> Optional[_builtins.str]:
        """
        Only when the `RuleType` value is.
        """
        return pulumi.get(self, "replication_region_id")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> Optional[_builtins.int]:
        """
        Retention time, in days.
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter(name="retentionRules")
    def retention_rules(self) -> Optional[Sequence['outputs.PolicyRuleRetentionRule']]:
        """
        This parameter is required only when the value of `RuleType` is `TRANSITION`. See `retention_rules` below.
        """
        return pulumi.get(self, "retention_rules")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[_builtins.str]:
        """
        Rule ID.
        """
        return pulumi.get(self, "rule_id")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[_builtins.str]:
        """
        This parameter is required only if you set the `RuleType` parameter to `BACKUP`. This parameter specifies the backup schedule settings. Format: `I|{startTime}|{interval}`. The system runs the first backup job at a point in time that is specified in the {startTime} parameter and the subsequent backup jobs at an interval that is specified in the {interval} parameter. The system does not run a backup job before the specified point in time. Each backup job, except the first one, starts only after the previous backup job is complete. For example, `I|1631685600|P1D` specifies that the system runs the first backup job at 14:00:00 on September 15, 2021 and the subsequent backup jobs once a day.  *   startTime: the time at which the system starts to run a backup job. The time must follow the UNIX time format. Unit: seconds. *   interval: the interval at which the system runs a backup job. The interval must follow the ISO 8601 standard. For example, PT1H specifies an interval of one hour. P1D specifies an interval of one day.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[_builtins.str]:
        """
        Vault ID.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class PolicyRuleRetentionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advancedRetentionType":
            suggest = "advanced_retention_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyRuleRetentionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyRuleRetentionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyRuleRetentionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advanced_retention_type: Optional[_builtins.str] = None,
                 retention: Optional[_builtins.int] = None):
        """
        :param _builtins.str advanced_retention_type: Valid values: `annually`, `MONTHLY`, and `WEEKLY`:- `annually`: the first backup of each year. - `MONTHLY`: The first backup of the month. - `WEEKLY`: The first backup of the week. - `DAILY`: The first backup of the day.
        :param _builtins.int retention: Retention time, in days.
        """
        if advanced_retention_type is not None:
            pulumi.set(__self__, "advanced_retention_type", advanced_retention_type)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)

    @_builtins.property
    @pulumi.getter(name="advancedRetentionType")
    def advanced_retention_type(self) -> Optional[_builtins.str]:
        """
        Valid values: `annually`, `MONTHLY`, and `WEEKLY`:- `annually`: the first backup of each year. - `MONTHLY`: The first backup of the month. - `WEEKLY`: The first backup of the week. - `DAILY`: The first backup of the day.
        """
        return pulumi.get(self, "advanced_retention_type")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> Optional[_builtins.int]:
        """
        Retention time, in days.
        """
        return pulumi.get(self, "retention")


@pulumi.output_type
class RestoreJobOtsDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "overwriteExisting":
            suggest = "overwrite_existing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestoreJobOtsDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestoreJobOtsDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestoreJobOtsDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 overwrite_existing: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool overwrite_existing: Whether to overwrite the existing table storage recovery task. Valid values: `true`, `false`.
        """
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)

    @_builtins.property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional[_builtins.bool]:
        """
        Whether to overwrite the existing table storage recovery task. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "overwrite_existing")


@pulumi.output_type
class ServerBackupPlanDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appConsistent":
            suggest = "app_consistent"
        elif key == "snapshotGroup":
            suggest = "snapshot_group"
        elif key == "destinationRegionId":
            suggest = "destination_region_id"
        elif key == "destinationRetention":
            suggest = "destination_retention"
        elif key == "diskIdLists":
            suggest = "disk_id_lists"
        elif key == "doCopy":
            suggest = "do_copy"
        elif key == "enableFsFreeze":
            suggest = "enable_fs_freeze"
        elif key == "postScriptPath":
            suggest = "post_script_path"
        elif key == "preScriptPath":
            suggest = "pre_script_path"
        elif key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerBackupPlanDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerBackupPlanDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerBackupPlanDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_consistent: _builtins.bool,
                 snapshot_group: _builtins.bool,
                 destination_region_id: Optional[_builtins.str] = None,
                 destination_retention: Optional[_builtins.int] = None,
                 disk_id_lists: Optional[Sequence[_builtins.str]] = None,
                 do_copy: Optional[_builtins.bool] = None,
                 enable_fs_freeze: Optional[_builtins.bool] = None,
                 post_script_path: Optional[_builtins.str] = None,
                 pre_script_path: Optional[_builtins.str] = None,
                 timeout_in_seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.bool app_consistent: Whether to turn on application consistency. The application consistency snapshot backs up memory data and ongoing database transactions at the time of snapshot creation to ensure the consistency of application system data and database transactions. By applying consistent snapshots, there is no data damage or loss, so as to avoid log rollback during database startup and ensure that the application is in a consistent startup state. Valid values: `true`, `false`.
        :param _builtins.bool snapshot_group: Whether to turn on file system consistency. If SnapshotGroup is true, when AppConsistent is true but the relevant conditions are not met or AppConsistent is false, the resulting snapshot will be a file system consistency snapshot. The file system consistency ensures that the file system memory and disk information are synchronized at the time of snapshot creation, and the file system write operation is frozen to make the file system in a consistent state. The file system consistency snapshot can prevent the operating system from performing disk inspection and repair operations such as CHKDSK or fsck after restart. Valid values: `true`, `false`.
        :param _builtins.str destination_region_id: Only vaild when DoCopy is true. The destination region ID when replicating to another region. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param _builtins.int destination_retention: Only vaild when DoCopy is true. The retention days of the destination backup. When not specified, the destination backup will be saved permanently. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param Sequence[_builtins.str] disk_id_lists: The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
        :param _builtins.bool do_copy: Whether replicate to another region. Valid values: `true`, `false`.
        :param _builtins.bool enable_fs_freeze: Only the Linux system is valid. Whether to use the Linux FsFreeze mechanism to ensure that the file system is read-only consistent before creating a storage snapshot. The default is True. Valid values: `true`, `false`.
        :param _builtins.str post_script_path: Only vaild for the linux system when AppConsistent is true. The application thaw script path (e.g. /tmp/postscript.sh). The postscript.sh script must meet the following conditions: in terms of permissions, only the root user as the owner has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        :param _builtins.str pre_script_path: Only vaild for the linux system when AppConsistent is true. Apply the freeze script path (e.g. /tmp/prescript.sh). prescript.sh scripts must meet the following conditions: in terms of permissions, only root, as the owner, has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        :param _builtins.int timeout_in_seconds: Only the Linux system is valid, and the IO freeze timeout period. The default is 30 seconds.
        """
        pulumi.set(__self__, "app_consistent", app_consistent)
        pulumi.set(__self__, "snapshot_group", snapshot_group)
        if destination_region_id is not None:
            pulumi.set(__self__, "destination_region_id", destination_region_id)
        if destination_retention is not None:
            pulumi.set(__self__, "destination_retention", destination_retention)
        if disk_id_lists is not None:
            pulumi.set(__self__, "disk_id_lists", disk_id_lists)
        if do_copy is not None:
            pulumi.set(__self__, "do_copy", do_copy)
        if enable_fs_freeze is not None:
            pulumi.set(__self__, "enable_fs_freeze", enable_fs_freeze)
        if post_script_path is not None:
            pulumi.set(__self__, "post_script_path", post_script_path)
        if pre_script_path is not None:
            pulumi.set(__self__, "pre_script_path", pre_script_path)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @_builtins.property
    @pulumi.getter(name="appConsistent")
    def app_consistent(self) -> _builtins.bool:
        """
        Whether to turn on application consistency. The application consistency snapshot backs up memory data and ongoing database transactions at the time of snapshot creation to ensure the consistency of application system data and database transactions. By applying consistent snapshots, there is no data damage or loss, so as to avoid log rollback during database startup and ensure that the application is in a consistent startup state. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "app_consistent")

    @_builtins.property
    @pulumi.getter(name="snapshotGroup")
    def snapshot_group(self) -> _builtins.bool:
        """
        Whether to turn on file system consistency. If SnapshotGroup is true, when AppConsistent is true but the relevant conditions are not met or AppConsistent is false, the resulting snapshot will be a file system consistency snapshot. The file system consistency ensures that the file system memory and disk information are synchronized at the time of snapshot creation, and the file system write operation is frozen to make the file system in a consistent state. The file system consistency snapshot can prevent the operating system from performing disk inspection and repair operations such as CHKDSK or fsck after restart. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "snapshot_group")

    @_builtins.property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> Optional[_builtins.str]:
        """
        Only vaild when DoCopy is true. The destination region ID when replicating to another region. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "destination_region_id")

    @_builtins.property
    @pulumi.getter(name="destinationRetention")
    def destination_retention(self) -> Optional[_builtins.int]:
        """
        Only vaild when DoCopy is true. The retention days of the destination backup. When not specified, the destination backup will be saved permanently. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "destination_retention")

    @_builtins.property
    @pulumi.getter(name="diskIdLists")
    def disk_id_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
        """
        return pulumi.get(self, "disk_id_lists")

    @_builtins.property
    @pulumi.getter(name="doCopy")
    def do_copy(self) -> Optional[_builtins.bool]:
        """
        Whether replicate to another region. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "do_copy")

    @_builtins.property
    @pulumi.getter(name="enableFsFreeze")
    def enable_fs_freeze(self) -> Optional[_builtins.bool]:
        """
        Only the Linux system is valid. Whether to use the Linux FsFreeze mechanism to ensure that the file system is read-only consistent before creating a storage snapshot. The default is True. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_fs_freeze")

    @_builtins.property
    @pulumi.getter(name="postScriptPath")
    def post_script_path(self) -> Optional[_builtins.str]:
        """
        Only vaild for the linux system when AppConsistent is true. The application thaw script path (e.g. /tmp/postscript.sh). The postscript.sh script must meet the following conditions: in terms of permissions, only the root user as the owner has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        """
        return pulumi.get(self, "post_script_path")

    @_builtins.property
    @pulumi.getter(name="preScriptPath")
    def pre_script_path(self) -> Optional[_builtins.str]:
        """
        Only vaild for the linux system when AppConsistent is true. Apply the freeze script path (e.g. /tmp/prescript.sh). prescript.sh scripts must meet the following conditions: in terms of permissions, only root, as the owner, has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        """
        return pulumi.get(self, "pre_script_path")

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[_builtins.int]:
        """
        Only the Linux system is valid, and the IO freeze timeout period. The default is 30 seconds.
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class GetBackupJobsFilterResult(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 operator: Optional[_builtins.str] = None,
                 values: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str key: The key of the field to filter. Valid values: `PlanId`, `VaultId`, `InstanceId`, `Bucket`, `FileSystemId`, `CompleteTime`.
        :param _builtins.str operator: The operator of the field to filter. Valid values: `EQUAL`, `NOT_EQUAL`, `GREATER_THAN`, `GREATER_THAN_OR_EQUAL`, `LESS_THAN`, `LESS_THAN_OR_EQUAL`, `BETWEEN`, `IN`.
        :param Sequence[_builtins.str] values: Set of values that are accepted for the given field.
               
               > **NOTE:** Numeric types such as `CompleteTime` do not support `IN` operations for the time being.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key of the field to filter. Valid values: `PlanId`, `VaultId`, `InstanceId`, `Bucket`, `FileSystemId`, `CompleteTime`.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        The operator of the field to filter. Valid values: `EQUAL`, `NOT_EQUAL`, `GREATER_THAN`, `GREATER_THAN_OR_EQUAL`, `LESS_THAN`, `LESS_THAN_OR_EQUAL`, `BETWEEN`, `IN`.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        Set of values that are accepted for the given field.

        > **NOTE:** Numeric types such as `CompleteTime` do not support `IN` operations for the time being.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBackupJobsJobResult(dict):
    def __init__(__self__, *,
                 actual_bytes: _builtins.str,
                 actual_items: _builtins.str,
                 back_job_name: _builtins.str,
                 backup_job_id: _builtins.str,
                 backup_type: _builtins.str,
                 bucket: _builtins.str,
                 bytes_done: _builtins.str,
                 bytes_total: _builtins.str,
                 complete_time: _builtins.str,
                 create_time: _builtins.str,
                 cross_account_role_name: _builtins.str,
                 cross_account_type: _builtins.str,
                 cross_account_user_id: _builtins.int,
                 error_message: _builtins.str,
                 exclude: _builtins.str,
                 file_system_id: _builtins.str,
                 id: _builtins.str,
                 include: _builtins.str,
                 instance_id: _builtins.str,
                 items_done: _builtins.str,
                 items_total: _builtins.str,
                 nas_create_time: _builtins.str,
                 ots_details: Sequence['outputs.GetBackupJobsJobOtsDetailResult'],
                 paths: Sequence[_builtins.str],
                 plan_id: _builtins.str,
                 prefix: _builtins.str,
                 progress: _builtins.str,
                 source_type: _builtins.str,
                 start_time: _builtins.str,
                 status: _builtins.str,
                 updated_time: _builtins.str,
                 vault_id: _builtins.str):
        """
        :param _builtins.str actual_bytes: The actual data volume of the backup task (After deduplication) . Unit byte.
        :param _builtins.str actual_items: The actual number of items in the backup task. (Currently only file backup is available).
        :param _builtins.str back_job_name: The name of backup job.
        :param _builtins.str backup_job_id: The ID of the backup job.
        :param _builtins.str backup_type: Backup type. Valid values: `COMPLETE`(full backup).
        :param _builtins.str bucket: The name of target OSS bucket.
        :param _builtins.str bytes_done: The amount of backup data (Incremental). Unit byte.
        :param _builtins.str bytes_total: The total amount of data sources. Unit byte.
        :param _builtins.str complete_time: The completion time of backup job. UNIX time seconds.
        :param _builtins.str create_time: The creation time of backup job. UNIX time seconds.
        :param _builtins.str cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account. It is valid only when `source_type` is `ECS_FILE`, `NAS`, `OSS` or `OTS`.
        :param _builtins.str cross_account_type: The type of the cross account backup. It is valid only when `source_type` is `ECS_FILE`, `NAS`, `OSS` or `OTS`.
        :param _builtins.int cross_account_user_id: The original account ID of the cross account backup managed by the current account. It is valid only when `source_type` is `ECS_FILE`, `NAS`, `OSS` or `OTS`.
        :param _builtins.str error_message: Error message.
        :param _builtins.str exclude: Exclude path. String of Json list. Up to 255 characters. e.g. `"[\\"/home/work\\"]"`
        :param _builtins.str file_system_id: The ID of destination file system.
        :param _builtins.str id: The ID of the backup job.
        :param _builtins.str include: Include path. String of Json list. Up to 255 characters. e.g. `"[\\"/var\\"]"`
        :param _builtins.str instance_id: The ID of target ECS instance.
        :param _builtins.str items_done: The number of items restore job recovered.
        :param _builtins.str items_total: The total number of items restore job recovered.
        :param _builtins.str nas_create_time: File system creation time. UNIX time in seconds.
        :param Sequence[_builtins.str] paths: List of backup path. e.g. `["/home", "/var"]`.
        :param _builtins.str plan_id: The ID of a backup plan.
        :param _builtins.str prefix: The prefix of Oss bucket files.
        :param _builtins.str progress: Backup progress. The value is 100%*100.
        :param _builtins.str source_type: The type of data source. Valid Values: `ECS_FILE`, `OSS`, `NAS`, `UDM_DISK`.
        :param _builtins.str start_time: The scheduled backup start time. UNIX time seconds.
        :param _builtins.str status: The status of restore job. Valid values: `COMPLETE` , `PARTIAL_COMPLETE`, `FAILED`.
        :param _builtins.str updated_time: The update time of backup job. UNIX time seconds.
        :param _builtins.str vault_id: The ID of backup vault.
        """
        pulumi.set(__self__, "actual_bytes", actual_bytes)
        pulumi.set(__self__, "actual_items", actual_items)
        pulumi.set(__self__, "back_job_name", back_job_name)
        pulumi.set(__self__, "backup_job_id", backup_job_id)
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "bytes_done", bytes_done)
        pulumi.set(__self__, "bytes_total", bytes_total)
        pulumi.set(__self__, "complete_time", complete_time)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "cross_account_role_name", cross_account_role_name)
        pulumi.set(__self__, "cross_account_type", cross_account_type)
        pulumi.set(__self__, "cross_account_user_id", cross_account_user_id)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "exclude", exclude)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "include", include)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "items_done", items_done)
        pulumi.set(__self__, "items_total", items_total)
        pulumi.set(__self__, "nas_create_time", nas_create_time)
        pulumi.set(__self__, "ots_details", ots_details)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "plan_id", plan_id)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="actualBytes")
    def actual_bytes(self) -> _builtins.str:
        """
        The actual data volume of the backup task (After deduplication) . Unit byte.
        """
        return pulumi.get(self, "actual_bytes")

    @_builtins.property
    @pulumi.getter(name="actualItems")
    def actual_items(self) -> _builtins.str:
        """
        The actual number of items in the backup task. (Currently only file backup is available).
        """
        return pulumi.get(self, "actual_items")

    @_builtins.property
    @pulumi.getter(name="backJobName")
    def back_job_name(self) -> _builtins.str:
        """
        The name of backup job.
        """
        return pulumi.get(self, "back_job_name")

    @_builtins.property
    @pulumi.getter(name="backupJobId")
    def backup_job_id(self) -> _builtins.str:
        """
        The ID of the backup job.
        """
        return pulumi.get(self, "backup_job_id")

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> _builtins.str:
        """
        Backup type. Valid values: `COMPLETE`(full backup).
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of target OSS bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="bytesDone")
    def bytes_done(self) -> _builtins.str:
        """
        The amount of backup data (Incremental). Unit byte.
        """
        return pulumi.get(self, "bytes_done")

    @_builtins.property
    @pulumi.getter(name="bytesTotal")
    def bytes_total(self) -> _builtins.str:
        """
        The total amount of data sources. Unit byte.
        """
        return pulumi.get(self, "bytes_total")

    @_builtins.property
    @pulumi.getter(name="completeTime")
    def complete_time(self) -> _builtins.str:
        """
        The completion time of backup job. UNIX time seconds.
        """
        return pulumi.get(self, "complete_time")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of backup job. UNIX time seconds.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> _builtins.str:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account. It is valid only when `source_type` is `ECS_FILE`, `NAS`, `OSS` or `OTS`.
        """
        return pulumi.get(self, "cross_account_role_name")

    @_builtins.property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> _builtins.str:
        """
        The type of the cross account backup. It is valid only when `source_type` is `ECS_FILE`, `NAS`, `OSS` or `OTS`.
        """
        return pulumi.get(self, "cross_account_type")

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> _builtins.int:
        """
        The original account ID of the cross account backup managed by the current account. It is valid only when `source_type` is `ECS_FILE`, `NAS`, `OSS` or `OTS`.
        """
        return pulumi.get(self, "cross_account_user_id")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> _builtins.str:
        """
        Error message.
        """
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter
    def exclude(self) -> _builtins.str:
        """
        Exclude path. String of Json list. Up to 255 characters. e.g. `"[\\"/home/work\\"]"`
        """
        return pulumi.get(self, "exclude")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> _builtins.str:
        """
        The ID of destination file system.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the backup job.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def include(self) -> _builtins.str:
        """
        Include path. String of Json list. Up to 255 characters. e.g. `"[\\"/var\\"]"`
        """
        return pulumi.get(self, "include")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of target ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="itemsDone")
    def items_done(self) -> _builtins.str:
        """
        The number of items restore job recovered.
        """
        return pulumi.get(self, "items_done")

    @_builtins.property
    @pulumi.getter(name="itemsTotal")
    def items_total(self) -> _builtins.str:
        """
        The total number of items restore job recovered.
        """
        return pulumi.get(self, "items_total")

    @_builtins.property
    @pulumi.getter(name="nasCreateTime")
    def nas_create_time(self) -> _builtins.str:
        """
        File system creation time. UNIX time in seconds.
        """
        return pulumi.get(self, "nas_create_time")

    @_builtins.property
    @pulumi.getter(name="otsDetails")
    def ots_details(self) -> Sequence['outputs.GetBackupJobsJobOtsDetailResult']:
        return pulumi.get(self, "ots_details")

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Sequence[_builtins.str]:
        """
        List of backup path. e.g. `["/home", "/var"]`.
        """
        return pulumi.get(self, "paths")

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> _builtins.str:
        """
        The ID of a backup plan.
        """
        return pulumi.get(self, "plan_id")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        The prefix of Oss bucket files.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def progress(self) -> _builtins.str:
        """
        Backup progress. The value is 100%*100.
        """
        return pulumi.get(self, "progress")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The type of data source. Valid Values: `ECS_FILE`, `OSS`, `NAS`, `UDM_DISK`.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        The scheduled backup start time. UNIX time seconds.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of restore job. Valid values: `COMPLETE` , `PARTIAL_COMPLETE`, `FAILED`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> _builtins.str:
        """
        The update time of backup job. UNIX time seconds.
        """
        return pulumi.get(self, "updated_time")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetBackupJobsJobOtsDetailResult(dict):
    def __init__(__self__, *,
                 table_names: Sequence[_builtins.str]):
        pulumi.set(__self__, "table_names", table_names)

    @_builtins.property
    @pulumi.getter(name="tableNames")
    def table_names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "table_names")


@pulumi.output_type
class GetEcsBackupClientsClientResult(dict):
    def __init__(__self__, *,
                 arch_type: _builtins.str,
                 backup_status: _builtins.str,
                 client_type: _builtins.str,
                 client_version: _builtins.str,
                 create_time: _builtins.str,
                 data_network_type: _builtins.str,
                 data_proxy_setting: _builtins.str,
                 ecs_backup_client_id: _builtins.str,
                 hostname: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 instance_name: _builtins.str,
                 last_heart_beat_time: _builtins.str,
                 max_client_version: _builtins.str,
                 max_cpu_core: _builtins.str,
                 max_worker: _builtins.str,
                 os_type: _builtins.str,
                 private_ipv4: _builtins.str,
                 proxy_host: _builtins.str,
                 proxy_password: _builtins.str,
                 proxy_port: _builtins.str,
                 proxy_user: _builtins.str,
                 status: _builtins.str,
                 updated_time: _builtins.str,
                 use_https: _builtins.bool,
                 zone_id: _builtins.str):
        """
        :param _builtins.str arch_type: The system architecture of client, only the ECS File Backup Client is available. Valid values: `AMD64` , `386`.
        :param _builtins.str backup_status: Client protected status. Valid values: `UNPROTECTED`, `PROTECTED`.
        :param _builtins.str client_type: The type of client. Valid values: `ECS_CLIENT` (ECS File Backup Client).
        :param _builtins.str client_version: The version of client.
        :param _builtins.str create_time: The creation time of client. Unix time in seconds.
        :param _builtins.str data_network_type: The data plane access point type. Valid Values: `PUBLIC`, `VPC`, `CLASSIC`.
        :param _builtins.str data_proxy_setting: The data plane proxy settings. Valid Values: `DISABLE`, `USE_CONTROL_PROXY`, `CUSTOM`.
               * `USE_CONTROL_PROXY` (Default, the same with control plane)
               * `CUSTOM` (Custom configuration items for the HTTP protocol).
        :param _builtins.str ecs_backup_client_id: The first ID of the resource.
        :param _builtins.str hostname: The hostname of ECS instance.
        :param _builtins.str id: The ID of the Ecs Backup Client.
        :param _builtins.str instance_id: The ID of ECS instance. When the client type is ECS file backup client, it indicates the ID of ECS instance. When the client type is a local file backup client, it is a hardware fingerprint generated based on system information.
        :param _builtins.str instance_name: The name of ECS instance.
        :param _builtins.str last_heart_beat_time: The last heartbeat time of client. Unix Time Seconds.
        :param _builtins.str max_client_version: The latest version of client.
        :param _builtins.str max_cpu_core: The number of CPU cores used by a single backup task, 0 means no restrictions.
        :param _builtins.str max_worker: The number of concurrent jobs for a single backup task, 0 means no restrictions.
        :param _builtins.str os_type: The operating system type of client, only the ECS File Backup Client is available. Valid values: `windows`, `linux`.
        :param _builtins.str private_ipv4: Intranet IP address of the instance, only available for ECS file backup client.
        :param _builtins.str proxy_host: Custom data plane proxy server host address.
        :param _builtins.str proxy_password: The password of custom data plane proxy server.
        :param _builtins.str proxy_port: Custom data plane proxy server host port.
        :param _builtins.str proxy_user: The username of custom data plane proxy server.
        :param _builtins.str status: The status of the resource.
        :param _builtins.str updated_time: The update time of client. Unix Time Seconds.
        :param _builtins.bool use_https: Indicates whether to use the HTTPS protocol. Valid values: `true`, `false`.
        :param _builtins.str zone_id: The ID of Zone.
        """
        pulumi.set(__self__, "arch_type", arch_type)
        pulumi.set(__self__, "backup_status", backup_status)
        pulumi.set(__self__, "client_type", client_type)
        pulumi.set(__self__, "client_version", client_version)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "data_network_type", data_network_type)
        pulumi.set(__self__, "data_proxy_setting", data_proxy_setting)
        pulumi.set(__self__, "ecs_backup_client_id", ecs_backup_client_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "last_heart_beat_time", last_heart_beat_time)
        pulumi.set(__self__, "max_client_version", max_client_version)
        pulumi.set(__self__, "max_cpu_core", max_cpu_core)
        pulumi.set(__self__, "max_worker", max_worker)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "private_ipv4", private_ipv4)
        pulumi.set(__self__, "proxy_host", proxy_host)
        pulumi.set(__self__, "proxy_password", proxy_password)
        pulumi.set(__self__, "proxy_port", proxy_port)
        pulumi.set(__self__, "proxy_user", proxy_user)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "use_https", use_https)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="archType")
    def arch_type(self) -> _builtins.str:
        """
        The system architecture of client, only the ECS File Backup Client is available. Valid values: `AMD64` , `386`.
        """
        return pulumi.get(self, "arch_type")

    @_builtins.property
    @pulumi.getter(name="backupStatus")
    def backup_status(self) -> _builtins.str:
        """
        Client protected status. Valid values: `UNPROTECTED`, `PROTECTED`.
        """
        return pulumi.get(self, "backup_status")

    @_builtins.property
    @pulumi.getter(name="clientType")
    def client_type(self) -> _builtins.str:
        """
        The type of client. Valid values: `ECS_CLIENT` (ECS File Backup Client).
        """
        return pulumi.get(self, "client_type")

    @_builtins.property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> _builtins.str:
        """
        The version of client.
        """
        return pulumi.get(self, "client_version")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of client. Unix time in seconds.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataNetworkType")
    def data_network_type(self) -> _builtins.str:
        """
        The data plane access point type. Valid Values: `PUBLIC`, `VPC`, `CLASSIC`.
        """
        return pulumi.get(self, "data_network_type")

    @_builtins.property
    @pulumi.getter(name="dataProxySetting")
    def data_proxy_setting(self) -> _builtins.str:
        """
        The data plane proxy settings. Valid Values: `DISABLE`, `USE_CONTROL_PROXY`, `CUSTOM`.
        * `USE_CONTROL_PROXY` (Default, the same with control plane)
        * `CUSTOM` (Custom configuration items for the HTTP protocol).
        """
        return pulumi.get(self, "data_proxy_setting")

    @_builtins.property
    @pulumi.getter(name="ecsBackupClientId")
    def ecs_backup_client_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "ecs_backup_client_id")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The hostname of ECS instance.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Ecs Backup Client.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of ECS instance. When the client type is ECS file backup client, it indicates the ID of ECS instance. When the client type is a local file backup client, it is a hardware fingerprint generated based on system information.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        """
        The name of ECS instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="lastHeartBeatTime")
    def last_heart_beat_time(self) -> _builtins.str:
        """
        The last heartbeat time of client. Unix Time Seconds.
        """
        return pulumi.get(self, "last_heart_beat_time")

    @_builtins.property
    @pulumi.getter(name="maxClientVersion")
    def max_client_version(self) -> _builtins.str:
        """
        The latest version of client.
        """
        return pulumi.get(self, "max_client_version")

    @_builtins.property
    @pulumi.getter(name="maxCpuCore")
    def max_cpu_core(self) -> _builtins.str:
        """
        The number of CPU cores used by a single backup task, 0 means no restrictions.
        """
        return pulumi.get(self, "max_cpu_core")

    @_builtins.property
    @pulumi.getter(name="maxWorker")
    def max_worker(self) -> _builtins.str:
        """
        The number of concurrent jobs for a single backup task, 0 means no restrictions.
        """
        return pulumi.get(self, "max_worker")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> _builtins.str:
        """
        The operating system type of client, only the ECS File Backup Client is available. Valid values: `windows`, `linux`.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter(name="privateIpv4")
    def private_ipv4(self) -> _builtins.str:
        """
        Intranet IP address of the instance, only available for ECS file backup client.
        """
        return pulumi.get(self, "private_ipv4")

    @_builtins.property
    @pulumi.getter(name="proxyHost")
    def proxy_host(self) -> _builtins.str:
        """
        Custom data plane proxy server host address.
        """
        return pulumi.get(self, "proxy_host")

    @_builtins.property
    @pulumi.getter(name="proxyPassword")
    def proxy_password(self) -> _builtins.str:
        """
        The password of custom data plane proxy server.
        """
        return pulumi.get(self, "proxy_password")

    @_builtins.property
    @pulumi.getter(name="proxyPort")
    def proxy_port(self) -> _builtins.str:
        """
        Custom data plane proxy server host port.
        """
        return pulumi.get(self, "proxy_port")

    @_builtins.property
    @pulumi.getter(name="proxyUser")
    def proxy_user(self) -> _builtins.str:
        """
        The username of custom data plane proxy server.
        """
        return pulumi.get(self, "proxy_user")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> _builtins.str:
        """
        The update time of client. Unix Time Seconds.
        """
        return pulumi.get(self, "updated_time")

    @_builtins.property
    @pulumi.getter(name="useHttps")
    def use_https(self) -> _builtins.bool:
        """
        Indicates whether to use the HTTPS protocol. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "use_https")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The ID of Zone.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetEcsBackupPlansPlanResult(dict):
    def __init__(__self__, *,
                 backup_type: _builtins.str,
                 create_time: _builtins.str,
                 created_time: _builtins.str,
                 detail: _builtins.str,
                 disabled: _builtins.bool,
                 ecs_backup_plan_id: _builtins.str,
                 ecs_backup_plan_name: _builtins.str,
                 exclude: _builtins.str,
                 id: _builtins.str,
                 include: _builtins.str,
                 instance_id: _builtins.str,
                 options: _builtins.str,
                 paths: Sequence[_builtins.str],
                 retention: _builtins.str,
                 schedule: _builtins.str,
                 source_type: _builtins.str,
                 speed_limit: _builtins.str,
                 updated_time: _builtins.str,
                 vault_id: _builtins.str):
        """
        :param _builtins.str backup_type: Backup type. Valid values: `COMPLETE`.
        :param _builtins.str created_time: The creation time of the backup plan. UNIX time in seconds.
        :param _builtins.bool disabled: Whether to be suspended. Valid values: `true`, `false`.
        :param _builtins.str ecs_backup_plan_id: The ID of ecs backup plan.
        :param _builtins.str ecs_backup_plan_name: The name of the backup plan.
        :param _builtins.str exclude: Exclude path. String of Json list. Up to 255 characters. e.g. `"[\\"/home/work\\"]"`
        :param _builtins.str id: The ID of ecs backup plan.
        :param _builtins.str include: Include path. String of Json list. Up to 255 characters. e.g. `"[\\"/var\\"]"`
        :param _builtins.str instance_id: The ID of ECS instance.
        :param _builtins.str options: Windows operating system with application consistency using VSS. eg: {`UseVSS`:false}.
        :param Sequence[_builtins.str] paths: Backup path. e.g. `["/home", "/var"]`
        :param _builtins.str retention: Backup retention days, the minimum is 1.
        :param _builtins.str schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
               * `startTime` Backup start time, UNIX time seconds.
        :param _builtins.str source_type: The type of backup source.
        :param _builtins.str speed_limit: Flow control. The format is: {start}|{end}|{bandwidth}. Use `|` to separate multiple flow control configurations, multiple flow control configurations not allowed to have overlapping times.
        :param _builtins.str updated_time: The update time of the backup plan. UNIX time in seconds.
        :param _builtins.str vault_id: The ID of Backup vault.
        """
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "detail", detail)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "ecs_backup_plan_id", ecs_backup_plan_id)
        pulumi.set(__self__, "ecs_backup_plan_name", ecs_backup_plan_name)
        pulumi.set(__self__, "exclude", exclude)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "include", include)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "speed_limit", speed_limit)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> _builtins.str:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        The creation time of the backup plan. UNIX time in seconds.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def detail(self) -> _builtins.str:
        return pulumi.get(self, "detail")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> _builtins.bool:
        """
        Whether to be suspended. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="ecsBackupPlanId")
    def ecs_backup_plan_id(self) -> _builtins.str:
        """
        The ID of ecs backup plan.
        """
        return pulumi.get(self, "ecs_backup_plan_id")

    @_builtins.property
    @pulumi.getter(name="ecsBackupPlanName")
    def ecs_backup_plan_name(self) -> _builtins.str:
        """
        The name of the backup plan.
        """
        return pulumi.get(self, "ecs_backup_plan_name")

    @_builtins.property
    @pulumi.getter
    def exclude(self) -> _builtins.str:
        """
        Exclude path. String of Json list. Up to 255 characters. e.g. `"[\\"/home/work\\"]"`
        """
        return pulumi.get(self, "exclude")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of ecs backup plan.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def include(self) -> _builtins.str:
        """
        Include path. String of Json list. Up to 255 characters. e.g. `"[\\"/var\\"]"`
        """
        return pulumi.get(self, "include")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def options(self) -> _builtins.str:
        """
        Windows operating system with application consistency using VSS. eg: {`UseVSS`:false}.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Sequence[_builtins.str]:
        """
        Backup path. e.g. `["/home", "/var"]`
        """
        return pulumi.get(self, "paths")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> _builtins.str:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> _builtins.str:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        * `startTime` Backup start time, UNIX time seconds.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The type of backup source.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="speedLimit")
    def speed_limit(self) -> _builtins.str:
        """
        Flow control. The format is: {start}|{end}|{bandwidth}. Use `|` to separate multiple flow control configurations, multiple flow control configurations not allowed to have overlapping times.
        """
        return pulumi.get(self, "speed_limit")

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> _builtins.str:
        """
        The update time of the backup plan. UNIX time in seconds.
        """
        return pulumi.get(self, "updated_time")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The ID of Backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetHanaBackupClientsHanaBackupClientResult(dict):
    def __init__(__self__, *,
                 alert_setting: _builtins.str,
                 client_id: _builtins.str,
                 client_name: _builtins.str,
                 client_type: _builtins.str,
                 client_version: _builtins.str,
                 cluster_id: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 instance_name: _builtins.str,
                 max_version: _builtins.str,
                 network_type: _builtins.str,
                 status: _builtins.str,
                 status_message: _builtins.str,
                 use_https: _builtins.bool,
                 vault_id: _builtins.str):
        """
        :param _builtins.str alert_setting: The alert settings.
        :param _builtins.str client_id: The ID of the backup client.
        :param _builtins.str client_name: The name of the backup client.
        :param _builtins.str client_type: The type of the backup client.
        :param _builtins.str client_version: The version number of the backup client.
        :param _builtins.str cluster_id: The ID of the SAP HANA instance.
        :param _builtins.str id: The id of the Hana Backup Client. It formats as `<vault_id>:<client_id>`.
        :param _builtins.str instance_id: The ID of the instance.
        :param _builtins.str instance_name: The name of the ECS instance.
        :param _builtins.str max_version: The maximum version number of the backup client.
        :param _builtins.str network_type: The network type.
        :param _builtins.str status: The status of the Hana Backup Client. Valid Values: `REGISTERED`, `ACTIVATED`, `DEACTIVATED`, `INSTALLING`, `INSTALL_FAILED`, `NOT_INSTALLED`, `UPGRADING`, `UPGRADE_FAILED`, `UNINSTALLING`, `UNINSTALL_FAILED`, `STOPPED`, `UNKNOWN`.
        :param _builtins.str status_message: The status information.
        :param _builtins.bool use_https: Indicates whether data is transmitted over HTTPS.
        :param _builtins.str vault_id: The ID of the backup vault.
        """
        pulumi.set(__self__, "alert_setting", alert_setting)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_name", client_name)
        pulumi.set(__self__, "client_type", client_type)
        pulumi.set(__self__, "client_version", client_version)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "max_version", max_version)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_message", status_message)
        pulumi.set(__self__, "use_https", use_https)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="alertSetting")
    def alert_setting(self) -> _builtins.str:
        """
        The alert settings.
        """
        return pulumi.get(self, "alert_setting")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        The ID of the backup client.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientName")
    def client_name(self) -> _builtins.str:
        """
        The name of the backup client.
        """
        return pulumi.get(self, "client_name")

    @_builtins.property
    @pulumi.getter(name="clientType")
    def client_type(self) -> _builtins.str:
        """
        The type of the backup client.
        """
        return pulumi.get(self, "client_type")

    @_builtins.property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> _builtins.str:
        """
        The version number of the backup client.
        """
        return pulumi.get(self, "client_version")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the SAP HANA instance.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the Hana Backup Client. It formats as `<vault_id>:<client_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        """
        The name of the ECS instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="maxVersion")
    def max_version(self) -> _builtins.str:
        """
        The maximum version number of the backup client.
        """
        return pulumi.get(self, "max_version")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        The network type.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Hana Backup Client. Valid Values: `REGISTERED`, `ACTIVATED`, `DEACTIVATED`, `INSTALLING`, `INSTALL_FAILED`, `NOT_INSTALLED`, `UPGRADING`, `UPGRADE_FAILED`, `UNINSTALLING`, `UNINSTALL_FAILED`, `STOPPED`, `UNKNOWN`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> _builtins.str:
        """
        The status information.
        """
        return pulumi.get(self, "status_message")

    @_builtins.property
    @pulumi.getter(name="useHttps")
    def use_https(self) -> _builtins.bool:
        """
        Indicates whether data is transmitted over HTTPS.
        """
        return pulumi.get(self, "use_https")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The ID of the backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetHanaBackupPlansPlanResult(dict):
    def __init__(__self__, *,
                 backup_prefix: _builtins.str,
                 backup_type: _builtins.str,
                 cluster_id: _builtins.str,
                 database_name: _builtins.str,
                 id: _builtins.str,
                 page_total: _builtins.str,
                 plan_id: _builtins.str,
                 plan_name: _builtins.str,
                 schedule: _builtins.str,
                 status: _builtins.str,
                 vault_id: _builtins.str):
        """
        :param _builtins.str backup_prefix: The backup prefix.
        :param _builtins.str backup_type: The backup type.
        :param _builtins.str cluster_id: The ID of the SAP HANA instance.
        :param _builtins.str database_name: The name of the database.
        :param _builtins.str id: The ID of the resource.
        :param _builtins.str plan_id: The ID of the backup plan.
        :param _builtins.str plan_name: The name of the backup plan.
        :param _builtins.str schedule: The backup policy.
        :param _builtins.str status: The status of the resource.
        :param _builtins.str vault_id: The ID of the backup vault.
        """
        pulumi.set(__self__, "backup_prefix", backup_prefix)
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "page_total", page_total)
        pulumi.set(__self__, "plan_id", plan_id)
        pulumi.set(__self__, "plan_name", plan_name)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="backupPrefix")
    def backup_prefix(self) -> _builtins.str:
        """
        The backup prefix.
        """
        return pulumi.get(self, "backup_prefix")

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> _builtins.str:
        """
        The backup type.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the SAP HANA instance.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> _builtins.str:
        """
        The name of the database.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="pageTotal")
    def page_total(self) -> _builtins.str:
        return pulumi.get(self, "page_total")

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> _builtins.str:
        """
        The ID of the backup plan.
        """
        return pulumi.get(self, "plan_id")

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> _builtins.str:
        """
        The name of the backup plan.
        """
        return pulumi.get(self, "plan_name")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> _builtins.str:
        """
        The backup policy.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The ID of the backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetHanaInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 alert_setting: _builtins.str,
                 hana_instance_id: _builtins.str,
                 hana_name: _builtins.str,
                 host: _builtins.str,
                 id: _builtins.str,
                 instance_number: _builtins.int,
                 resource_group_id: _builtins.str,
                 status: _builtins.str,
                 status_message: _builtins.str,
                 use_ssl: _builtins.bool,
                 user_name: _builtins.str,
                 validate_certificate: _builtins.bool,
                 vault_id: _builtins.str):
        """
        :param _builtins.str alert_setting: The alert settings. Valid value: `INHERITED`, which indicates that the backup client sends alert notifications in the same way as the backup vault.
        :param _builtins.str hana_instance_id: The ID of the SAP HANA instance.
        :param _builtins.str hana_name: The name of the SAP HANA instance.
        :param _builtins.str host: The private or internal IP address of the host where the primary node of the SAP HANA instance resides.
        :param _builtins.str id: The ID of the Hana Instance. The value formats as `<vault_id>:<hana_instance_id>`.
        :param _builtins.int instance_number: The instance number of the SAP HANA system.
        :param _builtins.str resource_group_id: The ID of the resource group.
        :param _builtins.str status: The status of the SAP HANA instance.
        :param _builtins.str status_message: The status information.
        :param _builtins.bool use_ssl: Indicates whether the SAP HANA instance is connected over Secure Sockets Layer (SSL).
        :param _builtins.str user_name: The username of the SYSTEMDB database.
        :param _builtins.bool validate_certificate: Indicates whether the SSL certificate of the SAP HANA instance is verified.
        :param _builtins.str vault_id: The ID of the backup vault.
        """
        pulumi.set(__self__, "alert_setting", alert_setting)
        pulumi.set(__self__, "hana_instance_id", hana_instance_id)
        pulumi.set(__self__, "hana_name", hana_name)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_number", instance_number)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_message", status_message)
        pulumi.set(__self__, "use_ssl", use_ssl)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "validate_certificate", validate_certificate)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="alertSetting")
    def alert_setting(self) -> _builtins.str:
        """
        The alert settings. Valid value: `INHERITED`, which indicates that the backup client sends alert notifications in the same way as the backup vault.
        """
        return pulumi.get(self, "alert_setting")

    @_builtins.property
    @pulumi.getter(name="hanaInstanceId")
    def hana_instance_id(self) -> _builtins.str:
        """
        The ID of the SAP HANA instance.
        """
        return pulumi.get(self, "hana_instance_id")

    @_builtins.property
    @pulumi.getter(name="hanaName")
    def hana_name(self) -> _builtins.str:
        """
        The name of the SAP HANA instance.
        """
        return pulumi.get(self, "hana_name")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The private or internal IP address of the host where the primary node of the SAP HANA instance resides.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Hana Instance. The value formats as `<vault_id>:<hana_instance_id>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> _builtins.int:
        """
        The instance number of the SAP HANA system.
        """
        return pulumi.get(self, "instance_number")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the SAP HANA instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> _builtins.str:
        """
        The status information.
        """
        return pulumi.get(self, "status_message")

    @_builtins.property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> _builtins.bool:
        """
        Indicates whether the SAP HANA instance is connected over Secure Sockets Layer (SSL).
        """
        return pulumi.get(self, "use_ssl")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        The username of the SYSTEMDB database.
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter(name="validateCertificate")
    def validate_certificate(self) -> _builtins.bool:
        """
        Indicates whether the SSL certificate of the SAP HANA instance is verified.
        """
        return pulumi.get(self, "validate_certificate")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The ID of the backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetNasBackupPlansPlanResult(dict):
    def __init__(__self__, *,
                 backup_type: _builtins.str,
                 create_time: _builtins.str,
                 created_time: _builtins.str,
                 disabled: _builtins.bool,
                 file_system_id: _builtins.str,
                 id: _builtins.str,
                 nas_backup_plan_id: _builtins.str,
                 nas_backup_plan_name: _builtins.str,
                 options: _builtins.str,
                 paths: Sequence[_builtins.str],
                 retention: _builtins.str,
                 schedule: _builtins.str,
                 updated_time: _builtins.str,
                 vault_id: _builtins.str):
        """
        :param _builtins.str backup_type: Backup type. Valid values: `COMPLETE`.
        :param _builtins.str create_time: File System Creation Time. **Note** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST`.
        :param _builtins.str created_time: The creation time of the backup plan. UNIX time in seconds.
        :param _builtins.bool disabled: Whether to be suspended. Valid values: `true`, `false`.
        :param _builtins.str file_system_id: The File System ID of Nas.
        :param _builtins.str id: The ID of Nas backup plan.
        :param _builtins.str nas_backup_plan_id: The ID of Nas backup plan.
        :param _builtins.str nas_backup_plan_name: The name of the resource.
        :param _builtins.str options: Options field of Nas backup plan.
        :param Sequence[_builtins.str] paths: List of backup path. Up to 65536 Characters. e.g.`["/home", "/var"]`
        :param _builtins.str retention: Backup retention days, the minimum is 1.
        :param _builtins.str schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
               * `startTime` Backup start time, UNIX time seconds.
        :param _builtins.str updated_time: The update time of the backup plan. UNIX time in seconds.
        :param _builtins.str vault_id: The ID of backup vault.
        """
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "nas_backup_plan_id", nas_backup_plan_id)
        pulumi.set(__self__, "nas_backup_plan_name", nas_backup_plan_name)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> _builtins.str:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        File System Creation Time. **Note** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST`.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        The creation time of the backup plan. UNIX time in seconds.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> _builtins.bool:
        """
        Whether to be suspended. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> _builtins.str:
        """
        The File System ID of Nas.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of Nas backup plan.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nasBackupPlanId")
    def nas_backup_plan_id(self) -> _builtins.str:
        """
        The ID of Nas backup plan.
        """
        return pulumi.get(self, "nas_backup_plan_id")

    @_builtins.property
    @pulumi.getter(name="nasBackupPlanName")
    def nas_backup_plan_name(self) -> _builtins.str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "nas_backup_plan_name")

    @_builtins.property
    @pulumi.getter
    def options(self) -> _builtins.str:
        """
        Options field of Nas backup plan.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Sequence[_builtins.str]:
        """
        List of backup path. Up to 65536 Characters. e.g.`["/home", "/var"]`
        """
        return pulumi.get(self, "paths")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> _builtins.str:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> _builtins.str:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        * `startTime` Backup start time, UNIX time seconds.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> _builtins.str:
        """
        The update time of the backup plan. UNIX time in seconds.
        """
        return pulumi.get(self, "updated_time")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetOssBackupPlansPlanResult(dict):
    def __init__(__self__, *,
                 backup_type: _builtins.str,
                 bucket: _builtins.str,
                 created_time: _builtins.str,
                 disabled: _builtins.bool,
                 id: _builtins.str,
                 oss_backup_plan_id: _builtins.str,
                 oss_backup_plan_name: _builtins.str,
                 prefix: _builtins.str,
                 retention: _builtins.str,
                 schedule: _builtins.str,
                 updated_time: _builtins.str,
                 vault_id: _builtins.str):
        """
        :param _builtins.str backup_type: Backup type. Valid values: `COMPLETE`.
        :param _builtins.str bucket: The name of OSS bucket.
        :param _builtins.str created_time: The creation time of the backup plan. UNIX time in seconds.
        :param _builtins.bool disabled: Whether to be suspended. Valid values: `true`, `false`.
        :param _builtins.str id: The ID of Oss backup plan.
        :param _builtins.str oss_backup_plan_id: The ID of Oss backup plan.
        :param _builtins.str oss_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param _builtins.str prefix: Backup prefix.
        :param _builtins.str retention: Backup retention days, the minimum is 1.
        :param _builtins.str schedule: Backup strategy. Optional format: I|{startTime}|{interval}. It means to execute a backup task every {interval} starting from {startTime}. The backup task for the elapsed time will not be compensated. If the last backup task is not completed yet, the next backup task will not be triggered.
               * `startTime` Backup start time, UNIX time seconds.
        :param _builtins.str updated_time: The update time of the backup plan. UNIX time in seconds.
        :param _builtins.str vault_id: The ID of backup vault.
        """
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "oss_backup_plan_id", oss_backup_plan_id)
        pulumi.set(__self__, "oss_backup_plan_name", oss_backup_plan_name)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> _builtins.str:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of OSS bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        The creation time of the backup plan. UNIX time in seconds.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> _builtins.bool:
        """
        Whether to be suspended. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of Oss backup plan.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ossBackupPlanId")
    def oss_backup_plan_id(self) -> _builtins.str:
        """
        The ID of Oss backup plan.
        """
        return pulumi.get(self, "oss_backup_plan_id")

    @_builtins.property
    @pulumi.getter(name="ossBackupPlanName")
    def oss_backup_plan_name(self) -> _builtins.str:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "oss_backup_plan_name")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        Backup prefix.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> _builtins.str:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> _builtins.str:
        """
        Backup strategy. Optional format: I|{startTime}|{interval}. It means to execute a backup task every {interval} starting from {startTime}. The backup task for the elapsed time will not be compensated. If the last backup task is not completed yet, the next backup task will not be triggered.
        * `startTime` Backup start time, UNIX time seconds.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> _builtins.str:
        """
        The update time of the backup plan. UNIX time in seconds.
        """
        return pulumi.get(self, "updated_time")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetOtsBackupPlansPlanResult(dict):
    def __init__(__self__, *,
                 backup_type: _builtins.str,
                 created_time: _builtins.str,
                 disabled: _builtins.bool,
                 id: _builtins.str,
                 ots_backup_plan_id: _builtins.str,
                 ots_backup_plan_name: _builtins.str,
                 ots_details: Sequence['outputs.GetOtsBackupPlansPlanOtsDetailResult'],
                 retention: _builtins.str,
                 schedule: _builtins.str,
                 source_type: _builtins.str,
                 updated_time: _builtins.str,
                 vault_id: _builtins.str):
        """
        :param _builtins.str backup_type: The Backup type. Valid values: `COMPLETE`.
        :param _builtins.str created_time: The creation time of the backup plan. UNIX time in seconds.
        :param _builtins.bool disabled: Whether to be suspended. Valid values: `true`, `false`.
        :param _builtins.str id: The ID of ots backup plan.
        :param _builtins.str ots_backup_plan_id: The ID of ots backup plan.
        :param _builtins.str ots_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param _builtins.str retention: The Backup retention days, the minimum is 1.
        :param _builtins.str schedule: The Backup strategy. Optional format: I|{startTime}|{interval}. It means to execute a backup task every {interval} starting from {startTime}. The backup task for the elapsed time will not be compensated. If the last backup task is not completed yet, the next backup task will not be triggered.
               * `startTime` Backup start time, UNIX time seconds.
        :param _builtins.str source_type: The type of the data source.
        :param _builtins.str updated_time: The update time of the backup plan. UNIX time in seconds.
               *ots_detail - The details about the Tablestore instance.
        :param _builtins.str vault_id: The ID of backup vault.
        """
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ots_backup_plan_id", ots_backup_plan_id)
        pulumi.set(__self__, "ots_backup_plan_name", ots_backup_plan_name)
        pulumi.set(__self__, "ots_details", ots_details)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> _builtins.str:
        """
        The Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        The creation time of the backup plan. UNIX time in seconds.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> _builtins.bool:
        """
        Whether to be suspended. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of ots backup plan.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="otsBackupPlanId")
    def ots_backup_plan_id(self) -> _builtins.str:
        """
        The ID of ots backup plan.
        """
        return pulumi.get(self, "ots_backup_plan_id")

    @_builtins.property
    @pulumi.getter(name="otsBackupPlanName")
    def ots_backup_plan_name(self) -> _builtins.str:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "ots_backup_plan_name")

    @_builtins.property
    @pulumi.getter(name="otsDetails")
    def ots_details(self) -> Sequence['outputs.GetOtsBackupPlansPlanOtsDetailResult']:
        return pulumi.get(self, "ots_details")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> _builtins.str:
        """
        The Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> _builtins.str:
        """
        The Backup strategy. Optional format: I|{startTime}|{interval}. It means to execute a backup task every {interval} starting from {startTime}. The backup task for the elapsed time will not be compensated. If the last backup task is not completed yet, the next backup task will not be triggered.
        * `startTime` Backup start time, UNIX time seconds.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The type of the data source.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> _builtins.str:
        """
        The update time of the backup plan. UNIX time in seconds.
        *ots_detail - The details about the Tablestore instance.
        """
        return pulumi.get(self, "updated_time")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetOtsBackupPlansPlanOtsDetailResult(dict):
    def __init__(__self__, *,
                 table_names: Sequence[_builtins.str]):
        pulumi.set(__self__, "table_names", table_names)

    @_builtins.property
    @pulumi.getter(name="tableNames")
    def table_names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "table_names")


@pulumi.output_type
class GetOtsSnapshotsSnapshotResult(dict):
    def __init__(__self__, *,
                 actual_bytes: _builtins.str,
                 backup_type: _builtins.str,
                 bytes_total: _builtins.str,
                 complete_time: _builtins.str,
                 create_time: _builtins.str,
                 created_time: _builtins.str,
                 id: _builtins.str,
                 instance_name: _builtins.str,
                 job_id: _builtins.str,
                 parent_snapshot_hash: _builtins.str,
                 range_end: _builtins.str,
                 range_start: _builtins.str,
                 retention: _builtins.str,
                 snapshot_hash: _builtins.str,
                 snapshot_id: _builtins.str,
                 source_type: _builtins.str,
                 start_time: _builtins.str,
                 status: _builtins.str,
                 table_name: _builtins.str,
                 updated_time: _builtins.str,
                 vault_id: _builtins.str):
        """
        :param _builtins.str actual_bytes: The actual amount of backup snapshots after duplicates are removed. Unit: bytes.
        :param _builtins.str backup_type: The backup type. Valid value: `COMPLETE`, which indicates full backup.
        :param _builtins.str bytes_total: The total amount of data. Unit: bytes.
        :param _builtins.str complete_time: The time when the backup snapshot was completed. This value is a UNIX timestamp. Unit: seconds.
        :param _builtins.str create_time: The time when the Table store instance was created. This value is a UNIX timestamp. Unit: seconds.
        :param _builtins.str created_time: The time when the backup snapshot was created. This value is a UNIX timestamp. Unit: seconds.
        :param _builtins.str id: The ID of the backup snapshot.
        :param _builtins.str instance_name: The name of the Table store instance.
        :param _builtins.str job_id: The ID of the backup job.
        :param _builtins.str parent_snapshot_hash: The hash value of the parent backup snapshot.
        :param _builtins.str range_end: The time when the backup job ended. This value is a UNIX timestamp. Unit: milliseconds.
        :param _builtins.str range_start: The time when the backup job started. This value is a UNIX timestamp. Unit: milliseconds.
        :param _builtins.str retention: The retention period of the backup snapshot.
        :param _builtins.str snapshot_hash: The hash value of the backup snapshot.
        :param _builtins.str snapshot_id: The ID of the backup snapshot.
        :param _builtins.str source_type: The type of the data source. Valid values: `ECS_FILE`,`PARTIAL_COMPLETE`,`FAILED`
        :param _builtins.str start_time: The start time of the backup snapshot. This value is a UNIX timestamp. Unit: seconds.
        :param _builtins.str status: The status of the backup job. Valid values: `COMPLETE`,`PARTIAL_COMPLETE`,`FAILED`.
        :param _builtins.str table_name: The name of the table in the Table store instance.
        :param _builtins.str updated_time: The time when the backup snapshot was updated. This value is a UNIX timestamp. Unit: seconds.
        :param _builtins.str vault_id: The ID of the backup vault that stores the backup snapshot.
        """
        pulumi.set(__self__, "actual_bytes", actual_bytes)
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "bytes_total", bytes_total)
        pulumi.set(__self__, "complete_time", complete_time)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "parent_snapshot_hash", parent_snapshot_hash)
        pulumi.set(__self__, "range_end", range_end)
        pulumi.set(__self__, "range_start", range_start)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "snapshot_hash", snapshot_hash)
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="actualBytes")
    def actual_bytes(self) -> _builtins.str:
        """
        The actual amount of backup snapshots after duplicates are removed. Unit: bytes.
        """
        return pulumi.get(self, "actual_bytes")

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> _builtins.str:
        """
        The backup type. Valid value: `COMPLETE`, which indicates full backup.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="bytesTotal")
    def bytes_total(self) -> _builtins.str:
        """
        The total amount of data. Unit: bytes.
        """
        return pulumi.get(self, "bytes_total")

    @_builtins.property
    @pulumi.getter(name="completeTime")
    def complete_time(self) -> _builtins.str:
        """
        The time when the backup snapshot was completed. This value is a UNIX timestamp. Unit: seconds.
        """
        return pulumi.get(self, "complete_time")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the Table store instance was created. This value is a UNIX timestamp. Unit: seconds.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        The time when the backup snapshot was created. This value is a UNIX timestamp. Unit: seconds.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the backup snapshot.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        """
        The name of the Table store instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> _builtins.str:
        """
        The ID of the backup job.
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="parentSnapshotHash")
    def parent_snapshot_hash(self) -> _builtins.str:
        """
        The hash value of the parent backup snapshot.
        """
        return pulumi.get(self, "parent_snapshot_hash")

    @_builtins.property
    @pulumi.getter(name="rangeEnd")
    def range_end(self) -> _builtins.str:
        """
        The time when the backup job ended. This value is a UNIX timestamp. Unit: milliseconds.
        """
        return pulumi.get(self, "range_end")

    @_builtins.property
    @pulumi.getter(name="rangeStart")
    def range_start(self) -> _builtins.str:
        """
        The time when the backup job started. This value is a UNIX timestamp. Unit: milliseconds.
        """
        return pulumi.get(self, "range_start")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> _builtins.str:
        """
        The retention period of the backup snapshot.
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter(name="snapshotHash")
    def snapshot_hash(self) -> _builtins.str:
        """
        The hash value of the backup snapshot.
        """
        return pulumi.get(self, "snapshot_hash")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> _builtins.str:
        """
        The ID of the backup snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The type of the data source. Valid values: `ECS_FILE`,`PARTIAL_COMPLETE`,`FAILED`
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        The start time of the backup snapshot. This value is a UNIX timestamp. Unit: seconds.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the backup job. Valid values: `COMPLETE`,`PARTIAL_COMPLETE`,`FAILED`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> _builtins.str:
        """
        The name of the table in the Table store instance.
        """
        return pulumi.get(self, "table_name")

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> _builtins.str:
        """
        The time when the backup snapshot was updated. This value is a UNIX timestamp. Unit: seconds.
        """
        return pulumi.get(self, "updated_time")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The ID of the backup vault that stores the backup snapshot.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetReplicationVaultRegionsRegionResult(dict):
    def __init__(__self__, *,
                 replication_region_id: _builtins.str):
        """
        :param _builtins.str replication_region_id: The ID of the replication region.
        """
        pulumi.set(__self__, "replication_region_id", replication_region_id)

    @_builtins.property
    @pulumi.getter(name="replicationRegionId")
    def replication_region_id(self) -> _builtins.str:
        """
        The ID of the replication region.
        """
        return pulumi.get(self, "replication_region_id")


@pulumi.output_type
class GetRestoreJobsJobResult(dict):
    def __init__(__self__, *,
                 actual_bytes: _builtins.str,
                 actual_items: _builtins.str,
                 bytes_done: _builtins.str,
                 bytes_total: _builtins.str,
                 complete_time: _builtins.str,
                 create_time: _builtins.str,
                 error_file: _builtins.str,
                 error_message: _builtins.str,
                 expire_time: _builtins.str,
                 id: _builtins.str,
                 items_done: _builtins.str,
                 items_total: _builtins.str,
                 options: _builtins.str,
                 parent_id: _builtins.str,
                 progress: _builtins.int,
                 restore_job_id: _builtins.str,
                 restore_type: _builtins.str,
                 snapshot_hash: _builtins.str,
                 snapshot_id: _builtins.str,
                 source_type: _builtins.str,
                 start_time: _builtins.str,
                 status: _builtins.str,
                 target_bucket: _builtins.str,
                 target_client_id: _builtins.str,
                 target_create_time: _builtins.str,
                 target_data_source_id: _builtins.str,
                 target_file_system_id: _builtins.str,
                 target_instance_id: _builtins.str,
                 target_path: _builtins.str,
                 target_prefix: _builtins.str,
                 updated_time: _builtins.str,
                 vault_id: _builtins.str):
        """
        :param _builtins.str actual_bytes: The actual size of Snapshot.
        :param _builtins.str actual_items: The actual number of files.
        :param _builtins.str bytes_done: The size of restore job recovered.
        :param _builtins.str bytes_total: The total size of restore job recovered.
        :param _builtins.str complete_time: The completion time of restore Job.
        :param _builtins.str create_time: The creation time of restore job.
        :param _builtins.str error_message: The error message of recovery task execution.
        :param _builtins.str expire_time: The expiration time of restore job. Unix Time in seconds.
        :param _builtins.str id: The ID of the restore job.
        :param _builtins.str items_done: The number of items restore job recovered.
        :param _builtins.str items_total: The total number of items restore job recovered.
        :param _builtins.str options: Recovery Options.
        :param _builtins.int progress: The recovery progress.
        :param _builtins.str restore_job_id: The ID of restore job.
        :param _builtins.str restore_type: The type of recovery destination. Valid Values: `ECS_FILE`, `OSS`, `NAS`.
        :param _builtins.str snapshot_hash: The hashcode of Snapshot.
        :param _builtins.str snapshot_id: The ID of Snapshot.
        :param _builtins.str source_type: The list of data source types. Valid values: `ECS_FILE`, `NAS`, `OSS`, `OTS_TABLE`,`UDM_ECS_ROLLBACK`.
        :param _builtins.str start_time: The start time of restore job. Unix Time in Seconds.
        :param _builtins.str status: The status of restore job.
        :param _builtins.str target_bucket: The name of target ofo OSS bucket.
        :param _builtins.str target_create_time: The creation time of destination file system.
        :param _builtins.str target_file_system_id: The ID of destination file system.
        :param _builtins.str target_instance_id: The ID of target ECS instance.
        :param _builtins.str target_path: The target file path of ECS instance.
        :param _builtins.str target_prefix: The file prefix of target OSS object.
        :param _builtins.str updated_time: The update Time of restore job. Unix Time in Seconds.
        :param _builtins.str vault_id: The ID of backup vault.
        """
        pulumi.set(__self__, "actual_bytes", actual_bytes)
        pulumi.set(__self__, "actual_items", actual_items)
        pulumi.set(__self__, "bytes_done", bytes_done)
        pulumi.set(__self__, "bytes_total", bytes_total)
        pulumi.set(__self__, "complete_time", complete_time)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "error_file", error_file)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "items_done", items_done)
        pulumi.set(__self__, "items_total", items_total)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "parent_id", parent_id)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "restore_job_id", restore_job_id)
        pulumi.set(__self__, "restore_type", restore_type)
        pulumi.set(__self__, "snapshot_hash", snapshot_hash)
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "target_bucket", target_bucket)
        pulumi.set(__self__, "target_client_id", target_client_id)
        pulumi.set(__self__, "target_create_time", target_create_time)
        pulumi.set(__self__, "target_data_source_id", target_data_source_id)
        pulumi.set(__self__, "target_file_system_id", target_file_system_id)
        pulumi.set(__self__, "target_instance_id", target_instance_id)
        pulumi.set(__self__, "target_path", target_path)
        pulumi.set(__self__, "target_prefix", target_prefix)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="actualBytes")
    def actual_bytes(self) -> _builtins.str:
        """
        The actual size of Snapshot.
        """
        return pulumi.get(self, "actual_bytes")

    @_builtins.property
    @pulumi.getter(name="actualItems")
    def actual_items(self) -> _builtins.str:
        """
        The actual number of files.
        """
        return pulumi.get(self, "actual_items")

    @_builtins.property
    @pulumi.getter(name="bytesDone")
    def bytes_done(self) -> _builtins.str:
        """
        The size of restore job recovered.
        """
        return pulumi.get(self, "bytes_done")

    @_builtins.property
    @pulumi.getter(name="bytesTotal")
    def bytes_total(self) -> _builtins.str:
        """
        The total size of restore job recovered.
        """
        return pulumi.get(self, "bytes_total")

    @_builtins.property
    @pulumi.getter(name="completeTime")
    def complete_time(self) -> _builtins.str:
        """
        The completion time of restore Job.
        """
        return pulumi.get(self, "complete_time")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of restore job.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="errorFile")
    def error_file(self) -> _builtins.str:
        return pulumi.get(self, "error_file")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> _builtins.str:
        """
        The error message of recovery task execution.
        """
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        The expiration time of restore job. Unix Time in seconds.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the restore job.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="itemsDone")
    def items_done(self) -> _builtins.str:
        """
        The number of items restore job recovered.
        """
        return pulumi.get(self, "items_done")

    @_builtins.property
    @pulumi.getter(name="itemsTotal")
    def items_total(self) -> _builtins.str:
        """
        The total number of items restore job recovered.
        """
        return pulumi.get(self, "items_total")

    @_builtins.property
    @pulumi.getter
    def options(self) -> _builtins.str:
        """
        Recovery Options.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> _builtins.str:
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter
    def progress(self) -> _builtins.int:
        """
        The recovery progress.
        """
        return pulumi.get(self, "progress")

    @_builtins.property
    @pulumi.getter(name="restoreJobId")
    def restore_job_id(self) -> _builtins.str:
        """
        The ID of restore job.
        """
        return pulumi.get(self, "restore_job_id")

    @_builtins.property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> _builtins.str:
        """
        The type of recovery destination. Valid Values: `ECS_FILE`, `OSS`, `NAS`.
        """
        return pulumi.get(self, "restore_type")

    @_builtins.property
    @pulumi.getter(name="snapshotHash")
    def snapshot_hash(self) -> _builtins.str:
        """
        The hashcode of Snapshot.
        """
        return pulumi.get(self, "snapshot_hash")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> _builtins.str:
        """
        The ID of Snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The list of data source types. Valid values: `ECS_FILE`, `NAS`, `OSS`, `OTS_TABLE`,`UDM_ECS_ROLLBACK`.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        The start time of restore job. Unix Time in Seconds.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of restore job.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> _builtins.str:
        """
        The name of target ofo OSS bucket.
        """
        return pulumi.get(self, "target_bucket")

    @_builtins.property
    @pulumi.getter(name="targetClientId")
    def target_client_id(self) -> _builtins.str:
        return pulumi.get(self, "target_client_id")

    @_builtins.property
    @pulumi.getter(name="targetCreateTime")
    def target_create_time(self) -> _builtins.str:
        """
        The creation time of destination file system.
        """
        return pulumi.get(self, "target_create_time")

    @_builtins.property
    @pulumi.getter(name="targetDataSourceId")
    def target_data_source_id(self) -> _builtins.str:
        return pulumi.get(self, "target_data_source_id")

    @_builtins.property
    @pulumi.getter(name="targetFileSystemId")
    def target_file_system_id(self) -> _builtins.str:
        """
        The ID of destination file system.
        """
        return pulumi.get(self, "target_file_system_id")

    @_builtins.property
    @pulumi.getter(name="targetInstanceId")
    def target_instance_id(self) -> _builtins.str:
        """
        The ID of target ECS instance.
        """
        return pulumi.get(self, "target_instance_id")

    @_builtins.property
    @pulumi.getter(name="targetPath")
    def target_path(self) -> _builtins.str:
        """
        The target file path of ECS instance.
        """
        return pulumi.get(self, "target_path")

    @_builtins.property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> _builtins.str:
        """
        The file prefix of target OSS object.
        """
        return pulumi.get(self, "target_prefix")

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> _builtins.str:
        """
        The update Time of restore job. Unix Time in Seconds.
        """
        return pulumi.get(self, "updated_time")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetServerBackupPlansFilterResult(dict):
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 values: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str key: The key of the field to filter. Valid values: `planId`, `instanceId`, `planName`.
        :param Sequence[_builtins.str] values: Set of values that are accepted for the given field.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key of the field to filter. Valid values: `planId`, `instanceId`, `planName`.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        Set of values that are accepted for the given field.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetServerBackupPlansPlanResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 details: Sequence['outputs.GetServerBackupPlansPlanDetailResult'],
                 disabled: _builtins.bool,
                 ecs_server_backup_plan_id: _builtins.str,
                 ecs_server_backup_plan_name: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 retention: _builtins.str,
                 schedule: _builtins.str):
        """
        :param _builtins.str create_time: The creation time of backup plan.
        :param Sequence['GetServerBackupPlansPlanDetailArgs'] details: ECS server backup plan details.
        :param _builtins.bool disabled: Whether to disable the backup task. Valid values: `true`, `false`.
        :param _builtins.str ecs_server_backup_plan_id: The ID of the server backup plan.
        :param _builtins.str ecs_server_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param _builtins.str id: The ID of the server backup plan.
        :param _builtins.str instance_id: The ID of ECS Instance.
        :param _builtins.str retention: Backup retention days, the minimum is 1.
        :param _builtins.str schedule: Backup strategy.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "ecs_server_backup_plan_id", ecs_server_backup_plan_id)
        pulumi.set(__self__, "ecs_server_backup_plan_name", ecs_server_backup_plan_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "schedule", schedule)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of backup plan.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Sequence['outputs.GetServerBackupPlansPlanDetailResult']:
        """
        ECS server backup plan details.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> _builtins.bool:
        """
        Whether to disable the backup task. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="ecsServerBackupPlanId")
    def ecs_server_backup_plan_id(self) -> _builtins.str:
        """
        The ID of the server backup plan.
        """
        return pulumi.get(self, "ecs_server_backup_plan_id")

    @_builtins.property
    @pulumi.getter(name="ecsServerBackupPlanName")
    def ecs_server_backup_plan_name(self) -> _builtins.str:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "ecs_server_backup_plan_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the server backup plan.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of ECS Instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> _builtins.str:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> _builtins.str:
        """
        Backup strategy.
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class GetServerBackupPlansPlanDetailResult(dict):
    def __init__(__self__, *,
                 app_consistent: _builtins.bool,
                 destination_region_id: _builtins.str,
                 destination_retention: _builtins.int,
                 disk_id_lists: Sequence[_builtins.str],
                 do_copy: _builtins.bool,
                 enable_fs_freeze: _builtins.bool,
                 post_script_path: _builtins.str,
                 pre_script_path: _builtins.str,
                 snapshot_group: _builtins.bool,
                 timeout_in_seconds: _builtins.int):
        """
        :param _builtins.bool app_consistent: Whether to turn on application consistency. The application consistency snapshot backs up memory data and ongoing database transactions at the time of snapshot creation to ensure the consistency of application system data and database transactions. By applying consistent snapshots, there is no data damage or loss, so as to avoid log rollback during database startup and ensure that the application is in a consistent startup state. Valid values: `true`, `false`.
        :param _builtins.str destination_region_id: Only vaild when DoCopy is true. The destination region ID when replicating to another region. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param _builtins.int destination_retention: Only vaild when DoCopy is true. The retention days of the destination backup. When not specified, the destination backup will be saved permanently. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        :param Sequence[_builtins.str] disk_id_lists: The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
        :param _builtins.bool do_copy: Whether replicate to another region. Valid values: `true`, `false`.
        :param _builtins.bool enable_fs_freeze: Only the Linux system is valid. Whether to use the Linux FsFreeze mechanism to ensure that the file system is read-only consistent before creating a storage snapshot. The default is True. Valid values: `true`, `false`.
        :param _builtins.str post_script_path: Only vaild for the linux system when AppConsistent is true. The application thaw script path (e.g. /tmp/postscript.sh). The postscript.sh script must meet the following conditions: in terms of permissions, only the root user as the owner has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        :param _builtins.str pre_script_path: Only vaild for the linux system when AppConsistent is true. Apply the freeze script path (e.g. /tmp/prescript.sh). prescript.sh scripts must meet the following conditions: in terms of permissions, only root, as the owner, has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        :param _builtins.bool snapshot_group: Whether to turn on file system consistency. If SnapshotGroup is true, when AppConsistent is true but the relevant conditions are not met or AppConsistent is false, the resulting snapshot will be a file system consistency snapshot. The file system consistency ensures that the file system memory and disk information are synchronized at the time of snapshot creation, and the file system write operation is frozen to make the file system in a consistent state. The file system consistency snapshot can prevent the operating system from performing disk inspection and repair operations such as CHKDSK or fsck after restart. Valid values: `true`, `false`.
        :param _builtins.int timeout_in_seconds: Only the Linux system is valid, and the IO freeze timeout period. The default is 30 seconds.
        """
        pulumi.set(__self__, "app_consistent", app_consistent)
        pulumi.set(__self__, "destination_region_id", destination_region_id)
        pulumi.set(__self__, "destination_retention", destination_retention)
        pulumi.set(__self__, "disk_id_lists", disk_id_lists)
        pulumi.set(__self__, "do_copy", do_copy)
        pulumi.set(__self__, "enable_fs_freeze", enable_fs_freeze)
        pulumi.set(__self__, "post_script_path", post_script_path)
        pulumi.set(__self__, "pre_script_path", pre_script_path)
        pulumi.set(__self__, "snapshot_group", snapshot_group)
        pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @_builtins.property
    @pulumi.getter(name="appConsistent")
    def app_consistent(self) -> _builtins.bool:
        """
        Whether to turn on application consistency. The application consistency snapshot backs up memory data and ongoing database transactions at the time of snapshot creation to ensure the consistency of application system data and database transactions. By applying consistent snapshots, there is no data damage or loss, so as to avoid log rollback during database startup and ensure that the application is in a consistent startup state. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "app_consistent")

    @_builtins.property
    @pulumi.getter(name="destinationRegionId")
    def destination_region_id(self) -> _builtins.str:
        """
        Only vaild when DoCopy is true. The destination region ID when replicating to another region. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "destination_region_id")

    @_builtins.property
    @pulumi.getter(name="destinationRetention")
    def destination_retention(self) -> _builtins.int:
        """
        Only vaild when DoCopy is true. The retention days of the destination backup. When not specified, the destination backup will be saved permanently. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
        """
        return pulumi.get(self, "destination_retention")

    @_builtins.property
    @pulumi.getter(name="diskIdLists")
    def disk_id_lists(self) -> Sequence[_builtins.str]:
        """
        The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
        """
        return pulumi.get(self, "disk_id_lists")

    @_builtins.property
    @pulumi.getter(name="doCopy")
    def do_copy(self) -> _builtins.bool:
        """
        Whether replicate to another region. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "do_copy")

    @_builtins.property
    @pulumi.getter(name="enableFsFreeze")
    def enable_fs_freeze(self) -> _builtins.bool:
        """
        Only the Linux system is valid. Whether to use the Linux FsFreeze mechanism to ensure that the file system is read-only consistent before creating a storage snapshot. The default is True. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_fs_freeze")

    @_builtins.property
    @pulumi.getter(name="postScriptPath")
    def post_script_path(self) -> _builtins.str:
        """
        Only vaild for the linux system when AppConsistent is true. The application thaw script path (e.g. /tmp/postscript.sh). The postscript.sh script must meet the following conditions: in terms of permissions, only the root user as the owner has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        """
        return pulumi.get(self, "post_script_path")

    @_builtins.property
    @pulumi.getter(name="preScriptPath")
    def pre_script_path(self) -> _builtins.str:
        """
        Only vaild for the linux system when AppConsistent is true. Apply the freeze script path (e.g. /tmp/prescript.sh). prescript.sh scripts must meet the following conditions: in terms of permissions, only root, as the owner, has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
        """
        return pulumi.get(self, "pre_script_path")

    @_builtins.property
    @pulumi.getter(name="snapshotGroup")
    def snapshot_group(self) -> _builtins.bool:
        """
        Whether to turn on file system consistency. If SnapshotGroup is true, when AppConsistent is true but the relevant conditions are not met or AppConsistent is false, the resulting snapshot will be a file system consistency snapshot. The file system consistency ensures that the file system memory and disk information are synchronized at the time of snapshot creation, and the file system write operation is frozen to make the file system in a consistent state. The file system consistency snapshot can prevent the operating system from performing disk inspection and repair operations such as CHKDSK or fsck after restart. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "snapshot_group")

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> _builtins.int:
        """
        Only the Linux system is valid, and the IO freeze timeout period. The default is 30 seconds.
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class GetSnapshotsSnapshotResult(dict):
    def __init__(__self__, *,
                 actual_bytes: _builtins.str,
                 actual_items: _builtins.str,
                 backup_type: _builtins.str,
                 bucket: _builtins.str,
                 bytes_done: _builtins.str,
                 bytes_total: _builtins.str,
                 client_id: _builtins.str,
                 complete_time: _builtins.str,
                 create_time: _builtins.str,
                 created_time: _builtins.str,
                 error_file: _builtins.str,
                 file_system_id: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 items_done: _builtins.str,
                 items_total: _builtins.str,
                 job_id: _builtins.str,
                 parent_snapshot_hash: _builtins.str,
                 path: _builtins.str,
                 prefix: _builtins.str,
                 retention: _builtins.str,
                 snapshot_hash: _builtins.str,
                 snapshot_id: _builtins.str,
                 source_type: _builtins.str,
                 start_time: _builtins.str,
                 status: _builtins.str,
                 updated_time: _builtins.str):
        """
        :param _builtins.str actual_bytes: The actual data volume of the snapshot. Unit byte.
        :param _builtins.str actual_items: The actual number of items in the snapshot. (Currently only file backup is available).
        :param _builtins.str backup_type: Backup type. Possible values: `COMPLETE` (full backup).
        :param _builtins.str bucket: The name of OSS bucket.
        :param _builtins.str bytes_done: The incremental amount of backup data. Unit byte.
        :param _builtins.str bytes_total: The total amount of data sources. Unit byte.
        :param _builtins.str client_id: The ID of ECS backup client.
        :param _builtins.str complete_time: The time when the snapshot completed. UNIX time in seconds.
        :param _builtins.str create_time: File System Creation Time of Nas. Unix Time Seconds.
        :param _builtins.str created_time: Snapshot creation time. UNIX time in seconds.
        :param _builtins.str file_system_id: The ID of NAS File system.
        :param _builtins.str id: The ID of the Snapshot.
        :param _builtins.str instance_id: The ID of ECS instance.
        :param _builtins.str items_done: The number of backup items. (Currently only file backup is available).
        :param _builtins.str items_total: The total number of data source items. (Currently only file backup is available).
        :param _builtins.str job_id: The job ID of backup task.
        :param _builtins.str parent_snapshot_hash: The hashcode of parent backup snapshot.
        :param _builtins.str path: Backup Path.
        :param _builtins.str prefix: Backup file prefix.
        :param _builtins.str retention: The number of days to keep.
        :param _builtins.str snapshot_hash: The hashcode of Snapshot.
        :param _builtins.str snapshot_id: The ID of the Snapshot.
        :param _builtins.str source_type: Data source type, optional values: `ECS_FILE`, `OSS`, `NAS`.
        :param _builtins.str start_time: The start time of the snapshot. UNIX time in seconds.
        :param _builtins.str status: The status of snapshot execution. Possible values: `COMPLETE`, `PARTIAL_COMPLETE`, `FAILED`.
        :param _builtins.str updated_time: The update time of snapshot. UNIX time in seconds.
        """
        pulumi.set(__self__, "actual_bytes", actual_bytes)
        pulumi.set(__self__, "actual_items", actual_items)
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "bytes_done", bytes_done)
        pulumi.set(__self__, "bytes_total", bytes_total)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "complete_time", complete_time)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "error_file", error_file)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "items_done", items_done)
        pulumi.set(__self__, "items_total", items_total)
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "parent_snapshot_hash", parent_snapshot_hash)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "snapshot_hash", snapshot_hash)
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_time", updated_time)

    @_builtins.property
    @pulumi.getter(name="actualBytes")
    def actual_bytes(self) -> _builtins.str:
        """
        The actual data volume of the snapshot. Unit byte.
        """
        return pulumi.get(self, "actual_bytes")

    @_builtins.property
    @pulumi.getter(name="actualItems")
    def actual_items(self) -> _builtins.str:
        """
        The actual number of items in the snapshot. (Currently only file backup is available).
        """
        return pulumi.get(self, "actual_items")

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> _builtins.str:
        """
        Backup type. Possible values: `COMPLETE` (full backup).
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of OSS bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="bytesDone")
    def bytes_done(self) -> _builtins.str:
        """
        The incremental amount of backup data. Unit byte.
        """
        return pulumi.get(self, "bytes_done")

    @_builtins.property
    @pulumi.getter(name="bytesTotal")
    def bytes_total(self) -> _builtins.str:
        """
        The total amount of data sources. Unit byte.
        """
        return pulumi.get(self, "bytes_total")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        The ID of ECS backup client.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="completeTime")
    def complete_time(self) -> _builtins.str:
        """
        The time when the snapshot completed. UNIX time in seconds.
        """
        return pulumi.get(self, "complete_time")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        File System Creation Time of Nas. Unix Time Seconds.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        Snapshot creation time. UNIX time in seconds.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="errorFile")
    def error_file(self) -> _builtins.str:
        return pulumi.get(self, "error_file")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> _builtins.str:
        """
        The ID of NAS File system.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Snapshot.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="itemsDone")
    def items_done(self) -> _builtins.str:
        """
        The number of backup items. (Currently only file backup is available).
        """
        return pulumi.get(self, "items_done")

    @_builtins.property
    @pulumi.getter(name="itemsTotal")
    def items_total(self) -> _builtins.str:
        """
        The total number of data source items. (Currently only file backup is available).
        """
        return pulumi.get(self, "items_total")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> _builtins.str:
        """
        The job ID of backup task.
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="parentSnapshotHash")
    def parent_snapshot_hash(self) -> _builtins.str:
        """
        The hashcode of parent backup snapshot.
        """
        return pulumi.get(self, "parent_snapshot_hash")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Backup Path.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        Backup file prefix.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> _builtins.str:
        """
        The number of days to keep.
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter(name="snapshotHash")
    def snapshot_hash(self) -> _builtins.str:
        """
        The hashcode of Snapshot.
        """
        return pulumi.get(self, "snapshot_hash")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> _builtins.str:
        """
        The ID of the Snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        Data source type, optional values: `ECS_FILE`, `OSS`, `NAS`.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        The start time of the snapshot. UNIX time in seconds.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of snapshot execution. Possible values: `COMPLETE`, `PARTIAL_COMPLETE`, `FAILED`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> _builtins.str:
        """
        The update time of snapshot. UNIX time in seconds.
        """
        return pulumi.get(self, "updated_time")


@pulumi.output_type
class GetUdmSnapshotsSnapshotResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 disk_id: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 job_id: _builtins.str,
                 source_type: _builtins.str,
                 start_time: _builtins.int,
                 udm_snapshot_id: _builtins.str):
        """
        :param _builtins.str create_time: The creation time of the resource
        :param _builtins.str disk_id: Cloud disk ID. This field is valid only when SourceType = UDM_ECS_DISK.
        :param _builtins.str id: The ID of the resource supplied above.
        :param _builtins.str instance_id: ECS instance ID
        :param _builtins.str job_id: The ID of the backup job that creates the snapshot.
        :param _builtins.str source_type: Data source type. Only UDM_ECS and UDM_ECS_DISK are supported.
        :param _builtins.int start_time: Start Time
        :param _builtins.str udm_snapshot_id: The first ID of the resource
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "source_type", source_type)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "udm_snapshot_id", udm_snapshot_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> _builtins.str:
        """
        Cloud disk ID. This field is valid only when SourceType = UDM_ECS_DISK.
        """
        return pulumi.get(self, "disk_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ECS instance ID
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> _builtins.str:
        """
        The ID of the backup job that creates the snapshot.
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        Data source type. Only UDM_ECS and UDM_ECS_DISK are supported.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.int:
        """
        Start Time
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="udmSnapshotId")
    def udm_snapshot_id(self) -> _builtins.str:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "udm_snapshot_id")


@pulumi.output_type
class GetVaultsVaultResult(dict):
    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 bytes_done: _builtins.str,
                 created_time: _builtins.str,
                 dedup: _builtins.bool,
                 description: _builtins.str,
                 id: _builtins.str,
                 index_available: _builtins.bool,
                 index_level: _builtins.str,
                 index_update_time: _builtins.str,
                 latest_replication_time: _builtins.str,
                 payment_type: _builtins.str,
                 replication: _builtins.bool,
                 replication_source_region_id: _builtins.str,
                 replication_source_vault_id: _builtins.str,
                 retention: _builtins.str,
                 search_enabled: _builtins.bool,
                 source_types: Sequence[_builtins.str],
                 status: _builtins.str,
                 storage_size: _builtins.str,
                 updated_time: _builtins.str,
                 vault_id: _builtins.str,
                 vault_name: _builtins.str,
                 vault_status_message: _builtins.str,
                 vault_storage_class: _builtins.str,
                 vault_type: _builtins.str):
        """
        :param _builtins.str bucket_name: The name of the OSS bucket of the Vault.
        :param _builtins.str bytes_done: The amount of backup data. The unit is Byte.
        :param _builtins.str created_time: The creation time of the Vault. UNIX time in seconds.
        :param _builtins.bool dedup: Whether to enable the deduplication function for the database backup Vault.
        :param _builtins.str description: The description of the vault.
        :param _builtins.str id: The ID of vault.
        :param _builtins.bool index_available: Index available.
        :param _builtins.str index_level: Index level.
        :param _builtins.str index_update_time: Index update time.
        :param _builtins.str latest_replication_time: The time of the last remote backup synchronization.
        :param _builtins.str payment_type: Billing model, possible values:
               * `FREE` is not billed
               * `V1` common vault billing model, including back-end storage capacity, client licenses and other billing items
               * `V2` new version of metering mode
               * `AEGIS` Billing method for cloud security use
               * `UNI_BACKUP` the backup of deduplication database
               * `ARCHIVE` archive library.
        :param _builtins.bool replication: Whether it is a remote backup warehouse. It's a boolean value.
        :param _builtins.str replication_source_region_id: The region ID to which the remote backup Vault belongs.
        :param _builtins.str replication_source_vault_id: The source vault ID of the remote backup Vault.
        :param _builtins.str retention: Warehouse-level data retention days, only valid for archive libraries.
        :param _builtins.bool search_enabled: Whether to enable the backup search function.
        :param _builtins.str status: The status of Vault. Valid values: `CREATED`, `ERROR`, `UNKNOWN`.
        :param _builtins.str storage_size: Backup vault storage usage. The unit is Byte.
        :param _builtins.str updated_time: The update time of the Vault. UNIX time in seconds.
        :param _builtins.str vault_id: The ID of vault, same as `id`.
        :param _builtins.str vault_name: The name of vault.
        :param _builtins.str vault_status_message: Error status information of Vault. Only valid for remote backup warehouses. Only the remote backup warehouse is valid.
        :param _builtins.str vault_storage_class: The storage class of vault. Valid values: `STANDARD`.
        :param _builtins.str vault_type: The type of Vault. Valid values: `STANDARD`,`OTS_BACKUP`.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bytes_done", bytes_done)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "dedup", dedup)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "index_available", index_available)
        pulumi.set(__self__, "index_level", index_level)
        pulumi.set(__self__, "index_update_time", index_update_time)
        pulumi.set(__self__, "latest_replication_time", latest_replication_time)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "replication", replication)
        pulumi.set(__self__, "replication_source_region_id", replication_source_region_id)
        pulumi.set(__self__, "replication_source_vault_id", replication_source_vault_id)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "search_enabled", search_enabled)
        pulumi.set(__self__, "source_types", source_types)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage_size", storage_size)
        pulumi.set(__self__, "updated_time", updated_time)
        pulumi.set(__self__, "vault_id", vault_id)
        pulumi.set(__self__, "vault_name", vault_name)
        pulumi.set(__self__, "vault_status_message", vault_status_message)
        pulumi.set(__self__, "vault_storage_class", vault_storage_class)
        pulumi.set(__self__, "vault_type", vault_type)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        The name of the OSS bucket of the Vault.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="bytesDone")
    def bytes_done(self) -> _builtins.str:
        """
        The amount of backup data. The unit is Byte.
        """
        return pulumi.get(self, "bytes_done")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        The creation time of the Vault. UNIX time in seconds.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def dedup(self) -> _builtins.bool:
        """
        Whether to enable the deduplication function for the database backup Vault.
        """
        return pulumi.get(self, "dedup")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the vault.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of vault.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="indexAvailable")
    def index_available(self) -> _builtins.bool:
        """
        Index available.
        """
        return pulumi.get(self, "index_available")

    @_builtins.property
    @pulumi.getter(name="indexLevel")
    def index_level(self) -> _builtins.str:
        """
        Index level.
        """
        return pulumi.get(self, "index_level")

    @_builtins.property
    @pulumi.getter(name="indexUpdateTime")
    def index_update_time(self) -> _builtins.str:
        """
        Index update time.
        """
        return pulumi.get(self, "index_update_time")

    @_builtins.property
    @pulumi.getter(name="latestReplicationTime")
    def latest_replication_time(self) -> _builtins.str:
        """
        The time of the last remote backup synchronization.
        """
        return pulumi.get(self, "latest_replication_time")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        Billing model, possible values:
        * `FREE` is not billed
        * `V1` common vault billing model, including back-end storage capacity, client licenses and other billing items
        * `V2` new version of metering mode
        * `AEGIS` Billing method for cloud security use
        * `UNI_BACKUP` the backup of deduplication database
        * `ARCHIVE` archive library.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def replication(self) -> _builtins.bool:
        """
        Whether it is a remote backup warehouse. It's a boolean value.
        """
        return pulumi.get(self, "replication")

    @_builtins.property
    @pulumi.getter(name="replicationSourceRegionId")
    def replication_source_region_id(self) -> _builtins.str:
        """
        The region ID to which the remote backup Vault belongs.
        """
        return pulumi.get(self, "replication_source_region_id")

    @_builtins.property
    @pulumi.getter(name="replicationSourceVaultId")
    def replication_source_vault_id(self) -> _builtins.str:
        """
        The source vault ID of the remote backup Vault.
        """
        return pulumi.get(self, "replication_source_vault_id")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> _builtins.str:
        """
        Warehouse-level data retention days, only valid for archive libraries.
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter(name="searchEnabled")
    def search_enabled(self) -> _builtins.bool:
        """
        Whether to enable the backup search function.
        """
        return pulumi.get(self, "search_enabled")

    @_builtins.property
    @pulumi.getter(name="sourceTypes")
    def source_types(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "source_types")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of Vault. Valid values: `CREATED`, `ERROR`, `UNKNOWN`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> _builtins.str:
        """
        Backup vault storage usage. The unit is Byte.
        """
        return pulumi.get(self, "storage_size")

    @_builtins.property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> _builtins.str:
        """
        The update time of the Vault. UNIX time in seconds.
        """
        return pulumi.get(self, "updated_time")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The ID of vault, same as `id`.
        """
        return pulumi.get(self, "vault_id")

    @_builtins.property
    @pulumi.getter(name="vaultName")
    def vault_name(self) -> _builtins.str:
        """
        The name of vault.
        """
        return pulumi.get(self, "vault_name")

    @_builtins.property
    @pulumi.getter(name="vaultStatusMessage")
    def vault_status_message(self) -> _builtins.str:
        """
        Error status information of Vault. Only valid for remote backup warehouses. Only the remote backup warehouse is valid.
        """
        return pulumi.get(self, "vault_status_message")

    @_builtins.property
    @pulumi.getter(name="vaultStorageClass")
    def vault_storage_class(self) -> _builtins.str:
        """
        The storage class of vault. Valid values: `STANDARD`.
        """
        return pulumi.get(self, "vault_storage_class")

    @_builtins.property
    @pulumi.getter(name="vaultType")
    def vault_type(self) -> _builtins.str:
        """
        The type of Vault. Valid values: `STANDARD`,`OTS_BACKUP`.
        """
        return pulumi.get(self, "vault_type")


