# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOidcProvidersResult',
    'AwaitableGetOidcProvidersResult',
    'get_oidc_providers',
    'get_oidc_providers_output',
]

@pulumi.output_type
class GetOidcProvidersResult:
    """
    A collection of values returned by getOidcProviders.
    """
    def __init__(__self__, id=None, ids=None, name_regex=None, names=None, output_file=None, providers=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if providers and not isinstance(providers, list):
            raise TypeError("Expected argument 'providers' to be a list")
        pulumi.set(__self__, "providers", providers)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Oidc Provider IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of name of Oidc Providers.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def providers(self) -> Sequence['outputs.GetOidcProvidersProviderResult']:
        """
        A list of Oidc Provider Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "providers")


class AwaitableGetOidcProvidersResult(GetOidcProvidersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOidcProvidersResult(
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            providers=self.providers)


def get_oidc_providers(ids: Optional[Sequence[_builtins.str]] = None,
                       name_regex: Optional[_builtins.str] = None,
                       output_file: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOidcProvidersResult:
    """
    This data source provides Ims Oidc Provider available to the user.[What is Oidc Provider](https://next.api.alibabacloud.com/document/Ims/2019-08-15/CreateOIDCProvider)

    > **NOTE:** Available since v1.248.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    oidc_provider_name = config.get("oidcProviderName")
    if oidc_provider_name is None:
        oidc_provider_name = "amp-resource-example-oidc-provider"
    default_oidc_provider = alicloud.ims.OidcProvider("default",
        description=oidc_provider_name,
        issuer_url="https://oauth.aliyun.com",
        fingerprints=["0BBFAB97059595E8D1EC48E89EB8657C0E5AAE71"],
        issuance_limit_time=12,
        oidc_provider_name=oidc_provider_name,
        client_ids=[
            "123",
            "456",
        ])
    default = alicloud.ims.get_oidc_providers_output(ids=[default_oidc_provider.id])
    pulumi.export("alicloudImsOidcProviderExampleId", default.providers[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Oidc Provider IDs.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ims/getOidcProviders:getOidcProviders', __args__, opts=opts, typ=GetOidcProvidersResult).value

    return AwaitableGetOidcProvidersResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        providers=pulumi.get(__ret__, 'providers'))
def get_oidc_providers_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                              name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOidcProvidersResult]:
    """
    This data source provides Ims Oidc Provider available to the user.[What is Oidc Provider](https://next.api.alibabacloud.com/document/Ims/2019-08-15/CreateOIDCProvider)

    > **NOTE:** Available since v1.248.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    oidc_provider_name = config.get("oidcProviderName")
    if oidc_provider_name is None:
        oidc_provider_name = "amp-resource-example-oidc-provider"
    default_oidc_provider = alicloud.ims.OidcProvider("default",
        description=oidc_provider_name,
        issuer_url="https://oauth.aliyun.com",
        fingerprints=["0BBFAB97059595E8D1EC48E89EB8657C0E5AAE71"],
        issuance_limit_time=12,
        oidc_provider_name=oidc_provider_name,
        client_ids=[
            "123",
            "456",
        ])
    default = alicloud.ims.get_oidc_providers_output(ids=[default_oidc_provider.id])
    pulumi.export("alicloudImsOidcProviderExampleId", default.providers[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Oidc Provider IDs.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ims/getOidcProviders:getOidcProviders', __args__, opts=opts, typ=GetOidcProvidersResult)
    return __ret__.apply(lambda __response__: GetOidcProvidersResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        providers=pulumi.get(__response__, 'providers')))
