# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetProductsResult',
    'AwaitableGetProductsResult',
    'get_products',
    'get_products_output',
]

@pulumi.output_type
class GetProductsResult:
    """
    A collection of values returned by getProducts.
    """
    def __init__(__self__, category_id=None, id=None, ids=None, name_regex=None, output_file=None, product_type=None, products=None, search_term=None, sort=None, suggested_price=None, supplier_id=None, supplier_name_keyword=None):
        if category_id and not isinstance(category_id, str):
            raise TypeError("Expected argument 'category_id' to be a str")
        pulumi.set(__self__, "category_id", category_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if product_type and not isinstance(product_type, str):
            raise TypeError("Expected argument 'product_type' to be a str")
        pulumi.set(__self__, "product_type", product_type)
        if products and not isinstance(products, list):
            raise TypeError("Expected argument 'products' to be a list")
        pulumi.set(__self__, "products", products)
        if search_term and not isinstance(search_term, str):
            raise TypeError("Expected argument 'search_term' to be a str")
        pulumi.set(__self__, "search_term", search_term)
        if sort and not isinstance(sort, str):
            raise TypeError("Expected argument 'sort' to be a str")
        pulumi.set(__self__, "sort", sort)
        if suggested_price and not isinstance(suggested_price, float):
            raise TypeError("Expected argument 'suggested_price' to be a float")
        pulumi.set(__self__, "suggested_price", suggested_price)
        if supplier_id and not isinstance(supplier_id, str):
            raise TypeError("Expected argument 'supplier_id' to be a str")
        pulumi.set(__self__, "supplier_id", supplier_id)
        if supplier_name_keyword and not isinstance(supplier_name_keyword, str):
            raise TypeError("Expected argument 'supplier_name_keyword' to be a str")
        pulumi.set(__self__, "supplier_name_keyword", supplier_name_keyword)

    @_builtins.property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> Optional[_builtins.str]:
        """
        The category id of the product.
        """
        return pulumi.get(self, "category_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of product codes.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="productType")
    def product_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "product_type")

    @_builtins.property
    @pulumi.getter
    def products(self) -> Sequence['outputs.GetProductsProductResult']:
        """
        A list of products. Each element contains the following attributes:
        """
        return pulumi.get(self, "products")

    @_builtins.property
    @pulumi.getter(name="searchTerm")
    def search_term(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "search_term")

    @_builtins.property
    @pulumi.getter
    def sort(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sort")

    @_builtins.property
    @pulumi.getter(name="suggestedPrice")
    def suggested_price(self) -> Optional[_builtins.float]:
        """
        The suggested price of the product.
        """
        return pulumi.get(self, "suggested_price")

    @_builtins.property
    @pulumi.getter(name="supplierId")
    def supplier_id(self) -> Optional[_builtins.str]:
        """
        The supplier id of the product.
        """
        return pulumi.get(self, "supplier_id")

    @_builtins.property
    @pulumi.getter(name="supplierNameKeyword")
    def supplier_name_keyword(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "supplier_name_keyword")


class AwaitableGetProductsResult(GetProductsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProductsResult(
            category_id=self.category_id,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            output_file=self.output_file,
            product_type=self.product_type,
            products=self.products,
            search_term=self.search_term,
            sort=self.sort,
            suggested_price=self.suggested_price,
            supplier_id=self.supplier_id,
            supplier_name_keyword=self.supplier_name_keyword)


def get_products(category_id: Optional[_builtins.str] = None,
                 ids: Optional[Sequence[_builtins.str]] = None,
                 name_regex: Optional[_builtins.str] = None,
                 output_file: Optional[_builtins.str] = None,
                 product_type: Optional[_builtins.str] = None,
                 search_term: Optional[_builtins.str] = None,
                 sort: Optional[_builtins.str] = None,
                 suggested_price: Optional[_builtins.float] = None,
                 supplier_id: Optional[_builtins.str] = None,
                 supplier_name_keyword: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProductsResult:
    """
    This data source provides the Market product items of Alibaba Cloud.

    > **NOTE:** Available in 1.64.0+


    :param _builtins.str category_id: The Category ID of products.
    :param Sequence[_builtins.str] ids: A list of product code.
    :param _builtins.str name_regex: A regex string to apply to the product name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str product_type: The type of products, Valid values: `APP`, `SERVICE`, `MIRROR`, `DOWNLOAD` and `API_SERVICE`.
    :param _builtins.str search_term: Search term in this query.
    :param _builtins.str sort: This field determines how to sort the filtered results, Valid values: `user_count-desc`, `created_on-desc`, `price-desc` and `score-desc`.
    :param _builtins.float suggested_price: The suggested price of the product.
    :param _builtins.str supplier_id: The supplier id of the product.
    :param _builtins.str supplier_name_keyword: The supplier name keyword of the product.
    """
    __args__ = dict()
    __args__['categoryId'] = category_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['productType'] = product_type
    __args__['searchTerm'] = search_term
    __args__['sort'] = sort
    __args__['suggestedPrice'] = suggested_price
    __args__['supplierId'] = supplier_id
    __args__['supplierNameKeyword'] = supplier_name_keyword
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:marketplace/getProducts:getProducts', __args__, opts=opts, typ=GetProductsResult).value

    return AwaitableGetProductsResult(
        category_id=pulumi.get(__ret__, 'category_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        product_type=pulumi.get(__ret__, 'product_type'),
        products=pulumi.get(__ret__, 'products'),
        search_term=pulumi.get(__ret__, 'search_term'),
        sort=pulumi.get(__ret__, 'sort'),
        suggested_price=pulumi.get(__ret__, 'suggested_price'),
        supplier_id=pulumi.get(__ret__, 'supplier_id'),
        supplier_name_keyword=pulumi.get(__ret__, 'supplier_name_keyword'))
def get_products_output(category_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                        name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        product_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        search_term: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        sort: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        suggested_price: Optional[pulumi.Input[Optional[_builtins.float]]] = None,
                        supplier_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        supplier_name_keyword: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProductsResult]:
    """
    This data source provides the Market product items of Alibaba Cloud.

    > **NOTE:** Available in 1.64.0+


    :param _builtins.str category_id: The Category ID of products.
    :param Sequence[_builtins.str] ids: A list of product code.
    :param _builtins.str name_regex: A regex string to apply to the product name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str product_type: The type of products, Valid values: `APP`, `SERVICE`, `MIRROR`, `DOWNLOAD` and `API_SERVICE`.
    :param _builtins.str search_term: Search term in this query.
    :param _builtins.str sort: This field determines how to sort the filtered results, Valid values: `user_count-desc`, `created_on-desc`, `price-desc` and `score-desc`.
    :param _builtins.float suggested_price: The suggested price of the product.
    :param _builtins.str supplier_id: The supplier id of the product.
    :param _builtins.str supplier_name_keyword: The supplier name keyword of the product.
    """
    __args__ = dict()
    __args__['categoryId'] = category_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['productType'] = product_type
    __args__['searchTerm'] = search_term
    __args__['sort'] = sort
    __args__['suggestedPrice'] = suggested_price
    __args__['supplierId'] = supplier_id
    __args__['supplierNameKeyword'] = supplier_name_keyword
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:marketplace/getProducts:getProducts', __args__, opts=opts, typ=GetProductsResult)
    return __ret__.apply(lambda __response__: GetProductsResult(
        category_id=pulumi.get(__response__, 'category_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        output_file=pulumi.get(__response__, 'output_file'),
        product_type=pulumi.get(__response__, 'product_type'),
        products=pulumi.get(__response__, 'products'),
        search_term=pulumi.get(__response__, 'search_term'),
        sort=pulumi.get(__response__, 'sort'),
        suggested_price=pulumi.get(__response__, 'suggested_price'),
        supplier_id=pulumi.get(__response__, 'supplier_id'),
        supplier_name_keyword=pulumi.get(__response__, 'supplier_name_keyword')))
