# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ProjectIpWhiteListArgs',
    'ProjectIpWhiteListArgsDict',
    'ProjectPropertiesArgs',
    'ProjectPropertiesArgsDict',
    'ProjectPropertiesEncryptionArgs',
    'ProjectPropertiesEncryptionArgsDict',
    'ProjectPropertiesTableLifecycleArgs',
    'ProjectPropertiesTableLifecycleArgsDict',
    'ProjectSecurityPropertiesArgs',
    'ProjectSecurityPropertiesArgsDict',
    'ProjectSecurityPropertiesProjectProtectionArgs',
    'ProjectSecurityPropertiesProjectProtectionArgsDict',
    'QuotaPlanQuotaArgs',
    'QuotaPlanQuotaArgsDict',
    'QuotaPlanQuotaParameterArgs',
    'QuotaPlanQuotaParameterArgsDict',
    'QuotaPlanQuotaSubQuotaInfoListArgs',
    'QuotaPlanQuotaSubQuotaInfoListArgsDict',
    'QuotaPlanQuotaSubQuotaInfoListParameterArgs',
    'QuotaPlanQuotaSubQuotaInfoListParameterArgsDict',
    'QuotaScheduleScheduleListArgs',
    'QuotaScheduleScheduleListArgsDict',
    'QuotaScheduleScheduleListConditionArgs',
    'QuotaScheduleScheduleListConditionArgsDict',
    'QuotaSubQuotaInfoListArgs',
    'QuotaSubQuotaInfoListArgsDict',
    'QuotaSubQuotaInfoListParameterArgs',
    'QuotaSubQuotaInfoListParameterArgsDict',
    'TunnelQuotaTimerQuotaTimerArgs',
    'TunnelQuotaTimerQuotaTimerArgsDict',
    'TunnelQuotaTimerQuotaTimerTunnelQuotaParameterArgs',
    'TunnelQuotaTimerQuotaTimerTunnelQuotaParameterArgsDict',
]

MYPY = False

if not MYPY:
    class ProjectIpWhiteListArgsDict(TypedDict):
        ip_list: NotRequired[pulumi.Input[_builtins.str]]
        """
        Set the IP address whitelist in the classic network. Only devices in the whitelist are allowed to access the project.

        > **NOTE:** If you only configure a classic network IP address whitelist, access to the classic network is restricted and all access to the VPC is prohibited.
        """
        vpc_ip_list: NotRequired[pulumi.Input[_builtins.str]]
        """
        Set the IP address whitelist in the VPC network to allow only devices in the whitelist to access the project space.

        > **NOTE:** If you only configure a VPC network IP address whitelist, access to the VPC network is restricted and access to the classic network is prohibited.
        """
elif False:
    ProjectIpWhiteListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectIpWhiteListArgs:
    def __init__(__self__, *,
                 ip_list: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_ip_list: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] ip_list: Set the IP address whitelist in the classic network. Only devices in the whitelist are allowed to access the project.
               
               > **NOTE:** If you only configure a classic network IP address whitelist, access to the classic network is restricted and all access to the VPC is prohibited.
        :param pulumi.Input[_builtins.str] vpc_ip_list: Set the IP address whitelist in the VPC network to allow only devices in the whitelist to access the project space.
               
               > **NOTE:** If you only configure a VPC network IP address whitelist, access to the VPC network is restricted and access to the classic network is prohibited.
        """
        if ip_list is not None:
            pulumi.set(__self__, "ip_list", ip_list)
        if vpc_ip_list is not None:
            pulumi.set(__self__, "vpc_ip_list", vpc_ip_list)

    @_builtins.property
    @pulumi.getter(name="ipList")
    def ip_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the IP address whitelist in the classic network. Only devices in the whitelist are allowed to access the project.

        > **NOTE:** If you only configure a classic network IP address whitelist, access to the classic network is restricted and all access to the VPC is prohibited.
        """
        return pulumi.get(self, "ip_list")

    @ip_list.setter
    def ip_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_list", value)

    @_builtins.property
    @pulumi.getter(name="vpcIpList")
    def vpc_ip_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the IP address whitelist in the VPC network to allow only devices in the whitelist to access the project space.

        > **NOTE:** If you only configure a VPC network IP address whitelist, access to the VPC network is restricted and access to the classic network is prohibited.
        """
        return pulumi.get(self, "vpc_ip_list")

    @vpc_ip_list.setter
    def vpc_ip_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_ip_list", value)


if not MYPY:
    class ProjectPropertiesArgsDict(TypedDict):
        allow_full_scan: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to allow full table scan. Default: `false`.
        """
        enable_decimal2: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to turn on Decimal2.0.
        """
        enable_dr: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable multi-AZ storage disaster tolerance. Valid values: `true`, `false`.
        """
        encryption: NotRequired[pulumi.Input['ProjectPropertiesEncryptionArgsDict']]
        """
        Storage encryption. For details, see [Storage Encryption](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/storage-encryption)
        > **NOTE :**:
        To enable storage encryption, you need to modify the parameters of the basic attributes of the MaxCompute project. This operation permission is authenticated by RAM, and you need to have the Super_Administrator role permission of the corresponding project.

        To configure the permissions and IP whitelist parameters of the MaxCompute project, you must have the management permissions (Admin) of the corresponding project, including Super_Administrator, Admin, or custom management permissions. For more information, see the project management permissions list.

        You can turn on storage encryption only for projects that have not turned on storage encryption. For projects that have turned on storage encryption, you cannot turn off storage encryption or change the encryption algorithm. See `encryption` below.
        """
        retention_days: NotRequired[pulumi.Input[_builtins.int]]
        """
        Set the number of days to retain backup data. During this time, you can restore the current version to any backup version. The value range of days is [0,30], and the default value is 1. 0 means backup is turned off.
        The effective policy after adjusting the backup cycle is:
        Extend the backup cycle: The new backup cycle takes effect on the same day.
        Shorten the backup cycle: The system will automatically delete backup data that has exceeded the retention cycle.
        """
        sql_metering_max: NotRequired[pulumi.Input[_builtins.str]]
        """
        Set the maximum threshold for single SQL Consumption, that is, set the ODPS. SQL. metering.value.max attribute. For more information, see [Consumption control](https://www.alibabacloud.com/help/en/maxcompute/product-overview/consumption-control).
        Unit: scan volume (GB)* complexity.
        """
        table_lifecycle: NotRequired[pulumi.Input['ProjectPropertiesTableLifecycleArgsDict']]
        """
        Set whether the lifecycle of the table in the project needs to be configured, that is, set the ODPS. table.lifecycle property, See `table_lifecycle` below.
        """
        timezone: NotRequired[pulumi.Input[_builtins.str]]
        """
        Project time zone, example value: Asia/Shanghai
        """
        type_system: NotRequired[pulumi.Input[_builtins.str]]
        """
        Data type version. Value:(1/2/hive)
        1: The original MaxCompute type system.
        2: New type system introduced by MaxCompute 2.0.
        hive: the type system of the Hive compatibility mode introduced by MaxCompute 2.0.
        """
elif False:
    ProjectPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectPropertiesArgs:
    def __init__(__self__, *,
                 allow_full_scan: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_decimal2: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dr: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input['ProjectPropertiesEncryptionArgs']] = None,
                 retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 sql_metering_max: Optional[pulumi.Input[_builtins.str]] = None,
                 table_lifecycle: Optional[pulumi.Input['ProjectPropertiesTableLifecycleArgs']] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 type_system: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] allow_full_scan: Whether to allow full table scan. Default: `false`.
        :param pulumi.Input[_builtins.bool] enable_decimal2: Whether to turn on Decimal2.0.
        :param pulumi.Input[_builtins.bool] enable_dr: Enable multi-AZ storage disaster tolerance. Valid values: `true`, `false`.
        :param pulumi.Input['ProjectPropertiesEncryptionArgs'] encryption: Storage encryption. For details, see [Storage Encryption](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/storage-encryption)
               > **NOTE :**:
               To enable storage encryption, you need to modify the parameters of the basic attributes of the MaxCompute project. This operation permission is authenticated by RAM, and you need to have the Super_Administrator role permission of the corresponding project.
               
               To configure the permissions and IP whitelist parameters of the MaxCompute project, you must have the management permissions (Admin) of the corresponding project, including Super_Administrator, Admin, or custom management permissions. For more information, see the project management permissions list.
               
               You can turn on storage encryption only for projects that have not turned on storage encryption. For projects that have turned on storage encryption, you cannot turn off storage encryption or change the encryption algorithm. See `encryption` below.
        :param pulumi.Input[_builtins.int] retention_days: Set the number of days to retain backup data. During this time, you can restore the current version to any backup version. The value range of days is [0,30], and the default value is 1. 0 means backup is turned off.
               The effective policy after adjusting the backup cycle is:
               Extend the backup cycle: The new backup cycle takes effect on the same day.
               Shorten the backup cycle: The system will automatically delete backup data that has exceeded the retention cycle.
        :param pulumi.Input[_builtins.str] sql_metering_max: Set the maximum threshold for single SQL Consumption, that is, set the ODPS. SQL. metering.value.max attribute. For more information, see [Consumption control](https://www.alibabacloud.com/help/en/maxcompute/product-overview/consumption-control).
               Unit: scan volume (GB)* complexity.
        :param pulumi.Input['ProjectPropertiesTableLifecycleArgs'] table_lifecycle: Set whether the lifecycle of the table in the project needs to be configured, that is, set the ODPS. table.lifecycle property, See `table_lifecycle` below.
        :param pulumi.Input[_builtins.str] timezone: Project time zone, example value: Asia/Shanghai
        :param pulumi.Input[_builtins.str] type_system: Data type version. Value:(1/2/hive)
               1: The original MaxCompute type system.
               2: New type system introduced by MaxCompute 2.0.
               hive: the type system of the Hive compatibility mode introduced by MaxCompute 2.0.
        """
        if allow_full_scan is not None:
            pulumi.set(__self__, "allow_full_scan", allow_full_scan)
        if enable_decimal2 is not None:
            pulumi.set(__self__, "enable_decimal2", enable_decimal2)
        if enable_dr is not None:
            pulumi.set(__self__, "enable_dr", enable_dr)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)
        if sql_metering_max is not None:
            pulumi.set(__self__, "sql_metering_max", sql_metering_max)
        if table_lifecycle is not None:
            pulumi.set(__self__, "table_lifecycle", table_lifecycle)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if type_system is not None:
            pulumi.set(__self__, "type_system", type_system)

    @_builtins.property
    @pulumi.getter(name="allowFullScan")
    def allow_full_scan(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow full table scan. Default: `false`.
        """
        return pulumi.get(self, "allow_full_scan")

    @allow_full_scan.setter
    def allow_full_scan(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_full_scan", value)

    @_builtins.property
    @pulumi.getter(name="enableDecimal2")
    def enable_decimal2(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to turn on Decimal2.0.
        """
        return pulumi.get(self, "enable_decimal2")

    @enable_decimal2.setter
    def enable_decimal2(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_decimal2", value)

    @_builtins.property
    @pulumi.getter(name="enableDr")
    def enable_dr(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable multi-AZ storage disaster tolerance. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_dr")

    @enable_dr.setter
    def enable_dr(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dr", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['ProjectPropertiesEncryptionArgs']]:
        """
        Storage encryption. For details, see [Storage Encryption](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/storage-encryption)
        > **NOTE :**:
        To enable storage encryption, you need to modify the parameters of the basic attributes of the MaxCompute project. This operation permission is authenticated by RAM, and you need to have the Super_Administrator role permission of the corresponding project.

        To configure the permissions and IP whitelist parameters of the MaxCompute project, you must have the management permissions (Admin) of the corresponding project, including Super_Administrator, Admin, or custom management permissions. For more information, see the project management permissions list.

        You can turn on storage encryption only for projects that have not turned on storage encryption. For projects that have turned on storage encryption, you cannot turn off storage encryption or change the encryption algorithm. See `encryption` below.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['ProjectPropertiesEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set the number of days to retain backup data. During this time, you can restore the current version to any backup version. The value range of days is [0,30], and the default value is 1. 0 means backup is turned off.
        The effective policy after adjusting the backup cycle is:
        Extend the backup cycle: The new backup cycle takes effect on the same day.
        Shorten the backup cycle: The system will automatically delete backup data that has exceeded the retention cycle.
        """
        return pulumi.get(self, "retention_days")

    @retention_days.setter
    def retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_days", value)

    @_builtins.property
    @pulumi.getter(name="sqlMeteringMax")
    def sql_metering_max(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the maximum threshold for single SQL Consumption, that is, set the ODPS. SQL. metering.value.max attribute. For more information, see [Consumption control](https://www.alibabacloud.com/help/en/maxcompute/product-overview/consumption-control).
        Unit: scan volume (GB)* complexity.
        """
        return pulumi.get(self, "sql_metering_max")

    @sql_metering_max.setter
    def sql_metering_max(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_metering_max", value)

    @_builtins.property
    @pulumi.getter(name="tableLifecycle")
    def table_lifecycle(self) -> Optional[pulumi.Input['ProjectPropertiesTableLifecycleArgs']]:
        """
        Set whether the lifecycle of the table in the project needs to be configured, that is, set the ODPS. table.lifecycle property, See `table_lifecycle` below.
        """
        return pulumi.get(self, "table_lifecycle")

    @table_lifecycle.setter
    def table_lifecycle(self, value: Optional[pulumi.Input['ProjectPropertiesTableLifecycleArgs']]):
        pulumi.set(self, "table_lifecycle", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project time zone, example value: Asia/Shanghai
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="typeSystem")
    def type_system(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data type version. Value:(1/2/hive)
        1: The original MaxCompute type system.
        2: New type system introduced by MaxCompute 2.0.
        hive: the type system of the Hive compatibility mode introduced by MaxCompute 2.0.
        """
        return pulumi.get(self, "type_system")

    @type_system.setter
    def type_system(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type_system", value)


if not MYPY:
    class ProjectPropertiesEncryptionArgsDict(TypedDict):
        algorithm: NotRequired[pulumi.Input[_builtins.str]]
        """
        The encryption algorithm supported by the key, including AES256, AESCTR, and RC4.
        """
        enable: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Only enable function is supported. Value: (true)

        > **NOTE:** cannot be turned off after the function is turned on
        """
        key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The encryption algorithm Key, the Key type used by the project, including the Default Key (MaxCompute Default Key) and the self-contained Key (BYOK). The MaxCompute Default Key is the Default Key created inside MaxCompute.
        """
elif False:
    ProjectPropertiesEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectPropertiesEncryptionArgs:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] algorithm: The encryption algorithm supported by the key, including AES256, AESCTR, and RC4.
        :param pulumi.Input[_builtins.bool] enable: Only enable function is supported. Value: (true)
               
               > **NOTE:** cannot be turned off after the function is turned on
        :param pulumi.Input[_builtins.str] key: The encryption algorithm Key, the Key type used by the project, including the Default Key (MaxCompute Default Key) and the self-contained Key (BYOK). The MaxCompute Default Key is the Default Key created inside MaxCompute.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption algorithm supported by the key, including AES256, AESCTR, and RC4.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Only enable function is supported. Value: (true)

        > **NOTE:** cannot be turned off after the function is turned on
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption algorithm Key, the Key type used by the project, including the Default Key (MaxCompute Default Key) and the self-contained Key (BYOK). The MaxCompute Default Key is the Default Key created inside MaxCompute.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)


if not MYPY:
    class ProjectPropertiesTableLifecycleArgsDict(TypedDict):
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Project type
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The value of the life cycle, in days. The value range is 1~37231, and the default value is 37231.
        """
elif False:
    ProjectPropertiesTableLifecycleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectPropertiesTableLifecycleArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Project type
        :param pulumi.Input[_builtins.str] value: The value of the life cycle, in days. The value range is 1~37231, and the default value is 37231.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the life cycle, in days. The value range is 1~37231, and the default value is 37231.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ProjectSecurityPropertiesArgsDict(TypedDict):
        enable_download_privilege: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Set whether to enable the [Download permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/download-control), that is, set the ODPS. security.enabledownloadprivilege property.
        """
        label_security: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Set whether to use the [Label permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/label-based-access-control), that is, set the LabelSecurity attribute, which is not used by default.
        """
        object_creator_has_access_permission: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Sets whether to allow the creator of the object to have access to the object, I .e. sets the attribute. The default is the allowed state.
        """
        object_creator_has_grant_permission: NotRequired[pulumi.Input[_builtins.bool]]
        """
        The ObjectCreatorHasGrantPermission attribute is set to allow the object creator to have the authorization permission on the object. The default is the allowed state.
        """
        project_protection: NotRequired[pulumi.Input['ProjectSecurityPropertiesProjectProtectionArgsDict']]
        """
        Project protection See `project_protection` below.
        """
        using_acl: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Set whether to use the [ACL permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/maxcompute-permissions), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
        """
        using_policy: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Set whether to use the Policy permission control function (https://www.alibabacloud.com/help/en/maxcompute/user-guide/policy-based-access-control-1), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
        """
elif False:
    ProjectSecurityPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectSecurityPropertiesArgs:
    def __init__(__self__, *,
                 enable_download_privilege: Optional[pulumi.Input[_builtins.bool]] = None,
                 label_security: Optional[pulumi.Input[_builtins.bool]] = None,
                 object_creator_has_access_permission: Optional[pulumi.Input[_builtins.bool]] = None,
                 object_creator_has_grant_permission: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_protection: Optional[pulumi.Input['ProjectSecurityPropertiesProjectProtectionArgs']] = None,
                 using_acl: Optional[pulumi.Input[_builtins.bool]] = None,
                 using_policy: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] enable_download_privilege: Set whether to enable the [Download permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/download-control), that is, set the ODPS. security.enabledownloadprivilege property.
        :param pulumi.Input[_builtins.bool] label_security: Set whether to use the [Label permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/label-based-access-control), that is, set the LabelSecurity attribute, which is not used by default.
        :param pulumi.Input[_builtins.bool] object_creator_has_access_permission: Sets whether to allow the creator of the object to have access to the object, I .e. sets the attribute. The default is the allowed state.
        :param pulumi.Input[_builtins.bool] object_creator_has_grant_permission: The ObjectCreatorHasGrantPermission attribute is set to allow the object creator to have the authorization permission on the object. The default is the allowed state.
        :param pulumi.Input['ProjectSecurityPropertiesProjectProtectionArgs'] project_protection: Project protection See `project_protection` below.
        :param pulumi.Input[_builtins.bool] using_acl: Set whether to use the [ACL permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/maxcompute-permissions), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
        :param pulumi.Input[_builtins.bool] using_policy: Set whether to use the Policy permission control function (https://www.alibabacloud.com/help/en/maxcompute/user-guide/policy-based-access-control-1), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
        """
        if enable_download_privilege is not None:
            pulumi.set(__self__, "enable_download_privilege", enable_download_privilege)
        if label_security is not None:
            pulumi.set(__self__, "label_security", label_security)
        if object_creator_has_access_permission is not None:
            pulumi.set(__self__, "object_creator_has_access_permission", object_creator_has_access_permission)
        if object_creator_has_grant_permission is not None:
            pulumi.set(__self__, "object_creator_has_grant_permission", object_creator_has_grant_permission)
        if project_protection is not None:
            pulumi.set(__self__, "project_protection", project_protection)
        if using_acl is not None:
            pulumi.set(__self__, "using_acl", using_acl)
        if using_policy is not None:
            pulumi.set(__self__, "using_policy", using_policy)

    @_builtins.property
    @pulumi.getter(name="enableDownloadPrivilege")
    def enable_download_privilege(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set whether to enable the [Download permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/download-control), that is, set the ODPS. security.enabledownloadprivilege property.
        """
        return pulumi.get(self, "enable_download_privilege")

    @enable_download_privilege.setter
    def enable_download_privilege(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_download_privilege", value)

    @_builtins.property
    @pulumi.getter(name="labelSecurity")
    def label_security(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set whether to use the [Label permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/label-based-access-control), that is, set the LabelSecurity attribute, which is not used by default.
        """
        return pulumi.get(self, "label_security")

    @label_security.setter
    def label_security(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "label_security", value)

    @_builtins.property
    @pulumi.getter(name="objectCreatorHasAccessPermission")
    def object_creator_has_access_permission(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Sets whether to allow the creator of the object to have access to the object, I .e. sets the attribute. The default is the allowed state.
        """
        return pulumi.get(self, "object_creator_has_access_permission")

    @object_creator_has_access_permission.setter
    def object_creator_has_access_permission(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "object_creator_has_access_permission", value)

    @_builtins.property
    @pulumi.getter(name="objectCreatorHasGrantPermission")
    def object_creator_has_grant_permission(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The ObjectCreatorHasGrantPermission attribute is set to allow the object creator to have the authorization permission on the object. The default is the allowed state.
        """
        return pulumi.get(self, "object_creator_has_grant_permission")

    @object_creator_has_grant_permission.setter
    def object_creator_has_grant_permission(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "object_creator_has_grant_permission", value)

    @_builtins.property
    @pulumi.getter(name="projectProtection")
    def project_protection(self) -> Optional[pulumi.Input['ProjectSecurityPropertiesProjectProtectionArgs']]:
        """
        Project protection See `project_protection` below.
        """
        return pulumi.get(self, "project_protection")

    @project_protection.setter
    def project_protection(self, value: Optional[pulumi.Input['ProjectSecurityPropertiesProjectProtectionArgs']]):
        pulumi.set(self, "project_protection", value)

    @_builtins.property
    @pulumi.getter(name="usingAcl")
    def using_acl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set whether to use the [ACL permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/maxcompute-permissions), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
        """
        return pulumi.get(self, "using_acl")

    @using_acl.setter
    def using_acl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "using_acl", value)

    @_builtins.property
    @pulumi.getter(name="usingPolicy")
    def using_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set whether to use the Policy permission control function (https://www.alibabacloud.com/help/en/maxcompute/user-guide/policy-based-access-control-1), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
        """
        return pulumi.get(self, "using_policy")

    @using_policy.setter
    def using_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "using_policy", value)


if not MYPY:
    class ProjectSecurityPropertiesProjectProtectionArgsDict(TypedDict):
        exception_policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        Set [Exceptions or Trusted Items](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/project-data-protection)
        """
        protected: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether enabled, value:(true/false)
        """
elif False:
    ProjectSecurityPropertiesProjectProtectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectSecurityPropertiesProjectProtectionArgs:
    def __init__(__self__, *,
                 exception_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 protected: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] exception_policy: Set [Exceptions or Trusted Items](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/project-data-protection)
        :param pulumi.Input[_builtins.bool] protected: Whether enabled, value:(true/false)
        """
        if exception_policy is not None:
            pulumi.set(__self__, "exception_policy", exception_policy)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)

    @_builtins.property
    @pulumi.getter(name="exceptionPolicy")
    def exception_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set [Exceptions or Trusted Items](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/project-data-protection)
        """
        return pulumi.get(self, "exception_policy")

    @exception_policy.setter
    def exception_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exception_policy", value)

    @_builtins.property
    @pulumi.getter
    def protected(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enabled, value:(true/false)
        """
        return pulumi.get(self, "protected")

    @protected.setter
    def protected(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "protected", value)


if not MYPY:
    class QuotaPlanQuotaArgsDict(TypedDict):
        parameter: NotRequired[pulumi.Input['QuotaPlanQuotaParameterArgsDict']]
        """
        Level 2 Quota CU configuration See `parameter` below.
        """
        sub_quota_info_lists: NotRequired[pulumi.Input[Sequence[pulumi.Input['QuotaPlanQuotaSubQuotaInfoListArgsDict']]]]
        """
        Secondary Quota list

        > **NOTE:** need to list all secondary Quota
        See `sub_quota_info_list` below.
        """
elif False:
    QuotaPlanQuotaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QuotaPlanQuotaArgs:
    def __init__(__self__, *,
                 parameter: Optional[pulumi.Input['QuotaPlanQuotaParameterArgs']] = None,
                 sub_quota_info_lists: Optional[pulumi.Input[Sequence[pulumi.Input['QuotaPlanQuotaSubQuotaInfoListArgs']]]] = None):
        """
        :param pulumi.Input['QuotaPlanQuotaParameterArgs'] parameter: Level 2 Quota CU configuration See `parameter` below.
        :param pulumi.Input[Sequence[pulumi.Input['QuotaPlanQuotaSubQuotaInfoListArgs']]] sub_quota_info_lists: Secondary Quota list
               
               > **NOTE:** need to list all secondary Quota
               See `sub_quota_info_list` below.
        """
        if parameter is not None:
            pulumi.set(__self__, "parameter", parameter)
        if sub_quota_info_lists is not None:
            pulumi.set(__self__, "sub_quota_info_lists", sub_quota_info_lists)

    @_builtins.property
    @pulumi.getter
    def parameter(self) -> Optional[pulumi.Input['QuotaPlanQuotaParameterArgs']]:
        """
        Level 2 Quota CU configuration See `parameter` below.
        """
        return pulumi.get(self, "parameter")

    @parameter.setter
    def parameter(self, value: Optional[pulumi.Input['QuotaPlanQuotaParameterArgs']]):
        pulumi.set(self, "parameter", value)

    @_builtins.property
    @pulumi.getter(name="subQuotaInfoLists")
    def sub_quota_info_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QuotaPlanQuotaSubQuotaInfoListArgs']]]]:
        """
        Secondary Quota list

        > **NOTE:** need to list all secondary Quota
        See `sub_quota_info_list` below.
        """
        return pulumi.get(self, "sub_quota_info_lists")

    @sub_quota_info_lists.setter
    def sub_quota_info_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QuotaPlanQuotaSubQuotaInfoListArgs']]]]):
        pulumi.set(self, "sub_quota_info_lists", value)


if not MYPY:
    class QuotaPlanQuotaParameterArgsDict(TypedDict):
        elastic_reserved_cu: pulumi.Input[_builtins.int]
        """
        The value of elastic Reserved CUs.

        > **NOTE:**  The total number of elastically reserved CUs in all the level-2 quotas is equal to the number of elastically reserved CUs in the level-1 quota..
        """
        max_cu: NotRequired[pulumi.Input[_builtins.int]]
        """
        The value of maxCU in Reserved CUs.
        """
        min_cu: NotRequired[pulumi.Input[_builtins.int]]
        """
        The value of minCU in Reserved CUs.
        """
elif False:
    QuotaPlanQuotaParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QuotaPlanQuotaParameterArgs:
    def __init__(__self__, *,
                 elastic_reserved_cu: pulumi.Input[_builtins.int],
                 max_cu: Optional[pulumi.Input[_builtins.int]] = None,
                 min_cu: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] elastic_reserved_cu: The value of elastic Reserved CUs.
               
               > **NOTE:**  The total number of elastically reserved CUs in all the level-2 quotas is equal to the number of elastically reserved CUs in the level-1 quota..
        :param pulumi.Input[_builtins.int] max_cu: The value of maxCU in Reserved CUs.
        :param pulumi.Input[_builtins.int] min_cu: The value of minCU in Reserved CUs.
        """
        pulumi.set(__self__, "elastic_reserved_cu", elastic_reserved_cu)
        if max_cu is not None:
            pulumi.set(__self__, "max_cu", max_cu)
        if min_cu is not None:
            pulumi.set(__self__, "min_cu", min_cu)

    @_builtins.property
    @pulumi.getter(name="elasticReservedCu")
    def elastic_reserved_cu(self) -> pulumi.Input[_builtins.int]:
        """
        The value of elastic Reserved CUs.

        > **NOTE:**  The total number of elastically reserved CUs in all the level-2 quotas is equal to the number of elastically reserved CUs in the level-1 quota..
        """
        return pulumi.get(self, "elastic_reserved_cu")

    @elastic_reserved_cu.setter
    def elastic_reserved_cu(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "elastic_reserved_cu", value)

    @_builtins.property
    @pulumi.getter(name="maxCu")
    def max_cu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The value of maxCU in Reserved CUs.
        """
        return pulumi.get(self, "max_cu")

    @max_cu.setter
    def max_cu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_cu", value)

    @_builtins.property
    @pulumi.getter(name="minCu")
    def min_cu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The value of minCU in Reserved CUs.
        """
        return pulumi.get(self, "min_cu")

    @min_cu.setter
    def min_cu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_cu", value)


if not MYPY:
    class QuotaPlanQuotaSubQuotaInfoListArgsDict(TypedDict):
        nick_name: pulumi.Input[_builtins.str]
        """
        The nickname of the level-2 quota.
        """
        parameter: NotRequired[pulumi.Input['QuotaPlanQuotaSubQuotaInfoListParameterArgsDict']]
        """
        The parameters of level-1 quota.
        """
elif False:
    QuotaPlanQuotaSubQuotaInfoListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QuotaPlanQuotaSubQuotaInfoListArgs:
    def __init__(__self__, *,
                 nick_name: pulumi.Input[_builtins.str],
                 parameter: Optional[pulumi.Input['QuotaPlanQuotaSubQuotaInfoListParameterArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] nick_name: The nickname of the level-2 quota.
        :param pulumi.Input['QuotaPlanQuotaSubQuotaInfoListParameterArgs'] parameter: The parameters of level-1 quota.
        """
        pulumi.set(__self__, "nick_name", nick_name)
        if parameter is not None:
            pulumi.set(__self__, "parameter", parameter)

    @_builtins.property
    @pulumi.getter(name="nickName")
    def nick_name(self) -> pulumi.Input[_builtins.str]:
        """
        The nickname of the level-2 quota.
        """
        return pulumi.get(self, "nick_name")

    @nick_name.setter
    def nick_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nick_name", value)

    @_builtins.property
    @pulumi.getter
    def parameter(self) -> Optional[pulumi.Input['QuotaPlanQuotaSubQuotaInfoListParameterArgs']]:
        """
        The parameters of level-1 quota.
        """
        return pulumi.get(self, "parameter")

    @parameter.setter
    def parameter(self, value: Optional[pulumi.Input['QuotaPlanQuotaSubQuotaInfoListParameterArgs']]):
        pulumi.set(self, "parameter", value)


if not MYPY:
    class QuotaPlanQuotaSubQuotaInfoListParameterArgsDict(TypedDict):
        elastic_reserved_cu: pulumi.Input[_builtins.int]
        """
        The value of elastic Reserved CUs.

        > **NOTE:**  The total number of elastically reserved CUs in all the level-2 quotas is equal to the number of elastically reserved CUs in the level-1 quota..
        """
        max_cu: pulumi.Input[_builtins.int]
        """
        The value of maxCU in Reserved CUs.
        """
        min_cu: pulumi.Input[_builtins.int]
        """
        The value of minCU in Reserved CUs.
        """
elif False:
    QuotaPlanQuotaSubQuotaInfoListParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QuotaPlanQuotaSubQuotaInfoListParameterArgs:
    def __init__(__self__, *,
                 elastic_reserved_cu: pulumi.Input[_builtins.int],
                 max_cu: pulumi.Input[_builtins.int],
                 min_cu: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.int] elastic_reserved_cu: The value of elastic Reserved CUs.
               
               > **NOTE:**  The total number of elastically reserved CUs in all the level-2 quotas is equal to the number of elastically reserved CUs in the level-1 quota..
        :param pulumi.Input[_builtins.int] max_cu: The value of maxCU in Reserved CUs.
        :param pulumi.Input[_builtins.int] min_cu: The value of minCU in Reserved CUs.
        """
        pulumi.set(__self__, "elastic_reserved_cu", elastic_reserved_cu)
        pulumi.set(__self__, "max_cu", max_cu)
        pulumi.set(__self__, "min_cu", min_cu)

    @_builtins.property
    @pulumi.getter(name="elasticReservedCu")
    def elastic_reserved_cu(self) -> pulumi.Input[_builtins.int]:
        """
        The value of elastic Reserved CUs.

        > **NOTE:**  The total number of elastically reserved CUs in all the level-2 quotas is equal to the number of elastically reserved CUs in the level-1 quota..
        """
        return pulumi.get(self, "elastic_reserved_cu")

    @elastic_reserved_cu.setter
    def elastic_reserved_cu(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "elastic_reserved_cu", value)

    @_builtins.property
    @pulumi.getter(name="maxCu")
    def max_cu(self) -> pulumi.Input[_builtins.int]:
        """
        The value of maxCU in Reserved CUs.
        """
        return pulumi.get(self, "max_cu")

    @max_cu.setter
    def max_cu(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_cu", value)

    @_builtins.property
    @pulumi.getter(name="minCu")
    def min_cu(self) -> pulumi.Input[_builtins.int]:
        """
        The value of minCU in Reserved CUs.
        """
        return pulumi.get(self, "min_cu")

    @min_cu.setter
    def min_cu(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "min_cu", value)


if not MYPY:
    class QuotaScheduleScheduleListArgsDict(TypedDict):
        plan: pulumi.Input[_builtins.str]
        """
        The name of the quota plan.
        """
        type: pulumi.Input[_builtins.str]
        """
        The type of the quota plan. Valid values: daily 

        > **NOTE:** Currently, only daily is supported.
        """
        condition: NotRequired[pulumi.Input['QuotaScheduleScheduleListConditionArgsDict']]
        """
        The value of effective condition. See `condition` below.
        """
elif False:
    QuotaScheduleScheduleListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QuotaScheduleScheduleListArgs:
    def __init__(__self__, *,
                 plan: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 condition: Optional[pulumi.Input['QuotaScheduleScheduleListConditionArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] plan: The name of the quota plan.
        :param pulumi.Input[_builtins.str] type: The type of the quota plan. Valid values: daily 
               
               > **NOTE:** Currently, only daily is supported.
        :param pulumi.Input['QuotaScheduleScheduleListConditionArgs'] condition: The value of effective condition. See `condition` below.
        """
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "type", type)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the quota plan.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the quota plan. Valid values: daily 

        > **NOTE:** Currently, only daily is supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['QuotaScheduleScheduleListConditionArgs']]:
        """
        The value of effective condition. See `condition` below.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['QuotaScheduleScheduleListConditionArgs']]):
        pulumi.set(self, "condition", value)


if not MYPY:
    class QuotaScheduleScheduleListConditionArgsDict(TypedDict):
        at: pulumi.Input[_builtins.str]
        """
        Effective time. The format is HH:mm, sample value: 00:00

        > **NOTE:** The configuration must start from the effective time of 00:00. The input time must be either a whole hour or a half hour, and the minimum interval between each schedule is 30 minutes.
        """
elif False:
    QuotaScheduleScheduleListConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QuotaScheduleScheduleListConditionArgs:
    def __init__(__self__, *,
                 at: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] at: Effective time. The format is HH:mm, sample value: 00:00
               
               > **NOTE:** The configuration must start from the effective time of 00:00. The input time must be either a whole hour or a half hour, and the minimum interval between each schedule is 30 minutes.
        """
        pulumi.set(__self__, "at", at)

    @_builtins.property
    @pulumi.getter
    def at(self) -> pulumi.Input[_builtins.str]:
        """
        Effective time. The format is HH:mm, sample value: 00:00

        > **NOTE:** The configuration must start from the effective time of 00:00. The input time must be either a whole hour or a half hour, and the minimum interval between each schedule is 30 minutes.
        """
        return pulumi.get(self, "at")

    @at.setter
    def at(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "at", value)


if not MYPY:
    class QuotaSubQuotaInfoListArgsDict(TypedDict):
        nick_name: pulumi.Input[_builtins.str]
        """
        Secondary Quota nickname.

        > **NOTE:** -- Subscription: If you enter partNickName, the first-level QuotaNickName created is os_partNickName_p. Each first-level Quota has a default second-level Quota whose QuotaNickName is os_partNickName . -- The first-level quotanicname created by PayAsYouGo is os_PayAsYouGoQuota_p  by default, the second-level quotanicname is os_PayAsYouGoQuota
        """
        parameter: NotRequired[pulumi.Input['QuotaSubQuotaInfoListParameterArgsDict']]
        """
        Parameter See `parameter` below.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The secondary Quota type. The default value is: FUXI_OFFLINE
        """
elif False:
    QuotaSubQuotaInfoListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QuotaSubQuotaInfoListArgs:
    def __init__(__self__, *,
                 nick_name: pulumi.Input[_builtins.str],
                 parameter: Optional[pulumi.Input['QuotaSubQuotaInfoListParameterArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] nick_name: Secondary Quota nickname.
               
               > **NOTE:** -- Subscription: If you enter partNickName, the first-level QuotaNickName created is os_partNickName_p. Each first-level Quota has a default second-level Quota whose QuotaNickName is os_partNickName . -- The first-level quotanicname created by PayAsYouGo is os_PayAsYouGoQuota_p  by default, the second-level quotanicname is os_PayAsYouGoQuota
        :param pulumi.Input['QuotaSubQuotaInfoListParameterArgs'] parameter: Parameter See `parameter` below.
        :param pulumi.Input[_builtins.str] type: The secondary Quota type. The default value is: FUXI_OFFLINE
        """
        pulumi.set(__self__, "nick_name", nick_name)
        if parameter is not None:
            pulumi.set(__self__, "parameter", parameter)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="nickName")
    def nick_name(self) -> pulumi.Input[_builtins.str]:
        """
        Secondary Quota nickname.

        > **NOTE:** -- Subscription: If you enter partNickName, the first-level QuotaNickName created is os_partNickName_p. Each first-level Quota has a default second-level Quota whose QuotaNickName is os_partNickName . -- The first-level quotanicname created by PayAsYouGo is os_PayAsYouGoQuota_p  by default, the second-level quotanicname is os_PayAsYouGoQuota
        """
        return pulumi.get(self, "nick_name")

    @nick_name.setter
    def nick_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nick_name", value)

    @_builtins.property
    @pulumi.getter
    def parameter(self) -> Optional[pulumi.Input['QuotaSubQuotaInfoListParameterArgs']]:
        """
        Parameter See `parameter` below.
        """
        return pulumi.get(self, "parameter")

    @parameter.setter
    def parameter(self, value: Optional[pulumi.Input['QuotaSubQuotaInfoListParameterArgs']]):
        pulumi.set(self, "parameter", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secondary Quota type. The default value is: FUXI_OFFLINE
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class QuotaSubQuotaInfoListParameterArgsDict(TypedDict):
        max_cu: pulumi.Input[_builtins.int]
        """
        The value of maxCU in Reserved CUs.

        > **NOTE:**  The value of maxCU must be less than or equal to the value of maxCU in the level-1 quota that you purchased.
        """
        min_cu: pulumi.Input[_builtins.int]
        """
        The value of minCU in Reserved CUs.

        > **NOTE:**  -- The total value of minCU in all the level-2 quotas is equal to the value of minCU in the level-1 quota.    -- The value of minCU must be less than or equal to the value of maxCU in the level-2 quota and less than or equal to the value of minCU in the level-1 quota that you purchased.
        """
        enable_priority: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable priority. Valid values: true/false, default: false
        """
        force_reserved_min: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Exclusive or not. Valid values: true/false, default: false
        """
        scheduler_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Scheduling policy. Valid values: Fifo/Fair, default: Fifo
        """
        single_job_cu_limit: NotRequired[pulumi.Input[_builtins.int]]
        """
        Single job CU upper limit. Valid value: greater than or equal to 1

        > **NOTE:** -- If you want to not restrict SingleJobCuLimit, please make sure that this parameter is not included in the configuration at all. That is, do not configure SingleJobCuLimit to "null" or any other invalid value
        """
elif False:
    QuotaSubQuotaInfoListParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QuotaSubQuotaInfoListParameterArgs:
    def __init__(__self__, *,
                 max_cu: pulumi.Input[_builtins.int],
                 min_cu: pulumi.Input[_builtins.int],
                 enable_priority: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_reserved_min: Optional[pulumi.Input[_builtins.bool]] = None,
                 scheduler_type: Optional[pulumi.Input[_builtins.str]] = None,
                 single_job_cu_limit: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] max_cu: The value of maxCU in Reserved CUs.
               
               > **NOTE:**  The value of maxCU must be less than or equal to the value of maxCU in the level-1 quota that you purchased.
        :param pulumi.Input[_builtins.int] min_cu: The value of minCU in Reserved CUs.
               
               > **NOTE:**  -- The total value of minCU in all the level-2 quotas is equal to the value of minCU in the level-1 quota.    -- The value of minCU must be less than or equal to the value of maxCU in the level-2 quota and less than or equal to the value of minCU in the level-1 quota that you purchased.
        :param pulumi.Input[_builtins.bool] enable_priority: Enable priority. Valid values: true/false, default: false
        :param pulumi.Input[_builtins.bool] force_reserved_min: Exclusive or not. Valid values: true/false, default: false
        :param pulumi.Input[_builtins.str] scheduler_type: Scheduling policy. Valid values: Fifo/Fair, default: Fifo
        :param pulumi.Input[_builtins.int] single_job_cu_limit: Single job CU upper limit. Valid value: greater than or equal to 1
               
               > **NOTE:** -- If you want to not restrict SingleJobCuLimit, please make sure that this parameter is not included in the configuration at all. That is, do not configure SingleJobCuLimit to "null" or any other invalid value
        """
        pulumi.set(__self__, "max_cu", max_cu)
        pulumi.set(__self__, "min_cu", min_cu)
        if enable_priority is not None:
            pulumi.set(__self__, "enable_priority", enable_priority)
        if force_reserved_min is not None:
            pulumi.set(__self__, "force_reserved_min", force_reserved_min)
        if scheduler_type is not None:
            pulumi.set(__self__, "scheduler_type", scheduler_type)
        if single_job_cu_limit is not None:
            pulumi.set(__self__, "single_job_cu_limit", single_job_cu_limit)

    @_builtins.property
    @pulumi.getter(name="maxCu")
    def max_cu(self) -> pulumi.Input[_builtins.int]:
        """
        The value of maxCU in Reserved CUs.

        > **NOTE:**  The value of maxCU must be less than or equal to the value of maxCU in the level-1 quota that you purchased.
        """
        return pulumi.get(self, "max_cu")

    @max_cu.setter
    def max_cu(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_cu", value)

    @_builtins.property
    @pulumi.getter(name="minCu")
    def min_cu(self) -> pulumi.Input[_builtins.int]:
        """
        The value of minCU in Reserved CUs.

        > **NOTE:**  -- The total value of minCU in all the level-2 quotas is equal to the value of minCU in the level-1 quota.    -- The value of minCU must be less than or equal to the value of maxCU in the level-2 quota and less than or equal to the value of minCU in the level-1 quota that you purchased.
        """
        return pulumi.get(self, "min_cu")

    @min_cu.setter
    def min_cu(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "min_cu", value)

    @_builtins.property
    @pulumi.getter(name="enablePriority")
    def enable_priority(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable priority. Valid values: true/false, default: false
        """
        return pulumi.get(self, "enable_priority")

    @enable_priority.setter
    def enable_priority(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_priority", value)

    @_builtins.property
    @pulumi.getter(name="forceReservedMin")
    def force_reserved_min(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Exclusive or not. Valid values: true/false, default: false
        """
        return pulumi.get(self, "force_reserved_min")

    @force_reserved_min.setter
    def force_reserved_min(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_reserved_min", value)

    @_builtins.property
    @pulumi.getter(name="schedulerType")
    def scheduler_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scheduling policy. Valid values: Fifo/Fair, default: Fifo
        """
        return pulumi.get(self, "scheduler_type")

    @scheduler_type.setter
    def scheduler_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduler_type", value)

    @_builtins.property
    @pulumi.getter(name="singleJobCuLimit")
    def single_job_cu_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Single job CU upper limit. Valid value: greater than or equal to 1

        > **NOTE:** -- If you want to not restrict SingleJobCuLimit, please make sure that this parameter is not included in the configuration at all. That is, do not configure SingleJobCuLimit to "null" or any other invalid value
        """
        return pulumi.get(self, "single_job_cu_limit")

    @single_job_cu_limit.setter
    def single_job_cu_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "single_job_cu_limit", value)


if not MYPY:
    class TunnelQuotaTimerQuotaTimerArgsDict(TypedDict):
        begin_time: pulumi.Input[_builtins.str]
        """
        The time-sharing configuration start time. Reference value: 00:00
        """
        end_time: pulumi.Input[_builtins.str]
        """
        The end time of the timesharing configuration. Reference value: 24:00
        """
        tunnel_quota_parameter: NotRequired[pulumi.Input['TunnelQuotaTimerQuotaTimerTunnelQuotaParameterArgsDict']]
        """
        Time-sharing configuration parameters. See `tunnel_quota_parameter` below.
        """
elif False:
    TunnelQuotaTimerQuotaTimerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TunnelQuotaTimerQuotaTimerArgs:
    def __init__(__self__, *,
                 begin_time: pulumi.Input[_builtins.str],
                 end_time: pulumi.Input[_builtins.str],
                 tunnel_quota_parameter: Optional[pulumi.Input['TunnelQuotaTimerQuotaTimerTunnelQuotaParameterArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] begin_time: The time-sharing configuration start time. Reference value: 00:00
        :param pulumi.Input[_builtins.str] end_time: The end time of the timesharing configuration. Reference value: 24:00
        :param pulumi.Input['TunnelQuotaTimerQuotaTimerTunnelQuotaParameterArgs'] tunnel_quota_parameter: Time-sharing configuration parameters. See `tunnel_quota_parameter` below.
        """
        pulumi.set(__self__, "begin_time", begin_time)
        pulumi.set(__self__, "end_time", end_time)
        if tunnel_quota_parameter is not None:
            pulumi.set(__self__, "tunnel_quota_parameter", tunnel_quota_parameter)

    @_builtins.property
    @pulumi.getter(name="beginTime")
    def begin_time(self) -> pulumi.Input[_builtins.str]:
        """
        The time-sharing configuration start time. Reference value: 00:00
        """
        return pulumi.get(self, "begin_time")

    @begin_time.setter
    def begin_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "begin_time", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Input[_builtins.str]:
        """
        The end time of the timesharing configuration. Reference value: 24:00
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="tunnelQuotaParameter")
    def tunnel_quota_parameter(self) -> Optional[pulumi.Input['TunnelQuotaTimerQuotaTimerTunnelQuotaParameterArgs']]:
        """
        Time-sharing configuration parameters. See `tunnel_quota_parameter` below.
        """
        return pulumi.get(self, "tunnel_quota_parameter")

    @tunnel_quota_parameter.setter
    def tunnel_quota_parameter(self, value: Optional[pulumi.Input['TunnelQuotaTimerQuotaTimerTunnelQuotaParameterArgs']]):
        pulumi.set(self, "tunnel_quota_parameter", value)


if not MYPY:
    class TunnelQuotaTimerQuotaTimerTunnelQuotaParameterArgsDict(TypedDict):
        elastic_reserved_slot_num: pulumi.Input[_builtins.int]
        """
        The number of elastic reserved concurrency (Slot).
        """
        slot_num: pulumi.Input[_builtins.int]
        """
        The number of reserved concurrency (Slot).

        > **NOTE:** The reserved concurrency (Slot) cannot be modified. The number of concurrency slots must be the same as that of the purchased tunnel quota.
        """
elif False:
    TunnelQuotaTimerQuotaTimerTunnelQuotaParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TunnelQuotaTimerQuotaTimerTunnelQuotaParameterArgs:
    def __init__(__self__, *,
                 elastic_reserved_slot_num: pulumi.Input[_builtins.int],
                 slot_num: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.int] elastic_reserved_slot_num: The number of elastic reserved concurrency (Slot).
        :param pulumi.Input[_builtins.int] slot_num: The number of reserved concurrency (Slot).
               
               > **NOTE:** The reserved concurrency (Slot) cannot be modified. The number of concurrency slots must be the same as that of the purchased tunnel quota.
        """
        pulumi.set(__self__, "elastic_reserved_slot_num", elastic_reserved_slot_num)
        pulumi.set(__self__, "slot_num", slot_num)

    @_builtins.property
    @pulumi.getter(name="elasticReservedSlotNum")
    def elastic_reserved_slot_num(self) -> pulumi.Input[_builtins.int]:
        """
        The number of elastic reserved concurrency (Slot).
        """
        return pulumi.get(self, "elastic_reserved_slot_num")

    @elastic_reserved_slot_num.setter
    def elastic_reserved_slot_num(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "elastic_reserved_slot_num", value)

    @_builtins.property
    @pulumi.getter(name="slotNum")
    def slot_num(self) -> pulumi.Input[_builtins.int]:
        """
        The number of reserved concurrency (Slot).

        > **NOTE:** The reserved concurrency (Slot) cannot be modified. The number of concurrency slots must be the same as that of the purchased tunnel quota.
        """
        return pulumi.get(self, "slot_num")

    @slot_num.setter
    def slot_num(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "slot_num", value)


