# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ProjectIpWhiteList',
    'ProjectProperties',
    'ProjectPropertiesEncryption',
    'ProjectPropertiesTableLifecycle',
    'ProjectSecurityProperties',
    'ProjectSecurityPropertiesProjectProtection',
    'QuotaPlanQuota',
    'QuotaPlanQuotaParameter',
    'QuotaPlanQuotaSubQuotaInfoList',
    'QuotaPlanQuotaSubQuotaInfoListParameter',
    'QuotaScheduleScheduleList',
    'QuotaScheduleScheduleListCondition',
    'QuotaSubQuotaInfoList',
    'QuotaSubQuotaInfoListParameter',
    'TunnelQuotaTimerQuotaTimer',
    'TunnelQuotaTimerQuotaTimerTunnelQuotaParameter',
    'GetProjectsProjectResult',
    'GetProjectsProjectIpWhiteListResult',
    'GetProjectsProjectPropertiesResult',
    'GetProjectsProjectPropertiesEncryptionResult',
    'GetProjectsProjectPropertiesTableLifecycleResult',
    'GetProjectsProjectSecurityPropertiesResult',
    'GetProjectsProjectSecurityPropertiesProjectProtectionResult',
]

@pulumi.output_type
class ProjectIpWhiteList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipList":
            suggest = "ip_list"
        elif key == "vpcIpList":
            suggest = "vpc_ip_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectIpWhiteList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectIpWhiteList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectIpWhiteList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_list: Optional[_builtins.str] = None,
                 vpc_ip_list: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip_list: Set the IP address whitelist in the classic network. Only devices in the whitelist are allowed to access the project.
               
               > **NOTE:** If you only configure a classic network IP address whitelist, access to the classic network is restricted and all access to the VPC is prohibited.
        :param _builtins.str vpc_ip_list: Set the IP address whitelist in the VPC network to allow only devices in the whitelist to access the project space.
               
               > **NOTE:** If you only configure a VPC network IP address whitelist, access to the VPC network is restricted and access to the classic network is prohibited.
        """
        if ip_list is not None:
            pulumi.set(__self__, "ip_list", ip_list)
        if vpc_ip_list is not None:
            pulumi.set(__self__, "vpc_ip_list", vpc_ip_list)

    @_builtins.property
    @pulumi.getter(name="ipList")
    def ip_list(self) -> Optional[_builtins.str]:
        """
        Set the IP address whitelist in the classic network. Only devices in the whitelist are allowed to access the project.

        > **NOTE:** If you only configure a classic network IP address whitelist, access to the classic network is restricted and all access to the VPC is prohibited.
        """
        return pulumi.get(self, "ip_list")

    @_builtins.property
    @pulumi.getter(name="vpcIpList")
    def vpc_ip_list(self) -> Optional[_builtins.str]:
        """
        Set the IP address whitelist in the VPC network to allow only devices in the whitelist to access the project space.

        > **NOTE:** If you only configure a VPC network IP address whitelist, access to the VPC network is restricted and access to the classic network is prohibited.
        """
        return pulumi.get(self, "vpc_ip_list")


@pulumi.output_type
class ProjectProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowFullScan":
            suggest = "allow_full_scan"
        elif key == "enableDecimal2":
            suggest = "enable_decimal2"
        elif key == "enableDr":
            suggest = "enable_dr"
        elif key == "retentionDays":
            suggest = "retention_days"
        elif key == "sqlMeteringMax":
            suggest = "sql_metering_max"
        elif key == "tableLifecycle":
            suggest = "table_lifecycle"
        elif key == "typeSystem":
            suggest = "type_system"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_full_scan: Optional[_builtins.bool] = None,
                 enable_decimal2: Optional[_builtins.bool] = None,
                 enable_dr: Optional[_builtins.bool] = None,
                 encryption: Optional['outputs.ProjectPropertiesEncryption'] = None,
                 retention_days: Optional[_builtins.int] = None,
                 sql_metering_max: Optional[_builtins.str] = None,
                 table_lifecycle: Optional['outputs.ProjectPropertiesTableLifecycle'] = None,
                 timezone: Optional[_builtins.str] = None,
                 type_system: Optional[_builtins.str] = None):
        """
        :param _builtins.bool allow_full_scan: Whether to allow full table scan. Default: `false`.
        :param _builtins.bool enable_decimal2: Whether to turn on Decimal2.0.
        :param _builtins.bool enable_dr: Enable multi-AZ storage disaster tolerance. Valid values: `true`, `false`.
        :param 'ProjectPropertiesEncryptionArgs' encryption: Storage encryption. For details, see [Storage Encryption](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/storage-encryption)
               > **NOTE :**:
               To enable storage encryption, you need to modify the parameters of the basic attributes of the MaxCompute project. This operation permission is authenticated by RAM, and you need to have the Super_Administrator role permission of the corresponding project.
               
               To configure the permissions and IP whitelist parameters of the MaxCompute project, you must have the management permissions (Admin) of the corresponding project, including Super_Administrator, Admin, or custom management permissions. For more information, see the project management permissions list.
               
               You can turn on storage encryption only for projects that have not turned on storage encryption. For projects that have turned on storage encryption, you cannot turn off storage encryption or change the encryption algorithm. See `encryption` below.
        :param _builtins.int retention_days: Set the number of days to retain backup data. During this time, you can restore the current version to any backup version. The value range of days is [0,30], and the default value is 1. 0 means backup is turned off.
               The effective policy after adjusting the backup cycle is:
               Extend the backup cycle: The new backup cycle takes effect on the same day.
               Shorten the backup cycle: The system will automatically delete backup data that has exceeded the retention cycle.
        :param _builtins.str sql_metering_max: Set the maximum threshold for single SQL Consumption, that is, set the ODPS. SQL. metering.value.max attribute. For more information, see [Consumption control](https://www.alibabacloud.com/help/en/maxcompute/product-overview/consumption-control).
               Unit: scan volume (GB)* complexity.
        :param 'ProjectPropertiesTableLifecycleArgs' table_lifecycle: Set whether the lifecycle of the table in the project needs to be configured, that is, set the ODPS. table.lifecycle property, See `table_lifecycle` below.
        :param _builtins.str timezone: Project time zone, example value: Asia/Shanghai
        :param _builtins.str type_system: Data type version. Value:(1/2/hive)
               1: The original MaxCompute type system.
               2: New type system introduced by MaxCompute 2.0.
               hive: the type system of the Hive compatibility mode introduced by MaxCompute 2.0.
        """
        if allow_full_scan is not None:
            pulumi.set(__self__, "allow_full_scan", allow_full_scan)
        if enable_decimal2 is not None:
            pulumi.set(__self__, "enable_decimal2", enable_decimal2)
        if enable_dr is not None:
            pulumi.set(__self__, "enable_dr", enable_dr)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)
        if sql_metering_max is not None:
            pulumi.set(__self__, "sql_metering_max", sql_metering_max)
        if table_lifecycle is not None:
            pulumi.set(__self__, "table_lifecycle", table_lifecycle)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if type_system is not None:
            pulumi.set(__self__, "type_system", type_system)

    @_builtins.property
    @pulumi.getter(name="allowFullScan")
    def allow_full_scan(self) -> Optional[_builtins.bool]:
        """
        Whether to allow full table scan. Default: `false`.
        """
        return pulumi.get(self, "allow_full_scan")

    @_builtins.property
    @pulumi.getter(name="enableDecimal2")
    def enable_decimal2(self) -> Optional[_builtins.bool]:
        """
        Whether to turn on Decimal2.0.
        """
        return pulumi.get(self, "enable_decimal2")

    @_builtins.property
    @pulumi.getter(name="enableDr")
    def enable_dr(self) -> Optional[_builtins.bool]:
        """
        Enable multi-AZ storage disaster tolerance. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable_dr")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.ProjectPropertiesEncryption']:
        """
        Storage encryption. For details, see [Storage Encryption](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/storage-encryption)
        > **NOTE :**:
        To enable storage encryption, you need to modify the parameters of the basic attributes of the MaxCompute project. This operation permission is authenticated by RAM, and you need to have the Super_Administrator role permission of the corresponding project.

        To configure the permissions and IP whitelist parameters of the MaxCompute project, you must have the management permissions (Admin) of the corresponding project, including Super_Administrator, Admin, or custom management permissions. For more information, see the project management permissions list.

        You can turn on storage encryption only for projects that have not turned on storage encryption. For projects that have turned on storage encryption, you cannot turn off storage encryption or change the encryption algorithm. See `encryption` below.
        """
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[_builtins.int]:
        """
        Set the number of days to retain backup data. During this time, you can restore the current version to any backup version. The value range of days is [0,30], and the default value is 1. 0 means backup is turned off.
        The effective policy after adjusting the backup cycle is:
        Extend the backup cycle: The new backup cycle takes effect on the same day.
        Shorten the backup cycle: The system will automatically delete backup data that has exceeded the retention cycle.
        """
        return pulumi.get(self, "retention_days")

    @_builtins.property
    @pulumi.getter(name="sqlMeteringMax")
    def sql_metering_max(self) -> Optional[_builtins.str]:
        """
        Set the maximum threshold for single SQL Consumption, that is, set the ODPS. SQL. metering.value.max attribute. For more information, see [Consumption control](https://www.alibabacloud.com/help/en/maxcompute/product-overview/consumption-control).
        Unit: scan volume (GB)* complexity.
        """
        return pulumi.get(self, "sql_metering_max")

    @_builtins.property
    @pulumi.getter(name="tableLifecycle")
    def table_lifecycle(self) -> Optional['outputs.ProjectPropertiesTableLifecycle']:
        """
        Set whether the lifecycle of the table in the project needs to be configured, that is, set the ODPS. table.lifecycle property, See `table_lifecycle` below.
        """
        return pulumi.get(self, "table_lifecycle")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[_builtins.str]:
        """
        Project time zone, example value: Asia/Shanghai
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="typeSystem")
    def type_system(self) -> Optional[_builtins.str]:
        """
        Data type version. Value:(1/2/hive)
        1: The original MaxCompute type system.
        2: New type system introduced by MaxCompute 2.0.
        hive: the type system of the Hive compatibility mode introduced by MaxCompute 2.0.
        """
        return pulumi.get(self, "type_system")


@pulumi.output_type
class ProjectPropertiesEncryption(dict):
    def __init__(__self__, *,
                 algorithm: Optional[_builtins.str] = None,
                 enable: Optional[_builtins.bool] = None,
                 key: Optional[_builtins.str] = None):
        """
        :param _builtins.str algorithm: The encryption algorithm supported by the key, including AES256, AESCTR, and RC4.
        :param _builtins.bool enable: Only enable function is supported. Value: (true)
               
               > **NOTE:** cannot be turned off after the function is turned on
        :param _builtins.str key: The encryption algorithm Key, the Key type used by the project, including the Default Key (MaxCompute Default Key) and the self-contained Key (BYOK). The MaxCompute Default Key is the Default Key created inside MaxCompute.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[_builtins.str]:
        """
        The encryption algorithm supported by the key, including AES256, AESCTR, and RC4.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[_builtins.bool]:
        """
        Only enable function is supported. Value: (true)

        > **NOTE:** cannot be turned off after the function is turned on
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The encryption algorithm Key, the Key type used by the project, including the Default Key (MaxCompute Default Key) and the self-contained Key (BYOK). The MaxCompute Default Key is the Default Key created inside MaxCompute.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class ProjectPropertiesTableLifecycle(dict):
    def __init__(__self__, *,
                 type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Project type
        :param _builtins.str value: The value of the life cycle, in days. The value range is 1~37231, and the default value is 37231.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Project type
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of the life cycle, in days. The value range is 1~37231, and the default value is 37231.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ProjectSecurityProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableDownloadPrivilege":
            suggest = "enable_download_privilege"
        elif key == "labelSecurity":
            suggest = "label_security"
        elif key == "objectCreatorHasAccessPermission":
            suggest = "object_creator_has_access_permission"
        elif key == "objectCreatorHasGrantPermission":
            suggest = "object_creator_has_grant_permission"
        elif key == "projectProtection":
            suggest = "project_protection"
        elif key == "usingAcl":
            suggest = "using_acl"
        elif key == "usingPolicy":
            suggest = "using_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectSecurityProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectSecurityProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectSecurityProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_download_privilege: Optional[_builtins.bool] = None,
                 label_security: Optional[_builtins.bool] = None,
                 object_creator_has_access_permission: Optional[_builtins.bool] = None,
                 object_creator_has_grant_permission: Optional[_builtins.bool] = None,
                 project_protection: Optional['outputs.ProjectSecurityPropertiesProjectProtection'] = None,
                 using_acl: Optional[_builtins.bool] = None,
                 using_policy: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enable_download_privilege: Set whether to enable the [Download permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/download-control), that is, set the ODPS. security.enabledownloadprivilege property.
        :param _builtins.bool label_security: Set whether to use the [Label permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/label-based-access-control), that is, set the LabelSecurity attribute, which is not used by default.
        :param _builtins.bool object_creator_has_access_permission: Sets whether to allow the creator of the object to have access to the object, I .e. sets the attribute. The default is the allowed state.
        :param _builtins.bool object_creator_has_grant_permission: The ObjectCreatorHasGrantPermission attribute is set to allow the object creator to have the authorization permission on the object. The default is the allowed state.
        :param 'ProjectSecurityPropertiesProjectProtectionArgs' project_protection: Project protection See `project_protection` below.
        :param _builtins.bool using_acl: Set whether to use the [ACL permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/maxcompute-permissions), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
        :param _builtins.bool using_policy: Set whether to use the Policy permission control function (https://www.alibabacloud.com/help/en/maxcompute/user-guide/policy-based-access-control-1), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
        """
        if enable_download_privilege is not None:
            pulumi.set(__self__, "enable_download_privilege", enable_download_privilege)
        if label_security is not None:
            pulumi.set(__self__, "label_security", label_security)
        if object_creator_has_access_permission is not None:
            pulumi.set(__self__, "object_creator_has_access_permission", object_creator_has_access_permission)
        if object_creator_has_grant_permission is not None:
            pulumi.set(__self__, "object_creator_has_grant_permission", object_creator_has_grant_permission)
        if project_protection is not None:
            pulumi.set(__self__, "project_protection", project_protection)
        if using_acl is not None:
            pulumi.set(__self__, "using_acl", using_acl)
        if using_policy is not None:
            pulumi.set(__self__, "using_policy", using_policy)

    @_builtins.property
    @pulumi.getter(name="enableDownloadPrivilege")
    def enable_download_privilege(self) -> Optional[_builtins.bool]:
        """
        Set whether to enable the [Download permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/download-control), that is, set the ODPS. security.enabledownloadprivilege property.
        """
        return pulumi.get(self, "enable_download_privilege")

    @_builtins.property
    @pulumi.getter(name="labelSecurity")
    def label_security(self) -> Optional[_builtins.bool]:
        """
        Set whether to use the [Label permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/label-based-access-control), that is, set the LabelSecurity attribute, which is not used by default.
        """
        return pulumi.get(self, "label_security")

    @_builtins.property
    @pulumi.getter(name="objectCreatorHasAccessPermission")
    def object_creator_has_access_permission(self) -> Optional[_builtins.bool]:
        """
        Sets whether to allow the creator of the object to have access to the object, I .e. sets the attribute. The default is the allowed state.
        """
        return pulumi.get(self, "object_creator_has_access_permission")

    @_builtins.property
    @pulumi.getter(name="objectCreatorHasGrantPermission")
    def object_creator_has_grant_permission(self) -> Optional[_builtins.bool]:
        """
        The ObjectCreatorHasGrantPermission attribute is set to allow the object creator to have the authorization permission on the object. The default is the allowed state.
        """
        return pulumi.get(self, "object_creator_has_grant_permission")

    @_builtins.property
    @pulumi.getter(name="projectProtection")
    def project_protection(self) -> Optional['outputs.ProjectSecurityPropertiesProjectProtection']:
        """
        Project protection See `project_protection` below.
        """
        return pulumi.get(self, "project_protection")

    @_builtins.property
    @pulumi.getter(name="usingAcl")
    def using_acl(self) -> Optional[_builtins.bool]:
        """
        Set whether to use the [ACL permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/maxcompute-permissions), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
        """
        return pulumi.get(self, "using_acl")

    @_builtins.property
    @pulumi.getter(name="usingPolicy")
    def using_policy(self) -> Optional[_builtins.bool]:
        """
        Set whether to use the Policy permission control function (https://www.alibabacloud.com/help/en/maxcompute/user-guide/policy-based-access-control-1), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
        """
        return pulumi.get(self, "using_policy")


@pulumi.output_type
class ProjectSecurityPropertiesProjectProtection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exceptionPolicy":
            suggest = "exception_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectSecurityPropertiesProjectProtection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectSecurityPropertiesProjectProtection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectSecurityPropertiesProjectProtection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exception_policy: Optional[_builtins.str] = None,
                 protected: Optional[_builtins.bool] = None):
        """
        :param _builtins.str exception_policy: Set [Exceptions or Trusted Items](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/project-data-protection)
        :param _builtins.bool protected: Whether enabled, value:(true/false)
        """
        if exception_policy is not None:
            pulumi.set(__self__, "exception_policy", exception_policy)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)

    @_builtins.property
    @pulumi.getter(name="exceptionPolicy")
    def exception_policy(self) -> Optional[_builtins.str]:
        """
        Set [Exceptions or Trusted Items](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/project-data-protection)
        """
        return pulumi.get(self, "exception_policy")

    @_builtins.property
    @pulumi.getter
    def protected(self) -> Optional[_builtins.bool]:
        """
        Whether enabled, value:(true/false)
        """
        return pulumi.get(self, "protected")


@pulumi.output_type
class QuotaPlanQuota(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subQuotaInfoLists":
            suggest = "sub_quota_info_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuotaPlanQuota. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuotaPlanQuota.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuotaPlanQuota.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter: Optional['outputs.QuotaPlanQuotaParameter'] = None,
                 sub_quota_info_lists: Optional[Sequence['outputs.QuotaPlanQuotaSubQuotaInfoList']] = None):
        """
        :param 'QuotaPlanQuotaParameterArgs' parameter: Level 2 Quota CU configuration See `parameter` below.
        :param Sequence['QuotaPlanQuotaSubQuotaInfoListArgs'] sub_quota_info_lists: Secondary Quota list
               
               > **NOTE:** need to list all secondary Quota
               See `sub_quota_info_list` below.
        """
        if parameter is not None:
            pulumi.set(__self__, "parameter", parameter)
        if sub_quota_info_lists is not None:
            pulumi.set(__self__, "sub_quota_info_lists", sub_quota_info_lists)

    @_builtins.property
    @pulumi.getter
    def parameter(self) -> Optional['outputs.QuotaPlanQuotaParameter']:
        """
        Level 2 Quota CU configuration See `parameter` below.
        """
        return pulumi.get(self, "parameter")

    @_builtins.property
    @pulumi.getter(name="subQuotaInfoLists")
    def sub_quota_info_lists(self) -> Optional[Sequence['outputs.QuotaPlanQuotaSubQuotaInfoList']]:
        """
        Secondary Quota list

        > **NOTE:** need to list all secondary Quota
        See `sub_quota_info_list` below.
        """
        return pulumi.get(self, "sub_quota_info_lists")


@pulumi.output_type
class QuotaPlanQuotaParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elasticReservedCu":
            suggest = "elastic_reserved_cu"
        elif key == "maxCu":
            suggest = "max_cu"
        elif key == "minCu":
            suggest = "min_cu"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuotaPlanQuotaParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuotaPlanQuotaParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuotaPlanQuotaParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 elastic_reserved_cu: _builtins.int,
                 max_cu: Optional[_builtins.int] = None,
                 min_cu: Optional[_builtins.int] = None):
        """
        :param _builtins.int elastic_reserved_cu: The value of elastic Reserved CUs.
               
               > **NOTE:**  The total number of elastically reserved CUs in all the level-2 quotas is equal to the number of elastically reserved CUs in the level-1 quota..
        :param _builtins.int max_cu: The value of maxCU in Reserved CUs.
        :param _builtins.int min_cu: The value of minCU in Reserved CUs.
        """
        pulumi.set(__self__, "elastic_reserved_cu", elastic_reserved_cu)
        if max_cu is not None:
            pulumi.set(__self__, "max_cu", max_cu)
        if min_cu is not None:
            pulumi.set(__self__, "min_cu", min_cu)

    @_builtins.property
    @pulumi.getter(name="elasticReservedCu")
    def elastic_reserved_cu(self) -> _builtins.int:
        """
        The value of elastic Reserved CUs.

        > **NOTE:**  The total number of elastically reserved CUs in all the level-2 quotas is equal to the number of elastically reserved CUs in the level-1 quota..
        """
        return pulumi.get(self, "elastic_reserved_cu")

    @_builtins.property
    @pulumi.getter(name="maxCu")
    def max_cu(self) -> Optional[_builtins.int]:
        """
        The value of maxCU in Reserved CUs.
        """
        return pulumi.get(self, "max_cu")

    @_builtins.property
    @pulumi.getter(name="minCu")
    def min_cu(self) -> Optional[_builtins.int]:
        """
        The value of minCU in Reserved CUs.
        """
        return pulumi.get(self, "min_cu")


@pulumi.output_type
class QuotaPlanQuotaSubQuotaInfoList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nickName":
            suggest = "nick_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuotaPlanQuotaSubQuotaInfoList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuotaPlanQuotaSubQuotaInfoList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuotaPlanQuotaSubQuotaInfoList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 nick_name: _builtins.str,
                 parameter: Optional['outputs.QuotaPlanQuotaSubQuotaInfoListParameter'] = None):
        """
        :param _builtins.str nick_name: The nickname of the level-2 quota.
        :param 'QuotaPlanQuotaSubQuotaInfoListParameterArgs' parameter: The parameters of level-1 quota.
        """
        pulumi.set(__self__, "nick_name", nick_name)
        if parameter is not None:
            pulumi.set(__self__, "parameter", parameter)

    @_builtins.property
    @pulumi.getter(name="nickName")
    def nick_name(self) -> _builtins.str:
        """
        The nickname of the level-2 quota.
        """
        return pulumi.get(self, "nick_name")

    @_builtins.property
    @pulumi.getter
    def parameter(self) -> Optional['outputs.QuotaPlanQuotaSubQuotaInfoListParameter']:
        """
        The parameters of level-1 quota.
        """
        return pulumi.get(self, "parameter")


@pulumi.output_type
class QuotaPlanQuotaSubQuotaInfoListParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elasticReservedCu":
            suggest = "elastic_reserved_cu"
        elif key == "maxCu":
            suggest = "max_cu"
        elif key == "minCu":
            suggest = "min_cu"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuotaPlanQuotaSubQuotaInfoListParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuotaPlanQuotaSubQuotaInfoListParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuotaPlanQuotaSubQuotaInfoListParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 elastic_reserved_cu: _builtins.int,
                 max_cu: _builtins.int,
                 min_cu: _builtins.int):
        """
        :param _builtins.int elastic_reserved_cu: The value of elastic Reserved CUs.
               
               > **NOTE:**  The total number of elastically reserved CUs in all the level-2 quotas is equal to the number of elastically reserved CUs in the level-1 quota..
        :param _builtins.int max_cu: The value of maxCU in Reserved CUs.
        :param _builtins.int min_cu: The value of minCU in Reserved CUs.
        """
        pulumi.set(__self__, "elastic_reserved_cu", elastic_reserved_cu)
        pulumi.set(__self__, "max_cu", max_cu)
        pulumi.set(__self__, "min_cu", min_cu)

    @_builtins.property
    @pulumi.getter(name="elasticReservedCu")
    def elastic_reserved_cu(self) -> _builtins.int:
        """
        The value of elastic Reserved CUs.

        > **NOTE:**  The total number of elastically reserved CUs in all the level-2 quotas is equal to the number of elastically reserved CUs in the level-1 quota..
        """
        return pulumi.get(self, "elastic_reserved_cu")

    @_builtins.property
    @pulumi.getter(name="maxCu")
    def max_cu(self) -> _builtins.int:
        """
        The value of maxCU in Reserved CUs.
        """
        return pulumi.get(self, "max_cu")

    @_builtins.property
    @pulumi.getter(name="minCu")
    def min_cu(self) -> _builtins.int:
        """
        The value of minCU in Reserved CUs.
        """
        return pulumi.get(self, "min_cu")


@pulumi.output_type
class QuotaScheduleScheduleList(dict):
    def __init__(__self__, *,
                 plan: _builtins.str,
                 type: _builtins.str,
                 condition: Optional['outputs.QuotaScheduleScheduleListCondition'] = None):
        """
        :param _builtins.str plan: The name of the quota plan.
        :param _builtins.str type: The type of the quota plan. Valid values: daily 
               
               > **NOTE:** Currently, only daily is supported.
        :param 'QuotaScheduleScheduleListConditionArgs' condition: The value of effective condition. See `condition` below.
        """
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "type", type)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> _builtins.str:
        """
        The name of the quota plan.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the quota plan. Valid values: daily 

        > **NOTE:** Currently, only daily is supported.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional['outputs.QuotaScheduleScheduleListCondition']:
        """
        The value of effective condition. See `condition` below.
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class QuotaScheduleScheduleListCondition(dict):
    def __init__(__self__, *,
                 at: _builtins.str):
        """
        :param _builtins.str at: Effective time. The format is HH:mm, sample value: 00:00
               
               > **NOTE:** The configuration must start from the effective time of 00:00. The input time must be either a whole hour or a half hour, and the minimum interval between each schedule is 30 minutes.
        """
        pulumi.set(__self__, "at", at)

    @_builtins.property
    @pulumi.getter
    def at(self) -> _builtins.str:
        """
        Effective time. The format is HH:mm, sample value: 00:00

        > **NOTE:** The configuration must start from the effective time of 00:00. The input time must be either a whole hour or a half hour, and the minimum interval between each schedule is 30 minutes.
        """
        return pulumi.get(self, "at")


@pulumi.output_type
class QuotaSubQuotaInfoList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nickName":
            suggest = "nick_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuotaSubQuotaInfoList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuotaSubQuotaInfoList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuotaSubQuotaInfoList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 nick_name: _builtins.str,
                 parameter: Optional['outputs.QuotaSubQuotaInfoListParameter'] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str nick_name: Secondary Quota nickname.
               
               > **NOTE:** -- Subscription: If you enter partNickName, the first-level QuotaNickName created is os_partNickName_p. Each first-level Quota has a default second-level Quota whose QuotaNickName is os_partNickName . -- The first-level quotanicname created by PayAsYouGo is os_PayAsYouGoQuota_p  by default, the second-level quotanicname is os_PayAsYouGoQuota
        :param 'QuotaSubQuotaInfoListParameterArgs' parameter: Parameter See `parameter` below.
        :param _builtins.str type: The secondary Quota type. The default value is: FUXI_OFFLINE
        """
        pulumi.set(__self__, "nick_name", nick_name)
        if parameter is not None:
            pulumi.set(__self__, "parameter", parameter)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="nickName")
    def nick_name(self) -> _builtins.str:
        """
        Secondary Quota nickname.

        > **NOTE:** -- Subscription: If you enter partNickName, the first-level QuotaNickName created is os_partNickName_p. Each first-level Quota has a default second-level Quota whose QuotaNickName is os_partNickName . -- The first-level quotanicname created by PayAsYouGo is os_PayAsYouGoQuota_p  by default, the second-level quotanicname is os_PayAsYouGoQuota
        """
        return pulumi.get(self, "nick_name")

    @_builtins.property
    @pulumi.getter
    def parameter(self) -> Optional['outputs.QuotaSubQuotaInfoListParameter']:
        """
        Parameter See `parameter` below.
        """
        return pulumi.get(self, "parameter")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The secondary Quota type. The default value is: FUXI_OFFLINE
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class QuotaSubQuotaInfoListParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCu":
            suggest = "max_cu"
        elif key == "minCu":
            suggest = "min_cu"
        elif key == "enablePriority":
            suggest = "enable_priority"
        elif key == "forceReservedMin":
            suggest = "force_reserved_min"
        elif key == "schedulerType":
            suggest = "scheduler_type"
        elif key == "singleJobCuLimit":
            suggest = "single_job_cu_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QuotaSubQuotaInfoListParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QuotaSubQuotaInfoListParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QuotaSubQuotaInfoListParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_cu: _builtins.int,
                 min_cu: _builtins.int,
                 enable_priority: Optional[_builtins.bool] = None,
                 force_reserved_min: Optional[_builtins.bool] = None,
                 scheduler_type: Optional[_builtins.str] = None,
                 single_job_cu_limit: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_cu: The value of maxCU in Reserved CUs.
               
               > **NOTE:**  The value of maxCU must be less than or equal to the value of maxCU in the level-1 quota that you purchased.
        :param _builtins.int min_cu: The value of minCU in Reserved CUs.
               
               > **NOTE:**  -- The total value of minCU in all the level-2 quotas is equal to the value of minCU in the level-1 quota.    -- The value of minCU must be less than or equal to the value of maxCU in the level-2 quota and less than or equal to the value of minCU in the level-1 quota that you purchased.
        :param _builtins.bool enable_priority: Enable priority. Valid values: true/false, default: false
        :param _builtins.bool force_reserved_min: Exclusive or not. Valid values: true/false, default: false
        :param _builtins.str scheduler_type: Scheduling policy. Valid values: Fifo/Fair, default: Fifo
        :param _builtins.int single_job_cu_limit: Single job CU upper limit. Valid value: greater than or equal to 1
               
               > **NOTE:** -- If you want to not restrict SingleJobCuLimit, please make sure that this parameter is not included in the configuration at all. That is, do not configure SingleJobCuLimit to "null" or any other invalid value
        """
        pulumi.set(__self__, "max_cu", max_cu)
        pulumi.set(__self__, "min_cu", min_cu)
        if enable_priority is not None:
            pulumi.set(__self__, "enable_priority", enable_priority)
        if force_reserved_min is not None:
            pulumi.set(__self__, "force_reserved_min", force_reserved_min)
        if scheduler_type is not None:
            pulumi.set(__self__, "scheduler_type", scheduler_type)
        if single_job_cu_limit is not None:
            pulumi.set(__self__, "single_job_cu_limit", single_job_cu_limit)

    @_builtins.property
    @pulumi.getter(name="maxCu")
    def max_cu(self) -> _builtins.int:
        """
        The value of maxCU in Reserved CUs.

        > **NOTE:**  The value of maxCU must be less than or equal to the value of maxCU in the level-1 quota that you purchased.
        """
        return pulumi.get(self, "max_cu")

    @_builtins.property
    @pulumi.getter(name="minCu")
    def min_cu(self) -> _builtins.int:
        """
        The value of minCU in Reserved CUs.

        > **NOTE:**  -- The total value of minCU in all the level-2 quotas is equal to the value of minCU in the level-1 quota.    -- The value of minCU must be less than or equal to the value of maxCU in the level-2 quota and less than or equal to the value of minCU in the level-1 quota that you purchased.
        """
        return pulumi.get(self, "min_cu")

    @_builtins.property
    @pulumi.getter(name="enablePriority")
    def enable_priority(self) -> Optional[_builtins.bool]:
        """
        Enable priority. Valid values: true/false, default: false
        """
        return pulumi.get(self, "enable_priority")

    @_builtins.property
    @pulumi.getter(name="forceReservedMin")
    def force_reserved_min(self) -> Optional[_builtins.bool]:
        """
        Exclusive or not. Valid values: true/false, default: false
        """
        return pulumi.get(self, "force_reserved_min")

    @_builtins.property
    @pulumi.getter(name="schedulerType")
    def scheduler_type(self) -> Optional[_builtins.str]:
        """
        Scheduling policy. Valid values: Fifo/Fair, default: Fifo
        """
        return pulumi.get(self, "scheduler_type")

    @_builtins.property
    @pulumi.getter(name="singleJobCuLimit")
    def single_job_cu_limit(self) -> Optional[_builtins.int]:
        """
        Single job CU upper limit. Valid value: greater than or equal to 1

        > **NOTE:** -- If you want to not restrict SingleJobCuLimit, please make sure that this parameter is not included in the configuration at all. That is, do not configure SingleJobCuLimit to "null" or any other invalid value
        """
        return pulumi.get(self, "single_job_cu_limit")


@pulumi.output_type
class TunnelQuotaTimerQuotaTimer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "beginTime":
            suggest = "begin_time"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "tunnelQuotaParameter":
            suggest = "tunnel_quota_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TunnelQuotaTimerQuotaTimer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TunnelQuotaTimerQuotaTimer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TunnelQuotaTimerQuotaTimer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 begin_time: _builtins.str,
                 end_time: _builtins.str,
                 tunnel_quota_parameter: Optional['outputs.TunnelQuotaTimerQuotaTimerTunnelQuotaParameter'] = None):
        """
        :param _builtins.str begin_time: The time-sharing configuration start time. Reference value: 00:00
        :param _builtins.str end_time: The end time of the timesharing configuration. Reference value: 24:00
        :param 'TunnelQuotaTimerQuotaTimerTunnelQuotaParameterArgs' tunnel_quota_parameter: Time-sharing configuration parameters. See `tunnel_quota_parameter` below.
        """
        pulumi.set(__self__, "begin_time", begin_time)
        pulumi.set(__self__, "end_time", end_time)
        if tunnel_quota_parameter is not None:
            pulumi.set(__self__, "tunnel_quota_parameter", tunnel_quota_parameter)

    @_builtins.property
    @pulumi.getter(name="beginTime")
    def begin_time(self) -> _builtins.str:
        """
        The time-sharing configuration start time. Reference value: 00:00
        """
        return pulumi.get(self, "begin_time")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        The end time of the timesharing configuration. Reference value: 24:00
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="tunnelQuotaParameter")
    def tunnel_quota_parameter(self) -> Optional['outputs.TunnelQuotaTimerQuotaTimerTunnelQuotaParameter']:
        """
        Time-sharing configuration parameters. See `tunnel_quota_parameter` below.
        """
        return pulumi.get(self, "tunnel_quota_parameter")


@pulumi.output_type
class TunnelQuotaTimerQuotaTimerTunnelQuotaParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elasticReservedSlotNum":
            suggest = "elastic_reserved_slot_num"
        elif key == "slotNum":
            suggest = "slot_num"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TunnelQuotaTimerQuotaTimerTunnelQuotaParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TunnelQuotaTimerQuotaTimerTunnelQuotaParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TunnelQuotaTimerQuotaTimerTunnelQuotaParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 elastic_reserved_slot_num: _builtins.int,
                 slot_num: _builtins.int):
        """
        :param _builtins.int elastic_reserved_slot_num: The number of elastic reserved concurrency (Slot).
        :param _builtins.int slot_num: The number of reserved concurrency (Slot).
               
               > **NOTE:** The reserved concurrency (Slot) cannot be modified. The number of concurrency slots must be the same as that of the purchased tunnel quota.
        """
        pulumi.set(__self__, "elastic_reserved_slot_num", elastic_reserved_slot_num)
        pulumi.set(__self__, "slot_num", slot_num)

    @_builtins.property
    @pulumi.getter(name="elasticReservedSlotNum")
    def elastic_reserved_slot_num(self) -> _builtins.int:
        """
        The number of elastic reserved concurrency (Slot).
        """
        return pulumi.get(self, "elastic_reserved_slot_num")

    @_builtins.property
    @pulumi.getter(name="slotNum")
    def slot_num(self) -> _builtins.int:
        """
        The number of reserved concurrency (Slot).

        > **NOTE:** The reserved concurrency (Slot) cannot be modified. The number of concurrency slots must be the same as that of the purchased tunnel quota.
        """
        return pulumi.get(self, "slot_num")


@pulumi.output_type
class GetProjectsProjectResult(dict):
    def __init__(__self__, *,
                 comment: _builtins.str,
                 cost_storage: _builtins.str,
                 create_time: _builtins.str,
                 default_quota: _builtins.str,
                 ip_white_list: 'outputs.GetProjectsProjectIpWhiteListResult',
                 owner: _builtins.str,
                 project_name: _builtins.str,
                 properties: 'outputs.GetProjectsProjectPropertiesResult',
                 security_properties: 'outputs.GetProjectsProjectSecurityPropertiesResult',
                 status: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str comment: Project description information. The length is 1 to 256 English or Chinese characters. The default value is blank.
        :param _builtins.str cost_storage: View the current storage size of the Project. The storage size is the same as the measurement size, that is, the compressed logical storage size collected by the Project.
        :param _builtins.str create_time: Represents the creation time of the project
        :param _builtins.str default_quota: Used to implement computing resource allocation.If the calculation Quota is not specified, the default Quota resource will be consumed by jobs initiated by the project. For more information about computing resource usage, see [Computing Resource Usage](https://www.alibabacloud.com/help/en/maxcompute/user-guide/use-of-computing-resources).
        :param 'GetProjectsProjectIpWhiteListArgs' ip_white_list: IP whitelist
        :param _builtins.str owner: Project owner
        :param _builtins.str project_name: The name begins with a letter, containing letters, digits, and underscores (_). It can be 3 to 28 characters in length and is globally unique.
        :param 'GetProjectsProjectPropertiesArgs' properties: Project base attributes
        :param 'GetProjectsProjectSecurityPropertiesArgs' security_properties: Security-related attributes
        :param _builtins.str status: The project status. Default value: AVAILABLE. Value: (AVAILABLE/READONLY/FROZEN/DELETING)
        :param _builtins.str type: Project type
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "cost_storage", cost_storage)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "default_quota", default_quota)
        pulumi.set(__self__, "ip_white_list", ip_white_list)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "security_properties", security_properties)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        Project description information. The length is 1 to 256 English or Chinese characters. The default value is blank.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="costStorage")
    def cost_storage(self) -> _builtins.str:
        """
        View the current storage size of the Project. The storage size is the same as the measurement size, that is, the compressed logical storage size collected by the Project.
        """
        return pulumi.get(self, "cost_storage")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Represents the creation time of the project
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="defaultQuota")
    def default_quota(self) -> _builtins.str:
        """
        Used to implement computing resource allocation.If the calculation Quota is not specified, the default Quota resource will be consumed by jobs initiated by the project. For more information about computing resource usage, see [Computing Resource Usage](https://www.alibabacloud.com/help/en/maxcompute/user-guide/use-of-computing-resources).
        """
        return pulumi.get(self, "default_quota")

    @_builtins.property
    @pulumi.getter(name="ipWhiteList")
    def ip_white_list(self) -> 'outputs.GetProjectsProjectIpWhiteListResult':
        """
        IP whitelist
        """
        return pulumi.get(self, "ip_white_list")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        """
        Project owner
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> _builtins.str:
        """
        The name begins with a letter, containing letters, digits, and underscores (_). It can be 3 to 28 characters in length and is globally unique.
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> 'outputs.GetProjectsProjectPropertiesResult':
        """
        Project base attributes
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="securityProperties")
    def security_properties(self) -> 'outputs.GetProjectsProjectSecurityPropertiesResult':
        """
        Security-related attributes
        """
        return pulumi.get(self, "security_properties")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The project status. Default value: AVAILABLE. Value: (AVAILABLE/READONLY/FROZEN/DELETING)
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Project type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetProjectsProjectIpWhiteListResult(dict):
    def __init__(__self__, *,
                 ip_list: _builtins.str,
                 vpc_ip_list: _builtins.str):
        """
        :param _builtins.str ip_list: Set the IP address whitelist in the classic network. Only devices in the whitelist are allowed to access the project.> **NOTE:** If you only configure a classic network IP address whitelist, access to the classic network is restricted and all access to the VPC is prohibited.
        :param _builtins.str vpc_ip_list: Set the IP address whitelist in the VPC network to allow only devices in the whitelist to access the project space.> **NOTE:** If you only configure a VPC network IP address whitelist, access to the VPC network is restricted and access to the classic network is prohibited.
        """
        pulumi.set(__self__, "ip_list", ip_list)
        pulumi.set(__self__, "vpc_ip_list", vpc_ip_list)

    @_builtins.property
    @pulumi.getter(name="ipList")
    def ip_list(self) -> _builtins.str:
        """
        Set the IP address whitelist in the classic network. Only devices in the whitelist are allowed to access the project.> **NOTE:** If you only configure a classic network IP address whitelist, access to the classic network is restricted and all access to the VPC is prohibited.
        """
        return pulumi.get(self, "ip_list")

    @_builtins.property
    @pulumi.getter(name="vpcIpList")
    def vpc_ip_list(self) -> _builtins.str:
        """
        Set the IP address whitelist in the VPC network to allow only devices in the whitelist to access the project space.> **NOTE:** If you only configure a VPC network IP address whitelist, access to the VPC network is restricted and access to the classic network is prohibited.
        """
        return pulumi.get(self, "vpc_ip_list")


@pulumi.output_type
class GetProjectsProjectPropertiesResult(dict):
    def __init__(__self__, *,
                 allow_full_scan: _builtins.bool,
                 enable_decimal2: _builtins.bool,
                 encryption: 'outputs.GetProjectsProjectPropertiesEncryptionResult',
                 retention_days: _builtins.int,
                 sql_metering_max: _builtins.str,
                 table_lifecycle: 'outputs.GetProjectsProjectPropertiesTableLifecycleResult',
                 timezone: _builtins.str,
                 type_system: _builtins.str):
        """
        :param _builtins.bool allow_full_scan: Whether to allow full table scan. Default: false.
        :param _builtins.bool enable_decimal2: Whether to turn on Decimal2.0.
        :param 'GetProjectsProjectPropertiesEncryptionArgs' encryption: Storage encryption. For details, see [Storage Encryption](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/storage-encryption)> **NOTE :**:To enable storage encryption, you need to modify the parameters of the basic attributes of the MaxCompute project. This operation permission is authenticated by RAM, and you need to have the Super_Administrator role permission of the corresponding project.To configure the permissions and IP whitelist parameters of the MaxCompute project, you must have the management permissions (Admin) of the corresponding project, including Super_Administrator, Admin, or custom management permissions. For more information, see the project management permissions list.You can turn on storage encryption only for projects that have not turned on storage encryption. For projects that have turned on storage encryption, you cannot turn off storage encryption or change the encryption algorithm.
        :param _builtins.int retention_days: Set the number of days to retain backup data. During this time, you can restore the current version to any backup version. The value range of days is [0,30], and the default value is 1. 0 means backup is turned off.The effective policy after adjusting the backup cycle is:Extend the backup cycle: The new backup cycle takes effect on the same day.Shorten the backup cycle: The system will automatically delete backup data that has exceeded the retention cycle.
        :param _builtins.str sql_metering_max: Set the maximum threshold of single SQL consumption, that is, set the ODPS. SQL. metering.value.max attribute. For details, see [Consumption Monitoring Alarm](https://www.alibabacloud.com/help/en/maxcompute/product-overview/consumption-control).Unit: scan volume (GB)* complexity.
        :param 'GetProjectsProjectPropertiesTableLifecycleArgs' table_lifecycle: Set whether the lifecycle of the table in the project needs to be configured, that is, set the ODPS. table.lifecycle property,.
        :param _builtins.str timezone: Project time zone, example value: Asia/Shanghai.
        :param _builtins.str type_system: Data type version. Value:(1/2/hive)1: The original MaxCompute type system.2: New type system introduced by MaxCompute 2.0.hive: the type system of the Hive compatibility mode introduced by MaxCompute 2.0.
        """
        pulumi.set(__self__, "allow_full_scan", allow_full_scan)
        pulumi.set(__self__, "enable_decimal2", enable_decimal2)
        pulumi.set(__self__, "encryption", encryption)
        pulumi.set(__self__, "retention_days", retention_days)
        pulumi.set(__self__, "sql_metering_max", sql_metering_max)
        pulumi.set(__self__, "table_lifecycle", table_lifecycle)
        pulumi.set(__self__, "timezone", timezone)
        pulumi.set(__self__, "type_system", type_system)

    @_builtins.property
    @pulumi.getter(name="allowFullScan")
    def allow_full_scan(self) -> _builtins.bool:
        """
        Whether to allow full table scan. Default: false.
        """
        return pulumi.get(self, "allow_full_scan")

    @_builtins.property
    @pulumi.getter(name="enableDecimal2")
    def enable_decimal2(self) -> _builtins.bool:
        """
        Whether to turn on Decimal2.0.
        """
        return pulumi.get(self, "enable_decimal2")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> 'outputs.GetProjectsProjectPropertiesEncryptionResult':
        """
        Storage encryption. For details, see [Storage Encryption](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/storage-encryption)> **NOTE :**:To enable storage encryption, you need to modify the parameters of the basic attributes of the MaxCompute project. This operation permission is authenticated by RAM, and you need to have the Super_Administrator role permission of the corresponding project.To configure the permissions and IP whitelist parameters of the MaxCompute project, you must have the management permissions (Admin) of the corresponding project, including Super_Administrator, Admin, or custom management permissions. For more information, see the project management permissions list.You can turn on storage encryption only for projects that have not turned on storage encryption. For projects that have turned on storage encryption, you cannot turn off storage encryption or change the encryption algorithm.
        """
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> _builtins.int:
        """
        Set the number of days to retain backup data. During this time, you can restore the current version to any backup version. The value range of days is [0,30], and the default value is 1. 0 means backup is turned off.The effective policy after adjusting the backup cycle is:Extend the backup cycle: The new backup cycle takes effect on the same day.Shorten the backup cycle: The system will automatically delete backup data that has exceeded the retention cycle.
        """
        return pulumi.get(self, "retention_days")

    @_builtins.property
    @pulumi.getter(name="sqlMeteringMax")
    def sql_metering_max(self) -> _builtins.str:
        """
        Set the maximum threshold of single SQL consumption, that is, set the ODPS. SQL. metering.value.max attribute. For details, see [Consumption Monitoring Alarm](https://www.alibabacloud.com/help/en/maxcompute/product-overview/consumption-control).Unit: scan volume (GB)* complexity.
        """
        return pulumi.get(self, "sql_metering_max")

    @_builtins.property
    @pulumi.getter(name="tableLifecycle")
    def table_lifecycle(self) -> 'outputs.GetProjectsProjectPropertiesTableLifecycleResult':
        """
        Set whether the lifecycle of the table in the project needs to be configured, that is, set the ODPS. table.lifecycle property,.
        """
        return pulumi.get(self, "table_lifecycle")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> _builtins.str:
        """
        Project time zone, example value: Asia/Shanghai.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="typeSystem")
    def type_system(self) -> _builtins.str:
        """
        Data type version. Value:(1/2/hive)1: The original MaxCompute type system.2: New type system introduced by MaxCompute 2.0.hive: the type system of the Hive compatibility mode introduced by MaxCompute 2.0.
        """
        return pulumi.get(self, "type_system")


@pulumi.output_type
class GetProjectsProjectPropertiesEncryptionResult(dict):
    def __init__(__self__, *,
                 algorithm: _builtins.str,
                 enable: _builtins.bool,
                 key: _builtins.str):
        """
        :param _builtins.str algorithm: The encryption algorithm supported by the key, including AES256, AESCTR, and RC4.
        :param _builtins.bool enable: Only enable function is supported. Value: (true).
        :param _builtins.str key: The encryption algorithm Key, the Key type used by the project, including the Default Key (MaxCompute Default Key) and the self-contained Key (BYOK). The MaxCompute Default Key is the Default Key created inside MaxCompute.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> _builtins.str:
        """
        The encryption algorithm supported by the key, including AES256, AESCTR, and RC4.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> _builtins.bool:
        """
        Only enable function is supported. Value: (true).
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The encryption algorithm Key, the Key type used by the project, including the Default Key (MaxCompute Default Key) and the self-contained Key (BYOK). The MaxCompute Default Key is the Default Key created inside MaxCompute.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class GetProjectsProjectPropertiesTableLifecycleResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str type: Project type
        :param _builtins.str value: The value of the life cycle, in days. The value range is 1~37231, and the default value is 37231.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Project type
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the life cycle, in days. The value range is 1~37231, and the default value is 37231.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetProjectsProjectSecurityPropertiesResult(dict):
    def __init__(__self__, *,
                 enable_download_privilege: _builtins.bool,
                 label_security: _builtins.bool,
                 object_creator_has_access_permission: _builtins.bool,
                 object_creator_has_grant_permission: _builtins.bool,
                 project_protection: 'outputs.GetProjectsProjectSecurityPropertiesProjectProtectionResult',
                 using_acl: _builtins.bool,
                 using_policy: _builtins.bool):
        """
        :param _builtins.bool enable_download_privilege: Set whether to enable the [Download permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/download-control), that is, set the ODPS. security.enabledownloadprivilege property.
        :param _builtins.bool label_security: Set whether to use the [Label permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/label-based-access-control), that is, set the LabelSecurity attribute, which is not used by default.
        :param _builtins.bool object_creator_has_access_permission: Sets whether to allow the creator of the object to have access to the object, I .e. sets the attribute. The default is the allowed state.
        :param _builtins.bool object_creator_has_grant_permission: The ObjectCreatorHasGrantPermission attribute is set to allow the object creator to have the authorization permission on the object. The default is the allowed state.
        :param 'GetProjectsProjectSecurityPropertiesProjectProtectionArgs' project_protection: Project protection.
        :param _builtins.bool using_acl: Set whether to use the [ACL permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/maxcompute-permissions), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
        :param _builtins.bool using_policy: Set whether to use the Policy permission control function (https://www.alibabacloud.com/help/en/maxcompute/user-guide/policy-based-access-control-1), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
        """
        pulumi.set(__self__, "enable_download_privilege", enable_download_privilege)
        pulumi.set(__self__, "label_security", label_security)
        pulumi.set(__self__, "object_creator_has_access_permission", object_creator_has_access_permission)
        pulumi.set(__self__, "object_creator_has_grant_permission", object_creator_has_grant_permission)
        pulumi.set(__self__, "project_protection", project_protection)
        pulumi.set(__self__, "using_acl", using_acl)
        pulumi.set(__self__, "using_policy", using_policy)

    @_builtins.property
    @pulumi.getter(name="enableDownloadPrivilege")
    def enable_download_privilege(self) -> _builtins.bool:
        """
        Set whether to enable the [Download permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/download-control), that is, set the ODPS. security.enabledownloadprivilege property.
        """
        return pulumi.get(self, "enable_download_privilege")

    @_builtins.property
    @pulumi.getter(name="labelSecurity")
    def label_security(self) -> _builtins.bool:
        """
        Set whether to use the [Label permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/label-based-access-control), that is, set the LabelSecurity attribute, which is not used by default.
        """
        return pulumi.get(self, "label_security")

    @_builtins.property
    @pulumi.getter(name="objectCreatorHasAccessPermission")
    def object_creator_has_access_permission(self) -> _builtins.bool:
        """
        Sets whether to allow the creator of the object to have access to the object, I .e. sets the attribute. The default is the allowed state.
        """
        return pulumi.get(self, "object_creator_has_access_permission")

    @_builtins.property
    @pulumi.getter(name="objectCreatorHasGrantPermission")
    def object_creator_has_grant_permission(self) -> _builtins.bool:
        """
        The ObjectCreatorHasGrantPermission attribute is set to allow the object creator to have the authorization permission on the object. The default is the allowed state.
        """
        return pulumi.get(self, "object_creator_has_grant_permission")

    @_builtins.property
    @pulumi.getter(name="projectProtection")
    def project_protection(self) -> 'outputs.GetProjectsProjectSecurityPropertiesProjectProtectionResult':
        """
        Project protection.
        """
        return pulumi.get(self, "project_protection")

    @_builtins.property
    @pulumi.getter(name="usingAcl")
    def using_acl(self) -> _builtins.bool:
        """
        Set whether to use the [ACL permission control function](https://www.alibabacloud.com/help/en/maxcompute/user-guide/maxcompute-permissions), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
        """
        return pulumi.get(self, "using_acl")

    @_builtins.property
    @pulumi.getter(name="usingPolicy")
    def using_policy(self) -> _builtins.bool:
        """
        Set whether to use the Policy permission control function (https://www.alibabacloud.com/help/en/maxcompute/user-guide/policy-based-access-control-1), that is, set the CheckPermissionUsingACL attribute, which is in use by default.
        """
        return pulumi.get(self, "using_policy")


@pulumi.output_type
class GetProjectsProjectSecurityPropertiesProjectProtectionResult(dict):
    def __init__(__self__, *,
                 exception_policy: _builtins.str,
                 protected: _builtins.bool):
        """
        :param _builtins.str exception_policy: Set [Exceptions or Trusted Items](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/project-data-protection).
        :param _builtins.bool protected: Whether enabled, value:(true/false).
        """
        pulumi.set(__self__, "exception_policy", exception_policy)
        pulumi.set(__self__, "protected", protected)

    @_builtins.property
    @pulumi.getter(name="exceptionPolicy")
    def exception_policy(self) -> _builtins.str:
        """
        Set [Exceptions or Trusted Items](https://www.alibabacloud.com/help/en/maxcompute/security-and-compliance/project-data-protection).
        """
        return pulumi.get(self, "exception_policy")

    @_builtins.property
    @pulumi.getter
    def protected(self) -> _builtins.bool:
        """
        Whether enabled, value:(true/false).
        """
        return pulumi.get(self, "protected")


