# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QuotaScheduleArgs', 'QuotaSchedule']

@pulumi.input_type
class QuotaScheduleArgs:
    def __init__(__self__, *,
                 nickname: pulumi.Input[_builtins.str],
                 timezone: pulumi.Input[_builtins.str],
                 schedule_lists: Optional[pulumi.Input[Sequence[pulumi.Input['QuotaScheduleScheduleListArgs']]]] = None):
        """
        The set of arguments for constructing a QuotaSchedule resource.
        :param pulumi.Input[_builtins.str] nickname: The nickname of level-1 compute quota.
        :param pulumi.Input[_builtins.str] timezone: Time zone, reference value: UTC +8
        :param pulumi.Input[Sequence[pulumi.Input['QuotaScheduleScheduleListArgs']]] schedule_lists: schedule list See `schedule_list` below.
        """
        pulumi.set(__self__, "nickname", nickname)
        pulumi.set(__self__, "timezone", timezone)
        if schedule_lists is not None:
            pulumi.set(__self__, "schedule_lists", schedule_lists)

    @_builtins.property
    @pulumi.getter
    def nickname(self) -> pulumi.Input[_builtins.str]:
        """
        The nickname of level-1 compute quota.
        """
        return pulumi.get(self, "nickname")

    @nickname.setter
    def nickname(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nickname", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Input[_builtins.str]:
        """
        Time zone, reference value: UTC +8
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="scheduleLists")
    def schedule_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QuotaScheduleScheduleListArgs']]]]:
        """
        schedule list See `schedule_list` below.
        """
        return pulumi.get(self, "schedule_lists")

    @schedule_lists.setter
    def schedule_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QuotaScheduleScheduleListArgs']]]]):
        pulumi.set(self, "schedule_lists", value)


@pulumi.input_type
class _QuotaScheduleState:
    def __init__(__self__, *,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_lists: Optional[pulumi.Input[Sequence[pulumi.Input['QuotaScheduleScheduleListArgs']]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering QuotaSchedule resources.
        :param pulumi.Input[_builtins.str] nickname: The nickname of level-1 compute quota.
        :param pulumi.Input[Sequence[pulumi.Input['QuotaScheduleScheduleListArgs']]] schedule_lists: schedule list See `schedule_list` below.
        :param pulumi.Input[_builtins.str] timezone: Time zone, reference value: UTC +8
        """
        if nickname is not None:
            pulumi.set(__self__, "nickname", nickname)
        if schedule_lists is not None:
            pulumi.set(__self__, "schedule_lists", schedule_lists)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter
    def nickname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The nickname of level-1 compute quota.
        """
        return pulumi.get(self, "nickname")

    @nickname.setter
    def nickname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nickname", value)

    @_builtins.property
    @pulumi.getter(name="scheduleLists")
    def schedule_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QuotaScheduleScheduleListArgs']]]]:
        """
        schedule list See `schedule_list` below.
        """
        return pulumi.get(self, "schedule_lists")

    @schedule_lists.setter
    def schedule_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QuotaScheduleScheduleListArgs']]]]):
        pulumi.set(self, "schedule_lists", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time zone, reference value: UTC +8
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)


@pulumi.type_token("alicloud:maxcompute/quotaSchedule:QuotaSchedule")
class QuotaSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QuotaScheduleScheduleListArgs', 'QuotaScheduleScheduleListArgsDict']]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Max Compute Quota Schedule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:maxcompute/quotaSchedule:QuotaSchedule example <nickname>:<timezone>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] nickname: The nickname of level-1 compute quota.
        :param pulumi.Input[Sequence[pulumi.Input[Union['QuotaScheduleScheduleListArgs', 'QuotaScheduleScheduleListArgsDict']]]] schedule_lists: schedule list See `schedule_list` below.
        :param pulumi.Input[_builtins.str] timezone: Time zone, reference value: UTC +8
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QuotaScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Max Compute Quota Schedule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:maxcompute/quotaSchedule:QuotaSchedule example <nickname>:<timezone>
        ```

        :param str resource_name: The name of the resource.
        :param QuotaScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QuotaScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QuotaScheduleScheduleListArgs', 'QuotaScheduleScheduleListArgsDict']]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QuotaScheduleArgs.__new__(QuotaScheduleArgs)

            if nickname is None and not opts.urn:
                raise TypeError("Missing required property 'nickname'")
            __props__.__dict__["nickname"] = nickname
            __props__.__dict__["schedule_lists"] = schedule_lists
            if timezone is None and not opts.urn:
                raise TypeError("Missing required property 'timezone'")
            __props__.__dict__["timezone"] = timezone
        super(QuotaSchedule, __self__).__init__(
            'alicloud:maxcompute/quotaSchedule:QuotaSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            nickname: Optional[pulumi.Input[_builtins.str]] = None,
            schedule_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QuotaScheduleScheduleListArgs', 'QuotaScheduleScheduleListArgsDict']]]]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None) -> 'QuotaSchedule':
        """
        Get an existing QuotaSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] nickname: The nickname of level-1 compute quota.
        :param pulumi.Input[Sequence[pulumi.Input[Union['QuotaScheduleScheduleListArgs', 'QuotaScheduleScheduleListArgsDict']]]] schedule_lists: schedule list See `schedule_list` below.
        :param pulumi.Input[_builtins.str] timezone: Time zone, reference value: UTC +8
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QuotaScheduleState.__new__(_QuotaScheduleState)

        __props__.__dict__["nickname"] = nickname
        __props__.__dict__["schedule_lists"] = schedule_lists
        __props__.__dict__["timezone"] = timezone
        return QuotaSchedule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def nickname(self) -> pulumi.Output[_builtins.str]:
        """
        The nickname of level-1 compute quota.
        """
        return pulumi.get(self, "nickname")

    @_builtins.property
    @pulumi.getter(name="scheduleLists")
    def schedule_lists(self) -> pulumi.Output[Optional[Sequence['outputs.QuotaScheduleScheduleList']]]:
        """
        schedule list See `schedule_list` below.
        """
        return pulumi.get(self, "schedule_lists")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[_builtins.str]:
        """
        Time zone, reference value: UTC +8
        """
        return pulumi.get(self, "timezone")

