# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServiceEndpointAclArgs', 'ServiceEndpointAcl']

@pulumi.input_type
class ServiceEndpointAclArgs:
    def __init__(__self__, *,
                 acl_strategy: pulumi.Input[_builtins.str],
                 cidr: pulumi.Input[_builtins.str],
                 endpoint_type: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ServiceEndpointAcl resource.
        :param pulumi.Input[_builtins.str] acl_strategy: The ACL policy. Valid value:
               - allow: indicates that the current endpoint allows access from the corresponding CIDR block. (Only allow is supported)
        :param pulumi.Input[_builtins.str] endpoint_type: Access point type. Value:
               - public: indicates a public access point. (Currently only public is supported)
        """
        pulumi.set(__self__, "acl_strategy", acl_strategy)
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "endpoint_type", endpoint_type)

    @_builtins.property
    @pulumi.getter(name="aclStrategy")
    def acl_strategy(self) -> pulumi.Input[_builtins.str]:
        """
        The ACL policy. Valid value:
        - allow: indicates that the current endpoint allows access from the corresponding CIDR block. (Only allow is supported)
        """
        return pulumi.get(self, "acl_strategy")

    @acl_strategy.setter
    def acl_strategy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "acl_strategy", value)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[_builtins.str]:
        """
        Access point type. Value:
        - public: indicates a public access point. (Currently only public is supported)
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint_type", value)


@pulumi.input_type
class _ServiceEndpointAclState:
    def __init__(__self__, *,
                 acl_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceEndpointAcl resources.
        :param pulumi.Input[_builtins.str] acl_strategy: The ACL policy. Valid value:
               - allow: indicates that the current endpoint allows access from the corresponding CIDR block. (Only allow is supported)
        :param pulumi.Input[_builtins.str] endpoint_type: Access point type. Value:
               - public: indicates a public access point. (Currently only public is supported)
        """
        if acl_strategy is not None:
            pulumi.set(__self__, "acl_strategy", acl_strategy)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)

    @_builtins.property
    @pulumi.getter(name="aclStrategy")
    def acl_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ACL policy. Valid value:
        - allow: indicates that the current endpoint allows access from the corresponding CIDR block. (Only allow is supported)
        """
        return pulumi.get(self, "acl_strategy")

    @acl_strategy.setter
    def acl_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_strategy", value)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr", value)

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access point type. Value:
        - public: indicates a public access point. (Currently only public is supported)
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_type", value)


@pulumi.type_token("alicloud:message/serviceEndpointAcl:ServiceEndpointAcl")
class ServiceEndpointAcl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Message Service Endpoint Acl resource.

        For information about Message Service Endpoint Acl and how to use it, see [What is Endpoint Acl](https://www.alibabacloud.com/help/en/mns/developer-reference/api-mns-open-2022-01-19-authorizeendpointacl).

        > **NOTE:** Available since v1.243.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.message.ServiceEndpoint("default",
            endpoint_enabled=True,
            endpoint_type="public")
        default_service_endpoint_acl = alicloud.message.ServiceEndpointAcl("default",
            cidr="192.168.1.1/23",
            endpoint_type=default.id,
            acl_strategy="allow")
        ```

        ## Import

        Message Service Endpoint Acl can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:message/serviceEndpointAcl:ServiceEndpointAcl example <endpoint_type>:<acl_strategy>:<cidr>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_strategy: The ACL policy. Valid value:
               - allow: indicates that the current endpoint allows access from the corresponding CIDR block. (Only allow is supported)
        :param pulumi.Input[_builtins.str] endpoint_type: Access point type. Value:
               - public: indicates a public access point. (Currently only public is supported)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceEndpointAclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Message Service Endpoint Acl resource.

        For information about Message Service Endpoint Acl and how to use it, see [What is Endpoint Acl](https://www.alibabacloud.com/help/en/mns/developer-reference/api-mns-open-2022-01-19-authorizeendpointacl).

        > **NOTE:** Available since v1.243.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.message.ServiceEndpoint("default",
            endpoint_enabled=True,
            endpoint_type="public")
        default_service_endpoint_acl = alicloud.message.ServiceEndpointAcl("default",
            cidr="192.168.1.1/23",
            endpoint_type=default.id,
            acl_strategy="allow")
        ```

        ## Import

        Message Service Endpoint Acl can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:message/serviceEndpointAcl:ServiceEndpointAcl example <endpoint_type>:<acl_strategy>:<cidr>
        ```

        :param str resource_name: The name of the resource.
        :param ServiceEndpointAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceEndpointAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceEndpointAclArgs.__new__(ServiceEndpointAclArgs)

            if acl_strategy is None and not opts.urn:
                raise TypeError("Missing required property 'acl_strategy'")
            __props__.__dict__["acl_strategy"] = acl_strategy
            if cidr is None and not opts.urn:
                raise TypeError("Missing required property 'cidr'")
            __props__.__dict__["cidr"] = cidr
            if endpoint_type is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_type'")
            __props__.__dict__["endpoint_type"] = endpoint_type
        super(ServiceEndpointAcl, __self__).__init__(
            'alicloud:message/serviceEndpointAcl:ServiceEndpointAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            cidr: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceEndpointAcl':
        """
        Get an existing ServiceEndpointAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_strategy: The ACL policy. Valid value:
               - allow: indicates that the current endpoint allows access from the corresponding CIDR block. (Only allow is supported)
        :param pulumi.Input[_builtins.str] endpoint_type: Access point type. Value:
               - public: indicates a public access point. (Currently only public is supported)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceEndpointAclState.__new__(_ServiceEndpointAclState)

        __props__.__dict__["acl_strategy"] = acl_strategy
        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["endpoint_type"] = endpoint_type
        return ServiceEndpointAcl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aclStrategy")
    def acl_strategy(self) -> pulumi.Output[_builtins.str]:
        """
        The ACL policy. Valid value:
        - allow: indicates that the current endpoint allows access from the corresponding CIDR block. (Only allow is supported)
        """
        return pulumi.get(self, "acl_strategy")

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[_builtins.str]:
        """
        Access point type. Value:
        - public: indicates a public access point. (Currently only public is supported)
        """
        return pulumi.get(self, "endpoint_type")

