# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceEventRuleArgs', 'ServiceEventRule']

@pulumi.input_type
class ServiceEventRuleArgs:
    def __init__(__self__, *,
                 event_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 rule_name: pulumi.Input[_builtins.str],
                 delivery_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input['ServiceEventRuleEndpointArgs']] = None,
                 match_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['ServiceEventRuleMatchRuleArgs']]]]]] = None):
        """
        The set of arguments for constructing a ServiceEventRule resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] event_types: Event Type List
        :param pulumi.Input[_builtins.str] rule_name: The event notification rule name.
        :param pulumi.Input[_builtins.str] delivery_mode: DIRECT: directly delivers to a single queue (1:1) without creating a Topic;
               - BROADCAST: BROADCAST to all subscription queues (1:N). You need to create a Topic;
        :param pulumi.Input['ServiceEventRuleEndpointArgs'] endpoint: Message Receiving Terminal Endpoint Object. See `endpoint` below.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['ServiceEventRuleMatchRuleArgs']]]]] match_rules: Matching rules, or relationships between multiple rules. See `match_rules` below.
        """
        pulumi.set(__self__, "event_types", event_types)
        pulumi.set(__self__, "rule_name", rule_name)
        if delivery_mode is not None:
            pulumi.set(__self__, "delivery_mode", delivery_mode)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if match_rules is not None:
            pulumi.set(__self__, "match_rules", match_rules)

    @_builtins.property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Event Type List
        """
        return pulumi.get(self, "event_types")

    @event_types.setter
    def event_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "event_types", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[_builtins.str]:
        """
        The event notification rule name.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="deliveryMode")
    def delivery_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DIRECT: directly delivers to a single queue (1:1) without creating a Topic;
        - BROADCAST: BROADCAST to all subscription queues (1:N). You need to create a Topic;
        """
        return pulumi.get(self, "delivery_mode")

    @delivery_mode.setter
    def delivery_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_mode", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input['ServiceEventRuleEndpointArgs']]:
        """
        Message Receiving Terminal Endpoint Object. See `endpoint` below.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input['ServiceEventRuleEndpointArgs']]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="matchRules")
    def match_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['ServiceEventRuleMatchRuleArgs']]]]]]:
        """
        Matching rules, or relationships between multiple rules. See `match_rules` below.
        """
        return pulumi.get(self, "match_rules")

    @match_rules.setter
    def match_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['ServiceEventRuleMatchRuleArgs']]]]]]):
        pulumi.set(self, "match_rules", value)


@pulumi.input_type
class _ServiceEventRuleState:
    def __init__(__self__, *,
                 delivery_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input['ServiceEventRuleEndpointArgs']] = None,
                 event_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 match_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['ServiceEventRuleMatchRuleArgs']]]]]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceEventRule resources.
        :param pulumi.Input[_builtins.str] delivery_mode: DIRECT: directly delivers to a single queue (1:1) without creating a Topic;
               - BROADCAST: BROADCAST to all subscription queues (1:N). You need to create a Topic;
        :param pulumi.Input['ServiceEventRuleEndpointArgs'] endpoint: Message Receiving Terminal Endpoint Object. See `endpoint` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] event_types: Event Type List
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['ServiceEventRuleMatchRuleArgs']]]]] match_rules: Matching rules, or relationships between multiple rules. See `match_rules` below.
        :param pulumi.Input[_builtins.str] rule_name: The event notification rule name.
        """
        if delivery_mode is not None:
            pulumi.set(__self__, "delivery_mode", delivery_mode)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if event_types is not None:
            pulumi.set(__self__, "event_types", event_types)
        if match_rules is not None:
            pulumi.set(__self__, "match_rules", match_rules)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)

    @_builtins.property
    @pulumi.getter(name="deliveryMode")
    def delivery_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DIRECT: directly delivers to a single queue (1:1) without creating a Topic;
        - BROADCAST: BROADCAST to all subscription queues (1:N). You need to create a Topic;
        """
        return pulumi.get(self, "delivery_mode")

    @delivery_mode.setter
    def delivery_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_mode", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input['ServiceEventRuleEndpointArgs']]:
        """
        Message Receiving Terminal Endpoint Object. See `endpoint` below.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input['ServiceEventRuleEndpointArgs']]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Event Type List
        """
        return pulumi.get(self, "event_types")

    @event_types.setter
    def event_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "event_types", value)

    @_builtins.property
    @pulumi.getter(name="matchRules")
    def match_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['ServiceEventRuleMatchRuleArgs']]]]]]:
        """
        Matching rules, or relationships between multiple rules. See `match_rules` below.
        """
        return pulumi.get(self, "match_rules")

    @match_rules.setter
    def match_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['ServiceEventRuleMatchRuleArgs']]]]]]):
        pulumi.set(self, "match_rules", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The event notification rule name.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)


@pulumi.type_token("alicloud:message/serviceEventRule:ServiceEventRule")
class ServiceEventRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[Union['ServiceEventRuleEndpointArgs', 'ServiceEventRuleEndpointArgsDict']]] = None,
                 event_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 match_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[Union['ServiceEventRuleMatchRuleArgs', 'ServiceEventRuleMatchRuleArgsDict']]]]]]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Message Service Event Rule resource.

        For information about Message Service Event Rule and how to use it, see [What is Event Rule](https://next.api.alibabacloud.com/document/Mns-open/2022-01-19/CreateEventRule).

        > **NOTE:** Available since v1.255.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        queue_name = config.get("queueName")
        if queue_name is None:
            queue_name = "tf-exampe-topic2queue"
        rule_name = config.get("ruleName")
        if rule_name is None:
            rule_name = "tf-exampe-topic-1"
        topic_name = config.get("topicName")
        if topic_name is None:
            topic_name = "tf-exampe-topic2queue"
        create_topic = alicloud.message.ServiceTopic("CreateTopic",
            max_message_size=65536,
            topic_name=topic_name,
            logging_enabled=False)
        create_queue = alicloud.message.ServiceQueue("CreateQueue",
            delay_seconds=2,
            polling_wait_seconds=2,
            message_retention_period=566,
            maximum_message_size=1123,
            visibility_timeout=30,
            queue_name=queue_name,
            logging_enabled=False)
        create_sub = alicloud.message.ServiceSubscription("CreateSub",
            push_type="queue",
            notify_strategy="BACKOFF_RETRY",
            notify_content_format="SIMPLIFIED",
            subscription_name="RDK-example-sub",
            filter_tag="important",
            topic_name=create_topic.topic_name,
            endpoint=std.format(input="acs:mns:cn-hangzhou:1511928242963727:/queues/%s",
                args=[create_queue.id]).result)
        default = alicloud.message.ServiceEventRule("default",
            event_types=["ObjectCreated:PutObject"],
            match_rules=[[{
                "suffix": "",
                "match_state": "true",
                "name": "acs:oss:cn-hangzhou:1511928242963727:accccx",
                "prefix": "",
            }]],
            endpoint={
                "endpoint_value": create_sub.topic_name,
                "endpoint_type": "topic",
            },
            rule_name=rule_name)
        ```

        ## Import

        Message Service Event Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:message/serviceEventRule:ServiceEventRule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] delivery_mode: DIRECT: directly delivers to a single queue (1:1) without creating a Topic;
               - BROADCAST: BROADCAST to all subscription queues (1:N). You need to create a Topic;
        :param pulumi.Input[Union['ServiceEventRuleEndpointArgs', 'ServiceEventRuleEndpointArgsDict']] endpoint: Message Receiving Terminal Endpoint Object. See `endpoint` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] event_types: Event Type List
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[Union['ServiceEventRuleMatchRuleArgs', 'ServiceEventRuleMatchRuleArgsDict']]]]]] match_rules: Matching rules, or relationships between multiple rules. See `match_rules` below.
        :param pulumi.Input[_builtins.str] rule_name: The event notification rule name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceEventRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Message Service Event Rule resource.

        For information about Message Service Event Rule and how to use it, see [What is Event Rule](https://next.api.alibabacloud.com/document/Mns-open/2022-01-19/CreateEventRule).

        > **NOTE:** Available since v1.255.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        queue_name = config.get("queueName")
        if queue_name is None:
            queue_name = "tf-exampe-topic2queue"
        rule_name = config.get("ruleName")
        if rule_name is None:
            rule_name = "tf-exampe-topic-1"
        topic_name = config.get("topicName")
        if topic_name is None:
            topic_name = "tf-exampe-topic2queue"
        create_topic = alicloud.message.ServiceTopic("CreateTopic",
            max_message_size=65536,
            topic_name=topic_name,
            logging_enabled=False)
        create_queue = alicloud.message.ServiceQueue("CreateQueue",
            delay_seconds=2,
            polling_wait_seconds=2,
            message_retention_period=566,
            maximum_message_size=1123,
            visibility_timeout=30,
            queue_name=queue_name,
            logging_enabled=False)
        create_sub = alicloud.message.ServiceSubscription("CreateSub",
            push_type="queue",
            notify_strategy="BACKOFF_RETRY",
            notify_content_format="SIMPLIFIED",
            subscription_name="RDK-example-sub",
            filter_tag="important",
            topic_name=create_topic.topic_name,
            endpoint=std.format(input="acs:mns:cn-hangzhou:1511928242963727:/queues/%s",
                args=[create_queue.id]).result)
        default = alicloud.message.ServiceEventRule("default",
            event_types=["ObjectCreated:PutObject"],
            match_rules=[[{
                "suffix": "",
                "match_state": "true",
                "name": "acs:oss:cn-hangzhou:1511928242963727:accccx",
                "prefix": "",
            }]],
            endpoint={
                "endpoint_value": create_sub.topic_name,
                "endpoint_type": "topic",
            },
            rule_name=rule_name)
        ```

        ## Import

        Message Service Event Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:message/serviceEventRule:ServiceEventRule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ServiceEventRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceEventRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[Union['ServiceEventRuleEndpointArgs', 'ServiceEventRuleEndpointArgsDict']]] = None,
                 event_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 match_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[Union['ServiceEventRuleMatchRuleArgs', 'ServiceEventRuleMatchRuleArgsDict']]]]]]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceEventRuleArgs.__new__(ServiceEventRuleArgs)

            __props__.__dict__["delivery_mode"] = delivery_mode
            __props__.__dict__["endpoint"] = endpoint
            if event_types is None and not opts.urn:
                raise TypeError("Missing required property 'event_types'")
            __props__.__dict__["event_types"] = event_types
            __props__.__dict__["match_rules"] = match_rules
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
        super(ServiceEventRule, __self__).__init__(
            'alicloud:message/serviceEventRule:ServiceEventRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            delivery_mode: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint: Optional[pulumi.Input[Union['ServiceEventRuleEndpointArgs', 'ServiceEventRuleEndpointArgsDict']]] = None,
            event_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            match_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[Union['ServiceEventRuleMatchRuleArgs', 'ServiceEventRuleMatchRuleArgsDict']]]]]]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceEventRule':
        """
        Get an existing ServiceEventRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] delivery_mode: DIRECT: directly delivers to a single queue (1:1) without creating a Topic;
               - BROADCAST: BROADCAST to all subscription queues (1:N). You need to create a Topic;
        :param pulumi.Input[Union['ServiceEventRuleEndpointArgs', 'ServiceEventRuleEndpointArgsDict']] endpoint: Message Receiving Terminal Endpoint Object. See `endpoint` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] event_types: Event Type List
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[Union['ServiceEventRuleMatchRuleArgs', 'ServiceEventRuleMatchRuleArgsDict']]]]]] match_rules: Matching rules, or relationships between multiple rules. See `match_rules` below.
        :param pulumi.Input[_builtins.str] rule_name: The event notification rule name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceEventRuleState.__new__(_ServiceEventRuleState)

        __props__.__dict__["delivery_mode"] = delivery_mode
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["event_types"] = event_types
        __props__.__dict__["match_rules"] = match_rules
        __props__.__dict__["rule_name"] = rule_name
        return ServiceEventRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="deliveryMode")
    def delivery_mode(self) -> pulumi.Output[_builtins.str]:
        """
        DIRECT: directly delivers to a single queue (1:1) without creating a Topic;
        - BROADCAST: BROADCAST to all subscription queues (1:N). You need to create a Topic;
        """
        return pulumi.get(self, "delivery_mode")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional['outputs.ServiceEventRuleEndpoint']]:
        """
        Message Receiving Terminal Endpoint Object. See `endpoint` below.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Event Type List
        """
        return pulumi.get(self, "event_types")

    @_builtins.property
    @pulumi.getter(name="matchRules")
    def match_rules(self) -> pulumi.Output[Optional[Sequence[Sequence['outputs.ServiceEventRuleMatchRule']]]]:
        """
        Matching rules, or relationships between multiple rules. See `match_rules` below.
        """
        return pulumi.get(self, "match_rules")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[_builtins.str]:
        """
        The event notification rule name.
        """
        return pulumi.get(self, "rule_name")

