# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'InstanceParameter',
    'InstanceReplicaSet',
    'PublicNetworkAddressReplicaSet',
    'ServerlessInstanceSecurityIpGroup',
    'ShardingInstanceConfigServerList',
    'ShardingInstanceMongoList',
    'ShardingInstanceShardList',
    'ShardingNetworkPrivateAddressNetworkAddress',
    'ShardingNetworkPublicAddressNetworkAddress',
    'GetAccountsAccountResult',
    'GetAuditPoliciesPolicyResult',
    'GetInstancesInstanceResult',
    'GetInstancesInstanceMongoResult',
    'GetInstancesInstanceShardResult',
    'GetServerlessInstancesInstanceResult',
    'GetServerlessInstancesInstanceSecurityIpGroupResult',
    'GetShardingNetworkPrivateAddressesAddressResult',
    'GetShardingNetworkPublicAddressesAddressResult',
    'GetZonesZoneResult',
]

@pulumi.output_type
class InstanceParameter(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the parameter.
        :param _builtins.str value: The value of the parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InstanceReplicaSet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionDomain":
            suggest = "connection_domain"
        elif key == "connectionPort":
            suggest = "connection_port"
        elif key == "networkType":
            suggest = "network_type"
        elif key == "replicaSetRole":
            suggest = "replica_set_role"
        elif key == "roleId":
            suggest = "role_id"
        elif key == "vpcCloudInstanceId":
            suggest = "vpc_cloud_instance_id"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "vswitchId":
            suggest = "vswitch_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceReplicaSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceReplicaSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceReplicaSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_domain: Optional[_builtins.str] = None,
                 connection_port: Optional[_builtins.str] = None,
                 network_type: Optional[_builtins.str] = None,
                 replica_set_role: Optional[_builtins.str] = None,
                 role_id: Optional[_builtins.str] = None,
                 vpc_cloud_instance_id: Optional[_builtins.str] = None,
                 vpc_id: Optional[_builtins.str] = None,
                 vswitch_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str connection_domain: The connection address of the node.
        :param _builtins.str connection_port: The connection port of the node.
        :param _builtins.str network_type: The network type of the instance. Valid values:`Classic`, `VPC`.
        :param _builtins.str replica_set_role: The role of the node.
        :param _builtins.str role_id: The id of the role.
        :param _builtins.str vpc_cloud_instance_id: VPC instance ID.
        :param _builtins.str vpc_id: The ID of the VPC. > **NOTE:** `vpc_id` is valid only when `network_type` is set to `VPC`.
        :param _builtins.str vswitch_id: The virtual switch ID to launch DB instances in one VPC.
        """
        if connection_domain is not None:
            pulumi.set(__self__, "connection_domain", connection_domain)
        if connection_port is not None:
            pulumi.set(__self__, "connection_port", connection_port)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if replica_set_role is not None:
            pulumi.set(__self__, "replica_set_role", replica_set_role)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if vpc_cloud_instance_id is not None:
            pulumi.set(__self__, "vpc_cloud_instance_id", vpc_cloud_instance_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="connectionDomain")
    def connection_domain(self) -> Optional[_builtins.str]:
        """
        The connection address of the node.
        """
        return pulumi.get(self, "connection_domain")

    @_builtins.property
    @pulumi.getter(name="connectionPort")
    def connection_port(self) -> Optional[_builtins.str]:
        """
        The connection port of the node.
        """
        return pulumi.get(self, "connection_port")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[_builtins.str]:
        """
        The network type of the instance. Valid values:`Classic`, `VPC`.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="replicaSetRole")
    def replica_set_role(self) -> Optional[_builtins.str]:
        """
        The role of the node.
        """
        return pulumi.get(self, "replica_set_role")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[_builtins.str]:
        """
        The id of the role.
        """
        return pulumi.get(self, "role_id")

    @_builtins.property
    @pulumi.getter(name="vpcCloudInstanceId")
    def vpc_cloud_instance_id(self) -> Optional[_builtins.str]:
        """
        VPC instance ID.
        """
        return pulumi.get(self, "vpc_cloud_instance_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The ID of the VPC. > **NOTE:** `vpc_id` is valid only when `network_type` is set to `VPC`.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[_builtins.str]:
        """
        The virtual switch ID to launch DB instances in one VPC.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class PublicNetworkAddressReplicaSet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionDomain":
            suggest = "connection_domain"
        elif key == "connectionPort":
            suggest = "connection_port"
        elif key == "connectionType":
            suggest = "connection_type"
        elif key == "networkType":
            suggest = "network_type"
        elif key == "replicaSetRole":
            suggest = "replica_set_role"
        elif key == "roleId":
            suggest = "role_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicNetworkAddressReplicaSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicNetworkAddressReplicaSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicNetworkAddressReplicaSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_domain: Optional[_builtins.str] = None,
                 connection_port: Optional[_builtins.str] = None,
                 connection_type: Optional[_builtins.str] = None,
                 network_type: Optional[_builtins.str] = None,
                 replica_set_role: Optional[_builtins.str] = None,
                 role_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str connection_domain: The connection address of the node.
        :param _builtins.str connection_port: The connection port of the node.
        :param _builtins.str connection_type: The connection type.
        :param _builtins.str network_type: The network type, should be always "Public".
        :param _builtins.str replica_set_role: The role of the node.
        :param _builtins.str role_id: The id of the role.
        """
        if connection_domain is not None:
            pulumi.set(__self__, "connection_domain", connection_domain)
        if connection_port is not None:
            pulumi.set(__self__, "connection_port", connection_port)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if replica_set_role is not None:
            pulumi.set(__self__, "replica_set_role", replica_set_role)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)

    @_builtins.property
    @pulumi.getter(name="connectionDomain")
    def connection_domain(self) -> Optional[_builtins.str]:
        """
        The connection address of the node.
        """
        return pulumi.get(self, "connection_domain")

    @_builtins.property
    @pulumi.getter(name="connectionPort")
    def connection_port(self) -> Optional[_builtins.str]:
        """
        The connection port of the node.
        """
        return pulumi.get(self, "connection_port")

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[_builtins.str]:
        """
        The connection type.
        """
        return pulumi.get(self, "connection_type")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[_builtins.str]:
        """
        The network type, should be always "Public".
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="replicaSetRole")
    def replica_set_role(self) -> Optional[_builtins.str]:
        """
        The role of the node.
        """
        return pulumi.get(self, "replica_set_role")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[_builtins.str]:
        """
        The id of the role.
        """
        return pulumi.get(self, "role_id")


@pulumi.output_type
class ServerlessInstanceSecurityIpGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityIpGroupAttribute":
            suggest = "security_ip_group_attribute"
        elif key == "securityIpGroupName":
            suggest = "security_ip_group_name"
        elif key == "securityIpList":
            suggest = "security_ip_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerlessInstanceSecurityIpGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerlessInstanceSecurityIpGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerlessInstanceSecurityIpGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_ip_group_attribute: Optional[_builtins.str] = None,
                 security_ip_group_name: Optional[_builtins.str] = None,
                 security_ip_list: Optional[_builtins.str] = None):
        """
        :param _builtins.str security_ip_group_attribute: The attribute of the IP whitelist. This parameter is empty by default.
        :param _builtins.str security_ip_group_name: The name of the IP whitelist.
        :param _builtins.str security_ip_list: The IP addresses in the whitelist.
        """
        if security_ip_group_attribute is not None:
            pulumi.set(__self__, "security_ip_group_attribute", security_ip_group_attribute)
        if security_ip_group_name is not None:
            pulumi.set(__self__, "security_ip_group_name", security_ip_group_name)
        if security_ip_list is not None:
            pulumi.set(__self__, "security_ip_list", security_ip_list)

    @_builtins.property
    @pulumi.getter(name="securityIpGroupAttribute")
    def security_ip_group_attribute(self) -> Optional[_builtins.str]:
        """
        The attribute of the IP whitelist. This parameter is empty by default.
        """
        return pulumi.get(self, "security_ip_group_attribute")

    @_builtins.property
    @pulumi.getter(name="securityIpGroupName")
    def security_ip_group_name(self) -> Optional[_builtins.str]:
        """
        The name of the IP whitelist.
        """
        return pulumi.get(self, "security_ip_group_name")

    @_builtins.property
    @pulumi.getter(name="securityIpList")
    def security_ip_list(self) -> Optional[_builtins.str]:
        """
        The IP addresses in the whitelist.
        """
        return pulumi.get(self, "security_ip_list")


@pulumi.output_type
class ShardingInstanceConfigServerList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectString":
            suggest = "connect_string"
        elif key == "maxConnections":
            suggest = "max_connections"
        elif key == "maxIops":
            suggest = "max_iops"
        elif key == "nodeClass":
            suggest = "node_class"
        elif key == "nodeDescription":
            suggest = "node_description"
        elif key == "nodeId":
            suggest = "node_id"
        elif key == "nodeStorage":
            suggest = "node_storage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardingInstanceConfigServerList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardingInstanceConfigServerList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardingInstanceConfigServerList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_string: Optional[_builtins.str] = None,
                 max_connections: Optional[_builtins.int] = None,
                 max_iops: Optional[_builtins.int] = None,
                 node_class: Optional[_builtins.str] = None,
                 node_description: Optional[_builtins.str] = None,
                 node_id: Optional[_builtins.str] = None,
                 node_storage: Optional[_builtins.int] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str connect_string: The connection address of the Config Server node.
        :param _builtins.int max_connections: The max connections of the Config Server node.
        :param _builtins.int max_iops: The maximum IOPS of the Config Server node.
        :param _builtins.str node_class: The instance type of the ConfigServer node. Valid values: `mdb.shard.2x.xlarge.d`, `dds.cs.mid`.
        :param _builtins.str node_description: The description of the Config Server node.
        :param _builtins.str node_id: The ID of the Config Server node.
        :param _builtins.int node_storage: The storage space of the ConfigServer node.
        :param _builtins.int port: The connection port of the Config Server node.
        """
        if connect_string is not None:
            pulumi.set(__self__, "connect_string", connect_string)
        if max_connections is not None:
            pulumi.set(__self__, "max_connections", max_connections)
        if max_iops is not None:
            pulumi.set(__self__, "max_iops", max_iops)
        if node_class is not None:
            pulumi.set(__self__, "node_class", node_class)
        if node_description is not None:
            pulumi.set(__self__, "node_description", node_description)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if node_storage is not None:
            pulumi.set(__self__, "node_storage", node_storage)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="connectString")
    def connect_string(self) -> Optional[_builtins.str]:
        """
        The connection address of the Config Server node.
        """
        return pulumi.get(self, "connect_string")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> Optional[_builtins.int]:
        """
        The max connections of the Config Server node.
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter(name="maxIops")
    def max_iops(self) -> Optional[_builtins.int]:
        """
        The maximum IOPS of the Config Server node.
        """
        return pulumi.get(self, "max_iops")

    @_builtins.property
    @pulumi.getter(name="nodeClass")
    def node_class(self) -> Optional[_builtins.str]:
        """
        The instance type of the ConfigServer node. Valid values: `mdb.shard.2x.xlarge.d`, `dds.cs.mid`.
        """
        return pulumi.get(self, "node_class")

    @_builtins.property
    @pulumi.getter(name="nodeDescription")
    def node_description(self) -> Optional[_builtins.str]:
        """
        The description of the Config Server node.
        """
        return pulumi.get(self, "node_description")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Config Server node.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="nodeStorage")
    def node_storage(self) -> Optional[_builtins.int]:
        """
        The storage space of the ConfigServer node.
        """
        return pulumi.get(self, "node_storage")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The connection port of the Config Server node.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ShardingInstanceMongoList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeClass":
            suggest = "node_class"
        elif key == "connectString":
            suggest = "connect_string"
        elif key == "nodeId":
            suggest = "node_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardingInstanceMongoList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardingInstanceMongoList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardingInstanceMongoList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_class: _builtins.str,
                 connect_string: Optional[_builtins.str] = None,
                 node_id: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str node_class: The instance type of the mongo node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
        :param _builtins.str connect_string: The connection address of the Config Server node.
        :param _builtins.str node_id: The ID of the Config Server node.
        :param _builtins.int port: The connection port of the Config Server node.
        """
        pulumi.set(__self__, "node_class", node_class)
        if connect_string is not None:
            pulumi.set(__self__, "connect_string", connect_string)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="nodeClass")
    def node_class(self) -> _builtins.str:
        """
        The instance type of the mongo node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
        """
        return pulumi.get(self, "node_class")

    @_builtins.property
    @pulumi.getter(name="connectString")
    def connect_string(self) -> Optional[_builtins.str]:
        """
        The connection address of the Config Server node.
        """
        return pulumi.get(self, "connect_string")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Config Server node.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The connection port of the Config Server node.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ShardingInstanceShardList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeClass":
            suggest = "node_class"
        elif key == "nodeStorage":
            suggest = "node_storage"
        elif key == "nodeId":
            suggest = "node_id"
        elif key == "readonlyReplicas":
            suggest = "readonly_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardingInstanceShardList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardingInstanceShardList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardingInstanceShardList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_class: _builtins.str,
                 node_storage: _builtins.int,
                 node_id: Optional[_builtins.str] = None,
                 readonly_replicas: Optional[_builtins.int] = None):
        """
        :param _builtins.str node_class: The instance type of the shard node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
        :param _builtins.int node_storage: The storage space of the shard node.
               - Custom storage space; value range: [10, 1,000]
               - 10-GB increments. Unit: GB.
        :param _builtins.str node_id: The ID of the Config Server node.
        :param _builtins.int readonly_replicas: The number of read-only nodes in shard node Default value: `0`. Valid values: `0` to `5`.
        """
        pulumi.set(__self__, "node_class", node_class)
        pulumi.set(__self__, "node_storage", node_storage)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if readonly_replicas is not None:
            pulumi.set(__self__, "readonly_replicas", readonly_replicas)

    @_builtins.property
    @pulumi.getter(name="nodeClass")
    def node_class(self) -> _builtins.str:
        """
        The instance type of the shard node. see [Instance specifications](https://www.alibabacloud.com/help/doc-detail/57141.htm).
        """
        return pulumi.get(self, "node_class")

    @_builtins.property
    @pulumi.getter(name="nodeStorage")
    def node_storage(self) -> _builtins.int:
        """
        The storage space of the shard node.
        - Custom storage space; value range: [10, 1,000]
        - 10-GB increments. Unit: GB.
        """
        return pulumi.get(self, "node_storage")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Config Server node.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="readonlyReplicas")
    def readonly_replicas(self) -> Optional[_builtins.int]:
        """
        The number of read-only nodes in shard node Default value: `0`. Valid values: `0` to `5`.
        """
        return pulumi.get(self, "readonly_replicas")


@pulumi.output_type
class ShardingNetworkPrivateAddressNetworkAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiredTime":
            suggest = "expired_time"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "networkAddress":
            suggest = "network_address"
        elif key == "networkType":
            suggest = "network_type"
        elif key == "nodeId":
            suggest = "node_id"
        elif key == "nodeType":
            suggest = "node_type"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "vswitchId":
            suggest = "vswitch_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardingNetworkPrivateAddressNetworkAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardingNetworkPrivateAddressNetworkAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardingNetworkPrivateAddressNetworkAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expired_time: Optional[_builtins.str] = None,
                 ip_address: Optional[_builtins.str] = None,
                 network_address: Optional[_builtins.str] = None,
                 network_type: Optional[_builtins.str] = None,
                 node_id: Optional[_builtins.str] = None,
                 node_type: Optional[_builtins.str] = None,
                 port: Optional[_builtins.str] = None,
                 role: Optional[_builtins.str] = None,
                 vpc_id: Optional[_builtins.str] = None,
                 vswitch_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str expired_time: The remaining duration of the classic network endpoint.
        :param _builtins.str ip_address: The IP address of the instance.
        :param _builtins.str network_address: The connection string of the instance.
        :param _builtins.str network_type: The network type of the instance.
        :param _builtins.str node_id: The ID of the Shard node or ConfigServer node.
        :param _builtins.str node_type: The type of the node.
        :param _builtins.str port: The port that is used to connect to the instance.
        :param _builtins.str role: The role of the node.
        :param _builtins.str vpc_id: The ID of the VPC.
        :param _builtins.str vswitch_id: The ID of the vSwitch in the VPC.
        """
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if network_address is not None:
            pulumi.set(__self__, "network_address", network_address)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[_builtins.str]:
        """
        The remaining duration of the classic network endpoint.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        The IP address of the instance.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> Optional[_builtins.str]:
        """
        The connection string of the instance.
        """
        return pulumi.get(self, "network_address")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[_builtins.str]:
        """
        The network type of the instance.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Shard node or ConfigServer node.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[_builtins.str]:
        """
        The type of the node.
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        The port that is used to connect to the instance.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        The role of the node.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[_builtins.str]:
        """
        The ID of the vSwitch in the VPC.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class ShardingNetworkPublicAddressNetworkAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiredTime":
            suggest = "expired_time"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "networkAddress":
            suggest = "network_address"
        elif key == "networkType":
            suggest = "network_type"
        elif key == "nodeId":
            suggest = "node_id"
        elif key == "nodeType":
            suggest = "node_type"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "vswitchId":
            suggest = "vswitch_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardingNetworkPublicAddressNetworkAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardingNetworkPublicAddressNetworkAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardingNetworkPublicAddressNetworkAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expired_time: Optional[_builtins.str] = None,
                 ip_address: Optional[_builtins.str] = None,
                 network_address: Optional[_builtins.str] = None,
                 network_type: Optional[_builtins.str] = None,
                 node_id: Optional[_builtins.str] = None,
                 node_type: Optional[_builtins.str] = None,
                 port: Optional[_builtins.str] = None,
                 role: Optional[_builtins.str] = None,
                 vpc_id: Optional[_builtins.str] = None,
                 vswitch_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str expired_time: The remaining duration of the classic network address. Unit: `seconds`.
        :param _builtins.str ip_address: The IP address of the instance.
        :param _builtins.str network_address: The endpoint of the instance.
        :param _builtins.str network_type: The network type.
        :param _builtins.str node_id: The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
        :param _builtins.str node_type: The type of the node.
        :param _builtins.str port: The port number.
        :param _builtins.str role: The role of the node.
        :param _builtins.str vpc_id: The ID of the VPC.
        :param _builtins.str vswitch_id: The vSwitch ID of the VPC.
        """
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if network_address is not None:
            pulumi.set(__self__, "network_address", network_address)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[_builtins.str]:
        """
        The remaining duration of the classic network address. Unit: `seconds`.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        The IP address of the instance.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> Optional[_builtins.str]:
        """
        The endpoint of the instance.
        """
        return pulumi.get(self, "network_address")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[_builtins.str]:
        """
        The network type.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[_builtins.str]:
        """
        The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[_builtins.str]:
        """
        The type of the node.
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        The port number.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        The role of the node.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[_builtins.str]:
        """
        The vSwitch ID of the VPC.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetAccountsAccountResult(dict):
    def __init__(__self__, *,
                 account_description: _builtins.str,
                 account_name: _builtins.str,
                 character_type: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str account_description: The description of the account.
        :param _builtins.str account_name: The name of the account.
        :param _builtins.str character_type: The role of the account. Valid values: `db`, `cs`, `mongos`, `logic`, `normal`.
        :param _builtins.str id: The ID of the Account. The value formats as `<instance_id>:<account_name>`.
        :param _builtins.str instance_id: The id of the instance to which the account belongs.
        :param _builtins.str status: The status of the account. Valid values: `Unavailable`, `Available`.
        """
        pulumi.set(__self__, "account_description", account_description)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "character_type", character_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> _builtins.str:
        """
        The description of the account.
        """
        return pulumi.get(self, "account_description")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        """
        The name of the account.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="characterType")
    def character_type(self) -> _builtins.str:
        """
        The role of the account. Valid values: `db`, `cs`, `mongos`, `logic`, `normal`.
        """
        return pulumi.get(self, "character_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Account. The value formats as `<instance_id>:<account_name>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The id of the instance to which the account belongs.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the account. Valid values: `Unavailable`, `Available`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAuditPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 audit_status: _builtins.str,
                 db_instance_id: _builtins.str,
                 id: _builtins.str):
        """
        :param _builtins.str audit_status: The status of the log audit feature.
        :param _builtins.str db_instance_id: The ID of the instance.
        :param _builtins.str id: The ID of the Audit Policy.
        """
        pulumi.set(__self__, "audit_status", audit_status)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="auditStatus")
    def audit_status(self) -> _builtins.str:
        """
        The status of the log audit feature.
        """
        return pulumi.get(self, "audit_status")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> _builtins.str:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Audit Policy.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 availability_zone: _builtins.str,
                 charge_type: _builtins.str,
                 creation_time: _builtins.str,
                 engine: _builtins.str,
                 engine_version: _builtins.str,
                 expiration_time: _builtins.str,
                 id: _builtins.str,
                 instance_class: _builtins.str,
                 instance_type: _builtins.str,
                 lock_mode: _builtins.str,
                 mongos: Sequence['outputs.GetInstancesInstanceMongoResult'],
                 name: _builtins.str,
                 network_type: _builtins.str,
                 region_id: _builtins.str,
                 replication: _builtins.str,
                 shards: Sequence['outputs.GetInstancesInstanceShardResult'],
                 status: _builtins.str,
                 storage: _builtins.int,
                 tags: Mapping[str, _builtins.str]):
        """
        :param _builtins.str availability_zone: Instance availability zone.
        :param _builtins.str charge_type: Billing method. Value options are `PostPaid` for  Pay-As-You-Go and `PrePaid` for yearly or monthly subscription.
        :param _builtins.str creation_time: Creation time of the instance in RFC3339 format.
        :param _builtins.str engine: Database engine type. Supported option is `MongoDB`.
        :param _builtins.str engine_version: Database engine version.
        :param _builtins.str expiration_time: Expiration time in RFC3339 format. Pay-As-You-Go instances are never expire.
        :param _builtins.str id: The ID of the MongoDB instance.
        :param _builtins.str instance_class: Sizing of the instance to be queried.
        :param _builtins.str instance_type: Type of the instance to be queried. If it is set to `sharding`, the sharded cluster instances are listed. If it is set to `replicate`, replica set instances are listed. Default value `replicate`.
        :param _builtins.str lock_mode: Lock status of the instance.
        :param Sequence['GetInstancesInstanceMongoArgs'] mongos: Array composed of Mongos.
        :param _builtins.str name: The name of the MongoDB instance.
        :param _builtins.str network_type: Classic network or VPC.
        :param _builtins.str region_id: Region ID the instance belongs to.
        :param _builtins.str replication: Replication factor corresponds to number of nodes. Optional values are `1` for single node and `3` for three nodes replica set.
        :param Sequence['GetInstancesInstanceShardArgs'] shards: Array composed of shards.
        :param _builtins.str status: Status of the instance.
        :param _builtins.int storage: Shard disk.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "charge_type", charge_type)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_class", instance_class)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "lock_mode", lock_mode)
        pulumi.set(__self__, "mongos", mongos)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "replication", replication)
        pulumi.set(__self__, "shards", shards)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage", storage)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        Instance availability zone.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> _builtins.str:
        """
        Billing method. Value options are `PostPaid` for  Pay-As-You-Go and `PrePaid` for yearly or monthly subscription.
        """
        return pulumi.get(self, "charge_type")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        """
        Creation time of the instance in RFC3339 format.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        """
        Database engine type. Supported option is `MongoDB`.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> _builtins.str:
        """
        Database engine version.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> _builtins.str:
        """
        Expiration time in RFC3339 format. Pay-As-You-Go instances are never expire.
        """
        return pulumi.get(self, "expiration_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the MongoDB instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> _builtins.str:
        """
        Sizing of the instance to be queried.
        """
        return pulumi.get(self, "instance_class")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        Type of the instance to be queried. If it is set to `sharding`, the sharded cluster instances are listed. If it is set to `replicate`, replica set instances are listed. Default value `replicate`.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> _builtins.str:
        """
        Lock status of the instance.
        """
        return pulumi.get(self, "lock_mode")

    @_builtins.property
    @pulumi.getter
    def mongos(self) -> Sequence['outputs.GetInstancesInstanceMongoResult']:
        """
        Array composed of Mongos.
        """
        return pulumi.get(self, "mongos")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the MongoDB instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        Classic network or VPC.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        Region ID the instance belongs to.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def replication(self) -> _builtins.str:
        """
        Replication factor corresponds to number of nodes. Optional values are `1` for single node and `3` for three nodes replica set.
        """
        return pulumi.get(self, "replication")

    @_builtins.property
    @pulumi.getter
    def shards(self) -> Sequence['outputs.GetInstancesInstanceShardResult']:
        """
        Array composed of shards.
        """
        return pulumi.get(self, "shards")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> _builtins.int:
        """
        Shard disk.
        """
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetInstancesInstanceMongoResult(dict):
    def __init__(__self__, *,
                 class_: _builtins.str,
                 description: _builtins.str,
                 node_id: _builtins.str):
        """
        :param _builtins.str class_: Shard instance specification.
        :param _builtins.str description: Shard instance description.
        :param _builtins.str node_id: Shard instance ID.
        """
        pulumi.set(__self__, "class_", class_)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "node_id", node_id)

    @_builtins.property
    @pulumi.getter(name="class")
    def class_(self) -> _builtins.str:
        """
        Shard instance specification.
        """
        return pulumi.get(self, "class_")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Shard instance description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        """
        Shard instance ID.
        """
        return pulumi.get(self, "node_id")


@pulumi.output_type
class GetInstancesInstanceShardResult(dict):
    def __init__(__self__, *,
                 class_: _builtins.str,
                 description: _builtins.str,
                 node_id: _builtins.str,
                 storage: _builtins.int):
        """
        :param _builtins.str class_: Shard instance specification.
        :param _builtins.str description: Shard instance description.
        :param _builtins.str node_id: Shard instance ID.
        :param _builtins.int storage: Shard disk.
        """
        pulumi.set(__self__, "class_", class_)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "storage", storage)

    @_builtins.property
    @pulumi.getter(name="class")
    def class_(self) -> _builtins.str:
        """
        Shard instance specification.
        """
        return pulumi.get(self, "class_")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Shard instance description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        """
        Shard instance ID.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> _builtins.int:
        """
        Shard disk.
        """
        return pulumi.get(self, "storage")


@pulumi.output_type
class GetServerlessInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 capacity_unit: _builtins.int,
                 db_instance_class: _builtins.str,
                 db_instance_description: _builtins.str,
                 db_instance_id: _builtins.str,
                 db_instance_release_protection: _builtins.bool,
                 db_instance_storage: _builtins.int,
                 engine: _builtins.str,
                 engine_version: _builtins.str,
                 expire_time: _builtins.str,
                 id: _builtins.str,
                 kind_code: _builtins.str,
                 lock_mode: _builtins.str,
                 maintain_end_time: _builtins.str,
                 maintain_start_time: _builtins.str,
                 max_connections: _builtins.int,
                 max_iops: _builtins.int,
                 network_type: _builtins.str,
                 payment_type: _builtins.str,
                 protocol_type: _builtins.str,
                 resource_group_id: _builtins.str,
                 security_ip_groups: Sequence['outputs.GetServerlessInstancesInstanceSecurityIpGroupResult'],
                 status: _builtins.str,
                 storage_engine: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 vpc_auth_mode: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.int capacity_unit: The read/write throughput consumed by the instance.
        :param _builtins.str db_instance_class: The db instance class.
        :param _builtins.str db_instance_description: The db instance description.
        :param _builtins.str db_instance_id: The db instance id.
        :param _builtins.bool db_instance_release_protection: The db instance release protection.
        :param _builtins.int db_instance_storage: The db instance storage.
        :param _builtins.str engine: The database engine of the instance.
        :param _builtins.str engine_version: The database version number. Valid values: `4.2`.
        :param _builtins.str expire_time: The time when the subscription instance expires. The time is in the `yyyy-MM-ddTHH:mmZ` format. The time is displayed in UTC.
        :param _builtins.str id: The ID of the Serverless Instance.
        :param _builtins.str kind_code: Indicates the type of the instance. Valid values: `0`: physical machine. `1`: ECS. `2`: DOCKER. `18`: k8s new architecture instance.
        :param _builtins.str lock_mode: The locked status of the instance.
        :param _builtins.str maintain_end_time: The start time of the maintenance window. The time is in the `HH:mmZ` format. The time is displayed in UTC.
        :param _builtins.str maintain_start_time: The end time of the maintenance window. The time is in the `HH:mmZ` format. The time is displayed in UTC.
        :param _builtins.int max_connections: Instance maximum connections.
        :param _builtins.int max_iops: The maximum IOPS of the instance.
        :param _builtins.str network_type: The network type of the instance.
        :param _builtins.str payment_type: The Payment type of the instance.
        :param _builtins.str protocol_type: The access protocol type of the instance. Valid values: `mongodb`, `dynamodb`.
        :param _builtins.str resource_group_id: The ID of the resource group.
        :param Sequence['GetServerlessInstancesInstanceSecurityIpGroupArgs'] security_ip_groups: The security ip list.
        :param _builtins.str status: The status of the instance.
        :param _builtins.str storage_engine: The storage engine used by the instance.
        :param Mapping[str, _builtins.str] tags: The tag of the resource.
        :param _builtins.str vpc_auth_mode: Intranet secret free access mode.
        :param _builtins.str vpc_id: The ID of the VPC network.
        :param _builtins.str vswitch_id: The id of the vswitch.
        :param _builtins.str zone_id: The ID of the zone.
        """
        pulumi.set(__self__, "capacity_unit", capacity_unit)
        pulumi.set(__self__, "db_instance_class", db_instance_class)
        pulumi.set(__self__, "db_instance_description", db_instance_description)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "db_instance_release_protection", db_instance_release_protection)
        pulumi.set(__self__, "db_instance_storage", db_instance_storage)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "kind_code", kind_code)
        pulumi.set(__self__, "lock_mode", lock_mode)
        pulumi.set(__self__, "maintain_end_time", maintain_end_time)
        pulumi.set(__self__, "maintain_start_time", maintain_start_time)
        pulumi.set(__self__, "max_connections", max_connections)
        pulumi.set(__self__, "max_iops", max_iops)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "protocol_type", protocol_type)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "security_ip_groups", security_ip_groups)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage_engine", storage_engine)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_auth_mode", vpc_auth_mode)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="capacityUnit")
    def capacity_unit(self) -> _builtins.int:
        """
        The read/write throughput consumed by the instance.
        """
        return pulumi.get(self, "capacity_unit")

    @_builtins.property
    @pulumi.getter(name="dbInstanceClass")
    def db_instance_class(self) -> _builtins.str:
        """
        The db instance class.
        """
        return pulumi.get(self, "db_instance_class")

    @_builtins.property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> _builtins.str:
        """
        The db instance description.
        """
        return pulumi.get(self, "db_instance_description")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> _builtins.str:
        """
        The db instance id.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="dbInstanceReleaseProtection")
    def db_instance_release_protection(self) -> _builtins.bool:
        """
        The db instance release protection.
        """
        return pulumi.get(self, "db_instance_release_protection")

    @_builtins.property
    @pulumi.getter(name="dbInstanceStorage")
    def db_instance_storage(self) -> _builtins.int:
        """
        The db instance storage.
        """
        return pulumi.get(self, "db_instance_storage")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        """
        The database engine of the instance.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> _builtins.str:
        """
        The database version number. Valid values: `4.2`.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        The time when the subscription instance expires. The time is in the `yyyy-MM-ddTHH:mmZ` format. The time is displayed in UTC.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Serverless Instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kindCode")
    def kind_code(self) -> _builtins.str:
        """
        Indicates the type of the instance. Valid values: `0`: physical machine. `1`: ECS. `2`: DOCKER. `18`: k8s new architecture instance.
        """
        return pulumi.get(self, "kind_code")

    @_builtins.property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> _builtins.str:
        """
        The locked status of the instance.
        """
        return pulumi.get(self, "lock_mode")

    @_builtins.property
    @pulumi.getter(name="maintainEndTime")
    def maintain_end_time(self) -> _builtins.str:
        """
        The start time of the maintenance window. The time is in the `HH:mmZ` format. The time is displayed in UTC.
        """
        return pulumi.get(self, "maintain_end_time")

    @_builtins.property
    @pulumi.getter(name="maintainStartTime")
    def maintain_start_time(self) -> _builtins.str:
        """
        The end time of the maintenance window. The time is in the `HH:mmZ` format. The time is displayed in UTC.
        """
        return pulumi.get(self, "maintain_start_time")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> _builtins.int:
        """
        Instance maximum connections.
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter(name="maxIops")
    def max_iops(self) -> _builtins.int:
        """
        The maximum IOPS of the instance.
        """
        return pulumi.get(self, "max_iops")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        The network type of the instance.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The Payment type of the instance.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> _builtins.str:
        """
        The access protocol type of the instance. Valid values: `mongodb`, `dynamodb`.
        """
        return pulumi.get(self, "protocol_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityIpGroups")
    def security_ip_groups(self) -> Sequence['outputs.GetServerlessInstancesInstanceSecurityIpGroupResult']:
        """
        The security ip list.
        """
        return pulumi.get(self, "security_ip_groups")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageEngine")
    def storage_engine(self) -> _builtins.str:
        """
        The storage engine used by the instance.
        """
        return pulumi.get(self, "storage_engine")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcAuthMode")
    def vpc_auth_mode(self) -> _builtins.str:
        """
        Intranet secret free access mode.
        """
        return pulumi.get(self, "vpc_auth_mode")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC network.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The id of the vswitch.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The ID of the zone.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetServerlessInstancesInstanceSecurityIpGroupResult(dict):
    def __init__(__self__, *,
                 security_ip_group_attribute: _builtins.str,
                 security_ip_group_name: _builtins.str,
                 security_ip_list: _builtins.str):
        """
        :param _builtins.str security_ip_group_attribute: The attribute of the IP whitelist. This parameter is empty by default.
        :param _builtins.str security_ip_group_name: The name of the IP whitelist.
        :param _builtins.str security_ip_list: The IP addresses in the whitelist.
        """
        pulumi.set(__self__, "security_ip_group_attribute", security_ip_group_attribute)
        pulumi.set(__self__, "security_ip_group_name", security_ip_group_name)
        pulumi.set(__self__, "security_ip_list", security_ip_list)

    @_builtins.property
    @pulumi.getter(name="securityIpGroupAttribute")
    def security_ip_group_attribute(self) -> _builtins.str:
        """
        The attribute of the IP whitelist. This parameter is empty by default.
        """
        return pulumi.get(self, "security_ip_group_attribute")

    @_builtins.property
    @pulumi.getter(name="securityIpGroupName")
    def security_ip_group_name(self) -> _builtins.str:
        """
        The name of the IP whitelist.
        """
        return pulumi.get(self, "security_ip_group_name")

    @_builtins.property
    @pulumi.getter(name="securityIpList")
    def security_ip_list(self) -> _builtins.str:
        """
        The IP addresses in the whitelist.
        """
        return pulumi.get(self, "security_ip_list")


@pulumi.output_type
class GetShardingNetworkPrivateAddressesAddressResult(dict):
    def __init__(__self__, *,
                 db_instance_id: _builtins.str,
                 expired_time: _builtins.str,
                 ip_address: _builtins.str,
                 network_address: _builtins.str,
                 network_type: _builtins.str,
                 node_id: _builtins.str,
                 node_type: _builtins.str,
                 port: _builtins.str,
                 role: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param _builtins.str db_instance_id: The db instance id.
        :param _builtins.str expired_time: The remaining duration of the classic network address. Unit: `seconds`.
        :param _builtins.str ip_address: The IP address of the instance.
        :param _builtins.str network_address: The endpoint of the instance.
        :param _builtins.str network_type: The type of the network.
        :param _builtins.str node_id: The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
        :param _builtins.str node_type: The type of the node.
        :param _builtins.str port: The port number.
        :param _builtins.str role: The role of the node.
        :param _builtins.str vpc_id: The ID of the VPC.
        :param _builtins.str vswitch_id: The vSwitch ID of the VPC.
        """
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network_address", network_address)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> _builtins.str:
        """
        The db instance id.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.str:
        """
        The remaining duration of the classic network address. Unit: `seconds`.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address of the instance.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> _builtins.str:
        """
        The endpoint of the instance.
        """
        return pulumi.get(self, "network_address")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        The type of the network.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        """
        The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> _builtins.str:
        """
        The type of the node.
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        The port number.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        The role of the node.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The vSwitch ID of the VPC.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetShardingNetworkPublicAddressesAddressResult(dict):
    def __init__(__self__, *,
                 db_instance_id: _builtins.str,
                 expired_time: _builtins.str,
                 ip_address: _builtins.str,
                 network_address: _builtins.str,
                 network_type: _builtins.str,
                 node_id: _builtins.str,
                 node_type: _builtins.str,
                 port: _builtins.str,
                 role: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param _builtins.str db_instance_id: The db instance id.
        :param _builtins.str expired_time: The remaining duration of the classic network address. Unit: `seconds`.
        :param _builtins.str ip_address: The IP address of the instance.
        :param _builtins.str network_address: The endpoint of the instance.
        :param _builtins.str network_type: The network type.
        :param _builtins.str node_id: The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
        :param _builtins.str node_type: The type of the node.
        :param _builtins.str port: The port number.
        :param _builtins.str role: The role of the node.
        :param _builtins.str vpc_id: The ID of the VPC.
        :param _builtins.str vswitch_id: The vSwitch ID of the VPC.
        """
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network_address", network_address)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> _builtins.str:
        """
        The db instance id.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.str:
        """
        The remaining duration of the classic network address. Unit: `seconds`.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address of the instance.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> _builtins.str:
        """
        The endpoint of the instance.
        """
        return pulumi.get(self, "network_address")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        The network type.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        """
        The ID of the `mongos`, `shard`, or `Configserver` node in the sharded cluster instance.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> _builtins.str:
        """
        The type of the node.
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        The port number.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        The role of the node.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The vSwitch ID of the VPC.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 multi_zone_ids: Sequence[_builtins.str]):
        """
        :param _builtins.str id: ID of the zone.
        :param Sequence[_builtins.str] multi_zone_ids: A list of zone ids in which the multi zone.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "multi_zone_ids", multi_zone_ids)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the zone.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="multiZoneIds")
    def multi_zone_ids(self) -> Sequence[_builtins.str]:
        """
        A list of zone ids in which the multi zone.
        """
        return pulumi.get(self, "multi_zone_ids")


