# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretParameterArgs', 'SecretParameter']

@pulumi.input_type
class SecretParameterArgs:
    def __init__(__self__, *,
                 secret_parameter_name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str],
                 constraints: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dkms_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecretParameter resource.
        :param pulumi.Input[_builtins.str] secret_parameter_name: The name of the encryption parameter.  The name must be `2` to `180` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/) and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, `ALICLOUD`, or `OOS`.
        :param pulumi.Input[_builtins.str] value: The value of the encryption parameter. The value must be `1` to `4096` characters in length.
        :param pulumi.Input[_builtins.str] constraints: The constraints of the encryption parameter. By default, this parameter is null. Valid values:
               * `AllowedValues`: The value that is allowed for the encryption parameter. It must be an array string.
               * `AllowedPattern`: The pattern that is allowed for the encryption parameter. It must be a regular expression.
               * `MinLength`: The minimum length of the encryption parameter.
               * `MaxLength`: The maximum length of the encryption parameter.
        :param pulumi.Input[_builtins.str] description: The description of the encryption parameter. The description must be `1` to `200` characters in length.
        :param pulumi.Input[_builtins.str] dkms_instance_id: The ID of the KMS instance.
        :param pulumi.Input[_builtins.str] key_id: The Customer Master Key (CMK) of Key Management Service (KMS) that is used to encrypt the parameter.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the Resource Group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The data type of the encryption parameter. Valid values: `Secret`.
        """
        pulumi.set(__self__, "secret_parameter_name", secret_parameter_name)
        pulumi.set(__self__, "value", value)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dkms_instance_id is not None:
            pulumi.set(__self__, "dkms_instance_id", dkms_instance_id)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="secretParameterName")
    def secret_parameter_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the encryption parameter.  The name must be `2` to `180` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/) and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, `ALICLOUD`, or `OOS`.
        """
        return pulumi.get(self, "secret_parameter_name")

    @secret_parameter_name.setter
    def secret_parameter_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_parameter_name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The value of the encryption parameter. The value must be `1` to `4096` characters in length.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter
    def constraints(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The constraints of the encryption parameter. By default, this parameter is null. Valid values:
        * `AllowedValues`: The value that is allowed for the encryption parameter. It must be an array string.
        * `AllowedPattern`: The pattern that is allowed for the encryption parameter. It must be a regular expression.
        * `MinLength`: The minimum length of the encryption parameter.
        * `MaxLength`: The maximum length of the encryption parameter.
        """
        return pulumi.get(self, "constraints")

    @constraints.setter
    def constraints(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "constraints", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the encryption parameter. The description must be `1` to `200` characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dkmsInstanceId")
    def dkms_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS instance.
        """
        return pulumi.get(self, "dkms_instance_id")

    @dkms_instance_id.setter
    def dkms_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dkms_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Customer Master Key (CMK) of Key Management Service (KMS) that is used to encrypt the parameter.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Resource Group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data type of the encryption parameter. Valid values: `Secret`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _SecretParameterState:
    def __init__(__self__, *,
                 constraints: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dkms_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_parameter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretParameter resources.
        :param pulumi.Input[_builtins.str] constraints: The constraints of the encryption parameter. By default, this parameter is null. Valid values:
               * `AllowedValues`: The value that is allowed for the encryption parameter. It must be an array string.
               * `AllowedPattern`: The pattern that is allowed for the encryption parameter. It must be a regular expression.
               * `MinLength`: The minimum length of the encryption parameter.
               * `MaxLength`: The maximum length of the encryption parameter.
        :param pulumi.Input[_builtins.str] create_time: Parameter creation time
        :param pulumi.Input[_builtins.str] description: The description of the encryption parameter. The description must be `1` to `200` characters in length.
        :param pulumi.Input[_builtins.str] dkms_instance_id: The ID of the KMS instance.
        :param pulumi.Input[_builtins.str] key_id: The Customer Master Key (CMK) of Key Management Service (KMS) that is used to encrypt the parameter.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the Resource Group.
        :param pulumi.Input[_builtins.str] secret_parameter_name: The name of the encryption parameter.  The name must be `2` to `180` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/) and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, `ALICLOUD`, or `OOS`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The data type of the encryption parameter. Valid values: `Secret`.
        :param pulumi.Input[_builtins.str] value: The value of the encryption parameter. The value must be `1` to `4096` characters in length.
        """
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dkms_instance_id is not None:
            pulumi.set(__self__, "dkms_instance_id", dkms_instance_id)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if secret_parameter_name is not None:
            pulumi.set(__self__, "secret_parameter_name", secret_parameter_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def constraints(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The constraints of the encryption parameter. By default, this parameter is null. Valid values:
        * `AllowedValues`: The value that is allowed for the encryption parameter. It must be an array string.
        * `AllowedPattern`: The pattern that is allowed for the encryption parameter. It must be a regular expression.
        * `MinLength`: The minimum length of the encryption parameter.
        * `MaxLength`: The maximum length of the encryption parameter.
        """
        return pulumi.get(self, "constraints")

    @constraints.setter
    def constraints(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "constraints", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parameter creation time
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the encryption parameter. The description must be `1` to `200` characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dkmsInstanceId")
    def dkms_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS instance.
        """
        return pulumi.get(self, "dkms_instance_id")

    @dkms_instance_id.setter
    def dkms_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dkms_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Customer Master Key (CMK) of Key Management Service (KMS) that is used to encrypt the parameter.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Resource Group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="secretParameterName")
    def secret_parameter_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the encryption parameter.  The name must be `2` to `180` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/) and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, `ALICLOUD`, or `OOS`.
        """
        return pulumi.get(self, "secret_parameter_name")

    @secret_parameter_name.setter
    def secret_parameter_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_parameter_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data type of the encryption parameter. Valid values: `Secret`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the encryption parameter. The value must be `1` to `4096` characters in length.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("alicloud:oos/secretParameter:SecretParameter")
class SecretParameter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 constraints: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dkms_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_parameter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Operation Orchestration Service (OOS) Secret Parameter resource.

        For information about Operation Orchestration Service (OOS) Secret Parameter and how to use it, see [What is Secret Parameter](https://www.alibabacloud.com/help/en/doc-detail/183418.html).

        > **NOTE:** Available since v1.147.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.resourcemanager.get_resource_groups()
        example_key = alicloud.kms.Key("example",
            description="terraform-example",
            status="Enabled",
            pending_window_in_days=7)
        example_secret_parameter = alicloud.oos.SecretParameter("example",
            secret_parameter_name="terraform-example",
            value="terraform-example",
            type="Secret",
            key_id=example_key.id,
            description="terraform-example",
            tags={
                "Created": "TF",
                "For": "OosSecretParameter",
            },
            resource_group_id=example.groups[0].id)
        ```

        ## Import

        Operation Orchestration Service (OOS) Secret Parameter can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oos/secretParameter:SecretParameter example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] constraints: The constraints of the encryption parameter. By default, this parameter is null. Valid values:
               * `AllowedValues`: The value that is allowed for the encryption parameter. It must be an array string.
               * `AllowedPattern`: The pattern that is allowed for the encryption parameter. It must be a regular expression.
               * `MinLength`: The minimum length of the encryption parameter.
               * `MaxLength`: The maximum length of the encryption parameter.
        :param pulumi.Input[_builtins.str] description: The description of the encryption parameter. The description must be `1` to `200` characters in length.
        :param pulumi.Input[_builtins.str] dkms_instance_id: The ID of the KMS instance.
        :param pulumi.Input[_builtins.str] key_id: The Customer Master Key (CMK) of Key Management Service (KMS) that is used to encrypt the parameter.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the Resource Group.
        :param pulumi.Input[_builtins.str] secret_parameter_name: The name of the encryption parameter.  The name must be `2` to `180` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/) and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, `ALICLOUD`, or `OOS`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The data type of the encryption parameter. Valid values: `Secret`.
        :param pulumi.Input[_builtins.str] value: The value of the encryption parameter. The value must be `1` to `4096` characters in length.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretParameterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Operation Orchestration Service (OOS) Secret Parameter resource.

        For information about Operation Orchestration Service (OOS) Secret Parameter and how to use it, see [What is Secret Parameter](https://www.alibabacloud.com/help/en/doc-detail/183418.html).

        > **NOTE:** Available since v1.147.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.resourcemanager.get_resource_groups()
        example_key = alicloud.kms.Key("example",
            description="terraform-example",
            status="Enabled",
            pending_window_in_days=7)
        example_secret_parameter = alicloud.oos.SecretParameter("example",
            secret_parameter_name="terraform-example",
            value="terraform-example",
            type="Secret",
            key_id=example_key.id,
            description="terraform-example",
            tags={
                "Created": "TF",
                "For": "OosSecretParameter",
            },
            resource_group_id=example.groups[0].id)
        ```

        ## Import

        Operation Orchestration Service (OOS) Secret Parameter can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oos/secretParameter:SecretParameter example <id>
        ```

        :param str resource_name: The name of the resource.
        :param SecretParameterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretParameterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 constraints: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dkms_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_parameter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretParameterArgs.__new__(SecretParameterArgs)

            __props__.__dict__["constraints"] = constraints
            __props__.__dict__["description"] = description
            __props__.__dict__["dkms_instance_id"] = dkms_instance_id
            __props__.__dict__["key_id"] = key_id
            __props__.__dict__["resource_group_id"] = resource_group_id
            if secret_parameter_name is None and not opts.urn:
                raise TypeError("Missing required property 'secret_parameter_name'")
            __props__.__dict__["secret_parameter_name"] = secret_parameter_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = None if value is None else pulumi.Output.secret(value)
            __props__.__dict__["create_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["value"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SecretParameter, __self__).__init__(
            'alicloud:oos/secretParameter:SecretParameter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            constraints: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dkms_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            secret_parameter_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecretParameter':
        """
        Get an existing SecretParameter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] constraints: The constraints of the encryption parameter. By default, this parameter is null. Valid values:
               * `AllowedValues`: The value that is allowed for the encryption parameter. It must be an array string.
               * `AllowedPattern`: The pattern that is allowed for the encryption parameter. It must be a regular expression.
               * `MinLength`: The minimum length of the encryption parameter.
               * `MaxLength`: The maximum length of the encryption parameter.
        :param pulumi.Input[_builtins.str] create_time: Parameter creation time
        :param pulumi.Input[_builtins.str] description: The description of the encryption parameter. The description must be `1` to `200` characters in length.
        :param pulumi.Input[_builtins.str] dkms_instance_id: The ID of the KMS instance.
        :param pulumi.Input[_builtins.str] key_id: The Customer Master Key (CMK) of Key Management Service (KMS) that is used to encrypt the parameter.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the Resource Group.
        :param pulumi.Input[_builtins.str] secret_parameter_name: The name of the encryption parameter.  The name must be `2` to `180` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/) and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, `ALICLOUD`, or `OOS`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The data type of the encryption parameter. Valid values: `Secret`.
        :param pulumi.Input[_builtins.str] value: The value of the encryption parameter. The value must be `1` to `4096` characters in length.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretParameterState.__new__(_SecretParameterState)

        __props__.__dict__["constraints"] = constraints
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["dkms_instance_id"] = dkms_instance_id
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["secret_parameter_name"] = secret_parameter_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["value"] = value
        return SecretParameter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def constraints(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The constraints of the encryption parameter. By default, this parameter is null. Valid values:
        * `AllowedValues`: The value that is allowed for the encryption parameter. It must be an array string.
        * `AllowedPattern`: The pattern that is allowed for the encryption parameter. It must be a regular expression.
        * `MinLength`: The minimum length of the encryption parameter.
        * `MaxLength`: The maximum length of the encryption parameter.
        """
        return pulumi.get(self, "constraints")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Parameter creation time
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the encryption parameter. The description must be `1` to `200` characters in length.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dkmsInstanceId")
    def dkms_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the KMS instance.
        """
        return pulumi.get(self, "dkms_instance_id")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Customer Master Key (CMK) of Key Management Service (KMS) that is used to encrypt the parameter.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Resource Group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="secretParameterName")
    def secret_parameter_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the encryption parameter.  The name must be `2` to `180` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/) and underscores (_). It cannot start with `ALIYUN`, `ACS`, `ALIBABA`, `ALICLOUD`, or `OOS`.
        """
        return pulumi.get(self, "secret_parameter_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The data type of the encryption parameter. Valid values: `Secret`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        The value of the encryption parameter. The value must be `1` to `4096` characters in length.
        """
        return pulumi.get(self, "value")

