# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketArgs', 'Bucket']

@pulumi.input_type
class BucketArgs:
    def __init__(__self__, *,
                 access_monitor: Optional[pulumi.Input['BucketAccessMonitorArgs']] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_rule_allow_same_action_overlap: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]] = None,
                 logging: Optional[pulumi.Input['BucketLoggingArgs']] = None,
                 logging_isenable: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 redundancy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 referer_config: Optional[pulumi.Input['BucketRefererConfigArgs']] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption_rule: Optional[pulumi.Input['BucketServerSideEncryptionRuleArgs']] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transfer_acceleration: Optional[pulumi.Input['BucketTransferAccelerationArgs']] = None,
                 versioning: Optional[pulumi.Input['BucketVersioningArgs']] = None,
                 website: Optional[pulumi.Input['BucketWebsiteArgs']] = None):
        """
        The set of arguments for constructing a Bucket resource.
        :param pulumi.Input['BucketAccessMonitorArgs'] access_monitor: A access monitor status of a bucket. See `access_monitor` below.
        :param pulumi.Input[_builtins.str] acl: The [canned ACL](https://www.alibabacloud.com/help/doc-detail/31898.htm) to apply. Can be "private", "public-read" and "public-read-write". This property has been deprecated since 1.220.0, please use the resource `oss.BucketAcl` instead.
        :param pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]] cors_rules: A rule of  [Cross-Origin Resource Sharing](https://www.alibabacloud.com/help/doc-detail/31903.htm). The items of core rule are no more than 10 for every OSS bucket. See `cors_rule` below.
        :param pulumi.Input[_builtins.bool] force_destroy: A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are not recoverable. Defaults to "false".
        :param pulumi.Input[_builtins.bool] lifecycle_rule_allow_same_action_overlap: A boolean that indicates lifecycle rules allow prefix overlap.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]] lifecycle_rules: A configuration of [object lifecycle management](https://www.alibabacloud.com/help/doc-detail/31904.htm). See `lifecycle_rule` below.
        :param pulumi.Input['BucketLoggingArgs'] logging: A Settings of [bucket logging](https://www.alibabacloud.com/help/doc-detail/31900.htm). See `logging` below.
        :param pulumi.Input[_builtins.bool] logging_isenable: The flag of using logging enable container. Defaults true.
        :param pulumi.Input[_builtins.str] policy: Json format text of bucket policy [bucket policy management](https://www.alibabacloud.com/help/doc-detail/100680.htm). This property has been deprecated since 1.220.0, please use the resource `oss.BucketPolicy` instead.
        :param pulumi.Input[_builtins.str] redundancy_type: The [redundancy type](https://www.alibabacloud.com/help/doc-detail/90589.htm) to enable. Can be "LRS", and "ZRS". Defaults to "LRS".
        :param pulumi.Input['BucketRefererConfigArgs'] referer_config: The configuration of [referer](https://www.alibabacloud.com/help/doc-detail/31901.htm). This property has been deprecated since 1.220.0, please use the resource `oss.BucketReferer` instead. See `referer_config` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the bucket belongs.
        :param pulumi.Input['BucketServerSideEncryptionRuleArgs'] server_side_encryption_rule: A configuration of server-side encryption. See `server_side_encryption_rule` below.
        :param pulumi.Input[_builtins.str] storage_class: The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the bucket. The items are no more than 10 for a bucket.
        :param pulumi.Input['BucketTransferAccelerationArgs'] transfer_acceleration: A transfer acceleration status of a bucket. See `transfer_acceleration` below.
        :param pulumi.Input['BucketVersioningArgs'] versioning: A state of versioning. See `versioning` below.
        :param pulumi.Input['BucketWebsiteArgs'] website: A website configuration. See `website` below.
        """
        if access_monitor is not None:
            pulumi.set(__self__, "access_monitor", access_monitor)
        if acl is not None:
            warnings.warn("""Field 'acl' has been deprecated since provider version 1.220.0. New resource 'alicloud_oss_bucket_acl' instead.""", DeprecationWarning)
            pulumi.log.warn("""acl is deprecated: Field 'acl' has been deprecated since provider version 1.220.0. New resource 'alicloud_oss_bucket_acl' instead.""")
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if lifecycle_rule_allow_same_action_overlap is not None:
            pulumi.set(__self__, "lifecycle_rule_allow_same_action_overlap", lifecycle_rule_allow_same_action_overlap)
        if lifecycle_rules is not None:
            pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if logging_isenable is not None:
            warnings.warn("""Deprecated from 1.37.0. When `logging` is set, the bucket logging will be able.""", DeprecationWarning)
            pulumi.log.warn("""logging_isenable is deprecated: Deprecated from 1.37.0. When `logging` is set, the bucket logging will be able.""")
        if logging_isenable is not None:
            pulumi.set(__self__, "logging_isenable", logging_isenable)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if redundancy_type is not None:
            pulumi.set(__self__, "redundancy_type", redundancy_type)
        if referer_config is not None:
            pulumi.set(__self__, "referer_config", referer_config)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if server_side_encryption_rule is not None:
            pulumi.set(__self__, "server_side_encryption_rule", server_side_encryption_rule)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transfer_acceleration is not None:
            pulumi.set(__self__, "transfer_acceleration", transfer_acceleration)
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)
        if website is not None:
            pulumi.set(__self__, "website", website)

    @_builtins.property
    @pulumi.getter(name="accessMonitor")
    def access_monitor(self) -> Optional[pulumi.Input['BucketAccessMonitorArgs']]:
        """
        A access monitor status of a bucket. See `access_monitor` below.
        """
        return pulumi.get(self, "access_monitor")

    @access_monitor.setter
    def access_monitor(self, value: Optional[pulumi.Input['BucketAccessMonitorArgs']]):
        pulumi.set(self, "access_monitor", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'acl' has been deprecated since provider version 1.220.0. New resource 'alicloud_oss_bucket_acl' instead.""")
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [canned ACL](https://www.alibabacloud.com/help/doc-detail/31898.htm) to apply. Can be "private", "public-read" and "public-read-write". This property has been deprecated since 1.220.0, please use the resource `oss.BucketAcl` instead.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]]:
        """
        A rule of  [Cross-Origin Resource Sharing](https://www.alibabacloud.com/help/doc-detail/31903.htm). The items of core rule are no more than 10 for every OSS bucket. See `cors_rule` below.
        """
        return pulumi.get(self, "cors_rules")

    @cors_rules.setter
    def cors_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]]):
        pulumi.set(self, "cors_rules", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are not recoverable. Defaults to "false".
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleRuleAllowSameActionOverlap")
    def lifecycle_rule_allow_same_action_overlap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean that indicates lifecycle rules allow prefix overlap.
        """
        return pulumi.get(self, "lifecycle_rule_allow_same_action_overlap")

    @lifecycle_rule_allow_same_action_overlap.setter
    def lifecycle_rule_allow_same_action_overlap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lifecycle_rule_allow_same_action_overlap", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]]:
        """
        A configuration of [object lifecycle management](https://www.alibabacloud.com/help/doc-detail/31904.htm). See `lifecycle_rule` below.
        """
        return pulumi.get(self, "lifecycle_rules")

    @lifecycle_rules.setter
    def lifecycle_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]]):
        pulumi.set(self, "lifecycle_rules", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['BucketLoggingArgs']]:
        """
        A Settings of [bucket logging](https://www.alibabacloud.com/help/doc-detail/31900.htm). See `logging` below.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['BucketLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter(name="loggingIsenable")
    @_utilities.deprecated("""Deprecated from 1.37.0. When `logging` is set, the bucket logging will be able.""")
    def logging_isenable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The flag of using logging enable container. Defaults true.
        """
        return pulumi.get(self, "logging_isenable")

    @logging_isenable.setter
    def logging_isenable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "logging_isenable", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Json format text of bucket policy [bucket policy management](https://www.alibabacloud.com/help/doc-detail/100680.htm). This property has been deprecated since 1.220.0, please use the resource `oss.BucketPolicy` instead.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="redundancyType")
    def redundancy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [redundancy type](https://www.alibabacloud.com/help/doc-detail/90589.htm) to enable. Can be "LRS", and "ZRS". Defaults to "LRS".
        """
        return pulumi.get(self, "redundancy_type")

    @redundancy_type.setter
    def redundancy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redundancy_type", value)

    @_builtins.property
    @pulumi.getter(name="refererConfig")
    def referer_config(self) -> Optional[pulumi.Input['BucketRefererConfigArgs']]:
        """
        The configuration of [referer](https://www.alibabacloud.com/help/doc-detail/31901.htm). This property has been deprecated since 1.220.0, please use the resource `oss.BucketReferer` instead. See `referer_config` below.
        """
        return pulumi.get(self, "referer_config")

    @referer_config.setter
    def referer_config(self, value: Optional[pulumi.Input['BucketRefererConfigArgs']]):
        pulumi.set(self, "referer_config", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the bucket belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serverSideEncryptionRule")
    def server_side_encryption_rule(self) -> Optional[pulumi.Input['BucketServerSideEncryptionRuleArgs']]:
        """
        A configuration of server-side encryption. See `server_side_encryption_rule` below.
        """
        return pulumi.get(self, "server_side_encryption_rule")

    @server_side_encryption_rule.setter
    def server_side_encryption_rule(self, value: Optional[pulumi.Input['BucketServerSideEncryptionRuleArgs']]):
        pulumi.set(self, "server_side_encryption_rule", value)

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_class", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the bucket. The items are no more than 10 for a bucket.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transferAcceleration")
    def transfer_acceleration(self) -> Optional[pulumi.Input['BucketTransferAccelerationArgs']]:
        """
        A transfer acceleration status of a bucket. See `transfer_acceleration` below.
        """
        return pulumi.get(self, "transfer_acceleration")

    @transfer_acceleration.setter
    def transfer_acceleration(self, value: Optional[pulumi.Input['BucketTransferAccelerationArgs']]):
        pulumi.set(self, "transfer_acceleration", value)

    @_builtins.property
    @pulumi.getter
    def versioning(self) -> Optional[pulumi.Input['BucketVersioningArgs']]:
        """
        A state of versioning. See `versioning` below.
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input['BucketVersioningArgs']]):
        pulumi.set(self, "versioning", value)

    @_builtins.property
    @pulumi.getter
    def website(self) -> Optional[pulumi.Input['BucketWebsiteArgs']]:
        """
        A website configuration. See `website` below.
        """
        return pulumi.get(self, "website")

    @website.setter
    def website(self, value: Optional[pulumi.Input['BucketWebsiteArgs']]):
        pulumi.set(self, "website", value)


@pulumi.input_type
class _BucketState:
    def __init__(__self__, *,
                 access_monitor: Optional[pulumi.Input['BucketAccessMonitorArgs']] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]] = None,
                 creation_date: Optional[pulumi.Input[_builtins.str]] = None,
                 extranet_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 intranet_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_rule_allow_same_action_overlap: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging: Optional[pulumi.Input['BucketLoggingArgs']] = None,
                 logging_isenable: Optional[pulumi.Input[_builtins.bool]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 redundancy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 referer_config: Optional[pulumi.Input['BucketRefererConfigArgs']] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption_rule: Optional[pulumi.Input['BucketServerSideEncryptionRuleArgs']] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transfer_acceleration: Optional[pulumi.Input['BucketTransferAccelerationArgs']] = None,
                 versioning: Optional[pulumi.Input['BucketVersioningArgs']] = None,
                 website: Optional[pulumi.Input['BucketWebsiteArgs']] = None):
        """
        Input properties used for looking up and filtering Bucket resources.
        :param pulumi.Input['BucketAccessMonitorArgs'] access_monitor: A access monitor status of a bucket. See `access_monitor` below.
        :param pulumi.Input[_builtins.str] acl: The [canned ACL](https://www.alibabacloud.com/help/doc-detail/31898.htm) to apply. Can be "private", "public-read" and "public-read-write". This property has been deprecated since 1.220.0, please use the resource `oss.BucketAcl` instead.
        :param pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]] cors_rules: A rule of  [Cross-Origin Resource Sharing](https://www.alibabacloud.com/help/doc-detail/31903.htm). The items of core rule are no more than 10 for every OSS bucket. See `cors_rule` below.
        :param pulumi.Input[_builtins.str] creation_date: The creation date of the bucket.
        :param pulumi.Input[_builtins.str] extranet_endpoint: The extranet access endpoint of the bucket.
        :param pulumi.Input[_builtins.bool] force_destroy: A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are not recoverable. Defaults to "false".
        :param pulumi.Input[_builtins.str] intranet_endpoint: The intranet access endpoint of the bucket.
        :param pulumi.Input[_builtins.bool] lifecycle_rule_allow_same_action_overlap: A boolean that indicates lifecycle rules allow prefix overlap.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]] lifecycle_rules: A configuration of [object lifecycle management](https://www.alibabacloud.com/help/doc-detail/31904.htm). See `lifecycle_rule` below.
        :param pulumi.Input[_builtins.str] location: The location of the bucket.
        :param pulumi.Input['BucketLoggingArgs'] logging: A Settings of [bucket logging](https://www.alibabacloud.com/help/doc-detail/31900.htm). See `logging` below.
        :param pulumi.Input[_builtins.bool] logging_isenable: The flag of using logging enable container. Defaults true.
        :param pulumi.Input[_builtins.str] owner: The bucket owner.
        :param pulumi.Input[_builtins.str] policy: Json format text of bucket policy [bucket policy management](https://www.alibabacloud.com/help/doc-detail/100680.htm). This property has been deprecated since 1.220.0, please use the resource `oss.BucketPolicy` instead.
        :param pulumi.Input[_builtins.str] redundancy_type: The [redundancy type](https://www.alibabacloud.com/help/doc-detail/90589.htm) to enable. Can be "LRS", and "ZRS". Defaults to "LRS".
        :param pulumi.Input['BucketRefererConfigArgs'] referer_config: The configuration of [referer](https://www.alibabacloud.com/help/doc-detail/31901.htm). This property has been deprecated since 1.220.0, please use the resource `oss.BucketReferer` instead. See `referer_config` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the bucket belongs.
        :param pulumi.Input['BucketServerSideEncryptionRuleArgs'] server_side_encryption_rule: A configuration of server-side encryption. See `server_side_encryption_rule` below.
        :param pulumi.Input[_builtins.str] storage_class: The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the bucket. The items are no more than 10 for a bucket.
        :param pulumi.Input['BucketTransferAccelerationArgs'] transfer_acceleration: A transfer acceleration status of a bucket. See `transfer_acceleration` below.
        :param pulumi.Input['BucketVersioningArgs'] versioning: A state of versioning. See `versioning` below.
        :param pulumi.Input['BucketWebsiteArgs'] website: A website configuration. See `website` below.
        """
        if access_monitor is not None:
            pulumi.set(__self__, "access_monitor", access_monitor)
        if acl is not None:
            warnings.warn("""Field 'acl' has been deprecated since provider version 1.220.0. New resource 'alicloud_oss_bucket_acl' instead.""", DeprecationWarning)
            pulumi.log.warn("""acl is deprecated: Field 'acl' has been deprecated since provider version 1.220.0. New resource 'alicloud_oss_bucket_acl' instead.""")
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if extranet_endpoint is not None:
            pulumi.set(__self__, "extranet_endpoint", extranet_endpoint)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if intranet_endpoint is not None:
            pulumi.set(__self__, "intranet_endpoint", intranet_endpoint)
        if lifecycle_rule_allow_same_action_overlap is not None:
            pulumi.set(__self__, "lifecycle_rule_allow_same_action_overlap", lifecycle_rule_allow_same_action_overlap)
        if lifecycle_rules is not None:
            pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if logging_isenable is not None:
            warnings.warn("""Deprecated from 1.37.0. When `logging` is set, the bucket logging will be able.""", DeprecationWarning)
            pulumi.log.warn("""logging_isenable is deprecated: Deprecated from 1.37.0. When `logging` is set, the bucket logging will be able.""")
        if logging_isenable is not None:
            pulumi.set(__self__, "logging_isenable", logging_isenable)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if redundancy_type is not None:
            pulumi.set(__self__, "redundancy_type", redundancy_type)
        if referer_config is not None:
            pulumi.set(__self__, "referer_config", referer_config)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if server_side_encryption_rule is not None:
            pulumi.set(__self__, "server_side_encryption_rule", server_side_encryption_rule)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transfer_acceleration is not None:
            pulumi.set(__self__, "transfer_acceleration", transfer_acceleration)
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)
        if website is not None:
            pulumi.set(__self__, "website", website)

    @_builtins.property
    @pulumi.getter(name="accessMonitor")
    def access_monitor(self) -> Optional[pulumi.Input['BucketAccessMonitorArgs']]:
        """
        A access monitor status of a bucket. See `access_monitor` below.
        """
        return pulumi.get(self, "access_monitor")

    @access_monitor.setter
    def access_monitor(self, value: Optional[pulumi.Input['BucketAccessMonitorArgs']]):
        pulumi.set(self, "access_monitor", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'acl' has been deprecated since provider version 1.220.0. New resource 'alicloud_oss_bucket_acl' instead.""")
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [canned ACL](https://www.alibabacloud.com/help/doc-detail/31898.htm) to apply. Can be "private", "public-read" and "public-read-write". This property has been deprecated since 1.220.0, please use the resource `oss.BucketAcl` instead.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]]:
        """
        A rule of  [Cross-Origin Resource Sharing](https://www.alibabacloud.com/help/doc-detail/31903.htm). The items of core rule are no more than 10 for every OSS bucket. See `cors_rule` below.
        """
        return pulumi.get(self, "cors_rules")

    @cors_rules.setter
    def cors_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]]):
        pulumi.set(self, "cors_rules", value)

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation date of the bucket.
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_date", value)

    @_builtins.property
    @pulumi.getter(name="extranetEndpoint")
    def extranet_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The extranet access endpoint of the bucket.
        """
        return pulumi.get(self, "extranet_endpoint")

    @extranet_endpoint.setter
    def extranet_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extranet_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are not recoverable. Defaults to "false".
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="intranetEndpoint")
    def intranet_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The intranet access endpoint of the bucket.
        """
        return pulumi.get(self, "intranet_endpoint")

    @intranet_endpoint.setter
    def intranet_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "intranet_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleRuleAllowSameActionOverlap")
    def lifecycle_rule_allow_same_action_overlap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean that indicates lifecycle rules allow prefix overlap.
        """
        return pulumi.get(self, "lifecycle_rule_allow_same_action_overlap")

    @lifecycle_rule_allow_same_action_overlap.setter
    def lifecycle_rule_allow_same_action_overlap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lifecycle_rule_allow_same_action_overlap", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]]:
        """
        A configuration of [object lifecycle management](https://www.alibabacloud.com/help/doc-detail/31904.htm). See `lifecycle_rule` below.
        """
        return pulumi.get(self, "lifecycle_rules")

    @lifecycle_rules.setter
    def lifecycle_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]]):
        pulumi.set(self, "lifecycle_rules", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the bucket.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['BucketLoggingArgs']]:
        """
        A Settings of [bucket logging](https://www.alibabacloud.com/help/doc-detail/31900.htm). See `logging` below.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['BucketLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter(name="loggingIsenable")
    @_utilities.deprecated("""Deprecated from 1.37.0. When `logging` is set, the bucket logging will be able.""")
    def logging_isenable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The flag of using logging enable container. Defaults true.
        """
        return pulumi.get(self, "logging_isenable")

    @logging_isenable.setter
    def logging_isenable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "logging_isenable", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bucket owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Json format text of bucket policy [bucket policy management](https://www.alibabacloud.com/help/doc-detail/100680.htm). This property has been deprecated since 1.220.0, please use the resource `oss.BucketPolicy` instead.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="redundancyType")
    def redundancy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [redundancy type](https://www.alibabacloud.com/help/doc-detail/90589.htm) to enable. Can be "LRS", and "ZRS". Defaults to "LRS".
        """
        return pulumi.get(self, "redundancy_type")

    @redundancy_type.setter
    def redundancy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redundancy_type", value)

    @_builtins.property
    @pulumi.getter(name="refererConfig")
    def referer_config(self) -> Optional[pulumi.Input['BucketRefererConfigArgs']]:
        """
        The configuration of [referer](https://www.alibabacloud.com/help/doc-detail/31901.htm). This property has been deprecated since 1.220.0, please use the resource `oss.BucketReferer` instead. See `referer_config` below.
        """
        return pulumi.get(self, "referer_config")

    @referer_config.setter
    def referer_config(self, value: Optional[pulumi.Input['BucketRefererConfigArgs']]):
        pulumi.set(self, "referer_config", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the bucket belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serverSideEncryptionRule")
    def server_side_encryption_rule(self) -> Optional[pulumi.Input['BucketServerSideEncryptionRuleArgs']]:
        """
        A configuration of server-side encryption. See `server_side_encryption_rule` below.
        """
        return pulumi.get(self, "server_side_encryption_rule")

    @server_side_encryption_rule.setter
    def server_side_encryption_rule(self, value: Optional[pulumi.Input['BucketServerSideEncryptionRuleArgs']]):
        pulumi.set(self, "server_side_encryption_rule", value)

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_class", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the bucket. The items are no more than 10 for a bucket.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transferAcceleration")
    def transfer_acceleration(self) -> Optional[pulumi.Input['BucketTransferAccelerationArgs']]:
        """
        A transfer acceleration status of a bucket. See `transfer_acceleration` below.
        """
        return pulumi.get(self, "transfer_acceleration")

    @transfer_acceleration.setter
    def transfer_acceleration(self, value: Optional[pulumi.Input['BucketTransferAccelerationArgs']]):
        pulumi.set(self, "transfer_acceleration", value)

    @_builtins.property
    @pulumi.getter
    def versioning(self) -> Optional[pulumi.Input['BucketVersioningArgs']]:
        """
        A state of versioning. See `versioning` below.
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input['BucketVersioningArgs']]):
        pulumi.set(self, "versioning", value)

    @_builtins.property
    @pulumi.getter
    def website(self) -> Optional[pulumi.Input['BucketWebsiteArgs']]:
        """
        A website configuration. See `website` below.
        """
        return pulumi.get(self, "website")

    @website.setter
    def website(self, value: Optional[pulumi.Input['BucketWebsiteArgs']]):
        pulumi.set(self, "website", value)


@pulumi.type_token("alicloud:oss/bucket:Bucket")
class Bucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_monitor: Optional[pulumi.Input[Union['BucketAccessMonitorArgs', 'BucketAccessMonitorArgsDict']]] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketCorsRuleArgs', 'BucketCorsRuleArgsDict']]]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_rule_allow_same_action_overlap: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleRuleArgs', 'BucketLifecycleRuleArgsDict']]]]] = None,
                 logging: Optional[pulumi.Input[Union['BucketLoggingArgs', 'BucketLoggingArgsDict']]] = None,
                 logging_isenable: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 redundancy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 referer_config: Optional[pulumi.Input[Union['BucketRefererConfigArgs', 'BucketRefererConfigArgsDict']]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption_rule: Optional[pulumi.Input[Union['BucketServerSideEncryptionRuleArgs', 'BucketServerSideEncryptionRuleArgsDict']]] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transfer_acceleration: Optional[pulumi.Input[Union['BucketTransferAccelerationArgs', 'BucketTransferAccelerationArgsDict']]] = None,
                 versioning: Optional[pulumi.Input[Union['BucketVersioningArgs', 'BucketVersioningArgsDict']]] = None,
                 website: Optional[pulumi.Input[Union['BucketWebsiteArgs', 'BucketWebsiteArgsDict']]] = None,
                 __props__=None):
        """
        Provides a resource to create a oss bucket and set its attribution.

        > **NOTE:** The bucket namespace is shared by all users of the OSS system. Please set bucket name as unique as possible.

        > **NOTE:** Available since v1.2.0.

        ## Example Usage

        Private Bucket

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_acl = alicloud.oss.Bucket("bucket-acl", bucket=f"example-value-{default['result']}")
        bucket_acl_bucket_acl = alicloud.oss.BucketAcl("bucket-acl",
            bucket=bucket_acl.bucket,
            acl="private")
        ```

        Static Website

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_website = alicloud.oss.Bucket("bucket-website",
            bucket=f"example-value-{default['result']}",
            website={
                "index_document": "index.html",
                "error_document": "error.html",
            })
        ```

        Enable Logging

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_target = alicloud.oss.Bucket("bucket-target", bucket=f"example-value-{default['result']}")
        bucket_target_bucket_acl = alicloud.oss.BucketAcl("bucket-target",
            bucket=bucket_target.bucket,
            acl="public-read")
        bucket_logging = alicloud.oss.Bucket("bucket-logging",
            bucket=f"example-logging-{default['result']}",
            logging={
                "target_bucket": bucket_target.id,
                "target_prefix": "log/",
            })
        ```

        Referer configuration

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_referer = alicloud.oss.Bucket("bucket-referer",
            bucket=f"example-value-{default['result']}",
            referer_config={
                "allow_empty": False,
                "referers": [
                    "http://www.aliyun.com",
                    "https://www.aliyun.com",
                ],
            })
        default_bucket_acl = alicloud.oss.BucketAcl("default",
            bucket=bucket_referer.bucket,
            acl="private")
        ```

        Set lifecycle rule

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_lifecycle1 = alicloud.oss.Bucket("bucket-lifecycle1",
            bucket=f"example-lifecycle1-{default['result']}",
            lifecycle_rules=[
                {
                    "id": "rule-days",
                    "prefix": "path1/",
                    "enabled": True,
                    "expirations": [{
                        "days": 365,
                    }],
                },
                {
                    "id": "rule-date",
                    "prefix": "path2/",
                    "enabled": True,
                    "expirations": [{
                        "date": "2018-01-12",
                    }],
                },
            ])
        bucket_lifecycle1_bucket_acl = alicloud.oss.BucketAcl("bucket-lifecycle1",
            bucket=bucket_lifecycle1.bucket,
            acl="public-read")
        bucket_lifecycle2 = alicloud.oss.Bucket("bucket-lifecycle2",
            bucket=f"example-lifecycle2-{default['result']}",
            lifecycle_rules=[{
                "id": "rule-days-transition",
                "prefix": "path3/",
                "enabled": True,
                "transitions": [
                    {
                        "days": 3,
                        "storage_class": "IA",
                    },
                    {
                        "days": 30,
                        "storage_class": "Archive",
                    },
                ],
            }])
        bucket_lifecycle2_bucket_acl = alicloud.oss.BucketAcl("bucket-lifecycle2",
            bucket=bucket_lifecycle2.bucket,
            acl="public-read")
        bucket_lifecycle3 = alicloud.oss.Bucket("bucket-lifecycle3",
            bucket=f"example-lifecycle3-{default['result']}",
            lifecycle_rules=[{
                "id": "rule-days-transition",
                "prefix": "path3/",
                "enabled": True,
                "transitions": [
                    {
                        "created_before_date": "2022-11-11",
                        "storage_class": "IA",
                    },
                    {
                        "created_before_date": "2021-11-11",
                        "storage_class": "Archive",
                    },
                ],
            }])
        bucket_lifecycle3_bucket_acl = alicloud.oss.BucketAcl("bucket-lifecycle3",
            bucket=bucket_lifecycle3.bucket,
            acl="public-read")
        bucket_lifecycle4 = alicloud.oss.Bucket("bucket-lifecycle4",
            bucket=f"example-lifecycle4-{default['result']}",
            lifecycle_rules=[{
                "id": "rule-abort-multipart-upload",
                "prefix": "path3/",
                "enabled": True,
                "abort_multipart_uploads": [{
                    "days": 128,
                }],
            }])
        bucket_lifecycle4_bucket_acl = alicloud.oss.BucketAcl("bucket-lifecycle4",
            bucket=bucket_lifecycle4.bucket,
            acl="public-read")
        bucket_versioning_lifecycle = alicloud.oss.Bucket("bucket-versioning-lifecycle",
            bucket=f"example-lifecycle5-{default['result']}",
            versioning={
                "status": "Enabled",
            },
            lifecycle_rules=[{
                "id": "rule-versioning",
                "prefix": "path1/",
                "enabled": True,
                "expirations": [{
                    "expired_object_delete_marker": True,
                }],
                "noncurrent_version_expirations": [{
                    "days": 240,
                }],
                "noncurrent_version_transitions": [
                    {
                        "days": 180,
                        "storage_class": "Archive",
                    },
                    {
                        "days": 60,
                        "storage_class": "IA",
                    },
                ],
            }])
        bucket_versioning_lifecycle_bucket_acl = alicloud.oss.BucketAcl("bucket-versioning-lifecycle",
            bucket=bucket_versioning_lifecycle.bucket,
            acl="private")
        bucket_access_monitor_lifecycle = alicloud.oss.Bucket("bucket-access-monitor-lifecycle",
            bucket=std.format(input="example-lifecycle6-%s",
                args=[default["result"]]).result,
            access_monitor={
                "status": "Enabled",
            },
            lifecycle_rules=[{
                "id": "rule-days-transition",
                "prefix": "path/",
                "enabled": True,
                "transitions": [{
                    "days": 30,
                    "storage_class": "IA",
                    "is_access_time": True,
                    "return_to_std_when_visit": True,
                }],
            }])
        bucket_access_monitor_lifecycle_bucket_acl = alicloud.oss.BucketAcl("bucket-access-monitor-lifecycle",
            bucket=bucket_access_monitor_lifecycle.bucket,
            acl="private")
        bucket_tag_lifecycle = alicloud.oss.Bucket("bucket-tag-lifecycle",
            bucket=std.format(input="example-lifecycle7-%s",
                args=[default["result"]]).result,
            lifecycle_rules=[{
                "id": "rule-days-transition",
                "prefix": "path/",
                "enabled": True,
                "transitions": [{
                    "created_before_date": "2022-11-11",
                    "storage_class": "IA",
                }],
            }],
            tags={
                "Created": "TF",
                "For": "example",
            })
        bucket_tag_lifecycle_bucket_acl = alicloud.oss.BucketAcl("bucket-tag-lifecycle",
            bucket=bucket_tag_lifecycle.bucket,
            acl="private")
        ```

        Set bucket policy

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_policy = alicloud.oss.Bucket("bucket-policy",
            bucket=f"example-policy-{default['result']}",
            policy=\"\"\"  {\\"Statement\\":
              [{\\"Action\\":
                  [\\"oss:PutObject\\", \\"oss:GetObject\\", \\"oss:DeleteBucket\\"],
                \\"Effect\\":\\"Allow\\",
                \\"Resource\\":
                    [\\"acs:oss:*:*:*\\"]}],
           \\"Version\\":\\"1\\"}
        \"\"\")
        default_bucket_acl = alicloud.oss.BucketAcl("default",
            bucket=bucket_policy.bucket,
            acl="private")
        ```

        IA Bucket

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        default_bucket = alicloud.oss.Bucket("default",
            bucket=f"example-{default['result']}",
            storage_class="IA")
        ```

        Set bucket server-side encryption rule

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_sserule = alicloud.oss.Bucket("bucket-sserule",
            bucket=f"terraform-example-{default['result']}",
            server_side_encryption_rule={
                "sse_algorithm": "AES256",
            })
        bucket_sserule_bucket_acl = alicloud.oss.BucketAcl("bucket-sserule",
            bucket=bucket_sserule.bucket,
            acl="private")
        kms = alicloud.kms.Key("kms",
            description="terraform-example",
            pending_window_in_days=7,
            status="Enabled")
        bucket_kms = alicloud.oss.Bucket("bucket-kms",
            bucket=f"terraform-example-kms-{default['result']}",
            server_side_encryption_rule={
                "sse_algorithm": "KMS",
                "kms_master_key_id": kms.id,
            })
        bucket_kms_bucket_acl = alicloud.oss.BucketAcl("bucket-kms",
            bucket=bucket_kms.bucket,
            acl="private")
        ```

        Set bucket tags

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_tags = alicloud.oss.Bucket("bucket-tags",
            bucket=f"terraform-example-{default['result']}",
            tags={
                "key1": "value1",
                "key2": "value2",
            })
        bucket_tags_bucket_acl = alicloud.oss.BucketAcl("bucket-tags",
            bucket=bucket_tags.bucket,
            acl="private")
        ```

        Enable bucket versioning

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_versioning = alicloud.oss.Bucket("bucket-versioning",
            bucket=f"terraform-example-{default['result']}",
            versioning={
                "status": "Enabled",
            })
        default_bucket_acl = alicloud.oss.BucketAcl("default",
            bucket=bucket_versioning.bucket,
            acl="private")
        ```

        Set bucket redundancy type

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_redundancytype = alicloud.oss.Bucket("bucket-redundancytype",
            bucket=f"terraform-example-{default['result']}",
            redundancy_type="ZRS")
        ```

        Set bucket accelerate configuration

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_accelerate = alicloud.oss.Bucket("bucket-accelerate",
            bucket=f"terraform-example-{default['result']}",
            transfer_acceleration={
                "enabled": False,
            })
        ```

        Set bucket resource group id

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default = alicloud.resourcemanager.get_resource_groups(name_regex="default")
        bucket_accelerate = alicloud.oss.Bucket("bucket-accelerate",
            bucket=f"terraform-example-{default_integer['result']}",
            resource_group_id=default.groups[0].id)
        ```

        ## Import

        OSS bucket can be imported using the bucket name, e.g.

        ```sh
        $ pulumi import alicloud:oss/bucket:Bucket bucket bucket-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BucketAccessMonitorArgs', 'BucketAccessMonitorArgsDict']] access_monitor: A access monitor status of a bucket. See `access_monitor` below.
        :param pulumi.Input[_builtins.str] acl: The [canned ACL](https://www.alibabacloud.com/help/doc-detail/31898.htm) to apply. Can be "private", "public-read" and "public-read-write". This property has been deprecated since 1.220.0, please use the resource `oss.BucketAcl` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketCorsRuleArgs', 'BucketCorsRuleArgsDict']]]] cors_rules: A rule of  [Cross-Origin Resource Sharing](https://www.alibabacloud.com/help/doc-detail/31903.htm). The items of core rule are no more than 10 for every OSS bucket. See `cors_rule` below.
        :param pulumi.Input[_builtins.bool] force_destroy: A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are not recoverable. Defaults to "false".
        :param pulumi.Input[_builtins.bool] lifecycle_rule_allow_same_action_overlap: A boolean that indicates lifecycle rules allow prefix overlap.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleRuleArgs', 'BucketLifecycleRuleArgsDict']]]] lifecycle_rules: A configuration of [object lifecycle management](https://www.alibabacloud.com/help/doc-detail/31904.htm). See `lifecycle_rule` below.
        :param pulumi.Input[Union['BucketLoggingArgs', 'BucketLoggingArgsDict']] logging: A Settings of [bucket logging](https://www.alibabacloud.com/help/doc-detail/31900.htm). See `logging` below.
        :param pulumi.Input[_builtins.bool] logging_isenable: The flag of using logging enable container. Defaults true.
        :param pulumi.Input[_builtins.str] policy: Json format text of bucket policy [bucket policy management](https://www.alibabacloud.com/help/doc-detail/100680.htm). This property has been deprecated since 1.220.0, please use the resource `oss.BucketPolicy` instead.
        :param pulumi.Input[_builtins.str] redundancy_type: The [redundancy type](https://www.alibabacloud.com/help/doc-detail/90589.htm) to enable. Can be "LRS", and "ZRS". Defaults to "LRS".
        :param pulumi.Input[Union['BucketRefererConfigArgs', 'BucketRefererConfigArgsDict']] referer_config: The configuration of [referer](https://www.alibabacloud.com/help/doc-detail/31901.htm). This property has been deprecated since 1.220.0, please use the resource `oss.BucketReferer` instead. See `referer_config` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the bucket belongs.
        :param pulumi.Input[Union['BucketServerSideEncryptionRuleArgs', 'BucketServerSideEncryptionRuleArgsDict']] server_side_encryption_rule: A configuration of server-side encryption. See `server_side_encryption_rule` below.
        :param pulumi.Input[_builtins.str] storage_class: The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the bucket. The items are no more than 10 for a bucket.
        :param pulumi.Input[Union['BucketTransferAccelerationArgs', 'BucketTransferAccelerationArgsDict']] transfer_acceleration: A transfer acceleration status of a bucket. See `transfer_acceleration` below.
        :param pulumi.Input[Union['BucketVersioningArgs', 'BucketVersioningArgsDict']] versioning: A state of versioning. See `versioning` below.
        :param pulumi.Input[Union['BucketWebsiteArgs', 'BucketWebsiteArgsDict']] website: A website configuration. See `website` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BucketArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create a oss bucket and set its attribution.

        > **NOTE:** The bucket namespace is shared by all users of the OSS system. Please set bucket name as unique as possible.

        > **NOTE:** Available since v1.2.0.

        ## Example Usage

        Private Bucket

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_acl = alicloud.oss.Bucket("bucket-acl", bucket=f"example-value-{default['result']}")
        bucket_acl_bucket_acl = alicloud.oss.BucketAcl("bucket-acl",
            bucket=bucket_acl.bucket,
            acl="private")
        ```

        Static Website

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_website = alicloud.oss.Bucket("bucket-website",
            bucket=f"example-value-{default['result']}",
            website={
                "index_document": "index.html",
                "error_document": "error.html",
            })
        ```

        Enable Logging

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_target = alicloud.oss.Bucket("bucket-target", bucket=f"example-value-{default['result']}")
        bucket_target_bucket_acl = alicloud.oss.BucketAcl("bucket-target",
            bucket=bucket_target.bucket,
            acl="public-read")
        bucket_logging = alicloud.oss.Bucket("bucket-logging",
            bucket=f"example-logging-{default['result']}",
            logging={
                "target_bucket": bucket_target.id,
                "target_prefix": "log/",
            })
        ```

        Referer configuration

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_referer = alicloud.oss.Bucket("bucket-referer",
            bucket=f"example-value-{default['result']}",
            referer_config={
                "allow_empty": False,
                "referers": [
                    "http://www.aliyun.com",
                    "https://www.aliyun.com",
                ],
            })
        default_bucket_acl = alicloud.oss.BucketAcl("default",
            bucket=bucket_referer.bucket,
            acl="private")
        ```

        Set lifecycle rule

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random
        import pulumi_std as std

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_lifecycle1 = alicloud.oss.Bucket("bucket-lifecycle1",
            bucket=f"example-lifecycle1-{default['result']}",
            lifecycle_rules=[
                {
                    "id": "rule-days",
                    "prefix": "path1/",
                    "enabled": True,
                    "expirations": [{
                        "days": 365,
                    }],
                },
                {
                    "id": "rule-date",
                    "prefix": "path2/",
                    "enabled": True,
                    "expirations": [{
                        "date": "2018-01-12",
                    }],
                },
            ])
        bucket_lifecycle1_bucket_acl = alicloud.oss.BucketAcl("bucket-lifecycle1",
            bucket=bucket_lifecycle1.bucket,
            acl="public-read")
        bucket_lifecycle2 = alicloud.oss.Bucket("bucket-lifecycle2",
            bucket=f"example-lifecycle2-{default['result']}",
            lifecycle_rules=[{
                "id": "rule-days-transition",
                "prefix": "path3/",
                "enabled": True,
                "transitions": [
                    {
                        "days": 3,
                        "storage_class": "IA",
                    },
                    {
                        "days": 30,
                        "storage_class": "Archive",
                    },
                ],
            }])
        bucket_lifecycle2_bucket_acl = alicloud.oss.BucketAcl("bucket-lifecycle2",
            bucket=bucket_lifecycle2.bucket,
            acl="public-read")
        bucket_lifecycle3 = alicloud.oss.Bucket("bucket-lifecycle3",
            bucket=f"example-lifecycle3-{default['result']}",
            lifecycle_rules=[{
                "id": "rule-days-transition",
                "prefix": "path3/",
                "enabled": True,
                "transitions": [
                    {
                        "created_before_date": "2022-11-11",
                        "storage_class": "IA",
                    },
                    {
                        "created_before_date": "2021-11-11",
                        "storage_class": "Archive",
                    },
                ],
            }])
        bucket_lifecycle3_bucket_acl = alicloud.oss.BucketAcl("bucket-lifecycle3",
            bucket=bucket_lifecycle3.bucket,
            acl="public-read")
        bucket_lifecycle4 = alicloud.oss.Bucket("bucket-lifecycle4",
            bucket=f"example-lifecycle4-{default['result']}",
            lifecycle_rules=[{
                "id": "rule-abort-multipart-upload",
                "prefix": "path3/",
                "enabled": True,
                "abort_multipart_uploads": [{
                    "days": 128,
                }],
            }])
        bucket_lifecycle4_bucket_acl = alicloud.oss.BucketAcl("bucket-lifecycle4",
            bucket=bucket_lifecycle4.bucket,
            acl="public-read")
        bucket_versioning_lifecycle = alicloud.oss.Bucket("bucket-versioning-lifecycle",
            bucket=f"example-lifecycle5-{default['result']}",
            versioning={
                "status": "Enabled",
            },
            lifecycle_rules=[{
                "id": "rule-versioning",
                "prefix": "path1/",
                "enabled": True,
                "expirations": [{
                    "expired_object_delete_marker": True,
                }],
                "noncurrent_version_expirations": [{
                    "days": 240,
                }],
                "noncurrent_version_transitions": [
                    {
                        "days": 180,
                        "storage_class": "Archive",
                    },
                    {
                        "days": 60,
                        "storage_class": "IA",
                    },
                ],
            }])
        bucket_versioning_lifecycle_bucket_acl = alicloud.oss.BucketAcl("bucket-versioning-lifecycle",
            bucket=bucket_versioning_lifecycle.bucket,
            acl="private")
        bucket_access_monitor_lifecycle = alicloud.oss.Bucket("bucket-access-monitor-lifecycle",
            bucket=std.format(input="example-lifecycle6-%s",
                args=[default["result"]]).result,
            access_monitor={
                "status": "Enabled",
            },
            lifecycle_rules=[{
                "id": "rule-days-transition",
                "prefix": "path/",
                "enabled": True,
                "transitions": [{
                    "days": 30,
                    "storage_class": "IA",
                    "is_access_time": True,
                    "return_to_std_when_visit": True,
                }],
            }])
        bucket_access_monitor_lifecycle_bucket_acl = alicloud.oss.BucketAcl("bucket-access-monitor-lifecycle",
            bucket=bucket_access_monitor_lifecycle.bucket,
            acl="private")
        bucket_tag_lifecycle = alicloud.oss.Bucket("bucket-tag-lifecycle",
            bucket=std.format(input="example-lifecycle7-%s",
                args=[default["result"]]).result,
            lifecycle_rules=[{
                "id": "rule-days-transition",
                "prefix": "path/",
                "enabled": True,
                "transitions": [{
                    "created_before_date": "2022-11-11",
                    "storage_class": "IA",
                }],
            }],
            tags={
                "Created": "TF",
                "For": "example",
            })
        bucket_tag_lifecycle_bucket_acl = alicloud.oss.BucketAcl("bucket-tag-lifecycle",
            bucket=bucket_tag_lifecycle.bucket,
            acl="private")
        ```

        Set bucket policy

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_policy = alicloud.oss.Bucket("bucket-policy",
            bucket=f"example-policy-{default['result']}",
            policy=\"\"\"  {\\"Statement\\":
              [{\\"Action\\":
                  [\\"oss:PutObject\\", \\"oss:GetObject\\", \\"oss:DeleteBucket\\"],
                \\"Effect\\":\\"Allow\\",
                \\"Resource\\":
                    [\\"acs:oss:*:*:*\\"]}],
           \\"Version\\":\\"1\\"}
        \"\"\")
        default_bucket_acl = alicloud.oss.BucketAcl("default",
            bucket=bucket_policy.bucket,
            acl="private")
        ```

        IA Bucket

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        default_bucket = alicloud.oss.Bucket("default",
            bucket=f"example-{default['result']}",
            storage_class="IA")
        ```

        Set bucket server-side encryption rule

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_sserule = alicloud.oss.Bucket("bucket-sserule",
            bucket=f"terraform-example-{default['result']}",
            server_side_encryption_rule={
                "sse_algorithm": "AES256",
            })
        bucket_sserule_bucket_acl = alicloud.oss.BucketAcl("bucket-sserule",
            bucket=bucket_sserule.bucket,
            acl="private")
        kms = alicloud.kms.Key("kms",
            description="terraform-example",
            pending_window_in_days=7,
            status="Enabled")
        bucket_kms = alicloud.oss.Bucket("bucket-kms",
            bucket=f"terraform-example-kms-{default['result']}",
            server_side_encryption_rule={
                "sse_algorithm": "KMS",
                "kms_master_key_id": kms.id,
            })
        bucket_kms_bucket_acl = alicloud.oss.BucketAcl("bucket-kms",
            bucket=bucket_kms.bucket,
            acl="private")
        ```

        Set bucket tags

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_tags = alicloud.oss.Bucket("bucket-tags",
            bucket=f"terraform-example-{default['result']}",
            tags={
                "key1": "value1",
                "key2": "value2",
            })
        bucket_tags_bucket_acl = alicloud.oss.BucketAcl("bucket-tags",
            bucket=bucket_tags.bucket,
            acl="private")
        ```

        Enable bucket versioning

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_versioning = alicloud.oss.Bucket("bucket-versioning",
            bucket=f"terraform-example-{default['result']}",
            versioning={
                "status": "Enabled",
            })
        default_bucket_acl = alicloud.oss.BucketAcl("default",
            bucket=bucket_versioning.bucket,
            acl="private")
        ```

        Set bucket redundancy type

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_redundancytype = alicloud.oss.Bucket("bucket-redundancytype",
            bucket=f"terraform-example-{default['result']}",
            redundancy_type="ZRS")
        ```

        Set bucket accelerate configuration

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        bucket_accelerate = alicloud.oss.Bucket("bucket-accelerate",
            bucket=f"terraform-example-{default['result']}",
            transfer_acceleration={
                "enabled": False,
            })
        ```

        Set bucket resource group id

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default = alicloud.resourcemanager.get_resource_groups(name_regex="default")
        bucket_accelerate = alicloud.oss.Bucket("bucket-accelerate",
            bucket=f"terraform-example-{default_integer['result']}",
            resource_group_id=default.groups[0].id)
        ```

        ## Import

        OSS bucket can be imported using the bucket name, e.g.

        ```sh
        $ pulumi import alicloud:oss/bucket:Bucket bucket bucket-12345678
        ```

        :param str resource_name: The name of the resource.
        :param BucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_monitor: Optional[pulumi.Input[Union['BucketAccessMonitorArgs', 'BucketAccessMonitorArgsDict']]] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketCorsRuleArgs', 'BucketCorsRuleArgsDict']]]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_rule_allow_same_action_overlap: Optional[pulumi.Input[_builtins.bool]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleRuleArgs', 'BucketLifecycleRuleArgsDict']]]]] = None,
                 logging: Optional[pulumi.Input[Union['BucketLoggingArgs', 'BucketLoggingArgsDict']]] = None,
                 logging_isenable: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 redundancy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 referer_config: Optional[pulumi.Input[Union['BucketRefererConfigArgs', 'BucketRefererConfigArgsDict']]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption_rule: Optional[pulumi.Input[Union['BucketServerSideEncryptionRuleArgs', 'BucketServerSideEncryptionRuleArgsDict']]] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transfer_acceleration: Optional[pulumi.Input[Union['BucketTransferAccelerationArgs', 'BucketTransferAccelerationArgsDict']]] = None,
                 versioning: Optional[pulumi.Input[Union['BucketVersioningArgs', 'BucketVersioningArgsDict']]] = None,
                 website: Optional[pulumi.Input[Union['BucketWebsiteArgs', 'BucketWebsiteArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketArgs.__new__(BucketArgs)

            __props__.__dict__["access_monitor"] = access_monitor
            __props__.__dict__["acl"] = acl
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["cors_rules"] = cors_rules
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["lifecycle_rule_allow_same_action_overlap"] = lifecycle_rule_allow_same_action_overlap
            __props__.__dict__["lifecycle_rules"] = lifecycle_rules
            __props__.__dict__["logging"] = logging
            __props__.__dict__["logging_isenable"] = logging_isenable
            __props__.__dict__["policy"] = policy
            __props__.__dict__["redundancy_type"] = redundancy_type
            __props__.__dict__["referer_config"] = referer_config
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["server_side_encryption_rule"] = server_side_encryption_rule
            __props__.__dict__["storage_class"] = storage_class
            __props__.__dict__["tags"] = tags
            __props__.__dict__["transfer_acceleration"] = transfer_acceleration
            __props__.__dict__["versioning"] = versioning
            __props__.__dict__["website"] = website
            __props__.__dict__["creation_date"] = None
            __props__.__dict__["extranet_endpoint"] = None
            __props__.__dict__["intranet_endpoint"] = None
            __props__.__dict__["location"] = None
            __props__.__dict__["owner"] = None
        super(Bucket, __self__).__init__(
            'alicloud:oss/bucket:Bucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_monitor: Optional[pulumi.Input[Union['BucketAccessMonitorArgs', 'BucketAccessMonitorArgsDict']]] = None,
            acl: Optional[pulumi.Input[_builtins.str]] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketCorsRuleArgs', 'BucketCorsRuleArgsDict']]]]] = None,
            creation_date: Optional[pulumi.Input[_builtins.str]] = None,
            extranet_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            intranet_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_rule_allow_same_action_overlap: Optional[pulumi.Input[_builtins.bool]] = None,
            lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleRuleArgs', 'BucketLifecycleRuleArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            logging: Optional[pulumi.Input[Union['BucketLoggingArgs', 'BucketLoggingArgsDict']]] = None,
            logging_isenable: Optional[pulumi.Input[_builtins.bool]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            policy: Optional[pulumi.Input[_builtins.str]] = None,
            redundancy_type: Optional[pulumi.Input[_builtins.str]] = None,
            referer_config: Optional[pulumi.Input[Union['BucketRefererConfigArgs', 'BucketRefererConfigArgsDict']]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            server_side_encryption_rule: Optional[pulumi.Input[Union['BucketServerSideEncryptionRuleArgs', 'BucketServerSideEncryptionRuleArgsDict']]] = None,
            storage_class: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            transfer_acceleration: Optional[pulumi.Input[Union['BucketTransferAccelerationArgs', 'BucketTransferAccelerationArgsDict']]] = None,
            versioning: Optional[pulumi.Input[Union['BucketVersioningArgs', 'BucketVersioningArgsDict']]] = None,
            website: Optional[pulumi.Input[Union['BucketWebsiteArgs', 'BucketWebsiteArgsDict']]] = None) -> 'Bucket':
        """
        Get an existing Bucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BucketAccessMonitorArgs', 'BucketAccessMonitorArgsDict']] access_monitor: A access monitor status of a bucket. See `access_monitor` below.
        :param pulumi.Input[_builtins.str] acl: The [canned ACL](https://www.alibabacloud.com/help/doc-detail/31898.htm) to apply. Can be "private", "public-read" and "public-read-write". This property has been deprecated since 1.220.0, please use the resource `oss.BucketAcl` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketCorsRuleArgs', 'BucketCorsRuleArgsDict']]]] cors_rules: A rule of  [Cross-Origin Resource Sharing](https://www.alibabacloud.com/help/doc-detail/31903.htm). The items of core rule are no more than 10 for every OSS bucket. See `cors_rule` below.
        :param pulumi.Input[_builtins.str] creation_date: The creation date of the bucket.
        :param pulumi.Input[_builtins.str] extranet_endpoint: The extranet access endpoint of the bucket.
        :param pulumi.Input[_builtins.bool] force_destroy: A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are not recoverable. Defaults to "false".
        :param pulumi.Input[_builtins.str] intranet_endpoint: The intranet access endpoint of the bucket.
        :param pulumi.Input[_builtins.bool] lifecycle_rule_allow_same_action_overlap: A boolean that indicates lifecycle rules allow prefix overlap.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleRuleArgs', 'BucketLifecycleRuleArgsDict']]]] lifecycle_rules: A configuration of [object lifecycle management](https://www.alibabacloud.com/help/doc-detail/31904.htm). See `lifecycle_rule` below.
        :param pulumi.Input[_builtins.str] location: The location of the bucket.
        :param pulumi.Input[Union['BucketLoggingArgs', 'BucketLoggingArgsDict']] logging: A Settings of [bucket logging](https://www.alibabacloud.com/help/doc-detail/31900.htm). See `logging` below.
        :param pulumi.Input[_builtins.bool] logging_isenable: The flag of using logging enable container. Defaults true.
        :param pulumi.Input[_builtins.str] owner: The bucket owner.
        :param pulumi.Input[_builtins.str] policy: Json format text of bucket policy [bucket policy management](https://www.alibabacloud.com/help/doc-detail/100680.htm). This property has been deprecated since 1.220.0, please use the resource `oss.BucketPolicy` instead.
        :param pulumi.Input[_builtins.str] redundancy_type: The [redundancy type](https://www.alibabacloud.com/help/doc-detail/90589.htm) to enable. Can be "LRS", and "ZRS". Defaults to "LRS".
        :param pulumi.Input[Union['BucketRefererConfigArgs', 'BucketRefererConfigArgsDict']] referer_config: The configuration of [referer](https://www.alibabacloud.com/help/doc-detail/31901.htm). This property has been deprecated since 1.220.0, please use the resource `oss.BucketReferer` instead. See `referer_config` below.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the bucket belongs.
        :param pulumi.Input[Union['BucketServerSideEncryptionRuleArgs', 'BucketServerSideEncryptionRuleArgsDict']] server_side_encryption_rule: A configuration of server-side encryption. See `server_side_encryption_rule` below.
        :param pulumi.Input[_builtins.str] storage_class: The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the bucket. The items are no more than 10 for a bucket.
        :param pulumi.Input[Union['BucketTransferAccelerationArgs', 'BucketTransferAccelerationArgsDict']] transfer_acceleration: A transfer acceleration status of a bucket. See `transfer_acceleration` below.
        :param pulumi.Input[Union['BucketVersioningArgs', 'BucketVersioningArgsDict']] versioning: A state of versioning. See `versioning` below.
        :param pulumi.Input[Union['BucketWebsiteArgs', 'BucketWebsiteArgsDict']] website: A website configuration. See `website` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketState.__new__(_BucketState)

        __props__.__dict__["access_monitor"] = access_monitor
        __props__.__dict__["acl"] = acl
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["cors_rules"] = cors_rules
        __props__.__dict__["creation_date"] = creation_date
        __props__.__dict__["extranet_endpoint"] = extranet_endpoint
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["intranet_endpoint"] = intranet_endpoint
        __props__.__dict__["lifecycle_rule_allow_same_action_overlap"] = lifecycle_rule_allow_same_action_overlap
        __props__.__dict__["lifecycle_rules"] = lifecycle_rules
        __props__.__dict__["location"] = location
        __props__.__dict__["logging"] = logging
        __props__.__dict__["logging_isenable"] = logging_isenable
        __props__.__dict__["owner"] = owner
        __props__.__dict__["policy"] = policy
        __props__.__dict__["redundancy_type"] = redundancy_type
        __props__.__dict__["referer_config"] = referer_config
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["server_side_encryption_rule"] = server_side_encryption_rule
        __props__.__dict__["storage_class"] = storage_class
        __props__.__dict__["tags"] = tags
        __props__.__dict__["transfer_acceleration"] = transfer_acceleration
        __props__.__dict__["versioning"] = versioning
        __props__.__dict__["website"] = website
        return Bucket(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessMonitor")
    def access_monitor(self) -> pulumi.Output['outputs.BucketAccessMonitor']:
        """
        A access monitor status of a bucket. See `access_monitor` below.
        """
        return pulumi.get(self, "access_monitor")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'acl' has been deprecated since provider version 1.220.0. New resource 'alicloud_oss_bucket_acl' instead.""")
    def acl(self) -> pulumi.Output[_builtins.str]:
        """
        The [canned ACL](https://www.alibabacloud.com/help/doc-detail/31898.htm) to apply. Can be "private", "public-read" and "public-read-write". This property has been deprecated since 1.220.0, please use the resource `oss.BucketAcl` instead.
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> pulumi.Output[Optional[Sequence['outputs.BucketCorsRule']]]:
        """
        A rule of  [Cross-Origin Resource Sharing](https://www.alibabacloud.com/help/doc-detail/31903.htm). The items of core rule are no more than 10 for every OSS bucket. See `cors_rule` below.
        """
        return pulumi.get(self, "cors_rules")

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[_builtins.str]:
        """
        The creation date of the bucket.
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter(name="extranetEndpoint")
    def extranet_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The extranet access endpoint of the bucket.
        """
        return pulumi.get(self, "extranet_endpoint")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are not recoverable. Defaults to "false".
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter(name="intranetEndpoint")
    def intranet_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The intranet access endpoint of the bucket.
        """
        return pulumi.get(self, "intranet_endpoint")

    @_builtins.property
    @pulumi.getter(name="lifecycleRuleAllowSameActionOverlap")
    def lifecycle_rule_allow_same_action_overlap(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A boolean that indicates lifecycle rules allow prefix overlap.
        """
        return pulumi.get(self, "lifecycle_rule_allow_same_action_overlap")

    @_builtins.property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> pulumi.Output[Optional[Sequence['outputs.BucketLifecycleRule']]]:
        """
        A configuration of [object lifecycle management](https://www.alibabacloud.com/help/doc-detail/31904.htm). See `lifecycle_rule` below.
        """
        return pulumi.get(self, "lifecycle_rules")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the bucket.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def logging(self) -> pulumi.Output[Optional['outputs.BucketLogging']]:
        """
        A Settings of [bucket logging](https://www.alibabacloud.com/help/doc-detail/31900.htm). See `logging` below.
        """
        return pulumi.get(self, "logging")

    @_builtins.property
    @pulumi.getter(name="loggingIsenable")
    @_utilities.deprecated("""Deprecated from 1.37.0. When `logging` is set, the bucket logging will be able.""")
    def logging_isenable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The flag of using logging enable container. Defaults true.
        """
        return pulumi.get(self, "logging_isenable")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        The bucket owner.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Json format text of bucket policy [bucket policy management](https://www.alibabacloud.com/help/doc-detail/100680.htm). This property has been deprecated since 1.220.0, please use the resource `oss.BucketPolicy` instead.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="redundancyType")
    def redundancy_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The [redundancy type](https://www.alibabacloud.com/help/doc-detail/90589.htm) to enable. Can be "LRS", and "ZRS". Defaults to "LRS".
        """
        return pulumi.get(self, "redundancy_type")

    @_builtins.property
    @pulumi.getter(name="refererConfig")
    def referer_config(self) -> pulumi.Output[Optional['outputs.BucketRefererConfig']]:
        """
        The configuration of [referer](https://www.alibabacloud.com/help/doc-detail/31901.htm). This property has been deprecated since 1.220.0, please use the resource `oss.BucketReferer` instead. See `referer_config` below.
        """
        return pulumi.get(self, "referer_config")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group to which the bucket belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryptionRule")
    def server_side_encryption_rule(self) -> pulumi.Output[Optional['outputs.BucketServerSideEncryptionRule']]:
        """
        A configuration of server-side encryption. See `server_side_encryption_rule` below.
        """
        return pulumi.get(self, "server_side_encryption_rule")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The [storage class](https://www.alibabacloud.com/help/doc-detail/51374.htm) to apply. Can be "Standard", "IA", "Archive", "ColdArchive" and "DeepColdArchive". Defaults to "Standard". "ColdArchive" is available since 1.203.0. "DeepColdArchive" is available since 1.209.0.
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the bucket. The items are no more than 10 for a bucket.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transferAcceleration")
    def transfer_acceleration(self) -> pulumi.Output[Optional['outputs.BucketTransferAcceleration']]:
        """
        A transfer acceleration status of a bucket. See `transfer_acceleration` below.
        """
        return pulumi.get(self, "transfer_acceleration")

    @_builtins.property
    @pulumi.getter
    def versioning(self) -> pulumi.Output[Optional['outputs.BucketVersioning']]:
        """
        A state of versioning. See `versioning` below.
        """
        return pulumi.get(self, "versioning")

    @_builtins.property
    @pulumi.getter
    def website(self) -> pulumi.Output[Optional['outputs.BucketWebsite']]:
        """
        A website configuration. See `website` below.
        """
        return pulumi.get(self, "website")

