# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceDatasetArgs', 'WorkspaceDataset']

@pulumi.input_type
class WorkspaceDatasetArgs:
    def __init__(__self__, *,
                 data_source_type: pulumi.Input[_builtins.str],
                 dataset_name: pulumi.Input[_builtins.str],
                 property: pulumi.Input[_builtins.str],
                 uri: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str],
                 accessibility: Optional[pulumi.Input[_builtins.str]] = None,
                 data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDatasetLabelArgs']]]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceDataset resource.
        :param pulumi.Input[_builtins.str] data_source_type: The data source type. The following values are supported:
               - OSS: Alibaba Cloud Object Storage (OSS).
               - NAS: Alibaba cloud file storage (NAS).
        :param pulumi.Input[_builtins.str] dataset_name: The name of the dataset. The naming rules are as follows:
               - Start with a lowercase letter, uppercase letter, number, or Chinese.
               - Can contain an underscore (_) or a dash (-).
               - 1~127 characters in length.
        :param pulumi.Input[_builtins.str] property: The properties of the dataset. The following values are supported:
               - FILE: FILE.
               - DIRECTORY: folder.
        :param pulumi.Input[_builtins.str] uri: The Uri configuration sample is as follows:
               - The data source type is OSS:'oss:// bucket.endpoint/object'
               - The data source type is NAS:
               
               The general NAS format is: 'nas://.region/subpath/to/dir/';
               
               CPFS1.0:'nas://.region/subpath/to/dir /';
               
               CPFS2.0:'nas://.region//'.
               
               CPFS1.0 and CPFS2.0 are distinguished by the format of fsid: CPFS1.0 is cpfs-;CPFS2.0 is cpfs-.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace where the dataset is located. For details about how to obtain the workspace ID, see ListWorkspaces.
               
               If this parameter is not configured, the default workspace is used. If the default workspace does not exist, an error is reported.
        :param pulumi.Input[_builtins.str] accessibility: Workspace visibility. The following values are supported:
               - PRIVATE (default): indicates that the workspace is visible to itself and the administrator.
               - PUBLIC: The workspace is visible to all users.
        :param pulumi.Input[_builtins.str] data_type: The dataset type. The default value is COMMON. The following values are supported:
               - COMMON: COMMON.
               - PIC: picture.
               - TEXT: TEXT.
               - VIDEO: VIDEO.
               - AUDIO: AUDIO.
        :param pulumi.Input[_builtins.str] description: Custom descriptions of datasets to distinguish between different datasets.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceDatasetLabelArgs']]] labels: Labels added to the dataset See `labels` below.
        :param pulumi.Input[_builtins.str] options: The extended field, which is of the JsonString type.
               
               When DLC uses a dataset, you can specify the default Mount path for the dataset by configuring the mountPath field.
        :param pulumi.Input[_builtins.str] source_id: The data source ID.
               - When the SourceType is USER, SourceId can be customized.
               - When SourceType is ITAG, that is, when the iTAG module labels the data set generated by the result, SourceId is the task ID of ITAG.
               - When SourceType is PAI_PUBLIC_DATASET, that is, a dataset created using PAI public datasets, SourceId is empty by default.
        :param pulumi.Input[_builtins.str] source_type: The data source type. The default value is USER. The following values are supported:
               - PAI-PUBLIC-DATASET:PAI public dataset.
               - ITAG: The dataset generated by the iTAG module annotation result.
               - USER: The data set registered by the USER.
        :param pulumi.Input[_builtins.str] user_id: The ID of the dataset owner.
        """
        pulumi.set(__self__, "data_source_type", data_source_type)
        pulumi.set(__self__, "dataset_name", dataset_name)
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if accessibility is not None:
            pulumi.set(__self__, "accessibility", accessibility)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> pulumi.Input[_builtins.str]:
        """
        The data source type. The following values are supported:
        - OSS: Alibaba Cloud Object Storage (OSS).
        - NAS: Alibaba cloud file storage (NAS).
        """
        return pulumi.get(self, "data_source_type")

    @data_source_type.setter
    def data_source_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_source_type", value)

    @_builtins.property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the dataset. The naming rules are as follows:
        - Start with a lowercase letter, uppercase letter, number, or Chinese.
        - Can contain an underscore (_) or a dash (-).
        - 1~127 characters in length.
        """
        return pulumi.get(self, "dataset_name")

    @dataset_name.setter
    def dataset_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dataset_name", value)

    @_builtins.property
    @pulumi.getter
    def property(self) -> pulumi.Input[_builtins.str]:
        """
        The properties of the dataset. The following values are supported:
        - FILE: FILE.
        - DIRECTORY: folder.
        """
        return pulumi.get(self, "property")

    @property.setter
    def property(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "property", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Input[_builtins.str]:
        """
        The Uri configuration sample is as follows:
        - The data source type is OSS:'oss:// bucket.endpoint/object'
        - The data source type is NAS:

        The general NAS format is: 'nas://.region/subpath/to/dir/';

        CPFS1.0:'nas://.region/subpath/to/dir /';

        CPFS2.0:'nas://.region//'.

        CPFS1.0 and CPFS2.0 are distinguished by the format of fsid: CPFS1.0 is cpfs-;CPFS2.0 is cpfs-.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "uri", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the workspace where the dataset is located. For details about how to obtain the workspace ID, see ListWorkspaces.

        If this parameter is not configured, the default workspace is used. If the default workspace does not exist, an error is reported.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def accessibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace visibility. The following values are supported:
        - PRIVATE (default): indicates that the workspace is visible to itself and the administrator.
        - PUBLIC: The workspace is visible to all users.
        """
        return pulumi.get(self, "accessibility")

    @accessibility.setter
    def accessibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility", value)

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dataset type. The default value is COMMON. The following values are supported:
        - COMMON: COMMON.
        - PIC: picture.
        - TEXT: TEXT.
        - VIDEO: VIDEO.
        - AUDIO: AUDIO.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom descriptions of datasets to distinguish between different datasets.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDatasetLabelArgs']]]]:
        """
        Labels added to the dataset See `labels` below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDatasetLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The extended field, which is of the JsonString type.

        When DLC uses a dataset, you can specify the default Mount path for the dataset by configuring the mountPath field.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source ID.
        - When the SourceType is USER, SourceId can be customized.
        - When SourceType is ITAG, that is, when the iTAG module labels the data set generated by the result, SourceId is the task ID of ITAG.
        - When SourceType is PAI_PUBLIC_DATASET, that is, a dataset created using PAI public datasets, SourceId is empty by default.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source type. The default value is USER. The following values are supported:
        - PAI-PUBLIC-DATASET:PAI public dataset.
        - ITAG: The dataset generated by the iTAG module annotation result.
        - USER: The data set registered by the USER.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dataset owner.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _WorkspaceDatasetState:
    def __init__(__self__, *,
                 accessibility: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDatasetLabelArgs']]]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 property: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceDataset resources.
        :param pulumi.Input[_builtins.str] accessibility: Workspace visibility. The following values are supported:
               - PRIVATE (default): indicates that the workspace is visible to itself and the administrator.
               - PUBLIC: The workspace is visible to all users.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] data_source_type: The data source type. The following values are supported:
               - OSS: Alibaba Cloud Object Storage (OSS).
               - NAS: Alibaba cloud file storage (NAS).
        :param pulumi.Input[_builtins.str] data_type: The dataset type. The default value is COMMON. The following values are supported:
               - COMMON: COMMON.
               - PIC: picture.
               - TEXT: TEXT.
               - VIDEO: VIDEO.
               - AUDIO: AUDIO.
        :param pulumi.Input[_builtins.str] dataset_name: The name of the dataset. The naming rules are as follows:
               - Start with a lowercase letter, uppercase letter, number, or Chinese.
               - Can contain an underscore (_) or a dash (-).
               - 1~127 characters in length.
        :param pulumi.Input[_builtins.str] description: Custom descriptions of datasets to distinguish between different datasets.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceDatasetLabelArgs']]] labels: Labels added to the dataset See `labels` below.
        :param pulumi.Input[_builtins.str] options: The extended field, which is of the JsonString type.
               
               When DLC uses a dataset, you can specify the default Mount path for the dataset by configuring the mountPath field.
        :param pulumi.Input[_builtins.str] property: The properties of the dataset. The following values are supported:
               - FILE: FILE.
               - DIRECTORY: folder.
        :param pulumi.Input[_builtins.str] source_id: The data source ID.
               - When the SourceType is USER, SourceId can be customized.
               - When SourceType is ITAG, that is, when the iTAG module labels the data set generated by the result, SourceId is the task ID of ITAG.
               - When SourceType is PAI_PUBLIC_DATASET, that is, a dataset created using PAI public datasets, SourceId is empty by default.
        :param pulumi.Input[_builtins.str] source_type: The data source type. The default value is USER. The following values are supported:
               - PAI-PUBLIC-DATASET:PAI public dataset.
               - ITAG: The dataset generated by the iTAG module annotation result.
               - USER: The data set registered by the USER.
        :param pulumi.Input[_builtins.str] uri: The Uri configuration sample is as follows:
               - The data source type is OSS:'oss:// bucket.endpoint/object'
               - The data source type is NAS:
               
               The general NAS format is: 'nas://.region/subpath/to/dir/';
               
               CPFS1.0:'nas://.region/subpath/to/dir /';
               
               CPFS2.0:'nas://.region//'.
               
               CPFS1.0 and CPFS2.0 are distinguished by the format of fsid: CPFS1.0 is cpfs-;CPFS2.0 is cpfs-.
        :param pulumi.Input[_builtins.str] user_id: The ID of the dataset owner.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace where the dataset is located. For details about how to obtain the workspace ID, see ListWorkspaces.
               
               If this parameter is not configured, the default workspace is used. If the default workspace does not exist, an error is reported.
        """
        if accessibility is not None:
            pulumi.set(__self__, "accessibility", accessibility)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_source_type is not None:
            pulumi.set(__self__, "data_source_type", data_source_type)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if dataset_name is not None:
            pulumi.set(__self__, "dataset_name", dataset_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if property is not None:
            pulumi.set(__self__, "property", property)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def accessibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace visibility. The following values are supported:
        - PRIVATE (default): indicates that the workspace is visible to itself and the administrator.
        - PUBLIC: The workspace is visible to all users.
        """
        return pulumi.get(self, "accessibility")

    @accessibility.setter
    def accessibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source type. The following values are supported:
        - OSS: Alibaba Cloud Object Storage (OSS).
        - NAS: Alibaba cloud file storage (NAS).
        """
        return pulumi.get(self, "data_source_type")

    @data_source_type.setter
    def data_source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_type", value)

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dataset type. The default value is COMMON. The following values are supported:
        - COMMON: COMMON.
        - PIC: picture.
        - TEXT: TEXT.
        - VIDEO: VIDEO.
        - AUDIO: AUDIO.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_type", value)

    @_builtins.property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the dataset. The naming rules are as follows:
        - Start with a lowercase letter, uppercase letter, number, or Chinese.
        - Can contain an underscore (_) or a dash (-).
        - 1~127 characters in length.
        """
        return pulumi.get(self, "dataset_name")

    @dataset_name.setter
    def dataset_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom descriptions of datasets to distinguish between different datasets.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDatasetLabelArgs']]]]:
        """
        Labels added to the dataset See `labels` below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceDatasetLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The extended field, which is of the JsonString type.

        When DLC uses a dataset, you can specify the default Mount path for the dataset by configuring the mountPath field.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def property(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The properties of the dataset. The following values are supported:
        - FILE: FILE.
        - DIRECTORY: folder.
        """
        return pulumi.get(self, "property")

    @property.setter
    def property(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "property", value)

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source ID.
        - When the SourceType is USER, SourceId can be customized.
        - When SourceType is ITAG, that is, when the iTAG module labels the data set generated by the result, SourceId is the task ID of ITAG.
        - When SourceType is PAI_PUBLIC_DATASET, that is, a dataset created using PAI public datasets, SourceId is empty by default.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data source type. The default value is USER. The following values are supported:
        - PAI-PUBLIC-DATASET:PAI public dataset.
        - ITAG: The dataset generated by the iTAG module annotation result.
        - USER: The data set registered by the USER.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Uri configuration sample is as follows:
        - The data source type is OSS:'oss:// bucket.endpoint/object'
        - The data source type is NAS:

        The general NAS format is: 'nas://.region/subpath/to/dir/';

        CPFS1.0:'nas://.region/subpath/to/dir /';

        CPFS2.0:'nas://.region//'.

        CPFS1.0 and CPFS2.0 are distinguished by the format of fsid: CPFS1.0 is cpfs-;CPFS2.0 is cpfs-.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dataset owner.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the workspace where the dataset is located. For details about how to obtain the workspace ID, see ListWorkspaces.

        If this parameter is not configured, the default workspace is used. If the default workspace does not exist, an error is reported.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("alicloud:pai/workspaceDataset:WorkspaceDataset")
class WorkspaceDataset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceDatasetLabelArgs', 'WorkspaceDatasetLabelArgsDict']]]]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 property: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a PAI Workspace Dataset resource.

        For information about PAI Workspace Dataset and how to use it, see [What is Dataset](https://next.api.alibabacloud.com/document/AIWorkSpace/2021-02-04/CreateDataset).

        > **NOTE:** Available since v1.236.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default_workspace = alicloud.pai.WorkspaceWorkspace("defaultWorkspace",
            description=name,
            display_name=name,
            workspace_name=name,
            env_types=["prod"])
        default = alicloud.pai.WorkspaceDataset("default",
            options=json.dumps({
                "mountPath": "/mnt/data/",
            }),
            description=name,
            accessibility="PRIVATE",
            dataset_name=name,
            data_source_type="NAS",
            source_type="ITAG",
            workspace_id=default_workspace.id,
            data_type="PIC",
            property="DIRECTORY",
            uri="nas://086b649545.cn-hangzhou/",
            source_id="d-xxxxx_v1",
            user_id="1511928242963727")
        ```

        ## Import

        PAI Workspace Dataset can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/workspaceDataset:WorkspaceDataset example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessibility: Workspace visibility. The following values are supported:
               - PRIVATE (default): indicates that the workspace is visible to itself and the administrator.
               - PUBLIC: The workspace is visible to all users.
        :param pulumi.Input[_builtins.str] data_source_type: The data source type. The following values are supported:
               - OSS: Alibaba Cloud Object Storage (OSS).
               - NAS: Alibaba cloud file storage (NAS).
        :param pulumi.Input[_builtins.str] data_type: The dataset type. The default value is COMMON. The following values are supported:
               - COMMON: COMMON.
               - PIC: picture.
               - TEXT: TEXT.
               - VIDEO: VIDEO.
               - AUDIO: AUDIO.
        :param pulumi.Input[_builtins.str] dataset_name: The name of the dataset. The naming rules are as follows:
               - Start with a lowercase letter, uppercase letter, number, or Chinese.
               - Can contain an underscore (_) or a dash (-).
               - 1~127 characters in length.
        :param pulumi.Input[_builtins.str] description: Custom descriptions of datasets to distinguish between different datasets.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceDatasetLabelArgs', 'WorkspaceDatasetLabelArgsDict']]]] labels: Labels added to the dataset See `labels` below.
        :param pulumi.Input[_builtins.str] options: The extended field, which is of the JsonString type.
               
               When DLC uses a dataset, you can specify the default Mount path for the dataset by configuring the mountPath field.
        :param pulumi.Input[_builtins.str] property: The properties of the dataset. The following values are supported:
               - FILE: FILE.
               - DIRECTORY: folder.
        :param pulumi.Input[_builtins.str] source_id: The data source ID.
               - When the SourceType is USER, SourceId can be customized.
               - When SourceType is ITAG, that is, when the iTAG module labels the data set generated by the result, SourceId is the task ID of ITAG.
               - When SourceType is PAI_PUBLIC_DATASET, that is, a dataset created using PAI public datasets, SourceId is empty by default.
        :param pulumi.Input[_builtins.str] source_type: The data source type. The default value is USER. The following values are supported:
               - PAI-PUBLIC-DATASET:PAI public dataset.
               - ITAG: The dataset generated by the iTAG module annotation result.
               - USER: The data set registered by the USER.
        :param pulumi.Input[_builtins.str] uri: The Uri configuration sample is as follows:
               - The data source type is OSS:'oss:// bucket.endpoint/object'
               - The data source type is NAS:
               
               The general NAS format is: 'nas://.region/subpath/to/dir/';
               
               CPFS1.0:'nas://.region/subpath/to/dir /';
               
               CPFS2.0:'nas://.region//'.
               
               CPFS1.0 and CPFS2.0 are distinguished by the format of fsid: CPFS1.0 is cpfs-;CPFS2.0 is cpfs-.
        :param pulumi.Input[_builtins.str] user_id: The ID of the dataset owner.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace where the dataset is located. For details about how to obtain the workspace ID, see ListWorkspaces.
               
               If this parameter is not configured, the default workspace is used. If the default workspace does not exist, an error is reported.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceDatasetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a PAI Workspace Dataset resource.

        For information about PAI Workspace Dataset and how to use it, see [What is Dataset](https://next.api.alibabacloud.com/document/AIWorkSpace/2021-02-04/CreateDataset).

        > **NOTE:** Available since v1.236.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default_workspace = alicloud.pai.WorkspaceWorkspace("defaultWorkspace",
            description=name,
            display_name=name,
            workspace_name=name,
            env_types=["prod"])
        default = alicloud.pai.WorkspaceDataset("default",
            options=json.dumps({
                "mountPath": "/mnt/data/",
            }),
            description=name,
            accessibility="PRIVATE",
            dataset_name=name,
            data_source_type="NAS",
            source_type="ITAG",
            workspace_id=default_workspace.id,
            data_type="PIC",
            property="DIRECTORY",
            uri="nas://086b649545.cn-hangzhou/",
            source_id="d-xxxxx_v1",
            user_id="1511928242963727")
        ```

        ## Import

        PAI Workspace Dataset can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:pai/workspaceDataset:WorkspaceDataset example <id>
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceDatasetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceDatasetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility: Optional[pulumi.Input[_builtins.str]] = None,
                 data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceDatasetLabelArgs', 'WorkspaceDatasetLabelArgsDict']]]]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 property: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceDatasetArgs.__new__(WorkspaceDatasetArgs)

            __props__.__dict__["accessibility"] = accessibility
            if data_source_type is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_type'")
            __props__.__dict__["data_source_type"] = data_source_type
            __props__.__dict__["data_type"] = data_type
            if dataset_name is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_name'")
            __props__.__dict__["dataset_name"] = dataset_name
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["options"] = options
            if property is None and not opts.urn:
                raise TypeError("Missing required property 'property'")
            __props__.__dict__["property"] = property
            __props__.__dict__["source_id"] = source_id
            __props__.__dict__["source_type"] = source_type
            if uri is None and not opts.urn:
                raise TypeError("Missing required property 'uri'")
            __props__.__dict__["uri"] = uri
            __props__.__dict__["user_id"] = user_id
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["create_time"] = None
        super(WorkspaceDataset, __self__).__init__(
            'alicloud:pai/workspaceDataset:WorkspaceDataset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessibility: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            data_source_type: Optional[pulumi.Input[_builtins.str]] = None,
            data_type: Optional[pulumi.Input[_builtins.str]] = None,
            dataset_name: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceDatasetLabelArgs', 'WorkspaceDatasetLabelArgsDict']]]]] = None,
            options: Optional[pulumi.Input[_builtins.str]] = None,
            property: Optional[pulumi.Input[_builtins.str]] = None,
            source_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_type: Optional[pulumi.Input[_builtins.str]] = None,
            uri: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceDataset':
        """
        Get an existing WorkspaceDataset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessibility: Workspace visibility. The following values are supported:
               - PRIVATE (default): indicates that the workspace is visible to itself and the administrator.
               - PUBLIC: The workspace is visible to all users.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] data_source_type: The data source type. The following values are supported:
               - OSS: Alibaba Cloud Object Storage (OSS).
               - NAS: Alibaba cloud file storage (NAS).
        :param pulumi.Input[_builtins.str] data_type: The dataset type. The default value is COMMON. The following values are supported:
               - COMMON: COMMON.
               - PIC: picture.
               - TEXT: TEXT.
               - VIDEO: VIDEO.
               - AUDIO: AUDIO.
        :param pulumi.Input[_builtins.str] dataset_name: The name of the dataset. The naming rules are as follows:
               - Start with a lowercase letter, uppercase letter, number, or Chinese.
               - Can contain an underscore (_) or a dash (-).
               - 1~127 characters in length.
        :param pulumi.Input[_builtins.str] description: Custom descriptions of datasets to distinguish between different datasets.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceDatasetLabelArgs', 'WorkspaceDatasetLabelArgsDict']]]] labels: Labels added to the dataset See `labels` below.
        :param pulumi.Input[_builtins.str] options: The extended field, which is of the JsonString type.
               
               When DLC uses a dataset, you can specify the default Mount path for the dataset by configuring the mountPath field.
        :param pulumi.Input[_builtins.str] property: The properties of the dataset. The following values are supported:
               - FILE: FILE.
               - DIRECTORY: folder.
        :param pulumi.Input[_builtins.str] source_id: The data source ID.
               - When the SourceType is USER, SourceId can be customized.
               - When SourceType is ITAG, that is, when the iTAG module labels the data set generated by the result, SourceId is the task ID of ITAG.
               - When SourceType is PAI_PUBLIC_DATASET, that is, a dataset created using PAI public datasets, SourceId is empty by default.
        :param pulumi.Input[_builtins.str] source_type: The data source type. The default value is USER. The following values are supported:
               - PAI-PUBLIC-DATASET:PAI public dataset.
               - ITAG: The dataset generated by the iTAG module annotation result.
               - USER: The data set registered by the USER.
        :param pulumi.Input[_builtins.str] uri: The Uri configuration sample is as follows:
               - The data source type is OSS:'oss:// bucket.endpoint/object'
               - The data source type is NAS:
               
               The general NAS format is: 'nas://.region/subpath/to/dir/';
               
               CPFS1.0:'nas://.region/subpath/to/dir /';
               
               CPFS2.0:'nas://.region//'.
               
               CPFS1.0 and CPFS2.0 are distinguished by the format of fsid: CPFS1.0 is cpfs-;CPFS2.0 is cpfs-.
        :param pulumi.Input[_builtins.str] user_id: The ID of the dataset owner.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace where the dataset is located. For details about how to obtain the workspace ID, see ListWorkspaces.
               
               If this parameter is not configured, the default workspace is used. If the default workspace does not exist, an error is reported.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceDatasetState.__new__(_WorkspaceDatasetState)

        __props__.__dict__["accessibility"] = accessibility
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_source_type"] = data_source_type
        __props__.__dict__["data_type"] = data_type
        __props__.__dict__["dataset_name"] = dataset_name
        __props__.__dict__["description"] = description
        __props__.__dict__["labels"] = labels
        __props__.__dict__["options"] = options
        __props__.__dict__["property"] = property
        __props__.__dict__["source_id"] = source_id
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["uri"] = uri
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceDataset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accessibility(self) -> pulumi.Output[_builtins.str]:
        """
        Workspace visibility. The following values are supported:
        - PRIVATE (default): indicates that the workspace is visible to itself and the administrator.
        - PUBLIC: The workspace is visible to all users.
        """
        return pulumi.get(self, "accessibility")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> pulumi.Output[_builtins.str]:
        """
        The data source type. The following values are supported:
        - OSS: Alibaba Cloud Object Storage (OSS).
        - NAS: Alibaba cloud file storage (NAS).
        """
        return pulumi.get(self, "data_source_type")

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Output[_builtins.str]:
        """
        The dataset type. The default value is COMMON. The following values are supported:
        - COMMON: COMMON.
        - PIC: picture.
        - TEXT: TEXT.
        - VIDEO: VIDEO.
        - AUDIO: AUDIO.
        """
        return pulumi.get(self, "data_type")

    @_builtins.property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the dataset. The naming rules are as follows:
        - Start with a lowercase letter, uppercase letter, number, or Chinese.
        - Can contain an underscore (_) or a dash (-).
        - 1~127 characters in length.
        """
        return pulumi.get(self, "dataset_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom descriptions of datasets to distinguish between different datasets.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.WorkspaceDatasetLabel']]]:
        """
        Labels added to the dataset See `labels` below.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The extended field, which is of the JsonString type.

        When DLC uses a dataset, you can specify the default Mount path for the dataset by configuring the mountPath field.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def property(self) -> pulumi.Output[_builtins.str]:
        """
        The properties of the dataset. The following values are supported:
        - FILE: FILE.
        - DIRECTORY: folder.
        """
        return pulumi.get(self, "property")

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The data source ID.
        - When the SourceType is USER, SourceId can be customized.
        - When SourceType is ITAG, that is, when the iTAG module labels the data set generated by the result, SourceId is the task ID of ITAG.
        - When SourceType is PAI_PUBLIC_DATASET, that is, a dataset created using PAI public datasets, SourceId is empty by default.
        """
        return pulumi.get(self, "source_id")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[_builtins.str]:
        """
        The data source type. The default value is USER. The following values are supported:
        - PAI-PUBLIC-DATASET:PAI public dataset.
        - ITAG: The dataset generated by the iTAG module annotation result.
        - USER: The data set registered by the USER.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Output[_builtins.str]:
        """
        The Uri configuration sample is as follows:
        - The data source type is OSS:'oss:// bucket.endpoint/object'
        - The data source type is NAS:

        The general NAS format is: 'nas://.region/subpath/to/dir/';

        CPFS1.0:'nas://.region/subpath/to/dir /';

        CPFS2.0:'nas://.region//'.

        CPFS1.0 and CPFS2.0 are distinguished by the format of fsid: CPFS1.0 is cpfs-;CPFS2.0 is cpfs-.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the dataset owner.
        """
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the workspace where the dataset is located. For details about how to obtain the workspace ID, see ListWorkspaces.

        If this parameter is not configured, the default workspace is used. If the default workspace does not exist, an error is reported.
        """
        return pulumi.get(self, "workspace_id")

