# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterDbClusterIpArray',
    'ClusterDbRevisionVersionList',
    'ClusterParameter',
    'ParameterGroupParameter',
    'GetAccountsAccountResult',
    'GetAccountsAccountDatabasePrivilegeResult',
    'GetClustersClusterResult',
    'GetClustersClusterDbNodeResult',
    'GetDatabasesDatabaseResult',
    'GetDatabasesDatabaseAccountResult',
    'GetEndpointsEndpointResult',
    'GetEndpointsEndpointAddressItemResult',
    'GetGlobalDatabaseNetworksNetworkResult',
    'GetGlobalDatabaseNetworksNetworkDbClusterResult',
    'GetNodeClassesClassResult',
    'GetNodeClassesClassSupportedEngineResult',
    'GetNodeClassesClassSupportedEngineAvailableResourceResult',
    'GetParameterGroupsGroupResult',
    'GetZonesZoneResult',
]

@pulumi.output_type
class ClusterDbClusterIpArray(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dbClusterIpArrayName":
            suggest = "db_cluster_ip_array_name"
        elif key == "modifyMode":
            suggest = "modify_mode"
        elif key == "securityIps":
            suggest = "security_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterDbClusterIpArray. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterDbClusterIpArray.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterDbClusterIpArray.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 db_cluster_ip_array_name: Optional[_builtins.str] = None,
                 modify_mode: Optional[_builtins.str] = None,
                 security_ips: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str db_cluster_ip_array_name: The name of the IP whitelist group. The group name must be 2 to 120 characters in length and consists of lowercase letters and digits. It must start with a letter, and end with a letter or a digit.
               **NOTE:** If the specified whitelist group name does not exist, the whitelist group is created. If the specified whitelist group name exists, the whitelist group is modified. If you do not specify this parameter, the default group is modified. You can create a maximum of 50 IP whitelist groups for a cluster.
        :param _builtins.str modify_mode: The method for modifying the IP whitelist. Valid values are `Cover`, `Append`, `Delete`.
               **NOTE:** There does not recommend setting modify_mode to `Append` or `Delete` and it will bring a potential diff error.
        :param Sequence[_builtins.str] security_ips: List of IP addresses allowed to access all databases of a cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        if db_cluster_ip_array_name is not None:
            pulumi.set(__self__, "db_cluster_ip_array_name", db_cluster_ip_array_name)
        if modify_mode is not None:
            pulumi.set(__self__, "modify_mode", modify_mode)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)

    @_builtins.property
    @pulumi.getter(name="dbClusterIpArrayName")
    def db_cluster_ip_array_name(self) -> Optional[_builtins.str]:
        """
        The name of the IP whitelist group. The group name must be 2 to 120 characters in length and consists of lowercase letters and digits. It must start with a letter, and end with a letter or a digit.
        **NOTE:** If the specified whitelist group name does not exist, the whitelist group is created. If the specified whitelist group name exists, the whitelist group is modified. If you do not specify this parameter, the default group is modified. You can create a maximum of 50 IP whitelist groups for a cluster.
        """
        return pulumi.get(self, "db_cluster_ip_array_name")

    @_builtins.property
    @pulumi.getter(name="modifyMode")
    def modify_mode(self) -> Optional[_builtins.str]:
        """
        The method for modifying the IP whitelist. Valid values are `Cover`, `Append`, `Delete`.
        **NOTE:** There does not recommend setting modify_mode to `Append` or `Delete` and it will bring a potential diff error.
        """
        return pulumi.get(self, "modify_mode")

    @_builtins.property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of IP addresses allowed to access all databases of a cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        return pulumi.get(self, "security_ips")


@pulumi.output_type
class ClusterDbRevisionVersionList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "releaseNote":
            suggest = "release_note"
        elif key == "releaseType":
            suggest = "release_type"
        elif key == "revisionVersionCode":
            suggest = "revision_version_code"
        elif key == "revisionVersionName":
            suggest = "revision_version_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterDbRevisionVersionList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterDbRevisionVersionList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterDbRevisionVersionList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 release_note: Optional[_builtins.str] = None,
                 release_type: Optional[_builtins.str] = None,
                 revision_version_code: Optional[_builtins.str] = None,
                 revision_version_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str release_note: (Available since v1.216.0) The revised version Code of the database engine is used to specify the upgrade to the target version.
        :param _builtins.str release_type: (Available since v1.216.0) Database version release status. Valid values are `Stable`, `Old`, `HighRisk`.
        :param _builtins.str revision_version_code: (Available since v1.216.0) The revised version Code of the database engine is used to specify the upgrade to the target version.
        :param _builtins.str revision_version_name: (Available since v1.216.0) The revision version number of the database engine.
        """
        if release_note is not None:
            pulumi.set(__self__, "release_note", release_note)
        if release_type is not None:
            pulumi.set(__self__, "release_type", release_type)
        if revision_version_code is not None:
            pulumi.set(__self__, "revision_version_code", revision_version_code)
        if revision_version_name is not None:
            pulumi.set(__self__, "revision_version_name", revision_version_name)

    @_builtins.property
    @pulumi.getter(name="releaseNote")
    def release_note(self) -> Optional[_builtins.str]:
        """
        (Available since v1.216.0) The revised version Code of the database engine is used to specify the upgrade to the target version.
        """
        return pulumi.get(self, "release_note")

    @_builtins.property
    @pulumi.getter(name="releaseType")
    def release_type(self) -> Optional[_builtins.str]:
        """
        (Available since v1.216.0) Database version release status. Valid values are `Stable`, `Old`, `HighRisk`.
        """
        return pulumi.get(self, "release_type")

    @_builtins.property
    @pulumi.getter(name="revisionVersionCode")
    def revision_version_code(self) -> Optional[_builtins.str]:
        """
        (Available since v1.216.0) The revised version Code of the database engine is used to specify the upgrade to the target version.
        """
        return pulumi.get(self, "revision_version_code")

    @_builtins.property
    @pulumi.getter(name="revisionVersionName")
    def revision_version_name(self) -> Optional[_builtins.str]:
        """
        (Available since v1.216.0) The revision version number of the database engine.
        """
        return pulumi.get(self, "revision_version_name")


@pulumi.output_type
class ClusterParameter(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Kernel parameter name.
        :param _builtins.str value: Kernel parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Kernel parameter name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Kernel parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ParameterGroupParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "paramName":
            suggest = "param_name"
        elif key == "paramValue":
            suggest = "param_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParameterGroupParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParameterGroupParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParameterGroupParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 param_name: _builtins.str,
                 param_value: _builtins.str):
        """
        :param _builtins.str param_name: The name of a parameter in the parameter template.
        :param _builtins.str param_value: The value of a parameter in the parameter template.
        """
        pulumi.set(__self__, "param_name", param_name)
        pulumi.set(__self__, "param_value", param_value)

    @_builtins.property
    @pulumi.getter(name="paramName")
    def param_name(self) -> _builtins.str:
        """
        The name of a parameter in the parameter template.
        """
        return pulumi.get(self, "param_name")

    @_builtins.property
    @pulumi.getter(name="paramValue")
    def param_value(self) -> _builtins.str:
        """
        The value of a parameter in the parameter template.
        """
        return pulumi.get(self, "param_value")


@pulumi.output_type
class GetAccountsAccountResult(dict):
    def __init__(__self__, *,
                 account_description: _builtins.str,
                 account_lock_state: _builtins.str,
                 account_name: _builtins.str,
                 account_status: _builtins.str,
                 account_type: _builtins.str,
                 database_privileges: Sequence['outputs.GetAccountsAccountDatabasePrivilegeResult']):
        """
        :param _builtins.str account_description: Account description.
        :param _builtins.str account_lock_state: Account lock state, Valid values are `Lock`, `UnLock`.
        :param _builtins.str account_name: Account name.
        :param _builtins.str account_status: Cluster address type.`Cluster`: the default address of the Cluster.`Primary`: Primary address.`Custom`: Custom cluster addresses.
        :param _builtins.str account_type: Account type, Valid values are `Normal`, `Super`.
        :param Sequence['GetAccountsAccountDatabasePrivilegeArgs'] database_privileges: A list of database privilege. Each element contains the following attributes.
        """
        pulumi.set(__self__, "account_description", account_description)
        pulumi.set(__self__, "account_lock_state", account_lock_state)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "account_status", account_status)
        pulumi.set(__self__, "account_type", account_type)
        pulumi.set(__self__, "database_privileges", database_privileges)

    @_builtins.property
    @pulumi.getter(name="accountDescription")
    def account_description(self) -> _builtins.str:
        """
        Account description.
        """
        return pulumi.get(self, "account_description")

    @_builtins.property
    @pulumi.getter(name="accountLockState")
    def account_lock_state(self) -> _builtins.str:
        """
        Account lock state, Valid values are `Lock`, `UnLock`.
        """
        return pulumi.get(self, "account_lock_state")

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        """
        Account name.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="accountStatus")
    def account_status(self) -> _builtins.str:
        """
        Cluster address type.`Cluster`: the default address of the Cluster.`Primary`: Primary address.`Custom`: Custom cluster addresses.
        """
        return pulumi.get(self, "account_status")

    @_builtins.property
    @pulumi.getter(name="accountType")
    def account_type(self) -> _builtins.str:
        """
        Account type, Valid values are `Normal`, `Super`.
        """
        return pulumi.get(self, "account_type")

    @_builtins.property
    @pulumi.getter(name="databasePrivileges")
    def database_privileges(self) -> Sequence['outputs.GetAccountsAccountDatabasePrivilegeResult']:
        """
        A list of database privilege. Each element contains the following attributes.
        """
        return pulumi.get(self, "database_privileges")


@pulumi.output_type
class GetAccountsAccountDatabasePrivilegeResult(dict):
    def __init__(__self__, *,
                 account_privilege: _builtins.str,
                 db_name: _builtins.str):
        """
        :param _builtins.str account_privilege: Account privilege of database
        :param _builtins.str db_name: The account owned database name
        """
        pulumi.set(__self__, "account_privilege", account_privilege)
        pulumi.set(__self__, "db_name", db_name)

    @_builtins.property
    @pulumi.getter(name="accountPrivilege")
    def account_privilege(self) -> _builtins.str:
        """
        Account privilege of database
        """
        return pulumi.get(self, "account_privilege")

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> _builtins.str:
        """
        The account owned database name
        """
        return pulumi.get(self, "db_name")


@pulumi.output_type
class GetClustersClusterResult(dict):
    def __init__(__self__, *,
                 charge_type: _builtins.str,
                 connection_string: _builtins.str,
                 create_time: _builtins.str,
                 db_node_class: _builtins.str,
                 db_node_number: _builtins.int,
                 db_nodes: Sequence['outputs.GetClustersClusterDbNodeResult'],
                 db_type: _builtins.str,
                 db_version: _builtins.str,
                 delete_lock: _builtins.int,
                 description: _builtins.str,
                 engine: _builtins.str,
                 expire_time: _builtins.str,
                 expired: _builtins.str,
                 id: _builtins.str,
                 lock_mode: _builtins.str,
                 network_type: _builtins.str,
                 port: _builtins.str,
                 region_id: _builtins.str,
                 status: _builtins.str,
                 storage_used: _builtins.int,
                 vpc_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str charge_type: Billing method. Value options: `PostPaid` for Pay-As-You-Go and `PrePaid` for subscription.
        :param _builtins.str connection_string: PolarDB cluster connection string.
        :param _builtins.str create_time: The create_time of the db_nodes.
        :param _builtins.str db_node_class: The db_node_class of the db_nodes.
        :param _builtins.int db_node_number: The DBNodeNumber of the PolarDB cluster.
        :param Sequence['GetClustersClusterDbNodeArgs'] db_nodes: The DBNodes of the PolarDB cluster.
        :param _builtins.str db_type: Database type. Options are `MySQL`, `Oracle` and `PostgreSQL`. If no value is specified, all types are returned.
        :param _builtins.str db_version: The DBVersion of the PolarDB cluster.
        :param _builtins.int delete_lock: The DeleteLock of the PolarDB cluster.
        :param _builtins.str description: The description of the PolarDB cluster.
        :param _builtins.str engine: The database engine of the cluster, example: POLARDB.
        :param _builtins.str expire_time: Expiration time. Pay-As-You-Go clusters never expire.
        :param _builtins.str expired: The expired of the PolarDB cluster.
        :param _builtins.str id: The ID of the PolarDB cluster.
        :param _builtins.str lock_mode: The LockMode of the PolarDB cluster.
        :param _builtins.str network_type: The DBClusterNetworkType of the PolarDB cluster.
        :param _builtins.str port: PolarDB cluster connection port.
        :param _builtins.str region_id: The region_id of the db_nodes.
        :param _builtins.str status: status of the cluster.
        :param _builtins.int storage_used: The StorageUsed of the PolarDB cluster.
        :param _builtins.str vpc_id: ID of the VPC the cluster belongs to.
        :param _builtins.str zone_id: The zone_id of the db_nodes.
        """
        pulumi.set(__self__, "charge_type", charge_type)
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "db_node_class", db_node_class)
        pulumi.set(__self__, "db_node_number", db_node_number)
        pulumi.set(__self__, "db_nodes", db_nodes)
        pulumi.set(__self__, "db_type", db_type)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "delete_lock", delete_lock)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "expired", expired)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lock_mode", lock_mode)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage_used", storage_used)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> _builtins.str:
        """
        Billing method. Value options: `PostPaid` for Pay-As-You-Go and `PrePaid` for subscription.
        """
        return pulumi.get(self, "charge_type")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> _builtins.str:
        """
        PolarDB cluster connection string.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The create_time of the db_nodes.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dbNodeClass")
    def db_node_class(self) -> _builtins.str:
        """
        The db_node_class of the db_nodes.
        """
        return pulumi.get(self, "db_node_class")

    @_builtins.property
    @pulumi.getter(name="dbNodeNumber")
    def db_node_number(self) -> _builtins.int:
        """
        The DBNodeNumber of the PolarDB cluster.
        """
        return pulumi.get(self, "db_node_number")

    @_builtins.property
    @pulumi.getter(name="dbNodes")
    def db_nodes(self) -> Sequence['outputs.GetClustersClusterDbNodeResult']:
        """
        The DBNodes of the PolarDB cluster.
        """
        return pulumi.get(self, "db_nodes")

    @_builtins.property
    @pulumi.getter(name="dbType")
    def db_type(self) -> _builtins.str:
        """
        Database type. Options are `MySQL`, `Oracle` and `PostgreSQL`. If no value is specified, all types are returned.
        """
        return pulumi.get(self, "db_type")

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> _builtins.str:
        """
        The DBVersion of the PolarDB cluster.
        """
        return pulumi.get(self, "db_version")

    @_builtins.property
    @pulumi.getter(name="deleteLock")
    def delete_lock(self) -> _builtins.int:
        """
        The DeleteLock of the PolarDB cluster.
        """
        return pulumi.get(self, "delete_lock")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the PolarDB cluster.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        """
        The database engine of the cluster, example: POLARDB.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        Expiration time. Pay-As-You-Go clusters never expire.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def expired(self) -> _builtins.str:
        """
        The expired of the PolarDB cluster.
        """
        return pulumi.get(self, "expired")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the PolarDB cluster.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> _builtins.str:
        """
        The LockMode of the PolarDB cluster.
        """
        return pulumi.get(self, "lock_mode")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> _builtins.str:
        """
        The DBClusterNetworkType of the PolarDB cluster.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        PolarDB cluster connection port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region_id of the db_nodes.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        status of the cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageUsed")
    def storage_used(self) -> _builtins.int:
        """
        The StorageUsed of the PolarDB cluster.
        """
        return pulumi.get(self, "storage_used")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        ID of the VPC the cluster belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone_id of the db_nodes.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetClustersClusterDbNodeResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 db_node_class: _builtins.str,
                 db_node_id: _builtins.str,
                 db_node_role: _builtins.str,
                 db_node_status: _builtins.str,
                 max_connections: _builtins.int,
                 max_iops: _builtins.int,
                 region_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str create_time: The create_time of the db_nodes.
        :param _builtins.str db_node_class: The db_node_class of the db_nodes.
        :param _builtins.str db_node_id: The db_node_id of the db_nodes.
        :param _builtins.str db_node_role: The db_node_role of the db_nodes.
        :param _builtins.str db_node_status: The db_node_status of the db_nodes.
        :param _builtins.int max_connections: The max_connections of the db_nodes.
        :param _builtins.int max_iops: The max_iops of the db_nodes.
        :param _builtins.str region_id: The region_id of the db_nodes.
        :param _builtins.str zone_id: The zone_id of the db_nodes.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "db_node_class", db_node_class)
        pulumi.set(__self__, "db_node_id", db_node_id)
        pulumi.set(__self__, "db_node_role", db_node_role)
        pulumi.set(__self__, "db_node_status", db_node_status)
        pulumi.set(__self__, "max_connections", max_connections)
        pulumi.set(__self__, "max_iops", max_iops)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The create_time of the db_nodes.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dbNodeClass")
    def db_node_class(self) -> _builtins.str:
        """
        The db_node_class of the db_nodes.
        """
        return pulumi.get(self, "db_node_class")

    @_builtins.property
    @pulumi.getter(name="dbNodeId")
    def db_node_id(self) -> _builtins.str:
        """
        The db_node_id of the db_nodes.
        """
        return pulumi.get(self, "db_node_id")

    @_builtins.property
    @pulumi.getter(name="dbNodeRole")
    def db_node_role(self) -> _builtins.str:
        """
        The db_node_role of the db_nodes.
        """
        return pulumi.get(self, "db_node_role")

    @_builtins.property
    @pulumi.getter(name="dbNodeStatus")
    def db_node_status(self) -> _builtins.str:
        """
        The db_node_status of the db_nodes.
        """
        return pulumi.get(self, "db_node_status")

    @_builtins.property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> _builtins.int:
        """
        The max_connections of the db_nodes.
        """
        return pulumi.get(self, "max_connections")

    @_builtins.property
    @pulumi.getter(name="maxIops")
    def max_iops(self) -> _builtins.int:
        """
        The max_iops of the db_nodes.
        """
        return pulumi.get(self, "max_iops")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region_id of the db_nodes.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone_id of the db_nodes.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetDatabasesDatabaseResult(dict):
    def __init__(__self__, *,
                 accounts: Sequence['outputs.GetDatabasesDatabaseAccountResult'],
                 character_set_name: _builtins.str,
                 db_description: _builtins.str,
                 db_name: _builtins.str,
                 db_status: _builtins.str,
                 engine: _builtins.str):
        """
        :param Sequence['GetDatabasesDatabaseAccountArgs'] accounts: A list of accounts of database. Each element contains the following attributes.
        :param _builtins.str character_set_name: The character set name of database.
        :param _builtins.str db_description: Database description.
        :param _builtins.str db_name: Database name.
        :param _builtins.str db_status: The status of database.
        :param _builtins.str engine: The engine of database.
        """
        pulumi.set(__self__, "accounts", accounts)
        pulumi.set(__self__, "character_set_name", character_set_name)
        pulumi.set(__self__, "db_description", db_description)
        pulumi.set(__self__, "db_name", db_name)
        pulumi.set(__self__, "db_status", db_status)
        pulumi.set(__self__, "engine", engine)

    @_builtins.property
    @pulumi.getter
    def accounts(self) -> Sequence['outputs.GetDatabasesDatabaseAccountResult']:
        """
        A list of accounts of database. Each element contains the following attributes.
        """
        return pulumi.get(self, "accounts")

    @_builtins.property
    @pulumi.getter(name="characterSetName")
    def character_set_name(self) -> _builtins.str:
        """
        The character set name of database.
        """
        return pulumi.get(self, "character_set_name")

    @_builtins.property
    @pulumi.getter(name="dbDescription")
    def db_description(self) -> _builtins.str:
        """
        Database description.
        """
        return pulumi.get(self, "db_description")

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> _builtins.str:
        """
        Database name.
        """
        return pulumi.get(self, "db_name")

    @_builtins.property
    @pulumi.getter(name="dbStatus")
    def db_status(self) -> _builtins.str:
        """
        The status of database.
        """
        return pulumi.get(self, "db_status")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        """
        The engine of database.
        """
        return pulumi.get(self, "engine")


@pulumi.output_type
class GetDatabasesDatabaseAccountResult(dict):
    def __init__(__self__, *,
                 account_name: _builtins.str,
                 account_status: _builtins.str,
                 privilege_status: _builtins.str):
        """
        :param _builtins.str account_name: Account name.
        :param _builtins.str account_status: Account status.
        :param _builtins.str privilege_status: The privilege status of account.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "account_status", account_status)
        pulumi.set(__self__, "privilege_status", privilege_status)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        """
        Account name.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="accountStatus")
    def account_status(self) -> _builtins.str:
        """
        Account status.
        """
        return pulumi.get(self, "account_status")

    @_builtins.property
    @pulumi.getter(name="privilegeStatus")
    def privilege_status(self) -> _builtins.str:
        """
        The privilege status of account.
        """
        return pulumi.get(self, "privilege_status")


@pulumi.output_type
class GetEndpointsEndpointResult(dict):
    def __init__(__self__, *,
                 address_items: Sequence['outputs.GetEndpointsEndpointAddressItemResult'],
                 auto_add_new_nodes: _builtins.str,
                 db_endpoint_id: _builtins.str,
                 endpoint_config: _builtins.str,
                 endpoint_type: _builtins.str,
                 nodes: _builtins.str,
                 read_write_mode: _builtins.str):
        """
        :param Sequence['GetEndpointsEndpointAddressItemArgs'] address_items: A list of endpoint addresses. Each element contains the following attributes.
        :param _builtins.str auto_add_new_nodes: Whether the new node is automatically added to the default cluster address.Options are `Enable` and `Disable`.
        :param _builtins.str db_endpoint_id: endpoint of the cluster.
        :param _builtins.str endpoint_config: The Endpoint configuration. `ConsistLevel`: session consistency level, value:`0`: final consistency,`1`: session consistency;`LoadBalanceStrategy`: load balancing strategy. Based on the automatic scheduling of load, the value is: `load`.
        :param _builtins.str endpoint_type: Cluster address type.`Cluster`: the default address of the Cluster.`Primary`: Primary address.`Custom`: Custom cluster addresses.
        :param _builtins.str nodes: A list of nodes that connect to the address configuration.
        :param _builtins.str read_write_mode: Read-write mode:`ReadWrite`: readable and writable (automatic read-write separation).`ReadOnly`: ReadOnly.
        """
        pulumi.set(__self__, "address_items", address_items)
        pulumi.set(__self__, "auto_add_new_nodes", auto_add_new_nodes)
        pulumi.set(__self__, "db_endpoint_id", db_endpoint_id)
        pulumi.set(__self__, "endpoint_config", endpoint_config)
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "read_write_mode", read_write_mode)

    @_builtins.property
    @pulumi.getter(name="addressItems")
    def address_items(self) -> Sequence['outputs.GetEndpointsEndpointAddressItemResult']:
        """
        A list of endpoint addresses. Each element contains the following attributes.
        """
        return pulumi.get(self, "address_items")

    @_builtins.property
    @pulumi.getter(name="autoAddNewNodes")
    def auto_add_new_nodes(self) -> _builtins.str:
        """
        Whether the new node is automatically added to the default cluster address.Options are `Enable` and `Disable`.
        """
        return pulumi.get(self, "auto_add_new_nodes")

    @_builtins.property
    @pulumi.getter(name="dbEndpointId")
    def db_endpoint_id(self) -> _builtins.str:
        """
        endpoint of the cluster.
        """
        return pulumi.get(self, "db_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> _builtins.str:
        """
        The Endpoint configuration. `ConsistLevel`: session consistency level, value:`0`: final consistency,`1`: session consistency;`LoadBalanceStrategy`: load balancing strategy. Based on the automatic scheduling of load, the value is: `load`.
        """
        return pulumi.get(self, "endpoint_config")

    @_builtins.property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> _builtins.str:
        """
        Cluster address type.`Cluster`: the default address of the Cluster.`Primary`: Primary address.`Custom`: Custom cluster addresses.
        """
        return pulumi.get(self, "endpoint_type")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> _builtins.str:
        """
        A list of nodes that connect to the address configuration.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter(name="readWriteMode")
    def read_write_mode(self) -> _builtins.str:
        """
        Read-write mode:`ReadWrite`: readable and writable (automatic read-write separation).`ReadOnly`: ReadOnly.
        """
        return pulumi.get(self, "read_write_mode")


@pulumi.output_type
class GetEndpointsEndpointAddressItemResult(dict):
    def __init__(__self__, *,
                 connection_string: _builtins.str,
                 ip_address: _builtins.str,
                 net_type: _builtins.str,
                 port: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str):
        """
        :param _builtins.str connection_string: Connection instance string.
        :param _builtins.str ip_address: The ip address of connection string.
        :param _builtins.str net_type: IP network type:`Public` or `Private`.
        :param _builtins.str port: Intranet connection port.
        :param _builtins.str vpc_id: ID of the VPC the instance belongs to.
        :param _builtins.str vswitch_id: ID of the vSwitch the cluster belongs to.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "net_type", net_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> _builtins.str:
        """
        Connection instance string.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The ip address of connection string.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> _builtins.str:
        """
        IP network type:`Public` or `Private`.
        """
        return pulumi.get(self, "net_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        Intranet connection port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        ID of the VPC the instance belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        ID of the vSwitch the cluster belongs to.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetGlobalDatabaseNetworksNetworkResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 db_clusters: Sequence['outputs.GetGlobalDatabaseNetworksNetworkDbClusterResult'],
                 db_type: _builtins.str,
                 db_version: _builtins.str,
                 description: _builtins.str,
                 gdn_id: _builtins.str,
                 id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str create_time: The time when the Global Database Network was created. The time is in the YYYY-MM-DDThh:mm:ssZ format. The time is displayed in UTC.
        :param Sequence['GetGlobalDatabaseNetworksNetworkDbClusterArgs'] db_clusters: The details of each cluster in the Global Database Network.
        :param _builtins.str db_type: The type of the database engine. Only MySQL is supported.
        :param _builtins.str db_version: The version number of the database engine. Only the 8.0 version is supported.
        :param _builtins.str description: The description of the Global Database Network.
        :param _builtins.str gdn_id: The ID of the Global Database Network.
        :param _builtins.str id: The ID of the Global Database Network.
        :param _builtins.str status: The status of the Global Database Network. Valid values:
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "db_clusters", db_clusters)
        pulumi.set(__self__, "db_type", db_type)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "gdn_id", gdn_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the Global Database Network was created. The time is in the YYYY-MM-DDThh:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dbClusters")
    def db_clusters(self) -> Sequence['outputs.GetGlobalDatabaseNetworksNetworkDbClusterResult']:
        """
        The details of each cluster in the Global Database Network.
        """
        return pulumi.get(self, "db_clusters")

    @_builtins.property
    @pulumi.getter(name="dbType")
    def db_type(self) -> _builtins.str:
        """
        The type of the database engine. Only MySQL is supported.
        """
        return pulumi.get(self, "db_type")

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> _builtins.str:
        """
        The version number of the database engine. Only the 8.0 version is supported.
        """
        return pulumi.get(self, "db_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Global Database Network.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="gdnId")
    def gdn_id(self) -> _builtins.str:
        """
        The ID of the Global Database Network.
        """
        return pulumi.get(self, "gdn_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Global Database Network.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Global Database Network. Valid values:
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetGlobalDatabaseNetworksNetworkDbClusterResult(dict):
    def __init__(__self__, *,
                 db_cluster_id: _builtins.str,
                 region_id: _builtins.str,
                 role: _builtins.str):
        """
        :param _builtins.str db_cluster_id: The ID of the cluster.
        :param _builtins.str region_id: The region ID of the cluster.
        :param _builtins.str role: The role of the cluster.
        """
        pulumi.set(__self__, "db_cluster_id", db_cluster_id)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter(name="dbClusterId")
    def db_cluster_id(self) -> _builtins.str:
        """
        The ID of the cluster.
        """
        return pulumi.get(self, "db_cluster_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        The region ID of the cluster.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        The role of the cluster.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GetNodeClassesClassResult(dict):
    def __init__(__self__, *,
                 supported_engines: Sequence['outputs.GetNodeClassesClassSupportedEngineResult'],
                 zone_id: _builtins.str):
        """
        :param Sequence['GetNodeClassesClassSupportedEngineArgs'] supported_engines: A list of PolarDB node classes in the zone.
        :param _builtins.str zone_id: The Zone to launch the PolarDB cluster.
        """
        pulumi.set(__self__, "supported_engines", supported_engines)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="supportedEngines")
    def supported_engines(self) -> Sequence['outputs.GetNodeClassesClassSupportedEngineResult']:
        """
        A list of PolarDB node classes in the zone.
        """
        return pulumi.get(self, "supported_engines")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The Zone to launch the PolarDB cluster.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetNodeClassesClassSupportedEngineResult(dict):
    def __init__(__self__, *,
                 available_resources: Sequence['outputs.GetNodeClassesClassSupportedEngineAvailableResourceResult'],
                 engine: _builtins.str):
        """
        :param Sequence['GetNodeClassesClassSupportedEngineAvailableResourceArgs'] available_resources: A list of PolarDB node available classes.
        :param _builtins.str engine: In the zone, the database type supports classes in the following available_resources.
        """
        pulumi.set(__self__, "available_resources", available_resources)
        pulumi.set(__self__, "engine", engine)

    @_builtins.property
    @pulumi.getter(name="availableResources")
    def available_resources(self) -> Sequence['outputs.GetNodeClassesClassSupportedEngineAvailableResourceResult']:
        """
        A list of PolarDB node available classes.
        """
        return pulumi.get(self, "available_resources")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        """
        In the zone, the database type supports classes in the following available_resources.
        """
        return pulumi.get(self, "engine")


@pulumi.output_type
class GetNodeClassesClassSupportedEngineAvailableResourceResult(dict):
    def __init__(__self__, *,
                 db_node_class: _builtins.str):
        """
        :param _builtins.str db_node_class: The PolarDB node class type by the user.
        """
        pulumi.set(__self__, "db_node_class", db_node_class)

    @_builtins.property
    @pulumi.getter(name="dbNodeClass")
    def db_node_class(self) -> _builtins.str:
        """
        The PolarDB node class type by the user.
        """
        return pulumi.get(self, "db_node_class")


@pulumi.output_type
class GetParameterGroupsGroupResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 db_type: _builtins.str,
                 db_version: _builtins.str,
                 force_restart: _builtins.str,
                 id: _builtins.str,
                 parameter_counts: _builtins.int,
                 parameter_group_desc: _builtins.str,
                 parameter_group_id: _builtins.str,
                 parameter_group_name: _builtins.str,
                 parameter_group_type: _builtins.str):
        """
        :param _builtins.str create_time: The time when the parameter template was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param _builtins.str db_type: The type of the database engine. Only `MySQL` is supported.
        :param _builtins.str db_version: The version number of the database engine. Valid values: `5.6`, `5.7`, `8.0`.
        :param _builtins.str force_restart: Indicates whether to restart the cluster when this parameter template is applied.
        :param _builtins.str id: The ID of the Parameter Group.
        :param _builtins.int parameter_counts: The number of parameters in the parameter template.
        :param _builtins.str parameter_group_desc: The description of the parameter template.
        :param _builtins.str parameter_group_id: The ID of the Parameter Group.
        :param _builtins.str parameter_group_name: The name of the parameter template.
        :param _builtins.str parameter_group_type: The type of the parameter template.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "db_type", db_type)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "force_restart", force_restart)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "parameter_counts", parameter_counts)
        pulumi.set(__self__, "parameter_group_desc", parameter_group_desc)
        pulumi.set(__self__, "parameter_group_id", parameter_group_id)
        pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        pulumi.set(__self__, "parameter_group_type", parameter_group_type)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the parameter template was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dbType")
    def db_type(self) -> _builtins.str:
        """
        The type of the database engine. Only `MySQL` is supported.
        """
        return pulumi.get(self, "db_type")

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> _builtins.str:
        """
        The version number of the database engine. Valid values: `5.6`, `5.7`, `8.0`.
        """
        return pulumi.get(self, "db_version")

    @_builtins.property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> _builtins.str:
        """
        Indicates whether to restart the cluster when this parameter template is applied.
        """
        return pulumi.get(self, "force_restart")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Parameter Group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="parameterCounts")
    def parameter_counts(self) -> _builtins.int:
        """
        The number of parameters in the parameter template.
        """
        return pulumi.get(self, "parameter_counts")

    @_builtins.property
    @pulumi.getter(name="parameterGroupDesc")
    def parameter_group_desc(self) -> _builtins.str:
        """
        The description of the parameter template.
        """
        return pulumi.get(self, "parameter_group_desc")

    @_builtins.property
    @pulumi.getter(name="parameterGroupId")
    def parameter_group_id(self) -> _builtins.str:
        """
        The ID of the Parameter Group.
        """
        return pulumi.get(self, "parameter_group_id")

    @_builtins.property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> _builtins.str:
        """
        The name of the parameter template.
        """
        return pulumi.get(self, "parameter_group_name")

    @_builtins.property
    @pulumi.getter(name="parameterGroupType")
    def parameter_group_type(self) -> _builtins.str:
        """
        The type of the parameter template.
        """
        return pulumi.get(self, "parameter_group_type")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 multi_zone_ids: Sequence[_builtins.str]):
        """
        :param _builtins.str id: ID of the zone.
        :param Sequence[_builtins.str] multi_zone_ids: A list of zone ids in which the multi zone.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "multi_zone_ids", multi_zone_ids)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the zone.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="multiZoneIds")
    def multi_zone_ids(self) -> Sequence[_builtins.str]:
        """
        A list of zone ids in which the multi zone.
        """
        return pulumi.get(self, "multi_zone_ids")


