# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 mobile: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[_builtins.str] comments: Comment of the RAM user. This parameter can have a string of 1 to 128 characters.
        :param pulumi.Input[_builtins.str] display_name: Name of the RAM user which for display. This name can have a string of 1 to 128 characters or Chinese characters, must contain only alphanumeric characters or Chinese characters or hyphens, such as "-",".", and must not end with a hyphen.
        :param pulumi.Input[_builtins.str] email: Email of the RAM user.
        :param pulumi.Input[_builtins.bool] force: This parameter is used for resource destroy. Default value: `false`.
        :param pulumi.Input[_builtins.str] mobile: Phone number of the RAM user. This number must contain an international area code prefix, just look like this: 86-18600008888.
        :param pulumi.Input[_builtins.str] name: Name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
        """
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if mobile is not None:
            pulumi.set(__self__, "mobile", mobile)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment of the RAM user. This parameter can have a string of 1 to 128 characters.
        """
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comments", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the RAM user which for display. This name can have a string of 1 to 128 characters or Chinese characters, must contain only alphanumeric characters or Chinese characters or hyphens, such as "-",".", and must not end with a hyphen.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email of the RAM user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This parameter is used for resource destroy. Default value: `false`.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter
    def mobile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Phone number of the RAM user. This number must contain an international area code prefix, just look like this: 86-18600008888.
        """
        return pulumi.get(self, "mobile")

    @mobile.setter
    def mobile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mobile", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 mobile: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[_builtins.str] comments: Comment of the RAM user. This parameter can have a string of 1 to 128 characters.
        :param pulumi.Input[_builtins.str] display_name: Name of the RAM user which for display. This name can have a string of 1 to 128 characters or Chinese characters, must contain only alphanumeric characters or Chinese characters or hyphens, such as "-",".", and must not end with a hyphen.
        :param pulumi.Input[_builtins.str] email: Email of the RAM user.
        :param pulumi.Input[_builtins.bool] force: This parameter is used for resource destroy. Default value: `false`.
        :param pulumi.Input[_builtins.str] mobile: Phone number of the RAM user. This number must contain an international area code prefix, just look like this: 86-18600008888.
        :param pulumi.Input[_builtins.str] name: Name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
        """
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if mobile is not None:
            pulumi.set(__self__, "mobile", mobile)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comment of the RAM user. This parameter can have a string of 1 to 128 characters.
        """
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comments", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the RAM user which for display. This name can have a string of 1 to 128 characters or Chinese characters, must contain only alphanumeric characters or Chinese characters or hyphens, such as "-",".", and must not end with a hyphen.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email of the RAM user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This parameter is used for resource destroy. Default value: `false`.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter
    def mobile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Phone number of the RAM user. This number must contain an international area code prefix, just look like this: 86-18600008888.
        """
        return pulumi.get(self, "mobile")

    @mobile.setter
    def mobile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mobile", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("alicloud:ram/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 mobile: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RAM User resource.

        For information about RAM User and how to use it, see [What is User](https://www.alibabacloud.com/help/en/ram/developer-reference/api-ram-2015-05-01-createuser).

        > **NOTE:** When you want to destroy this resource forcefully(means release all the relationships associated with it automatically and then destroy it) without set `force`  with `true` at beginning, you need add `force = true` to configuration file and run `pulumi preview`, then you can delete resource forcefully.

        > **NOTE:** Available since v1.0.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            min=10000,
            max=99999)
        # Create a new RAM user.
        user = alicloud.ram.User("user",
            name=f"terraform-example-{default['result']}",
            display_name="user_display_name",
            mobile="86-18688888888",
            email="hello.uuu@aaa.com",
            comments="yoyoyo")
        ```

        ## Import

        RAM User can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ram/user:User example 123456789xxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comments: Comment of the RAM user. This parameter can have a string of 1 to 128 characters.
        :param pulumi.Input[_builtins.str] display_name: Name of the RAM user which for display. This name can have a string of 1 to 128 characters or Chinese characters, must contain only alphanumeric characters or Chinese characters or hyphens, such as "-",".", and must not end with a hyphen.
        :param pulumi.Input[_builtins.str] email: Email of the RAM user.
        :param pulumi.Input[_builtins.bool] force: This parameter is used for resource destroy. Default value: `false`.
        :param pulumi.Input[_builtins.str] mobile: Phone number of the RAM user. This number must contain an international area code prefix, just look like this: 86-18600008888.
        :param pulumi.Input[_builtins.str] name: Name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[UserArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RAM User resource.

        For information about RAM User and how to use it, see [What is User](https://www.alibabacloud.com/help/en/ram/developer-reference/api-ram-2015-05-01-createuser).

        > **NOTE:** When you want to destroy this resource forcefully(means release all the relationships associated with it automatically and then destroy it) without set `force`  with `true` at beginning, you need add `force = true` to configuration file and run `pulumi preview`, then you can delete resource forcefully.

        > **NOTE:** Available since v1.0.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            min=10000,
            max=99999)
        # Create a new RAM user.
        user = alicloud.ram.User("user",
            name=f"terraform-example-{default['result']}",
            display_name="user_display_name",
            mobile="86-18688888888",
            email="hello.uuu@aaa.com",
            comments="yoyoyo")
        ```

        ## Import

        RAM User can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ram/user:User example 123456789xxx
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 mobile: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["comments"] = comments
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["email"] = email
            __props__.__dict__["force"] = force
            __props__.__dict__["mobile"] = mobile
            __props__.__dict__["name"] = name
        super(User, __self__).__init__(
            'alicloud:ram/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comments: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            force: Optional[pulumi.Input[_builtins.bool]] = None,
            mobile: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comments: Comment of the RAM user. This parameter can have a string of 1 to 128 characters.
        :param pulumi.Input[_builtins.str] display_name: Name of the RAM user which for display. This name can have a string of 1 to 128 characters or Chinese characters, must contain only alphanumeric characters or Chinese characters or hyphens, such as "-",".", and must not end with a hyphen.
        :param pulumi.Input[_builtins.str] email: Email of the RAM user.
        :param pulumi.Input[_builtins.bool] force: This parameter is used for resource destroy. Default value: `false`.
        :param pulumi.Input[_builtins.str] mobile: Phone number of the RAM user. This number must contain an international area code prefix, just look like this: 86-18600008888.
        :param pulumi.Input[_builtins.str] name: Name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["comments"] = comments
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["email"] = email
        __props__.__dict__["force"] = force
        __props__.__dict__["mobile"] = mobile
        __props__.__dict__["name"] = name
        return User(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comment of the RAM user. This parameter can have a string of 1 to 128 characters.
        """
        return pulumi.get(self, "comments")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the RAM user which for display. This name can have a string of 1 to 128 characters or Chinese characters, must contain only alphanumeric characters or Chinese characters or hyphens, such as "-",".", and must not end with a hyphen.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Email of the RAM user.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This parameter is used for resource destroy. Default value: `false`.
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter
    def mobile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Phone number of the RAM user. This number must contain an international area code prefix, just look like this: 86-18600008888.
        """
        return pulumi.get(self, "mobile")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the RAM user. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen.
        """
        return pulumi.get(self, "name")

