# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserGroupAttachmentArgs', 'UserGroupAttachment']

@pulumi.input_type
class UserGroupAttachmentArgs:
    def __init__(__self__, *,
                 group_name: pulumi.Input[_builtins.str],
                 user_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a UserGroupAttachment resource.
        :param pulumi.Input[_builtins.str] group_name: The name of group.
        :param pulumi.Input[_builtins.str] user_name: The name of user.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of group.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of user.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class _UserGroupAttachmentState:
    def __init__(__self__, *,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserGroupAttachment resources.
        :param pulumi.Input[_builtins.str] group_name: The name of group.
        :param pulumi.Input[_builtins.str] user_name: The name of user.
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of group.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of user.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.type_token("alicloud:ram/userGroupAttachment:UserGroupAttachment")
class UserGroupAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RAM User Group Attachment resource.

        For information about RAM User Group Attachment and how to use it, see [What is User Group Attachment](https://next.api.alibabacloud.com/document/Ram/2015-05-01/AddUserToGroup).

        > **NOTE:** Available since v1.245.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_user = alicloud.ram.User("default",
            name=f"terraform-example-{default['result']}",
            display_name=f"terraform-example-{default['result']}")
        default_group = alicloud.ram.Group("default", name=f"terraform-example-{default['result']}")
        default_user_group_attachment = alicloud.ram.UserGroupAttachment("default",
            group_name=default_group.id,
            user_name=default_user.name)
        ```

        ## Import

        RAM User Group Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ram/userGroupAttachment:UserGroupAttachment example <group_name>:<user_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_name: The name of group.
        :param pulumi.Input[_builtins.str] user_name: The name of user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserGroupAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RAM User Group Attachment resource.

        For information about RAM User Group Attachment and how to use it, see [What is User Group Attachment](https://next.api.alibabacloud.com/document/Ram/2015-05-01/AddUserToGroup).

        > **NOTE:** Available since v1.245.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_user = alicloud.ram.User("default",
            name=f"terraform-example-{default['result']}",
            display_name=f"terraform-example-{default['result']}")
        default_group = alicloud.ram.Group("default", name=f"terraform-example-{default['result']}")
        default_user_group_attachment = alicloud.ram.UserGroupAttachment("default",
            group_name=default_group.id,
            user_name=default_user.name)
        ```

        ## Import

        RAM User Group Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ram/userGroupAttachment:UserGroupAttachment example <group_name>:<user_name>
        ```

        :param str resource_name: The name of the resource.
        :param UserGroupAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserGroupAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserGroupAttachmentArgs.__new__(UserGroupAttachmentArgs)

            if group_name is None and not opts.urn:
                raise TypeError("Missing required property 'group_name'")
            __props__.__dict__["group_name"] = group_name
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
        super(UserGroupAttachment, __self__).__init__(
            'alicloud:ram/userGroupAttachment:UserGroupAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_name: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserGroupAttachment':
        """
        Get an existing UserGroupAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_name: The name of group.
        :param pulumi.Input[_builtins.str] user_name: The name of user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserGroupAttachmentState.__new__(_UserGroupAttachmentState)

        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["user_name"] = user_name
        return UserGroupAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of group.
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of user.
        """
        return pulumi.get(self, "user_name")

