# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCollationTimeZonesResult',
    'AwaitableGetCollationTimeZonesResult',
    'get_collation_time_zones',
    'get_collation_time_zones_output',
]

@pulumi.output_type
class GetCollationTimeZonesResult:
    """
    A collection of values returned by getCollationTimeZones.
    """
    def __init__(__self__, collation_time_zones=None, id=None, ids=None, output_file=None):
        if collation_time_zones and not isinstance(collation_time_zones, list):
            raise TypeError("Expected argument 'collation_time_zones' to be a list")
        pulumi.set(__self__, "collation_time_zones", collation_time_zones)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter(name="collationTimeZones")
    def collation_time_zones(self) -> Optional[Sequence['outputs.GetCollationTimeZonesCollationTimeZoneResult']]:
        return pulumi.get(self, "collation_time_zones")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetCollationTimeZonesResult(GetCollationTimeZonesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCollationTimeZonesResult(
            collation_time_zones=self.collation_time_zones,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file)


def get_collation_time_zones(collation_time_zones: Optional[Sequence[Union['GetCollationTimeZonesCollationTimeZoneArgs', 'GetCollationTimeZonesCollationTimeZoneArgsDict']]] = None,
                             output_file: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCollationTimeZonesResult:
    """
    Operation to query the character set collations and time zones available for use in ApsaraDB RDS.

    > **NOTE:** Available in v1.198.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    zones = alicloud.rds.get_collation_time_zones(output_file="./classes.txt")
    pulumi.export("firstRdsCollationTimeZones", zones.collation_time_zones[0])
    ```


    :param Sequence[Union['GetCollationTimeZonesCollationTimeZoneArgs', 'GetCollationTimeZonesCollationTimeZoneArgsDict']] collation_time_zones: An array that consists of the character set collations and time zones that are available for
           use in ApsaraDB RDS.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi up`).
    """
    __args__ = dict()
    __args__['collationTimeZones'] = collation_time_zones
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:rds/getCollationTimeZones:getCollationTimeZones', __args__, opts=opts, typ=GetCollationTimeZonesResult).value

    return AwaitableGetCollationTimeZonesResult(
        collation_time_zones=pulumi.get(__ret__, 'collation_time_zones'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_collation_time_zones_output(collation_time_zones: Optional[pulumi.Input[Optional[Sequence[Union['GetCollationTimeZonesCollationTimeZoneArgs', 'GetCollationTimeZonesCollationTimeZoneArgsDict']]]]] = None,
                                    output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCollationTimeZonesResult]:
    """
    Operation to query the character set collations and time zones available for use in ApsaraDB RDS.

    > **NOTE:** Available in v1.198.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    zones = alicloud.rds.get_collation_time_zones(output_file="./classes.txt")
    pulumi.export("firstRdsCollationTimeZones", zones.collation_time_zones[0])
    ```


    :param Sequence[Union['GetCollationTimeZonesCollationTimeZoneArgs', 'GetCollationTimeZonesCollationTimeZoneArgsDict']] collation_time_zones: An array that consists of the character set collations and time zones that are available for
           use in ApsaraDB RDS.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi up`).
    """
    __args__ = dict()
    __args__['collationTimeZones'] = collation_time_zones
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:rds/getCollationTimeZones:getCollationTimeZones', __args__, opts=opts, typ=GetCollationTimeZonesResult)
    return __ret__.apply(lambda __response__: GetCollationTimeZonesResult(
        collation_time_zones=pulumi.get(__response__, 'collation_time_zones'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file')))
