# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 engine: pulumi.Input[_builtins.str],
                 engine_version: pulumi.Input[_builtins.str],
                 instance_storage: pulumi.Input[_builtins.int],
                 instance_type: pulumi.Input[_builtins.str],
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 babelfish_configs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBabelfishConfigArgs']]]] = None,
                 babelfish_port: Optional[pulumi.Input[_builtins.str]] = None,
                 bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ca_type: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 client_cert_revocation_list: Optional[pulumi.Input[_builtins.str]] = None,
                 client_crl_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 cold_data_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_array_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_array_name: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_is_ignore_case: Optional[pulumi.Input[_builtins.bool]] = None,
                 db_param_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.str]] = None,
                 force_restart: Optional[pulumi.Input[_builtins.bool]] = None,
                 fresh_white_list_readins: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_config: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_time: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_ha_time: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_period: Optional[pulumi.Input[_builtins.int]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 optimized_writes: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 pg_bouncer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 pg_hba_confs: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePgHbaConfArgs']]]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_model: Optional[pulumi.Input[_builtins.str]] = None,
                 released_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_acl: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_ip_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 server_key: Optional[pulumi.Input[_builtins.str]] = None,
                 serverless_configs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerlessConfigArgs']]]] = None,
                 sql_collector_config_value: Optional[pulumi.Input[_builtins.int]] = None,
                 sql_collector_status: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_auto_scale: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_upper_bound: Optional[pulumi.Input[_builtins.int]] = None,
                 switch_time: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tde_encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tde_status: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 upgrade_db_instance_kernel_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 upgrade_time: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelist_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id_slave_a: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id_slave_b: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] engine: Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.
               
               > **NOTE:** When the 'engine_version' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
        :param pulumi.Input[_builtins.str] engine_version: Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
               - MySQL: [ 5.5、5.6、5.7、8.0 ]
               - SQLServer: [ 2008r2、08r2_ent_ha、2012、2012_ent_ha、2012_std_ha、2012_web、2014_std_ha、2016_ent_ha、2016_std_ha、2016_web、2017_std_ha、2017_ent、2019_std_ha、2019_ent ]
               - PostgreSQL: [ 10.0、11.0、12.0、13.0、14.0、15.0 ]
               - MariaDB: [ 10.3 ]
               **Serverless**
               - MySQL: [ 5.7、8.0 ]
               - SQLServer: [ 2016_std_sl、2017_std_sl、2019_std_sl ]
               - PostgreSQL: [ 14.0 ]
               - MariaDB does not support creating serverless instances.
        :param pulumi.Input[_builtins.int] instance_storage: User-defined DB instance storage space. Value range:
               - [5, 2000] for MySQL/PostgreSQL HA dual node edition;
               - [20,1000] for MySQL 5.7 basic single node edition;
               - [10, 2000] for SQL Server 2008R2;
               - [20,2000] for SQL Server 2012 basic single node edition
               Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
               Note: There is extra 5 GB storage for SQL Server Instance, and it is not in specified `instance_storage`.
        :param pulumi.Input[_builtins.str] instance_type: DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
               - To create a serverless instance, please pass the following values:
               - MySQL basic: mysql.n2.serverless.1c
               - MySQL high availability: mysql.n2.serverless.2c
               - SQLServer high availability: mssql.mem2.serverless.s2
               - PostgreSQL basic: pg.n2.serverless.1c
               
               > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value. When `payment_type="Serverless"` and when modifying, do not perform `instance_storage` check. Otherwise, check.
        :param pulumi.Input[_builtins.str] acl: The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
        :param pulumi.Input[_builtins.str] auto_upgrade_minor_version: The upgrade method to use. Valid values:
               - Auto: Instances are automatically upgraded to a higher minor version.
               - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.
               
               See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceBabelfishConfigArgs']]] babelfish_configs: The configuration of an ApsaraDB RDS for PostgreSQL instance for which Babelfish is enabled. See `babelfish_config` below.
               
               > **NOTE:** This parameter takes effect only when you create an ApsaraDB RDS for PostgreSQL instance. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
        :param pulumi.Input[_builtins.str] babelfish_port: The TDS port of the instance for which Babelfish is enabled.
               
               > **NOTE:** This parameter applies only to ApsaraDB RDS for PostgreSQL instances. For more information about Babelfish for ApsaraDB RDS for PostgreSQL, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
        :param pulumi.Input[_builtins.bool] bursting_enabled: Specifies whether to enable the I/O burst feature of general
               ESSDs. Valid values:
               - true
               - false
        :param pulumi.Input[_builtins.str] ca_type: The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. **NOTE:** From version 1.231.0, `ca_type` start  support `MySQL` engine. Value range:
               - aliyun: a cloud certificate
               - custom: a custom certificate
        :param pulumi.Input[_builtins.str] category: The RDS edition of the instance. If you want to create a serverless instance, you must use this value. Valid values:
               * **Basic**: Basic Edition.
               * **HighAvailability**: High-availability Edition.
               * **AlwaysOn**: Cluster Edition.
               * **Finance**: Enterprise Edition.
               * **cluster**: MySQL Cluster Edition. (Available since v1.202.0)
               * **serverless_basic**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since v1.200.0)
               * **serverless_standard**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since v1.204.0)
               * **serverless_ha**: RDS Serverless High-availability Edition for SQL Server. (Available since v1.204.0)
               
               > **NOTE:** `zone_id_slave_a` and `zone_id_slave_b` can specify slave zone ids when creating the high-availability or enterprise edition instances. Meanwhile, `vswitch_id` needs to pass in the corresponding vswitch id to the slave zone by order (If the `vswitch_id` is not specified, the classic network version will be created). For example, `zone_id` = "zone-a" and `zone_id_slave_a` = "zone-c", `zone_id_slave_b` = "zone-b", then the `vswitch_id` must be "vsw-zone-a,vsw-zone-c,vsw-zone-b". Of course, you can also choose automatic allocation , for example, `zone_id` = "zone-a" and `zone_id_slave_a` = "Auto",`zone_id_slave_b` = "Auto", then the `vswitch_id` must be "vsw-zone-a,Auto,Auto". The list contains up to 2 slave zone ids , separated by commas.
        :param pulumi.Input[_builtins.str] client_ca_cert: The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
        :param pulumi.Input[_builtins.int] client_ca_enabled: Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
               - 1: enables the public key
               - 0: disables the public key
        :param pulumi.Input[_builtins.str] client_cert_revocation_list: The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
        :param pulumi.Input[_builtins.int] client_crl_enabled: Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - 1: enables the CRL
               - 0: disables the CRL
        :param pulumi.Input[_builtins.bool] cold_data_enabled: High performance cloud disk data archiving function switch.Example value:
               - true: Enable high-performance cloud disk data archiving function.
               - false: Disable high-performance cloud disk data archiving function.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The private connection string prefix. If you want to update public connection string prefix, please use resource rds.Connection connection_prefix.
               > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\\|{};:'",<>/?
        :param pulumi.Input[_builtins.str] db_instance_ip_array_attribute: The attribute of the IP address whitelist. By default, this parameter is empty.
               
               > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        :param pulumi.Input[_builtins.str] db_instance_ip_array_name: The name of the IP address whitelist. Default value: Default.
               
               > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        :param pulumi.Input[_builtins.str] db_instance_storage_type: The storage type of the instance. Serverless instance, only `cloud_essd` can be selected. Valid values:
               - local_ssd: specifies to use local SSDs. This value is recommended.
               - cloud_ssd: specifies to use standard SSDs.
               - cloud_essd: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
               - general_essd: general essd.
        :param pulumi.Input[_builtins.bool] db_is_ignore_case: Specifies whether table names on the instance are case-sensitive. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] db_param_group_id: Parameter template ID. Only MySQL and PostgreSQL support this parameter. If this parameter is not specified, the default parameter template is used. You can also customize a parameter template and use it here.
        :param pulumi.Input[_builtins.str] db_time_zone: The time zone of the instance. This parameter takes effect only when you set the `Engine` parameter to MySQL or PostgreSQL.
               - If you set the `Engine` parameter to MySQL.
               - This time zone of the instance is in UTC. Valid values: -12:59 to +13:00.
               - You can specify this parameter when the instance is equipped with local SSDs. For example, you can specify the time zone to Asia/Hong_Kong. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
               - If you set the `Engine` parameter to PostgreSQL.
               - This time zone of the instance is not in UTC. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
               - You can specify this parameter only when the instance is equipped with standard SSDs or ESSDs.
               
               > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
        :param pulumi.Input[_builtins.bool] deletion_protection: The switch of delete protection. Valid values:
               - true: delete protect.
               - false: no delete protect.
               
               > **NOTE:** `deletion_protection` is valid only when attribute `instance_charge_type` is set to `Postpaid` or `Serverless`, supported engine type: `MySQL`, `PostgreSQL`, `MariaDB`, `MSSQL`.
        :param pulumi.Input[_builtins.str] direction: The instance configuration type. Valid values: ["Up", "Down", "TempUpgrade", "Serverless"]
        :param pulumi.Input[_builtins.str] effective_time: The method to update the engine version and change.  Default value: Immediate. Valid values:
               - Immediate: The change immediately takes effect.
               - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        :param pulumi.Input[_builtins.str] encryption_key: The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
               When the instance is PostgreSQL, this parameter can be used to enable, modify, and disable cloud disk encryption.Value range:
               - ServiceKey: Enable disk encryption using the service-managed key (Default Service CMK) automatically generated by Alibaba Cloud RDS.
               - <Key ID>: Use a custom key to enable cloud disk encryption or change the current key. For example: 494c98ce-f2b5-48ab-96ab-36c986b6****.
               - disabled: Turn off cloud disk encryption.
               > **NOTE:** This parameter is available when the instance runs MySQL.
        :param pulumi.Input[_builtins.str] force: Specifies whether to enable forcible switching. Valid values:
               - Yes
               - No
        :param pulumi.Input[_builtins.bool] force_restart: Set it to true to make some parameter efficient when modifying them. Default to false.
        :param pulumi.Input[_builtins.str] fresh_white_list_readins: The read-only instances to which you want to synchronize the IP address whitelist.
               * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
               * If the instance is not attached with a read-only instance, this parameter is empty.
        :param pulumi.Input[_builtins.str] ha_config: The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
               - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
               - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
        :param pulumi.Input[_builtins.str] instance_charge_type: Valid values are `Prepaid`, `Postpaid`, `Serverless`, Default to `Postpaid`. Currently, the resource only supports PostPaid to PrePaid. For more information, see [Overview](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/what-is-serverless?spm=a2c63.p38356.0.0.772a28cfTAGqIv).
        :param pulumi.Input[_builtins.str] instance_name: The name of DB instance. It a string of 2 to 256 characters.
        :param pulumi.Input[_builtins.str] maintain_time: Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        :param pulumi.Input[_builtins.str] manual_ha_time: The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
               
               > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
        :param pulumi.Input[_builtins.str] modify_mode: The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
               - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
               - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
               - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        :param pulumi.Input[_builtins.int] monitoring_period: The monitoring frequency in seconds. Valid values are 5, 10, 60, 300. Defaults to 300.
        :param pulumi.Input[_builtins.str] node_id: The globally unique identifier (GUID) of the secondary instance. You can call the DescribeDBInstanceHAConfig operation to query the GUID of the secondary instance.
        :param pulumi.Input[_builtins.str] optimized_writes: Write optimization function switch. supported engine type: `MySQL`. Valid values:
               - optimized: Enable
               - none: Disable
        :param pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]] parameters: Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.bool] pg_bouncer_enabled: Modify the PgBouncer feature of the RDS PostgreSQL instance. Valid values:
               - true: enable.
               - false: disable.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePgHbaConfArgs']]] pg_hba_confs: The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        :param pulumi.Input[_builtins.str] port: The private port of the database service. If you want to update public port, please use resource rds.Connection port.
        :param pulumi.Input[_builtins.str] private_ip_address: The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
        :param pulumi.Input[_builtins.str] recovery_model: Enable the Simple Recovery Model for an RDS SQL Server Instance.The Simple Recovery Model feature is only supported by the Basic Series of RDS SQL Server instances. Once this feature is enabled, it cannot be disabled.Valid values:
               - simple: Enable Simple Recovery.
               > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
        :param pulumi.Input[_builtins.str] released_keep_policy: The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
               - None: No archived backup files are retained.
               - Lastest: Only the last archived backup file is retained.
               - All: All the archived backup files are retained.
               
               > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
        :param pulumi.Input[_builtins.str] replication_acl: The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of resource group which the DB instance belongs.
        :param pulumi.Input[_builtins.str] role_arn: The Alibaba Cloud Resource Name (ARN) of the RAM role.
               
               > **NOTE:**  This parameter is not required when you create an instance that runs MySQL, PostgreSQL, or SQL Server. You need to only specify the RoleARN parameter to create an instance that has cloud disk encryption enabled by using the obtained key ID.
               You can configure RAM authorization to require a RAM user to enable cloud disk encryption when the RAM user is used to create an instance. If cloud disk encryption is disabled during the instance creation, the creation operation fails. To complete the configuration, you can attach the following policy to the RAM user: {"Version":"1","Statement":[{"Effect":"Deny","Action":"rds:CreateDBInstance","Resource":"*","Condition":{"StringEquals":{"rds:DiskEncryptionRequired":"false"}}}]}
        :param pulumi.Input[_builtins.str] security_group_id: It has been deprecated from 1.69.0 and use `security_group_ids` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: , Available since v1.69.0) The list IDs to join ECS Security Group. At most supports three security groups.
        :param pulumi.Input[_builtins.str] security_ip_mode: Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
        :param pulumi.Input[_builtins.str] security_ip_type: The type of IP address in the IP address whitelist.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ips: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[_builtins.str] server_cert: The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. **NOTE:** From version 1.231.0, `server_cert` start  support `MySQL` engine.
        :param pulumi.Input[_builtins.str] server_key: The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. **NOTE:** From version 1.231.0, `server_key` start support `MySQL` engine.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceServerlessConfigArgs']]] serverless_configs: The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for Serverless instance. See `serverless_config` below.
        :param pulumi.Input[_builtins.int] sql_collector_config_value: The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
               > **NOTE:** This parameter takes effect when sql_collector_status is set to Enabled and does not take effect when sql_collector_status is set to Disabled.
        :param pulumi.Input[_builtins.str] sql_collector_status: The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
        :param pulumi.Input[_builtins.str] ssl_action: Actions performed on SSL functions. Valid values: 
               `Open`: turn on SSL encryption;
               `Close`: turn off SSL encryption;
               `Update`: update SSL certificate.
               See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
               
               > **NOTE:** The attribute `ssl_action` will be ignored when setting `instance_charge_type = "Serverless"` for SQLServer, PostgreSQL or MariaDB.
        :param pulumi.Input[_builtins.str] ssl_connection_string: The internal or public endpoint for which the server certificate needs to be created or updated.
        :param pulumi.Input[_builtins.str] storage_auto_scale: Automatic storage space expansion switch. Valid values:
               - Enable
               - Disable
               
               > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
        :param pulumi.Input[_builtins.int] storage_threshold: The threshold in percentage based on which an automatic storage expansion is triggered. If the available storage reaches the threshold, ApsaraDB RDS increases the storage capacity of the instance.
               Valid values: [10, 20, 30, 40, 50].
               
               > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
        :param pulumi.Input[_builtins.int] storage_upper_bound: The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.
               
               > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        :param pulumi.Input[_builtins.str] switch_time: The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `target_minor_version` is changed. The time must be in UTC.
               
               > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
               
               Note: From 1.63.0, the tag key and value are case sensitive. Before that, they are not case sensitive.
        :param pulumi.Input[_builtins.str] target_minor_version: The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. You must specify the minor engine version in one of the following formats:
               - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
               - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
               - rds: The instance runs RDS Basic or High-availability Edition.
               - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
               - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
               - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
               
               > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        :param pulumi.Input[_builtins.str] tcp_connection_type: The availability check method of the instance. Valid values:
               - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
               - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        :param pulumi.Input[_builtins.str] tde_encryption_key: The ID of the custom key.
        :param pulumi.Input[_builtins.str] tde_status: The TDE(Transparent Data Encryption) status. After TDE is turned on, it cannot be turned off. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
               
               > **NOTE:** When creating an instance and enabling disk encryption, the value of encryption_key can only be a Key ID; it cannot be a ServiceKey. After the instance is created, you can manage the disk encryption using: ServiceKey, Key ID, or disabled.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] template_id_lists: Whitelist Template ID List.
        :param pulumi.Input[_builtins.bool] upgrade_db_instance_kernel_version: Whether to upgrade a minor version of the kernel. Valid values:
               - true: upgrade
               - false: not to upgrade
               
               > **NOTE:** Database Engine and Version: Supports only MySQL 5.7 or 8.0 instances.
               > **NOTE:** Storage Type: Supports only ESSD cloud disks and general-purpose cloud disks.
               > **NOTE:** Activation Stage: Supports only during instance creation or when enabling write optimization features for existing  (high-availability/cluster series) instances.
        :param pulumi.Input[_builtins.str] upgrade_time: The method to update the minor engine version. Default value: Immediate. It is valid only when `target_minor_version` is changed. Valid values:
               - Immediate: The minor engine version is immediately updated.
               - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
               - SpecifyTime: The minor engine version is updated at the point in time you specify.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID of the instance.
               
               
               > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
        :param pulumi.Input[_builtins.str] vswitch_id: The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
        :param pulumi.Input[_builtins.str] whitelist_network_type: The network type of the IP address whitelist. Default value: MIX. Valid values:
               - Classic: classic network in enhanced whitelist mode
               - VPC: virtual private cloud (VPC) in enhanced whitelist mode
               - MIX: standard whitelist mode
               
               > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the DB instance. From version 1.8.1, it supports multiple zone.
               If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
               The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `get_zones`.
        :param pulumi.Input[_builtins.str] zone_id_slave_a: The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
        :param pulumi.Input[_builtins.str] zone_id_slave_b: RDS MySQL Cluster series instances support creating 1 to 2 secondary nodes at the same time when establishing a new instance. If you have this requirement, you can use this parameter to specify the availability zone for the second secondary node.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "instance_storage", instance_storage)
        pulumi.set(__self__, "instance_type", instance_type)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if babelfish_configs is not None:
            pulumi.set(__self__, "babelfish_configs", babelfish_configs)
        if babelfish_port is not None:
            pulumi.set(__self__, "babelfish_port", babelfish_port)
        if bursting_enabled is not None:
            pulumi.set(__self__, "bursting_enabled", bursting_enabled)
        if ca_type is not None:
            pulumi.set(__self__, "ca_type", ca_type)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if client_ca_cert is not None:
            pulumi.set(__self__, "client_ca_cert", client_ca_cert)
        if client_ca_enabled is not None:
            pulumi.set(__self__, "client_ca_enabled", client_ca_enabled)
        if client_cert_revocation_list is not None:
            pulumi.set(__self__, "client_cert_revocation_list", client_cert_revocation_list)
        if client_crl_enabled is not None:
            pulumi.set(__self__, "client_crl_enabled", client_crl_enabled)
        if cold_data_enabled is not None:
            pulumi.set(__self__, "cold_data_enabled", cold_data_enabled)
        if connection_string_prefix is not None:
            pulumi.set(__self__, "connection_string_prefix", connection_string_prefix)
        if db_instance_ip_array_attribute is not None:
            pulumi.set(__self__, "db_instance_ip_array_attribute", db_instance_ip_array_attribute)
        if db_instance_ip_array_name is not None:
            pulumi.set(__self__, "db_instance_ip_array_name", db_instance_ip_array_name)
        if db_instance_storage_type is not None:
            pulumi.set(__self__, "db_instance_storage_type", db_instance_storage_type)
        if db_is_ignore_case is not None:
            pulumi.set(__self__, "db_is_ignore_case", db_is_ignore_case)
        if db_param_group_id is not None:
            pulumi.set(__self__, "db_param_group_id", db_param_group_id)
        if db_time_zone is not None:
            pulumi.set(__self__, "db_time_zone", db_time_zone)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)
        if fresh_white_list_readins is not None:
            pulumi.set(__self__, "fresh_white_list_readins", fresh_white_list_readins)
        if ha_config is not None:
            pulumi.set(__self__, "ha_config", ha_config)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if maintain_time is not None:
            pulumi.set(__self__, "maintain_time", maintain_time)
        if manual_ha_time is not None:
            pulumi.set(__self__, "manual_ha_time", manual_ha_time)
        if modify_mode is not None:
            pulumi.set(__self__, "modify_mode", modify_mode)
        if monitoring_period is not None:
            pulumi.set(__self__, "monitoring_period", monitoring_period)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if optimized_writes is not None:
            pulumi.set(__self__, "optimized_writes", optimized_writes)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if pg_bouncer_enabled is not None:
            pulumi.set(__self__, "pg_bouncer_enabled", pg_bouncer_enabled)
        if pg_hba_confs is not None:
            pulumi.set(__self__, "pg_hba_confs", pg_hba_confs)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if recovery_model is not None:
            pulumi.set(__self__, "recovery_model", recovery_model)
        if released_keep_policy is not None:
            pulumi.set(__self__, "released_keep_policy", released_keep_policy)
        if replication_acl is not None:
            pulumi.set(__self__, "replication_acl", replication_acl)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if security_group_id is not None:
            warnings.warn("""Attribute `security_group_id` has been deprecated from 1.69.0 and use `security_group_ids` instead.""", DeprecationWarning)
            pulumi.log.warn("""security_group_id is deprecated: Attribute `security_group_id` has been deprecated from 1.69.0 and use `security_group_ids` instead.""")
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if security_ip_mode is not None:
            pulumi.set(__self__, "security_ip_mode", security_ip_mode)
        if security_ip_type is not None:
            pulumi.set(__self__, "security_ip_type", security_ip_type)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if server_cert is not None:
            pulumi.set(__self__, "server_cert", server_cert)
        if server_key is not None:
            pulumi.set(__self__, "server_key", server_key)
        if serverless_configs is not None:
            pulumi.set(__self__, "serverless_configs", serverless_configs)
        if sql_collector_config_value is not None:
            pulumi.set(__self__, "sql_collector_config_value", sql_collector_config_value)
        if sql_collector_status is not None:
            pulumi.set(__self__, "sql_collector_status", sql_collector_status)
        if ssl_action is not None:
            pulumi.set(__self__, "ssl_action", ssl_action)
        if ssl_connection_string is not None:
            pulumi.set(__self__, "ssl_connection_string", ssl_connection_string)
        if storage_auto_scale is not None:
            pulumi.set(__self__, "storage_auto_scale", storage_auto_scale)
        if storage_threshold is not None:
            pulumi.set(__self__, "storage_threshold", storage_threshold)
        if storage_upper_bound is not None:
            pulumi.set(__self__, "storage_upper_bound", storage_upper_bound)
        if switch_time is not None:
            pulumi.set(__self__, "switch_time", switch_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_minor_version is not None:
            pulumi.set(__self__, "target_minor_version", target_minor_version)
        if tcp_connection_type is not None:
            pulumi.set(__self__, "tcp_connection_type", tcp_connection_type)
        if tde_encryption_key is not None:
            pulumi.set(__self__, "tde_encryption_key", tde_encryption_key)
        if tde_status is not None:
            pulumi.set(__self__, "tde_status", tde_status)
        if template_id_lists is not None:
            pulumi.set(__self__, "template_id_lists", template_id_lists)
        if upgrade_db_instance_kernel_version is not None:
            warnings.warn("""Attribute `upgrade_db_instance_kernel_version` has been deprecated from 1.198.0 and use `target_minor_version` instead.""", DeprecationWarning)
            pulumi.log.warn("""upgrade_db_instance_kernel_version is deprecated: Attribute `upgrade_db_instance_kernel_version` has been deprecated from 1.198.0 and use `target_minor_version` instead.""")
        if upgrade_db_instance_kernel_version is not None:
            pulumi.set(__self__, "upgrade_db_instance_kernel_version", upgrade_db_instance_kernel_version)
        if upgrade_time is not None:
            pulumi.set(__self__, "upgrade_time", upgrade_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if whitelist_network_type is not None:
            pulumi.set(__self__, "whitelist_network_type", whitelist_network_type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)
        if zone_id_slave_a is not None:
            pulumi.set(__self__, "zone_id_slave_a", zone_id_slave_a)
        if zone_id_slave_b is not None:
            pulumi.set(__self__, "zone_id_slave_b", zone_id_slave_b)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Input[_builtins.str]:
        """
        Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.

        > **NOTE:** When the 'engine_version' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Input[_builtins.str]:
        """
        Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
        - MySQL: [ 5.5、5.6、5.7、8.0 ]
        - SQLServer: [ 2008r2、08r2_ent_ha、2012、2012_ent_ha、2012_std_ha、2012_web、2014_std_ha、2016_ent_ha、2016_std_ha、2016_web、2017_std_ha、2017_ent、2019_std_ha、2019_ent ]
        - PostgreSQL: [ 10.0、11.0、12.0、13.0、14.0、15.0 ]
        - MariaDB: [ 10.3 ]
        **Serverless**
        - MySQL: [ 5.7、8.0 ]
        - SQLServer: [ 2016_std_sl、2017_std_sl、2019_std_sl ]
        - PostgreSQL: [ 14.0 ]
        - MariaDB does not support creating serverless instances.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> pulumi.Input[_builtins.int]:
        """
        User-defined DB instance storage space. Value range:
        - [5, 2000] for MySQL/PostgreSQL HA dual node edition;
        - [20,1000] for MySQL 5.7 basic single node edition;
        - [10, 2000] for SQL Server 2008R2;
        - [20,2000] for SQL Server 2012 basic single node edition
        Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        Note: There is extra 5 GB storage for SQL Server Instance, and it is not in specified `instance_storage`.
        """
        return pulumi.get(self, "instance_storage")

    @instance_storage.setter
    def instance_storage(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "instance_storage", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        - To create a serverless instance, please pass the following values:
        - MySQL basic: mysql.n2.serverless.1c
        - MySQL high availability: mysql.n2.serverless.2c
        - SQLServer high availability: mssql.mem2.serverless.s2
        - PostgreSQL basic: pg.n2.serverless.1c

        > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value. When `payment_type="Serverless"` and when modifying, do not perform `instance_storage` check. Otherwise, check.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The upgrade method to use. Valid values:
        - Auto: Instances are automatically upgraded to a higher minor version.
        - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.

        See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @auto_upgrade_minor_version.setter
    def auto_upgrade_minor_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_upgrade_minor_version", value)

    @_builtins.property
    @pulumi.getter(name="babelfishConfigs")
    def babelfish_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBabelfishConfigArgs']]]]:
        """
        The configuration of an ApsaraDB RDS for PostgreSQL instance for which Babelfish is enabled. See `babelfish_config` below.

        > **NOTE:** This parameter takes effect only when you create an ApsaraDB RDS for PostgreSQL instance. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
        """
        return pulumi.get(self, "babelfish_configs")

    @babelfish_configs.setter
    def babelfish_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBabelfishConfigArgs']]]]):
        pulumi.set(self, "babelfish_configs", value)

    @_builtins.property
    @pulumi.getter(name="babelfishPort")
    def babelfish_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TDS port of the instance for which Babelfish is enabled.

        > **NOTE:** This parameter applies only to ApsaraDB RDS for PostgreSQL instances. For more information about Babelfish for ApsaraDB RDS for PostgreSQL, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
        """
        return pulumi.get(self, "babelfish_port")

    @babelfish_port.setter
    def babelfish_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "babelfish_port", value)

    @_builtins.property
    @pulumi.getter(name="burstingEnabled")
    def bursting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the I/O burst feature of general
        ESSDs. Valid values:
        - true
        - false
        """
        return pulumi.get(self, "bursting_enabled")

    @bursting_enabled.setter
    def bursting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bursting_enabled", value)

    @_builtins.property
    @pulumi.getter(name="caType")
    def ca_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. **NOTE:** From version 1.231.0, `ca_type` start  support `MySQL` engine. Value range:
        - aliyun: a cloud certificate
        - custom: a custom certificate
        """
        return pulumi.get(self, "ca_type")

    @ca_type.setter
    def ca_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_type", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RDS edition of the instance. If you want to create a serverless instance, you must use this value. Valid values:
        * **Basic**: Basic Edition.
        * **HighAvailability**: High-availability Edition.
        * **AlwaysOn**: Cluster Edition.
        * **Finance**: Enterprise Edition.
        * **cluster**: MySQL Cluster Edition. (Available since v1.202.0)
        * **serverless_basic**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since v1.200.0)
        * **serverless_standard**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since v1.204.0)
        * **serverless_ha**: RDS Serverless High-availability Edition for SQL Server. (Available since v1.204.0)

        > **NOTE:** `zone_id_slave_a` and `zone_id_slave_b` can specify slave zone ids when creating the high-availability or enterprise edition instances. Meanwhile, `vswitch_id` needs to pass in the corresponding vswitch id to the slave zone by order (If the `vswitch_id` is not specified, the classic network version will be created). For example, `zone_id` = "zone-a" and `zone_id_slave_a` = "zone-c", `zone_id_slave_b` = "zone-b", then the `vswitch_id` must be "vsw-zone-a,vsw-zone-c,vsw-zone-b". Of course, you can also choose automatic allocation , for example, `zone_id` = "zone-a" and `zone_id_slave_a` = "Auto",`zone_id_slave_b` = "Auto", then the `vswitch_id` must be "vsw-zone-a,Auto,Auto". The list contains up to 2 slave zone ids , separated by commas.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="clientCaCert")
    def client_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
        """
        return pulumi.get(self, "client_ca_cert")

    @client_ca_cert.setter
    def client_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientCaEnabled")
    def client_ca_enabled(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
        - 1: enables the public key
        - 0: disables the public key
        """
        return pulumi.get(self, "client_ca_enabled")

    @client_ca_enabled.setter
    def client_ca_enabled(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_ca_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientCertRevocationList")
    def client_cert_revocation_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
        """
        return pulumi.get(self, "client_cert_revocation_list")

    @client_cert_revocation_list.setter
    def client_cert_revocation_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert_revocation_list", value)

    @_builtins.property
    @pulumi.getter(name="clientCrlEnabled")
    def client_crl_enabled(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - 1: enables the CRL
        - 0: disables the CRL
        """
        return pulumi.get(self, "client_crl_enabled")

    @client_crl_enabled.setter
    def client_crl_enabled(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_crl_enabled", value)

    @_builtins.property
    @pulumi.getter(name="coldDataEnabled")
    def cold_data_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        High performance cloud disk data archiving function switch.Example value:
        - true: Enable high-performance cloud disk data archiving function.
        - false: Disable high-performance cloud disk data archiving function.
        """
        return pulumi.get(self, "cold_data_enabled")

    @cold_data_enabled.setter
    def cold_data_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cold_data_enabled", value)

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private connection string prefix. If you want to update public connection string prefix, please use resource rds.Connection connection_prefix.
        > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\\|{};:'",<>/?
        """
        return pulumi.get(self, "connection_string_prefix")

    @connection_string_prefix.setter
    def connection_string_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string_prefix", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceIpArrayAttribute")
    def db_instance_ip_array_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute of the IP address whitelist. By default, this parameter is empty.

        > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        """
        return pulumi.get(self, "db_instance_ip_array_attribute")

    @db_instance_ip_array_attribute.setter
    def db_instance_ip_array_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_ip_array_attribute", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceIpArrayName")
    def db_instance_ip_array_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IP address whitelist. Default value: Default.

        > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        """
        return pulumi.get(self, "db_instance_ip_array_name")

    @db_instance_ip_array_name.setter
    def db_instance_ip_array_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_ip_array_name", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage type of the instance. Serverless instance, only `cloud_essd` can be selected. Valid values:
        - local_ssd: specifies to use local SSDs. This value is recommended.
        - cloud_ssd: specifies to use standard SSDs.
        - cloud_essd: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
        - general_essd: general essd.
        """
        return pulumi.get(self, "db_instance_storage_type")

    @db_instance_storage_type.setter
    def db_instance_storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_storage_type", value)

    @_builtins.property
    @pulumi.getter(name="dbIsIgnoreCase")
    def db_is_ignore_case(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether table names on the instance are case-sensitive. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "db_is_ignore_case")

    @db_is_ignore_case.setter
    def db_is_ignore_case(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "db_is_ignore_case", value)

    @_builtins.property
    @pulumi.getter(name="dbParamGroupId")
    def db_param_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parameter template ID. Only MySQL and PostgreSQL support this parameter. If this parameter is not specified, the default parameter template is used. You can also customize a parameter template and use it here.
        """
        return pulumi.get(self, "db_param_group_id")

    @db_param_group_id.setter
    def db_param_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_param_group_id", value)

    @_builtins.property
    @pulumi.getter(name="dbTimeZone")
    def db_time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone of the instance. This parameter takes effect only when you set the `Engine` parameter to MySQL or PostgreSQL.
        - If you set the `Engine` parameter to MySQL.
        - This time zone of the instance is in UTC. Valid values: -12:59 to +13:00.
        - You can specify this parameter when the instance is equipped with local SSDs. For example, you can specify the time zone to Asia/Hong_Kong. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
        - If you set the `Engine` parameter to PostgreSQL.
        - This time zone of the instance is not in UTC. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
        - You can specify this parameter only when the instance is equipped with standard SSDs or ESSDs.

        > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
        """
        return pulumi.get(self, "db_time_zone")

    @db_time_zone.setter
    def db_time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_time_zone", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The switch of delete protection. Valid values:
        - true: delete protect.
        - false: no delete protect.

        > **NOTE:** `deletion_protection` is valid only when attribute `instance_charge_type` is set to `Postpaid` or `Serverless`, supported engine type: `MySQL`, `PostgreSQL`, `MariaDB`, `MSSQL`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance configuration type. Valid values: ["Up", "Down", "TempUpgrade", "Serverless"]
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method to update the engine version and change.  Default value: Immediate. Valid values:
        - Immediate: The change immediately takes effect.
        - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_time", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
        When the instance is PostgreSQL, this parameter can be used to enable, modify, and disable cloud disk encryption.Value range:
        - ServiceKey: Enable disk encryption using the service-managed key (Default Service CMK) automatically generated by Alibaba Cloud RDS.
        - <Key ID>: Use a custom key to enable cloud disk encryption or change the current key. For example: 494c98ce-f2b5-48ab-96ab-36c986b6****.
        - disabled: Turn off cloud disk encryption.
        > **NOTE:** This parameter is available when the instance runs MySQL.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable forcible switching. Valid values:
        - Yes
        - No
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set it to true to make some parameter efficient when modifying them. Default to false.
        """
        return pulumi.get(self, "force_restart")

    @force_restart.setter
    def force_restart(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_restart", value)

    @_builtins.property
    @pulumi.getter(name="freshWhiteListReadins")
    def fresh_white_list_readins(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The read-only instances to which you want to synchronize the IP address whitelist.
        * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
        * If the instance is not attached with a read-only instance, this parameter is empty.
        """
        return pulumi.get(self, "fresh_white_list_readins")

    @fresh_white_list_readins.setter
    def fresh_white_list_readins(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fresh_white_list_readins", value)

    @_builtins.property
    @pulumi.getter(name="haConfig")
    def ha_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
        - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
        - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
        """
        return pulumi.get(self, "ha_config")

    @ha_config.setter
    def ha_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ha_config", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `Prepaid`, `Postpaid`, `Serverless`, Default to `Postpaid`. Currently, the resource only supports PostPaid to PrePaid. For more information, see [Overview](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/what-is-serverless?spm=a2c63.p38356.0.0.772a28cfTAGqIv).
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of DB instance. It a string of 2 to 256 characters.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        """
        return pulumi.get(self, "maintain_time")

    @maintain_time.setter
    def maintain_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_time", value)

    @_builtins.property
    @pulumi.getter(name="manualHaTime")
    def manual_ha_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.

        > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
        """
        return pulumi.get(self, "manual_ha_time")

    @manual_ha_time.setter
    def manual_ha_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manual_ha_time", value)

    @_builtins.property
    @pulumi.getter(name="modifyMode")
    def modify_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
        - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
        - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
        - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        """
        return pulumi.get(self, "modify_mode")

    @modify_mode.setter
    def modify_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_mode", value)

    @_builtins.property
    @pulumi.getter(name="monitoringPeriod")
    def monitoring_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The monitoring frequency in seconds. Valid values are 5, 10, 60, 300. Defaults to 300.
        """
        return pulumi.get(self, "monitoring_period")

    @monitoring_period.setter
    def monitoring_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "monitoring_period", value)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The globally unique identifier (GUID) of the secondary instance. You can call the DescribeDBInstanceHAConfig operation to query the GUID of the secondary instance.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_id", value)

    @_builtins.property
    @pulumi.getter(name="optimizedWrites")
    def optimized_writes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Write optimization function switch. supported engine type: `MySQL`. Valid values:
        - optimized: Enable
        - none: Disable
        """
        return pulumi.get(self, "optimized_writes")

    @optimized_writes.setter
    def optimized_writes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "optimized_writes", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]:
        """
        Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="pgBouncerEnabled")
    def pg_bouncer_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Modify the PgBouncer feature of the RDS PostgreSQL instance. Valid values:
        - true: enable.
        - false: disable.
        """
        return pulumi.get(self, "pg_bouncer_enabled")

    @pg_bouncer_enabled.setter
    def pg_bouncer_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pg_bouncer_enabled", value)

    @_builtins.property
    @pulumi.getter(name="pgHbaConfs")
    def pg_hba_confs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePgHbaConfArgs']]]]:
        """
        The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        """
        return pulumi.get(self, "pg_hba_confs")

    @pg_hba_confs.setter
    def pg_hba_confs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePgHbaConfArgs']]]]):
        pulumi.set(self, "pg_hba_confs", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private port of the database service. If you want to update public port, please use resource rds.Connection port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="recoveryModel")
    def recovery_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable the Simple Recovery Model for an RDS SQL Server Instance.The Simple Recovery Model feature is only supported by the Basic Series of RDS SQL Server instances. Once this feature is enabled, it cannot be disabled.Valid values:
        - simple: Enable Simple Recovery.
        > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
        """
        return pulumi.get(self, "recovery_model")

    @recovery_model.setter
    def recovery_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_model", value)

    @_builtins.property
    @pulumi.getter(name="releasedKeepPolicy")
    def released_keep_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
        - None: No archived backup files are retained.
        - Lastest: Only the last archived backup file is retained.
        - All: All the archived backup files are retained.

        > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
        """
        return pulumi.get(self, "released_keep_policy")

    @released_keep_policy.setter
    def released_keep_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "released_keep_policy", value)

    @_builtins.property
    @pulumi.getter(name="replicationAcl")
    def replication_acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "replication_acl")

    @replication_acl.setter
    def replication_acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_acl", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of resource group which the DB instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Alibaba Cloud Resource Name (ARN) of the RAM role.

        > **NOTE:**  This parameter is not required when you create an instance that runs MySQL, PostgreSQL, or SQL Server. You need to only specify the RoleARN parameter to create an instance that has cloud disk encryption enabled by using the obtained key ID.
        You can configure RAM authorization to require a RAM user to enable cloud disk encryption when the RAM user is used to create an instance. If cloud disk encryption is disabled during the instance creation, the creation operation fails. To complete the configuration, you can attach the following policy to the RAM user: {"Version":"1","Statement":[{"Effect":"Deny","Action":"rds:CreateDBInstance","Resource":"*","Condition":{"StringEquals":{"rds:DiskEncryptionRequired":"false"}}}]}
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    @_utilities.deprecated("""Attribute `security_group_id` has been deprecated from 1.69.0 and use `security_group_ids` instead.""")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from 1.69.0 and use `security_group_ids` instead.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        , Available since v1.69.0) The list IDs to join ECS Security Group. At most supports three security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="securityIpMode")
    def security_ip_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
        """
        return pulumi.get(self, "security_ip_mode")

    @security_ip_mode.setter
    def security_ip_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ip_mode", value)

    @_builtins.property
    @pulumi.getter(name="securityIpType")
    def security_ip_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of IP address in the IP address whitelist.
        """
        return pulumi.get(self, "security_ip_type")

    @security_ip_type.setter
    def security_ip_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ip_type", value)

    @_builtins.property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_ips", value)

    @_builtins.property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. **NOTE:** From version 1.231.0, `server_cert` start  support `MySQL` engine.
        """
        return pulumi.get(self, "server_cert")

    @server_cert.setter
    def server_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_cert", value)

    @_builtins.property
    @pulumi.getter(name="serverKey")
    def server_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. **NOTE:** From version 1.231.0, `server_key` start support `MySQL` engine.
        """
        return pulumi.get(self, "server_key")

    @server_key.setter
    def server_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_key", value)

    @_builtins.property
    @pulumi.getter(name="serverlessConfigs")
    def serverless_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerlessConfigArgs']]]]:
        """
        The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for Serverless instance. See `serverless_config` below.
        """
        return pulumi.get(self, "serverless_configs")

    @serverless_configs.setter
    def serverless_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerlessConfigArgs']]]]):
        pulumi.set(self, "serverless_configs", value)

    @_builtins.property
    @pulumi.getter(name="sqlCollectorConfigValue")
    def sql_collector_config_value(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
        > **NOTE:** This parameter takes effect when sql_collector_status is set to Enabled and does not take effect when sql_collector_status is set to Disabled.
        """
        return pulumi.get(self, "sql_collector_config_value")

    @sql_collector_config_value.setter
    def sql_collector_config_value(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sql_collector_config_value", value)

    @_builtins.property
    @pulumi.getter(name="sqlCollectorStatus")
    def sql_collector_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
        """
        return pulumi.get(self, "sql_collector_status")

    @sql_collector_status.setter
    def sql_collector_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_collector_status", value)

    @_builtins.property
    @pulumi.getter(name="sslAction")
    def ssl_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Actions performed on SSL functions. Valid values: 
        `Open`: turn on SSL encryption;
        `Close`: turn off SSL encryption;
        `Update`: update SSL certificate.
        See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).

        > **NOTE:** The attribute `ssl_action` will be ignored when setting `instance_charge_type = "Serverless"` for SQLServer, PostgreSQL or MariaDB.
        """
        return pulumi.get(self, "ssl_action")

    @ssl_action.setter
    def ssl_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_action", value)

    @_builtins.property
    @pulumi.getter(name="sslConnectionString")
    def ssl_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internal or public endpoint for which the server certificate needs to be created or updated.
        """
        return pulumi.get(self, "ssl_connection_string")

    @ssl_connection_string.setter
    def ssl_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="storageAutoScale")
    def storage_auto_scale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic storage space expansion switch. Valid values:
        - Enable
        - Disable

        > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
        """
        return pulumi.get(self, "storage_auto_scale")

    @storage_auto_scale.setter
    def storage_auto_scale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_auto_scale", value)

    @_builtins.property
    @pulumi.getter(name="storageThreshold")
    def storage_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The threshold in percentage based on which an automatic storage expansion is triggered. If the available storage reaches the threshold, ApsaraDB RDS increases the storage capacity of the instance.
        Valid values: [10, 20, 30, 40, 50].

        > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
        """
        return pulumi.get(self, "storage_threshold")

    @storage_threshold.setter
    def storage_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_threshold", value)

    @_builtins.property
    @pulumi.getter(name="storageUpperBound")
    def storage_upper_bound(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.

        > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        """
        return pulumi.get(self, "storage_upper_bound")

    @storage_upper_bound.setter
    def storage_upper_bound(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_upper_bound", value)

    @_builtins.property
    @pulumi.getter(name="switchTime")
    def switch_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `target_minor_version` is changed. The time must be in UTC.

        > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        """
        return pulumi.get(self, "switch_time")

    @switch_time.setter
    def switch_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "switch_time", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.

        Note: From 1.63.0, the tag key and value are case sensitive. Before that, they are not case sensitive.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetMinorVersion")
    def target_minor_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. You must specify the minor engine version in one of the following formats:
        - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
        - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
        - rds: The instance runs RDS Basic or High-availability Edition.
        - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
        - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
        - SQLServer: <Minor engine version>. Example: 15.0.4073.23.

        > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        """
        return pulumi.get(self, "target_minor_version")

    @target_minor_version.setter
    def target_minor_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_minor_version", value)

    @_builtins.property
    @pulumi.getter(name="tcpConnectionType")
    def tcp_connection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability check method of the instance. Valid values:
        - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
        - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        """
        return pulumi.get(self, "tcp_connection_type")

    @tcp_connection_type.setter
    def tcp_connection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tcp_connection_type", value)

    @_builtins.property
    @pulumi.getter(name="tdeEncryptionKey")
    def tde_encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the custom key.
        """
        return pulumi.get(self, "tde_encryption_key")

    @tde_encryption_key.setter
    def tde_encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tde_encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="tdeStatus")
    def tde_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TDE(Transparent Data Encryption) status. After TDE is turned on, it cannot be turned off. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).

        > **NOTE:** When creating an instance and enabling disk encryption, the value of encryption_key can only be a Key ID; it cannot be a ServiceKey. After the instance is created, you can manage the disk encryption using: ServiceKey, Key ID, or disabled.
        """
        return pulumi.get(self, "tde_status")

    @tde_status.setter
    def tde_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tde_status", value)

    @_builtins.property
    @pulumi.getter(name="templateIdLists")
    def template_id_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        Whitelist Template ID List.
        """
        return pulumi.get(self, "template_id_lists")

    @template_id_lists.setter
    def template_id_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "template_id_lists", value)

    @_builtins.property
    @pulumi.getter(name="upgradeDbInstanceKernelVersion")
    @_utilities.deprecated("""Attribute `upgrade_db_instance_kernel_version` has been deprecated from 1.198.0 and use `target_minor_version` instead.""")
    def upgrade_db_instance_kernel_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to upgrade a minor version of the kernel. Valid values:
        - true: upgrade
        - false: not to upgrade

        > **NOTE:** Database Engine and Version: Supports only MySQL 5.7 or 8.0 instances.
        > **NOTE:** Storage Type: Supports only ESSD cloud disks and general-purpose cloud disks.
        > **NOTE:** Activation Stage: Supports only during instance creation or when enabling write optimization features for existing  (high-availability/cluster series) instances.
        """
        return pulumi.get(self, "upgrade_db_instance_kernel_version")

    @upgrade_db_instance_kernel_version.setter
    def upgrade_db_instance_kernel_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "upgrade_db_instance_kernel_version", value)

    @_builtins.property
    @pulumi.getter(name="upgradeTime")
    def upgrade_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method to update the minor engine version. Default value: Immediate. It is valid only when `target_minor_version` is changed. Valid values:
        - Immediate: The minor engine version is immediately updated.
        - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
        - SpecifyTime: The minor engine version is updated at the point in time you specify.
        """
        return pulumi.get(self, "upgrade_time")

    @upgrade_time.setter
    def upgrade_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_time", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID of the instance.


        > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="whitelistNetworkType")
    def whitelist_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the IP address whitelist. Default value: MIX. Valid values:
        - Classic: classic network in enhanced whitelist mode
        - VPC: virtual private cloud (VPC) in enhanced whitelist mode
        - MIX: standard whitelist mode

        > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        """
        return pulumi.get(self, "whitelist_network_type")

    @whitelist_network_type.setter
    def whitelist_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "whitelist_network_type", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Zone to launch the DB instance. From version 1.8.1, it supports multiple zone.
        If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
        The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `get_zones`.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneIdSlaveA")
    def zone_id_slave_a(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
        """
        return pulumi.get(self, "zone_id_slave_a")

    @zone_id_slave_a.setter
    def zone_id_slave_a(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id_slave_a", value)

    @_builtins.property
    @pulumi.getter(name="zoneIdSlaveB")
    def zone_id_slave_b(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RDS MySQL Cluster series instances support creating 1 to 2 secondary nodes at the same time when establishing a new instance. If you have this requirement, you can use this parameter to specify the availability zone for the second secondary node.
        """
        return pulumi.get(self, "zone_id_slave_b")

    @zone_id_slave_b.setter
    def zone_id_slave_b(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id_slave_b", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 babelfish_configs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBabelfishConfigArgs']]]] = None,
                 babelfish_port: Optional[pulumi.Input[_builtins.str]] = None,
                 bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ca_type: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 client_cert_revocation_list: Optional[pulumi.Input[_builtins.str]] = None,
                 client_crl_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 cold_data_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_array_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_array_name: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_is_ignore_case: Optional[pulumi.Input[_builtins.bool]] = None,
                 db_param_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.str]] = None,
                 force_restart: Optional[pulumi.Input[_builtins.bool]] = None,
                 fresh_white_list_readins: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_config: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_time: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_ha_time: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_period: Optional[pulumi.Input[_builtins.int]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 optimized_writes: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 pg_bouncer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 pg_hba_confs: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePgHbaConfArgs']]]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_model: Optional[pulumi.Input[_builtins.str]] = None,
                 released_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_acl: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_ip_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 server_key: Optional[pulumi.Input[_builtins.str]] = None,
                 serverless_configs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerlessConfigArgs']]]] = None,
                 sql_collector_config_value: Optional[pulumi.Input[_builtins.int]] = None,
                 sql_collector_status: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_status: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_auto_scale: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_upper_bound: Optional[pulumi.Input[_builtins.int]] = None,
                 switch_time: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tde_encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tde_status: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 templates: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 upgrade_db_instance_kernel_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 upgrade_time: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelist_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id_slave_a: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id_slave_b: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] acl: The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
        :param pulumi.Input[_builtins.str] auto_upgrade_minor_version: The upgrade method to use. Valid values:
               - Auto: Instances are automatically upgraded to a higher minor version.
               - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.
               
               See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceBabelfishConfigArgs']]] babelfish_configs: The configuration of an ApsaraDB RDS for PostgreSQL instance for which Babelfish is enabled. See `babelfish_config` below.
               
               > **NOTE:** This parameter takes effect only when you create an ApsaraDB RDS for PostgreSQL instance. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
        :param pulumi.Input[_builtins.str] babelfish_port: The TDS port of the instance for which Babelfish is enabled.
               
               > **NOTE:** This parameter applies only to ApsaraDB RDS for PostgreSQL instances. For more information about Babelfish for ApsaraDB RDS for PostgreSQL, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
        :param pulumi.Input[_builtins.bool] bursting_enabled: Specifies whether to enable the I/O burst feature of general
               ESSDs. Valid values:
               - true
               - false
        :param pulumi.Input[_builtins.str] ca_type: The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. **NOTE:** From version 1.231.0, `ca_type` start  support `MySQL` engine. Value range:
               - aliyun: a cloud certificate
               - custom: a custom certificate
        :param pulumi.Input[_builtins.str] category: The RDS edition of the instance. If you want to create a serverless instance, you must use this value. Valid values:
               * **Basic**: Basic Edition.
               * **HighAvailability**: High-availability Edition.
               * **AlwaysOn**: Cluster Edition.
               * **Finance**: Enterprise Edition.
               * **cluster**: MySQL Cluster Edition. (Available since v1.202.0)
               * **serverless_basic**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since v1.200.0)
               * **serverless_standard**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since v1.204.0)
               * **serverless_ha**: RDS Serverless High-availability Edition for SQL Server. (Available since v1.204.0)
               
               > **NOTE:** `zone_id_slave_a` and `zone_id_slave_b` can specify slave zone ids when creating the high-availability or enterprise edition instances. Meanwhile, `vswitch_id` needs to pass in the corresponding vswitch id to the slave zone by order (If the `vswitch_id` is not specified, the classic network version will be created). For example, `zone_id` = "zone-a" and `zone_id_slave_a` = "zone-c", `zone_id_slave_b` = "zone-b", then the `vswitch_id` must be "vsw-zone-a,vsw-zone-c,vsw-zone-b". Of course, you can also choose automatic allocation , for example, `zone_id` = "zone-a" and `zone_id_slave_a` = "Auto",`zone_id_slave_b` = "Auto", then the `vswitch_id` must be "vsw-zone-a,Auto,Auto". The list contains up to 2 slave zone ids , separated by commas.
        :param pulumi.Input[_builtins.str] client_ca_cert: The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
        :param pulumi.Input[_builtins.int] client_ca_enabled: Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
               - 1: enables the public key
               - 0: disables the public key
        :param pulumi.Input[_builtins.str] client_cert_revocation_list: The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
        :param pulumi.Input[_builtins.int] client_crl_enabled: Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - 1: enables the CRL
               - 0: disables the CRL
        :param pulumi.Input[_builtins.bool] cold_data_enabled: High performance cloud disk data archiving function switch.Example value:
               - true: Enable high-performance cloud disk data archiving function.
               - false: Disable high-performance cloud disk data archiving function.
        :param pulumi.Input[_builtins.str] connection_string: RDS database connection string.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The private connection string prefix. If you want to update public connection string prefix, please use resource rds.Connection connection_prefix.
               > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\\|{};:'",<>/?
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.204.1) The creation time of db instance.
        :param pulumi.Input[_builtins.str] db_instance_ip_array_attribute: The attribute of the IP address whitelist. By default, this parameter is empty.
               
               > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        :param pulumi.Input[_builtins.str] db_instance_ip_array_name: The name of the IP address whitelist. Default value: Default.
               
               > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        :param pulumi.Input[_builtins.str] db_instance_storage_type: The storage type of the instance. Serverless instance, only `cloud_essd` can be selected. Valid values:
               - local_ssd: specifies to use local SSDs. This value is recommended.
               - cloud_ssd: specifies to use standard SSDs.
               - cloud_essd: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
               - general_essd: general essd.
        :param pulumi.Input[_builtins.str] db_instance_type: (Available since v1.197.0) The type of db instance.
        :param pulumi.Input[_builtins.bool] db_is_ignore_case: Specifies whether table names on the instance are case-sensitive. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] db_param_group_id: Parameter template ID. Only MySQL and PostgreSQL support this parameter. If this parameter is not specified, the default parameter template is used. You can also customize a parameter template and use it here.
        :param pulumi.Input[_builtins.str] db_time_zone: The time zone of the instance. This parameter takes effect only when you set the `Engine` parameter to MySQL or PostgreSQL.
               - If you set the `Engine` parameter to MySQL.
               - This time zone of the instance is in UTC. Valid values: -12:59 to +13:00.
               - You can specify this parameter when the instance is equipped with local SSDs. For example, you can specify the time zone to Asia/Hong_Kong. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
               - If you set the `Engine` parameter to PostgreSQL.
               - This time zone of the instance is not in UTC. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
               - You can specify this parameter only when the instance is equipped with standard SSDs or ESSDs.
               
               > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
        :param pulumi.Input[_builtins.bool] deletion_protection: The switch of delete protection. Valid values:
               - true: delete protect.
               - false: no delete protect.
               
               > **NOTE:** `deletion_protection` is valid only when attribute `instance_charge_type` is set to `Postpaid` or `Serverless`, supported engine type: `MySQL`, `PostgreSQL`, `MariaDB`, `MSSQL`.
        :param pulumi.Input[_builtins.str] direction: The instance configuration type. Valid values: ["Up", "Down", "TempUpgrade", "Serverless"]
        :param pulumi.Input[_builtins.str] effective_time: The method to update the engine version and change.  Default value: Immediate. Valid values:
               - Immediate: The change immediately takes effect.
               - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        :param pulumi.Input[_builtins.str] encryption_key: The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
               When the instance is PostgreSQL, this parameter can be used to enable, modify, and disable cloud disk encryption.Value range:
               - ServiceKey: Enable disk encryption using the service-managed key (Default Service CMK) automatically generated by Alibaba Cloud RDS.
               - <Key ID>: Use a custom key to enable cloud disk encryption or change the current key. For example: 494c98ce-f2b5-48ab-96ab-36c986b6****.
               - disabled: Turn off cloud disk encryption.
               > **NOTE:** This parameter is available when the instance runs MySQL.
        :param pulumi.Input[_builtins.str] engine: Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.
               
               > **NOTE:** When the 'engine_version' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
        :param pulumi.Input[_builtins.str] engine_version: Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
               - MySQL: [ 5.5、5.6、5.7、8.0 ]
               - SQLServer: [ 2008r2、08r2_ent_ha、2012、2012_ent_ha、2012_std_ha、2012_web、2014_std_ha、2016_ent_ha、2016_std_ha、2016_web、2017_std_ha、2017_ent、2019_std_ha、2019_ent ]
               - PostgreSQL: [ 10.0、11.0、12.0、13.0、14.0、15.0 ]
               - MariaDB: [ 10.3 ]
               **Serverless**
               - MySQL: [ 5.7、8.0 ]
               - SQLServer: [ 2016_std_sl、2017_std_sl、2019_std_sl ]
               - PostgreSQL: [ 14.0 ]
               - MariaDB does not support creating serverless instances.
        :param pulumi.Input[_builtins.str] force: Specifies whether to enable forcible switching. Valid values:
               - Yes
               - No
        :param pulumi.Input[_builtins.bool] force_restart: Set it to true to make some parameter efficient when modifying them. Default to false.
        :param pulumi.Input[_builtins.str] fresh_white_list_readins: The read-only instances to which you want to synchronize the IP address whitelist.
               * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
               * If the instance is not attached with a read-only instance, this parameter is empty.
        :param pulumi.Input[_builtins.str] ha_config: The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
               - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
               - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
        :param pulumi.Input[_builtins.str] instance_charge_type: Valid values are `Prepaid`, `Postpaid`, `Serverless`, Default to `Postpaid`. Currently, the resource only supports PostPaid to PrePaid. For more information, see [Overview](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/what-is-serverless?spm=a2c63.p38356.0.0.772a28cfTAGqIv).
        :param pulumi.Input[_builtins.str] instance_name: The name of DB instance. It a string of 2 to 256 characters.
        :param pulumi.Input[_builtins.int] instance_storage: User-defined DB instance storage space. Value range:
               - [5, 2000] for MySQL/PostgreSQL HA dual node edition;
               - [20,1000] for MySQL 5.7 basic single node edition;
               - [10, 2000] for SQL Server 2008R2;
               - [20,2000] for SQL Server 2012 basic single node edition
               Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
               Note: There is extra 5 GB storage for SQL Server Instance, and it is not in specified `instance_storage`.
        :param pulumi.Input[_builtins.str] instance_type: DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
               - To create a serverless instance, please pass the following values:
               - MySQL basic: mysql.n2.serverless.1c
               - MySQL high availability: mysql.n2.serverless.2c
               - SQLServer high availability: mssql.mem2.serverless.s2
               - PostgreSQL basic: pg.n2.serverless.1c
               
               > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value. When `payment_type="Serverless"` and when modifying, do not perform `instance_storage` check. Otherwise, check.
        :param pulumi.Input[_builtins.str] maintain_time: Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        :param pulumi.Input[_builtins.str] manual_ha_time: The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
               
               > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
        :param pulumi.Input[_builtins.str] modify_mode: The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
               - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
               - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
               - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        :param pulumi.Input[_builtins.int] monitoring_period: The monitoring frequency in seconds. Valid values are 5, 10, 60, 300. Defaults to 300.
        :param pulumi.Input[_builtins.str] node_id: The globally unique identifier (GUID) of the secondary instance. You can call the DescribeDBInstanceHAConfig operation to query the GUID of the secondary instance.
        :param pulumi.Input[_builtins.str] optimized_writes: Write optimization function switch. supported engine type: `MySQL`. Valid values:
               - optimized: Enable
               - none: Disable
        :param pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]] parameters: Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.bool] pg_bouncer_enabled: Modify the PgBouncer feature of the RDS PostgreSQL instance. Valid values:
               - true: enable.
               - false: disable.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePgHbaConfArgs']]] pg_hba_confs: The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        :param pulumi.Input[_builtins.str] port: The private port of the database service. If you want to update public port, please use resource rds.Connection port.
        :param pulumi.Input[_builtins.str] private_ip_address: The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
        :param pulumi.Input[_builtins.str] recovery_model: Enable the Simple Recovery Model for an RDS SQL Server Instance.The Simple Recovery Model feature is only supported by the Basic Series of RDS SQL Server instances. Once this feature is enabled, it cannot be disabled.Valid values:
               - simple: Enable Simple Recovery.
               > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
        :param pulumi.Input[_builtins.str] released_keep_policy: The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
               - None: No archived backup files are retained.
               - Lastest: Only the last archived backup file is retained.
               - All: All the archived backup files are retained.
               
               > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
        :param pulumi.Input[_builtins.str] replication_acl: The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of resource group which the DB instance belongs.
        :param pulumi.Input[_builtins.str] role_arn: The Alibaba Cloud Resource Name (ARN) of the RAM role.
               
               > **NOTE:**  This parameter is not required when you create an instance that runs MySQL, PostgreSQL, or SQL Server. You need to only specify the RoleARN parameter to create an instance that has cloud disk encryption enabled by using the obtained key ID.
               You can configure RAM authorization to require a RAM user to enable cloud disk encryption when the RAM user is used to create an instance. If cloud disk encryption is disabled during the instance creation, the creation operation fails. To complete the configuration, you can attach the following policy to the RAM user: {"Version":"1","Statement":[{"Effect":"Deny","Action":"rds:CreateDBInstance","Resource":"*","Condition":{"StringEquals":{"rds:DiskEncryptionRequired":"false"}}}]}
        :param pulumi.Input[_builtins.str] security_group_id: It has been deprecated from 1.69.0 and use `security_group_ids` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: , Available since v1.69.0) The list IDs to join ECS Security Group. At most supports three security groups.
        :param pulumi.Input[_builtins.str] security_ip_mode: Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
        :param pulumi.Input[_builtins.str] security_ip_type: The type of IP address in the IP address whitelist.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ips: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[_builtins.str] server_cert: The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. **NOTE:** From version 1.231.0, `server_cert` start  support `MySQL` engine.
        :param pulumi.Input[_builtins.str] server_key: The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. **NOTE:** From version 1.231.0, `server_key` start support `MySQL` engine.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceServerlessConfigArgs']]] serverless_configs: The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for Serverless instance. See `serverless_config` below.
        :param pulumi.Input[_builtins.int] sql_collector_config_value: The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
               > **NOTE:** This parameter takes effect when sql_collector_status is set to Enabled and does not take effect when sql_collector_status is set to Disabled.
        :param pulumi.Input[_builtins.str] sql_collector_status: The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
        :param pulumi.Input[_builtins.str] ssl_action: Actions performed on SSL functions. Valid values: 
               `Open`: turn on SSL encryption;
               `Close`: turn off SSL encryption;
               `Update`: update SSL certificate.
               See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
               
               > **NOTE:** The attribute `ssl_action` will be ignored when setting `instance_charge_type = "Serverless"` for SQLServer, PostgreSQL or MariaDB.
        :param pulumi.Input[_builtins.str] ssl_connection_string: The internal or public endpoint for which the server certificate needs to be created or updated.
        :param pulumi.Input[_builtins.str] ssl_status: Status of the SSL feature. `Yes`: SSL is turned on; `No`: SSL is turned off.
        :param pulumi.Input[_builtins.str] status: (Available since v1.204.1) The status of db instance.
        :param pulumi.Input[_builtins.str] storage_auto_scale: Automatic storage space expansion switch. Valid values:
               - Enable
               - Disable
               
               > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
        :param pulumi.Input[_builtins.int] storage_threshold: The threshold in percentage based on which an automatic storage expansion is triggered. If the available storage reaches the threshold, ApsaraDB RDS increases the storage capacity of the instance.
               Valid values: [10, 20, 30, 40, 50].
               
               > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
        :param pulumi.Input[_builtins.int] storage_upper_bound: The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.
               
               > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        :param pulumi.Input[_builtins.str] switch_time: The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `target_minor_version` is changed. The time must be in UTC.
               
               > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
               
               Note: From 1.63.0, the tag key and value are case sensitive. Before that, they are not case sensitive.
        :param pulumi.Input[_builtins.str] target_minor_version: The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. You must specify the minor engine version in one of the following formats:
               - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
               - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
               - rds: The instance runs RDS Basic or High-availability Edition.
               - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
               - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
               - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
               
               > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        :param pulumi.Input[_builtins.str] tcp_connection_type: The availability check method of the instance. Valid values:
               - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
               - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        :param pulumi.Input[_builtins.str] tde_encryption_key: The ID of the custom key.
        :param pulumi.Input[_builtins.str] tde_status: The TDE(Transparent Data Encryption) status. After TDE is turned on, it cannot be turned off. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
               
               > **NOTE:** When creating an instance and enabling disk encryption, the value of encryption_key can only be a Key ID; it cannot be a ServiceKey. After the instance is created, you can manage the disk encryption using: ServiceKey, Key ID, or disabled.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] template_id_lists: Whitelist Template ID List.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]] templates: (Computed, Available since v1.254.0) Whitelist Template Details.
        :param pulumi.Input[_builtins.bool] upgrade_db_instance_kernel_version: Whether to upgrade a minor version of the kernel. Valid values:
               - true: upgrade
               - false: not to upgrade
               
               > **NOTE:** Database Engine and Version: Supports only MySQL 5.7 or 8.0 instances.
               > **NOTE:** Storage Type: Supports only ESSD cloud disks and general-purpose cloud disks.
               > **NOTE:** Activation Stage: Supports only during instance creation or when enabling write optimization features for existing  (high-availability/cluster series) instances.
        :param pulumi.Input[_builtins.str] upgrade_time: The method to update the minor engine version. Default value: Immediate. It is valid only when `target_minor_version` is changed. Valid values:
               - Immediate: The minor engine version is immediately updated.
               - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
               - SpecifyTime: The minor engine version is updated at the point in time you specify.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID of the instance.
               
               
               > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
        :param pulumi.Input[_builtins.str] vswitch_id: The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
        :param pulumi.Input[_builtins.str] whitelist_network_type: The network type of the IP address whitelist. Default value: MIX. Valid values:
               - Classic: classic network in enhanced whitelist mode
               - VPC: virtual private cloud (VPC) in enhanced whitelist mode
               - MIX: standard whitelist mode
               
               > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the DB instance. From version 1.8.1, it supports multiple zone.
               If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
               The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `get_zones`.
        :param pulumi.Input[_builtins.str] zone_id_slave_a: The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
        :param pulumi.Input[_builtins.str] zone_id_slave_b: RDS MySQL Cluster series instances support creating 1 to 2 secondary nodes at the same time when establishing a new instance. If you have this requirement, you can use this parameter to specify the availability zone for the second secondary node.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if babelfish_configs is not None:
            pulumi.set(__self__, "babelfish_configs", babelfish_configs)
        if babelfish_port is not None:
            pulumi.set(__self__, "babelfish_port", babelfish_port)
        if bursting_enabled is not None:
            pulumi.set(__self__, "bursting_enabled", bursting_enabled)
        if ca_type is not None:
            pulumi.set(__self__, "ca_type", ca_type)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if client_ca_cert is not None:
            pulumi.set(__self__, "client_ca_cert", client_ca_cert)
        if client_ca_enabled is not None:
            pulumi.set(__self__, "client_ca_enabled", client_ca_enabled)
        if client_cert_revocation_list is not None:
            pulumi.set(__self__, "client_cert_revocation_list", client_cert_revocation_list)
        if client_crl_enabled is not None:
            pulumi.set(__self__, "client_crl_enabled", client_crl_enabled)
        if cold_data_enabled is not None:
            pulumi.set(__self__, "cold_data_enabled", cold_data_enabled)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if connection_string_prefix is not None:
            pulumi.set(__self__, "connection_string_prefix", connection_string_prefix)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if db_instance_ip_array_attribute is not None:
            pulumi.set(__self__, "db_instance_ip_array_attribute", db_instance_ip_array_attribute)
        if db_instance_ip_array_name is not None:
            pulumi.set(__self__, "db_instance_ip_array_name", db_instance_ip_array_name)
        if db_instance_storage_type is not None:
            pulumi.set(__self__, "db_instance_storage_type", db_instance_storage_type)
        if db_instance_type is not None:
            pulumi.set(__self__, "db_instance_type", db_instance_type)
        if db_is_ignore_case is not None:
            pulumi.set(__self__, "db_is_ignore_case", db_is_ignore_case)
        if db_param_group_id is not None:
            pulumi.set(__self__, "db_param_group_id", db_param_group_id)
        if db_time_zone is not None:
            pulumi.set(__self__, "db_time_zone", db_time_zone)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)
        if fresh_white_list_readins is not None:
            pulumi.set(__self__, "fresh_white_list_readins", fresh_white_list_readins)
        if ha_config is not None:
            pulumi.set(__self__, "ha_config", ha_config)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_storage is not None:
            pulumi.set(__self__, "instance_storage", instance_storage)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if maintain_time is not None:
            pulumi.set(__self__, "maintain_time", maintain_time)
        if manual_ha_time is not None:
            pulumi.set(__self__, "manual_ha_time", manual_ha_time)
        if modify_mode is not None:
            pulumi.set(__self__, "modify_mode", modify_mode)
        if monitoring_period is not None:
            pulumi.set(__self__, "monitoring_period", monitoring_period)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if optimized_writes is not None:
            pulumi.set(__self__, "optimized_writes", optimized_writes)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if pg_bouncer_enabled is not None:
            pulumi.set(__self__, "pg_bouncer_enabled", pg_bouncer_enabled)
        if pg_hba_confs is not None:
            pulumi.set(__self__, "pg_hba_confs", pg_hba_confs)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if recovery_model is not None:
            pulumi.set(__self__, "recovery_model", recovery_model)
        if released_keep_policy is not None:
            pulumi.set(__self__, "released_keep_policy", released_keep_policy)
        if replication_acl is not None:
            pulumi.set(__self__, "replication_acl", replication_acl)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if security_group_id is not None:
            warnings.warn("""Attribute `security_group_id` has been deprecated from 1.69.0 and use `security_group_ids` instead.""", DeprecationWarning)
            pulumi.log.warn("""security_group_id is deprecated: Attribute `security_group_id` has been deprecated from 1.69.0 and use `security_group_ids` instead.""")
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if security_ip_mode is not None:
            pulumi.set(__self__, "security_ip_mode", security_ip_mode)
        if security_ip_type is not None:
            pulumi.set(__self__, "security_ip_type", security_ip_type)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if server_cert is not None:
            pulumi.set(__self__, "server_cert", server_cert)
        if server_key is not None:
            pulumi.set(__self__, "server_key", server_key)
        if serverless_configs is not None:
            pulumi.set(__self__, "serverless_configs", serverless_configs)
        if sql_collector_config_value is not None:
            pulumi.set(__self__, "sql_collector_config_value", sql_collector_config_value)
        if sql_collector_status is not None:
            pulumi.set(__self__, "sql_collector_status", sql_collector_status)
        if ssl_action is not None:
            pulumi.set(__self__, "ssl_action", ssl_action)
        if ssl_connection_string is not None:
            pulumi.set(__self__, "ssl_connection_string", ssl_connection_string)
        if ssl_status is not None:
            pulumi.set(__self__, "ssl_status", ssl_status)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_auto_scale is not None:
            pulumi.set(__self__, "storage_auto_scale", storage_auto_scale)
        if storage_threshold is not None:
            pulumi.set(__self__, "storage_threshold", storage_threshold)
        if storage_upper_bound is not None:
            pulumi.set(__self__, "storage_upper_bound", storage_upper_bound)
        if switch_time is not None:
            pulumi.set(__self__, "switch_time", switch_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_minor_version is not None:
            pulumi.set(__self__, "target_minor_version", target_minor_version)
        if tcp_connection_type is not None:
            pulumi.set(__self__, "tcp_connection_type", tcp_connection_type)
        if tde_encryption_key is not None:
            pulumi.set(__self__, "tde_encryption_key", tde_encryption_key)
        if tde_status is not None:
            pulumi.set(__self__, "tde_status", tde_status)
        if template_id_lists is not None:
            pulumi.set(__self__, "template_id_lists", template_id_lists)
        if templates is not None:
            pulumi.set(__self__, "templates", templates)
        if upgrade_db_instance_kernel_version is not None:
            warnings.warn("""Attribute `upgrade_db_instance_kernel_version` has been deprecated from 1.198.0 and use `target_minor_version` instead.""", DeprecationWarning)
            pulumi.log.warn("""upgrade_db_instance_kernel_version is deprecated: Attribute `upgrade_db_instance_kernel_version` has been deprecated from 1.198.0 and use `target_minor_version` instead.""")
        if upgrade_db_instance_kernel_version is not None:
            pulumi.set(__self__, "upgrade_db_instance_kernel_version", upgrade_db_instance_kernel_version)
        if upgrade_time is not None:
            pulumi.set(__self__, "upgrade_time", upgrade_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if whitelist_network_type is not None:
            pulumi.set(__self__, "whitelist_network_type", whitelist_network_type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)
        if zone_id_slave_a is not None:
            pulumi.set(__self__, "zone_id_slave_a", zone_id_slave_a)
        if zone_id_slave_b is not None:
            pulumi.set(__self__, "zone_id_slave_b", zone_id_slave_b)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_renew_period", value)

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The upgrade method to use. Valid values:
        - Auto: Instances are automatically upgraded to a higher minor version.
        - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.

        See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @auto_upgrade_minor_version.setter
    def auto_upgrade_minor_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_upgrade_minor_version", value)

    @_builtins.property
    @pulumi.getter(name="babelfishConfigs")
    def babelfish_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBabelfishConfigArgs']]]]:
        """
        The configuration of an ApsaraDB RDS for PostgreSQL instance for which Babelfish is enabled. See `babelfish_config` below.

        > **NOTE:** This parameter takes effect only when you create an ApsaraDB RDS for PostgreSQL instance. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
        """
        return pulumi.get(self, "babelfish_configs")

    @babelfish_configs.setter
    def babelfish_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBabelfishConfigArgs']]]]):
        pulumi.set(self, "babelfish_configs", value)

    @_builtins.property
    @pulumi.getter(name="babelfishPort")
    def babelfish_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TDS port of the instance for which Babelfish is enabled.

        > **NOTE:** This parameter applies only to ApsaraDB RDS for PostgreSQL instances. For more information about Babelfish for ApsaraDB RDS for PostgreSQL, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
        """
        return pulumi.get(self, "babelfish_port")

    @babelfish_port.setter
    def babelfish_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "babelfish_port", value)

    @_builtins.property
    @pulumi.getter(name="burstingEnabled")
    def bursting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the I/O burst feature of general
        ESSDs. Valid values:
        - true
        - false
        """
        return pulumi.get(self, "bursting_enabled")

    @bursting_enabled.setter
    def bursting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bursting_enabled", value)

    @_builtins.property
    @pulumi.getter(name="caType")
    def ca_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. **NOTE:** From version 1.231.0, `ca_type` start  support `MySQL` engine. Value range:
        - aliyun: a cloud certificate
        - custom: a custom certificate
        """
        return pulumi.get(self, "ca_type")

    @ca_type.setter
    def ca_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_type", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RDS edition of the instance. If you want to create a serverless instance, you must use this value. Valid values:
        * **Basic**: Basic Edition.
        * **HighAvailability**: High-availability Edition.
        * **AlwaysOn**: Cluster Edition.
        * **Finance**: Enterprise Edition.
        * **cluster**: MySQL Cluster Edition. (Available since v1.202.0)
        * **serverless_basic**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since v1.200.0)
        * **serverless_standard**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since v1.204.0)
        * **serverless_ha**: RDS Serverless High-availability Edition for SQL Server. (Available since v1.204.0)

        > **NOTE:** `zone_id_slave_a` and `zone_id_slave_b` can specify slave zone ids when creating the high-availability or enterprise edition instances. Meanwhile, `vswitch_id` needs to pass in the corresponding vswitch id to the slave zone by order (If the `vswitch_id` is not specified, the classic network version will be created). For example, `zone_id` = "zone-a" and `zone_id_slave_a` = "zone-c", `zone_id_slave_b` = "zone-b", then the `vswitch_id` must be "vsw-zone-a,vsw-zone-c,vsw-zone-b". Of course, you can also choose automatic allocation , for example, `zone_id` = "zone-a" and `zone_id_slave_a` = "Auto",`zone_id_slave_b` = "Auto", then the `vswitch_id` must be "vsw-zone-a,Auto,Auto". The list contains up to 2 slave zone ids , separated by commas.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="clientCaCert")
    def client_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
        """
        return pulumi.get(self, "client_ca_cert")

    @client_ca_cert.setter
    def client_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientCaEnabled")
    def client_ca_enabled(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
        - 1: enables the public key
        - 0: disables the public key
        """
        return pulumi.get(self, "client_ca_enabled")

    @client_ca_enabled.setter
    def client_ca_enabled(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_ca_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientCertRevocationList")
    def client_cert_revocation_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
        """
        return pulumi.get(self, "client_cert_revocation_list")

    @client_cert_revocation_list.setter
    def client_cert_revocation_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert_revocation_list", value)

    @_builtins.property
    @pulumi.getter(name="clientCrlEnabled")
    def client_crl_enabled(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - 1: enables the CRL
        - 0: disables the CRL
        """
        return pulumi.get(self, "client_crl_enabled")

    @client_crl_enabled.setter
    def client_crl_enabled(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_crl_enabled", value)

    @_builtins.property
    @pulumi.getter(name="coldDataEnabled")
    def cold_data_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        High performance cloud disk data archiving function switch.Example value:
        - true: Enable high-performance cloud disk data archiving function.
        - false: Disable high-performance cloud disk data archiving function.
        """
        return pulumi.get(self, "cold_data_enabled")

    @cold_data_enabled.setter
    def cold_data_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cold_data_enabled", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RDS database connection string.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private connection string prefix. If you want to update public connection string prefix, please use resource rds.Connection connection_prefix.
        > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\\|{};:'",<>/?
        """
        return pulumi.get(self, "connection_string_prefix")

    @connection_string_prefix.setter
    def connection_string_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string_prefix", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.204.1) The creation time of db instance.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceIpArrayAttribute")
    def db_instance_ip_array_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The attribute of the IP address whitelist. By default, this parameter is empty.

        > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        """
        return pulumi.get(self, "db_instance_ip_array_attribute")

    @db_instance_ip_array_attribute.setter
    def db_instance_ip_array_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_ip_array_attribute", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceIpArrayName")
    def db_instance_ip_array_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IP address whitelist. Default value: Default.

        > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        """
        return pulumi.get(self, "db_instance_ip_array_name")

    @db_instance_ip_array_name.setter
    def db_instance_ip_array_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_ip_array_name", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage type of the instance. Serverless instance, only `cloud_essd` can be selected. Valid values:
        - local_ssd: specifies to use local SSDs. This value is recommended.
        - cloud_ssd: specifies to use standard SSDs.
        - cloud_essd: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
        - general_essd: general essd.
        """
        return pulumi.get(self, "db_instance_storage_type")

    @db_instance_storage_type.setter
    def db_instance_storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_storage_type", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceType")
    def db_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.197.0) The type of db instance.
        """
        return pulumi.get(self, "db_instance_type")

    @db_instance_type.setter
    def db_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="dbIsIgnoreCase")
    def db_is_ignore_case(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether table names on the instance are case-sensitive. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "db_is_ignore_case")

    @db_is_ignore_case.setter
    def db_is_ignore_case(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "db_is_ignore_case", value)

    @_builtins.property
    @pulumi.getter(name="dbParamGroupId")
    def db_param_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Parameter template ID. Only MySQL and PostgreSQL support this parameter. If this parameter is not specified, the default parameter template is used. You can also customize a parameter template and use it here.
        """
        return pulumi.get(self, "db_param_group_id")

    @db_param_group_id.setter
    def db_param_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_param_group_id", value)

    @_builtins.property
    @pulumi.getter(name="dbTimeZone")
    def db_time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone of the instance. This parameter takes effect only when you set the `Engine` parameter to MySQL or PostgreSQL.
        - If you set the `Engine` parameter to MySQL.
        - This time zone of the instance is in UTC. Valid values: -12:59 to +13:00.
        - You can specify this parameter when the instance is equipped with local SSDs. For example, you can specify the time zone to Asia/Hong_Kong. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
        - If you set the `Engine` parameter to PostgreSQL.
        - This time zone of the instance is not in UTC. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
        - You can specify this parameter only when the instance is equipped with standard SSDs or ESSDs.

        > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
        """
        return pulumi.get(self, "db_time_zone")

    @db_time_zone.setter
    def db_time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_time_zone", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The switch of delete protection. Valid values:
        - true: delete protect.
        - false: no delete protect.

        > **NOTE:** `deletion_protection` is valid only when attribute `instance_charge_type` is set to `Postpaid` or `Serverless`, supported engine type: `MySQL`, `PostgreSQL`, `MariaDB`, `MSSQL`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance configuration type. Valid values: ["Up", "Down", "TempUpgrade", "Serverless"]
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method to update the engine version and change.  Default value: Immediate. Valid values:
        - Immediate: The change immediately takes effect.
        - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_time", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
        When the instance is PostgreSQL, this parameter can be used to enable, modify, and disable cloud disk encryption.Value range:
        - ServiceKey: Enable disk encryption using the service-managed key (Default Service CMK) automatically generated by Alibaba Cloud RDS.
        - <Key ID>: Use a custom key to enable cloud disk encryption or change the current key. For example: 494c98ce-f2b5-48ab-96ab-36c986b6****.
        - disabled: Turn off cloud disk encryption.
        > **NOTE:** This parameter is available when the instance runs MySQL.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.

        > **NOTE:** When the 'engine_version' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
        - MySQL: [ 5.5、5.6、5.7、8.0 ]
        - SQLServer: [ 2008r2、08r2_ent_ha、2012、2012_ent_ha、2012_std_ha、2012_web、2014_std_ha、2016_ent_ha、2016_std_ha、2016_web、2017_std_ha、2017_ent、2019_std_ha、2019_ent ]
        - PostgreSQL: [ 10.0、11.0、12.0、13.0、14.0、15.0 ]
        - MariaDB: [ 10.3 ]
        **Serverless**
        - MySQL: [ 5.7、8.0 ]
        - SQLServer: [ 2016_std_sl、2017_std_sl、2019_std_sl ]
        - PostgreSQL: [ 14.0 ]
        - MariaDB does not support creating serverless instances.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable forcible switching. Valid values:
        - Yes
        - No
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set it to true to make some parameter efficient when modifying them. Default to false.
        """
        return pulumi.get(self, "force_restart")

    @force_restart.setter
    def force_restart(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_restart", value)

    @_builtins.property
    @pulumi.getter(name="freshWhiteListReadins")
    def fresh_white_list_readins(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The read-only instances to which you want to synchronize the IP address whitelist.
        * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
        * If the instance is not attached with a read-only instance, this parameter is empty.
        """
        return pulumi.get(self, "fresh_white_list_readins")

    @fresh_white_list_readins.setter
    def fresh_white_list_readins(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fresh_white_list_readins", value)

    @_builtins.property
    @pulumi.getter(name="haConfig")
    def ha_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
        - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
        - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
        """
        return pulumi.get(self, "ha_config")

    @ha_config.setter
    def ha_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ha_config", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `Prepaid`, `Postpaid`, `Serverless`, Default to `Postpaid`. Currently, the resource only supports PostPaid to PrePaid. For more information, see [Overview](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/what-is-serverless?spm=a2c63.p38356.0.0.772a28cfTAGqIv).
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of DB instance. It a string of 2 to 256 characters.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        User-defined DB instance storage space. Value range:
        - [5, 2000] for MySQL/PostgreSQL HA dual node edition;
        - [20,1000] for MySQL 5.7 basic single node edition;
        - [10, 2000] for SQL Server 2008R2;
        - [20,2000] for SQL Server 2012 basic single node edition
        Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        Note: There is extra 5 GB storage for SQL Server Instance, and it is not in specified `instance_storage`.
        """
        return pulumi.get(self, "instance_storage")

    @instance_storage.setter
    def instance_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_storage", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        - To create a serverless instance, please pass the following values:
        - MySQL basic: mysql.n2.serverless.1c
        - MySQL high availability: mysql.n2.serverless.2c
        - SQLServer high availability: mssql.mem2.serverless.s2
        - PostgreSQL basic: pg.n2.serverless.1c

        > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value. When `payment_type="Serverless"` and when modifying, do not perform `instance_storage` check. Otherwise, check.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        """
        return pulumi.get(self, "maintain_time")

    @maintain_time.setter
    def maintain_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_time", value)

    @_builtins.property
    @pulumi.getter(name="manualHaTime")
    def manual_ha_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.

        > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
        """
        return pulumi.get(self, "manual_ha_time")

    @manual_ha_time.setter
    def manual_ha_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manual_ha_time", value)

    @_builtins.property
    @pulumi.getter(name="modifyMode")
    def modify_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
        - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
        - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
        - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        """
        return pulumi.get(self, "modify_mode")

    @modify_mode.setter
    def modify_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modify_mode", value)

    @_builtins.property
    @pulumi.getter(name="monitoringPeriod")
    def monitoring_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The monitoring frequency in seconds. Valid values are 5, 10, 60, 300. Defaults to 300.
        """
        return pulumi.get(self, "monitoring_period")

    @monitoring_period.setter
    def monitoring_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "monitoring_period", value)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The globally unique identifier (GUID) of the secondary instance. You can call the DescribeDBInstanceHAConfig operation to query the GUID of the secondary instance.
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_id", value)

    @_builtins.property
    @pulumi.getter(name="optimizedWrites")
    def optimized_writes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Write optimization function switch. supported engine type: `MySQL`. Valid values:
        - optimized: Enable
        - none: Disable
        """
        return pulumi.get(self, "optimized_writes")

    @optimized_writes.setter
    def optimized_writes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "optimized_writes", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]:
        """
        Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="pgBouncerEnabled")
    def pg_bouncer_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Modify the PgBouncer feature of the RDS PostgreSQL instance. Valid values:
        - true: enable.
        - false: disable.
        """
        return pulumi.get(self, "pg_bouncer_enabled")

    @pg_bouncer_enabled.setter
    def pg_bouncer_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pg_bouncer_enabled", value)

    @_builtins.property
    @pulumi.getter(name="pgHbaConfs")
    def pg_hba_confs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePgHbaConfArgs']]]]:
        """
        The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        """
        return pulumi.get(self, "pg_hba_confs")

    @pg_hba_confs.setter
    def pg_hba_confs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePgHbaConfArgs']]]]):
        pulumi.set(self, "pg_hba_confs", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private port of the database service. If you want to update public port, please use resource rds.Connection port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="recoveryModel")
    def recovery_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enable the Simple Recovery Model for an RDS SQL Server Instance.The Simple Recovery Model feature is only supported by the Basic Series of RDS SQL Server instances. Once this feature is enabled, it cannot be disabled.Valid values:
        - simple: Enable Simple Recovery.
        > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
        """
        return pulumi.get(self, "recovery_model")

    @recovery_model.setter
    def recovery_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_model", value)

    @_builtins.property
    @pulumi.getter(name="releasedKeepPolicy")
    def released_keep_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
        - None: No archived backup files are retained.
        - Lastest: Only the last archived backup file is retained.
        - All: All the archived backup files are retained.

        > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
        """
        return pulumi.get(self, "released_keep_policy")

    @released_keep_policy.setter
    def released_keep_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "released_keep_policy", value)

    @_builtins.property
    @pulumi.getter(name="replicationAcl")
    def replication_acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "replication_acl")

    @replication_acl.setter
    def replication_acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_acl", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of resource group which the DB instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Alibaba Cloud Resource Name (ARN) of the RAM role.

        > **NOTE:**  This parameter is not required when you create an instance that runs MySQL, PostgreSQL, or SQL Server. You need to only specify the RoleARN parameter to create an instance that has cloud disk encryption enabled by using the obtained key ID.
        You can configure RAM authorization to require a RAM user to enable cloud disk encryption when the RAM user is used to create an instance. If cloud disk encryption is disabled during the instance creation, the creation operation fails. To complete the configuration, you can attach the following policy to the RAM user: {"Version":"1","Statement":[{"Effect":"Deny","Action":"rds:CreateDBInstance","Resource":"*","Condition":{"StringEquals":{"rds:DiskEncryptionRequired":"false"}}}]}
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    @_utilities.deprecated("""Attribute `security_group_id` has been deprecated from 1.69.0 and use `security_group_ids` instead.""")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from 1.69.0 and use `security_group_ids` instead.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        , Available since v1.69.0) The list IDs to join ECS Security Group. At most supports three security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="securityIpMode")
    def security_ip_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
        """
        return pulumi.get(self, "security_ip_mode")

    @security_ip_mode.setter
    def security_ip_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ip_mode", value)

    @_builtins.property
    @pulumi.getter(name="securityIpType")
    def security_ip_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of IP address in the IP address whitelist.
        """
        return pulumi.get(self, "security_ip_type")

    @security_ip_type.setter
    def security_ip_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_ip_type", value)

    @_builtins.property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_ips", value)

    @_builtins.property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. **NOTE:** From version 1.231.0, `server_cert` start  support `MySQL` engine.
        """
        return pulumi.get(self, "server_cert")

    @server_cert.setter
    def server_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_cert", value)

    @_builtins.property
    @pulumi.getter(name="serverKey")
    def server_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. **NOTE:** From version 1.231.0, `server_key` start support `MySQL` engine.
        """
        return pulumi.get(self, "server_key")

    @server_key.setter
    def server_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_key", value)

    @_builtins.property
    @pulumi.getter(name="serverlessConfigs")
    def serverless_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerlessConfigArgs']]]]:
        """
        The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for Serverless instance. See `serverless_config` below.
        """
        return pulumi.get(self, "serverless_configs")

    @serverless_configs.setter
    def serverless_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerlessConfigArgs']]]]):
        pulumi.set(self, "serverless_configs", value)

    @_builtins.property
    @pulumi.getter(name="sqlCollectorConfigValue")
    def sql_collector_config_value(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
        > **NOTE:** This parameter takes effect when sql_collector_status is set to Enabled and does not take effect when sql_collector_status is set to Disabled.
        """
        return pulumi.get(self, "sql_collector_config_value")

    @sql_collector_config_value.setter
    def sql_collector_config_value(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sql_collector_config_value", value)

    @_builtins.property
    @pulumi.getter(name="sqlCollectorStatus")
    def sql_collector_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
        """
        return pulumi.get(self, "sql_collector_status")

    @sql_collector_status.setter
    def sql_collector_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_collector_status", value)

    @_builtins.property
    @pulumi.getter(name="sslAction")
    def ssl_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Actions performed on SSL functions. Valid values: 
        `Open`: turn on SSL encryption;
        `Close`: turn off SSL encryption;
        `Update`: update SSL certificate.
        See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).

        > **NOTE:** The attribute `ssl_action` will be ignored when setting `instance_charge_type = "Serverless"` for SQLServer, PostgreSQL or MariaDB.
        """
        return pulumi.get(self, "ssl_action")

    @ssl_action.setter
    def ssl_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_action", value)

    @_builtins.property
    @pulumi.getter(name="sslConnectionString")
    def ssl_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internal or public endpoint for which the server certificate needs to be created or updated.
        """
        return pulumi.get(self, "ssl_connection_string")

    @ssl_connection_string.setter
    def ssl_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="sslStatus")
    def ssl_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the SSL feature. `Yes`: SSL is turned on; `No`: SSL is turned off.
        """
        return pulumi.get(self, "ssl_status")

    @ssl_status.setter
    def ssl_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_status", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.204.1) The status of db instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageAutoScale")
    def storage_auto_scale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic storage space expansion switch. Valid values:
        - Enable
        - Disable

        > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
        """
        return pulumi.get(self, "storage_auto_scale")

    @storage_auto_scale.setter
    def storage_auto_scale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_auto_scale", value)

    @_builtins.property
    @pulumi.getter(name="storageThreshold")
    def storage_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The threshold in percentage based on which an automatic storage expansion is triggered. If the available storage reaches the threshold, ApsaraDB RDS increases the storage capacity of the instance.
        Valid values: [10, 20, 30, 40, 50].

        > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
        """
        return pulumi.get(self, "storage_threshold")

    @storage_threshold.setter
    def storage_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_threshold", value)

    @_builtins.property
    @pulumi.getter(name="storageUpperBound")
    def storage_upper_bound(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.

        > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        """
        return pulumi.get(self, "storage_upper_bound")

    @storage_upper_bound.setter
    def storage_upper_bound(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_upper_bound", value)

    @_builtins.property
    @pulumi.getter(name="switchTime")
    def switch_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `target_minor_version` is changed. The time must be in UTC.

        > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        """
        return pulumi.get(self, "switch_time")

    @switch_time.setter
    def switch_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "switch_time", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.

        Note: From 1.63.0, the tag key and value are case sensitive. Before that, they are not case sensitive.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetMinorVersion")
    def target_minor_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. You must specify the minor engine version in one of the following formats:
        - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
        - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
        - rds: The instance runs RDS Basic or High-availability Edition.
        - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
        - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
        - SQLServer: <Minor engine version>. Example: 15.0.4073.23.

        > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        """
        return pulumi.get(self, "target_minor_version")

    @target_minor_version.setter
    def target_minor_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_minor_version", value)

    @_builtins.property
    @pulumi.getter(name="tcpConnectionType")
    def tcp_connection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability check method of the instance. Valid values:
        - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
        - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        """
        return pulumi.get(self, "tcp_connection_type")

    @tcp_connection_type.setter
    def tcp_connection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tcp_connection_type", value)

    @_builtins.property
    @pulumi.getter(name="tdeEncryptionKey")
    def tde_encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the custom key.
        """
        return pulumi.get(self, "tde_encryption_key")

    @tde_encryption_key.setter
    def tde_encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tde_encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="tdeStatus")
    def tde_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TDE(Transparent Data Encryption) status. After TDE is turned on, it cannot be turned off. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).

        > **NOTE:** When creating an instance and enabling disk encryption, the value of encryption_key can only be a Key ID; it cannot be a ServiceKey. After the instance is created, you can manage the disk encryption using: ServiceKey, Key ID, or disabled.
        """
        return pulumi.get(self, "tde_status")

    @tde_status.setter
    def tde_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tde_status", value)

    @_builtins.property
    @pulumi.getter(name="templateIdLists")
    def template_id_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        Whitelist Template ID List.
        """
        return pulumi.get(self, "template_id_lists")

    @template_id_lists.setter
    def template_id_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "template_id_lists", value)

    @_builtins.property
    @pulumi.getter
    def templates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]:
        """
        (Computed, Available since v1.254.0) Whitelist Template Details.
        """
        return pulumi.get(self, "templates")

    @templates.setter
    def templates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]):
        pulumi.set(self, "templates", value)

    @_builtins.property
    @pulumi.getter(name="upgradeDbInstanceKernelVersion")
    @_utilities.deprecated("""Attribute `upgrade_db_instance_kernel_version` has been deprecated from 1.198.0 and use `target_minor_version` instead.""")
    def upgrade_db_instance_kernel_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to upgrade a minor version of the kernel. Valid values:
        - true: upgrade
        - false: not to upgrade

        > **NOTE:** Database Engine and Version: Supports only MySQL 5.7 or 8.0 instances.
        > **NOTE:** Storage Type: Supports only ESSD cloud disks and general-purpose cloud disks.
        > **NOTE:** Activation Stage: Supports only during instance creation or when enabling write optimization features for existing  (high-availability/cluster series) instances.
        """
        return pulumi.get(self, "upgrade_db_instance_kernel_version")

    @upgrade_db_instance_kernel_version.setter
    def upgrade_db_instance_kernel_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "upgrade_db_instance_kernel_version", value)

    @_builtins.property
    @pulumi.getter(name="upgradeTime")
    def upgrade_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method to update the minor engine version. Default value: Immediate. It is valid only when `target_minor_version` is changed. Valid values:
        - Immediate: The minor engine version is immediately updated.
        - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
        - SpecifyTime: The minor engine version is updated at the point in time you specify.
        """
        return pulumi.get(self, "upgrade_time")

    @upgrade_time.setter
    def upgrade_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_time", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID of the instance.


        > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="whitelistNetworkType")
    def whitelist_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the IP address whitelist. Default value: MIX. Valid values:
        - Classic: classic network in enhanced whitelist mode
        - VPC: virtual private cloud (VPC) in enhanced whitelist mode
        - MIX: standard whitelist mode

        > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        """
        return pulumi.get(self, "whitelist_network_type")

    @whitelist_network_type.setter
    def whitelist_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "whitelist_network_type", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Zone to launch the DB instance. From version 1.8.1, it supports multiple zone.
        If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
        The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `get_zones`.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneIdSlaveA")
    def zone_id_slave_a(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
        """
        return pulumi.get(self, "zone_id_slave_a")

    @zone_id_slave_a.setter
    def zone_id_slave_a(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id_slave_a", value)

    @_builtins.property
    @pulumi.getter(name="zoneIdSlaveB")
    def zone_id_slave_b(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RDS MySQL Cluster series instances support creating 1 to 2 secondary nodes at the same time when establishing a new instance. If you have this requirement, you can use this parameter to specify the availability zone for the second secondary node.
        """
        return pulumi.get(self, "zone_id_slave_b")

    @zone_id_slave_b.setter
    def zone_id_slave_b(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id_slave_b", value)


@pulumi.type_token("alicloud:rds/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 babelfish_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceBabelfishConfigArgs', 'InstanceBabelfishConfigArgsDict']]]]] = None,
                 babelfish_port: Optional[pulumi.Input[_builtins.str]] = None,
                 bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ca_type: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 client_cert_revocation_list: Optional[pulumi.Input[_builtins.str]] = None,
                 client_crl_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 cold_data_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_array_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_array_name: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_is_ignore_case: Optional[pulumi.Input[_builtins.bool]] = None,
                 db_param_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.str]] = None,
                 force_restart: Optional[pulumi.Input[_builtins.bool]] = None,
                 fresh_white_list_readins: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_config: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_time: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_ha_time: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_period: Optional[pulumi.Input[_builtins.int]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 optimized_writes: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 pg_bouncer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 pg_hba_confs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePgHbaConfArgs', 'InstancePgHbaConfArgsDict']]]]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_model: Optional[pulumi.Input[_builtins.str]] = None,
                 released_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_acl: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_ip_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 server_key: Optional[pulumi.Input[_builtins.str]] = None,
                 serverless_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerlessConfigArgs', 'InstanceServerlessConfigArgsDict']]]]] = None,
                 sql_collector_config_value: Optional[pulumi.Input[_builtins.int]] = None,
                 sql_collector_status: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_auto_scale: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_upper_bound: Optional[pulumi.Input[_builtins.int]] = None,
                 switch_time: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tde_encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tde_status: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 upgrade_db_instance_kernel_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 upgrade_time: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelist_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id_slave_a: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id_slave_b: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        RDS instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rds/instance:Instance example rm-abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl: The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
        :param pulumi.Input[_builtins.str] auto_upgrade_minor_version: The upgrade method to use. Valid values:
               - Auto: Instances are automatically upgraded to a higher minor version.
               - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.
               
               See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceBabelfishConfigArgs', 'InstanceBabelfishConfigArgsDict']]]] babelfish_configs: The configuration of an ApsaraDB RDS for PostgreSQL instance for which Babelfish is enabled. See `babelfish_config` below.
               
               > **NOTE:** This parameter takes effect only when you create an ApsaraDB RDS for PostgreSQL instance. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
        :param pulumi.Input[_builtins.str] babelfish_port: The TDS port of the instance for which Babelfish is enabled.
               
               > **NOTE:** This parameter applies only to ApsaraDB RDS for PostgreSQL instances. For more information about Babelfish for ApsaraDB RDS for PostgreSQL, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
        :param pulumi.Input[_builtins.bool] bursting_enabled: Specifies whether to enable the I/O burst feature of general
               ESSDs. Valid values:
               - true
               - false
        :param pulumi.Input[_builtins.str] ca_type: The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. **NOTE:** From version 1.231.0, `ca_type` start  support `MySQL` engine. Value range:
               - aliyun: a cloud certificate
               - custom: a custom certificate
        :param pulumi.Input[_builtins.str] category: The RDS edition of the instance. If you want to create a serverless instance, you must use this value. Valid values:
               * **Basic**: Basic Edition.
               * **HighAvailability**: High-availability Edition.
               * **AlwaysOn**: Cluster Edition.
               * **Finance**: Enterprise Edition.
               * **cluster**: MySQL Cluster Edition. (Available since v1.202.0)
               * **serverless_basic**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since v1.200.0)
               * **serverless_standard**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since v1.204.0)
               * **serverless_ha**: RDS Serverless High-availability Edition for SQL Server. (Available since v1.204.0)
               
               > **NOTE:** `zone_id_slave_a` and `zone_id_slave_b` can specify slave zone ids when creating the high-availability or enterprise edition instances. Meanwhile, `vswitch_id` needs to pass in the corresponding vswitch id to the slave zone by order (If the `vswitch_id` is not specified, the classic network version will be created). For example, `zone_id` = "zone-a" and `zone_id_slave_a` = "zone-c", `zone_id_slave_b` = "zone-b", then the `vswitch_id` must be "vsw-zone-a,vsw-zone-c,vsw-zone-b". Of course, you can also choose automatic allocation , for example, `zone_id` = "zone-a" and `zone_id_slave_a` = "Auto",`zone_id_slave_b` = "Auto", then the `vswitch_id` must be "vsw-zone-a,Auto,Auto". The list contains up to 2 slave zone ids , separated by commas.
        :param pulumi.Input[_builtins.str] client_ca_cert: The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
        :param pulumi.Input[_builtins.int] client_ca_enabled: Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
               - 1: enables the public key
               - 0: disables the public key
        :param pulumi.Input[_builtins.str] client_cert_revocation_list: The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
        :param pulumi.Input[_builtins.int] client_crl_enabled: Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - 1: enables the CRL
               - 0: disables the CRL
        :param pulumi.Input[_builtins.bool] cold_data_enabled: High performance cloud disk data archiving function switch.Example value:
               - true: Enable high-performance cloud disk data archiving function.
               - false: Disable high-performance cloud disk data archiving function.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The private connection string prefix. If you want to update public connection string prefix, please use resource rds.Connection connection_prefix.
               > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\\|{};:'",<>/?
        :param pulumi.Input[_builtins.str] db_instance_ip_array_attribute: The attribute of the IP address whitelist. By default, this parameter is empty.
               
               > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        :param pulumi.Input[_builtins.str] db_instance_ip_array_name: The name of the IP address whitelist. Default value: Default.
               
               > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        :param pulumi.Input[_builtins.str] db_instance_storage_type: The storage type of the instance. Serverless instance, only `cloud_essd` can be selected. Valid values:
               - local_ssd: specifies to use local SSDs. This value is recommended.
               - cloud_ssd: specifies to use standard SSDs.
               - cloud_essd: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
               - general_essd: general essd.
        :param pulumi.Input[_builtins.bool] db_is_ignore_case: Specifies whether table names on the instance are case-sensitive. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] db_param_group_id: Parameter template ID. Only MySQL and PostgreSQL support this parameter. If this parameter is not specified, the default parameter template is used. You can also customize a parameter template and use it here.
        :param pulumi.Input[_builtins.str] db_time_zone: The time zone of the instance. This parameter takes effect only when you set the `Engine` parameter to MySQL or PostgreSQL.
               - If you set the `Engine` parameter to MySQL.
               - This time zone of the instance is in UTC. Valid values: -12:59 to +13:00.
               - You can specify this parameter when the instance is equipped with local SSDs. For example, you can specify the time zone to Asia/Hong_Kong. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
               - If you set the `Engine` parameter to PostgreSQL.
               - This time zone of the instance is not in UTC. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
               - You can specify this parameter only when the instance is equipped with standard SSDs or ESSDs.
               
               > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
        :param pulumi.Input[_builtins.bool] deletion_protection: The switch of delete protection. Valid values:
               - true: delete protect.
               - false: no delete protect.
               
               > **NOTE:** `deletion_protection` is valid only when attribute `instance_charge_type` is set to `Postpaid` or `Serverless`, supported engine type: `MySQL`, `PostgreSQL`, `MariaDB`, `MSSQL`.
        :param pulumi.Input[_builtins.str] direction: The instance configuration type. Valid values: ["Up", "Down", "TempUpgrade", "Serverless"]
        :param pulumi.Input[_builtins.str] effective_time: The method to update the engine version and change.  Default value: Immediate. Valid values:
               - Immediate: The change immediately takes effect.
               - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        :param pulumi.Input[_builtins.str] encryption_key: The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
               When the instance is PostgreSQL, this parameter can be used to enable, modify, and disable cloud disk encryption.Value range:
               - ServiceKey: Enable disk encryption using the service-managed key (Default Service CMK) automatically generated by Alibaba Cloud RDS.
               - <Key ID>: Use a custom key to enable cloud disk encryption or change the current key. For example: 494c98ce-f2b5-48ab-96ab-36c986b6****.
               - disabled: Turn off cloud disk encryption.
               > **NOTE:** This parameter is available when the instance runs MySQL.
        :param pulumi.Input[_builtins.str] engine: Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.
               
               > **NOTE:** When the 'engine_version' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
        :param pulumi.Input[_builtins.str] engine_version: Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
               - MySQL: [ 5.5、5.6、5.7、8.0 ]
               - SQLServer: [ 2008r2、08r2_ent_ha、2012、2012_ent_ha、2012_std_ha、2012_web、2014_std_ha、2016_ent_ha、2016_std_ha、2016_web、2017_std_ha、2017_ent、2019_std_ha、2019_ent ]
               - PostgreSQL: [ 10.0、11.0、12.0、13.0、14.0、15.0 ]
               - MariaDB: [ 10.3 ]
               **Serverless**
               - MySQL: [ 5.7、8.0 ]
               - SQLServer: [ 2016_std_sl、2017_std_sl、2019_std_sl ]
               - PostgreSQL: [ 14.0 ]
               - MariaDB does not support creating serverless instances.
        :param pulumi.Input[_builtins.str] force: Specifies whether to enable forcible switching. Valid values:
               - Yes
               - No
        :param pulumi.Input[_builtins.bool] force_restart: Set it to true to make some parameter efficient when modifying them. Default to false.
        :param pulumi.Input[_builtins.str] fresh_white_list_readins: The read-only instances to which you want to synchronize the IP address whitelist.
               * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
               * If the instance is not attached with a read-only instance, this parameter is empty.
        :param pulumi.Input[_builtins.str] ha_config: The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
               - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
               - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
        :param pulumi.Input[_builtins.str] instance_charge_type: Valid values are `Prepaid`, `Postpaid`, `Serverless`, Default to `Postpaid`. Currently, the resource only supports PostPaid to PrePaid. For more information, see [Overview](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/what-is-serverless?spm=a2c63.p38356.0.0.772a28cfTAGqIv).
        :param pulumi.Input[_builtins.str] instance_name: The name of DB instance. It a string of 2 to 256 characters.
        :param pulumi.Input[_builtins.int] instance_storage: User-defined DB instance storage space. Value range:
               - [5, 2000] for MySQL/PostgreSQL HA dual node edition;
               - [20,1000] for MySQL 5.7 basic single node edition;
               - [10, 2000] for SQL Server 2008R2;
               - [20,2000] for SQL Server 2012 basic single node edition
               Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
               Note: There is extra 5 GB storage for SQL Server Instance, and it is not in specified `instance_storage`.
        :param pulumi.Input[_builtins.str] instance_type: DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
               - To create a serverless instance, please pass the following values:
               - MySQL basic: mysql.n2.serverless.1c
               - MySQL high availability: mysql.n2.serverless.2c
               - SQLServer high availability: mssql.mem2.serverless.s2
               - PostgreSQL basic: pg.n2.serverless.1c
               
               > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value. When `payment_type="Serverless"` and when modifying, do not perform `instance_storage` check. Otherwise, check.
        :param pulumi.Input[_builtins.str] maintain_time: Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        :param pulumi.Input[_builtins.str] manual_ha_time: The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
               
               > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
        :param pulumi.Input[_builtins.str] modify_mode: The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
               - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
               - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
               - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        :param pulumi.Input[_builtins.int] monitoring_period: The monitoring frequency in seconds. Valid values are 5, 10, 60, 300. Defaults to 300.
        :param pulumi.Input[_builtins.str] node_id: The globally unique identifier (GUID) of the secondary instance. You can call the DescribeDBInstanceHAConfig operation to query the GUID of the secondary instance.
        :param pulumi.Input[_builtins.str] optimized_writes: Write optimization function switch. supported engine type: `MySQL`. Valid values:
               - optimized: Enable
               - none: Disable
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]] parameters: Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.bool] pg_bouncer_enabled: Modify the PgBouncer feature of the RDS PostgreSQL instance. Valid values:
               - true: enable.
               - false: disable.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstancePgHbaConfArgs', 'InstancePgHbaConfArgsDict']]]] pg_hba_confs: The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        :param pulumi.Input[_builtins.str] port: The private port of the database service. If you want to update public port, please use resource rds.Connection port.
        :param pulumi.Input[_builtins.str] private_ip_address: The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
        :param pulumi.Input[_builtins.str] recovery_model: Enable the Simple Recovery Model for an RDS SQL Server Instance.The Simple Recovery Model feature is only supported by the Basic Series of RDS SQL Server instances. Once this feature is enabled, it cannot be disabled.Valid values:
               - simple: Enable Simple Recovery.
               > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
        :param pulumi.Input[_builtins.str] released_keep_policy: The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
               - None: No archived backup files are retained.
               - Lastest: Only the last archived backup file is retained.
               - All: All the archived backup files are retained.
               
               > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
        :param pulumi.Input[_builtins.str] replication_acl: The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of resource group which the DB instance belongs.
        :param pulumi.Input[_builtins.str] role_arn: The Alibaba Cloud Resource Name (ARN) of the RAM role.
               
               > **NOTE:**  This parameter is not required when you create an instance that runs MySQL, PostgreSQL, or SQL Server. You need to only specify the RoleARN parameter to create an instance that has cloud disk encryption enabled by using the obtained key ID.
               You can configure RAM authorization to require a RAM user to enable cloud disk encryption when the RAM user is used to create an instance. If cloud disk encryption is disabled during the instance creation, the creation operation fails. To complete the configuration, you can attach the following policy to the RAM user: {"Version":"1","Statement":[{"Effect":"Deny","Action":"rds:CreateDBInstance","Resource":"*","Condition":{"StringEquals":{"rds:DiskEncryptionRequired":"false"}}}]}
        :param pulumi.Input[_builtins.str] security_group_id: It has been deprecated from 1.69.0 and use `security_group_ids` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: , Available since v1.69.0) The list IDs to join ECS Security Group. At most supports three security groups.
        :param pulumi.Input[_builtins.str] security_ip_mode: Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
        :param pulumi.Input[_builtins.str] security_ip_type: The type of IP address in the IP address whitelist.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ips: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[_builtins.str] server_cert: The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. **NOTE:** From version 1.231.0, `server_cert` start  support `MySQL` engine.
        :param pulumi.Input[_builtins.str] server_key: The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. **NOTE:** From version 1.231.0, `server_key` start support `MySQL` engine.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerlessConfigArgs', 'InstanceServerlessConfigArgsDict']]]] serverless_configs: The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for Serverless instance. See `serverless_config` below.
        :param pulumi.Input[_builtins.int] sql_collector_config_value: The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
               > **NOTE:** This parameter takes effect when sql_collector_status is set to Enabled and does not take effect when sql_collector_status is set to Disabled.
        :param pulumi.Input[_builtins.str] sql_collector_status: The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
        :param pulumi.Input[_builtins.str] ssl_action: Actions performed on SSL functions. Valid values: 
               `Open`: turn on SSL encryption;
               `Close`: turn off SSL encryption;
               `Update`: update SSL certificate.
               See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
               
               > **NOTE:** The attribute `ssl_action` will be ignored when setting `instance_charge_type = "Serverless"` for SQLServer, PostgreSQL or MariaDB.
        :param pulumi.Input[_builtins.str] ssl_connection_string: The internal or public endpoint for which the server certificate needs to be created or updated.
        :param pulumi.Input[_builtins.str] storage_auto_scale: Automatic storage space expansion switch. Valid values:
               - Enable
               - Disable
               
               > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
        :param pulumi.Input[_builtins.int] storage_threshold: The threshold in percentage based on which an automatic storage expansion is triggered. If the available storage reaches the threshold, ApsaraDB RDS increases the storage capacity of the instance.
               Valid values: [10, 20, 30, 40, 50].
               
               > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
        :param pulumi.Input[_builtins.int] storage_upper_bound: The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.
               
               > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        :param pulumi.Input[_builtins.str] switch_time: The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `target_minor_version` is changed. The time must be in UTC.
               
               > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
               
               Note: From 1.63.0, the tag key and value are case sensitive. Before that, they are not case sensitive.
        :param pulumi.Input[_builtins.str] target_minor_version: The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. You must specify the minor engine version in one of the following formats:
               - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
               - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
               - rds: The instance runs RDS Basic or High-availability Edition.
               - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
               - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
               - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
               
               > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        :param pulumi.Input[_builtins.str] tcp_connection_type: The availability check method of the instance. Valid values:
               - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
               - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        :param pulumi.Input[_builtins.str] tde_encryption_key: The ID of the custom key.
        :param pulumi.Input[_builtins.str] tde_status: The TDE(Transparent Data Encryption) status. After TDE is turned on, it cannot be turned off. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
               
               > **NOTE:** When creating an instance and enabling disk encryption, the value of encryption_key can only be a Key ID; it cannot be a ServiceKey. After the instance is created, you can manage the disk encryption using: ServiceKey, Key ID, or disabled.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] template_id_lists: Whitelist Template ID List.
        :param pulumi.Input[_builtins.bool] upgrade_db_instance_kernel_version: Whether to upgrade a minor version of the kernel. Valid values:
               - true: upgrade
               - false: not to upgrade
               
               > **NOTE:** Database Engine and Version: Supports only MySQL 5.7 or 8.0 instances.
               > **NOTE:** Storage Type: Supports only ESSD cloud disks and general-purpose cloud disks.
               > **NOTE:** Activation Stage: Supports only during instance creation or when enabling write optimization features for existing  (high-availability/cluster series) instances.
        :param pulumi.Input[_builtins.str] upgrade_time: The method to update the minor engine version. Default value: Immediate. It is valid only when `target_minor_version` is changed. Valid values:
               - Immediate: The minor engine version is immediately updated.
               - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
               - SpecifyTime: The minor engine version is updated at the point in time you specify.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID of the instance.
               
               
               > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
        :param pulumi.Input[_builtins.str] vswitch_id: The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
        :param pulumi.Input[_builtins.str] whitelist_network_type: The network type of the IP address whitelist. Default value: MIX. Valid values:
               - Classic: classic network in enhanced whitelist mode
               - VPC: virtual private cloud (VPC) in enhanced whitelist mode
               - MIX: standard whitelist mode
               
               > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the DB instance. From version 1.8.1, it supports multiple zone.
               If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
               The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `get_zones`.
        :param pulumi.Input[_builtins.str] zone_id_slave_a: The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
        :param pulumi.Input[_builtins.str] zone_id_slave_b: RDS MySQL Cluster series instances support creating 1 to 2 secondary nodes at the same time when establishing a new instance. If you have this requirement, you can use this parameter to specify the availability zone for the second secondary node.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        RDS instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rds/instance:Instance example rm-abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 babelfish_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceBabelfishConfigArgs', 'InstanceBabelfishConfigArgsDict']]]]] = None,
                 babelfish_port: Optional[pulumi.Input[_builtins.str]] = None,
                 bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ca_type: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 client_cert_revocation_list: Optional[pulumi.Input[_builtins.str]] = None,
                 client_crl_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 cold_data_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_array_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_ip_array_name: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_is_ignore_case: Optional[pulumi.Input[_builtins.bool]] = None,
                 db_param_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.str]] = None,
                 force_restart: Optional[pulumi.Input[_builtins.bool]] = None,
                 fresh_white_list_readins: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_config: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_time: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_ha_time: Optional[pulumi.Input[_builtins.str]] = None,
                 modify_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_period: Optional[pulumi.Input[_builtins.int]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 optimized_writes: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 pg_bouncer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 pg_hba_confs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePgHbaConfArgs', 'InstancePgHbaConfArgsDict']]]]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_model: Optional[pulumi.Input[_builtins.str]] = None,
                 released_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_acl: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_ip_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 server_key: Optional[pulumi.Input[_builtins.str]] = None,
                 serverless_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerlessConfigArgs', 'InstanceServerlessConfigArgsDict']]]]] = None,
                 sql_collector_config_value: Optional[pulumi.Input[_builtins.int]] = None,
                 sql_collector_status: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_action: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_auto_scale: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_upper_bound: Optional[pulumi.Input[_builtins.int]] = None,
                 switch_time: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tde_encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tde_status: Optional[pulumi.Input[_builtins.str]] = None,
                 template_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 upgrade_db_instance_kernel_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 upgrade_time: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 whitelist_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id_slave_a: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id_slave_b: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["acl"] = acl
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["auto_upgrade_minor_version"] = auto_upgrade_minor_version
            __props__.__dict__["babelfish_configs"] = babelfish_configs
            __props__.__dict__["babelfish_port"] = babelfish_port
            __props__.__dict__["bursting_enabled"] = bursting_enabled
            __props__.__dict__["ca_type"] = ca_type
            __props__.__dict__["category"] = category
            __props__.__dict__["client_ca_cert"] = None if client_ca_cert is None else pulumi.Output.secret(client_ca_cert)
            __props__.__dict__["client_ca_enabled"] = client_ca_enabled
            __props__.__dict__["client_cert_revocation_list"] = client_cert_revocation_list
            __props__.__dict__["client_crl_enabled"] = client_crl_enabled
            __props__.__dict__["cold_data_enabled"] = cold_data_enabled
            __props__.__dict__["connection_string_prefix"] = connection_string_prefix
            __props__.__dict__["db_instance_ip_array_attribute"] = db_instance_ip_array_attribute
            __props__.__dict__["db_instance_ip_array_name"] = db_instance_ip_array_name
            __props__.__dict__["db_instance_storage_type"] = db_instance_storage_type
            __props__.__dict__["db_is_ignore_case"] = db_is_ignore_case
            __props__.__dict__["db_param_group_id"] = db_param_group_id
            __props__.__dict__["db_time_zone"] = db_time_zone
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["direction"] = direction
            __props__.__dict__["effective_time"] = effective_time
            __props__.__dict__["encryption_key"] = encryption_key
            if engine is None and not opts.urn:
                raise TypeError("Missing required property 'engine'")
            __props__.__dict__["engine"] = engine
            if engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'engine_version'")
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["force"] = force
            __props__.__dict__["force_restart"] = force_restart
            __props__.__dict__["fresh_white_list_readins"] = fresh_white_list_readins
            __props__.__dict__["ha_config"] = ha_config
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["instance_name"] = instance_name
            if instance_storage is None and not opts.urn:
                raise TypeError("Missing required property 'instance_storage'")
            __props__.__dict__["instance_storage"] = instance_storage
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["maintain_time"] = maintain_time
            __props__.__dict__["manual_ha_time"] = manual_ha_time
            __props__.__dict__["modify_mode"] = modify_mode
            __props__.__dict__["monitoring_period"] = monitoring_period
            __props__.__dict__["node_id"] = node_id
            __props__.__dict__["optimized_writes"] = optimized_writes
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["period"] = period
            __props__.__dict__["pg_bouncer_enabled"] = pg_bouncer_enabled
            __props__.__dict__["pg_hba_confs"] = pg_hba_confs
            __props__.__dict__["port"] = port
            __props__.__dict__["private_ip_address"] = private_ip_address
            __props__.__dict__["recovery_model"] = recovery_model
            __props__.__dict__["released_keep_policy"] = released_keep_policy
            __props__.__dict__["replication_acl"] = replication_acl
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["security_ip_mode"] = security_ip_mode
            __props__.__dict__["security_ip_type"] = security_ip_type
            __props__.__dict__["security_ips"] = security_ips
            __props__.__dict__["server_cert"] = None if server_cert is None else pulumi.Output.secret(server_cert)
            __props__.__dict__["server_key"] = server_key
            __props__.__dict__["serverless_configs"] = serverless_configs
            __props__.__dict__["sql_collector_config_value"] = sql_collector_config_value
            __props__.__dict__["sql_collector_status"] = sql_collector_status
            __props__.__dict__["ssl_action"] = ssl_action
            __props__.__dict__["ssl_connection_string"] = ssl_connection_string
            __props__.__dict__["storage_auto_scale"] = storage_auto_scale
            __props__.__dict__["storage_threshold"] = storage_threshold
            __props__.__dict__["storage_upper_bound"] = storage_upper_bound
            __props__.__dict__["switch_time"] = switch_time
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_minor_version"] = target_minor_version
            __props__.__dict__["tcp_connection_type"] = tcp_connection_type
            __props__.__dict__["tde_encryption_key"] = tde_encryption_key
            __props__.__dict__["tde_status"] = tde_status
            __props__.__dict__["template_id_lists"] = template_id_lists
            __props__.__dict__["upgrade_db_instance_kernel_version"] = upgrade_db_instance_kernel_version
            __props__.__dict__["upgrade_time"] = upgrade_time
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["whitelist_network_type"] = whitelist_network_type
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["zone_id_slave_a"] = zone_id_slave_a
            __props__.__dict__["zone_id_slave_b"] = zone_id_slave_b
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["db_instance_type"] = None
            __props__.__dict__["ssl_status"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["templates"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientCaCert", "serverCert"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'alicloud:rds/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
            babelfish_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceBabelfishConfigArgs', 'InstanceBabelfishConfigArgsDict']]]]] = None,
            babelfish_port: Optional[pulumi.Input[_builtins.str]] = None,
            bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ca_type: Optional[pulumi.Input[_builtins.str]] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            client_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
            client_ca_enabled: Optional[pulumi.Input[_builtins.int]] = None,
            client_cert_revocation_list: Optional[pulumi.Input[_builtins.str]] = None,
            client_crl_enabled: Optional[pulumi.Input[_builtins.int]] = None,
            cold_data_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_ip_array_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_ip_array_name: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_is_ignore_case: Optional[pulumi.Input[_builtins.bool]] = None,
            db_param_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            direction: Optional[pulumi.Input[_builtins.str]] = None,
            effective_time: Optional[pulumi.Input[_builtins.str]] = None,
            encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            force: Optional[pulumi.Input[_builtins.str]] = None,
            force_restart: Optional[pulumi.Input[_builtins.bool]] = None,
            fresh_white_list_readins: Optional[pulumi.Input[_builtins.str]] = None,
            ha_config: Optional[pulumi.Input[_builtins.str]] = None,
            instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_storage: Optional[pulumi.Input[_builtins.int]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_time: Optional[pulumi.Input[_builtins.str]] = None,
            manual_ha_time: Optional[pulumi.Input[_builtins.str]] = None,
            modify_mode: Optional[pulumi.Input[_builtins.str]] = None,
            monitoring_period: Optional[pulumi.Input[_builtins.int]] = None,
            node_id: Optional[pulumi.Input[_builtins.str]] = None,
            optimized_writes: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            pg_bouncer_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            pg_hba_confs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePgHbaConfArgs', 'InstancePgHbaConfArgsDict']]]]] = None,
            port: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_model: Optional[pulumi.Input[_builtins.str]] = None,
            released_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
            replication_acl: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            security_ip_mode: Optional[pulumi.Input[_builtins.str]] = None,
            security_ip_type: Optional[pulumi.Input[_builtins.str]] = None,
            security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            server_cert: Optional[pulumi.Input[_builtins.str]] = None,
            server_key: Optional[pulumi.Input[_builtins.str]] = None,
            serverless_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerlessConfigArgs', 'InstanceServerlessConfigArgsDict']]]]] = None,
            sql_collector_config_value: Optional[pulumi.Input[_builtins.int]] = None,
            sql_collector_status: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_action: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_status: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_auto_scale: Optional[pulumi.Input[_builtins.str]] = None,
            storage_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            storage_upper_bound: Optional[pulumi.Input[_builtins.int]] = None,
            switch_time: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
            tcp_connection_type: Optional[pulumi.Input[_builtins.str]] = None,
            tde_encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
            tde_status: Optional[pulumi.Input[_builtins.str]] = None,
            template_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            templates: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
            upgrade_db_instance_kernel_version: Optional[pulumi.Input[_builtins.bool]] = None,
            upgrade_time: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            whitelist_network_type: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id_slave_a: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id_slave_b: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl: The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
        :param pulumi.Input[_builtins.int] auto_renew_period: Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
        :param pulumi.Input[_builtins.str] auto_upgrade_minor_version: The upgrade method to use. Valid values:
               - Auto: Instances are automatically upgraded to a higher minor version.
               - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.
               
               See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceBabelfishConfigArgs', 'InstanceBabelfishConfigArgsDict']]]] babelfish_configs: The configuration of an ApsaraDB RDS for PostgreSQL instance for which Babelfish is enabled. See `babelfish_config` below.
               
               > **NOTE:** This parameter takes effect only when you create an ApsaraDB RDS for PostgreSQL instance. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
        :param pulumi.Input[_builtins.str] babelfish_port: The TDS port of the instance for which Babelfish is enabled.
               
               > **NOTE:** This parameter applies only to ApsaraDB RDS for PostgreSQL instances. For more information about Babelfish for ApsaraDB RDS for PostgreSQL, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
        :param pulumi.Input[_builtins.bool] bursting_enabled: Specifies whether to enable the I/O burst feature of general
               ESSDs. Valid values:
               - true
               - false
        :param pulumi.Input[_builtins.str] ca_type: The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. **NOTE:** From version 1.231.0, `ca_type` start  support `MySQL` engine. Value range:
               - aliyun: a cloud certificate
               - custom: a custom certificate
        :param pulumi.Input[_builtins.str] category: The RDS edition of the instance. If you want to create a serverless instance, you must use this value. Valid values:
               * **Basic**: Basic Edition.
               * **HighAvailability**: High-availability Edition.
               * **AlwaysOn**: Cluster Edition.
               * **Finance**: Enterprise Edition.
               * **cluster**: MySQL Cluster Edition. (Available since v1.202.0)
               * **serverless_basic**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since v1.200.0)
               * **serverless_standard**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since v1.204.0)
               * **serverless_ha**: RDS Serverless High-availability Edition for SQL Server. (Available since v1.204.0)
               
               > **NOTE:** `zone_id_slave_a` and `zone_id_slave_b` can specify slave zone ids when creating the high-availability or enterprise edition instances. Meanwhile, `vswitch_id` needs to pass in the corresponding vswitch id to the slave zone by order (If the `vswitch_id` is not specified, the classic network version will be created). For example, `zone_id` = "zone-a" and `zone_id_slave_a` = "zone-c", `zone_id_slave_b` = "zone-b", then the `vswitch_id` must be "vsw-zone-a,vsw-zone-c,vsw-zone-b". Of course, you can also choose automatic allocation , for example, `zone_id` = "zone-a" and `zone_id_slave_a` = "Auto",`zone_id_slave_b` = "Auto", then the `vswitch_id` must be "vsw-zone-a,Auto,Auto". The list contains up to 2 slave zone ids , separated by commas.
        :param pulumi.Input[_builtins.str] client_ca_cert: The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
        :param pulumi.Input[_builtins.int] client_ca_enabled: Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
               - 1: enables the public key
               - 0: disables the public key
        :param pulumi.Input[_builtins.str] client_cert_revocation_list: The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
        :param pulumi.Input[_builtins.int] client_crl_enabled: Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - 1: enables the CRL
               - 0: disables the CRL
        :param pulumi.Input[_builtins.bool] cold_data_enabled: High performance cloud disk data archiving function switch.Example value:
               - true: Enable high-performance cloud disk data archiving function.
               - false: Disable high-performance cloud disk data archiving function.
        :param pulumi.Input[_builtins.str] connection_string: RDS database connection string.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The private connection string prefix. If you want to update public connection string prefix, please use resource rds.Connection connection_prefix.
               > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\\|{};:'",<>/?
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.204.1) The creation time of db instance.
        :param pulumi.Input[_builtins.str] db_instance_ip_array_attribute: The attribute of the IP address whitelist. By default, this parameter is empty.
               
               > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        :param pulumi.Input[_builtins.str] db_instance_ip_array_name: The name of the IP address whitelist. Default value: Default.
               
               > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        :param pulumi.Input[_builtins.str] db_instance_storage_type: The storage type of the instance. Serverless instance, only `cloud_essd` can be selected. Valid values:
               - local_ssd: specifies to use local SSDs. This value is recommended.
               - cloud_ssd: specifies to use standard SSDs.
               - cloud_essd: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
               - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
               - general_essd: general essd.
        :param pulumi.Input[_builtins.str] db_instance_type: (Available since v1.197.0) The type of db instance.
        :param pulumi.Input[_builtins.bool] db_is_ignore_case: Specifies whether table names on the instance are case-sensitive. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] db_param_group_id: Parameter template ID. Only MySQL and PostgreSQL support this parameter. If this parameter is not specified, the default parameter template is used. You can also customize a parameter template and use it here.
        :param pulumi.Input[_builtins.str] db_time_zone: The time zone of the instance. This parameter takes effect only when you set the `Engine` parameter to MySQL or PostgreSQL.
               - If you set the `Engine` parameter to MySQL.
               - This time zone of the instance is in UTC. Valid values: -12:59 to +13:00.
               - You can specify this parameter when the instance is equipped with local SSDs. For example, you can specify the time zone to Asia/Hong_Kong. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
               - If you set the `Engine` parameter to PostgreSQL.
               - This time zone of the instance is not in UTC. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
               - You can specify this parameter only when the instance is equipped with standard SSDs or ESSDs.
               
               > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
        :param pulumi.Input[_builtins.bool] deletion_protection: The switch of delete protection. Valid values:
               - true: delete protect.
               - false: no delete protect.
               
               > **NOTE:** `deletion_protection` is valid only when attribute `instance_charge_type` is set to `Postpaid` or `Serverless`, supported engine type: `MySQL`, `PostgreSQL`, `MariaDB`, `MSSQL`.
        :param pulumi.Input[_builtins.str] direction: The instance configuration type. Valid values: ["Up", "Down", "TempUpgrade", "Serverless"]
        :param pulumi.Input[_builtins.str] effective_time: The method to update the engine version and change.  Default value: Immediate. Valid values:
               - Immediate: The change immediately takes effect.
               - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        :param pulumi.Input[_builtins.str] encryption_key: The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
               When the instance is PostgreSQL, this parameter can be used to enable, modify, and disable cloud disk encryption.Value range:
               - ServiceKey: Enable disk encryption using the service-managed key (Default Service CMK) automatically generated by Alibaba Cloud RDS.
               - <Key ID>: Use a custom key to enable cloud disk encryption or change the current key. For example: 494c98ce-f2b5-48ab-96ab-36c986b6****.
               - disabled: Turn off cloud disk encryption.
               > **NOTE:** This parameter is available when the instance runs MySQL.
        :param pulumi.Input[_builtins.str] engine: Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.
               
               > **NOTE:** When the 'engine_version' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
        :param pulumi.Input[_builtins.str] engine_version: Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
               - MySQL: [ 5.5、5.6、5.7、8.0 ]
               - SQLServer: [ 2008r2、08r2_ent_ha、2012、2012_ent_ha、2012_std_ha、2012_web、2014_std_ha、2016_ent_ha、2016_std_ha、2016_web、2017_std_ha、2017_ent、2019_std_ha、2019_ent ]
               - PostgreSQL: [ 10.0、11.0、12.0、13.0、14.0、15.0 ]
               - MariaDB: [ 10.3 ]
               **Serverless**
               - MySQL: [ 5.7、8.0 ]
               - SQLServer: [ 2016_std_sl、2017_std_sl、2019_std_sl ]
               - PostgreSQL: [ 14.0 ]
               - MariaDB does not support creating serverless instances.
        :param pulumi.Input[_builtins.str] force: Specifies whether to enable forcible switching. Valid values:
               - Yes
               - No
        :param pulumi.Input[_builtins.bool] force_restart: Set it to true to make some parameter efficient when modifying them. Default to false.
        :param pulumi.Input[_builtins.str] fresh_white_list_readins: The read-only instances to which you want to synchronize the IP address whitelist.
               * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
               * If the instance is not attached with a read-only instance, this parameter is empty.
        :param pulumi.Input[_builtins.str] ha_config: The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
               - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
               - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
        :param pulumi.Input[_builtins.str] instance_charge_type: Valid values are `Prepaid`, `Postpaid`, `Serverless`, Default to `Postpaid`. Currently, the resource only supports PostPaid to PrePaid. For more information, see [Overview](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/what-is-serverless?spm=a2c63.p38356.0.0.772a28cfTAGqIv).
        :param pulumi.Input[_builtins.str] instance_name: The name of DB instance. It a string of 2 to 256 characters.
        :param pulumi.Input[_builtins.int] instance_storage: User-defined DB instance storage space. Value range:
               - [5, 2000] for MySQL/PostgreSQL HA dual node edition;
               - [20,1000] for MySQL 5.7 basic single node edition;
               - [10, 2000] for SQL Server 2008R2;
               - [20,2000] for SQL Server 2012 basic single node edition
               Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
               Note: There is extra 5 GB storage for SQL Server Instance, and it is not in specified `instance_storage`.
        :param pulumi.Input[_builtins.str] instance_type: DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
               - To create a serverless instance, please pass the following values:
               - MySQL basic: mysql.n2.serverless.1c
               - MySQL high availability: mysql.n2.serverless.2c
               - SQLServer high availability: mssql.mem2.serverless.s2
               - PostgreSQL basic: pg.n2.serverless.1c
               
               > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value. When `payment_type="Serverless"` and when modifying, do not perform `instance_storage` check. Otherwise, check.
        :param pulumi.Input[_builtins.str] maintain_time: Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        :param pulumi.Input[_builtins.str] manual_ha_time: The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
               
               > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
        :param pulumi.Input[_builtins.str] modify_mode: The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
               - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
               - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
               - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        :param pulumi.Input[_builtins.int] monitoring_period: The monitoring frequency in seconds. Valid values are 5, 10, 60, 300. Defaults to 300.
        :param pulumi.Input[_builtins.str] node_id: The globally unique identifier (GUID) of the secondary instance. You can call the DescribeDBInstanceHAConfig operation to query the GUID of the secondary instance.
        :param pulumi.Input[_builtins.str] optimized_writes: Write optimization function switch. supported engine type: `MySQL`. Valid values:
               - optimized: Enable
               - none: Disable
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]] parameters: Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.bool] pg_bouncer_enabled: Modify the PgBouncer feature of the RDS PostgreSQL instance. Valid values:
               - true: enable.
               - false: disable.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstancePgHbaConfArgs', 'InstancePgHbaConfArgsDict']]]] pg_hba_confs: The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        :param pulumi.Input[_builtins.str] port: The private port of the database service. If you want to update public port, please use resource rds.Connection port.
        :param pulumi.Input[_builtins.str] private_ip_address: The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
        :param pulumi.Input[_builtins.str] recovery_model: Enable the Simple Recovery Model for an RDS SQL Server Instance.The Simple Recovery Model feature is only supported by the Basic Series of RDS SQL Server instances. Once this feature is enabled, it cannot be disabled.Valid values:
               - simple: Enable Simple Recovery.
               > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
        :param pulumi.Input[_builtins.str] released_keep_policy: The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
               - None: No archived backup files are retained.
               - Lastest: Only the last archived backup file is retained.
               - All: All the archived backup files are retained.
               
               > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
        :param pulumi.Input[_builtins.str] replication_acl: The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
               - cert
               - perfer
               - verify-ca
               - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of resource group which the DB instance belongs.
        :param pulumi.Input[_builtins.str] role_arn: The Alibaba Cloud Resource Name (ARN) of the RAM role.
               
               > **NOTE:**  This parameter is not required when you create an instance that runs MySQL, PostgreSQL, or SQL Server. You need to only specify the RoleARN parameter to create an instance that has cloud disk encryption enabled by using the obtained key ID.
               You can configure RAM authorization to require a RAM user to enable cloud disk encryption when the RAM user is used to create an instance. If cloud disk encryption is disabled during the instance creation, the creation operation fails. To complete the configuration, you can attach the following policy to the RAM user: {"Version":"1","Statement":[{"Effect":"Deny","Action":"rds:CreateDBInstance","Resource":"*","Condition":{"StringEquals":{"rds:DiskEncryptionRequired":"false"}}}]}
        :param pulumi.Input[_builtins.str] security_group_id: It has been deprecated from 1.69.0 and use `security_group_ids` instead.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: , Available since v1.69.0) The list IDs to join ECS Security Group. At most supports three security groups.
        :param pulumi.Input[_builtins.str] security_ip_mode: Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
        :param pulumi.Input[_builtins.str] security_ip_type: The type of IP address in the IP address whitelist.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ips: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[_builtins.str] server_cert: The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. **NOTE:** From version 1.231.0, `server_cert` start  support `MySQL` engine.
        :param pulumi.Input[_builtins.str] server_key: The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. **NOTE:** From version 1.231.0, `server_key` start support `MySQL` engine.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerlessConfigArgs', 'InstanceServerlessConfigArgsDict']]]] serverless_configs: The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for Serverless instance. See `serverless_config` below.
        :param pulumi.Input[_builtins.int] sql_collector_config_value: The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
               > **NOTE:** This parameter takes effect when sql_collector_status is set to Enabled and does not take effect when sql_collector_status is set to Disabled.
        :param pulumi.Input[_builtins.str] sql_collector_status: The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
        :param pulumi.Input[_builtins.str] ssl_action: Actions performed on SSL functions. Valid values: 
               `Open`: turn on SSL encryption;
               `Close`: turn off SSL encryption;
               `Update`: update SSL certificate.
               See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).
               
               > **NOTE:** The attribute `ssl_action` will be ignored when setting `instance_charge_type = "Serverless"` for SQLServer, PostgreSQL or MariaDB.
        :param pulumi.Input[_builtins.str] ssl_connection_string: The internal or public endpoint for which the server certificate needs to be created or updated.
        :param pulumi.Input[_builtins.str] ssl_status: Status of the SSL feature. `Yes`: SSL is turned on; `No`: SSL is turned off.
        :param pulumi.Input[_builtins.str] status: (Available since v1.204.1) The status of db instance.
        :param pulumi.Input[_builtins.str] storage_auto_scale: Automatic storage space expansion switch. Valid values:
               - Enable
               - Disable
               
               > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
        :param pulumi.Input[_builtins.int] storage_threshold: The threshold in percentage based on which an automatic storage expansion is triggered. If the available storage reaches the threshold, ApsaraDB RDS increases the storage capacity of the instance.
               Valid values: [10, 20, 30, 40, 50].
               
               > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
        :param pulumi.Input[_builtins.int] storage_upper_bound: The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.
               
               > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        :param pulumi.Input[_builtins.str] switch_time: The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `target_minor_version` is changed. The time must be in UTC.
               
               > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
               
               Note: From 1.63.0, the tag key and value are case sensitive. Before that, they are not case sensitive.
        :param pulumi.Input[_builtins.str] target_minor_version: The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. You must specify the minor engine version in one of the following formats:
               - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
               - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
               - rds: The instance runs RDS Basic or High-availability Edition.
               - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
               - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
               - SQLServer: <Minor engine version>. Example: 15.0.4073.23.
               
               > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        :param pulumi.Input[_builtins.str] tcp_connection_type: The availability check method of the instance. Valid values:
               - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
               - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        :param pulumi.Input[_builtins.str] tde_encryption_key: The ID of the custom key.
        :param pulumi.Input[_builtins.str] tde_status: The TDE(Transparent Data Encryption) status. After TDE is turned on, it cannot be turned off. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).
               
               > **NOTE:** When creating an instance and enabling disk encryption, the value of encryption_key can only be a Key ID; it cannot be a ServiceKey. After the instance is created, you can manage the disk encryption using: ServiceKey, Key ID, or disabled.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] template_id_lists: Whitelist Template ID List.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]] templates: (Computed, Available since v1.254.0) Whitelist Template Details.
        :param pulumi.Input[_builtins.bool] upgrade_db_instance_kernel_version: Whether to upgrade a minor version of the kernel. Valid values:
               - true: upgrade
               - false: not to upgrade
               
               > **NOTE:** Database Engine and Version: Supports only MySQL 5.7 or 8.0 instances.
               > **NOTE:** Storage Type: Supports only ESSD cloud disks and general-purpose cloud disks.
               > **NOTE:** Activation Stage: Supports only during instance creation or when enabling write optimization features for existing  (high-availability/cluster series) instances.
        :param pulumi.Input[_builtins.str] upgrade_time: The method to update the minor engine version. Default value: Immediate. It is valid only when `target_minor_version` is changed. Valid values:
               - Immediate: The minor engine version is immediately updated.
               - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
               - SpecifyTime: The minor engine version is updated at the point in time you specify.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID of the instance.
               
               
               > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
        :param pulumi.Input[_builtins.str] vswitch_id: The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
        :param pulumi.Input[_builtins.str] whitelist_network_type: The network type of the IP address whitelist. Default value: MIX. Valid values:
               - Classic: classic network in enhanced whitelist mode
               - VPC: virtual private cloud (VPC) in enhanced whitelist mode
               - MIX: standard whitelist mode
               
               > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the DB instance. From version 1.8.1, it supports multiple zone.
               If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
               The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `get_zones`.
        :param pulumi.Input[_builtins.str] zone_id_slave_a: The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
        :param pulumi.Input[_builtins.str] zone_id_slave_b: RDS MySQL Cluster series instances support creating 1 to 2 secondary nodes at the same time when establishing a new instance. If you have this requirement, you can use this parameter to specify the availability zone for the second secondary node.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["acl"] = acl
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["auto_upgrade_minor_version"] = auto_upgrade_minor_version
        __props__.__dict__["babelfish_configs"] = babelfish_configs
        __props__.__dict__["babelfish_port"] = babelfish_port
        __props__.__dict__["bursting_enabled"] = bursting_enabled
        __props__.__dict__["ca_type"] = ca_type
        __props__.__dict__["category"] = category
        __props__.__dict__["client_ca_cert"] = client_ca_cert
        __props__.__dict__["client_ca_enabled"] = client_ca_enabled
        __props__.__dict__["client_cert_revocation_list"] = client_cert_revocation_list
        __props__.__dict__["client_crl_enabled"] = client_crl_enabled
        __props__.__dict__["cold_data_enabled"] = cold_data_enabled
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["connection_string_prefix"] = connection_string_prefix
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["db_instance_ip_array_attribute"] = db_instance_ip_array_attribute
        __props__.__dict__["db_instance_ip_array_name"] = db_instance_ip_array_name
        __props__.__dict__["db_instance_storage_type"] = db_instance_storage_type
        __props__.__dict__["db_instance_type"] = db_instance_type
        __props__.__dict__["db_is_ignore_case"] = db_is_ignore_case
        __props__.__dict__["db_param_group_id"] = db_param_group_id
        __props__.__dict__["db_time_zone"] = db_time_zone
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["direction"] = direction
        __props__.__dict__["effective_time"] = effective_time
        __props__.__dict__["encryption_key"] = encryption_key
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["force"] = force
        __props__.__dict__["force_restart"] = force_restart
        __props__.__dict__["fresh_white_list_readins"] = fresh_white_list_readins
        __props__.__dict__["ha_config"] = ha_config
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_storage"] = instance_storage
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["maintain_time"] = maintain_time
        __props__.__dict__["manual_ha_time"] = manual_ha_time
        __props__.__dict__["modify_mode"] = modify_mode
        __props__.__dict__["monitoring_period"] = monitoring_period
        __props__.__dict__["node_id"] = node_id
        __props__.__dict__["optimized_writes"] = optimized_writes
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["period"] = period
        __props__.__dict__["pg_bouncer_enabled"] = pg_bouncer_enabled
        __props__.__dict__["pg_hba_confs"] = pg_hba_confs
        __props__.__dict__["port"] = port
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["recovery_model"] = recovery_model
        __props__.__dict__["released_keep_policy"] = released_keep_policy
        __props__.__dict__["replication_acl"] = replication_acl
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["security_ip_mode"] = security_ip_mode
        __props__.__dict__["security_ip_type"] = security_ip_type
        __props__.__dict__["security_ips"] = security_ips
        __props__.__dict__["server_cert"] = server_cert
        __props__.__dict__["server_key"] = server_key
        __props__.__dict__["serverless_configs"] = serverless_configs
        __props__.__dict__["sql_collector_config_value"] = sql_collector_config_value
        __props__.__dict__["sql_collector_status"] = sql_collector_status
        __props__.__dict__["ssl_action"] = ssl_action
        __props__.__dict__["ssl_connection_string"] = ssl_connection_string
        __props__.__dict__["ssl_status"] = ssl_status
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_auto_scale"] = storage_auto_scale
        __props__.__dict__["storage_threshold"] = storage_threshold
        __props__.__dict__["storage_upper_bound"] = storage_upper_bound
        __props__.__dict__["switch_time"] = switch_time
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_minor_version"] = target_minor_version
        __props__.__dict__["tcp_connection_type"] = tcp_connection_type
        __props__.__dict__["tde_encryption_key"] = tde_encryption_key
        __props__.__dict__["tde_status"] = tde_status
        __props__.__dict__["template_id_lists"] = template_id_lists
        __props__.__dict__["templates"] = templates
        __props__.__dict__["upgrade_db_instance_kernel_version"] = upgrade_db_instance_kernel_version
        __props__.__dict__["upgrade_time"] = upgrade_time
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["whitelist_network_type"] = whitelist_network_type
        __props__.__dict__["zone_id"] = zone_id
        __props__.__dict__["zone_id_slave_a"] = zone_id_slave_a
        __props__.__dict__["zone_id_slave_b"] = zone_id_slave_b
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> pulumi.Output[_builtins.str]:
        """
        The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to renewal a DB instance automatically or not. It is valid when instance_charge_type is `PrePaid`. Default to `false`.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Auto-renewal period of an instance, in the unit of the month. It is valid when instance_charge_type is `PrePaid`. Valid value:[1~12], Default to 1.
        """
        return pulumi.get(self, "auto_renew_period")

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> pulumi.Output[_builtins.str]:
        """
        The upgrade method to use. Valid values:
        - Auto: Instances are automatically upgraded to a higher minor version.
        - Manual: Instances are forcibly upgraded to a higher minor version when the current version is unpublished.

        See more [details and limitation](https://www.alibabacloud.com/help/doc-detail/123605.htm).
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @_builtins.property
    @pulumi.getter(name="babelfishConfigs")
    def babelfish_configs(self) -> pulumi.Output[Sequence['outputs.InstanceBabelfishConfig']]:
        """
        The configuration of an ApsaraDB RDS for PostgreSQL instance for which Babelfish is enabled. See `babelfish_config` below.

        > **NOTE:** This parameter takes effect only when you create an ApsaraDB RDS for PostgreSQL instance. For more information, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
        """
        return pulumi.get(self, "babelfish_configs")

    @_builtins.property
    @pulumi.getter(name="babelfishPort")
    def babelfish_port(self) -> pulumi.Output[_builtins.str]:
        """
        The TDS port of the instance for which Babelfish is enabled.

        > **NOTE:** This parameter applies only to ApsaraDB RDS for PostgreSQL instances. For more information about Babelfish for ApsaraDB RDS for PostgreSQL, see [Introduction to Babelfish](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/babelfish-for-pg).
        """
        return pulumi.get(self, "babelfish_port")

    @_builtins.property
    @pulumi.getter(name="burstingEnabled")
    def bursting_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the I/O burst feature of general
        ESSDs. Valid values:
        - true
        - false
        """
        return pulumi.get(self, "bursting_enabled")

    @_builtins.property
    @pulumi.getter(name="caType")
    def ca_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the SSLEnabled parameter to 1, the default value of this parameter is aliyun. **NOTE:** From version 1.231.0, `ca_type` start  support `MySQL` engine. Value range:
        - aliyun: a cloud certificate
        - custom: a custom certificate
        """
        return pulumi.get(self, "ca_type")

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        The RDS edition of the instance. If you want to create a serverless instance, you must use this value. Valid values:
        * **Basic**: Basic Edition.
        * **HighAvailability**: High-availability Edition.
        * **AlwaysOn**: Cluster Edition.
        * **Finance**: Enterprise Edition.
        * **cluster**: MySQL Cluster Edition. (Available since v1.202.0)
        * **serverless_basic**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since v1.200.0)
        * **serverless_standard**: RDS Serverless Basic Edition. This edition is available only for instances that run MySQL and PostgreSQL. (Available since v1.204.0)
        * **serverless_ha**: RDS Serverless High-availability Edition for SQL Server. (Available since v1.204.0)

        > **NOTE:** `zone_id_slave_a` and `zone_id_slave_b` can specify slave zone ids when creating the high-availability or enterprise edition instances. Meanwhile, `vswitch_id` needs to pass in the corresponding vswitch id to the slave zone by order (If the `vswitch_id` is not specified, the classic network version will be created). For example, `zone_id` = "zone-a" and `zone_id_slave_a` = "zone-c", `zone_id_slave_b` = "zone-b", then the `vswitch_id` must be "vsw-zone-a,vsw-zone-c,vsw-zone-b". Of course, you can also choose automatic allocation , for example, `zone_id` = "zone-a" and `zone_id_slave_a` = "Auto",`zone_id_slave_b` = "Auto", then the `vswitch_id` must be "vsw-zone-a,Auto,Auto". The list contains up to 2 slave zone ids , separated by commas.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="clientCaCert")
    def client_ca_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCAEbabled parameter to 1, you must also specify this parameter.
        """
        return pulumi.get(self, "client_ca_cert")

    @_builtins.property
    @pulumi.getter(name="clientCaEnabled")
    def client_ca_enabled(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies whether to enable the public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
        - 1: enables the public key
        - 0: disables the public key
        """
        return pulumi.get(self, "client_ca_enabled")

    @_builtins.property
    @pulumi.getter(name="clientCertRevocationList")
    def client_cert_revocation_list(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The CRL that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. If you set the ClientCrlEnabled parameter to 1, you must also specify this parameter.
        """
        return pulumi.get(self, "client_cert_revocation_list")

    @_builtins.property
    @pulumi.getter(name="clientCrlEnabled")
    def client_crl_enabled(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies whether to enable a certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - 1: enables the CRL
        - 0: disables the CRL
        """
        return pulumi.get(self, "client_crl_enabled")

    @_builtins.property
    @pulumi.getter(name="coldDataEnabled")
    def cold_data_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        High performance cloud disk data archiving function switch.Example value:
        - true: Enable high-performance cloud disk data archiving function.
        - false: Disable high-performance cloud disk data archiving function.
        """
        return pulumi.get(self, "cold_data_enabled")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        RDS database connection string.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The private connection string prefix. If you want to update public connection string prefix, please use resource rds.Connection connection_prefix.
        > **NOTE:** The prefix must be 8 to 64 characters in length and can contain letters, digits, and hyphens (-). It cannot contain Chinese characters and special characters ~!#%^&*=+\\|{};:'",<>/?
        """
        return pulumi.get(self, "connection_string_prefix")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.204.1) The creation time of db instance.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dbInstanceIpArrayAttribute")
    def db_instance_ip_array_attribute(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The attribute of the IP address whitelist. By default, this parameter is empty.

        > **NOTE:** The IP address whitelists that have the hidden attribute are not displayed in the ApsaraDB RDS console. These IP address whitelists are used to access Alibaba Cloud services, such as Data Transmission Service (DTS).
        """
        return pulumi.get(self, "db_instance_ip_array_attribute")

    @_builtins.property
    @pulumi.getter(name="dbInstanceIpArrayName")
    def db_instance_ip_array_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the IP address whitelist. Default value: Default.

        > **NOTE:** A maximum of 200 IP address whitelists can be configured for each instance.
        """
        return pulumi.get(self, "db_instance_ip_array_name")

    @_builtins.property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> pulumi.Output[_builtins.str]:
        """
        The storage type of the instance. Serverless instance, only `cloud_essd` can be selected. Valid values:
        - local_ssd: specifies to use local SSDs. This value is recommended.
        - cloud_ssd: specifies to use standard SSDs.
        - cloud_essd: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd2: specifies to use enhanced SSDs (ESSDs).
        - cloud_essd3: specifies to use enhanced SSDs (ESSDs).
        - general_essd: general essd.
        """
        return pulumi.get(self, "db_instance_storage_type")

    @_builtins.property
    @pulumi.getter(name="dbInstanceType")
    def db_instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.197.0) The type of db instance.
        """
        return pulumi.get(self, "db_instance_type")

    @_builtins.property
    @pulumi.getter(name="dbIsIgnoreCase")
    def db_is_ignore_case(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether table names on the instance are case-sensitive. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "db_is_ignore_case")

    @_builtins.property
    @pulumi.getter(name="dbParamGroupId")
    def db_param_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Parameter template ID. Only MySQL and PostgreSQL support this parameter. If this parameter is not specified, the default parameter template is used. You can also customize a parameter template and use it here.
        """
        return pulumi.get(self, "db_param_group_id")

    @_builtins.property
    @pulumi.getter(name="dbTimeZone")
    def db_time_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The time zone of the instance. This parameter takes effect only when you set the `Engine` parameter to MySQL or PostgreSQL.
        - If you set the `Engine` parameter to MySQL.
        - This time zone of the instance is in UTC. Valid values: -12:59 to +13:00.
        - You can specify this parameter when the instance is equipped with local SSDs. For example, you can specify the time zone to Asia/Hong_Kong. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
        - If you set the `Engine` parameter to PostgreSQL.
        - This time zone of the instance is not in UTC. For more information about time zones, see [Time zones](https://www.alibabacloud.com/help/doc-detail/297356.htm).
        - You can specify this parameter only when the instance is equipped with standard SSDs or ESSDs.

        > **NOTE:** You can specify the time zone when you create a primary instance. You cannot specify the time zone when you create a read-only instance. Read-only instances inherit the time zone of their primary instance. If you do not specify this parameter, the system assigns the default time zone of the region where the instance resides.
        """
        return pulumi.get(self, "db_time_zone")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The switch of delete protection. Valid values:
        - true: delete protect.
        - false: no delete protect.

        > **NOTE:** `deletion_protection` is valid only when attribute `instance_charge_type` is set to `Postpaid` or `Serverless`, supported engine type: `MySQL`, `PostgreSQL`, `MariaDB`, `MSSQL`.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance configuration type. Valid values: ["Up", "Down", "TempUpgrade", "Serverless"]
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The method to update the engine version and change.  Default value: Immediate. Valid values:
        - Immediate: The change immediately takes effect.
        - MaintainTime: The change takes effect during the specified maintenance window. For more information, see ModifyDBInstanceMaintainTime.
        """
        return pulumi.get(self, "effective_time")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output[_builtins.str]:
        """
        The key id of the KMS. Used for encrypting a disk if not null. Only for PostgreSQL, MySQL and SQLServer.
        When the instance is PostgreSQL, this parameter can be used to enable, modify, and disable cloud disk encryption.Value range:
        - ServiceKey: Enable disk encryption using the service-managed key (Default Service CMK) automatically generated by Alibaba Cloud RDS.
        - <Key ID>: Use a custom key to enable cloud disk encryption or change the current key. For example: 494c98ce-f2b5-48ab-96ab-36c986b6****.
        - disabled: Turn off cloud disk encryption.
        > **NOTE:** This parameter is available when the instance runs MySQL.
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[_builtins.str]:
        """
        Database type. Value options: MySQL, SQLServer, PostgreSQL, MariaDB.

        > **NOTE:** When the 'engine_version' changes, it can be used as the target database version for the large version upgrade of RDS for MySQL instance.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        Database version. Value options can refer to the latest docs [CreateDBInstance](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
        - MySQL: [ 5.5、5.6、5.7、8.0 ]
        - SQLServer: [ 2008r2、08r2_ent_ha、2012、2012_ent_ha、2012_std_ha、2012_web、2014_std_ha、2016_ent_ha、2016_std_ha、2016_web、2017_std_ha、2017_ent、2019_std_ha、2019_ent ]
        - PostgreSQL: [ 10.0、11.0、12.0、13.0、14.0、15.0 ]
        - MariaDB: [ 10.3 ]
        **Serverless**
        - MySQL: [ 5.7、8.0 ]
        - SQLServer: [ 2016_std_sl、2017_std_sl、2019_std_sl ]
        - PostgreSQL: [ 14.0 ]
        - MariaDB does not support creating serverless instances.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to enable forcible switching. Valid values:
        - Yes
        - No
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set it to true to make some parameter efficient when modifying them. Default to false.
        """
        return pulumi.get(self, "force_restart")

    @_builtins.property
    @pulumi.getter(name="freshWhiteListReadins")
    def fresh_white_list_readins(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The read-only instances to which you want to synchronize the IP address whitelist.
        * If the instance is attached with a read-only instance, you can use this parameter to synchronize the IP address whitelist to the read-only instance. If the instance is attached with multiple read-only instances, the read-only instances must be separated by commas (,).
        * If the instance is not attached with a read-only instance, this parameter is empty.
        """
        return pulumi.get(self, "fresh_white_list_readins")

    @_builtins.property
    @pulumi.getter(name="haConfig")
    def ha_config(self) -> pulumi.Output[_builtins.str]:
        """
        The primary/secondary switchover mode of the instance. Default value: Auto. Valid values:
        - Auto: The system automatically switches over services from the primary to secondary instances in the event of a fault.
        - Manual: You must manually switch over services from the primary to secondary instances in the event of a fault.
        """
        return pulumi.get(self, "ha_config")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Valid values are `Prepaid`, `Postpaid`, `Serverless`, Default to `Postpaid`. Currently, the resource only supports PostPaid to PrePaid. For more information, see [Overview](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/what-is-serverless?spm=a2c63.p38356.0.0.772a28cfTAGqIv).
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of DB instance. It a string of 2 to 256 characters.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> pulumi.Output[_builtins.int]:
        """
        User-defined DB instance storage space. Value range:
        - [5, 2000] for MySQL/PostgreSQL HA dual node edition;
        - [20,1000] for MySQL 5.7 basic single node edition;
        - [10, 2000] for SQL Server 2008R2;
        - [20,2000] for SQL Server 2012 basic single node edition
        Increase progressively at a rate of 5 GB. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        Note: There is extra 5 GB storage for SQL Server Instance, and it is not in specified `instance_storage`.
        """
        return pulumi.get(self, "instance_storage")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        DB Instance type. For details, see [Instance type table](https://www.alibabacloud.com/help/doc-detail/26312.htm).
        - To create a serverless instance, please pass the following values:
        - MySQL basic: mysql.n2.serverless.1c
        - MySQL high availability: mysql.n2.serverless.2c
        - SQLServer high availability: mssql.mem2.serverless.s2
        - PostgreSQL basic: pg.n2.serverless.1c

        > **NOTE:** When `storage_auto_scale="Enable"`, do not perform `instance_storage` check. when `storage_auto_scale="Disable"`, if the instance itself `instance_storage`has changed. You need to manually revise the `instance_storage` in the template value. When `payment_type="Serverless"` and when modifying, do not perform `instance_storage` check. Otherwise, check.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> pulumi.Output[_builtins.str]:
        """
        Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
        """
        return pulumi.get(self, "maintain_time")

    @_builtins.property
    @pulumi.getter(name="manualHaTime")
    def manual_ha_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time after when you want to enable automatic primary/secondary switchover. At most, you can set this parameter to 23:59:59 seven days later. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.

        > **NOTE:** This parameter only takes effect when the HAConfig parameter is set to Manual.
        """
        return pulumi.get(self, "manual_ha_time")

    @_builtins.property
    @pulumi.getter(name="modifyMode")
    def modify_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The method that is used to modify the IP address whitelist. Default value: Cover. Valid values:
        - Cover: Use the value of the SecurityIps parameter to overwrite the existing entries in the IP address whitelist.
        - Append: Add the IP addresses and CIDR blocks that are specified in the SecurityIps parameter to the IP address whitelist.
        - Delete: Delete IP addresses and CIDR blocks that are specified in the SecurityIps parameter from the IP address whitelist. You must retain at least one IP address or CIDR block.
        """
        return pulumi.get(self, "modify_mode")

    @_builtins.property
    @pulumi.getter(name="monitoringPeriod")
    def monitoring_period(self) -> pulumi.Output[_builtins.int]:
        """
        The monitoring frequency in seconds. Valid values are 5, 10, 60, 300. Defaults to 300.
        """
        return pulumi.get(self, "monitoring_period")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Output[_builtins.str]:
        """
        The globally unique identifier (GUID) of the secondary instance. You can call the DescribeDBInstanceHAConfig operation to query the GUID of the secondary instance.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="optimizedWrites")
    def optimized_writes(self) -> pulumi.Output[_builtins.str]:
        """
        Write optimization function switch. supported engine type: `MySQL`. Valid values:
        - optimized: Enable
        - none: Disable
        """
        return pulumi.get(self, "optimized_writes")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.InstanceParameter']]:
        """
        Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm) . See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The duration that you will buy DB instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="pgBouncerEnabled")
    def pg_bouncer_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Modify the PgBouncer feature of the RDS PostgreSQL instance. Valid values:
        - true: enable.
        - false: disable.
        """
        return pulumi.get(self, "pg_bouncer_enabled")

    @_builtins.property
    @pulumi.getter(name="pgHbaConfs")
    def pg_hba_confs(self) -> pulumi.Output[Sequence['outputs.InstancePgHbaConf']]:
        """
        The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        """
        return pulumi.get(self, "pg_hba_confs")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.str]:
        """
        The private port of the database service. If you want to update public port, please use resource rds.Connection port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The private IP address of the instance. The private IP address must be within the Classless Inter-Domain Routing (CIDR) block of the vSwitch that is specified by the VSwitchId parameter.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="recoveryModel")
    def recovery_model(self) -> pulumi.Output[_builtins.str]:
        """
        Enable the Simple Recovery Model for an RDS SQL Server Instance.The Simple Recovery Model feature is only supported by the Basic Series of RDS SQL Server instances. Once this feature is enabled, it cannot be disabled.Valid values:
        - simple: Enable Simple Recovery.
        > **NOTE:** If you set this parameter to Manual, you must specify the ManualHATime parameter.
        """
        return pulumi.get(self, "recovery_model")

    @_builtins.property
    @pulumi.getter(name="releasedKeepPolicy")
    def released_keep_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The policy based on which ApsaraDB RDS retains archived backup files after the instance is released. Valid values:
        - None: No archived backup files are retained.
        - Lastest: Only the last archived backup file is retained.
        - All: All the archived backup files are retained.

        > **NOTE:** This parameter is supported only when the instance runs the MySQL database engine.
        """
        return pulumi.get(self, "released_keep_policy")

    @_builtins.property
    @pulumi.getter(name="replicationAcl")
    def replication_acl(self) -> pulumi.Output[_builtins.str]:
        """
        The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is available only when the public key of the CA that issues client certificates is enabled. Valid values:
        - cert
        - perfer
        - verify-ca
        - verify-full (supported only when the instance runs PostgreSQL 12 or later)
        """
        return pulumi.get(self, "replication_acl")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of resource group which the DB instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Alibaba Cloud Resource Name (ARN) of the RAM role.

        > **NOTE:**  This parameter is not required when you create an instance that runs MySQL, PostgreSQL, or SQL Server. You need to only specify the RoleARN parameter to create an instance that has cloud disk encryption enabled by using the obtained key ID.
        You can configure RAM authorization to require a RAM user to enable cloud disk encryption when the RAM user is used to create an instance. If cloud disk encryption is disabled during the instance creation, the creation operation fails. To complete the configuration, you can attach the following policy to the RAM user: {"Version":"1","Statement":[{"Effect":"Deny","Action":"rds:CreateDBInstance","Resource":"*","Condition":{"StringEquals":{"rds:DiskEncryptionRequired":"false"}}}]}
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    @_utilities.deprecated("""Attribute `security_group_id` has been deprecated from 1.69.0 and use `security_group_ids` instead.""")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        It has been deprecated from 1.69.0 and use `security_group_ids` instead.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        , Available since v1.69.0) The list IDs to join ECS Security Group. At most supports three security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="securityIpMode")
    def security_ip_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Valid values are `normal`, `safety`, Default to `normal`. support `safety` switch to high security access mode.
        """
        return pulumi.get(self, "security_ip_mode")

    @_builtins.property
    @pulumi.getter(name="securityIpType")
    def security_ip_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of IP address in the IP address whitelist.
        """
        return pulumi.get(self, "security_ip_type")

    @_builtins.property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        return pulumi.get(self, "security_ips")

    @_builtins.property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> pulumi.Output[_builtins.str]:
        """
        The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. **NOTE:** From version 1.231.0, `server_cert` start  support `MySQL` engine.
        """
        return pulumi.get(self, "server_cert")

    @_builtins.property
    @pulumi.getter(name="serverKey")
    def server_key(self) -> pulumi.Output[_builtins.str]:
        """
        The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL or MySQL with standard or enhanced SSDs. If you set the CAType parameter to custom, you must also specify this parameter. **NOTE:** From version 1.231.0, `server_key` start support `MySQL` engine.
        """
        return pulumi.get(self, "server_key")

    @_builtins.property
    @pulumi.getter(name="serverlessConfigs")
    def serverless_configs(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceServerlessConfig']]]:
        """
        The settings of the serverless instance. This parameter is required when you create a serverless instance. This parameter takes effect only when you create an ApsaraDB RDS for Serverless instance. See `serverless_config` below.
        """
        return pulumi.get(self, "serverless_configs")

    @_builtins.property
    @pulumi.getter(name="sqlCollectorConfigValue")
    def sql_collector_config_value(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The sql collector keep time of the instance. Valid values are `30`, `180`, `365`, `1095`, `1825`, Default to `30`.
        > **NOTE:** This parameter takes effect when sql_collector_status is set to Enabled and does not take effect when sql_collector_status is set to Disabled.
        """
        return pulumi.get(self, "sql_collector_config_value")

    @_builtins.property
    @pulumi.getter(name="sqlCollectorStatus")
    def sql_collector_status(self) -> pulumi.Output[_builtins.str]:
        """
        The sql collector status of the instance. Valid values are `Enabled`, `Disabled`, Default to `Disabled`.
        """
        return pulumi.get(self, "sql_collector_status")

    @_builtins.property
    @pulumi.getter(name="sslAction")
    def ssl_action(self) -> pulumi.Output[_builtins.str]:
        """
        Actions performed on SSL functions. Valid values: 
        `Open`: turn on SSL encryption;
        `Close`: turn off SSL encryption;
        `Update`: update SSL certificate.
        See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26254.htm).

        > **NOTE:** The attribute `ssl_action` will be ignored when setting `instance_charge_type = "Serverless"` for SQLServer, PostgreSQL or MariaDB.
        """
        return pulumi.get(self, "ssl_action")

    @_builtins.property
    @pulumi.getter(name="sslConnectionString")
    def ssl_connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        The internal or public endpoint for which the server certificate needs to be created or updated.
        """
        return pulumi.get(self, "ssl_connection_string")

    @_builtins.property
    @pulumi.getter(name="sslStatus")
    def ssl_status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the SSL feature. `Yes`: SSL is turned on; `No`: SSL is turned off.
        """
        return pulumi.get(self, "ssl_status")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.204.1) The status of db instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageAutoScale")
    def storage_auto_scale(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Automatic storage space expansion switch. Valid values:
        - Enable
        - Disable

        > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable.
        """
        return pulumi.get(self, "storage_auto_scale")

    @_builtins.property
    @pulumi.getter(name="storageThreshold")
    def storage_threshold(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The threshold in percentage based on which an automatic storage expansion is triggered. If the available storage reaches the threshold, ApsaraDB RDS increases the storage capacity of the instance.
        Valid values: [10, 20, 30, 40, 50].

        > **NOTE:** This parameter only takes effect when the StorageAutoScale parameter is set to Enable. The value must be greater than or equal to the total size of the current storage space of the instance.
        """
        return pulumi.get(self, "storage_threshold")

    @_builtins.property
    @pulumi.getter(name="storageUpperBound")
    def storage_upper_bound(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The upper limit of the total storage space for automatic expansion of the storage space, that is, automatic expansion will not cause the total storage space of the instance to exceed this value. Unit: GB. The value must be ≥0.

        > **NOTE:** Because of data backup and migration, change DB instance type and storage would cost 15~20 minutes. Please make full preparation before changing them.
        """
        return pulumi.get(self, "storage_upper_bound")

    @_builtins.property
    @pulumi.getter(name="switchTime")
    def switch_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The specific point in time when you want to perform the update. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. It is valid only when `target_minor_version` is changed. The time must be in UTC.

        > **NOTE:** This parameter takes effect only when you set the UpgradeTime parameter to SpecifyTime.
        """
        return pulumi.get(self, "switch_time")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.

        Note: From 1.63.0, the tag key and value are case sensitive. Before that, they are not case sensitive.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetMinorVersion")
    def target_minor_version(self) -> pulumi.Output[_builtins.str]:
        """
        The minor engine version to which you want to update the instance. If you do not specify this parameter, the instance is updated to the latest minor engine version. You must specify the minor engine version in one of the following formats:
        - PostgreSQL: rds_postgres_<Major engine version>00_<Minor engine version>. Example: rds_postgres_1200_20200830.
        - MySQL: <RDS edition>_<Minor engine version>. Examples: rds_20200229, xcluster_20200229, and xcluster80_20200229. The following RDS editions are supported:
        - rds: The instance runs RDS Basic or High-availability Edition.
        - xcluster: The instance runs MySQL 5.7 on RDS Enterprise Edition.
        - xcluster80: The instance runs MySQL 8.0 on RDS Enterprise Edition.
        - SQLServer: <Minor engine version>. Example: 15.0.4073.23.

        > **NOTE:** For more information about minor engine versions, see Release notes of minor AliPG versions, Release notes of minor AliSQL versions, and Release notes of minor engine versions of ApsaraDB RDS for SQL Server.
        """
        return pulumi.get(self, "target_minor_version")

    @_builtins.property
    @pulumi.getter(name="tcpConnectionType")
    def tcp_connection_type(self) -> pulumi.Output[_builtins.str]:
        """
        The availability check method of the instance. Valid values:
        - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
        - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        """
        return pulumi.get(self, "tcp_connection_type")

    @_builtins.property
    @pulumi.getter(name="tdeEncryptionKey")
    def tde_encryption_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the custom key.
        """
        return pulumi.get(self, "tde_encryption_key")

    @_builtins.property
    @pulumi.getter(name="tdeStatus")
    def tde_status(self) -> pulumi.Output[_builtins.str]:
        """
        The TDE(Transparent Data Encryption) status. After TDE is turned on, it cannot be turned off. See more [engine and engineVersion limitation](https://www.alibabacloud.com/help/zh/doc-detail/26256.htm).

        > **NOTE:** When creating an instance and enabling disk encryption, the value of encryption_key can only be a Key ID; it cannot be a ServiceKey. After the instance is created, you can manage the disk encryption using: ServiceKey, Key ID, or disabled.
        """
        return pulumi.get(self, "tde_status")

    @_builtins.property
    @pulumi.getter(name="templateIdLists")
    def template_id_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.int]]]:
        """
        Whitelist Template ID List.
        """
        return pulumi.get(self, "template_id_lists")

    @_builtins.property
    @pulumi.getter
    def templates(self) -> pulumi.Output[Sequence[Mapping[str, _builtins.str]]]:
        """
        (Computed, Available since v1.254.0) Whitelist Template Details.
        """
        return pulumi.get(self, "templates")

    @_builtins.property
    @pulumi.getter(name="upgradeDbInstanceKernelVersion")
    @_utilities.deprecated("""Attribute `upgrade_db_instance_kernel_version` has been deprecated from 1.198.0 and use `target_minor_version` instead.""")
    def upgrade_db_instance_kernel_version(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to upgrade a minor version of the kernel. Valid values:
        - true: upgrade
        - false: not to upgrade

        > **NOTE:** Database Engine and Version: Supports only MySQL 5.7 or 8.0 instances.
        > **NOTE:** Storage Type: Supports only ESSD cloud disks and general-purpose cloud disks.
        > **NOTE:** Activation Stage: Supports only during instance creation or when enabling write optimization features for existing  (high-availability/cluster series) instances.
        """
        return pulumi.get(self, "upgrade_db_instance_kernel_version")

    @_builtins.property
    @pulumi.getter(name="upgradeTime")
    def upgrade_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The method to update the minor engine version. Default value: Immediate. It is valid only when `target_minor_version` is changed. Valid values:
        - Immediate: The minor engine version is immediately updated.
        - MaintainTime: The minor engine version is updated during the maintenance window. For more information about how to change the maintenance window, see ModifyDBInstanceMaintainTime.
        - SpecifyTime: The minor engine version is updated at the point in time you specify.
        """
        return pulumi.get(self, "upgrade_time")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC ID of the instance.


        > **NOTE:** This parameter applies only to ApsaraDB RDS for MySQL instances. For more information about Upgrade the major engine version of an ApsaraDB RDS for MySQL instance, see [Upgrade the major engine version of an RDS instance in the ApsaraDB RDS console](https://www.alibabacloud.com/help/en/apsaradb-for-rds/latest/upgrade-the-major-engine-version-of-an-apsaradb-rds-for-mysql-instance-1).
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The virtual switch ID to launch DB instances in one VPC. If there are multiple vswitches, separate them with commas.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="whitelistNetworkType")
    def whitelist_network_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The network type of the IP address whitelist. Default value: MIX. Valid values:
        - Classic: classic network in enhanced whitelist mode
        - VPC: virtual private cloud (VPC) in enhanced whitelist mode
        - MIX: standard whitelist mode

        > **NOTE:** In standard whitelist mode, IP addresses and CIDR blocks can be added only to the default IP address whitelist. In enhanced whitelist mode, IP addresses and CIDR blocks can be added to both IP address whitelists of the classic network type and those of the VPC network type.
        """
        return pulumi.get(self, "whitelist_network_type")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Zone to launch the DB instance. From version 1.8.1, it supports multiple zone.
        If it is a multi-zone and `vswitch_id` is specified, the vswitch must in the one of them.
        The multiple zone ID can be retrieved by setting `multi` to "true" in the data source `get_zones`.
        """
        return pulumi.get(self, "zone_id")

    @_builtins.property
    @pulumi.getter(name="zoneIdSlaveA")
    def zone_id_slave_a(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
        """
        return pulumi.get(self, "zone_id_slave_a")

    @_builtins.property
    @pulumi.getter(name="zoneIdSlaveB")
    def zone_id_slave_b(self) -> pulumi.Output[_builtins.str]:
        """
        RDS MySQL Cluster series instances support creating 1 to 2 secondary nodes at the same time when establishing a new instance. If you have this requirement, you can use this parameter to specify the availability zone for the second secondary node.
        """
        return pulumi.get(self, "zone_id_slave_b")

