# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RdsUpgradeDbInstanceArgs', 'RdsUpgradeDbInstance']

@pulumi.input_type
class RdsUpgradeDbInstanceArgs:
    def __init__(__self__, *,
                 collect_stat_mode: pulumi.Input[_builtins.str],
                 db_instance_class: pulumi.Input[_builtins.str],
                 db_instance_storage: pulumi.Input[_builtins.int],
                 db_instance_storage_type: pulumi.Input[_builtins.str],
                 instance_network_type: pulumi.Input[_builtins.str],
                 payment_type: pulumi.Input[_builtins.str],
                 source_db_instance_id: pulumi.Input[_builtins.str],
                 switch_over: pulumi.Input[_builtins.str],
                 target_major_version: pulumi.Input[_builtins.str],
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_type: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 client_cert_revocation_list: Optional[pulumi.Input[_builtins.str]] = None,
                 client_crl_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 force_restart: Optional[pulumi.Input[_builtins.bool]] = None,
                 ha_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_time: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['RdsUpgradeDbInstanceParameterArgs']]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pg_hba_confs: Optional[pulumi.Input[Sequence[pulumi.Input['RdsUpgradeDbInstancePgHbaConfArgs']]]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 released_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_acl: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 server_key: Optional[pulumi.Input[_builtins.str]] = None,
                 source_biz: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 switch_time: Optional[pulumi.Input[_builtins.str]] = None,
                 switch_time_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tde_status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id_slave1: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RdsUpgradeDbInstance resource.
        :param pulumi.Input[_builtins.str] collect_stat_mode: The time at which ApsaraDB RDS collects the statistics of the new instance.
               * **Before**: ApsaraDB RDS collects the statistics of the new instance before the switchover to ensure service stability. If the original instance contains a large amount of data, the upgrade may require a long period of time.
               * **After**: ApsaraDB RDS collects the statistics of the new instance after the switchover to accelerate the upgrade. If you access tables for which no statistics are generated, the query plans that you specify may be inaccurately executed. In addition, your database service may be unavailable during peak hours.
               
               > **NOTE** If you set the SwitchOver parameter to false, the value Before specifies that ApsaraDB RDS collects the statistics of the new instance before the new instance starts to process read and write requests, and the value After specifies that ApsaraDB RDS collects the statistics of the new instance after the new instance starts to process read and write requests.
        :param pulumi.Input[_builtins.str] db_instance_class: The instance type of the new instance. For information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
        :param pulumi.Input[_builtins.int] db_instance_storage: The storage capacity of the new instance. Unit: GB. The storage capacity increases in increments of 5 GB. For more information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
               
               > **NOTE:** The default value of this parameter is the storage capacity of the original instance.
        :param pulumi.Input[_builtins.str] db_instance_storage_type: The type of storage media that is used for the new instance. Valid values:
               * **local_ssd**: local SSDs.
               * **cloud_ssd**: standard SSDs.
               * **cloud_essd**: enhanced SSDs (ESSDs) of performance level 1 (PL1).
               * **cloud_essd2**: ESSDs of PL2.
               * **cloud_essd3**: ESSDs of PL3.
        :param pulumi.Input[_builtins.str] instance_network_type: The network type of the instance. Valid values:
               * **Classic**: Classic Network.
               * **VPC**: VPC.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the new instance. Valid values: `PayAsYouGo` and `Subscription`.
        :param pulumi.Input[_builtins.str] source_db_instance_id: The source db instance id.
        :param pulumi.Input[_builtins.str] switch_over: Specifies whether ApsaraDB RDS automatically switches your workloads over to the new instance after data is migrated to the new instance. Valid values:
               * **true**: ApsaraDB RDS automatically switches workloads over to the new instance. If you set this parameter to true, you must take note of the following information:
               * After the switchover is complete, you cannot roll your workloads back to the original instance. Proceed with caution.
               * During the switchover, the original instance processes only read requests. You must perform the switchover during off-peak hours.
               * If read-only instances are attached to the original instance, you can set this parameter only to false. In this case, the read-only instances that are attached to the original instance cannot be cloned. After the upgrade is complete, you must create read-only instances for the new instance.
               * **false**: ApsaraDB RDS does not automatically switch your workloads over to the new instance. Before you perform an upgrade, we recommend that you set this parameter to false to test whether the new major engine version is compatible with your workloads. If you set this parameter to false, you must take note of the following information:
               * The data migration does not interrupt your workloads on the original instance.
               * After data is migrated to the new instance, you must update the endpoint configuration on your application. This update requires you to replace the endpoint of the original instance with the endpoint of the new instance. For more information about how to view the endpoint of an instance, see [View and change the internal and public endpoints and port numbers of an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/doc-detail/96788.htm).
        :param pulumi.Input[_builtins.str] target_major_version: The major engine version of the new instance. The value of this parameter must be the major engine version on which an upgrade check is performed.
               
               > **NOTE** You can call the [UpgradeDBInstanceMajorVersionPrecheck](https://www.alibabacloud.com/help/doc-detail/330050.htm) operation to perform an upgrade check on a major engine version.
        :param pulumi.Input[_builtins.str] acl: This parameter is only supported by the RDS PostgreSQL cloud disk version. This parameter indicates the authentication method. It is allowed only when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
        :param pulumi.Input[_builtins.str] auto_upgrade_minor_version: How to upgrade the minor version of the instance. Valid values:
               * **Auto**: automatically upgrade the minor version.
               * **Manual**: It is not automatically upgraded. It is only mandatory when the current version is offline.
        :param pulumi.Input[_builtins.str] ca_type: This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the certificate type. When the value of ssl_action is Open, the default value of this parameter is aliyun. Value range:
               * **aliyun**: using cloud certificates.
               * **custom**: use a custom certificate. Valid values: `aliyun`, `custom`.
        :param pulumi.Input[_builtins.str] certificate: The file that contains the certificate used for TDE.
        :param pulumi.Input[_builtins.str] client_ca_cert: This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the public key of the client certification authority. If the value of client_ca_enabled is 1, this parameter must be configured.
        :param pulumi.Input[_builtins.int] client_ca_enabled: The client ca enabled.
        :param pulumi.Input[_builtins.str] client_cert_revocation_list: This parameter is only supported by the RDS PostgreSQL cloud disk version, which indicates that the client revokes the certificate file. If the value of client_crl_enabled is 1, this parameter must be configured.
        :param pulumi.Input[_builtins.int] client_crl_enabled: The client crl enabled.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The connection string prefix.
        :param pulumi.Input[_builtins.str] db_instance_description: The db instance description.
        :param pulumi.Input[_builtins.str] db_name: The name of the database for which you want to enable TDE. Up to 50 names can be entered in a single request. If you specify multiple names, separate these names with commas (,).
               
               > **NOTE:** This parameter is available and must be specified only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
        :param pulumi.Input[_builtins.str] dedicated_host_group_id: The ID of the dedicated cluster to which the new instance belongs. This parameter takes effect only when you create the new instance in a dedicated cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The switch of delete protection. Valid values:
               - true: delete protect.
               - false: no delete protect.
               
               > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
        :param pulumi.Input[_builtins.str] direction: The direction. Valid values: `Auto`, `Down`, `TempUpgrade`, `Up`.
        :param pulumi.Input[_builtins.str] effective_time: The effective time.
        :param pulumi.Input[_builtins.str] encryption_key: The ID of the private key.
               
               > **NOTE:** This parameter is available only when the instance runs MySQL.
        :param pulumi.Input[_builtins.str] engine: Database type. Value options: MySQL, SQLServer, PostgreSQL.
        :param pulumi.Input[_builtins.str] engine_version: Database version. Value:
               * MySQL: **5.5/5.6/5.7/8.0**.
               * SQL Server: **2008r2/08r2_ent_ha/2012/2012_ent_ha/2012_std_ha/2012_web/2014_std_ha/2016_ent_ha/2016_std_ha/2016_web/2017_std_ha/2017_ent/2019_std_ha/2019_ent**.
               * PostgreSQL: **9.4/10.0/11.0/12.0/13.0**.
               * MariaDB: **10.3**.
        :param pulumi.Input[_builtins.bool] force_restart: Set it to true to make some parameter efficient when modifying them. Default to false.
        :param pulumi.Input[_builtins.str] ha_mode: The high availability mode. Valid values:
               * **RPO**: Data persistence is preferred. The instance preferentially ensures data reliability to minimize data loss. Use this mode if you have higher requirements on data consistency.
               * **RTO**: Instance availability is preferred. The instance restores services as soon as possible to ensure availability. Use this mode if you have higher requirements on service availability.
        :param pulumi.Input[_builtins.str] maintain_time: The maintainable time period of the instance. Format: <I> HH:mm</I> Z-<I> HH:mm</I> Z(UTC time).
        :param pulumi.Input[Sequence[pulumi.Input['RdsUpgradeDbInstanceParameterArgs']]] parameters: Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm). See `parameters` below.
        :param pulumi.Input[_builtins.str] password: The password of the certificate. 
               
               > **NOTE:** This parameter is available only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
        :param pulumi.Input[Sequence[pulumi.Input['RdsUpgradeDbInstancePgHbaConfArgs']]] pg_hba_confs: The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        :param pulumi.Input[_builtins.str] port: The port.
        :param pulumi.Input[_builtins.str] private_ip_address: The intranet IP address of the new instance must be within the specified vSwitch IP address range. By default, the system automatically allocates by using **VPCId** and **VSwitchId**.
        :param pulumi.Input[_builtins.str] private_key: The file that contains the private key used for TDE.
        :param pulumi.Input[_builtins.str] released_keep_policy: The released keep policy.
        :param pulumi.Input[_builtins.str] replication_acl: This parameter is only supported by the RDS PostgreSQL cloud disk version, indicating the authentication method of the replication permission. It is only allowed when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group id.
        :param pulumi.Input[_builtins.str] role_arn: The Alibaba Cloud Resource Name (ARN) of a RAM role. A RAM role is a virtual RAM identity that you can create within your Alibaba Cloud account. For more information, see [RAM role overview](https://www.alibabacloud.com/help/en/ram/user-guide/ram-role-overview).
               
               > **NOTE:** This parameter is available only when the instance runs MySQL.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ips: The IP address whitelist of the instance. Separate multiple IP addresses with commas (,) and cannot be repeated. The following two formats are supported:
               * IP address form, for example: 10.23.12.24.
               * CIDR format, for example, 10.23.12.0/24 (no Inter-Domain Routing, 24 indicates the length of the prefix in the address, ranging from 1 to 32).
               
               > **NOTE:** each instance can add up to 1000 IP addresses or IP segments, that is, the total number of IP addresses or IP segments in all IP whitelist groups cannot exceed 1000. When there are more IP addresses, it is recommended to merge them into IP segments, for example, 10.23.12.0/24.
        :param pulumi.Input[_builtins.str] server_cert: This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the content of the server certificate. If the CAType value is custom, this parameter must be configured.
        :param pulumi.Input[_builtins.str] server_key: This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the private key of the server certificate. If the value of CAType is custom, this parameter must be configured.
        :param pulumi.Input[_builtins.str] source_biz: The source biz.
        :param pulumi.Input[_builtins.int] ssl_enabled: Enable or disable SSL. Valid values: `0` and `1`.
        :param pulumi.Input[_builtins.str] switch_time: The time at which you want to apply the specification changes. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        :param pulumi.Input[_builtins.str] switch_time_mode: The time at which ApsaraDB RDS switches your workloads over to the new instance. This parameter is used together with the SwitchOver parameter and takes effect only when you set the SwitchOver parameter to true. Valid values:
               * **Immediate**: After data is migrated to the new instance, ApsaraDB RDS immediately switches your workloads over to the new instance.
               * **MaintainTime**: After data is migrated to the new instance, ApsaraDB RDS switches your workloads over to the new instance during the maintenance window that you specify. You can call the [ModifyDBInstanceMaintainTime](https://www.alibabacloud.com/help/doc-detail/26249.htm) operation to change the maintenance window of an instance.
        :param pulumi.Input[_builtins.str] sync_mode: [The data replication mode](https://www.alibabacloud.com/help/doc-detail/96055.htm). Valid values:
               * **Sync**: strong synchronization.
               * **Semi-sync**: Semi-synchronous.
               * **Async**: asynchronous.
               
               > **NOTE:** SQL Server 2017 cluster version is currently not supported.
        :param pulumi.Input[_builtins.str] tcp_connection_type: The availability check method of the instance. Valid values:
               - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
               - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        :param pulumi.Input[_builtins.str] tde_status: Specifies whether to enable TDE. Valid values: `Enabled` and `Disabled`.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to which the new instance belongs.
               
               > **NOTE:** Make sure that the VPC resides in the specified region.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch associated with the specified VPC.
               
               > **NOTE:** Make sure that the vSwitch belongs to the specified VPC and region.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone to which the new instance belongs. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query the most recent region list.
               
               > **NOTE:** The default value of this parameter is the ID of the zone to which the original instance belongs.
        :param pulumi.Input[_builtins.str] zone_id_slave1: The ID of the zone to which the secondary instance of the new instance belongs. You can specify this parameter only when the original instance runs RDS High-availability Edition. You can select a zone that belongs to the region where the original instance resides. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query zone IDs.
        """
        pulumi.set(__self__, "collect_stat_mode", collect_stat_mode)
        pulumi.set(__self__, "db_instance_class", db_instance_class)
        pulumi.set(__self__, "db_instance_storage", db_instance_storage)
        pulumi.set(__self__, "db_instance_storage_type", db_instance_storage_type)
        pulumi.set(__self__, "instance_network_type", instance_network_type)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "source_db_instance_id", source_db_instance_id)
        pulumi.set(__self__, "switch_over", switch_over)
        pulumi.set(__self__, "target_major_version", target_major_version)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if ca_type is not None:
            pulumi.set(__self__, "ca_type", ca_type)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if client_ca_cert is not None:
            pulumi.set(__self__, "client_ca_cert", client_ca_cert)
        if client_ca_enabled is not None:
            pulumi.set(__self__, "client_ca_enabled", client_ca_enabled)
        if client_cert_revocation_list is not None:
            pulumi.set(__self__, "client_cert_revocation_list", client_cert_revocation_list)
        if client_crl_enabled is not None:
            pulumi.set(__self__, "client_crl_enabled", client_crl_enabled)
        if connection_string_prefix is not None:
            pulumi.set(__self__, "connection_string_prefix", connection_string_prefix)
        if db_instance_description is not None:
            pulumi.set(__self__, "db_instance_description", db_instance_description)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if dedicated_host_group_id is not None:
            pulumi.set(__self__, "dedicated_host_group_id", dedicated_host_group_id)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)
        if ha_mode is not None:
            pulumi.set(__self__, "ha_mode", ha_mode)
        if maintain_time is not None:
            pulumi.set(__self__, "maintain_time", maintain_time)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pg_hba_confs is not None:
            pulumi.set(__self__, "pg_hba_confs", pg_hba_confs)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if released_keep_policy is not None:
            pulumi.set(__self__, "released_keep_policy", released_keep_policy)
        if replication_acl is not None:
            pulumi.set(__self__, "replication_acl", replication_acl)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if server_cert is not None:
            pulumi.set(__self__, "server_cert", server_cert)
        if server_key is not None:
            pulumi.set(__self__, "server_key", server_key)
        if source_biz is not None:
            pulumi.set(__self__, "source_biz", source_biz)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)
        if switch_time is not None:
            pulumi.set(__self__, "switch_time", switch_time)
        if switch_time_mode is not None:
            pulumi.set(__self__, "switch_time_mode", switch_time_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)
        if tcp_connection_type is not None:
            pulumi.set(__self__, "tcp_connection_type", tcp_connection_type)
        if tde_status is not None:
            pulumi.set(__self__, "tde_status", tde_status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)
        if zone_id_slave1 is not None:
            pulumi.set(__self__, "zone_id_slave1", zone_id_slave1)

    @_builtins.property
    @pulumi.getter(name="collectStatMode")
    def collect_stat_mode(self) -> pulumi.Input[_builtins.str]:
        """
        The time at which ApsaraDB RDS collects the statistics of the new instance.
        * **Before**: ApsaraDB RDS collects the statistics of the new instance before the switchover to ensure service stability. If the original instance contains a large amount of data, the upgrade may require a long period of time.
        * **After**: ApsaraDB RDS collects the statistics of the new instance after the switchover to accelerate the upgrade. If you access tables for which no statistics are generated, the query plans that you specify may be inaccurately executed. In addition, your database service may be unavailable during peak hours.

        > **NOTE** If you set the SwitchOver parameter to false, the value Before specifies that ApsaraDB RDS collects the statistics of the new instance before the new instance starts to process read and write requests, and the value After specifies that ApsaraDB RDS collects the statistics of the new instance after the new instance starts to process read and write requests.
        """
        return pulumi.get(self, "collect_stat_mode")

    @collect_stat_mode.setter
    def collect_stat_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "collect_stat_mode", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceClass")
    def db_instance_class(self) -> pulumi.Input[_builtins.str]:
        """
        The instance type of the new instance. For information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
        """
        return pulumi.get(self, "db_instance_class")

    @db_instance_class.setter
    def db_instance_class(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_class", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceStorage")
    def db_instance_storage(self) -> pulumi.Input[_builtins.int]:
        """
        The storage capacity of the new instance. Unit: GB. The storage capacity increases in increments of 5 GB. For more information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).

        > **NOTE:** The default value of this parameter is the storage capacity of the original instance.
        """
        return pulumi.get(self, "db_instance_storage")

    @db_instance_storage.setter
    def db_instance_storage(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "db_instance_storage", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of storage media that is used for the new instance. Valid values:
        * **local_ssd**: local SSDs.
        * **cloud_ssd**: standard SSDs.
        * **cloud_essd**: enhanced SSDs (ESSDs) of performance level 1 (PL1).
        * **cloud_essd2**: ESSDs of PL2.
        * **cloud_essd3**: ESSDs of PL3.
        """
        return pulumi.get(self, "db_instance_storage_type")

    @db_instance_storage_type.setter
    def db_instance_storage_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_storage_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceNetworkType")
    def instance_network_type(self) -> pulumi.Input[_builtins.str]:
        """
        The network type of the instance. Valid values:
        * **Classic**: Classic Network.
        * **VPC**: VPC.
        """
        return pulumi.get(self, "instance_network_type")

    @instance_network_type.setter
    def instance_network_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_network_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The billing method of the new instance. Valid values: `PayAsYouGo` and `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceDbInstanceId")
    def source_db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The source db instance id.
        """
        return pulumi.get(self, "source_db_instance_id")

    @source_db_instance_id.setter
    def source_db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="switchOver")
    def switch_over(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies whether ApsaraDB RDS automatically switches your workloads over to the new instance after data is migrated to the new instance. Valid values:
        * **true**: ApsaraDB RDS automatically switches workloads over to the new instance. If you set this parameter to true, you must take note of the following information:
        * After the switchover is complete, you cannot roll your workloads back to the original instance. Proceed with caution.
        * During the switchover, the original instance processes only read requests. You must perform the switchover during off-peak hours.
        * If read-only instances are attached to the original instance, you can set this parameter only to false. In this case, the read-only instances that are attached to the original instance cannot be cloned. After the upgrade is complete, you must create read-only instances for the new instance.
        * **false**: ApsaraDB RDS does not automatically switch your workloads over to the new instance. Before you perform an upgrade, we recommend that you set this parameter to false to test whether the new major engine version is compatible with your workloads. If you set this parameter to false, you must take note of the following information:
        * The data migration does not interrupt your workloads on the original instance.
        * After data is migrated to the new instance, you must update the endpoint configuration on your application. This update requires you to replace the endpoint of the original instance with the endpoint of the new instance. For more information about how to view the endpoint of an instance, see [View and change the internal and public endpoints and port numbers of an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/doc-detail/96788.htm).
        """
        return pulumi.get(self, "switch_over")

    @switch_over.setter
    def switch_over(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "switch_over", value)

    @_builtins.property
    @pulumi.getter(name="targetMajorVersion")
    def target_major_version(self) -> pulumi.Input[_builtins.str]:
        """
        The major engine version of the new instance. The value of this parameter must be the major engine version on which an upgrade check is performed.

        > **NOTE** You can call the [UpgradeDBInstanceMajorVersionPrecheck](https://www.alibabacloud.com/help/doc-detail/330050.htm) operation to perform an upgrade check on a major engine version.
        """
        return pulumi.get(self, "target_major_version")

    @target_major_version.setter
    def target_major_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_major_version", value)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version. This parameter indicates the authentication method. It is allowed only when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How to upgrade the minor version of the instance. Valid values:
        * **Auto**: automatically upgrade the minor version.
        * **Manual**: It is not automatically upgraded. It is only mandatory when the current version is offline.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @auto_upgrade_minor_version.setter
    def auto_upgrade_minor_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_upgrade_minor_version", value)

    @_builtins.property
    @pulumi.getter(name="caType")
    def ca_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the certificate type. When the value of ssl_action is Open, the default value of this parameter is aliyun. Value range:
        * **aliyun**: using cloud certificates.
        * **custom**: use a custom certificate. Valid values: `aliyun`, `custom`.
        """
        return pulumi.get(self, "ca_type")

    @ca_type.setter
    def ca_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_type", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The file that contains the certificate used for TDE.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="clientCaCert")
    def client_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the public key of the client certification authority. If the value of client_ca_enabled is 1, this parameter must be configured.
        """
        return pulumi.get(self, "client_ca_cert")

    @client_ca_cert.setter
    def client_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientCaEnabled")
    def client_ca_enabled(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The client ca enabled.
        """
        return pulumi.get(self, "client_ca_enabled")

    @client_ca_enabled.setter
    def client_ca_enabled(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_ca_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientCertRevocationList")
    def client_cert_revocation_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version, which indicates that the client revokes the certificate file. If the value of client_crl_enabled is 1, this parameter must be configured.
        """
        return pulumi.get(self, "client_cert_revocation_list")

    @client_cert_revocation_list.setter
    def client_cert_revocation_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert_revocation_list", value)

    @_builtins.property
    @pulumi.getter(name="clientCrlEnabled")
    def client_crl_enabled(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The client crl enabled.
        """
        return pulumi.get(self, "client_crl_enabled")

    @client_crl_enabled.setter
    def client_crl_enabled(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_crl_enabled", value)

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection string prefix.
        """
        return pulumi.get(self, "connection_string_prefix")

    @connection_string_prefix.setter
    def connection_string_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string_prefix", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The db instance description.
        """
        return pulumi.get(self, "db_instance_description")

    @db_instance_description.setter
    def db_instance_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_description", value)

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database for which you want to enable TDE. Up to 50 names can be entered in a single request. If you specify multiple names, separate these names with commas (,).

        > **NOTE:** This parameter is available and must be specified only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_name", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated cluster to which the new instance belongs. This parameter takes effect only when you create the new instance in a dedicated cluster.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @dedicated_host_group_id.setter
    def dedicated_host_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_host_group_id", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The switch of delete protection. Valid values:
        - true: delete protect.
        - false: no delete protect.

        > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The direction. Valid values: `Auto`, `Down`, `TempUpgrade`, `Up`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The effective time.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_time", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the private key.

        > **NOTE:** This parameter is available only when the instance runs MySQL.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database type. Value options: MySQL, SQLServer, PostgreSQL.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database version. Value:
        * MySQL: **5.5/5.6/5.7/8.0**.
        * SQL Server: **2008r2/08r2_ent_ha/2012/2012_ent_ha/2012_std_ha/2012_web/2014_std_ha/2016_ent_ha/2016_std_ha/2016_web/2017_std_ha/2017_ent/2019_std_ha/2019_ent**.
        * PostgreSQL: **9.4/10.0/11.0/12.0/13.0**.
        * MariaDB: **10.3**.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set it to true to make some parameter efficient when modifying them. Default to false.
        """
        return pulumi.get(self, "force_restart")

    @force_restart.setter
    def force_restart(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_restart", value)

    @_builtins.property
    @pulumi.getter(name="haMode")
    def ha_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The high availability mode. Valid values:
        * **RPO**: Data persistence is preferred. The instance preferentially ensures data reliability to minimize data loss. Use this mode if you have higher requirements on data consistency.
        * **RTO**: Instance availability is preferred. The instance restores services as soon as possible to ensure availability. Use this mode if you have higher requirements on service availability.
        """
        return pulumi.get(self, "ha_mode")

    @ha_mode.setter
    def ha_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ha_mode", value)

    @_builtins.property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maintainable time period of the instance. Format: <I> HH:mm</I> Z-<I> HH:mm</I> Z(UTC time).
        """
        return pulumi.get(self, "maintain_time")

    @maintain_time.setter
    def maintain_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_time", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RdsUpgradeDbInstanceParameterArgs']]]]:
        """
        Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm). See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RdsUpgradeDbInstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the certificate. 

        > **NOTE:** This parameter is available only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="pgHbaConfs")
    def pg_hba_confs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RdsUpgradeDbInstancePgHbaConfArgs']]]]:
        """
        The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        """
        return pulumi.get(self, "pg_hba_confs")

    @pg_hba_confs.setter
    def pg_hba_confs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RdsUpgradeDbInstancePgHbaConfArgs']]]]):
        pulumi.set(self, "pg_hba_confs", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The intranet IP address of the new instance must be within the specified vSwitch IP address range. By default, the system automatically allocates by using **VPCId** and **VSwitchId**.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The file that contains the private key used for TDE.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="releasedKeepPolicy")
    def released_keep_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The released keep policy.
        """
        return pulumi.get(self, "released_keep_policy")

    @released_keep_policy.setter
    def released_keep_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "released_keep_policy", value)

    @_builtins.property
    @pulumi.getter(name="replicationAcl")
    def replication_acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version, indicating the authentication method of the replication permission. It is only allowed when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
        """
        return pulumi.get(self, "replication_acl")

    @replication_acl.setter
    def replication_acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_acl", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Alibaba Cloud Resource Name (ARN) of a RAM role. A RAM role is a virtual RAM identity that you can create within your Alibaba Cloud account. For more information, see [RAM role overview](https://www.alibabacloud.com/help/en/ram/user-guide/ram-role-overview).

        > **NOTE:** This parameter is available only when the instance runs MySQL.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IP address whitelist of the instance. Separate multiple IP addresses with commas (,) and cannot be repeated. The following two formats are supported:
        * IP address form, for example: 10.23.12.24.
        * CIDR format, for example, 10.23.12.0/24 (no Inter-Domain Routing, 24 indicates the length of the prefix in the address, ranging from 1 to 32).

        > **NOTE:** each instance can add up to 1000 IP addresses or IP segments, that is, the total number of IP addresses or IP segments in all IP whitelist groups cannot exceed 1000. When there are more IP addresses, it is recommended to merge them into IP segments, for example, 10.23.12.0/24.
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_ips", value)

    @_builtins.property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the content of the server certificate. If the CAType value is custom, this parameter must be configured.
        """
        return pulumi.get(self, "server_cert")

    @server_cert.setter
    def server_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_cert", value)

    @_builtins.property
    @pulumi.getter(name="serverKey")
    def server_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the private key of the server certificate. If the value of CAType is custom, this parameter must be configured.
        """
        return pulumi.get(self, "server_key")

    @server_key.setter
    def server_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_key", value)

    @_builtins.property
    @pulumi.getter(name="sourceBiz")
    def source_biz(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source biz.
        """
        return pulumi.get(self, "source_biz")

    @source_biz.setter
    def source_biz(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_biz", value)

    @_builtins.property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Enable or disable SSL. Valid values: `0` and `1`.
        """
        return pulumi.get(self, "ssl_enabled")

    @ssl_enabled.setter
    def ssl_enabled(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ssl_enabled", value)

    @_builtins.property
    @pulumi.getter(name="switchTime")
    def switch_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which you want to apply the specification changes. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        """
        return pulumi.get(self, "switch_time")

    @switch_time.setter
    def switch_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "switch_time", value)

    @_builtins.property
    @pulumi.getter(name="switchTimeMode")
    def switch_time_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which ApsaraDB RDS switches your workloads over to the new instance. This parameter is used together with the SwitchOver parameter and takes effect only when you set the SwitchOver parameter to true. Valid values:
        * **Immediate**: After data is migrated to the new instance, ApsaraDB RDS immediately switches your workloads over to the new instance.
        * **MaintainTime**: After data is migrated to the new instance, ApsaraDB RDS switches your workloads over to the new instance during the maintenance window that you specify. You can call the [ModifyDBInstanceMaintainTime](https://www.alibabacloud.com/help/doc-detail/26249.htm) operation to change the maintenance window of an instance.
        """
        return pulumi.get(self, "switch_time_mode")

    @switch_time_mode.setter
    def switch_time_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "switch_time_mode", value)

    @_builtins.property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [The data replication mode](https://www.alibabacloud.com/help/doc-detail/96055.htm). Valid values:
        * **Sync**: strong synchronization.
        * **Semi-sync**: Semi-synchronous.
        * **Async**: asynchronous.

        > **NOTE:** SQL Server 2017 cluster version is currently not supported.
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_mode", value)

    @_builtins.property
    @pulumi.getter(name="tcpConnectionType")
    def tcp_connection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability check method of the instance. Valid values:
        - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
        - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        """
        return pulumi.get(self, "tcp_connection_type")

    @tcp_connection_type.setter
    def tcp_connection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tcp_connection_type", value)

    @_builtins.property
    @pulumi.getter(name="tdeStatus")
    def tde_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable TDE. Valid values: `Enabled` and `Disabled`.
        """
        return pulumi.get(self, "tde_status")

    @tde_status.setter
    def tde_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tde_status", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC to which the new instance belongs.

        > **NOTE:** Make sure that the VPC resides in the specified region.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vSwitch associated with the specified VPC.

        > **NOTE:** Make sure that the vSwitch belongs to the specified VPC and region.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the zone to which the new instance belongs. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query the most recent region list.

        > **NOTE:** The default value of this parameter is the ID of the zone to which the original instance belongs.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneIdSlave1")
    def zone_id_slave1(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the zone to which the secondary instance of the new instance belongs. You can specify this parameter only when the original instance runs RDS High-availability Edition. You can select a zone that belongs to the region where the original instance resides. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query zone IDs.
        """
        return pulumi.get(self, "zone_id_slave1")

    @zone_id_slave1.setter
    def zone_id_slave1(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id_slave1", value)


@pulumi.input_type
class _RdsUpgradeDbInstanceState:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_type: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 client_cert_revocation_list: Optional[pulumi.Input[_builtins.str]] = None,
                 client_crl_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 collect_stat_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 force_restart: Optional[pulumi.Input[_builtins.bool]] = None,
                 ha_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_time: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['RdsUpgradeDbInstanceParameterArgs']]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pg_hba_confs: Optional[pulumi.Input[Sequence[pulumi.Input['RdsUpgradeDbInstancePgHbaConfArgs']]]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 released_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_acl: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 server_key: Optional[pulumi.Input[_builtins.str]] = None,
                 source_biz: Optional[pulumi.Input[_builtins.str]] = None,
                 source_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 switch_over: Optional[pulumi.Input[_builtins.str]] = None,
                 switch_time: Optional[pulumi.Input[_builtins.str]] = None,
                 switch_time_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 target_major_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tde_status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id_slave1: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RdsUpgradeDbInstance resources.
        :param pulumi.Input[_builtins.str] acl: This parameter is only supported by the RDS PostgreSQL cloud disk version. This parameter indicates the authentication method. It is allowed only when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
        :param pulumi.Input[_builtins.str] auto_upgrade_minor_version: How to upgrade the minor version of the instance. Valid values:
               * **Auto**: automatically upgrade the minor version.
               * **Manual**: It is not automatically upgraded. It is only mandatory when the current version is offline.
        :param pulumi.Input[_builtins.str] ca_type: This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the certificate type. When the value of ssl_action is Open, the default value of this parameter is aliyun. Value range:
               * **aliyun**: using cloud certificates.
               * **custom**: use a custom certificate. Valid values: `aliyun`, `custom`.
        :param pulumi.Input[_builtins.str] certificate: The file that contains the certificate used for TDE.
        :param pulumi.Input[_builtins.str] client_ca_cert: This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the public key of the client certification authority. If the value of client_ca_enabled is 1, this parameter must be configured.
        :param pulumi.Input[_builtins.int] client_ca_enabled: The client ca enabled.
        :param pulumi.Input[_builtins.str] client_cert_revocation_list: This parameter is only supported by the RDS PostgreSQL cloud disk version, which indicates that the client revokes the certificate file. If the value of client_crl_enabled is 1, this parameter must be configured.
        :param pulumi.Input[_builtins.int] client_crl_enabled: The client crl enabled.
        :param pulumi.Input[_builtins.str] collect_stat_mode: The time at which ApsaraDB RDS collects the statistics of the new instance.
               * **Before**: ApsaraDB RDS collects the statistics of the new instance before the switchover to ensure service stability. If the original instance contains a large amount of data, the upgrade may require a long period of time.
               * **After**: ApsaraDB RDS collects the statistics of the new instance after the switchover to accelerate the upgrade. If you access tables for which no statistics are generated, the query plans that you specify may be inaccurately executed. In addition, your database service may be unavailable during peak hours.
               
               > **NOTE** If you set the SwitchOver parameter to false, the value Before specifies that ApsaraDB RDS collects the statistics of the new instance before the new instance starts to process read and write requests, and the value After specifies that ApsaraDB RDS collects the statistics of the new instance after the new instance starts to process read and write requests.
        :param pulumi.Input[_builtins.str] connection_string: The database connection address.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The connection string prefix.
        :param pulumi.Input[_builtins.str] db_instance_class: The instance type of the new instance. For information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
        :param pulumi.Input[_builtins.str] db_instance_description: The db instance description.
        :param pulumi.Input[_builtins.int] db_instance_storage: The storage capacity of the new instance. Unit: GB. The storage capacity increases in increments of 5 GB. For more information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
               
               > **NOTE:** The default value of this parameter is the storage capacity of the original instance.
        :param pulumi.Input[_builtins.str] db_instance_storage_type: The type of storage media that is used for the new instance. Valid values:
               * **local_ssd**: local SSDs.
               * **cloud_ssd**: standard SSDs.
               * **cloud_essd**: enhanced SSDs (ESSDs) of performance level 1 (PL1).
               * **cloud_essd2**: ESSDs of PL2.
               * **cloud_essd3**: ESSDs of PL3.
        :param pulumi.Input[_builtins.str] db_name: The name of the database for which you want to enable TDE. Up to 50 names can be entered in a single request. If you specify multiple names, separate these names with commas (,).
               
               > **NOTE:** This parameter is available and must be specified only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
        :param pulumi.Input[_builtins.str] dedicated_host_group_id: The ID of the dedicated cluster to which the new instance belongs. This parameter takes effect only when you create the new instance in a dedicated cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The switch of delete protection. Valid values:
               - true: delete protect.
               - false: no delete protect.
               
               > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
        :param pulumi.Input[_builtins.str] direction: The direction. Valid values: `Auto`, `Down`, `TempUpgrade`, `Up`.
        :param pulumi.Input[_builtins.str] effective_time: The effective time.
        :param pulumi.Input[_builtins.str] encryption_key: The ID of the private key.
               
               > **NOTE:** This parameter is available only when the instance runs MySQL.
        :param pulumi.Input[_builtins.str] engine: Database type. Value options: MySQL, SQLServer, PostgreSQL.
        :param pulumi.Input[_builtins.str] engine_version: Database version. Value:
               * MySQL: **5.5/5.6/5.7/8.0**.
               * SQL Server: **2008r2/08r2_ent_ha/2012/2012_ent_ha/2012_std_ha/2012_web/2014_std_ha/2016_ent_ha/2016_std_ha/2016_web/2017_std_ha/2017_ent/2019_std_ha/2019_ent**.
               * PostgreSQL: **9.4/10.0/11.0/12.0/13.0**.
               * MariaDB: **10.3**.
        :param pulumi.Input[_builtins.bool] force_restart: Set it to true to make some parameter efficient when modifying them. Default to false.
        :param pulumi.Input[_builtins.str] ha_mode: The high availability mode. Valid values:
               * **RPO**: Data persistence is preferred. The instance preferentially ensures data reliability to minimize data loss. Use this mode if you have higher requirements on data consistency.
               * **RTO**: Instance availability is preferred. The instance restores services as soon as possible to ensure availability. Use this mode if you have higher requirements on service availability.
        :param pulumi.Input[_builtins.str] instance_network_type: The network type of the instance. Valid values:
               * **Classic**: Classic Network.
               * **VPC**: VPC.
        :param pulumi.Input[_builtins.str] maintain_time: The maintainable time period of the instance. Format: <I> HH:mm</I> Z-<I> HH:mm</I> Z(UTC time).
        :param pulumi.Input[Sequence[pulumi.Input['RdsUpgradeDbInstanceParameterArgs']]] parameters: Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm). See `parameters` below.
        :param pulumi.Input[_builtins.str] password: The password of the certificate. 
               
               > **NOTE:** This parameter is available only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the new instance. Valid values: `PayAsYouGo` and `Subscription`.
        :param pulumi.Input[Sequence[pulumi.Input['RdsUpgradeDbInstancePgHbaConfArgs']]] pg_hba_confs: The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        :param pulumi.Input[_builtins.str] port: The port.
        :param pulumi.Input[_builtins.str] private_ip_address: The intranet IP address of the new instance must be within the specified vSwitch IP address range. By default, the system automatically allocates by using **VPCId** and **VSwitchId**.
        :param pulumi.Input[_builtins.str] private_key: The file that contains the private key used for TDE.
        :param pulumi.Input[_builtins.str] released_keep_policy: The released keep policy.
        :param pulumi.Input[_builtins.str] replication_acl: This parameter is only supported by the RDS PostgreSQL cloud disk version, indicating the authentication method of the replication permission. It is only allowed when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group id.
        :param pulumi.Input[_builtins.str] role_arn: The Alibaba Cloud Resource Name (ARN) of a RAM role. A RAM role is a virtual RAM identity that you can create within your Alibaba Cloud account. For more information, see [RAM role overview](https://www.alibabacloud.com/help/en/ram/user-guide/ram-role-overview).
               
               > **NOTE:** This parameter is available only when the instance runs MySQL.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ips: The IP address whitelist of the instance. Separate multiple IP addresses with commas (,) and cannot be repeated. The following two formats are supported:
               * IP address form, for example: 10.23.12.24.
               * CIDR format, for example, 10.23.12.0/24 (no Inter-Domain Routing, 24 indicates the length of the prefix in the address, ranging from 1 to 32).
               
               > **NOTE:** each instance can add up to 1000 IP addresses or IP segments, that is, the total number of IP addresses or IP segments in all IP whitelist groups cannot exceed 1000. When there are more IP addresses, it is recommended to merge them into IP segments, for example, 10.23.12.0/24.
        :param pulumi.Input[_builtins.str] server_cert: This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the content of the server certificate. If the CAType value is custom, this parameter must be configured.
        :param pulumi.Input[_builtins.str] server_key: This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the private key of the server certificate. If the value of CAType is custom, this parameter must be configured.
        :param pulumi.Input[_builtins.str] source_biz: The source biz.
        :param pulumi.Input[_builtins.str] source_db_instance_id: The source db instance id.
        :param pulumi.Input[_builtins.int] ssl_enabled: Enable or disable SSL. Valid values: `0` and `1`.
        :param pulumi.Input[_builtins.str] switch_over: Specifies whether ApsaraDB RDS automatically switches your workloads over to the new instance after data is migrated to the new instance. Valid values:
               * **true**: ApsaraDB RDS automatically switches workloads over to the new instance. If you set this parameter to true, you must take note of the following information:
               * After the switchover is complete, you cannot roll your workloads back to the original instance. Proceed with caution.
               * During the switchover, the original instance processes only read requests. You must perform the switchover during off-peak hours.
               * If read-only instances are attached to the original instance, you can set this parameter only to false. In this case, the read-only instances that are attached to the original instance cannot be cloned. After the upgrade is complete, you must create read-only instances for the new instance.
               * **false**: ApsaraDB RDS does not automatically switch your workloads over to the new instance. Before you perform an upgrade, we recommend that you set this parameter to false to test whether the new major engine version is compatible with your workloads. If you set this parameter to false, you must take note of the following information:
               * The data migration does not interrupt your workloads on the original instance.
               * After data is migrated to the new instance, you must update the endpoint configuration on your application. This update requires you to replace the endpoint of the original instance with the endpoint of the new instance. For more information about how to view the endpoint of an instance, see [View and change the internal and public endpoints and port numbers of an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/doc-detail/96788.htm).
        :param pulumi.Input[_builtins.str] switch_time: The time at which you want to apply the specification changes. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        :param pulumi.Input[_builtins.str] switch_time_mode: The time at which ApsaraDB RDS switches your workloads over to the new instance. This parameter is used together with the SwitchOver parameter and takes effect only when you set the SwitchOver parameter to true. Valid values:
               * **Immediate**: After data is migrated to the new instance, ApsaraDB RDS immediately switches your workloads over to the new instance.
               * **MaintainTime**: After data is migrated to the new instance, ApsaraDB RDS switches your workloads over to the new instance during the maintenance window that you specify. You can call the [ModifyDBInstanceMaintainTime](https://www.alibabacloud.com/help/doc-detail/26249.htm) operation to change the maintenance window of an instance.
        :param pulumi.Input[_builtins.str] sync_mode: [The data replication mode](https://www.alibabacloud.com/help/doc-detail/96055.htm). Valid values:
               * **Sync**: strong synchronization.
               * **Semi-sync**: Semi-synchronous.
               * **Async**: asynchronous.
               
               > **NOTE:** SQL Server 2017 cluster version is currently not supported.
        :param pulumi.Input[_builtins.str] target_major_version: The major engine version of the new instance. The value of this parameter must be the major engine version on which an upgrade check is performed.
               
               > **NOTE** You can call the [UpgradeDBInstanceMajorVersionPrecheck](https://www.alibabacloud.com/help/doc-detail/330050.htm) operation to perform an upgrade check on a major engine version.
        :param pulumi.Input[_builtins.str] tcp_connection_type: The availability check method of the instance. Valid values:
               - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
               - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        :param pulumi.Input[_builtins.str] tde_status: Specifies whether to enable TDE. Valid values: `Enabled` and `Disabled`.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to which the new instance belongs.
               
               > **NOTE:** Make sure that the VPC resides in the specified region.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch associated with the specified VPC.
               
               > **NOTE:** Make sure that the vSwitch belongs to the specified VPC and region.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone to which the new instance belongs. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query the most recent region list.
               
               > **NOTE:** The default value of this parameter is the ID of the zone to which the original instance belongs.
        :param pulumi.Input[_builtins.str] zone_id_slave1: The ID of the zone to which the secondary instance of the new instance belongs. You can specify this parameter only when the original instance runs RDS High-availability Edition. You can select a zone that belongs to the region where the original instance resides. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query zone IDs.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if ca_type is not None:
            pulumi.set(__self__, "ca_type", ca_type)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if client_ca_cert is not None:
            pulumi.set(__self__, "client_ca_cert", client_ca_cert)
        if client_ca_enabled is not None:
            pulumi.set(__self__, "client_ca_enabled", client_ca_enabled)
        if client_cert_revocation_list is not None:
            pulumi.set(__self__, "client_cert_revocation_list", client_cert_revocation_list)
        if client_crl_enabled is not None:
            pulumi.set(__self__, "client_crl_enabled", client_crl_enabled)
        if collect_stat_mode is not None:
            pulumi.set(__self__, "collect_stat_mode", collect_stat_mode)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if connection_string_prefix is not None:
            pulumi.set(__self__, "connection_string_prefix", connection_string_prefix)
        if db_instance_class is not None:
            pulumi.set(__self__, "db_instance_class", db_instance_class)
        if db_instance_description is not None:
            pulumi.set(__self__, "db_instance_description", db_instance_description)
        if db_instance_storage is not None:
            pulumi.set(__self__, "db_instance_storage", db_instance_storage)
        if db_instance_storage_type is not None:
            pulumi.set(__self__, "db_instance_storage_type", db_instance_storage_type)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if dedicated_host_group_id is not None:
            pulumi.set(__self__, "dedicated_host_group_id", dedicated_host_group_id)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)
        if ha_mode is not None:
            pulumi.set(__self__, "ha_mode", ha_mode)
        if instance_network_type is not None:
            pulumi.set(__self__, "instance_network_type", instance_network_type)
        if maintain_time is not None:
            pulumi.set(__self__, "maintain_time", maintain_time)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if pg_hba_confs is not None:
            pulumi.set(__self__, "pg_hba_confs", pg_hba_confs)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if released_keep_policy is not None:
            pulumi.set(__self__, "released_keep_policy", released_keep_policy)
        if replication_acl is not None:
            pulumi.set(__self__, "replication_acl", replication_acl)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if security_ips is not None:
            pulumi.set(__self__, "security_ips", security_ips)
        if server_cert is not None:
            pulumi.set(__self__, "server_cert", server_cert)
        if server_key is not None:
            pulumi.set(__self__, "server_key", server_key)
        if source_biz is not None:
            pulumi.set(__self__, "source_biz", source_biz)
        if source_db_instance_id is not None:
            pulumi.set(__self__, "source_db_instance_id", source_db_instance_id)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)
        if switch_over is not None:
            pulumi.set(__self__, "switch_over", switch_over)
        if switch_time is not None:
            pulumi.set(__self__, "switch_time", switch_time)
        if switch_time_mode is not None:
            pulumi.set(__self__, "switch_time_mode", switch_time_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)
        if target_major_version is not None:
            pulumi.set(__self__, "target_major_version", target_major_version)
        if tcp_connection_type is not None:
            pulumi.set(__self__, "tcp_connection_type", tcp_connection_type)
        if tde_status is not None:
            pulumi.set(__self__, "tde_status", tde_status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)
        if zone_id_slave1 is not None:
            pulumi.set(__self__, "zone_id_slave1", zone_id_slave1)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version. This parameter indicates the authentication method. It is allowed only when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How to upgrade the minor version of the instance. Valid values:
        * **Auto**: automatically upgrade the minor version.
        * **Manual**: It is not automatically upgraded. It is only mandatory when the current version is offline.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @auto_upgrade_minor_version.setter
    def auto_upgrade_minor_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_upgrade_minor_version", value)

    @_builtins.property
    @pulumi.getter(name="caType")
    def ca_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the certificate type. When the value of ssl_action is Open, the default value of this parameter is aliyun. Value range:
        * **aliyun**: using cloud certificates.
        * **custom**: use a custom certificate. Valid values: `aliyun`, `custom`.
        """
        return pulumi.get(self, "ca_type")

    @ca_type.setter
    def ca_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_type", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The file that contains the certificate used for TDE.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="clientCaCert")
    def client_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the public key of the client certification authority. If the value of client_ca_enabled is 1, this parameter must be configured.
        """
        return pulumi.get(self, "client_ca_cert")

    @client_ca_cert.setter
    def client_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientCaEnabled")
    def client_ca_enabled(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The client ca enabled.
        """
        return pulumi.get(self, "client_ca_enabled")

    @client_ca_enabled.setter
    def client_ca_enabled(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_ca_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientCertRevocationList")
    def client_cert_revocation_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version, which indicates that the client revokes the certificate file. If the value of client_crl_enabled is 1, this parameter must be configured.
        """
        return pulumi.get(self, "client_cert_revocation_list")

    @client_cert_revocation_list.setter
    def client_cert_revocation_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert_revocation_list", value)

    @_builtins.property
    @pulumi.getter(name="clientCrlEnabled")
    def client_crl_enabled(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The client crl enabled.
        """
        return pulumi.get(self, "client_crl_enabled")

    @client_crl_enabled.setter
    def client_crl_enabled(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_crl_enabled", value)

    @_builtins.property
    @pulumi.getter(name="collectStatMode")
    def collect_stat_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which ApsaraDB RDS collects the statistics of the new instance.
        * **Before**: ApsaraDB RDS collects the statistics of the new instance before the switchover to ensure service stability. If the original instance contains a large amount of data, the upgrade may require a long period of time.
        * **After**: ApsaraDB RDS collects the statistics of the new instance after the switchover to accelerate the upgrade. If you access tables for which no statistics are generated, the query plans that you specify may be inaccurately executed. In addition, your database service may be unavailable during peak hours.

        > **NOTE** If you set the SwitchOver parameter to false, the value Before specifies that ApsaraDB RDS collects the statistics of the new instance before the new instance starts to process read and write requests, and the value After specifies that ApsaraDB RDS collects the statistics of the new instance after the new instance starts to process read and write requests.
        """
        return pulumi.get(self, "collect_stat_mode")

    @collect_stat_mode.setter
    def collect_stat_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collect_stat_mode", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database connection address.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection string prefix.
        """
        return pulumi.get(self, "connection_string_prefix")

    @connection_string_prefix.setter
    def connection_string_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string_prefix", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceClass")
    def db_instance_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance type of the new instance. For information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
        """
        return pulumi.get(self, "db_instance_class")

    @db_instance_class.setter
    def db_instance_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_class", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The db instance description.
        """
        return pulumi.get(self, "db_instance_description")

    @db_instance_description.setter
    def db_instance_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_description", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceStorage")
    def db_instance_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The storage capacity of the new instance. Unit: GB. The storage capacity increases in increments of 5 GB. For more information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).

        > **NOTE:** The default value of this parameter is the storage capacity of the original instance.
        """
        return pulumi.get(self, "db_instance_storage")

    @db_instance_storage.setter
    def db_instance_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "db_instance_storage", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of storage media that is used for the new instance. Valid values:
        * **local_ssd**: local SSDs.
        * **cloud_ssd**: standard SSDs.
        * **cloud_essd**: enhanced SSDs (ESSDs) of performance level 1 (PL1).
        * **cloud_essd2**: ESSDs of PL2.
        * **cloud_essd3**: ESSDs of PL3.
        """
        return pulumi.get(self, "db_instance_storage_type")

    @db_instance_storage_type.setter
    def db_instance_storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_storage_type", value)

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database for which you want to enable TDE. Up to 50 names can be entered in a single request. If you specify multiple names, separate these names with commas (,).

        > **NOTE:** This parameter is available and must be specified only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_name", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated cluster to which the new instance belongs. This parameter takes effect only when you create the new instance in a dedicated cluster.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @dedicated_host_group_id.setter
    def dedicated_host_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_host_group_id", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The switch of delete protection. Valid values:
        - true: delete protect.
        - false: no delete protect.

        > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The direction. Valid values: `Auto`, `Down`, `TempUpgrade`, `Up`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The effective time.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_time", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the private key.

        > **NOTE:** This parameter is available only when the instance runs MySQL.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database type. Value options: MySQL, SQLServer, PostgreSQL.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database version. Value:
        * MySQL: **5.5/5.6/5.7/8.0**.
        * SQL Server: **2008r2/08r2_ent_ha/2012/2012_ent_ha/2012_std_ha/2012_web/2014_std_ha/2016_ent_ha/2016_std_ha/2016_web/2017_std_ha/2017_ent/2019_std_ha/2019_ent**.
        * PostgreSQL: **9.4/10.0/11.0/12.0/13.0**.
        * MariaDB: **10.3**.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set it to true to make some parameter efficient when modifying them. Default to false.
        """
        return pulumi.get(self, "force_restart")

    @force_restart.setter
    def force_restart(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_restart", value)

    @_builtins.property
    @pulumi.getter(name="haMode")
    def ha_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The high availability mode. Valid values:
        * **RPO**: Data persistence is preferred. The instance preferentially ensures data reliability to minimize data loss. Use this mode if you have higher requirements on data consistency.
        * **RTO**: Instance availability is preferred. The instance restores services as soon as possible to ensure availability. Use this mode if you have higher requirements on service availability.
        """
        return pulumi.get(self, "ha_mode")

    @ha_mode.setter
    def ha_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ha_mode", value)

    @_builtins.property
    @pulumi.getter(name="instanceNetworkType")
    def instance_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the instance. Valid values:
        * **Classic**: Classic Network.
        * **VPC**: VPC.
        """
        return pulumi.get(self, "instance_network_type")

    @instance_network_type.setter
    def instance_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_network_type", value)

    @_builtins.property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maintainable time period of the instance. Format: <I> HH:mm</I> Z-<I> HH:mm</I> Z(UTC time).
        """
        return pulumi.get(self, "maintain_time")

    @maintain_time.setter
    def maintain_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_time", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RdsUpgradeDbInstanceParameterArgs']]]]:
        """
        Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm). See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RdsUpgradeDbInstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the certificate. 

        > **NOTE:** This parameter is available only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the new instance. Valid values: `PayAsYouGo` and `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="pgHbaConfs")
    def pg_hba_confs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RdsUpgradeDbInstancePgHbaConfArgs']]]]:
        """
        The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        """
        return pulumi.get(self, "pg_hba_confs")

    @pg_hba_confs.setter
    def pg_hba_confs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RdsUpgradeDbInstancePgHbaConfArgs']]]]):
        pulumi.set(self, "pg_hba_confs", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The intranet IP address of the new instance must be within the specified vSwitch IP address range. By default, the system automatically allocates by using **VPCId** and **VSwitchId**.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The file that contains the private key used for TDE.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="releasedKeepPolicy")
    def released_keep_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The released keep policy.
        """
        return pulumi.get(self, "released_keep_policy")

    @released_keep_policy.setter
    def released_keep_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "released_keep_policy", value)

    @_builtins.property
    @pulumi.getter(name="replicationAcl")
    def replication_acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version, indicating the authentication method of the replication permission. It is only allowed when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
        """
        return pulumi.get(self, "replication_acl")

    @replication_acl.setter
    def replication_acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_acl", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Alibaba Cloud Resource Name (ARN) of a RAM role. A RAM role is a virtual RAM identity that you can create within your Alibaba Cloud account. For more information, see [RAM role overview](https://www.alibabacloud.com/help/en/ram/user-guide/ram-role-overview).

        > **NOTE:** This parameter is available only when the instance runs MySQL.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IP address whitelist of the instance. Separate multiple IP addresses with commas (,) and cannot be repeated. The following two formats are supported:
        * IP address form, for example: 10.23.12.24.
        * CIDR format, for example, 10.23.12.0/24 (no Inter-Domain Routing, 24 indicates the length of the prefix in the address, ranging from 1 to 32).

        > **NOTE:** each instance can add up to 1000 IP addresses or IP segments, that is, the total number of IP addresses or IP segments in all IP whitelist groups cannot exceed 1000. When there are more IP addresses, it is recommended to merge them into IP segments, for example, 10.23.12.0/24.
        """
        return pulumi.get(self, "security_ips")

    @security_ips.setter
    def security_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_ips", value)

    @_builtins.property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the content of the server certificate. If the CAType value is custom, this parameter must be configured.
        """
        return pulumi.get(self, "server_cert")

    @server_cert.setter
    def server_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_cert", value)

    @_builtins.property
    @pulumi.getter(name="serverKey")
    def server_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the private key of the server certificate. If the value of CAType is custom, this parameter must be configured.
        """
        return pulumi.get(self, "server_key")

    @server_key.setter
    def server_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_key", value)

    @_builtins.property
    @pulumi.getter(name="sourceBiz")
    def source_biz(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source biz.
        """
        return pulumi.get(self, "source_biz")

    @source_biz.setter
    def source_biz(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_biz", value)

    @_builtins.property
    @pulumi.getter(name="sourceDbInstanceId")
    def source_db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source db instance id.
        """
        return pulumi.get(self, "source_db_instance_id")

    @source_db_instance_id.setter
    def source_db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Enable or disable SSL. Valid values: `0` and `1`.
        """
        return pulumi.get(self, "ssl_enabled")

    @ssl_enabled.setter
    def ssl_enabled(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ssl_enabled", value)

    @_builtins.property
    @pulumi.getter(name="switchOver")
    def switch_over(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether ApsaraDB RDS automatically switches your workloads over to the new instance after data is migrated to the new instance. Valid values:
        * **true**: ApsaraDB RDS automatically switches workloads over to the new instance. If you set this parameter to true, you must take note of the following information:
        * After the switchover is complete, you cannot roll your workloads back to the original instance. Proceed with caution.
        * During the switchover, the original instance processes only read requests. You must perform the switchover during off-peak hours.
        * If read-only instances are attached to the original instance, you can set this parameter only to false. In this case, the read-only instances that are attached to the original instance cannot be cloned. After the upgrade is complete, you must create read-only instances for the new instance.
        * **false**: ApsaraDB RDS does not automatically switch your workloads over to the new instance. Before you perform an upgrade, we recommend that you set this parameter to false to test whether the new major engine version is compatible with your workloads. If you set this parameter to false, you must take note of the following information:
        * The data migration does not interrupt your workloads on the original instance.
        * After data is migrated to the new instance, you must update the endpoint configuration on your application. This update requires you to replace the endpoint of the original instance with the endpoint of the new instance. For more information about how to view the endpoint of an instance, see [View and change the internal and public endpoints and port numbers of an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/doc-detail/96788.htm).
        """
        return pulumi.get(self, "switch_over")

    @switch_over.setter
    def switch_over(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "switch_over", value)

    @_builtins.property
    @pulumi.getter(name="switchTime")
    def switch_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which you want to apply the specification changes. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        """
        return pulumi.get(self, "switch_time")

    @switch_time.setter
    def switch_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "switch_time", value)

    @_builtins.property
    @pulumi.getter(name="switchTimeMode")
    def switch_time_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which ApsaraDB RDS switches your workloads over to the new instance. This parameter is used together with the SwitchOver parameter and takes effect only when you set the SwitchOver parameter to true. Valid values:
        * **Immediate**: After data is migrated to the new instance, ApsaraDB RDS immediately switches your workloads over to the new instance.
        * **MaintainTime**: After data is migrated to the new instance, ApsaraDB RDS switches your workloads over to the new instance during the maintenance window that you specify. You can call the [ModifyDBInstanceMaintainTime](https://www.alibabacloud.com/help/doc-detail/26249.htm) operation to change the maintenance window of an instance.
        """
        return pulumi.get(self, "switch_time_mode")

    @switch_time_mode.setter
    def switch_time_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "switch_time_mode", value)

    @_builtins.property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [The data replication mode](https://www.alibabacloud.com/help/doc-detail/96055.htm). Valid values:
        * **Sync**: strong synchronization.
        * **Semi-sync**: Semi-synchronous.
        * **Async**: asynchronous.

        > **NOTE:** SQL Server 2017 cluster version is currently not supported.
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_mode", value)

    @_builtins.property
    @pulumi.getter(name="targetMajorVersion")
    def target_major_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The major engine version of the new instance. The value of this parameter must be the major engine version on which an upgrade check is performed.

        > **NOTE** You can call the [UpgradeDBInstanceMajorVersionPrecheck](https://www.alibabacloud.com/help/doc-detail/330050.htm) operation to perform an upgrade check on a major engine version.
        """
        return pulumi.get(self, "target_major_version")

    @target_major_version.setter
    def target_major_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_major_version", value)

    @_builtins.property
    @pulumi.getter(name="tcpConnectionType")
    def tcp_connection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability check method of the instance. Valid values:
        - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
        - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        """
        return pulumi.get(self, "tcp_connection_type")

    @tcp_connection_type.setter
    def tcp_connection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tcp_connection_type", value)

    @_builtins.property
    @pulumi.getter(name="tdeStatus")
    def tde_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable TDE. Valid values: `Enabled` and `Disabled`.
        """
        return pulumi.get(self, "tde_status")

    @tde_status.setter
    def tde_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tde_status", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC to which the new instance belongs.

        > **NOTE:** Make sure that the VPC resides in the specified region.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vSwitch associated with the specified VPC.

        > **NOTE:** Make sure that the vSwitch belongs to the specified VPC and region.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the zone to which the new instance belongs. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query the most recent region list.

        > **NOTE:** The default value of this parameter is the ID of the zone to which the original instance belongs.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneIdSlave1")
    def zone_id_slave1(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the zone to which the secondary instance of the new instance belongs. You can specify this parameter only when the original instance runs RDS High-availability Edition. You can select a zone that belongs to the region where the original instance resides. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query zone IDs.
        """
        return pulumi.get(self, "zone_id_slave1")

    @zone_id_slave1.setter
    def zone_id_slave1(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id_slave1", value)


@pulumi.type_token("alicloud:rds/rdsUpgradeDbInstance:RdsUpgradeDbInstance")
class RdsUpgradeDbInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_type: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 client_cert_revocation_list: Optional[pulumi.Input[_builtins.str]] = None,
                 client_crl_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 collect_stat_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 force_restart: Optional[pulumi.Input[_builtins.bool]] = None,
                 ha_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_time: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RdsUpgradeDbInstanceParameterArgs', 'RdsUpgradeDbInstanceParameterArgsDict']]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pg_hba_confs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RdsUpgradeDbInstancePgHbaConfArgs', 'RdsUpgradeDbInstancePgHbaConfArgsDict']]]]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 released_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_acl: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 server_key: Optional[pulumi.Input[_builtins.str]] = None,
                 source_biz: Optional[pulumi.Input[_builtins.str]] = None,
                 source_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 switch_over: Optional[pulumi.Input[_builtins.str]] = None,
                 switch_time: Optional[pulumi.Input[_builtins.str]] = None,
                 switch_time_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 target_major_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tde_status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id_slave1: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RDS Upgrade DB Instance resource.

        For information about RDS Upgrade DB Instance and how to use it, see [What is ApsaraDB for RDS](https://www.alibabacloud.com/help/en/doc-detail/26092.htm).

        > **NOTE:** Available since v1.153.0.

        ## Example Usage

        ### Create a RDS PostgreSQL upgrade instance

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.rds.get_zones(engine="PostgreSQL",
            engine_version="13.0",
            instance_charge_type="PostPaid",
            category="HighAvailability",
            db_instance_storage_type="cloud_essd")
        example_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=example.zones[0].id,
            engine="PostgreSQL",
            engine_version="13.0",
            category="HighAvailability",
            db_instance_storage_type="cloud_essd",
            instance_charge_type="PostPaid")
        example_get_cross_regions = alicloud.rds.get_cross_regions()
        example_network = alicloud.vpc.Network("example",
            vpc_name="terraform-example",
            cidr_block="172.16.0.0/16")
        example_switch = alicloud.vpc.Switch("example",
            vpc_id=example_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=example.zones[0].id,
            vswitch_name="terraform-example")
        example_instance = alicloud.rds.Instance("example",
            engine="PostgreSQL",
            engine_version="13.0",
            db_instance_storage_type="cloud_essd",
            instance_type=example_get_instance_classes.instance_classes[0].instance_class,
            instance_storage=example_get_instance_classes.instance_classes[0].storage_range.min,
            instance_charge_type="Postpaid",
            instance_name="terraform-example",
            vswitch_id=example_switch.id,
            monitoring_period=60)
        example_rds_upgrade_db_instance = alicloud.rds.RdsUpgradeDbInstance("example",
            source_db_instance_id=example_instance.id,
            target_major_version="14.0",
            db_instance_class=example_instance.instance_type,
            db_instance_storage=example_instance.instance_storage,
            db_instance_storage_type=example_instance.db_instance_storage_type,
            instance_network_type="VPC",
            collect_stat_mode="After",
            switch_over="false",
            payment_type="PayAsYouGo",
            db_instance_description="terraform-example",
            vswitch_id=example_switch.id)
        ```

        ## Import

        RDS Upgrade DB Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rds/rdsUpgradeDbInstance:RdsUpgradeDbInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl: This parameter is only supported by the RDS PostgreSQL cloud disk version. This parameter indicates the authentication method. It is allowed only when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
        :param pulumi.Input[_builtins.str] auto_upgrade_minor_version: How to upgrade the minor version of the instance. Valid values:
               * **Auto**: automatically upgrade the minor version.
               * **Manual**: It is not automatically upgraded. It is only mandatory when the current version is offline.
        :param pulumi.Input[_builtins.str] ca_type: This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the certificate type. When the value of ssl_action is Open, the default value of this parameter is aliyun. Value range:
               * **aliyun**: using cloud certificates.
               * **custom**: use a custom certificate. Valid values: `aliyun`, `custom`.
        :param pulumi.Input[_builtins.str] certificate: The file that contains the certificate used for TDE.
        :param pulumi.Input[_builtins.str] client_ca_cert: This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the public key of the client certification authority. If the value of client_ca_enabled is 1, this parameter must be configured.
        :param pulumi.Input[_builtins.int] client_ca_enabled: The client ca enabled.
        :param pulumi.Input[_builtins.str] client_cert_revocation_list: This parameter is only supported by the RDS PostgreSQL cloud disk version, which indicates that the client revokes the certificate file. If the value of client_crl_enabled is 1, this parameter must be configured.
        :param pulumi.Input[_builtins.int] client_crl_enabled: The client crl enabled.
        :param pulumi.Input[_builtins.str] collect_stat_mode: The time at which ApsaraDB RDS collects the statistics of the new instance.
               * **Before**: ApsaraDB RDS collects the statistics of the new instance before the switchover to ensure service stability. If the original instance contains a large amount of data, the upgrade may require a long period of time.
               * **After**: ApsaraDB RDS collects the statistics of the new instance after the switchover to accelerate the upgrade. If you access tables for which no statistics are generated, the query plans that you specify may be inaccurately executed. In addition, your database service may be unavailable during peak hours.
               
               > **NOTE** If you set the SwitchOver parameter to false, the value Before specifies that ApsaraDB RDS collects the statistics of the new instance before the new instance starts to process read and write requests, and the value After specifies that ApsaraDB RDS collects the statistics of the new instance after the new instance starts to process read and write requests.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The connection string prefix.
        :param pulumi.Input[_builtins.str] db_instance_class: The instance type of the new instance. For information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
        :param pulumi.Input[_builtins.str] db_instance_description: The db instance description.
        :param pulumi.Input[_builtins.int] db_instance_storage: The storage capacity of the new instance. Unit: GB. The storage capacity increases in increments of 5 GB. For more information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
               
               > **NOTE:** The default value of this parameter is the storage capacity of the original instance.
        :param pulumi.Input[_builtins.str] db_instance_storage_type: The type of storage media that is used for the new instance. Valid values:
               * **local_ssd**: local SSDs.
               * **cloud_ssd**: standard SSDs.
               * **cloud_essd**: enhanced SSDs (ESSDs) of performance level 1 (PL1).
               * **cloud_essd2**: ESSDs of PL2.
               * **cloud_essd3**: ESSDs of PL3.
        :param pulumi.Input[_builtins.str] db_name: The name of the database for which you want to enable TDE. Up to 50 names can be entered in a single request. If you specify multiple names, separate these names with commas (,).
               
               > **NOTE:** This parameter is available and must be specified only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
        :param pulumi.Input[_builtins.str] dedicated_host_group_id: The ID of the dedicated cluster to which the new instance belongs. This parameter takes effect only when you create the new instance in a dedicated cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The switch of delete protection. Valid values:
               - true: delete protect.
               - false: no delete protect.
               
               > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
        :param pulumi.Input[_builtins.str] direction: The direction. Valid values: `Auto`, `Down`, `TempUpgrade`, `Up`.
        :param pulumi.Input[_builtins.str] effective_time: The effective time.
        :param pulumi.Input[_builtins.str] encryption_key: The ID of the private key.
               
               > **NOTE:** This parameter is available only when the instance runs MySQL.
        :param pulumi.Input[_builtins.str] engine: Database type. Value options: MySQL, SQLServer, PostgreSQL.
        :param pulumi.Input[_builtins.str] engine_version: Database version. Value:
               * MySQL: **5.5/5.6/5.7/8.0**.
               * SQL Server: **2008r2/08r2_ent_ha/2012/2012_ent_ha/2012_std_ha/2012_web/2014_std_ha/2016_ent_ha/2016_std_ha/2016_web/2017_std_ha/2017_ent/2019_std_ha/2019_ent**.
               * PostgreSQL: **9.4/10.0/11.0/12.0/13.0**.
               * MariaDB: **10.3**.
        :param pulumi.Input[_builtins.bool] force_restart: Set it to true to make some parameter efficient when modifying them. Default to false.
        :param pulumi.Input[_builtins.str] ha_mode: The high availability mode. Valid values:
               * **RPO**: Data persistence is preferred. The instance preferentially ensures data reliability to minimize data loss. Use this mode if you have higher requirements on data consistency.
               * **RTO**: Instance availability is preferred. The instance restores services as soon as possible to ensure availability. Use this mode if you have higher requirements on service availability.
        :param pulumi.Input[_builtins.str] instance_network_type: The network type of the instance. Valid values:
               * **Classic**: Classic Network.
               * **VPC**: VPC.
        :param pulumi.Input[_builtins.str] maintain_time: The maintainable time period of the instance. Format: <I> HH:mm</I> Z-<I> HH:mm</I> Z(UTC time).
        :param pulumi.Input[Sequence[pulumi.Input[Union['RdsUpgradeDbInstanceParameterArgs', 'RdsUpgradeDbInstanceParameterArgsDict']]]] parameters: Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm). See `parameters` below.
        :param pulumi.Input[_builtins.str] password: The password of the certificate. 
               
               > **NOTE:** This parameter is available only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the new instance. Valid values: `PayAsYouGo` and `Subscription`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RdsUpgradeDbInstancePgHbaConfArgs', 'RdsUpgradeDbInstancePgHbaConfArgsDict']]]] pg_hba_confs: The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        :param pulumi.Input[_builtins.str] port: The port.
        :param pulumi.Input[_builtins.str] private_ip_address: The intranet IP address of the new instance must be within the specified vSwitch IP address range. By default, the system automatically allocates by using **VPCId** and **VSwitchId**.
        :param pulumi.Input[_builtins.str] private_key: The file that contains the private key used for TDE.
        :param pulumi.Input[_builtins.str] released_keep_policy: The released keep policy.
        :param pulumi.Input[_builtins.str] replication_acl: This parameter is only supported by the RDS PostgreSQL cloud disk version, indicating the authentication method of the replication permission. It is only allowed when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group id.
        :param pulumi.Input[_builtins.str] role_arn: The Alibaba Cloud Resource Name (ARN) of a RAM role. A RAM role is a virtual RAM identity that you can create within your Alibaba Cloud account. For more information, see [RAM role overview](https://www.alibabacloud.com/help/en/ram/user-guide/ram-role-overview).
               
               > **NOTE:** This parameter is available only when the instance runs MySQL.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ips: The IP address whitelist of the instance. Separate multiple IP addresses with commas (,) and cannot be repeated. The following two formats are supported:
               * IP address form, for example: 10.23.12.24.
               * CIDR format, for example, 10.23.12.0/24 (no Inter-Domain Routing, 24 indicates the length of the prefix in the address, ranging from 1 to 32).
               
               > **NOTE:** each instance can add up to 1000 IP addresses or IP segments, that is, the total number of IP addresses or IP segments in all IP whitelist groups cannot exceed 1000. When there are more IP addresses, it is recommended to merge them into IP segments, for example, 10.23.12.0/24.
        :param pulumi.Input[_builtins.str] server_cert: This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the content of the server certificate. If the CAType value is custom, this parameter must be configured.
        :param pulumi.Input[_builtins.str] server_key: This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the private key of the server certificate. If the value of CAType is custom, this parameter must be configured.
        :param pulumi.Input[_builtins.str] source_biz: The source biz.
        :param pulumi.Input[_builtins.str] source_db_instance_id: The source db instance id.
        :param pulumi.Input[_builtins.int] ssl_enabled: Enable or disable SSL. Valid values: `0` and `1`.
        :param pulumi.Input[_builtins.str] switch_over: Specifies whether ApsaraDB RDS automatically switches your workloads over to the new instance after data is migrated to the new instance. Valid values:
               * **true**: ApsaraDB RDS automatically switches workloads over to the new instance. If you set this parameter to true, you must take note of the following information:
               * After the switchover is complete, you cannot roll your workloads back to the original instance. Proceed with caution.
               * During the switchover, the original instance processes only read requests. You must perform the switchover during off-peak hours.
               * If read-only instances are attached to the original instance, you can set this parameter only to false. In this case, the read-only instances that are attached to the original instance cannot be cloned. After the upgrade is complete, you must create read-only instances for the new instance.
               * **false**: ApsaraDB RDS does not automatically switch your workloads over to the new instance. Before you perform an upgrade, we recommend that you set this parameter to false to test whether the new major engine version is compatible with your workloads. If you set this parameter to false, you must take note of the following information:
               * The data migration does not interrupt your workloads on the original instance.
               * After data is migrated to the new instance, you must update the endpoint configuration on your application. This update requires you to replace the endpoint of the original instance with the endpoint of the new instance. For more information about how to view the endpoint of an instance, see [View and change the internal and public endpoints and port numbers of an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/doc-detail/96788.htm).
        :param pulumi.Input[_builtins.str] switch_time: The time at which you want to apply the specification changes. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        :param pulumi.Input[_builtins.str] switch_time_mode: The time at which ApsaraDB RDS switches your workloads over to the new instance. This parameter is used together with the SwitchOver parameter and takes effect only when you set the SwitchOver parameter to true. Valid values:
               * **Immediate**: After data is migrated to the new instance, ApsaraDB RDS immediately switches your workloads over to the new instance.
               * **MaintainTime**: After data is migrated to the new instance, ApsaraDB RDS switches your workloads over to the new instance during the maintenance window that you specify. You can call the [ModifyDBInstanceMaintainTime](https://www.alibabacloud.com/help/doc-detail/26249.htm) operation to change the maintenance window of an instance.
        :param pulumi.Input[_builtins.str] sync_mode: [The data replication mode](https://www.alibabacloud.com/help/doc-detail/96055.htm). Valid values:
               * **Sync**: strong synchronization.
               * **Semi-sync**: Semi-synchronous.
               * **Async**: asynchronous.
               
               > **NOTE:** SQL Server 2017 cluster version is currently not supported.
        :param pulumi.Input[_builtins.str] target_major_version: The major engine version of the new instance. The value of this parameter must be the major engine version on which an upgrade check is performed.
               
               > **NOTE** You can call the [UpgradeDBInstanceMajorVersionPrecheck](https://www.alibabacloud.com/help/doc-detail/330050.htm) operation to perform an upgrade check on a major engine version.
        :param pulumi.Input[_builtins.str] tcp_connection_type: The availability check method of the instance. Valid values:
               - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
               - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        :param pulumi.Input[_builtins.str] tde_status: Specifies whether to enable TDE. Valid values: `Enabled` and `Disabled`.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to which the new instance belongs.
               
               > **NOTE:** Make sure that the VPC resides in the specified region.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch associated with the specified VPC.
               
               > **NOTE:** Make sure that the vSwitch belongs to the specified VPC and region.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone to which the new instance belongs. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query the most recent region list.
               
               > **NOTE:** The default value of this parameter is the ID of the zone to which the original instance belongs.
        :param pulumi.Input[_builtins.str] zone_id_slave1: The ID of the zone to which the secondary instance of the new instance belongs. You can specify this parameter only when the original instance runs RDS High-availability Edition. You can select a zone that belongs to the region where the original instance resides. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query zone IDs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RdsUpgradeDbInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RDS Upgrade DB Instance resource.

        For information about RDS Upgrade DB Instance and how to use it, see [What is ApsaraDB for RDS](https://www.alibabacloud.com/help/en/doc-detail/26092.htm).

        > **NOTE:** Available since v1.153.0.

        ## Example Usage

        ### Create a RDS PostgreSQL upgrade instance

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.rds.get_zones(engine="PostgreSQL",
            engine_version="13.0",
            instance_charge_type="PostPaid",
            category="HighAvailability",
            db_instance_storage_type="cloud_essd")
        example_get_instance_classes = alicloud.rds.get_instance_classes(zone_id=example.zones[0].id,
            engine="PostgreSQL",
            engine_version="13.0",
            category="HighAvailability",
            db_instance_storage_type="cloud_essd",
            instance_charge_type="PostPaid")
        example_get_cross_regions = alicloud.rds.get_cross_regions()
        example_network = alicloud.vpc.Network("example",
            vpc_name="terraform-example",
            cidr_block="172.16.0.0/16")
        example_switch = alicloud.vpc.Switch("example",
            vpc_id=example_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=example.zones[0].id,
            vswitch_name="terraform-example")
        example_instance = alicloud.rds.Instance("example",
            engine="PostgreSQL",
            engine_version="13.0",
            db_instance_storage_type="cloud_essd",
            instance_type=example_get_instance_classes.instance_classes[0].instance_class,
            instance_storage=example_get_instance_classes.instance_classes[0].storage_range.min,
            instance_charge_type="Postpaid",
            instance_name="terraform-example",
            vswitch_id=example_switch.id,
            monitoring_period=60)
        example_rds_upgrade_db_instance = alicloud.rds.RdsUpgradeDbInstance("example",
            source_db_instance_id=example_instance.id,
            target_major_version="14.0",
            db_instance_class=example_instance.instance_type,
            db_instance_storage=example_instance.instance_storage,
            db_instance_storage_type=example_instance.db_instance_storage_type,
            instance_network_type="VPC",
            collect_stat_mode="After",
            switch_over="false",
            payment_type="PayAsYouGo",
            db_instance_description="terraform-example",
            vswitch_id=example_switch.id)
        ```

        ## Import

        RDS Upgrade DB Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rds/rdsUpgradeDbInstance:RdsUpgradeDbInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param RdsUpgradeDbInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RdsUpgradeDbInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_type: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_ca_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 client_cert_revocation_list: Optional[pulumi.Input[_builtins.str]] = None,
                 client_crl_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 collect_stat_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 db_instance_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 force_restart: Optional[pulumi.Input[_builtins.bool]] = None,
                 ha_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_time: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RdsUpgradeDbInstanceParameterArgs', 'RdsUpgradeDbInstanceParameterArgsDict']]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pg_hba_confs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RdsUpgradeDbInstancePgHbaConfArgs', 'RdsUpgradeDbInstancePgHbaConfArgsDict']]]]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 released_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_acl: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 server_key: Optional[pulumi.Input[_builtins.str]] = None,
                 source_biz: Optional[pulumi.Input[_builtins.str]] = None,
                 source_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[_builtins.int]] = None,
                 switch_over: Optional[pulumi.Input[_builtins.str]] = None,
                 switch_time: Optional[pulumi.Input[_builtins.str]] = None,
                 switch_time_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 target_major_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tcp_connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tde_status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id_slave1: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RdsUpgradeDbInstanceArgs.__new__(RdsUpgradeDbInstanceArgs)

            __props__.__dict__["acl"] = acl
            __props__.__dict__["auto_upgrade_minor_version"] = auto_upgrade_minor_version
            __props__.__dict__["ca_type"] = ca_type
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["client_ca_cert"] = client_ca_cert
            __props__.__dict__["client_ca_enabled"] = client_ca_enabled
            __props__.__dict__["client_cert_revocation_list"] = client_cert_revocation_list
            __props__.__dict__["client_crl_enabled"] = client_crl_enabled
            if collect_stat_mode is None and not opts.urn:
                raise TypeError("Missing required property 'collect_stat_mode'")
            __props__.__dict__["collect_stat_mode"] = collect_stat_mode
            __props__.__dict__["connection_string_prefix"] = connection_string_prefix
            if db_instance_class is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_class'")
            __props__.__dict__["db_instance_class"] = db_instance_class
            __props__.__dict__["db_instance_description"] = db_instance_description
            if db_instance_storage is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_storage'")
            __props__.__dict__["db_instance_storage"] = db_instance_storage
            if db_instance_storage_type is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_storage_type'")
            __props__.__dict__["db_instance_storage_type"] = db_instance_storage_type
            __props__.__dict__["db_name"] = db_name
            __props__.__dict__["dedicated_host_group_id"] = dedicated_host_group_id
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["direction"] = direction
            __props__.__dict__["effective_time"] = effective_time
            __props__.__dict__["encryption_key"] = encryption_key
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["force_restart"] = force_restart
            __props__.__dict__["ha_mode"] = ha_mode
            if instance_network_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_network_type'")
            __props__.__dict__["instance_network_type"] = instance_network_type
            __props__.__dict__["maintain_time"] = maintain_time
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["password"] = password
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["pg_hba_confs"] = pg_hba_confs
            __props__.__dict__["port"] = port
            __props__.__dict__["private_ip_address"] = private_ip_address
            __props__.__dict__["private_key"] = private_key
            __props__.__dict__["released_keep_policy"] = released_keep_policy
            __props__.__dict__["replication_acl"] = replication_acl
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["security_ips"] = security_ips
            __props__.__dict__["server_cert"] = server_cert
            __props__.__dict__["server_key"] = server_key
            __props__.__dict__["source_biz"] = source_biz
            if source_db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_db_instance_id'")
            __props__.__dict__["source_db_instance_id"] = source_db_instance_id
            __props__.__dict__["ssl_enabled"] = ssl_enabled
            if switch_over is None and not opts.urn:
                raise TypeError("Missing required property 'switch_over'")
            __props__.__dict__["switch_over"] = switch_over
            __props__.__dict__["switch_time"] = switch_time
            __props__.__dict__["switch_time_mode"] = switch_time_mode
            __props__.__dict__["sync_mode"] = sync_mode
            if target_major_version is None and not opts.urn:
                raise TypeError("Missing required property 'target_major_version'")
            __props__.__dict__["target_major_version"] = target_major_version
            __props__.__dict__["tcp_connection_type"] = tcp_connection_type
            __props__.__dict__["tde_status"] = tde_status
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["zone_id_slave1"] = zone_id_slave1
            __props__.__dict__["connection_string"] = None
        super(RdsUpgradeDbInstance, __self__).__init__(
            'alicloud:rds/rdsUpgradeDbInstance:RdsUpgradeDbInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[_builtins.str]] = None,
            auto_upgrade_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
            ca_type: Optional[pulumi.Input[_builtins.str]] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            client_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
            client_ca_enabled: Optional[pulumi.Input[_builtins.int]] = None,
            client_cert_revocation_list: Optional[pulumi.Input[_builtins.str]] = None,
            client_crl_enabled: Optional[pulumi.Input[_builtins.int]] = None,
            collect_stat_mode: Optional[pulumi.Input[_builtins.str]] = None,
            connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_class: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_storage: Optional[pulumi.Input[_builtins.int]] = None,
            db_instance_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_name: Optional[pulumi.Input[_builtins.str]] = None,
            dedicated_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            direction: Optional[pulumi.Input[_builtins.str]] = None,
            effective_time: Optional[pulumi.Input[_builtins.str]] = None,
            encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            force_restart: Optional[pulumi.Input[_builtins.bool]] = None,
            ha_mode: Optional[pulumi.Input[_builtins.str]] = None,
            instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_time: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RdsUpgradeDbInstanceParameterArgs', 'RdsUpgradeDbInstanceParameterArgsDict']]]]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            pg_hba_confs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RdsUpgradeDbInstancePgHbaConfArgs', 'RdsUpgradeDbInstancePgHbaConfArgsDict']]]]] = None,
            port: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            released_keep_policy: Optional[pulumi.Input[_builtins.str]] = None,
            replication_acl: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            security_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            server_cert: Optional[pulumi.Input[_builtins.str]] = None,
            server_key: Optional[pulumi.Input[_builtins.str]] = None,
            source_biz: Optional[pulumi.Input[_builtins.str]] = None,
            source_db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_enabled: Optional[pulumi.Input[_builtins.int]] = None,
            switch_over: Optional[pulumi.Input[_builtins.str]] = None,
            switch_time: Optional[pulumi.Input[_builtins.str]] = None,
            switch_time_mode: Optional[pulumi.Input[_builtins.str]] = None,
            sync_mode: Optional[pulumi.Input[_builtins.str]] = None,
            target_major_version: Optional[pulumi.Input[_builtins.str]] = None,
            tcp_connection_type: Optional[pulumi.Input[_builtins.str]] = None,
            tde_status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id_slave1: Optional[pulumi.Input[_builtins.str]] = None) -> 'RdsUpgradeDbInstance':
        """
        Get an existing RdsUpgradeDbInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl: This parameter is only supported by the RDS PostgreSQL cloud disk version. This parameter indicates the authentication method. It is allowed only when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
        :param pulumi.Input[_builtins.str] auto_upgrade_minor_version: How to upgrade the minor version of the instance. Valid values:
               * **Auto**: automatically upgrade the minor version.
               * **Manual**: It is not automatically upgraded. It is only mandatory when the current version is offline.
        :param pulumi.Input[_builtins.str] ca_type: This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the certificate type. When the value of ssl_action is Open, the default value of this parameter is aliyun. Value range:
               * **aliyun**: using cloud certificates.
               * **custom**: use a custom certificate. Valid values: `aliyun`, `custom`.
        :param pulumi.Input[_builtins.str] certificate: The file that contains the certificate used for TDE.
        :param pulumi.Input[_builtins.str] client_ca_cert: This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the public key of the client certification authority. If the value of client_ca_enabled is 1, this parameter must be configured.
        :param pulumi.Input[_builtins.int] client_ca_enabled: The client ca enabled.
        :param pulumi.Input[_builtins.str] client_cert_revocation_list: This parameter is only supported by the RDS PostgreSQL cloud disk version, which indicates that the client revokes the certificate file. If the value of client_crl_enabled is 1, this parameter must be configured.
        :param pulumi.Input[_builtins.int] client_crl_enabled: The client crl enabled.
        :param pulumi.Input[_builtins.str] collect_stat_mode: The time at which ApsaraDB RDS collects the statistics of the new instance.
               * **Before**: ApsaraDB RDS collects the statistics of the new instance before the switchover to ensure service stability. If the original instance contains a large amount of data, the upgrade may require a long period of time.
               * **After**: ApsaraDB RDS collects the statistics of the new instance after the switchover to accelerate the upgrade. If you access tables for which no statistics are generated, the query plans that you specify may be inaccurately executed. In addition, your database service may be unavailable during peak hours.
               
               > **NOTE** If you set the SwitchOver parameter to false, the value Before specifies that ApsaraDB RDS collects the statistics of the new instance before the new instance starts to process read and write requests, and the value After specifies that ApsaraDB RDS collects the statistics of the new instance after the new instance starts to process read and write requests.
        :param pulumi.Input[_builtins.str] connection_string: The database connection address.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The connection string prefix.
        :param pulumi.Input[_builtins.str] db_instance_class: The instance type of the new instance. For information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
        :param pulumi.Input[_builtins.str] db_instance_description: The db instance description.
        :param pulumi.Input[_builtins.int] db_instance_storage: The storage capacity of the new instance. Unit: GB. The storage capacity increases in increments of 5 GB. For more information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
               
               > **NOTE:** The default value of this parameter is the storage capacity of the original instance.
        :param pulumi.Input[_builtins.str] db_instance_storage_type: The type of storage media that is used for the new instance. Valid values:
               * **local_ssd**: local SSDs.
               * **cloud_ssd**: standard SSDs.
               * **cloud_essd**: enhanced SSDs (ESSDs) of performance level 1 (PL1).
               * **cloud_essd2**: ESSDs of PL2.
               * **cloud_essd3**: ESSDs of PL3.
        :param pulumi.Input[_builtins.str] db_name: The name of the database for which you want to enable TDE. Up to 50 names can be entered in a single request. If you specify multiple names, separate these names with commas (,).
               
               > **NOTE:** This parameter is available and must be specified only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
        :param pulumi.Input[_builtins.str] dedicated_host_group_id: The ID of the dedicated cluster to which the new instance belongs. This parameter takes effect only when you create the new instance in a dedicated cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The switch of delete protection. Valid values:
               - true: delete protect.
               - false: no delete protect.
               
               > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
        :param pulumi.Input[_builtins.str] direction: The direction. Valid values: `Auto`, `Down`, `TempUpgrade`, `Up`.
        :param pulumi.Input[_builtins.str] effective_time: The effective time.
        :param pulumi.Input[_builtins.str] encryption_key: The ID of the private key.
               
               > **NOTE:** This parameter is available only when the instance runs MySQL.
        :param pulumi.Input[_builtins.str] engine: Database type. Value options: MySQL, SQLServer, PostgreSQL.
        :param pulumi.Input[_builtins.str] engine_version: Database version. Value:
               * MySQL: **5.5/5.6/5.7/8.0**.
               * SQL Server: **2008r2/08r2_ent_ha/2012/2012_ent_ha/2012_std_ha/2012_web/2014_std_ha/2016_ent_ha/2016_std_ha/2016_web/2017_std_ha/2017_ent/2019_std_ha/2019_ent**.
               * PostgreSQL: **9.4/10.0/11.0/12.0/13.0**.
               * MariaDB: **10.3**.
        :param pulumi.Input[_builtins.bool] force_restart: Set it to true to make some parameter efficient when modifying them. Default to false.
        :param pulumi.Input[_builtins.str] ha_mode: The high availability mode. Valid values:
               * **RPO**: Data persistence is preferred. The instance preferentially ensures data reliability to minimize data loss. Use this mode if you have higher requirements on data consistency.
               * **RTO**: Instance availability is preferred. The instance restores services as soon as possible to ensure availability. Use this mode if you have higher requirements on service availability.
        :param pulumi.Input[_builtins.str] instance_network_type: The network type of the instance. Valid values:
               * **Classic**: Classic Network.
               * **VPC**: VPC.
        :param pulumi.Input[_builtins.str] maintain_time: The maintainable time period of the instance. Format: <I> HH:mm</I> Z-<I> HH:mm</I> Z(UTC time).
        :param pulumi.Input[Sequence[pulumi.Input[Union['RdsUpgradeDbInstanceParameterArgs', 'RdsUpgradeDbInstanceParameterArgsDict']]]] parameters: Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm). See `parameters` below.
        :param pulumi.Input[_builtins.str] password: The password of the certificate. 
               
               > **NOTE:** This parameter is available only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the new instance. Valid values: `PayAsYouGo` and `Subscription`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RdsUpgradeDbInstancePgHbaConfArgs', 'RdsUpgradeDbInstancePgHbaConfArgsDict']]]] pg_hba_confs: The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        :param pulumi.Input[_builtins.str] port: The port.
        :param pulumi.Input[_builtins.str] private_ip_address: The intranet IP address of the new instance must be within the specified vSwitch IP address range. By default, the system automatically allocates by using **VPCId** and **VSwitchId**.
        :param pulumi.Input[_builtins.str] private_key: The file that contains the private key used for TDE.
        :param pulumi.Input[_builtins.str] released_keep_policy: The released keep policy.
        :param pulumi.Input[_builtins.str] replication_acl: This parameter is only supported by the RDS PostgreSQL cloud disk version, indicating the authentication method of the replication permission. It is only allowed when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group id.
        :param pulumi.Input[_builtins.str] role_arn: The Alibaba Cloud Resource Name (ARN) of a RAM role. A RAM role is a virtual RAM identity that you can create within your Alibaba Cloud account. For more information, see [RAM role overview](https://www.alibabacloud.com/help/en/ram/user-guide/ram-role-overview).
               
               > **NOTE:** This parameter is available only when the instance runs MySQL.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ips: The IP address whitelist of the instance. Separate multiple IP addresses with commas (,) and cannot be repeated. The following two formats are supported:
               * IP address form, for example: 10.23.12.24.
               * CIDR format, for example, 10.23.12.0/24 (no Inter-Domain Routing, 24 indicates the length of the prefix in the address, ranging from 1 to 32).
               
               > **NOTE:** each instance can add up to 1000 IP addresses or IP segments, that is, the total number of IP addresses or IP segments in all IP whitelist groups cannot exceed 1000. When there are more IP addresses, it is recommended to merge them into IP segments, for example, 10.23.12.0/24.
        :param pulumi.Input[_builtins.str] server_cert: This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the content of the server certificate. If the CAType value is custom, this parameter must be configured.
        :param pulumi.Input[_builtins.str] server_key: This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the private key of the server certificate. If the value of CAType is custom, this parameter must be configured.
        :param pulumi.Input[_builtins.str] source_biz: The source biz.
        :param pulumi.Input[_builtins.str] source_db_instance_id: The source db instance id.
        :param pulumi.Input[_builtins.int] ssl_enabled: Enable or disable SSL. Valid values: `0` and `1`.
        :param pulumi.Input[_builtins.str] switch_over: Specifies whether ApsaraDB RDS automatically switches your workloads over to the new instance after data is migrated to the new instance. Valid values:
               * **true**: ApsaraDB RDS automatically switches workloads over to the new instance. If you set this parameter to true, you must take note of the following information:
               * After the switchover is complete, you cannot roll your workloads back to the original instance. Proceed with caution.
               * During the switchover, the original instance processes only read requests. You must perform the switchover during off-peak hours.
               * If read-only instances are attached to the original instance, you can set this parameter only to false. In this case, the read-only instances that are attached to the original instance cannot be cloned. After the upgrade is complete, you must create read-only instances for the new instance.
               * **false**: ApsaraDB RDS does not automatically switch your workloads over to the new instance. Before you perform an upgrade, we recommend that you set this parameter to false to test whether the new major engine version is compatible with your workloads. If you set this parameter to false, you must take note of the following information:
               * The data migration does not interrupt your workloads on the original instance.
               * After data is migrated to the new instance, you must update the endpoint configuration on your application. This update requires you to replace the endpoint of the original instance with the endpoint of the new instance. For more information about how to view the endpoint of an instance, see [View and change the internal and public endpoints and port numbers of an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/doc-detail/96788.htm).
        :param pulumi.Input[_builtins.str] switch_time: The time at which you want to apply the specification changes. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        :param pulumi.Input[_builtins.str] switch_time_mode: The time at which ApsaraDB RDS switches your workloads over to the new instance. This parameter is used together with the SwitchOver parameter and takes effect only when you set the SwitchOver parameter to true. Valid values:
               * **Immediate**: After data is migrated to the new instance, ApsaraDB RDS immediately switches your workloads over to the new instance.
               * **MaintainTime**: After data is migrated to the new instance, ApsaraDB RDS switches your workloads over to the new instance during the maintenance window that you specify. You can call the [ModifyDBInstanceMaintainTime](https://www.alibabacloud.com/help/doc-detail/26249.htm) operation to change the maintenance window of an instance.
        :param pulumi.Input[_builtins.str] sync_mode: [The data replication mode](https://www.alibabacloud.com/help/doc-detail/96055.htm). Valid values:
               * **Sync**: strong synchronization.
               * **Semi-sync**: Semi-synchronous.
               * **Async**: asynchronous.
               
               > **NOTE:** SQL Server 2017 cluster version is currently not supported.
        :param pulumi.Input[_builtins.str] target_major_version: The major engine version of the new instance. The value of this parameter must be the major engine version on which an upgrade check is performed.
               
               > **NOTE** You can call the [UpgradeDBInstanceMajorVersionPrecheck](https://www.alibabacloud.com/help/doc-detail/330050.htm) operation to perform an upgrade check on a major engine version.
        :param pulumi.Input[_builtins.str] tcp_connection_type: The availability check method of the instance. Valid values:
               - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
               - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        :param pulumi.Input[_builtins.str] tde_status: Specifies whether to enable TDE. Valid values: `Enabled` and `Disabled`.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC to which the new instance belongs.
               
               > **NOTE:** Make sure that the VPC resides in the specified region.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch associated with the specified VPC.
               
               > **NOTE:** Make sure that the vSwitch belongs to the specified VPC and region.
        :param pulumi.Input[_builtins.str] zone_id: The ID of the zone to which the new instance belongs. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query the most recent region list.
               
               > **NOTE:** The default value of this parameter is the ID of the zone to which the original instance belongs.
        :param pulumi.Input[_builtins.str] zone_id_slave1: The ID of the zone to which the secondary instance of the new instance belongs. You can specify this parameter only when the original instance runs RDS High-availability Edition. You can select a zone that belongs to the region where the original instance resides. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query zone IDs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RdsUpgradeDbInstanceState.__new__(_RdsUpgradeDbInstanceState)

        __props__.__dict__["acl"] = acl
        __props__.__dict__["auto_upgrade_minor_version"] = auto_upgrade_minor_version
        __props__.__dict__["ca_type"] = ca_type
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["client_ca_cert"] = client_ca_cert
        __props__.__dict__["client_ca_enabled"] = client_ca_enabled
        __props__.__dict__["client_cert_revocation_list"] = client_cert_revocation_list
        __props__.__dict__["client_crl_enabled"] = client_crl_enabled
        __props__.__dict__["collect_stat_mode"] = collect_stat_mode
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["connection_string_prefix"] = connection_string_prefix
        __props__.__dict__["db_instance_class"] = db_instance_class
        __props__.__dict__["db_instance_description"] = db_instance_description
        __props__.__dict__["db_instance_storage"] = db_instance_storage
        __props__.__dict__["db_instance_storage_type"] = db_instance_storage_type
        __props__.__dict__["db_name"] = db_name
        __props__.__dict__["dedicated_host_group_id"] = dedicated_host_group_id
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["direction"] = direction
        __props__.__dict__["effective_time"] = effective_time
        __props__.__dict__["encryption_key"] = encryption_key
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["force_restart"] = force_restart
        __props__.__dict__["ha_mode"] = ha_mode
        __props__.__dict__["instance_network_type"] = instance_network_type
        __props__.__dict__["maintain_time"] = maintain_time
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["password"] = password
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["pg_hba_confs"] = pg_hba_confs
        __props__.__dict__["port"] = port
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["released_keep_policy"] = released_keep_policy
        __props__.__dict__["replication_acl"] = replication_acl
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["security_ips"] = security_ips
        __props__.__dict__["server_cert"] = server_cert
        __props__.__dict__["server_key"] = server_key
        __props__.__dict__["source_biz"] = source_biz
        __props__.__dict__["source_db_instance_id"] = source_db_instance_id
        __props__.__dict__["ssl_enabled"] = ssl_enabled
        __props__.__dict__["switch_over"] = switch_over
        __props__.__dict__["switch_time"] = switch_time
        __props__.__dict__["switch_time_mode"] = switch_time_mode
        __props__.__dict__["sync_mode"] = sync_mode
        __props__.__dict__["target_major_version"] = target_major_version
        __props__.__dict__["tcp_connection_type"] = tcp_connection_type
        __props__.__dict__["tde_status"] = tde_status
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        __props__.__dict__["zone_id_slave1"] = zone_id_slave1
        return RdsUpgradeDbInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> pulumi.Output[_builtins.str]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version. This parameter indicates the authentication method. It is allowed only when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> pulumi.Output[_builtins.str]:
        """
        How to upgrade the minor version of the instance. Valid values:
        * **Auto**: automatically upgrade the minor version.
        * **Manual**: It is not automatically upgraded. It is only mandatory when the current version is offline.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @_builtins.property
    @pulumi.getter(name="caType")
    def ca_type(self) -> pulumi.Output[_builtins.str]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the certificate type. When the value of ssl_action is Open, the default value of this parameter is aliyun. Value range:
        * **aliyun**: using cloud certificates.
        * **custom**: use a custom certificate. Valid values: `aliyun`, `custom`.
        """
        return pulumi.get(self, "ca_type")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The file that contains the certificate used for TDE.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="clientCaCert")
    def client_ca_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the public key of the client certification authority. If the value of client_ca_enabled is 1, this parameter must be configured.
        """
        return pulumi.get(self, "client_ca_cert")

    @_builtins.property
    @pulumi.getter(name="clientCaEnabled")
    def client_ca_enabled(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The client ca enabled.
        """
        return pulumi.get(self, "client_ca_enabled")

    @_builtins.property
    @pulumi.getter(name="clientCertRevocationList")
    def client_cert_revocation_list(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version, which indicates that the client revokes the certificate file. If the value of client_crl_enabled is 1, this parameter must be configured.
        """
        return pulumi.get(self, "client_cert_revocation_list")

    @_builtins.property
    @pulumi.getter(name="clientCrlEnabled")
    def client_crl_enabled(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The client crl enabled.
        """
        return pulumi.get(self, "client_crl_enabled")

    @_builtins.property
    @pulumi.getter(name="collectStatMode")
    def collect_stat_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which ApsaraDB RDS collects the statistics of the new instance.
        * **Before**: ApsaraDB RDS collects the statistics of the new instance before the switchover to ensure service stability. If the original instance contains a large amount of data, the upgrade may require a long period of time.
        * **After**: ApsaraDB RDS collects the statistics of the new instance after the switchover to accelerate the upgrade. If you access tables for which no statistics are generated, the query plans that you specify may be inaccurately executed. In addition, your database service may be unavailable during peak hours.

        > **NOTE** If you set the SwitchOver parameter to false, the value Before specifies that ApsaraDB RDS collects the statistics of the new instance before the new instance starts to process read and write requests, and the value After specifies that ApsaraDB RDS collects the statistics of the new instance after the new instance starts to process read and write requests.
        """
        return pulumi.get(self, "collect_stat_mode")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        The database connection address.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The connection string prefix.
        """
        return pulumi.get(self, "connection_string_prefix")

    @_builtins.property
    @pulumi.getter(name="dbInstanceClass")
    def db_instance_class(self) -> pulumi.Output[_builtins.str]:
        """
        The instance type of the new instance. For information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).
        """
        return pulumi.get(self, "db_instance_class")

    @_builtins.property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> pulumi.Output[_builtins.str]:
        """
        The db instance description.
        """
        return pulumi.get(self, "db_instance_description")

    @_builtins.property
    @pulumi.getter(name="dbInstanceStorage")
    def db_instance_storage(self) -> pulumi.Output[_builtins.int]:
        """
        The storage capacity of the new instance. Unit: GB. The storage capacity increases in increments of 5 GB. For more information, see [Primary ApsaraDB RDS instance types](https://www.alibabacloud.com/help/en/rds/product-overview/primary-apsaradb-rds-instance-types).

        > **NOTE:** The default value of this parameter is the storage capacity of the original instance.
        """
        return pulumi.get(self, "db_instance_storage")

    @_builtins.property
    @pulumi.getter(name="dbInstanceStorageType")
    def db_instance_storage_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of storage media that is used for the new instance. Valid values:
        * **local_ssd**: local SSDs.
        * **cloud_ssd**: standard SSDs.
        * **cloud_essd**: enhanced SSDs (ESSDs) of performance level 1 (PL1).
        * **cloud_essd2**: ESSDs of PL2.
        * **cloud_essd3**: ESSDs of PL3.
        """
        return pulumi.get(self, "db_instance_storage_type")

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the database for which you want to enable TDE. Up to 50 names can be entered in a single request. If you specify multiple names, separate these names with commas (,).

        > **NOTE:** This parameter is available and must be specified only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
        """
        return pulumi.get(self, "db_name")

    @_builtins.property
    @pulumi.getter(name="dedicatedHostGroupId")
    def dedicated_host_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the dedicated cluster to which the new instance belongs. This parameter takes effect only when you create the new instance in a dedicated cluster.
        """
        return pulumi.get(self, "dedicated_host_group_id")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The switch of delete protection. Valid values:
        - true: delete protect.
        - false: no delete protect.

        > **NOTE:** `deletion_protection` is valid only when attribute `payment_type` is set to `PayAsYouGo`, supported engine type: **MySQL**, **PostgreSQL**, **MariaDB**, **MSSQL**.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The direction. Valid values: `Auto`, `Down`, `TempUpgrade`, `Up`.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The effective time.
        """
        return pulumi.get(self, "effective_time")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the private key.

        > **NOTE:** This parameter is available only when the instance runs MySQL.
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[_builtins.str]:
        """
        Database type. Value options: MySQL, SQLServer, PostgreSQL.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        Database version. Value:
        * MySQL: **5.5/5.6/5.7/8.0**.
        * SQL Server: **2008r2/08r2_ent_ha/2012/2012_ent_ha/2012_std_ha/2012_web/2014_std_ha/2016_ent_ha/2016_std_ha/2016_web/2017_std_ha/2017_ent/2019_std_ha/2019_ent**.
        * PostgreSQL: **9.4/10.0/11.0/12.0/13.0**.
        * MariaDB: **10.3**.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set it to true to make some parameter efficient when modifying them. Default to false.
        """
        return pulumi.get(self, "force_restart")

    @_builtins.property
    @pulumi.getter(name="haMode")
    def ha_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The high availability mode. Valid values:
        * **RPO**: Data persistence is preferred. The instance preferentially ensures data reliability to minimize data loss. Use this mode if you have higher requirements on data consistency.
        * **RTO**: Instance availability is preferred. The instance restores services as soon as possible to ensure availability. Use this mode if you have higher requirements on service availability.
        """
        return pulumi.get(self, "ha_mode")

    @_builtins.property
    @pulumi.getter(name="instanceNetworkType")
    def instance_network_type(self) -> pulumi.Output[_builtins.str]:
        """
        The network type of the instance. Valid values:
        * **Classic**: Classic Network.
        * **VPC**: VPC.
        """
        return pulumi.get(self, "instance_network_type")

    @_builtins.property
    @pulumi.getter(name="maintainTime")
    def maintain_time(self) -> pulumi.Output[_builtins.str]:
        """
        The maintainable time period of the instance. Format: <I> HH:mm</I> Z-<I> HH:mm</I> Z(UTC time).
        """
        return pulumi.get(self, "maintain_time")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.RdsUpgradeDbInstanceParameter']]:
        """
        Set of parameters needs to be set after DB instance was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/doc-detail/26284.htm). See `parameters` below.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of the certificate. 

        > **NOTE:** This parameter is available only when the instance runs SQL Server 2019 SE or an Enterprise Edition of SQL Server.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The billing method of the new instance. Valid values: `PayAsYouGo` and `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="pgHbaConfs")
    def pg_hba_confs(self) -> pulumi.Output[Sequence['outputs.RdsUpgradeDbInstancePgHbaConf']]:
        """
        The configuration of [AD domain](https://www.alibabacloud.com/help/en/doc-detail/349288.htm) . See `pg_hba_conf` below.
        """
        return pulumi.get(self, "pg_hba_confs")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.str]:
        """
        The port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The intranet IP address of the new instance must be within the specified vSwitch IP address range. By default, the system automatically allocates by using **VPCId** and **VSwitchId**.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The file that contains the private key used for TDE.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="releasedKeepPolicy")
    def released_keep_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The released keep policy.
        """
        return pulumi.get(self, "released_keep_policy")

    @_builtins.property
    @pulumi.getter(name="replicationAcl")
    def replication_acl(self) -> pulumi.Output[_builtins.str]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version, indicating the authentication method of the replication permission. It is only allowed when the public key of the client certificate authority is enabled. Valid values: `cert` and `perfer` and `verify-ca` and `verify-full (supported by RDS PostgreSQL above 12)`.
        """
        return pulumi.get(self, "replication_acl")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Alibaba Cloud Resource Name (ARN) of a RAM role. A RAM role is a virtual RAM identity that you can create within your Alibaba Cloud account. For more information, see [RAM role overview](https://www.alibabacloud.com/help/en/ram/user-guide/ram-role-overview).

        > **NOTE:** This parameter is available only when the instance runs MySQL.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="securityIps")
    def security_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The IP address whitelist of the instance. Separate multiple IP addresses with commas (,) and cannot be repeated. The following two formats are supported:
        * IP address form, for example: 10.23.12.24.
        * CIDR format, for example, 10.23.12.0/24 (no Inter-Domain Routing, 24 indicates the length of the prefix in the address, ranging from 1 to 32).

        > **NOTE:** each instance can add up to 1000 IP addresses or IP segments, that is, the total number of IP addresses or IP segments in all IP whitelist groups cannot exceed 1000. When there are more IP addresses, it is recommended to merge them into IP segments, for example, 10.23.12.0/24.
        """
        return pulumi.get(self, "security_ips")

    @_builtins.property
    @pulumi.getter(name="serverCert")
    def server_cert(self) -> pulumi.Output[_builtins.str]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the content of the server certificate. If the CAType value is custom, this parameter must be configured.
        """
        return pulumi.get(self, "server_cert")

    @_builtins.property
    @pulumi.getter(name="serverKey")
    def server_key(self) -> pulumi.Output[_builtins.str]:
        """
        This parameter is only supported by the RDS PostgreSQL cloud disk version. It indicates the private key of the server certificate. If the value of CAType is custom, this parameter must be configured.
        """
        return pulumi.get(self, "server_key")

    @_builtins.property
    @pulumi.getter(name="sourceBiz")
    def source_biz(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The source biz.
        """
        return pulumi.get(self, "source_biz")

    @_builtins.property
    @pulumi.getter(name="sourceDbInstanceId")
    def source_db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The source db instance id.
        """
        return pulumi.get(self, "source_db_instance_id")

    @_builtins.property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> pulumi.Output[_builtins.int]:
        """
        Enable or disable SSL. Valid values: `0` and `1`.
        """
        return pulumi.get(self, "ssl_enabled")

    @_builtins.property
    @pulumi.getter(name="switchOver")
    def switch_over(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether ApsaraDB RDS automatically switches your workloads over to the new instance after data is migrated to the new instance. Valid values:
        * **true**: ApsaraDB RDS automatically switches workloads over to the new instance. If you set this parameter to true, you must take note of the following information:
        * After the switchover is complete, you cannot roll your workloads back to the original instance. Proceed with caution.
        * During the switchover, the original instance processes only read requests. You must perform the switchover during off-peak hours.
        * If read-only instances are attached to the original instance, you can set this parameter only to false. In this case, the read-only instances that are attached to the original instance cannot be cloned. After the upgrade is complete, you must create read-only instances for the new instance.
        * **false**: ApsaraDB RDS does not automatically switch your workloads over to the new instance. Before you perform an upgrade, we recommend that you set this parameter to false to test whether the new major engine version is compatible with your workloads. If you set this parameter to false, you must take note of the following information:
        * The data migration does not interrupt your workloads on the original instance.
        * After data is migrated to the new instance, you must update the endpoint configuration on your application. This update requires you to replace the endpoint of the original instance with the endpoint of the new instance. For more information about how to view the endpoint of an instance, see [View and change the internal and public endpoints and port numbers of an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/doc-detail/96788.htm).
        """
        return pulumi.get(self, "switch_over")

    @_builtins.property
    @pulumi.getter(name="switchTime")
    def switch_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time at which you want to apply the specification changes. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        """
        return pulumi.get(self, "switch_time")

    @_builtins.property
    @pulumi.getter(name="switchTimeMode")
    def switch_time_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time at which ApsaraDB RDS switches your workloads over to the new instance. This parameter is used together with the SwitchOver parameter and takes effect only when you set the SwitchOver parameter to true. Valid values:
        * **Immediate**: After data is migrated to the new instance, ApsaraDB RDS immediately switches your workloads over to the new instance.
        * **MaintainTime**: After data is migrated to the new instance, ApsaraDB RDS switches your workloads over to the new instance during the maintenance window that you specify. You can call the [ModifyDBInstanceMaintainTime](https://www.alibabacloud.com/help/doc-detail/26249.htm) operation to change the maintenance window of an instance.
        """
        return pulumi.get(self, "switch_time_mode")

    @_builtins.property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> pulumi.Output[_builtins.str]:
        """
        [The data replication mode](https://www.alibabacloud.com/help/doc-detail/96055.htm). Valid values:
        * **Sync**: strong synchronization.
        * **Semi-sync**: Semi-synchronous.
        * **Async**: asynchronous.

        > **NOTE:** SQL Server 2017 cluster version is currently not supported.
        """
        return pulumi.get(self, "sync_mode")

    @_builtins.property
    @pulumi.getter(name="targetMajorVersion")
    def target_major_version(self) -> pulumi.Output[_builtins.str]:
        """
        The major engine version of the new instance. The value of this parameter must be the major engine version on which an upgrade check is performed.

        > **NOTE** You can call the [UpgradeDBInstanceMajorVersionPrecheck](https://www.alibabacloud.com/help/doc-detail/330050.htm) operation to perform an upgrade check on a major engine version.
        """
        return pulumi.get(self, "target_major_version")

    @_builtins.property
    @pulumi.getter(name="tcpConnectionType")
    def tcp_connection_type(self) -> pulumi.Output[_builtins.str]:
        """
        The availability check method of the instance. Valid values:
        - **SHORT**: Alibaba Cloud uses short-lived connections to check the availability of the instance.
        - **LONG**: Alibaba Cloud uses persistent connections to check the availability of the instance.
        """
        return pulumi.get(self, "tcp_connection_type")

    @_builtins.property
    @pulumi.getter(name="tdeStatus")
    def tde_status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to enable TDE. Valid values: `Enabled` and `Disabled`.
        """
        return pulumi.get(self, "tde_status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC to which the new instance belongs.

        > **NOTE:** Make sure that the VPC resides in the specified region.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the vSwitch associated with the specified VPC.

        > **NOTE:** Make sure that the vSwitch belongs to the specified VPC and region.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the zone to which the new instance belongs. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query the most recent region list.

        > **NOTE:** The default value of this parameter is the ID of the zone to which the original instance belongs.
        """
        return pulumi.get(self, "zone_id")

    @_builtins.property
    @pulumi.getter(name="zoneIdSlave1")
    def zone_id_slave1(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the zone to which the secondary instance of the new instance belongs. You can specify this parameter only when the original instance runs RDS High-availability Edition. You can select a zone that belongs to the region where the original instance resides. You can call the [DescribeRegions](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-describeregions) operation to query zone IDs.
        """
        return pulumi.get(self, "zone_id_slave1")

