# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutoGroupingRuleArgs', 'AutoGroupingRule']

@pulumi.input_type
class AutoGroupingRuleArgs:
    def __init__(__self__, *,
                 rule_contents: pulumi.Input[Sequence[pulumi.Input['AutoGroupingRuleRuleContentArgs']]],
                 rule_name: pulumi.Input[_builtins.str],
                 rule_type: pulumi.Input[_builtins.str],
                 exclude_region_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_resource_group_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_resource_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_resource_types_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 region_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_desc: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AutoGroupingRule resource.
        :param pulumi.Input[Sequence[pulumi.Input['AutoGroupingRuleRuleContentArgs']]] rule_contents: The content records of the rule. See `rule_contents` below.
        :param pulumi.Input[_builtins.str] rule_name: The name of the rule.
        :param pulumi.Input[_builtins.str] rule_type: The type of the rule. Valid values:
        :param pulumi.Input[_builtins.str] exclude_region_ids_scope: The IDs of regions to be excluded. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] exclude_resource_group_ids_scope: The IDs of resource groups to be excluded. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] exclude_resource_ids_scope: The IDs of resources to be excluded. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] exclude_resource_types_scope: The resource types to be excluded. Separate multiple resource types with commas (,).
        :param pulumi.Input[_builtins.str] region_ids_scope: The IDs of regions. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] resource_group_ids_scope: The IDs of resource groups. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] resource_ids_scope: The IDs of resources. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] resource_types_scope: The resource types. Separate multiple resource types with commas (,).
        :param pulumi.Input[_builtins.str] rule_desc: The description of the rule.
        """
        pulumi.set(__self__, "rule_contents", rule_contents)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "rule_type", rule_type)
        if exclude_region_ids_scope is not None:
            pulumi.set(__self__, "exclude_region_ids_scope", exclude_region_ids_scope)
        if exclude_resource_group_ids_scope is not None:
            pulumi.set(__self__, "exclude_resource_group_ids_scope", exclude_resource_group_ids_scope)
        if exclude_resource_ids_scope is not None:
            pulumi.set(__self__, "exclude_resource_ids_scope", exclude_resource_ids_scope)
        if exclude_resource_types_scope is not None:
            pulumi.set(__self__, "exclude_resource_types_scope", exclude_resource_types_scope)
        if region_ids_scope is not None:
            pulumi.set(__self__, "region_ids_scope", region_ids_scope)
        if resource_group_ids_scope is not None:
            pulumi.set(__self__, "resource_group_ids_scope", resource_group_ids_scope)
        if resource_ids_scope is not None:
            pulumi.set(__self__, "resource_ids_scope", resource_ids_scope)
        if resource_types_scope is not None:
            pulumi.set(__self__, "resource_types_scope", resource_types_scope)
        if rule_desc is not None:
            pulumi.set(__self__, "rule_desc", rule_desc)

    @_builtins.property
    @pulumi.getter(name="ruleContents")
    def rule_contents(self) -> pulumi.Input[Sequence[pulumi.Input['AutoGroupingRuleRuleContentArgs']]]:
        """
        The content records of the rule. See `rule_contents` below.
        """
        return pulumi.get(self, "rule_contents")

    @rule_contents.setter
    def rule_contents(self, value: pulumi.Input[Sequence[pulumi.Input['AutoGroupingRuleRuleContentArgs']]]):
        pulumi.set(self, "rule_contents", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the rule. Valid values:
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_type", value)

    @_builtins.property
    @pulumi.getter(name="excludeRegionIdsScope")
    def exclude_region_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDs of regions to be excluded. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "exclude_region_ids_scope")

    @exclude_region_ids_scope.setter
    def exclude_region_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude_region_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="excludeResourceGroupIdsScope")
    def exclude_resource_group_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDs of resource groups to be excluded. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "exclude_resource_group_ids_scope")

    @exclude_resource_group_ids_scope.setter
    def exclude_resource_group_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude_resource_group_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="excludeResourceIdsScope")
    def exclude_resource_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDs of resources to be excluded. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "exclude_resource_ids_scope")

    @exclude_resource_ids_scope.setter
    def exclude_resource_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude_resource_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="excludeResourceTypesScope")
    def exclude_resource_types_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource types to be excluded. Separate multiple resource types with commas (,).
        """
        return pulumi.get(self, "exclude_resource_types_scope")

    @exclude_resource_types_scope.setter
    def exclude_resource_types_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude_resource_types_scope", value)

    @_builtins.property
    @pulumi.getter(name="regionIdsScope")
    def region_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDs of regions. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "region_ids_scope")

    @region_ids_scope.setter
    def region_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupIdsScope")
    def resource_group_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDs of resource groups. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "resource_group_ids_scope")

    @resource_group_ids_scope.setter
    def resource_group_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="resourceIdsScope")
    def resource_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDs of resources. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "resource_ids_scope")

    @resource_ids_scope.setter
    def resource_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypesScope")
    def resource_types_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource types. Separate multiple resource types with commas (,).
        """
        return pulumi.get(self, "resource_types_scope")

    @resource_types_scope.setter
    def resource_types_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_types_scope", value)

    @_builtins.property
    @pulumi.getter(name="ruleDesc")
    def rule_desc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "rule_desc")

    @rule_desc.setter
    def rule_desc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_desc", value)


@pulumi.input_type
class _AutoGroupingRuleState:
    def __init__(__self__, *,
                 exclude_region_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_resource_group_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_resource_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_resource_types_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 region_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_contents: Optional[pulumi.Input[Sequence[pulumi.Input['AutoGroupingRuleRuleContentArgs']]]] = None,
                 rule_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AutoGroupingRule resources.
        :param pulumi.Input[_builtins.str] exclude_region_ids_scope: The IDs of regions to be excluded. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] exclude_resource_group_ids_scope: The IDs of resource groups to be excluded. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] exclude_resource_ids_scope: The IDs of resources to be excluded. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] exclude_resource_types_scope: The resource types to be excluded. Separate multiple resource types with commas (,).
        :param pulumi.Input[_builtins.str] region_ids_scope: The IDs of regions. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] resource_group_ids_scope: The IDs of resource groups. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] resource_ids_scope: The IDs of resources. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] resource_types_scope: The resource types. Separate multiple resource types with commas (,).
        :param pulumi.Input[Sequence[pulumi.Input['AutoGroupingRuleRuleContentArgs']]] rule_contents: The content records of the rule. See `rule_contents` below.
        :param pulumi.Input[_builtins.str] rule_desc: The description of the rule.
        :param pulumi.Input[_builtins.str] rule_name: The name of the rule.
        :param pulumi.Input[_builtins.str] rule_type: The type of the rule. Valid values:
        """
        if exclude_region_ids_scope is not None:
            pulumi.set(__self__, "exclude_region_ids_scope", exclude_region_ids_scope)
        if exclude_resource_group_ids_scope is not None:
            pulumi.set(__self__, "exclude_resource_group_ids_scope", exclude_resource_group_ids_scope)
        if exclude_resource_ids_scope is not None:
            pulumi.set(__self__, "exclude_resource_ids_scope", exclude_resource_ids_scope)
        if exclude_resource_types_scope is not None:
            pulumi.set(__self__, "exclude_resource_types_scope", exclude_resource_types_scope)
        if region_ids_scope is not None:
            pulumi.set(__self__, "region_ids_scope", region_ids_scope)
        if resource_group_ids_scope is not None:
            pulumi.set(__self__, "resource_group_ids_scope", resource_group_ids_scope)
        if resource_ids_scope is not None:
            pulumi.set(__self__, "resource_ids_scope", resource_ids_scope)
        if resource_types_scope is not None:
            pulumi.set(__self__, "resource_types_scope", resource_types_scope)
        if rule_contents is not None:
            pulumi.set(__self__, "rule_contents", rule_contents)
        if rule_desc is not None:
            pulumi.set(__self__, "rule_desc", rule_desc)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if rule_type is not None:
            pulumi.set(__self__, "rule_type", rule_type)

    @_builtins.property
    @pulumi.getter(name="excludeRegionIdsScope")
    def exclude_region_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDs of regions to be excluded. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "exclude_region_ids_scope")

    @exclude_region_ids_scope.setter
    def exclude_region_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude_region_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="excludeResourceGroupIdsScope")
    def exclude_resource_group_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDs of resource groups to be excluded. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "exclude_resource_group_ids_scope")

    @exclude_resource_group_ids_scope.setter
    def exclude_resource_group_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude_resource_group_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="excludeResourceIdsScope")
    def exclude_resource_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDs of resources to be excluded. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "exclude_resource_ids_scope")

    @exclude_resource_ids_scope.setter
    def exclude_resource_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude_resource_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="excludeResourceTypesScope")
    def exclude_resource_types_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource types to be excluded. Separate multiple resource types with commas (,).
        """
        return pulumi.get(self, "exclude_resource_types_scope")

    @exclude_resource_types_scope.setter
    def exclude_resource_types_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude_resource_types_scope", value)

    @_builtins.property
    @pulumi.getter(name="regionIdsScope")
    def region_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDs of regions. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "region_ids_scope")

    @region_ids_scope.setter
    def region_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupIdsScope")
    def resource_group_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDs of resource groups. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "resource_group_ids_scope")

    @resource_group_ids_scope.setter
    def resource_group_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="resourceIdsScope")
    def resource_ids_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IDs of resources. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "resource_ids_scope")

    @resource_ids_scope.setter
    def resource_ids_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_ids_scope", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypesScope")
    def resource_types_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource types. Separate multiple resource types with commas (,).
        """
        return pulumi.get(self, "resource_types_scope")

    @resource_types_scope.setter
    def resource_types_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_types_scope", value)

    @_builtins.property
    @pulumi.getter(name="ruleContents")
    def rule_contents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutoGroupingRuleRuleContentArgs']]]]:
        """
        The content records of the rule. See `rule_contents` below.
        """
        return pulumi.get(self, "rule_contents")

    @rule_contents.setter
    def rule_contents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutoGroupingRuleRuleContentArgs']]]]):
        pulumi.set(self, "rule_contents", value)

    @_builtins.property
    @pulumi.getter(name="ruleDesc")
    def rule_desc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "rule_desc")

    @rule_desc.setter
    def rule_desc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_desc", value)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @_builtins.property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the rule. Valid values:
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_type", value)


@pulumi.type_token("alicloud:resourcemanager/autoGroupingRule:AutoGroupingRule")
class AutoGroupingRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 exclude_region_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_resource_group_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_resource_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_resource_types_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 region_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_contents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutoGroupingRuleRuleContentArgs', 'AutoGroupingRuleRuleContentArgsDict']]]]] = None,
                 rule_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Resource Manager Auto Grouping Rule resource.

        Auto grouping rules of resource group.

        For information about Resource Manager Auto Grouping Rule and how to use it, see [What is Auto Grouping Rule](https://www.alibabacloud.com/help/en/resource-management/resource-group/developer-reference/api-resourcemanager-2020-03-31-createautogroupingrule-rg).

        > **NOTE:** Available since v1.246.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.AutoGroupingRule("default",
            rule_contents=[{
                "target_resource_group_condition": \"\"\"    {
                \\"children\\": [
              {
                \\"desired\\": \\"rg-aek*****sbvy\\",
                \\"featurePath\\": \\"$.resourceGroupId\\",
                \\"featureSource\\": \\"RESOURCE\\",
                \\"operator\\": \\"StringEquals\\"
              }
                ],
                \\"operator\\": \\"and\\"
            }
        \"\"\",
                "auto_grouping_scope_condition": \"\"\"    {
                \\"children\\": [
              {
                \\"desired\\": \\"name_a\\",
                \\"featurePath\\": \\"$.resourceName\\",
                \\"featureSource\\": \\"RESOURCE\\",
                \\"operator\\": \\"StringEqualsAny\\"
              }
                ],
                \\"operator\\": \\"and\\"
            }
        \"\"\",
            }],
            rule_desc=name,
            rule_type="custom_condition",
            region_ids_scope="cn-hangzhou,cn-shanghai",
            resource_ids_scope="imock-xxxxxx",
            resource_group_ids_scope="rg-aek22*****3sbvz",
            resource_types_scope="ecs.instance,vpc.vpc",
            rule_name=name)
        ```

        ## Import

        Resource Manager Auto Grouping Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/autoGroupingRule:AutoGroupingRule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] exclude_region_ids_scope: The IDs of regions to be excluded. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] exclude_resource_group_ids_scope: The IDs of resource groups to be excluded. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] exclude_resource_ids_scope: The IDs of resources to be excluded. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] exclude_resource_types_scope: The resource types to be excluded. Separate multiple resource types with commas (,).
        :param pulumi.Input[_builtins.str] region_ids_scope: The IDs of regions. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] resource_group_ids_scope: The IDs of resource groups. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] resource_ids_scope: The IDs of resources. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] resource_types_scope: The resource types. Separate multiple resource types with commas (,).
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutoGroupingRuleRuleContentArgs', 'AutoGroupingRuleRuleContentArgsDict']]]] rule_contents: The content records of the rule. See `rule_contents` below.
        :param pulumi.Input[_builtins.str] rule_desc: The description of the rule.
        :param pulumi.Input[_builtins.str] rule_name: The name of the rule.
        :param pulumi.Input[_builtins.str] rule_type: The type of the rule. Valid values:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutoGroupingRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Resource Manager Auto Grouping Rule resource.

        Auto grouping rules of resource group.

        For information about Resource Manager Auto Grouping Rule and how to use it, see [What is Auto Grouping Rule](https://www.alibabacloud.com/help/en/resource-management/resource-group/developer-reference/api-resourcemanager-2020-03-31-createautogroupingrule-rg).

        > **NOTE:** Available since v1.246.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.AutoGroupingRule("default",
            rule_contents=[{
                "target_resource_group_condition": \"\"\"    {
                \\"children\\": [
              {
                \\"desired\\": \\"rg-aek*****sbvy\\",
                \\"featurePath\\": \\"$.resourceGroupId\\",
                \\"featureSource\\": \\"RESOURCE\\",
                \\"operator\\": \\"StringEquals\\"
              }
                ],
                \\"operator\\": \\"and\\"
            }
        \"\"\",
                "auto_grouping_scope_condition": \"\"\"    {
                \\"children\\": [
              {
                \\"desired\\": \\"name_a\\",
                \\"featurePath\\": \\"$.resourceName\\",
                \\"featureSource\\": \\"RESOURCE\\",
                \\"operator\\": \\"StringEqualsAny\\"
              }
                ],
                \\"operator\\": \\"and\\"
            }
        \"\"\",
            }],
            rule_desc=name,
            rule_type="custom_condition",
            region_ids_scope="cn-hangzhou,cn-shanghai",
            resource_ids_scope="imock-xxxxxx",
            resource_group_ids_scope="rg-aek22*****3sbvz",
            resource_types_scope="ecs.instance,vpc.vpc",
            rule_name=name)
        ```

        ## Import

        Resource Manager Auto Grouping Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/autoGroupingRule:AutoGroupingRule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param AutoGroupingRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutoGroupingRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 exclude_region_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_resource_group_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_resource_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_resource_types_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 region_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_contents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutoGroupingRuleRuleContentArgs', 'AutoGroupingRuleRuleContentArgsDict']]]]] = None,
                 rule_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutoGroupingRuleArgs.__new__(AutoGroupingRuleArgs)

            __props__.__dict__["exclude_region_ids_scope"] = exclude_region_ids_scope
            __props__.__dict__["exclude_resource_group_ids_scope"] = exclude_resource_group_ids_scope
            __props__.__dict__["exclude_resource_ids_scope"] = exclude_resource_ids_scope
            __props__.__dict__["exclude_resource_types_scope"] = exclude_resource_types_scope
            __props__.__dict__["region_ids_scope"] = region_ids_scope
            __props__.__dict__["resource_group_ids_scope"] = resource_group_ids_scope
            __props__.__dict__["resource_ids_scope"] = resource_ids_scope
            __props__.__dict__["resource_types_scope"] = resource_types_scope
            if rule_contents is None and not opts.urn:
                raise TypeError("Missing required property 'rule_contents'")
            __props__.__dict__["rule_contents"] = rule_contents
            __props__.__dict__["rule_desc"] = rule_desc
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
            if rule_type is None and not opts.urn:
                raise TypeError("Missing required property 'rule_type'")
            __props__.__dict__["rule_type"] = rule_type
        super(AutoGroupingRule, __self__).__init__(
            'alicloud:resourcemanager/autoGroupingRule:AutoGroupingRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            exclude_region_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_resource_group_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_resource_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_resource_types_scope: Optional[pulumi.Input[_builtins.str]] = None,
            region_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
            resource_ids_scope: Optional[pulumi.Input[_builtins.str]] = None,
            resource_types_scope: Optional[pulumi.Input[_builtins.str]] = None,
            rule_contents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutoGroupingRuleRuleContentArgs', 'AutoGroupingRuleRuleContentArgsDict']]]]] = None,
            rule_desc: Optional[pulumi.Input[_builtins.str]] = None,
            rule_name: Optional[pulumi.Input[_builtins.str]] = None,
            rule_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'AutoGroupingRule':
        """
        Get an existing AutoGroupingRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] exclude_region_ids_scope: The IDs of regions to be excluded. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] exclude_resource_group_ids_scope: The IDs of resource groups to be excluded. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] exclude_resource_ids_scope: The IDs of resources to be excluded. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] exclude_resource_types_scope: The resource types to be excluded. Separate multiple resource types with commas (,).
        :param pulumi.Input[_builtins.str] region_ids_scope: The IDs of regions. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] resource_group_ids_scope: The IDs of resource groups. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] resource_ids_scope: The IDs of resources. Separate multiple IDs with commas (,).
        :param pulumi.Input[_builtins.str] resource_types_scope: The resource types. Separate multiple resource types with commas (,).
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutoGroupingRuleRuleContentArgs', 'AutoGroupingRuleRuleContentArgsDict']]]] rule_contents: The content records of the rule. See `rule_contents` below.
        :param pulumi.Input[_builtins.str] rule_desc: The description of the rule.
        :param pulumi.Input[_builtins.str] rule_name: The name of the rule.
        :param pulumi.Input[_builtins.str] rule_type: The type of the rule. Valid values:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutoGroupingRuleState.__new__(_AutoGroupingRuleState)

        __props__.__dict__["exclude_region_ids_scope"] = exclude_region_ids_scope
        __props__.__dict__["exclude_resource_group_ids_scope"] = exclude_resource_group_ids_scope
        __props__.__dict__["exclude_resource_ids_scope"] = exclude_resource_ids_scope
        __props__.__dict__["exclude_resource_types_scope"] = exclude_resource_types_scope
        __props__.__dict__["region_ids_scope"] = region_ids_scope
        __props__.__dict__["resource_group_ids_scope"] = resource_group_ids_scope
        __props__.__dict__["resource_ids_scope"] = resource_ids_scope
        __props__.__dict__["resource_types_scope"] = resource_types_scope
        __props__.__dict__["rule_contents"] = rule_contents
        __props__.__dict__["rule_desc"] = rule_desc
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["rule_type"] = rule_type
        return AutoGroupingRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="excludeRegionIdsScope")
    def exclude_region_ids_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IDs of regions to be excluded. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "exclude_region_ids_scope")

    @_builtins.property
    @pulumi.getter(name="excludeResourceGroupIdsScope")
    def exclude_resource_group_ids_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IDs of resource groups to be excluded. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "exclude_resource_group_ids_scope")

    @_builtins.property
    @pulumi.getter(name="excludeResourceIdsScope")
    def exclude_resource_ids_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IDs of resources to be excluded. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "exclude_resource_ids_scope")

    @_builtins.property
    @pulumi.getter(name="excludeResourceTypesScope")
    def exclude_resource_types_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource types to be excluded. Separate multiple resource types with commas (,).
        """
        return pulumi.get(self, "exclude_resource_types_scope")

    @_builtins.property
    @pulumi.getter(name="regionIdsScope")
    def region_ids_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IDs of regions. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "region_ids_scope")

    @_builtins.property
    @pulumi.getter(name="resourceGroupIdsScope")
    def resource_group_ids_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IDs of resource groups. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "resource_group_ids_scope")

    @_builtins.property
    @pulumi.getter(name="resourceIdsScope")
    def resource_ids_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IDs of resources. Separate multiple IDs with commas (,).
        """
        return pulumi.get(self, "resource_ids_scope")

    @_builtins.property
    @pulumi.getter(name="resourceTypesScope")
    def resource_types_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource types. Separate multiple resource types with commas (,).
        """
        return pulumi.get(self, "resource_types_scope")

    @_builtins.property
    @pulumi.getter(name="ruleContents")
    def rule_contents(self) -> pulumi.Output[Sequence['outputs.AutoGroupingRuleRuleContent']]:
        """
        The content records of the rule. See `rule_contents` below.
        """
        return pulumi.get(self, "rule_contents")

    @_builtins.property
    @pulumi.getter(name="ruleDesc")
    def rule_desc(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "rule_desc")

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the rule. Valid values:
        """
        return pulumi.get(self, "rule_type")

