# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSharedTargetsResult',
    'AwaitableGetSharedTargetsResult',
    'get_shared_targets',
    'get_shared_targets_output',
]

@pulumi.output_type
class GetSharedTargetsResult:
    """
    A collection of values returned by getSharedTargets.
    """
    def __init__(__self__, id=None, ids=None, output_file=None, resource_share_id=None, status=None, targets=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resource_share_id and not isinstance(resource_share_id, str):
            raise TypeError("Expected argument 'resource_share_id' to be a str")
        pulumi.set(__self__, "resource_share_id", resource_share_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if targets and not isinstance(targets, list):
            raise TypeError("Expected argument 'targets' to be a list")
        pulumi.set(__self__, "targets", targets)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="resourceShareId")
    def resource_share_id(self) -> Optional[_builtins.str]:
        """
        The resource shared ID of resource manager.
        """
        return pulumi.get(self, "resource_share_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of shared target.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetSharedTargetsTargetResult']:
        """
        A list of Resource Manager Shared Targets. Each element contains the following attributes:
        """
        return pulumi.get(self, "targets")


class AwaitableGetSharedTargetsResult(GetSharedTargetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSharedTargetsResult(
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            resource_share_id=self.resource_share_id,
            status=self.status,
            targets=self.targets)


def get_shared_targets(ids: Optional[Sequence[_builtins.str]] = None,
                       output_file: Optional[_builtins.str] = None,
                       resource_share_id: Optional[_builtins.str] = None,
                       status: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSharedTargetsResult:
    """
    This data source provides the Resource Manager Shared Targets of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.111.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "tf-example"
    default = alicloud.resourcemanager.get_accounts()
    default_resource_share = alicloud.resourcemanager.ResourceShare("default", resource_share_name=name)
    default_shared_target = alicloud.resourcemanager.SharedTarget("default",
        resource_share_id=default_resource_share.id,
        target_id=default.ids[0])
    ids = alicloud.resourcemanager.get_shared_targets_output(ids=[default_shared_target.target_id])
    pulumi.export("firstResourceManagerSharedTargetId", ids.targets[0].id)
    resource_share_id = alicloud.resourcemanager.get_shared_targets_output(resource_share_id=default_shared_target.resource_share_id)
    pulumi.export("secondResourceManagerSharedTargetId", resource_share_id.targets[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Shared Target IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_share_id: The resource share ID of resource manager.
    :param _builtins.str status: The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['resourceShareId'] = resource_share_id
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:resourcemanager/getSharedTargets:getSharedTargets', __args__, opts=opts, typ=GetSharedTargetsResult).value

    return AwaitableGetSharedTargetsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resource_share_id=pulumi.get(__ret__, 'resource_share_id'),
        status=pulumi.get(__ret__, 'status'),
        targets=pulumi.get(__ret__, 'targets'))
def get_shared_targets_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                              output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              resource_share_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSharedTargetsResult]:
    """
    This data source provides the Resource Manager Shared Targets of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.111.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "tf-example"
    default = alicloud.resourcemanager.get_accounts()
    default_resource_share = alicloud.resourcemanager.ResourceShare("default", resource_share_name=name)
    default_shared_target = alicloud.resourcemanager.SharedTarget("default",
        resource_share_id=default_resource_share.id,
        target_id=default.ids[0])
    ids = alicloud.resourcemanager.get_shared_targets_output(ids=[default_shared_target.target_id])
    pulumi.export("firstResourceManagerSharedTargetId", ids.targets[0].id)
    resource_share_id = alicloud.resourcemanager.get_shared_targets_output(resource_share_id=default_shared_target.resource_share_id)
    pulumi.export("secondResourceManagerSharedTargetId", resource_share_id.targets[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Shared Target IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_share_id: The resource share ID of resource manager.
    :param _builtins.str status: The status of share resource. Valid values: `Associated`, `Associating`, `Disassociated`, `Disassociating` and `Failed`.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['resourceShareId'] = resource_share_id
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:resourcemanager/getSharedTargets:getSharedTargets', __args__, opts=opts, typ=GetSharedTargetsResult)
    return __ret__.apply(lambda __response__: GetSharedTargetsResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        output_file=pulumi.get(__response__, 'output_file'),
        resource_share_id=pulumi.get(__response__, 'resource_share_id'),
        status=pulumi.get(__response__, 'status'),
        targets=pulumi.get(__response__, 'targets')))
