# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PolicyVersionArgs', 'PolicyVersion']

@pulumi.input_type
class PolicyVersionArgs:
    def __init__(__self__, *,
                 policy_document: pulumi.Input[_builtins.str],
                 policy_name: pulumi.Input[_builtins.str],
                 is_default_version: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a PolicyVersion resource.
        :param pulumi.Input[_builtins.str] policy_document: The content of the policy. The content must be 1 to 2,048 characters in length.
        :param pulumi.Input[_builtins.str] policy_name: The name of the policy. Name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
        :param pulumi.Input[_builtins.bool] is_default_version: Specifies whether to set the policy version as the default version. Default to `false`.
        """
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "policy_name", policy_name)
        if is_default_version is not None:
            warnings.warn("""Field 'is_default_version' has been deprecated from provider version 1.90.0""", DeprecationWarning)
            pulumi.log.warn("""is_default_version is deprecated: Field 'is_default_version' has been deprecated from provider version 1.90.0""")
        if is_default_version is not None:
            pulumi.set(__self__, "is_default_version", is_default_version)

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Input[_builtins.str]:
        """
        The content of the policy. The content must be 1 to 2,048 characters in length.
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_document", value)

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the policy. Name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_name", value)

    @_builtins.property
    @pulumi.getter(name="isDefaultVersion")
    @_utilities.deprecated("""Field 'is_default_version' has been deprecated from provider version 1.90.0""")
    def is_default_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to set the policy version as the default version. Default to `false`.
        """
        return pulumi.get(self, "is_default_version")

    @is_default_version.setter
    def is_default_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default_version", value)


@pulumi.input_type
class _PolicyVersionState:
    def __init__(__self__, *,
                 is_default_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PolicyVersion resources.
        :param pulumi.Input[_builtins.bool] is_default_version: Specifies whether to set the policy version as the default version. Default to `false`.
        :param pulumi.Input[_builtins.str] policy_document: The content of the policy. The content must be 1 to 2,048 characters in length.
        :param pulumi.Input[_builtins.str] policy_name: The name of the policy. Name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
        """
        if is_default_version is not None:
            warnings.warn("""Field 'is_default_version' has been deprecated from provider version 1.90.0""", DeprecationWarning)
            pulumi.log.warn("""is_default_version is deprecated: Field 'is_default_version' has been deprecated from provider version 1.90.0""")
        if is_default_version is not None:
            pulumi.set(__self__, "is_default_version", is_default_version)
        if policy_document is not None:
            pulumi.set(__self__, "policy_document", policy_document)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)

    @_builtins.property
    @pulumi.getter(name="isDefaultVersion")
    @_utilities.deprecated("""Field 'is_default_version' has been deprecated from provider version 1.90.0""")
    def is_default_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to set the policy version as the default version. Default to `false`.
        """
        return pulumi.get(self, "is_default_version")

    @is_default_version.setter
    def is_default_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default_version", value)

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the policy. The content must be 1 to 2,048 characters in length.
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_document", value)

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the policy. Name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_name", value)


@pulumi.type_token("alicloud:resourcemanager/policyVersion:PolicyVersion")
class PolicyVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_default_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Resource Manager Policy Version resource.
        For information about Resource Manager Policy Version and how to use it, see [What is Resource Manager Policy Version](https://www.alibabacloud.com/help/en/doc-detail/116817.htm).

        > **NOTE:** Available since v1.84.0.

        > **NOTE:** It is not recommended to use this resource management policy version, it is recommended to directly use the policy resource to manage your policy. Please refer to the link for usage resource_manager_policy.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfexample"
        example = alicloud.resourcemanager.Policy("example",
            policy_name=name,
            policy_document=\"\"\"\\t\\t{
        \\t\\t\\t\\"Statement\\": [{
        \\t\\t\\t\\t\\"Action\\": [\\"oss:*\\"],
        \\t\\t\\t\\t\\"Effect\\": \\"Allow\\",
        \\t\\t\\t\\t\\"Resource\\": [\\"acs:oss:*:*:*\\"]
        \\t\\t\\t}],
        \\t\\t\\t\\"Version\\": \\"1\\"
        \\t\\t}
        \"\"\")
        example_policy_version = alicloud.resourcemanager.PolicyVersion("example",
            policy_name=example.policy_name,
            policy_document=\"\"\"\\t\\t{
        \\t\\t\\t\\"Statement\\": [{
        \\t\\t\\t\\t\\"Action\\": [\\"oss:*\\"],
        \\t\\t\\t\\t\\"Effect\\": \\"Allow\\",
        \\t\\t\\t\\t\\"Resource\\": [\\"acs:oss:*:*:myphotos\\"]
        \\t\\t\\t}],
        \\t\\t\\t\\"Version\\": \\"1\\"
        \\t\\t}
        \"\"\")
        ```

        ## Import

        Resource Manager Policy Version can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/policyVersion:PolicyVersion example tftest:v2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] is_default_version: Specifies whether to set the policy version as the default version. Default to `false`.
        :param pulumi.Input[_builtins.str] policy_document: The content of the policy. The content must be 1 to 2,048 characters in length.
        :param pulumi.Input[_builtins.str] policy_name: The name of the policy. Name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Resource Manager Policy Version resource.
        For information about Resource Manager Policy Version and how to use it, see [What is Resource Manager Policy Version](https://www.alibabacloud.com/help/en/doc-detail/116817.htm).

        > **NOTE:** Available since v1.84.0.

        > **NOTE:** It is not recommended to use this resource management policy version, it is recommended to directly use the policy resource to manage your policy. Please refer to the link for usage resource_manager_policy.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfexample"
        example = alicloud.resourcemanager.Policy("example",
            policy_name=name,
            policy_document=\"\"\"\\t\\t{
        \\t\\t\\t\\"Statement\\": [{
        \\t\\t\\t\\t\\"Action\\": [\\"oss:*\\"],
        \\t\\t\\t\\t\\"Effect\\": \\"Allow\\",
        \\t\\t\\t\\t\\"Resource\\": [\\"acs:oss:*:*:*\\"]
        \\t\\t\\t}],
        \\t\\t\\t\\"Version\\": \\"1\\"
        \\t\\t}
        \"\"\")
        example_policy_version = alicloud.resourcemanager.PolicyVersion("example",
            policy_name=example.policy_name,
            policy_document=\"\"\"\\t\\t{
        \\t\\t\\t\\"Statement\\": [{
        \\t\\t\\t\\t\\"Action\\": [\\"oss:*\\"],
        \\t\\t\\t\\t\\"Effect\\": \\"Allow\\",
        \\t\\t\\t\\t\\"Resource\\": [\\"acs:oss:*:*:myphotos\\"]
        \\t\\t\\t}],
        \\t\\t\\t\\"Version\\": \\"1\\"
        \\t\\t}
        \"\"\")
        ```

        ## Import

        Resource Manager Policy Version can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:resourcemanager/policyVersion:PolicyVersion example tftest:v2
        ```

        :param str resource_name: The name of the resource.
        :param PolicyVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_default_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyVersionArgs.__new__(PolicyVersionArgs)

            __props__.__dict__["is_default_version"] = is_default_version
            if policy_document is None and not opts.urn:
                raise TypeError("Missing required property 'policy_document'")
            __props__.__dict__["policy_document"] = policy_document
            if policy_name is None and not opts.urn:
                raise TypeError("Missing required property 'policy_name'")
            __props__.__dict__["policy_name"] = policy_name
        super(PolicyVersion, __self__).__init__(
            'alicloud:resourcemanager/policyVersion:PolicyVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            is_default_version: Optional[pulumi.Input[_builtins.bool]] = None,
            policy_document: Optional[pulumi.Input[_builtins.str]] = None,
            policy_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'PolicyVersion':
        """
        Get an existing PolicyVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] is_default_version: Specifies whether to set the policy version as the default version. Default to `false`.
        :param pulumi.Input[_builtins.str] policy_document: The content of the policy. The content must be 1 to 2,048 characters in length.
        :param pulumi.Input[_builtins.str] policy_name: The name of the policy. Name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyVersionState.__new__(_PolicyVersionState)

        __props__.__dict__["is_default_version"] = is_default_version
        __props__.__dict__["policy_document"] = policy_document
        __props__.__dict__["policy_name"] = policy_name
        return PolicyVersion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="isDefaultVersion")
    @_utilities.deprecated("""Field 'is_default_version' has been deprecated from provider version 1.90.0""")
    def is_default_version(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to set the policy version as the default version. Default to `false`.
        """
        return pulumi.get(self, "is_default_version")

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Output[_builtins.str]:
        """
        The content of the policy. The content must be 1 to 2,048 characters in length.
        """
        return pulumi.get(self, "policy_document")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the policy. Name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
        """
        return pulumi.get(self, "policy_name")

