# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AclArgs', 'Acl']

@pulumi.input_type
class AclArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 decision: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 resource_name: pulumi.Input[_builtins.str],
                 resource_type: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 ip_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Acl resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] actions: The type of operations that can be performed on the resource. Valid values:
               - If `resource_type` is set to `Topic`. Valid values: `Pub`, `Sub`.
               - If `resource_type` is set to `Group`. Valid values: `Sub`.
        :param pulumi.Input[_builtins.str] decision: The decision result of the authorization. Valid values: `Deny`, `Allow`.
        :param pulumi.Input[_builtins.str] instance_id: The instance ID.
        :param pulumi.Input[_builtins.str] resource_name: The name of the resource on which you want to grant permissions.
        :param pulumi.Input[_builtins.str] resource_type: The type of the resource on which you want to grant permissions. Valid values: `Group`, `Topic`.
        :param pulumi.Input[_builtins.str] username: The username of the account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_whitelists: The IP address whitelists.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "decision", decision)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "username", username)
        if ip_whitelists is not None:
            pulumi.set(__self__, "ip_whitelists", ip_whitelists)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The type of operations that can be performed on the resource. Valid values:
        - If `resource_type` is set to `Topic`. Valid values: `Pub`, `Sub`.
        - If `resource_type` is set to `Group`. Valid values: `Sub`.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter
    def decision(self) -> pulumi.Input[_builtins.str]:
        """
        The decision result of the authorization. Valid values: `Deny`, `Allow`.
        """
        return pulumi.get(self, "decision")

    @decision.setter
    def decision(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "decision", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource on which you want to grant permissions.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the resource on which you want to grant permissions. Valid values: `Group`, `Topic`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        The username of the account.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="ipWhitelists")
    def ip_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IP address whitelists.
        """
        return pulumi.get(self, "ip_whitelists")

    @ip_whitelists.setter
    def ip_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_whitelists", value)


@pulumi.input_type
class _AclState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 decision: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Acl resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] actions: The type of operations that can be performed on the resource. Valid values:
               - If `resource_type` is set to `Topic`. Valid values: `Pub`, `Sub`.
               - If `resource_type` is set to `Group`. Valid values: `Sub`.
        :param pulumi.Input[_builtins.str] decision: The decision result of the authorization. Valid values: `Deny`, `Allow`.
        :param pulumi.Input[_builtins.str] instance_id: The instance ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_whitelists: The IP address whitelists.
        :param pulumi.Input[_builtins.str] resource_name: The name of the resource on which you want to grant permissions.
        :param pulumi.Input[_builtins.str] resource_type: The type of the resource on which you want to grant permissions. Valid values: `Group`, `Topic`.
        :param pulumi.Input[_builtins.str] username: The username of the account.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if decision is not None:
            pulumi.set(__self__, "decision", decision)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if ip_whitelists is not None:
            pulumi.set(__self__, "ip_whitelists", ip_whitelists)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The type of operations that can be performed on the resource. Valid values:
        - If `resource_type` is set to `Topic`. Valid values: `Pub`, `Sub`.
        - If `resource_type` is set to `Group`. Valid values: `Sub`.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter
    def decision(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The decision result of the authorization. Valid values: `Deny`, `Allow`.
        """
        return pulumi.get(self, "decision")

    @decision.setter
    def decision(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "decision", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="ipWhitelists")
    def ip_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IP address whitelists.
        """
        return pulumi.get(self, "ip_whitelists")

    @ip_whitelists.setter
    def ip_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_whitelists", value)

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource on which you want to grant permissions.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the resource on which you want to grant permissions. Valid values: `Group`, `Topic`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the account.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("alicloud:rocketmq/acl:Acl")
class Acl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 decision: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_name_: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RocketMQ Acl resource.

        For information about RocketMQ Acl and how to use it, see [What is Acl](https://www.alibabacloud.com/help/en/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/developer-reference/api-rocketmq-2022-08-01-createinstanceacl).

        > **NOTE:** Available since v1.245.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        defaultrq_dt_gm = alicloud.vpc.Network("defaultrqDtGm",
            description="1111",
            cidr_block="192.168.0.0/16",
            vpc_name="pop-example-vpc")
        defaultj_ur_t_ym = alicloud.vpc.Switch("defaultjUrTYm",
            vpc_id=defaultrq_dt_gm.id,
            zone_id="cn-hangzhou-j",
            cidr_block="192.168.0.0/24",
            vswitch_name="pop-example-vswitch")
        default_kjznvm = alicloud.rocketmq.RocketMQInstance("defaultKJZNVM",
            product_info={
                "msg_process_spec": "rmq.p2.4xlarge",
                "send_receive_ratio": 0.3,
                "message_retention_time": 70,
            },
            service_code="rmq",
            series_code="professional",
            payment_type="PayAsYouGo",
            instance_name=name,
            sub_series_code="cluster_ha",
            remark="example",
            network_info={
                "vpc_info": {
                    "vpc_id": defaultrq_dt_gm.id,
                    "vswitches": [{
                        "vswitch_id": defaultj_ur_t_ym.id,
                    }],
                },
                "internet_info": {
                    "internet_spec": "enable",
                    "flow_out_type": "payByBandwidth",
                    "flow_out_bandwidth": 5,
                },
            },
            acl_info={
                "default_vpc_auth_free": False,
                "acl_types": [
                    "default",
                    "apache_acl",
                ],
            })
        default_me_nlxe = alicloud.rocketmq.Account("defaultMeNlxe",
            account_status="ENABLE",
            instance_id=default_kjznvm.id,
            username="tfexample",
            password="123456")
        default_va0zog = alicloud.rocketmq.RocketMQTopic("defaultVA0zog",
            instance_id=default_kjznvm.id,
            message_type="NORMAL",
            topic_name="tfexample")
        default = alicloud.rocketmq.Acl("default",
            actions=[
                "Pub",
                "Sub",
            ],
            instance_id=default_kjznvm.id,
            username=default_me_nlxe.username,
            resource_name_=default_va0zog.topic_name,
            resource_type="Topic",
            decision="Deny",
            ip_whitelists=["192.168.5.5"])
        ```

        ## Import

        RocketMQ Acl can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rocketmq/acl:Acl example <instance_id>:<username>:<resource_type>:<resource_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] actions: The type of operations that can be performed on the resource. Valid values:
               - If `resource_type` is set to `Topic`. Valid values: `Pub`, `Sub`.
               - If `resource_type` is set to `Group`. Valid values: `Sub`.
        :param pulumi.Input[_builtins.str] decision: The decision result of the authorization. Valid values: `Deny`, `Allow`.
        :param pulumi.Input[_builtins.str] instance_id: The instance ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_whitelists: The IP address whitelists.
        :param pulumi.Input[_builtins.str] resource_name_: The name of the resource on which you want to grant permissions.
        :param pulumi.Input[_builtins.str] resource_type: The type of the resource on which you want to grant permissions. Valid values: `Group`, `Topic`.
        :param pulumi.Input[_builtins.str] username: The username of the account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RocketMQ Acl resource.

        For information about RocketMQ Acl and how to use it, see [What is Acl](https://www.alibabacloud.com/help/en/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/developer-reference/api-rocketmq-2022-08-01-createinstanceacl).

        > **NOTE:** Available since v1.245.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        defaultrq_dt_gm = alicloud.vpc.Network("defaultrqDtGm",
            description="1111",
            cidr_block="192.168.0.0/16",
            vpc_name="pop-example-vpc")
        defaultj_ur_t_ym = alicloud.vpc.Switch("defaultjUrTYm",
            vpc_id=defaultrq_dt_gm.id,
            zone_id="cn-hangzhou-j",
            cidr_block="192.168.0.0/24",
            vswitch_name="pop-example-vswitch")
        default_kjznvm = alicloud.rocketmq.RocketMQInstance("defaultKJZNVM",
            product_info={
                "msg_process_spec": "rmq.p2.4xlarge",
                "send_receive_ratio": 0.3,
                "message_retention_time": 70,
            },
            service_code="rmq",
            series_code="professional",
            payment_type="PayAsYouGo",
            instance_name=name,
            sub_series_code="cluster_ha",
            remark="example",
            network_info={
                "vpc_info": {
                    "vpc_id": defaultrq_dt_gm.id,
                    "vswitches": [{
                        "vswitch_id": defaultj_ur_t_ym.id,
                    }],
                },
                "internet_info": {
                    "internet_spec": "enable",
                    "flow_out_type": "payByBandwidth",
                    "flow_out_bandwidth": 5,
                },
            },
            acl_info={
                "default_vpc_auth_free": False,
                "acl_types": [
                    "default",
                    "apache_acl",
                ],
            })
        default_me_nlxe = alicloud.rocketmq.Account("defaultMeNlxe",
            account_status="ENABLE",
            instance_id=default_kjznvm.id,
            username="tfexample",
            password="123456")
        default_va0zog = alicloud.rocketmq.RocketMQTopic("defaultVA0zog",
            instance_id=default_kjznvm.id,
            message_type="NORMAL",
            topic_name="tfexample")
        default = alicloud.rocketmq.Acl("default",
            actions=[
                "Pub",
                "Sub",
            ],
            instance_id=default_kjznvm.id,
            username=default_me_nlxe.username,
            resource_name_=default_va0zog.topic_name,
            resource_type="Topic",
            decision="Deny",
            ip_whitelists=["192.168.5.5"])
        ```

        ## Import

        RocketMQ Acl can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:rocketmq/acl:Acl example <instance_id>:<username>:<resource_type>:<resource_name>
        ```

        :param str resource_name: The name of the resource.
        :param AclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 decision: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_name_: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclArgs.__new__(AclArgs)

            if actions is None and not opts.urn:
                raise TypeError("Missing required property 'actions'")
            __props__.__dict__["actions"] = actions
            if decision is None and not opts.urn:
                raise TypeError("Missing required property 'decision'")
            __props__.__dict__["decision"] = decision
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["ip_whitelists"] = ip_whitelists
            if resource_name_ is None and not opts.urn:
                raise TypeError("Missing required property 'resource_name_'")
            __props__.__dict__["resource_name"] = resource_name_
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        super(Acl, __self__).__init__(
            'alicloud:rocketmq/acl:Acl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            decision: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            ip_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_name_: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'Acl':
        """
        Get an existing Acl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] actions: The type of operations that can be performed on the resource. Valid values:
               - If `resource_type` is set to `Topic`. Valid values: `Pub`, `Sub`.
               - If `resource_type` is set to `Group`. Valid values: `Sub`.
        :param pulumi.Input[_builtins.str] decision: The decision result of the authorization. Valid values: `Deny`, `Allow`.
        :param pulumi.Input[_builtins.str] instance_id: The instance ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_whitelists: The IP address whitelists.
        :param pulumi.Input[_builtins.str] resource_name_: The name of the resource on which you want to grant permissions.
        :param pulumi.Input[_builtins.str] resource_type: The type of the resource on which you want to grant permissions. Valid values: `Group`, `Topic`.
        :param pulumi.Input[_builtins.str] username: The username of the account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclState.__new__(_AclState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["decision"] = decision
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["ip_whitelists"] = ip_whitelists
        __props__.__dict__["resource_name"] = resource_name_
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["username"] = username
        return Acl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The type of operations that can be performed on the resource. Valid values:
        - If `resource_type` is set to `Topic`. Valid values: `Pub`, `Sub`.
        - If `resource_type` is set to `Group`. Valid values: `Sub`.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def decision(self) -> pulumi.Output[_builtins.str]:
        """
        The decision result of the authorization. Valid values: `Deny`, `Allow`.
        """
        return pulumi.get(self, "decision")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="ipWhitelists")
    def ip_whitelists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The IP address whitelists.
        """
        return pulumi.get(self, "ip_whitelists")

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource on which you want to grant permissions.
        """
        return pulumi.get(self, "resource_name")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the resource on which you want to grant permissions. Valid values: `Group`, `Topic`.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The username of the account.
        """
        return pulumi.get(self, "username")

